/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IDynamicReferenceProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ProjectDynamicReferencesTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private static final String PROJECT_0_NAME = "ProjectDynamicReferencesTest_p0";
    private IProject project0;
    private IProject project1;
    private IProject project2;

    @Before
    public void setUp() throws Exception {
        this.project0 = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_0_NAME);
        this.project1 = ResourcesPlugin.getWorkspace().getRoot().getProject("ProjectDynamicReferencesTest_p1");
        this.project2 = ResourcesPlugin.getWorkspace().getRoot().getProject("ProjectDynamicReferencesTest_p2");
        ResourceTestUtil.createInWorkspace((IResource[])new IProject[]{this.project0, this.project1, this.project2});
        ResourceTestUtil.updateProjectDescription(this.project0).addingCommand("org.eclipse.core.tests.resources.dynamicProjectReferenceBuilder").apply();
        ResourceTestUtil.updateProjectDescription(this.project1).addingCommand("org.eclipse.core.tests.resources.dynamicProjectReferenceBuilder").apply();
        ResourceTestUtil.updateProjectDescription(this.project2).addingCommand("org.eclipse.core.tests.resources.dynamicProjectReferenceBuilder").apply();
    }

    @After
    public void tearDown() throws Exception {
        DynamicReferenceProvider.clear();
    }

    @Test
    public void testReferencedProjects() throws CoreException {
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project0.getReferencedProjects()).as("referenced projects of Project0", new Object[0])).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project1.getReferencedProjects()).as("referenced projects of Project1", new Object[0])).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project2.getReferencedProjects()).as("referenced projects of Project2", new Object[0])).isEmpty();
        DynamicReferenceProvider.addReference(this.project0, this.project1);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project0.getReferencedProjects()).as("referenced projects of Project0", new Object[0])).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project1.getReferencedProjects()).as("referenced projects of Project1", new Object[0])).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project2.getReferencedProjects()).as("referenced projects of Project2", new Object[0])).isEmpty();
        this.clearCache();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project0.getReferencedProjects()).as("referenced projects of Project0", new Object[0])).containsExactly((Object[])new IProject[]{this.project1});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project1.getReferencedProjects()).as("referenced projects of Project1", new Object[0])).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project2.getReferencedProjects()).as("referenced projects of Project2", new Object[0])).isEmpty();
        DynamicReferenceProvider.addReference(this.project1, this.project2);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project0.getReferencedProjects()).as("referenced projects of Project0", new Object[0])).containsExactly((Object[])new IProject[]{this.project1});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project1.getReferencedProjects()).as("referenced projects of Project1", new Object[0])).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project2.getReferencedProjects()).as("referenced projects of Project2", new Object[0])).isEmpty();
        this.clearCache();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project0.getReferencedProjects()).as("referenced projects of Project0", new Object[0])).containsExactly((Object[])new IProject[]{this.project1});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project1.getReferencedProjects()).as("referenced projects of Project1", new Object[0])).containsExactly((Object[])new IProject[]{this.project2});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project2.getReferencedProjects()).as("referenced projects of Project2", new Object[0])).isEmpty();
        DynamicReferenceProvider.addReference(this.project0, this.project2);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project0.getReferencedProjects()).as("referenced projects of Project0", new Object[0])).containsExactly((Object[])new IProject[]{this.project1});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project1.getReferencedProjects()).as("referenced projects of Project1", new Object[0])).containsExactly((Object[])new IProject[]{this.project2});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project2.getReferencedProjects()).as("referenced projects of Project2", new Object[0])).isEmpty();
        this.clearCache();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project0.getReferencedProjects()).as("referenced projects of Project0", new Object[0])).containsExactly((Object[])new IProject[]{this.project1, this.project2});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project1.getReferencedProjects()).as("referenced projects of Project1", new Object[0])).containsExactly((Object[])new IProject[]{this.project2});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project2.getReferencedProjects()).as("referenced projects of Project2", new Object[0])).isEmpty();
    }

    @Test
    public void testReferencedBuildConfigs() throws CoreException {
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project0.getReferencedBuildConfigs("", false)).as("referenced build configs of Project0", new Object[0])).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project1.getReferencedBuildConfigs("", false)).as("referenced build configs of Project1", new Object[0])).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project2.getReferencedBuildConfigs("", false)).as("referenced build configs of Project2", new Object[0])).isEmpty();
        DynamicReferenceProvider.addReference(this.project0, this.project1);
        DynamicReferenceProvider.addReference(this.project1, this.project2);
        DynamicReferenceProvider.addReference(this.project0, this.project2);
        this.clearCache();
        IBuildConfiguration buildConfigProject1 = this.project1.getBuildConfig("");
        IBuildConfiguration buildConfigProject2 = this.project2.getBuildConfig("");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project0.getReferencedBuildConfigs("", false)).as("referenced build configs of Project0", new Object[0])).containsExactly((Object[])new IBuildConfiguration[]{buildConfigProject1, buildConfigProject2});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project1.getReferencedBuildConfigs("", false)).as("referenced build configs of Project1", new Object[0])).containsExactly((Object[])new IBuildConfiguration[]{buildConfigProject2});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project2.getReferencedBuildConfigs("", false)).as("referenced build configs of Project2", new Object[0])).isEmpty();
    }

    @Test
    public void testReferencingProjects() throws CoreException {
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project0.getReferencingProjects()).as("referencing projects of Project0", new Object[0])).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project1.getReferencingProjects()).as("referencing projects of Project1", new Object[0])).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project2.getReferencingProjects()).as("referencing projects of Project2", new Object[0])).isEmpty();
        DynamicReferenceProvider.addReference(this.project0, this.project1);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project0.getReferencingProjects()).as("referencing projects of Project0", new Object[0])).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project1.getReferencingProjects()).as("referencing projects of Project1", new Object[0])).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project2.getReferencingProjects()).as("referencing projects of Project2", new Object[0])).isEmpty();
        this.clearCache();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project0.getReferencingProjects()).as("referencing projects of Project0", new Object[0])).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project1.getReferencingProjects()).as("referencing projects of Project1", new Object[0])).containsExactly((Object[])new IProject[]{this.project0});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project2.getReferencingProjects()).as("referencing projects of Project2", new Object[0])).isEmpty();
        DynamicReferenceProvider.addReference(this.project1, this.project2);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project0.getReferencingProjects()).as("referencing projects of Project0", new Object[0])).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project1.getReferencingProjects()).as("referencing projects of Project1", new Object[0])).containsExactly((Object[])new IProject[]{this.project0});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project2.getReferencingProjects()).as("referencing projects of Project2", new Object[0])).isEmpty();
        this.clearCache();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project0.getReferencingProjects()).as("referencing projects of Project0", new Object[0])).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project1.getReferencingProjects()).as("referencing projects of Project2", new Object[0])).containsExactly((Object[])new IProject[]{this.project0});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project2.getReferencingProjects()).as("referencing projects of Project2", new Object[0])).containsExactly((Object[])new IProject[]{this.project1});
        DynamicReferenceProvider.addReference(this.project0, this.project2);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project0.getReferencingProjects()).as("referencing projects of Project0", new Object[0])).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project1.getReferencingProjects()).as("referencing projects of Project1", new Object[0])).containsExactly((Object[])new IProject[]{this.project0});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project2.getReferencingProjects()).as("referencing projects of Project2", new Object[0])).containsExactly((Object[])new IProject[]{this.project1});
        this.clearCache();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project0.getReferencingProjects()).as("referencing projects of Project0", new Object[0])).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project1.getReferencingProjects()).as("referencing projects of Project1", new Object[0])).containsExactly((Object[])new IProject[]{this.project0});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project2.getReferencingProjects()).as("referencing projects of Project2", new Object[0])).containsExactly((Object[])new IProject[]{this.project0, this.project1});
    }

    @Test
    public void testComputeProjectOrder() throws CoreException {
        IProject[] allProjects = new IProject[]{this.project0, this.project1, this.project2};
        IWorkspace.ProjectOrder projectOrder = ResourcesPlugin.getWorkspace().computeProjectOrder(allProjects);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])projectOrder.projects).as("build order", new Object[0])).isEqualTo((Object)allProjects);
        Assertions.assertThat((Object)projectOrder).matches(it -> !it.hasCycles, "does not have cycles");
        DynamicReferenceProvider.addReference(this.project0, this.project1);
        DynamicReferenceProvider.addReference(this.project1, this.project2);
        this.clearCache();
        projectOrder = ResourcesPlugin.getWorkspace().computeProjectOrder(allProjects);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])projectOrder.projects).as("build order", new Object[0])).containsExactly((Object[])new IProject[]{this.project2, this.project1, this.project0});
        Assertions.assertThat((Object)projectOrder).matches(it -> !it.hasCycles, "does not have cycles");
        DynamicReferenceProvider.clear();
        DynamicReferenceProvider.addReference(this.project1, this.project0);
        DynamicReferenceProvider.addReference(this.project0, this.project2);
        this.clearCache();
        projectOrder = ResourcesPlugin.getWorkspace().computeProjectOrder(allProjects);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])projectOrder.projects).as("build order", new Object[0])).containsExactly((Object[])new IProject[]{this.project2, this.project0, this.project1});
        Assertions.assertThat((Object)projectOrder).matches(it -> !it.hasCycles, "does not have cycles");
    }

    @Test
    public void testBug543776() throws Exception {
        IFile projectFile = this.project0.getFile(".project");
        String projectDescription = ResourceTestUtil.readStringInFileSystem(projectFile);
        projectDescription = projectDescription.replace(PROJECT_0_NAME, "anotherName");
        ResourceTestUtil.createInWorkspace(projectFile, projectDescription);
        this.project0.delete(false, true, null);
        this.project0.create(null);
        this.project0.open(null);
        Assertions.assertThat((String)this.project0.getName()).isEqualTo(PROJECT_0_NAME);
        Assertions.assertThat((String)this.project0.getDescription().getName()).isEqualTo("anotherName");
        DynamicReferenceProvider.addReference(this.project0, this.project1);
        this.clearCache();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.project0.getReferencedProjects()).as("referenced projects of Project0", new Object[0])).containsExactly((Object[])new IProject[]{this.project1});
    }

    private void clearCache() {
        this.project0.clearCachedDynamicReferences();
        this.project1.clearCachedDynamicReferences();
        this.project2.clearCachedDynamicReferences();
    }

    public static final class Builder
    extends IncrementalProjectBuilder {
        public static final String NAME = "org.eclipse.core.tests.resources.dynamicProjectReferenceBuilder";

        protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
            return null;
        }
    }

    public static final class DynamicReferenceProvider
    implements IDynamicReferenceProvider {
        private static final Map<IProject, List<IProject>> dependentProjects = new HashMap<IProject, List<IProject>>();

        public List<IProject> getDependentProjects(IBuildConfiguration buildConfiguration) throws CoreException {
            IProject project = buildConfiguration.getProject();
            List<IProject> depProjects = dependentProjects.get(project);
            if (depProjects != null) {
                return depProjects;
            }
            return Collections.emptyList();
        }

        public static void addReference(IProject project, IProject dependentProject) {
            List depProjects = dependentProjects.computeIfAbsent(project, proj -> new ArrayList());
            depProjects.add(dependentProject);
        }

        public static void clear() {
            dependentProjects.clear();
        }
    }
}

