/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.resources;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.resources.ProjectPreferences;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProjectPreferencesTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private static final String DIR_NAME = ".settings";
    private static final String FILE_EXTENSION = "prefs";

    @Test
    public void testSimple() throws CoreException {
        IProject project = ProjectPreferencesTest.getProject("foo");
        String qualifier = "org.eclipse.core.tests.resources";
        String key = "key" + ResourceTestUtil.createUniqueString();
        String instanceValue = "instance" + ResourceTestUtil.createUniqueString();
        String projectValue = "project" + ResourceTestUtil.createUniqueString();
        ProjectScope projectContext = new ProjectScope(project);
        IScopeContext instanceContext = InstanceScope.INSTANCE;
        ResourceTestUtil.createInWorkspace((IResource)project);
        ArrayList<IScopeContext[]> list = new ArrayList<IScopeContext[]>();
        list.add(null);
        list.add(new IScopeContext[0]);
        list.add(new IScopeContext[1]);
        IScopeContext[][] contextsWithoutScope = (IScopeContext[][])list.toArray((T[])new IScopeContext[list.size()][]);
        list = new ArrayList();
        list.add(new IScopeContext[]{projectContext});
        IScopeContext[] iScopeContextArray = new IScopeContext[2];
        iScopeContextArray[1] = projectContext;
        list.add(iScopeContextArray);
        IScopeContext[][] contextsWithScope = (IScopeContext[][])list.toArray((T[])new IScopeContext[list.size()][]);
        IPreferencesService service = Platform.getPreferencesService();
        IEclipsePreferences node = instanceContext.getNode(qualifier);
        node.put(key, instanceValue);
        String actual = node.get(key, null);
        Assert.assertNotNull((String)"1.0", (Object)actual);
        Assert.assertEquals((String)"1.1", (Object)instanceValue, (Object)actual);
        int i = 0;
        while (i < contextsWithoutScope.length) {
            actual = service.getString(qualifier, key, null, contextsWithoutScope[i]);
            Assert.assertNotNull((String)("2.0." + i), (Object)actual);
            Assert.assertEquals((String)("2.1." + i), (Object)instanceValue, (Object)actual);
            ++i;
        }
        i = 0;
        while (i < contextsWithScope.length) {
            actual = service.getString(qualifier, key, null, contextsWithScope[i]);
            Assert.assertNotNull((String)("2.2." + i), (Object)actual);
            Assert.assertEquals((String)("2.3." + i), (Object)instanceValue, (Object)actual);
            ++i;
        }
        node = projectContext.getNode(qualifier);
        node.put(key, projectValue);
        actual = node.get(key, null);
        Assert.assertNotNull((String)"3.0", (Object)actual);
        Assert.assertEquals((String)"3.1", (Object)projectValue, (Object)actual);
        i = 0;
        while (i < contextsWithoutScope.length) {
            actual = service.getString(qualifier, key, null, contextsWithoutScope[i]);
            Assert.assertNotNull((String)("4.0." + i), (Object)actual);
            Assert.assertEquals((String)("4.1." + i), (Object)instanceValue, (Object)actual);
            ++i;
        }
        i = 0;
        while (i < contextsWithScope.length) {
            actual = service.getString(qualifier, key, null, contextsWithScope[i]);
            Assert.assertNotNull((String)("4.2." + i), (Object)actual);
            Assert.assertEquals((String)("4.3." + i), (Object)projectValue, (Object)actual);
            ++i;
        }
        node = projectContext.getNode(qualifier);
        node.remove(key);
        actual = node.get(key, null);
        Assert.assertNull((String)"5.0", (Object)actual);
        i = 0;
        while (i < contextsWithoutScope.length) {
            actual = service.getString(qualifier, key, null, contextsWithoutScope[i]);
            Assert.assertNotNull((String)("6.0." + i), (Object)actual);
            Assert.assertEquals((String)("6.1." + i), (Object)instanceValue, (Object)actual);
            ++i;
        }
        i = 0;
        while (i < contextsWithScope.length) {
            actual = service.getString(qualifier, key, null, contextsWithScope[i]);
            Assert.assertNotNull((String)("6.2." + i), (Object)actual);
            Assert.assertEquals((String)("6.3." + i), (Object)instanceValue, (Object)actual);
            ++i;
        }
        node = instanceContext.getNode(qualifier);
        node.remove(key);
        actual = node.get(key, null);
        i = 0;
        while (i < contextsWithoutScope.length) {
            actual = service.getString(qualifier, key, null, contextsWithoutScope[i]);
            Assert.assertNull((String)("7.0." + i), (Object)actual);
            ++i;
        }
        i = 0;
        while (i < contextsWithScope.length) {
            actual = service.getString(qualifier, key, null, contextsWithScope[i]);
            Assert.assertNull((String)("7.1." + i), (Object)actual);
            ++i;
        }
    }

    @Test
    public void testListener() throws Exception {
        Object reader;
        IProject project = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        String qualifier = "org.eclipse.core.tests.resources";
        String key = "key" + ResourceTestUtil.createUniqueString();
        String value = "value" + ResourceTestUtil.createUniqueString();
        ProjectScope projectContext = new ProjectScope(project);
        ResourceTestUtil.createInWorkspace((IResource)project);
        IEclipsePreferences node = projectContext.getNode(qualifier);
        node.put(key, value);
        String actual = node.get(key, null);
        Assert.assertNotNull((String)"1.0", (Object)actual);
        Assert.assertEquals((String)"1.1", (Object)value, (Object)actual);
        node.flush();
        File file = ProjectPreferencesTest.getFileInFilesystem(project, qualifier);
        Properties props = new Properties();
        Throwable throwable = null;
        Object var11_12 = null;
        try {
            reader = Files.newBufferedReader(file.toPath());
            try {
                props.load((Reader)reader);
            }
            finally {
                if (reader != null) {
                    ((BufferedReader)reader).close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String newKey = "newKey" + ResourceTestUtil.createUniqueString();
        String newValue = "newValue" + ResourceTestUtil.createUniqueString();
        props.put(newKey, newValue);
        reader = null;
        Object var13_16 = null;
        try (FileOutputStream fileOutput = new FileOutputStream(file);){
            Throwable throwable3 = null;
            Object var16_21 = null;
            try (BufferedOutputStream output = new BufferedOutputStream(fileOutput);){
                props.store(output, null);
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
        }
        catch (Throwable throwable5) {
            if (reader == null) {
                reader = throwable5;
            } else if (reader != throwable5) {
                ((Throwable)reader).addSuppressed(throwable5);
            }
            throw reader;
        }
        IFile workspaceFile = ProjectPreferencesTest.getFileInWorkspace(project, qualifier);
        ResourceTestUtil.touchInFilesystem((IResource)workspaceFile);
        workspaceFile.refreshLocal(0, ResourceTestUtil.createTestMonitor());
        actual = node.get(key, null);
        Assert.assertEquals((String)"4.1", (Object)value, (Object)actual);
        actual = node.get(newKey, null);
        Assert.assertEquals((String)"4.2", (Object)newValue, (Object)actual);
    }

    @Test
    public void testProjectDelete() throws Exception {
        IProject project = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)project);
        String qualifier = ResourceTestUtil.createUniqueString();
        String key = ResourceTestUtil.createUniqueString();
        String value = ResourceTestUtil.createUniqueString();
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode(qualifier);
        Preferences parent = node.parent().parent();
        node.put(key, value);
        Assert.assertEquals((String)"1.0", (Object)value, (Object)node.get(key, null));
        project.delete(5, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"3.0", (!parent.nodeExists(project.getName()) ? 1 : 0) != 0);
        ResourceTestUtil.createInWorkspace((IResource)project);
        Assert.assertNull((String)"4.0", (Object)context.getNode(qualifier).get(key, null));
    }

    @Test
    public void testProjectMove() throws Exception {
        IProject project1 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        IProject project2 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)project1);
        String qualifier = ResourceTestUtil.createUniqueString();
        String key = ResourceTestUtil.createUniqueString();
        String value = ResourceTestUtil.createUniqueString();
        IEclipsePreferences node = new ProjectScope(project1).getNode(qualifier);
        node.put(key, value);
        node.flush();
        project1.move(IPath.fromOSString((String)project2.getName()), false, null);
        node = Platform.getPreferencesService().getRootNode().node("project");
        Assert.assertNotNull((String)"2.1", (Object)node);
        Assert.assertTrue((String)"2.2", (!node.nodeExists(project1.getName()) ? 1 : 0) != 0);
        node = Platform.getPreferencesService().getRootNode().node("project");
        Assert.assertNotNull((String)"2.3", (Object)node);
        Assert.assertTrue((String)"2.4", (boolean)node.nodeExists(project2.getName()));
        node = node.node(project2.getName());
        Assert.assertNotNull((String)"3.1", (Object)node);
        Assert.assertTrue((String)"3.2", (boolean)node.nodeExists(qualifier));
        node = node.node(qualifier);
        Assert.assertNotNull((String)"4.1", (Object)node);
        Assert.assertEquals((String)"4.2", (Object)value, (Object)node.get(key, null));
    }

    @Test
    public void test_60925() throws Exception {
        IProject project = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)project);
        String qualifier = ResourceTestUtil.createUniqueString();
        IFile file = ProjectPreferencesTest.getFileInWorkspace(project, qualifier);
        Assert.assertTrue((String)"0.0", (!file.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"0.1", (!file.getLocation().toFile().exists() ? 1 : 0) != 0);
        ProjectScope context = new ProjectScope(project);
        String key = ResourceTestUtil.createUniqueString();
        String value = ResourceTestUtil.createUniqueString();
        IEclipsePreferences node = context.getNode(qualifier);
        node.put(key, value);
        node.flush();
        Assert.assertTrue((String)"2.0", (boolean)file.exists());
        Assert.assertTrue((String)"2.1", (boolean)file.isSynchronized(0));
    }

    @Test
    public void test_55410() throws Exception {
        IProject project1 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)project1);
        Preferences node = new ProjectScope(project1).getNode("org.eclipse.core.resources").node("subnode");
        String key1 = ".";
        String key2 = "x";
        String value1 = ResourceTestUtil.createUniqueString();
        String value2 = ResourceTestUtil.createUniqueString();
        node.put(key1, value1);
        node.put(key2, value2);
        Assert.assertEquals((String)"0.8", (Object)value1, (Object)node.get(key1, null));
        Assert.assertEquals((String)"0.9", (Object)value2, (Object)node.get(key2, null));
        IFile prefsFile = ProjectPreferencesTest.getFileInWorkspace(project1, "org.eclipse.core.resources");
        Assert.assertTrue((String)"1.0", (boolean)prefsFile.exists());
        node.flush();
        Assert.assertTrue((String)"1.1", (boolean)prefsFile.exists());
        Properties props = new Properties();
        Throwable throwable = null;
        Object var10_11 = null;
        try (InputStream contents = prefsFile.getContents();){
            props.load(contents);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertEquals((String)"2.0", (Object)value2, (Object)props.getProperty("subnode/" + key2));
        Assert.assertEquals((String)"2.1", (Object)value1, (Object)props.getProperty("subnode/" + key1));
    }

    @Test
    public void test_61277a() throws Exception {
        IProject project = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        IProject destProject = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.removeFromWorkspace((IResource)destProject);
        ProjectScope context = new ProjectScope(project);
        String qualifier = ResourceTestUtil.createUniqueString();
        IEclipsePreferences node = context.getNode(qualifier);
        String key = ResourceTestUtil.createUniqueString();
        String value = ResourceTestUtil.createUniqueString();
        node.put(key, value);
        Assert.assertEquals((String)"1.0", (Object)value, (Object)node.get(key, null));
        node.flush();
        project.move(destProject.getFullPath(), true, ResourceTestUtil.createTestMonitor());
        context = new ProjectScope(destProject);
        node = context.getNode(qualifier);
        Assert.assertEquals((String)"3.0", (Object)value, (Object)node.get(key, null));
    }

    @Test
    public void test_61277b() throws Exception {
        IProject project1 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        IProject project2 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)project1);
        IEclipsePreferences node = new ProjectScope(project1).getNode("org.eclipse.core.resources");
        Assert.assertTrue((String)"1.0", (boolean)ProjectPreferencesTest.getFileInWorkspace(project1, "org.eclipse.core.resources").exists());
        node.put("key", "value");
        node.flush();
        Assert.assertTrue((String)"1.1", (boolean)ProjectPreferencesTest.getFileInWorkspace(project1, "org.eclipse.core.resources").exists());
        project1.move(project2.getFullPath(), false, null);
        Assert.assertTrue((String)"2.0", (boolean)ProjectPreferencesTest.getFileInWorkspace(project2, "org.eclipse.core.resources").exists());
        node = new ProjectScope(project2).getNode("org.eclipse.core.resources");
        Assert.assertEquals((String)"2.1", (Object)"value", (Object)node.get("key", null));
    }

    @Test
    public void test_61277c() throws Exception {
        IProject project1 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)project1);
        Assert.assertTrue((String)"1.0", (boolean)ProjectPreferencesTest.getFileInWorkspace(project1, "org.eclipse.core.resources").exists());
        IEclipsePreferences node = new ProjectScope(project1).getNode("org.eclipse.core.resources");
        String key1 = "key";
        String emptyKey = "";
        String value1 = ResourceTestUtil.createUniqueString();
        String value2 = ResourceTestUtil.createUniqueString();
        node.put(key1, value1);
        node.put(emptyKey, value2);
        node.flush();
        Assert.assertTrue((String)"1.2", (boolean)ProjectPreferencesTest.getFileInWorkspace(project1, "org.eclipse.core.resources").exists());
        IProject project2 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        project1.move(project2.getFullPath(), false, null);
        Assert.assertTrue((String)"2.0", (boolean)ProjectPreferencesTest.getFileInWorkspace(project2, "org.eclipse.core.resources").exists());
        node = new ProjectScope(project2).getNode("org.eclipse.core.resources");
        Assert.assertEquals((String)"2.1", (Object)value1, (Object)node.get(key1, null));
        Assert.assertEquals((String)"2.2", (Object)value2, (Object)node.get(emptyKey, null));
    }

    @Test
    public void test_61843() throws Exception {
        String qualifier = ResourceTestUtil.createUniqueString();
        IProject project = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)project);
        IFile settingsFile = ProjectPreferencesTest.getFileInWorkspace(project, qualifier);
        Properties properties = new Properties();
        properties.put("key", "value");
        File file = settingsFile.getLocation().toFile();
        file.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var7_8 = null;
        try (FileOutputStream fileOutput = new FileOutputStream(file);){
            Throwable throwable2 = null;
            Object var10_14 = null;
            try (BufferedOutputStream output = new BufferedOutputStream(fileOutput);){
                properties.store(output, null);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        ILogListener logListener = (status, plugin) -> {
            void coreException;
            Throwable exception = status.getException();
            if (exception == null || !(exception instanceof CoreException)) {
                return;
            }
            CoreException coreException2 = (CoreException)exception;
            Assertions.assertThat((int)380).isNotEqualTo(coreException.getStatus().getCode());
        };
        IResourceChangeListener rclistener = event -> {
            IEclipsePreferences iEclipsePreferences = new ProjectScope(project).getNode(qualifier);
        };
        try {
            Platform.addLogListener((ILogListener)logListener);
            ResourcesPlugin.getWorkspace().addResourceChangeListener(rclistener, 1);
            project.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        }
        finally {
            Platform.removeLogListener((ILogListener)logListener);
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(rclistener);
        }
    }

    @Test
    public void test_65068() throws Exception {
        IProject project = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)project);
        IEclipsePreferences node = new ProjectScope(project).getNode("org.eclipse.core.resources");
        String key = "key";
        String value = ResourceTestUtil.createUniqueString();
        node.put(key, value);
        node.flush();
        Assert.assertTrue((String)"1.2", (boolean)ProjectPreferencesTest.getFileInWorkspace(project, "org.eclipse.core.resources").exists());
        node = new ProjectScope(project).getNode("org.eclipse.core.resources");
        Assert.assertEquals((String)"1.3", (Object)value, (Object)node.get(key, null));
        ResourceTestUtil.removeFromWorkspace((IResource)project.getFolder(DIR_NAME));
        node = new ProjectScope(project).getNode("org.eclipse.core.resources");
        Assert.assertNull((String)"2.0", (Object)node.get(key, null));
    }

    @Test
    public void test_95052() throws Exception {
        IProject project = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)project);
        IEclipsePreferences node = new ProjectScope(project).getNode("org.eclipse.core.resources");
        node.put("key1", "value1");
        node.put("key2", "value2");
        node.put("key3", "value3");
        node.flush();
        IFile prefFile = ProjectPreferencesTest.getFileInWorkspace(project, "org.eclipse.core.resources");
        Assert.assertTrue((String)"1.2", (boolean)prefFile.exists());
        Properties properties = new Properties();
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream contents = prefFile.getContents();){
            properties.load(contents);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertEquals((String)"2.0", (Object)"value1", (Object)properties.get("key1"));
        Assert.assertEquals((String)"2.1", (Object)"value2", (Object)properties.get("key2"));
        Assert.assertEquals((String)"2.2", (Object)"value3", (Object)properties.get("key3"));
        properties.put("key0", "value0");
        properties.put("key2", "value2".toUpperCase());
        properties.remove("key3");
        ByteArrayOutputStream tempOutput = new ByteArrayOutputStream();
        properties.store(tempOutput, null);
        prefFile.setContents(tempOutput.toByteArray(), false, false, ResourceTestUtil.createTestMonitor());
        node = new ProjectScope(project).getNode("org.eclipse.core.resources");
        Assert.assertEquals((String)"3.0", (Object)"value0", (Object)node.get("key0", null));
        Assert.assertEquals((String)"3.1", (Object)"value1", (Object)node.get("key1", null));
        Assert.assertEquals((String)"3.2", (Object)"value2".toUpperCase(), (Object)node.get("key2", null));
        Assert.assertNull((String)"3.3", (Object)node.get("key3", null));
    }

    @Test
    public void test_579372() throws Exception {
        IProject project = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)project);
        IEclipsePreferences node = new ProjectScope(project).getNode("org.eclipse.core.resources");
        node.put("key1", "value1");
        node.node("child").put("key", "childValue1");
        node.node("child").node("node").put("key", "childValue2");
        node.flush();
        IFile prefFile = ProjectPreferencesTest.getFileInWorkspace(project, "org.eclipse.core.resources");
        Assert.assertTrue((String)"Preferences missing", (boolean)prefFile.exists());
        Properties properties = new Properties();
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream contents = prefFile.getContents();){
            properties.load(contents);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertEquals((Object)"value1", (Object)properties.get("key1"));
        Assert.assertEquals((Object)"childValue1", (Object)properties.get("child/key"));
        Assert.assertEquals((Object)"childValue2", (Object)properties.get("child/node/key"));
        Assert.assertEquals((Object)ResourcesPlugin.getEncoding(), (Object)properties.get("encoding/<project>"));
        properties.put("key0", "value0");
        properties.put("child2/key", "childValue3");
        properties.put("key1", "value2");
        properties.remove("child/key");
        properties.remove("child/node/key");
        properties.remove("encoding/<project>");
        ByteArrayOutputStream tempOutput = new ByteArrayOutputStream();
        properties.store(tempOutput, null);
        prefFile.setContents(tempOutput.toByteArray(), false, false, ResourceTestUtil.createTestMonitor());
        node = new ProjectScope(project).getNode("org.eclipse.core.resources");
        Assert.assertEquals((Object)"value0", (Object)node.get("key0", null));
        Assert.assertEquals((Object)"value2", (Object)node.get("key1", null));
        List<String> children = List.of(node.childrenNames());
        Assert.assertTrue((boolean)children.contains("child"));
        Assert.assertTrue((boolean)children.contains("child2"));
        Assert.assertTrue((boolean)children.contains("encoding"));
        Assert.assertEquals(Arrays.asList("key"), Arrays.asList(node.node("child2").keys()));
        Assert.assertEquals((Object)"childValue3", (Object)node.node("child2").get("key", null));
        Assert.assertEquals(Arrays.asList(new Object[0]), Arrays.asList(node.node("child").keys()));
        Assert.assertEquals(Arrays.asList("node"), Arrays.asList(node.node("child").childrenNames()));
        Assert.assertEquals(Arrays.asList(new Object[0]), Arrays.asList(node.node("child").node("node").keys()));
        Assert.assertEquals(Arrays.asList(new Object[0]), Arrays.asList(node.node("child").node("node").childrenNames()));
        Assert.assertEquals(Arrays.asList(new Object[0]), Arrays.asList(node.node("encoding").keys()));
        Assert.assertEquals(Arrays.asList(new Object[0]), Arrays.asList(node.node("encoding").childrenNames()));
    }

    @Test
    public void test_256900() throws Exception {
        IProject project = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)project);
        IProject project2 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)project2);
        ResourceTestUtil.createInWorkspace((IResource)project2.getFolder(DIR_NAME));
        IEclipsePreferences node = new ProjectScope(project).getNode("org.eclipse.core.resources");
        String key = "key";
        String value = ResourceTestUtil.createUniqueString();
        node.put(key, value);
        node.flush();
        IFile prefFile = ProjectPreferencesTest.getFileInWorkspace(project, "org.eclipse.core.resources");
        Assert.assertTrue((String)"2.0", (boolean)prefFile.exists());
        IEclipsePreferences project2Node = new ProjectScope(project2).getNode("org.eclipse.core.resources");
        Assert.assertNull((String)"3.0", (Object)project2Node.get(key, null));
        ProjectPreferencesTest.getFileInWorkspace(project2, "org.eclipse.core.resources").delete(true, null);
        prefFile.copy(ProjectPreferencesTest.getFileInWorkspace(project2, "org.eclipse.core.resources").getFullPath(), true, null);
        Assert.assertEquals((String)"5.0", (Object)value, (Object)project2Node.get(key, null));
    }

    @Test
    public void test_325000() throws Exception {
        IProject project1 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)project1);
        Preferences node = new ProjectScope(project1).getNode("org.eclipse.core.resources").node("subnode");
        ArrayList<Object> keys = new ArrayList<Object>();
        keys.add("z" + ResourceTestUtil.createUniqueString());
        keys.add("a" + ResourceTestUtil.createUniqueString());
        keys.add("1" + ResourceTestUtil.createUniqueString());
        keys.add("z" + ResourceTestUtil.createUniqueString());
        keys.add("_" + ResourceTestUtil.createUniqueString());
        keys.add(ResourceTestUtil.createUniqueString());
        for (String string : keys) {
            node.put(string, ResourceTestUtil.createUniqueString());
        }
        node.flush();
        IFile iFile = ProjectPreferencesTest.getFileInWorkspace(project1, "org.eclipse.core.resources");
        Object object = null;
        Object throwable = null;
        try (InputStream inputStream = iFile.getContents();){
            Throwable throwable2 = null;
            Object throwable4 = null;
            try (InputStreamReader streamReader = new InputStreamReader(inputStream);){
                Throwable throwable3 = null;
                Object throwable32 = null;
                try (BufferedReader reader = new BufferedReader(streamReader);){
                    String currentLine = null;
                    String prevLine = null;
                    while ((currentLine = reader.readLine()) != null) {
                        boolean isUserProperty = false;
                        for (String string : keys) {
                            if (!currentLine.contains(string)) continue;
                            isUserProperty = true;
                            break;
                        }
                        if (!isUserProperty) continue;
                        if (prevLine == null) {
                            prevLine = currentLine;
                            continue;
                        }
                        if (prevLine.compareTo(currentLine) > 0) {
                            Assert.fail((String)"1.1");
                        }
                        prevLine = currentLine;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable3 == null) {
                        throwable3 = throwable5;
                    } else if (throwable3 != throwable5) {
                        throwable3.addSuppressed(throwable5);
                    }
                    throw throwable3;
                }
            }
            catch (Throwable throwable6) {
                if (throwable2 == null) {
                    throwable2 = throwable6;
                } else if (throwable2 != throwable6) {
                    throwable2.addSuppressed(throwable6);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable7) {
            if (object == null) {
                object = throwable7;
            } else if (object != throwable7) {
                ((Throwable)object).addSuppressed(throwable7);
            }
            throw object;
        }
    }

    @Test
    public void test_335591() throws Exception {
        ArrayList<String> lines;
        String projectName = ResourceTestUtil.createUniqueString();
        String nodeName = "node";
        IProject project = ProjectPreferencesTest.getProject(projectName);
        project.create(ResourceTestUtil.createTestMonitor());
        File folder = new File(project.getLocation().toOSString() + "/.settings");
        folder.mkdir();
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(folder.getPath() + "/" + nodeName + ".prefs"));){
            bw.write("#Fri Jan 28 10:28:45 CET 2011\neclipse.preferences.version=1\nKEY=VALUE");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Preferences projectNode = Platform.getPreferencesService().getRootNode().node("project").node(projectName);
        project.open(ResourceTestUtil.createTestMonitor());
        Preferences node = projectNode.node(nodeName);
        Assert.assertEquals((Object)"VALUE", (Object)node.get("KEY", null));
        node.put("NEW_KEY", "NEW_VALUE");
        node.flush();
        folder = new File(project.getLocation().toOSString() + "/.settings");
        Throwable throwable3 = null;
        Object var9_12 = null;
        try (BufferedReader br = new BufferedReader(new FileReader(folder.getPath() + "/" + nodeName + ".prefs"));){
            lines = new ArrayList<String>();
            String line = br.readLine();
            while (line != null) {
                if (!line.startsWith("#") && !line.startsWith("eclipse.preferences.version")) {
                    lines.add(line);
                }
                line = br.readLine();
            }
        }
        catch (Throwable throwable4) {
            if (throwable3 == null) {
                throwable3 = throwable4;
            } else if (throwable3 != throwable4) {
                throwable3.addSuppressed(throwable4);
            }
            throw throwable3;
        }
        Assert.assertEquals((long)2L, (long)lines.size());
        lines.sort(null);
        Assert.assertTrue((boolean)((String)lines.get(0)).equals("KEY=VALUE"));
        Assert.assertTrue((boolean)((String)lines.get(1)).equals("NEW_KEY=NEW_VALUE"));
        node.sync();
        Assert.assertEquals((Object)"VALUE", (Object)node.get("KEY", null));
        Assert.assertEquals((Object)"NEW_VALUE", (Object)node.get("NEW_KEY", null));
    }

    @Test
    public void test_384151() throws BackingStoreException, CoreException {
        String newProjectValue;
        String newInstanceValue;
        String systemValue = System.lineSeparator();
        if (systemValue.equals("\n")) {
            newInstanceValue = "\r";
            newProjectValue = "\r\n";
        } else if (systemValue.equals("\r")) {
            newInstanceValue = "\n";
            newProjectValue = "\r\n";
        } else {
            newInstanceValue = "\r";
            newProjectValue = "\n";
        }
        IProject project = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)project);
        IEclipsePreferences rootNode = Platform.getPreferencesService().getRootNode();
        Preferences instanceNode = rootNode.node("instance").node("org.eclipse.core.runtime");
        Preferences projectNode = rootNode.node("project").node(project.getName()).node("org.eclipse.core.runtime");
        String oldInstanceValue = instanceNode.get("line.separator", null);
        String oldProjectValue = projectNode.get("line.separator", null);
        String qualifier = "qualifier";
        IFile file = project.getFile(IPath.fromOSString((String)(".settings/" + qualifier + ".prefs")));
        Preferences node = rootNode.node("project").node(project.getName()).node(qualifier);
        String key = "key";
        try {
            node.put(key, ResourceTestUtil.createUniqueString());
            node.flush();
            Assert.assertEquals((String)"1.0", (Object)systemValue, (Object)ResourceTestUtil.getLineSeparatorFromFile(file));
            file.delete(true, ResourceTestUtil.createTestMonitor());
            instanceNode.put("line.separator", newInstanceValue);
            instanceNode.flush();
            node.put(key, ResourceTestUtil.createUniqueString());
            node.flush();
            Assert.assertEquals((String)"2.0", (Object)newInstanceValue, (Object)ResourceTestUtil.getLineSeparatorFromFile(file));
            file.delete(true, ResourceTestUtil.createTestMonitor());
            projectNode.put("line.separator", newProjectValue);
            projectNode.flush();
            node.put(key, ResourceTestUtil.createUniqueString());
            node.flush();
            String recentlyUsedLineSeparator = ResourceTestUtil.getLineSeparatorFromFile(file);
            Assert.assertEquals((String)"3.0", (Object)newProjectValue, (Object)recentlyUsedLineSeparator);
            if (oldInstanceValue == null) {
                instanceNode.remove("line.separator");
            } else {
                instanceNode.put("line.separator", oldInstanceValue);
            }
            if (oldProjectValue == null) {
                projectNode.remove("line.separator");
            } else {
                projectNode.put("line.separator", oldProjectValue);
            }
            instanceNode.flush();
            projectNode.flush();
            node.put(key, ResourceTestUtil.createUniqueString());
            node.flush();
            Assert.assertEquals((String)"4.0", (Object)recentlyUsedLineSeparator, (Object)ResourceTestUtil.getLineSeparatorFromFile(file));
        }
        finally {
            if (oldInstanceValue == null) {
                instanceNode.remove("line.separator");
            } else {
                instanceNode.put("line.separator", oldInstanceValue);
            }
            instanceNode.flush();
        }
    }

    @Test
    public void test_336211() throws BackingStoreException, CoreException, IOException {
        String projectName = ResourceTestUtil.createUniqueString();
        String nodeName = "node";
        IProject project = ProjectPreferencesTest.getProject(projectName);
        project.create(ResourceTestUtil.createTestMonitor());
        File folder = new File(project.getLocation().toOSString() + "/.settings");
        folder.mkdir();
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(folder.getPath() + "/" + nodeName + ".prefs"));){
            bw.write("#Fri Jan 28 10:28:45 CET 2011\neclipse.preferences.version=1\nKEY=VALUE");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Preferences projectNode = Platform.getPreferencesService().getRootNode().node("project").node(projectName);
        Assert.assertFalse((boolean)projectNode.nodeExists(nodeName));
        Preferences node = projectNode.node(nodeName);
        project.open(ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((node == projectNode.node(nodeName) ? 1 : 0) != 0);
        Assert.assertEquals((Object)"VALUE", (Object)node.get("KEY", null));
    }

    @Test
    public void testProjectOpenClose() throws Exception {
        IProject project = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)project);
        String qualifier = ResourceTestUtil.createUniqueString();
        String key = ResourceTestUtil.createUniqueString();
        String value = ResourceTestUtil.createUniqueString();
        IEclipsePreferences node = new ProjectScope(project).getNode(qualifier);
        node.put(key, value);
        node.flush();
        project.close(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        node = new ProjectScope(project).getNode(qualifier);
        Assert.assertEquals((String)"2.1", (Object)value, (Object)node.get(key, null));
    }

    @Test
    public void testContentType() {
        IContentType prefsType = Platform.getContentTypeManager().getContentType("org.eclipse.core.resources.preferences");
        Assert.assertNotNull((String)"1.0", (Object)prefsType);
        IContentType associatedType = Platform.getContentTypeManager().findContentTypeFor("some.qualifier.prefs");
        Assert.assertEquals((String)"1.1", (Object)prefsType, (Object)associatedType);
    }

    @Test
    public void testListenerOnChangeFile() throws Exception {
        IProject project = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        String qualifier = "org.eclipse.core.tests.resources";
        String key = "key" + ResourceTestUtil.createUniqueString();
        String value = "value" + ResourceTestUtil.createUniqueString();
        ProjectScope projectContext = new ProjectScope(project);
        ResourceTestUtil.createInWorkspace((IResource)project);
        IEclipsePreferences node = projectContext.getNode(qualifier);
        node.put(key, value);
        Tracer tracer = new Tracer();
        node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)tracer);
        String actual = node.get(key, null);
        Assert.assertNotNull((String)"1.0", (Object)actual);
        Assert.assertEquals((String)"1.1", (Object)value, (Object)actual);
        node.flush();
        File file = ProjectPreferencesTest.getFileInFilesystem(project, qualifier);
        Properties props = new Properties();
        Throwable throwable = null;
        Object var12_13 = null;
        try (BufferedReader input = Files.newBufferedReader(file.toPath());){
            props.load(input);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        tracer.log.setLength(0);
        String newKey = "newKey" + ResourceTestUtil.createUniqueString();
        String newValue = "newValue" + ResourceTestUtil.createUniqueString();
        props.put(newKey, newValue);
        IFile workspaceFile = ProjectPreferencesTest.getFileInWorkspace(project, qualifier);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        props.store(output, null);
        Throwable throwable3 = null;
        Object var16_19 = null;
        try (ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());){
            workspaceFile.setContents((InputStream)input, 0, ResourceTestUtil.createTestMonitor());
        }
        catch (Throwable throwable4) {
            if (throwable3 == null) {
                throwable3 = throwable4;
            } else if (throwable3 != throwable4) {
                throwable3.addSuppressed(throwable4);
            }
            throw throwable3;
        }
        actual = node.get(key, null);
        Assert.assertEquals((String)"4.1", (Object)value, (Object)actual);
        actual = node.get(newKey, null);
        Assert.assertEquals((String)"4.2", (Object)newValue, (Object)actual);
        Assert.assertEquals((String)"4.3", (Object)("[" + newKey + ":null->S" + newValue + "]"), (Object)tracer.log.toString());
    }

    private static IProject getProject(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    private static IFile getFileInWorkspace(IProject project, String qualifier) {
        return project.getFile(IPath.fromOSString((String)DIR_NAME).append(qualifier).addFileExtension(FILE_EXTENSION));
    }

    private static File getFileInFilesystem(IProject project, String qualifier) {
        return project.getLocation().append(DIR_NAME).append(qualifier).addFileExtension(FILE_EXTENSION).toFile();
    }

    @Test
    public void testLoadIsImport() throws Exception {
        IProject project = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)project);
        ProjectScope context = new ProjectScope(project);
        String qualifier = "test.load.is.import";
        IEclipsePreferences node = context.getNode(qualifier);
        String key = "key";
        String oldValue = "old value";
        String newValue = "new value";
        IPreferencesService service = Platform.getPreferencesService();
        node.put(key, oldValue);
        node.flush();
        Assert.assertEquals((String)"1.00", (Object)oldValue, (Object)node.get(key, null));
        File fileInFS = ProjectPreferencesTest.getFileInFilesystem(project, qualifier);
        byte[] buffer = Files.readAllBytes(fileInFS.toPath());
        IFile fileInWS = ProjectPreferencesTest.getFileInWorkspace(project, qualifier);
        fileInWS.delete(0, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"3.0", (!fileInWS.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"3.1", (!fileInFS.exists() ? 1 : 0) != 0);
        IEclipsePreferences projectNode = (IEclipsePreferences)service.getRootNode().node("project").node(project.getName());
        Assert.assertTrue((String)"3.2", (boolean)this.isNodeCleared((Preferences)projectNode, new String[]{qualifier}));
        Throwable throwable = null;
        Object var14_15 = null;
        try (FileOutputStream fileOutput = new FileOutputStream(fileInFS);){
            Throwable throwable2 = null;
            Object var17_20 = null;
            try (BufferedOutputStream output = new BufferedOutputStream(fileOutput);){
                Throwable throwable3 = null;
                Object var20_25 = null;
                try (BufferedInputStream input = new BufferedInputStream(new ByteArrayInputStream(buffer));){
                    ((InputStream)input).transferTo(output);
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        project.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        node = context.getNode(qualifier);
        Assert.assertEquals((String)"5.0", (Object)newValue, (Object)node.get(key, null));
    }

    private boolean isNodeCleared(Preferences node, String[] childrenNames) throws BackingStoreException {
        if (node.keys().length != 0) {
            return false;
        }
        Preferences childNode = null;
        String[] stringArray = childrenNames;
        int n = childrenNames.length;
        int n2 = 0;
        while (n2 < n) {
            String childrenName = stringArray[n2];
            childNode = node.node(childrenName);
            if (!this.isNodeCleared(childNode, childNode.childrenNames())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Test
    public void testChildrenNamesAgainstInitialize() throws BackingStoreException, CoreException {
        String nodeA = "nodeA";
        String nodeB = "nodeB";
        String key = "key";
        String value = "value";
        IProject project1 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        Preferences prefs1 = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        prefs1.put(key, value);
        prefs1.flush();
        Assert.assertEquals((Object)value, (Object)prefs1.get(key, null));
        IProject project2 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        project1.move(project2.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Preferences prefs2 = new ProjectScope(project2).getNode(nodeA).node(nodeB);
        Assert.assertEquals((Object)value, (Object)prefs2.get(key, null));
        new ProjectScope(project1).getNode("");
        project2.move(project1.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        IEclipsePreferences node = new ProjectScope(project1).getNode("");
        Object[] childrenNames = node.childrenNames();
        Assertions.assertThat((Object[])childrenNames).hasSize(2);
        Assertions.assertThat((String)childrenNames[1]).isEqualTo(nodeA);
        node = node.node(nodeA);
        childrenNames = node.childrenNames();
        Assertions.assertThat((Object[])childrenNames).containsExactly((Object[])new String[]{nodeB});
        project1.delete(true, ResourceTestUtil.createTestMonitor());
        project2.delete(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testChildrenNamesAgainstLoad() throws BackingStoreException, CoreException {
        String nodeA = "nodeA";
        String nodeB = "nodeB";
        String key = "key";
        String value = "value";
        IProject project1 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        Preferences prefs1 = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        prefs1.put(key, value);
        prefs1.flush();
        Assert.assertEquals((Object)value, (Object)prefs1.get(key, null));
        IProject project2 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        project1.move(project2.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Preferences prefs2 = new ProjectScope(project2).getNode(nodeA).node(nodeB);
        Assert.assertEquals((Object)value, (Object)prefs2.get(key, null));
        new ProjectScope(project1).getNode(nodeA);
        project2.move(project1.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        IEclipsePreferences node = new ProjectScope(project1).getNode(nodeA);
        Object[] childrenNames = node.childrenNames();
        Assertions.assertThat((Object[])childrenNames).containsExactly((Object[])new String[]{nodeB});
        project1.delete(true, ResourceTestUtil.createTestMonitor());
        project2.delete(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testClear() throws BackingStoreException, CoreException {
        String nodeA = "nodeA";
        String nodeB = "nodeB";
        String key = "key";
        String value = "value";
        IProject project1 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        Preferences prefs1 = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        prefs1.put(key, value);
        prefs1.flush();
        Assert.assertEquals((Object)value, (Object)prefs1.get(key, null));
        IProject project2 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        project1.move(project2.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Preferences prefs2 = new ProjectScope(project2).getNode(nodeA).node(nodeB);
        Assert.assertEquals((Object)value, (Object)prefs2.get(key, null));
        new ProjectScope(project1).getNode(nodeA).node(nodeB);
        project2.move(project1.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Preferences node = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        node.clear();
        Assertions.assertThat((Object[])node.keys()).isEmpty();
        Assert.assertNull((Object)node.get(key, null));
        project1.delete(true, ResourceTestUtil.createTestMonitor());
        project2.delete(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testGet() throws BackingStoreException, CoreException {
        String nodeA = "nodeA";
        String nodeB = "nodeB";
        String key = "key";
        String value = "value";
        IProject project1 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        Preferences prefs1 = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        prefs1.put(key, value);
        prefs1.flush();
        Assert.assertEquals((Object)value, (Object)prefs1.get(key, null));
        IProject project2 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        project1.move(project2.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Preferences prefs2 = new ProjectScope(project2).getNode(nodeA).node(nodeB);
        Assert.assertEquals((Object)value, (Object)prefs2.get(key, null));
        new ProjectScope(project1).getNode(nodeA).node(nodeB);
        project2.move(project1.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Preferences node = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        Assert.assertEquals((Object)value, (Object)node.get(key, null));
        project1.delete(true, ResourceTestUtil.createTestMonitor());
        project2.delete(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testKeys() throws BackingStoreException, CoreException {
        String nodeA = "nodeA";
        String nodeB = "nodeB";
        String key = "key";
        String value = "value";
        IProject project1 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        Preferences prefs1 = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        prefs1.put(key, value);
        prefs1.flush();
        Assert.assertEquals((Object)value, (Object)prefs1.get(key, null));
        IProject project2 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        project1.move(project2.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Preferences prefs2 = new ProjectScope(project2).getNode(nodeA).node(nodeB);
        Assert.assertEquals((Object)value, (Object)prefs2.get(key, null));
        new ProjectScope(project1).getNode(nodeA).node(nodeB);
        project2.move(project1.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Preferences node = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        Object[] keys = node.keys();
        Assertions.assertThat((Object[])keys).containsExactly((Object[])new String[]{key});
        project1.delete(true, ResourceTestUtil.createTestMonitor());
        project2.delete(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testNodeExistsAgainstInitialize() throws BackingStoreException, CoreException {
        String nodeA = "nodeA";
        String nodeB = "nodeB";
        String key = "key";
        String value = "value";
        IProject project1 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        Preferences prefs1 = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        prefs1.put(key, value);
        prefs1.flush();
        Assert.assertEquals((Object)value, (Object)prefs1.get(key, null));
        IProject project2 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        project1.move(project2.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Preferences prefs2 = new ProjectScope(project2).getNode(nodeA).node(nodeB);
        Assert.assertEquals((Object)value, (Object)prefs2.get(key, null));
        new ProjectScope(project1).getNode("nodeC");
        project2.move(project1.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        IEclipsePreferences node = new ProjectScope(project1).getNode("");
        Assert.assertTrue((boolean)node.nodeExists(nodeA));
        node = node.node(nodeA);
        Assert.assertTrue((boolean)node.nodeExists(nodeB));
        project1.delete(true, ResourceTestUtil.createTestMonitor());
        project2.delete(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testNodeExistsAgainstLoad() throws BackingStoreException, CoreException {
        String nodeA = "nodeA";
        String nodeB = "nodeB";
        String key = "key";
        String value = "value";
        IProject project1 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        Preferences prefs1 = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        prefs1.put(key, value);
        prefs1.flush();
        Assert.assertEquals((Object)value, (Object)prefs1.get(key, null));
        IProject project2 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        project1.move(project2.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Preferences prefs2 = new ProjectScope(project2).getNode(nodeA).node(nodeB);
        Assert.assertEquals((Object)value, (Object)prefs2.get(key, null));
        new ProjectScope(project1).getNode(nodeA).node("nodeC");
        project2.move(project1.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        IEclipsePreferences node = new ProjectScope(project1).getNode(nodeA);
        Assert.assertTrue((boolean)node.nodeExists(nodeB));
        project1.delete(true, ResourceTestUtil.createTestMonitor());
        project2.delete(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testPut() throws BackingStoreException, CoreException {
        String nodeA = "nodeA";
        String nodeB = "nodeB";
        String key = "key";
        String value = "value";
        String anotherValue = "anotherValue";
        IProject project1 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        Preferences prefs1 = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        prefs1.put(key, value);
        prefs1.flush();
        Assert.assertEquals((Object)value, (Object)prefs1.get(key, null));
        IProject project2 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        project1.move(project2.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Preferences prefs2 = new ProjectScope(project2).getNode(nodeA).node(nodeB);
        Assert.assertEquals((Object)value, (Object)prefs2.get(key, null));
        new ProjectScope(project1).getNode(nodeA).node(nodeB);
        project2.move(project1.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Preferences node = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        node.put(key, anotherValue);
        Assert.assertEquals((Object)anotherValue, (Object)node.get(key, null));
        project1.delete(true, ResourceTestUtil.createTestMonitor());
        project2.delete(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testRemove() throws BackingStoreException, CoreException {
        String nodeA = "nodeA";
        String nodeB = "nodeB";
        String key = "key";
        String value = "value";
        IProject project1 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        Preferences prefs1 = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        prefs1.put(key, value);
        prefs1.flush();
        Assert.assertEquals((Object)value, (Object)prefs1.get(key, null));
        IProject project2 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        project1.move(project2.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Preferences prefs2 = new ProjectScope(project2).getNode(nodeA).node(nodeB);
        Assert.assertEquals((Object)value, (Object)prefs2.get(key, null));
        new ProjectScope(project1).getNode(nodeA).node(nodeB);
        project2.move(project1.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Preferences node = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        node.remove(key);
        Assert.assertNull((Object)node.get(key, null));
        project1.delete(true, ResourceTestUtil.createTestMonitor());
        project2.delete(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testDeleteOnFilesystemAndLoad() throws CoreException, BackingStoreException {
        String nodeA = "nodeA";
        String key = "key";
        String value = "value";
        IProject project1 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        IEclipsePreferences prefs1 = new ProjectScope(project1).getNode(nodeA);
        prefs1.put(key, value);
        prefs1.flush();
        IFile prefsFile = project1.getFile(".settings/nodeA.prefs");
        File settingsFile = new File(prefsFile.getLocationURI());
        Assert.assertTrue((boolean)settingsFile.exists());
        ProjectPreferences.updatePreferences((IFile)prefsFile);
        settingsFile.delete();
        Assert.assertFalse((boolean)settingsFile.exists());
        ProjectPreferences.updatePreferences((IFile)prefsFile);
    }

    @Test
    public void testSettingsFolderCreatedOutsideWorkspace() throws CoreException, BackingStoreException, IOException {
        String nodeA = "nodeA";
        String key = "key";
        String value = "value";
        IProject project1 = ProjectPreferencesTest.getProject(ResourceTestUtil.createUniqueString());
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        File projectFolder = new File(project1.getLocationURI());
        File settingsFolder = new File(projectFolder, DIR_NAME);
        Assert.assertTrue((boolean)projectFolder.exists());
        Assert.assertTrue((boolean)settingsFolder.exists());
        File prefsFile = new File(settingsFolder, "nodeA.prefs");
        prefsFile.createNewFile();
        IEclipsePreferences prefs1 = new ProjectScope(project1).getNode(nodeA);
        prefs1.put(key, value);
        prefs1.flush();
        Assert.assertEquals((Object)value, (Object)prefs1.get(key, null));
    }

    static class Tracer
    implements IEclipsePreferences.IPreferenceChangeListener {
        public StringBuilder log = new StringBuilder();

        Tracer() {
        }

        private String typeCode(Object value) {
            if (value == null) {
                return "";
            }
            if (value instanceof Boolean) {
                return "B";
            }
            if (value instanceof Integer) {
                return "I";
            }
            if (value instanceof Long) {
                return "L";
            }
            if (value instanceof Float) {
                return "F";
            }
            if (value instanceof Double) {
                return "D";
            }
            if (value instanceof String) {
                return "S";
            }
            Assert.assertTrue((String)"0.0", (boolean)false);
            return null;
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            this.log.append("[");
            this.log.append(event.getKey());
            this.log.append(":");
            this.log.append(this.typeCode(event.getOldValue()));
            this.log.append(event.getOldValue() == null ? "null" : event.getOldValue());
            this.log.append("->");
            this.log.append(this.typeCode(event.getNewValue()));
            this.log.append(event.getNewValue() == null ? "null" : event.getNewValue());
            this.log.append("]");
        }
    }
}

