/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.resources;

import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.resources.BuildConfiguration;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ProjectReferencesTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private IProject project0;
    private IProject project1;
    private IProject project2;
    private IProject project3;
    private IBuildConfiguration project0v0;
    private IBuildConfiguration project0v1;
    private IBuildConfiguration project1v0;
    private IBuildConfiguration project1v1;
    private IBuildConfiguration project2v0;
    private IBuildConfiguration project3v0;
    private IBuildConfiguration project3v1;
    private static final String bc0 = "Variant0";
    private static final String bc1 = "Variant1";
    private static final String nonExistentBC = "foo";

    @Before
    public void setUp() throws Exception {
        this.project0 = ResourcesPlugin.getWorkspace().getRoot().getProject("ProjectReferencesTest_p0");
        this.project1 = ResourcesPlugin.getWorkspace().getRoot().getProject("ProjectReferencesTest_p1");
        this.project2 = ResourcesPlugin.getWorkspace().getRoot().getProject("ProjectReferencesTest_p2");
        this.project3 = ResourcesPlugin.getWorkspace().getRoot().getProject("ProjectReferencesTest_p3");
        ResourceTestUtil.createInWorkspace((IResource[])new IProject[]{this.project0, this.project1, this.project2, this.project3});
        this.setUpVariants(this.project0);
        this.setUpVariants(this.project1);
        this.setUpVariants(this.project2);
        this.setUpVariants(this.project3);
        this.project0v0 = new BuildConfiguration(this.project0, bc0);
        this.project0v1 = new BuildConfiguration(this.project0, bc1);
        this.project1v0 = new BuildConfiguration(this.project1, bc0);
        this.project1v1 = new BuildConfiguration(this.project1, bc1);
        this.project2v0 = new BuildConfiguration(this.project2, bc0);
        this.project3v0 = new BuildConfiguration(this.project3, bc0);
        this.project3v1 = new BuildConfiguration(this.project3, bc1);
    }

    private IBuildConfiguration getRef(IProject project) {
        return new BuildConfiguration(project, null);
    }

    private void setUpVariants(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        desc.setBuildConfigs(new String[]{bc0, bc1});
        project.setDescription(desc, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testAddReferencesToNonExistantConfigs() throws CoreException {
        IProjectDescription desc = this.project0.getDescription();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.project0.hasBuildConfig(nonExistentBC)).withFailMessage("project '%s' has unexpected build config: %s", new Object[]{this.project0, nonExistentBC})).isFalse();
        desc.setBuildConfigReferences(nonExistentBC, new IBuildConfiguration[]{this.project1v0});
        this.project0.setDescription(desc, ResourceTestUtil.createTestMonitor());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.project0.hasBuildConfig(nonExistentBC)).withFailMessage("project '%s' has unexpected build config: %s", new Object[]{this.project0, nonExistentBC})).isFalse();
        Assertions.assertThat((Object[])desc.getBuildConfigReferences(nonExistentBC)).isEmpty();
        Assert.assertThrows(CoreException.class, () -> {
            IBuildConfiguration[] iBuildConfigurationArray = this.project0.getReferencedBuildConfigs(nonExistentBC, true);
        });
    }

    @Test
    public void testChangingBuildConfigurations() throws CoreException {
        IProjectDescription desc = this.project0.getDescription();
        IBuildConfiguration[] refs = new IBuildConfiguration[]{this.project0v1, this.project1v0};
        IBuildConfiguration[] refs2 = new IBuildConfiguration[]{this.project1v1, this.project1v0};
        desc.setBuildConfigReferences(this.project0v0.getName(), refs);
        desc.setBuildConfigReferences(this.project0v1.getName(), refs2);
        this.project0.setDescription(desc, ResourceTestUtil.createTestMonitor());
        desc = this.project0.getDescription();
        Assertions.assertThat((Object[])desc.getBuildConfigReferences(this.project0v0.getName())).isEqualTo((Object)refs);
        Assertions.assertThat((Object[])desc.getBuildConfigReferences(this.project0v1.getName())).isEqualTo((Object)refs2);
        desc.setBuildConfigs(new String[]{this.project0v0.getName(), this.project0v1.getName()});
        this.project0.setDescription(desc, ResourceTestUtil.createTestMonitor());
        desc = this.project0.getDescription();
        Assertions.assertThat((Object[])desc.getBuildConfigReferences(this.project0v0.getName())).isEqualTo((Object)refs);
        Assertions.assertThat((Object[])desc.getBuildConfigReferences(this.project0v1.getName())).isEqualTo((Object)refs2);
        desc.setBuildConfigs(new String[]{this.project0v0.getName()});
        this.project0.setDescription(desc, ResourceTestUtil.createTestMonitor());
        desc = this.project0.getDescription();
        Assertions.assertThat((Object[])desc.getBuildConfigReferences(this.project0v0.getName())).isEqualTo((Object)refs);
        Assertions.assertThat((Object[])desc.getBuildConfigReferences(this.project0v1.getName())).isEmpty();
        desc.setBuildConfigs(new String[]{this.project0v0.getName()});
        this.project0.setDescription(desc, ResourceTestUtil.createTestMonitor());
        desc = this.project0.getDescription();
        Assertions.assertThat((Object[])desc.getBuildConfigReferences(this.project0v0.getName())).isEqualTo((Object)refs);
        Assertions.assertThat((Object[])desc.getBuildConfigReferences(this.project0v1.getName())).isEmpty();
    }

    @Test
    public void testMixedProjectAndBuildConfigRefs() throws CoreException {
        IProjectDescription desc = this.project0.getDescription();
        desc.setDynamicReferences(new IProject[]{this.project1, this.project3});
        this.project0.setDescription(desc, ResourceTestUtil.createTestMonitor());
        desc = this.project0.getDescription();
        Assertions.assertThat((Object[])desc.getDynamicReferences()).containsExactly((Object[])new IProject[]{this.project1, this.project3});
        Assertions.assertThat((Object[])desc.getBuildConfigReferences(this.project0v0.getName())).isEmpty();
        Assertions.assertThat((Object[])desc.getBuildConfigReferences(this.project0v1.getName())).isEmpty();
        Assertions.assertThat((Object[])this.project0.getReferencedBuildConfigs(this.project0v0.getName(), false)).containsExactly((Object[])new IBuildConfiguration[]{this.project1.getActiveBuildConfig(), this.project3.getActiveBuildConfig()});
        Assertions.assertThat((Object[])this.project0.getReferencedBuildConfigs(this.project0v1.getName(), false)).containsExactly((Object[])new IBuildConfiguration[]{this.project1.getActiveBuildConfig(), this.project3.getActiveBuildConfig()});
        desc.setBuildConfigReferences(this.project0v0.getName(), new IBuildConfiguration[]{this.project3v1, this.project2v0, this.project1v0});
        this.project0.setDescription(desc, ResourceTestUtil.createTestMonitor());
        desc = this.project0.getDescription();
        Assertions.assertThat((Object[])desc.getDynamicReferences()).containsExactly((Object[])new IProject[]{this.project1, this.project3});
        Assertions.assertThat((Object[])desc.getBuildConfigReferences(this.project0v0.getName())).containsExactly((Object[])new IBuildConfiguration[]{this.project3v1, this.project2v0, this.project1v0});
        Assertions.assertThat((Object[])this.project0.getReferencedBuildConfigs(this.project0v0.getName(), false)).containsExactly((Object[])new IBuildConfiguration[]{this.project3v1, this.project2v0, this.project1v0, this.project3v0});
        Assertions.assertThat((Object[])this.project0.getReferencedBuildConfigs(this.project0v1.getName(), false)).containsExactly((Object[])new IBuildConfiguration[]{this.project1.getActiveBuildConfig(), this.project3.getActiveBuildConfig()});
    }

    @Test
    public void testSetAndGetProjectReferences() throws CoreException {
        IProjectDescription desc = this.project0.getDescription();
        desc.setReferencedProjects(new IProject[]{this.project3, this.project1});
        desc.setDynamicReferences(new IProject[]{this.project1, this.project2});
        this.project0.setDescription(desc, ResourceTestUtil.createTestMonitor());
        desc = this.project1.getDescription();
        desc.setReferencedProjects(new IProject[]{this.project0});
        desc.setDynamicReferences(new IProject[0]);
        this.project1.setDescription(desc, ResourceTestUtil.createTestMonitor());
        desc = this.project2.getDescription();
        desc.setReferencedProjects(new IProject[0]);
        desc.setDynamicReferences(new IProject[0]);
        this.project2.setDescription(desc, ResourceTestUtil.createTestMonitor());
        desc = this.project3.getDescription();
        desc.setReferencedProjects(new IProject[0]);
        desc.setDynamicReferences(new IProject[]{this.project0});
        this.project3.setDescription(desc, ResourceTestUtil.createTestMonitor());
        desc = this.project0.getDescription();
        Assertions.assertThat((Object[])desc.getReferencedProjects()).containsExactly((Object[])new IProject[]{this.project3, this.project1});
        Assertions.assertThat((Object[])desc.getDynamicReferences()).containsExactly((Object[])new IProject[]{this.project1, this.project2});
        Assertions.assertThat((Object[])desc.getBuildConfigReferences(bc0)).isEmpty();
        Assertions.assertThat((Object[])this.project0.getReferencedProjects()).containsExactly((Object[])new IProject[]{this.project3, this.project1, this.project2});
        Assertions.assertThat((Object[])this.project0.getReferencingProjects()).containsExactly((Object[])new IProject[]{this.project1, this.project3});
        Assertions.assertThat((Object[])this.project0.getReferencedBuildConfigs(this.project0v0.getName(), true)).containsExactly((Object[])new IBuildConfiguration[]{this.project3v0, this.project1v0, this.project2v0});
    }

    @Test
    public void testSetAndGetProjectConfigReferences() throws CoreException {
        IProjectDescription desc = this.project0.getDescription();
        desc.setReferencedProjects(new IProject[]{this.project1});
        desc.setDynamicReferences(new IProject[]{this.project3});
        desc.setBuildConfigReferences(bc0, new IBuildConfiguration[]{this.project2v0, this.project1v0});
        desc.setBuildConfigReferences(bc1, new IBuildConfiguration[]{this.project2v0});
        this.project0.setDescription(desc, ResourceTestUtil.createTestMonitor());
        desc = this.project1.getDescription();
        desc.setReferencedProjects(new IProject[]{this.project0});
        desc.setBuildConfigReferences(bc0, new IBuildConfiguration[]{this.project0v1});
        desc.setBuildConfigReferences(bc1, new IBuildConfiguration[0]);
        this.project1.setDescription(desc, ResourceTestUtil.createTestMonitor());
        desc = this.project3.getDescription();
        desc.setBuildConfigReferences(bc0, new IBuildConfiguration[]{this.project0v1});
        desc.setBuildConfigReferences(bc1, new IBuildConfiguration[0]);
        this.project3.setDescription(desc, ResourceTestUtil.createTestMonitor());
        desc = this.project0.getDescription();
        Assertions.assertThat((Object[])desc.getReferencedProjects()).containsExactly((Object[])new IProject[]{this.project1});
        Assertions.assertThat((Object[])desc.getDynamicReferences()).containsExactly((Object[])new IProject[]{this.project3});
        Assertions.assertThat((Object[])desc.getBuildConfigReferences(bc0)).containsExactly((Object[])new IBuildConfiguration[]{this.project2v0, this.project1v0});
        Assertions.assertThat((Object[])desc.getBuildConfigReferences(bc1)).containsExactly((Object[])new IBuildConfiguration[]{this.project2v0});
        Assertions.assertThat((Object[])this.project0.getReferencedProjects()).containsExactly((Object[])new IProject[]{this.project2, this.project1, this.project3});
        Assertions.assertThat((Object[])this.project0.getReferencingProjects()).containsExactly((Object[])new IProject[]{this.project1, this.project3});
        Assertions.assertThat((Object[])this.project0.getReferencedBuildConfigs(this.project0v0.getName(), true)).containsExactly((Object[])new IBuildConfiguration[]{this.project2v0, this.project1v0, this.project3.getActiveBuildConfig()});
        Assertions.assertThat((Object[])this.project0.getReferencedBuildConfigs(this.project0v1.getName(), true)).containsExactly((Object[])new IBuildConfiguration[]{this.project2v0, this.project1.getActiveBuildConfig(), this.project3.getActiveBuildConfig()});
    }

    @Test
    public void testReferencesToActiveConfigs() throws CoreException {
        IProjectDescription desc = this.project0.getDescription();
        desc.setBuildConfigReferences(bc0, new IBuildConfiguration[]{this.getRef(this.project1)});
        this.project0.setDescription(desc, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])desc.getBuildConfigReferences(bc0)).containsExactly((Object[])new IBuildConfiguration[]{this.getRef(this.project1)});
        Assertions.assertThat((Object[])this.project0.getReferencedBuildConfigs(this.project0v0.getName(), true)).containsExactly((Object[])new IBuildConfiguration[]{this.project1v0});
    }
}

