/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.resources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ResourceInfoTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    public static void assertEquals(ResourceInfo expected, ResourceInfo actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            Assert.assertTrue((boolean)false);
        }
        boolean different = false;
        different &= expected.getFlags() == actual.getFlags();
        different &= expected.getContentId() == actual.getContentId();
        different &= expected.getModificationStamp() == actual.getModificationStamp();
        different &= expected.getNodeId() == actual.getNodeId();
        different &= expected.getLocalSyncInfo() == actual.getLocalSyncInfo();
        if (different &= expected.getMarkerGenerationCount() == actual.getMarkerGenerationCount()) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testSerialization() throws IOException {
        ByteArrayInputStream input = null;
        ByteArrayOutputStream output = null;
        ResourceInfo info = new ResourceInfo();
        ResourceInfo newInfo = new ResourceInfo();
        output = new ByteArrayOutputStream();
        info.writeTo((DataOutput)new DataOutputStream(output));
        input = new ByteArrayInputStream(output.toByteArray());
        newInfo.readFrom(0, (DataInput)new DataInputStream(input));
        ResourceInfoTest.assertEquals(info, newInfo);
        info = new ResourceInfo();
        QualifiedName qname = new QualifiedName("org.eclipse.core.tests", "myTest1");
        byte[] bytes = new byte[]{};
        info.setSyncInfo(qname, bytes);
        qname = new QualifiedName("org.eclipse.core.tests", "myTest2");
        byte[] byArray = new byte[6];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        bytes = byArray;
        info.setSyncInfo(qname, bytes);
        output = new ByteArrayOutputStream();
        info.writeTo((DataOutput)new DataOutputStream(output));
        newInfo = new ResourceInfo();
        input = new ByteArrayInputStream(output.toByteArray());
        newInfo.readFrom(0, (DataInput)new DataInputStream(input));
        ResourceInfoTest.assertEquals(info, newInfo);
    }
}

