/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.resources;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class TestWorkspaceJob
extends WorkspaceJob {
    private static final int tickLength = 10;
    private final long duration;
    private boolean touch = false;

    public TestWorkspaceJob(long duration) {
        super("TestWorkspaceJob");
        this.duration = duration;
        if (duration % 10L > 0L) {
            throw new IllegalArgumentException("Use a job duration that it is a multiple of 10");
        }
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        int ticks = (int)(this.duration / 10L);
        monitor.beginTask(this.getName(), ticks <= 0 ? 1 : ticks);
        if (this.touch) {
            IProject[] projects;
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                project.touch(null);
                ++n2;
            }
        }
        try {
            int i = 0;
            while (i < ticks) {
                monitor.subTask("Tick: " + i);
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                monitor.worked(1);
                ++i;
            }
            if (ticks <= 0) {
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public void setTouch(boolean value) {
        this.touch = value;
    }
}

