/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.resources;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.harness.CancelingProgressMonitor;
import org.eclipse.core.tests.harness.TestBarrier2;
import org.eclipse.core.tests.internal.resources.TestWorkspaceJob;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class WorkspaceConcurrencyTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    private void sleep(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void testEndRuleInWorkspaceOperation() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("testEndRuleInWorkspaceOperation");
        Assert.assertThrows(RuntimeException.class, () -> ResourcesPlugin.getWorkspace().run(monitor -> Job.getJobManager().endRule((ISchedulingRule)project), (ISchedulingRule)project, 0, ResourceTestUtil.createTestMonitor()));
    }

    @Test
    public void testCancelOnBlocked() throws Throwable {
        ResourceTestUtil.createInWorkspace((IResource)ResourcesPlugin.getWorkspace().getRoot().getProject("P1"));
        AtomicIntegerArray barrier = new AtomicIntegerArray(new int[1]);
        AtomicReference errorInListener = new AtomicReference();
        IResourceChangeListener listener = event -> {
            barrier.set(0, 1);
            try {
                TestBarrier2.waitForStatus((AtomicIntegerArray)barrier, (int)5);
            }
            catch (Throwable e) {
                errorInListener.set(e);
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(listener);
        try {
            TestWorkspaceJob testJob = new TestWorkspaceJob(10L);
            testJob.setTouch(true);
            testJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            testJob.schedule();
            TestBarrier2.waitForStatus((AtomicIntegerArray)barrier, (int)1);
            AtomicBoolean canceled = new AtomicBoolean();
            AtomicReference errorInThread = new AtomicReference();
            Thread t2 = new Thread(() -> {
                try {
                    ResourcesPlugin.getWorkspace().run(monitor -> {}, (IProgressMonitor)new CancelingProgressMonitor());
                }
                catch (CoreException e1) {
                    errorInThread.set(e1);
                }
                catch (OperationCanceledException e2) {
                    canceled.set(true);
                }
            });
            t2.start();
            t2.join();
            Assert.assertTrue((String)"thread was not canceled", (boolean)canceled.get());
            barrier.set(0, 5);
            testJob.join();
            if (errorInListener.get() != null) {
                throw (Throwable)errorInListener.get();
            }
            if (errorInThread.get() != null) {
                throw (Throwable)errorInThread.get();
            }
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
        }
    }

    @Test
    public void testRunnableWithOtherRule() throws CoreException {
        ISchedulingRule rule = new ISchedulingRule(){

            public boolean contains(ISchedulingRule schedulingRule) {
                return schedulingRule == this;
            }

            public boolean isConflicting(ISchedulingRule schedulingRule) {
                return schedulingRule == this;
            }
        };
        ResourcesPlugin.getWorkspace().run(monitor -> {}, rule, 0, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testRunWhileBuilding() throws Throwable {
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject touch = workspace.getRoot().getProject("ToTouch");
        IProject rule = workspace.getRoot().getProject("jobThree");
        final IFile ruleFile = rule.getFile("somefile.txt");
        ResourceTestUtil.createInWorkspace((IResource)rule);
        ResourceTestUtil.createInWorkspace((IResource)touch);
        ResourceTestUtil.createInWorkspace((IResource)ruleFile);
        AtomicReference failure = new AtomicReference();
        IResourceChangeListener listener = event -> {
            try {
                touch.touch(null);
            }
            catch (RuntimeException | CoreException e2) {
                failure.set(e2);
            }
        };
        workspace.addResourceChangeListener(listener, 16);
        try {
            final AtomicIntegerArray status = new AtomicIntegerArray(new int[3]);
            Job jobOne = new Job("jobOne"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        workspace.run(monitor1 -> {
                            workspace.build(10, monitor1);
                            status.set(0, 3);
                            TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)4);
                        }, null);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            jobOne.schedule();
            TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)0, (int)3);
            Job jobTwo = new Job("jobTwo"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        workspace.run(monitor1 -> {
                            status.set(1, 3);
                            status.set(0, 4);
                            TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)1, (int)4);
                        }, null, 0, null);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            jobTwo.schedule();
            Job jobThree = new Job("jobThree"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        workspace.run(monitor1 -> {
                            status.set(2, 3);
                            status.set(1, 4);
                            ruleFile.touch(null);
                            TestBarrier2.waitForStatus((AtomicIntegerArray)status, (int)2, (int)4);
                        }, workspace.getRuleFactory().modifyRule((IResource)ruleFile), 0, null);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            jobThree.schedule();
            this.waitForCompletion(jobTwo);
            status.set(2, 4);
            this.waitForCompletion(jobThree);
            IStatus result = jobOne.getResult();
            if (!result.isOK()) {
                throw new CoreException(result);
            }
            result = jobTwo.getResult();
            if (!result.isOK()) {
                throw new CoreException(result);
            }
            result = jobThree.getResult();
            if (!result.isOK()) {
                throw new CoreException(result);
            }
            if (failure.get() != null) {
                throw (Throwable)failure.get();
            }
        }
        finally {
            workspace.removeResourceChangeListener(listener);
        }
    }

    private void waitForCompletion(Job job) {
        int i = 0;
        while (job.getState() != 0) {
            this.sleep(100L);
            Assert.assertTrue((String)"Timeout waiting for job to complete", (i++ < 1000 ? 1 : 0) != 0);
        }
    }
}

