/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.resources;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import junit.framework.ComparisonFailure;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.resources.WorkspaceDescription;
import org.eclipse.core.internal.resources.WorkspacePreferences;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class WorkspacePreferencesTest {
    @RegisterExtension
    SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();
    private IWorkspace workspace;
    private Preferences preferences;

    @BeforeEach
    public void retrieveWorkspaceAndPreferences() throws CoreException {
        this.workspace = ResourcesPlugin.getWorkspace();
        this.preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
    }

    @AfterEach
    public void restoreWorkspaceDescription() throws CoreException {
        this.workspace.setDescription((IWorkspaceDescription)Workspace.defaultWorkspaceDescription());
    }

    @Test
    public void testDefaults() throws CoreException {
        WorkspaceDescription description = Workspace.defaultWorkspaceDescription();
        this.assertMatchesPreferences(this.preferences, (IWorkspaceDescription)description);
        String[] descriptionProperties = new String[]{"description.autobuilding", "description.defaultbuildorder", "description.filestatelongevity", "description.maxbuilditerations", "description.maxfilestatesize", "description.maxfilestates", "description.snapshotinterval"};
        List<String> defaultPropertiesList = Arrays.asList(this.preferences.defaultPropertyNames());
        String[] stringArray = descriptionProperties;
        int n = descriptionProperties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            ((ListAssert)Assertions.assertThat(defaultPropertiesList).as("check description properties are default", new Object[0])).contains((Object[])new String[]{property});
            ++n2;
        }
    }

    @Test
    public void testSetPreferences() throws CoreException {
        this.preferences.setValue("description.autobuilding", true);
        Assertions.assertThat((Object)this.workspace.getDescription()).matches(IWorkspaceDescription::isAutoBuilding, "is auto-building");
        this.preferences.setValue("description.autobuilding", false);
        Assertions.assertThat((Object)this.workspace.getDescription()).matches(Predicate.not(IWorkspaceDescription::isAutoBuilding), "is not auto-building");
        this.preferences.setValue("description.defaultbuildorder", true);
        Assertions.assertThat((Object[])this.workspace.getDescription().getBuildOrder()).isNull();
        this.preferences.setValue("description.defaultbuildorder", false);
        Assertions.assertThat((Object[])this.workspace.getDescription().getBuildOrder()).isNotNull();
        this.preferences.setValue("description.buildorder", "x/y,:z/z");
        Assertions.assertThat((Object[])this.workspace.getDescription().getBuildOrder()).containsExactly((Object[])new String[]{"x", "y,:z", "z"});
        this.preferences.setValue("description.buildorder", "");
        Assertions.assertThat((Object[])this.workspace.getDescription().getBuildOrder()).isEmpty();
        long snapshotInterval = 800000000L;
        this.preferences.setValue("description.snapshotinterval", snapshotInterval);
        Assertions.assertThat((long)this.workspace.getDescription().getSnapshotInterval()).isEqualTo(snapshotInterval);
        long defaultSnapshotInterval = this.preferences.getDefaultLong("description.snapshotinterval");
        this.preferences.setValue("description.snapshotinterval", defaultSnapshotInterval);
        Assertions.assertThat((long)this.workspace.getDescription().getSnapshotInterval()).isEqualTo(defaultSnapshotInterval);
        this.preferences.setToDefault("description.snapshotinterval");
        Assertions.assertThat((long)this.workspace.getDescription().getSnapshotInterval()).isEqualTo(defaultSnapshotInterval);
        this.assertMatchesPreferences(this.preferences, this.workspace.getDescription());
        this.preferences.setValue("description.keepDerivedState", false);
        Assertions.assertThat((Object)this.workspace.getDescription()).matches(Predicate.not(IWorkspaceDescription::isKeepDerivedState), "does not keep derived state");
        this.preferences.setValue("description.keepDerivedState", true);
        Assertions.assertThat((Object)this.workspace.getDescription()).matches(IWorkspaceDescription::isKeepDerivedState, "keeps derived state");
    }

    @Test
    public void testEvents() throws CoreException {
        IWorkspaceDescription original = this.workspace.getDescription();
        IWorkspaceDescription modified = this.workspace.getDescription();
        modified.setAutoBuilding(!original.isAutoBuilding());
        modified.setBuildOrder(new String[]{"a", "b", "c"});
        modified.setApplyFileStatePolicy(!original.isApplyFileStatePolicy());
        modified.setFileStateLongevity((original.getFileStateLongevity() + 1L) * 2L);
        modified.setMaxBuildIterations((original.getMaxBuildIterations() + 1) * 2);
        modified.setMaxFileStates((original.getMaxFileStates() + 1) * 2);
        modified.setMaxFileStateSize((original.getMaxFileStateSize() + 1L) * 2L);
        modified.setSnapshotInterval((original.getSnapshotInterval() + 1L) * 2L);
        modified.setKeepDerivedState(!original.isKeepDerivedState());
        LinkedList changedProperties = new LinkedList();
        Preferences.IPropertyChangeListener listener = event -> {
            boolean bl = changedProperties.add(event.getProperty());
        };
        try {
            this.preferences.addPropertyChangeListener(listener);
            this.workspace.setDescription(original);
            ((ListAssert)Assertions.assertThat(changedProperties).as("check no events have been fired", new Object[0])).isEmpty();
            this.workspace.setDescription(modified);
            ((ListAssert)Assertions.assertThat(changedProperties).as("check right number of events has been fired", new Object[0])).hasSize(10);
        }
        finally {
            this.preferences.removePropertyChangeListener(listener);
        }
    }

    @Test
    public void testImportExport() throws CoreException {
        IPath originalPreferencesFile = FileSystemHelper.getRandomLocation().append("original.epf");
        IPath modifiedPreferencesFile = FileSystemHelper.getRandomLocation().append("modified.epf");
        try {
            IWorkspaceDescription original = this.workspace.getDescription();
            this.preferences.setValue("foo.bar", ResourceTestUtil.createRandomString());
            Preferences.exportPreferences((IPath)originalPreferencesFile);
            IWorkspaceDescription modified = this.workspace.getDescription();
            modified.setAutoBuilding(!original.isAutoBuilding());
            modified.setBuildOrder(new String[]{"a", "b", "c"});
            modified.setApplyFileStatePolicy(!original.isApplyFileStatePolicy());
            modified.setFileStateLongevity((original.getFileStateLongevity() + 1L) * 2L);
            modified.setMaxBuildIterations((original.getMaxBuildIterations() + 1) * 2);
            modified.setMaxFileStates((original.getMaxFileStates() + 1) * 2);
            modified.setMaxFileStateSize((original.getMaxFileStateSize() + 1L) * 2L);
            modified.setSnapshotInterval((original.getSnapshotInterval() + 1L) * 2L);
            modified.setKeepDerivedState(!original.isKeepDerivedState());
            this.workspace.setDescription(modified);
            this.assertDescriptionEquals(modified, this.workspace.getDescription());
            Preferences.exportPreferences((IPath)modifiedPreferencesFile);
            Preferences.importPreferences((IPath)originalPreferencesFile);
            this.assertDescriptionEquals(original, this.workspace.getDescription());
            Preferences.importPreferences((IPath)modifiedPreferencesFile);
            this.assertDescriptionEquals(modified, this.workspace.getDescription());
        }
        finally {
            ResourceTestUtil.removeFromFileSystem(originalPreferencesFile.removeLastSegments(1).toFile());
            ResourceTestUtil.removeFromFileSystem(modifiedPreferencesFile.removeLastSegments(1).toFile());
        }
    }

    @Test
    public void testSetDescription() throws CoreException {
        IWorkspaceDescription description = this.workspace.getDescription();
        description.setAutoBuilding(false);
        description.setBuildOrder(new String[]{"a", "b,c", "c"});
        description.setFileStateLongevity(300000L);
        description.setMaxBuildIterations(35);
        description.setMaxFileStates(16);
        description.setMaxFileStateSize(100050L);
        description.setSnapshotInterval(1234567L);
        description.setKeepDerivedState(true);
        this.workspace.setDescription(description);
        this.assertMatchesPreferences(this.preferences, description);
        description.setFileStateLongevity(90000L);
        this.workspace.setDescription(description);
        description.setFileStateLongevity(100000L);
        Assertions.assertThat((long)this.workspace.getDescription().getFileStateLongevity()).isEqualTo(90000L);
        Assertions.assertThat((long)this.preferences.getLong("description.filestatelongevity")).isEqualTo(90000L);
    }

    private void assertMatchesPreferences(Preferences expectedPreferences, IWorkspaceDescription actualDescription) throws ComparisonFailure {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)actualDescription.isAutoBuilding()).as("check auto building", new Object[0])).isEqualTo(expectedPreferences.getBoolean("description.autobuilding"));
        ((AbstractBooleanAssert)Assertions.assertThat((actualDescription.getBuildOrder() == null ? 1 : 0) != 0).as("check default build order", new Object[0])).isEqualTo(expectedPreferences.getBoolean("description.defaultbuildorder"));
        ((AbstractStringAssert)Assertions.assertThat((String)WorkspacePreferences.convertStringArraytoString((String[])actualDescription.getBuildOrder())).as("check build order", new Object[0])).isEqualTo(expectedPreferences.getString("description.buildorder"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)actualDescription.isApplyFileStatePolicy()).as("check apply file state policy", new Object[0])).isEqualTo(expectedPreferences.getBoolean("description.applyfilestatepolicy"));
        ((AbstractLongAssert)Assertions.assertThat((long)actualDescription.getFileStateLongevity()).as("check file state longevity", new Object[0])).isEqualTo(expectedPreferences.getLong("description.filestatelongevity"));
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDescription.getMaxFileStates()).as("check max files states", new Object[0])).isEqualTo(expectedPreferences.getInt("description.maxfilestates"));
        ((AbstractLongAssert)Assertions.assertThat((long)actualDescription.getMaxFileStateSize()).as("check max file state size", new Object[0])).isEqualTo(expectedPreferences.getLong("description.maxfilestatesize"));
        ((AbstractLongAssert)Assertions.assertThat((long)actualDescription.getSnapshotInterval()).as("check snapshot interval", new Object[0])).isEqualTo(expectedPreferences.getLong("description.snapshotinterval"));
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDescription.getMaxBuildIterations()).as("check max build iterations", new Object[0])).isEqualTo(expectedPreferences.getLong("description.maxbuilditerations"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)actualDescription.isKeepDerivedState()).as("check keep derived state", new Object[0])).isEqualTo(expectedPreferences.getBoolean("description.keepDerivedState"));
    }

    private void assertDescriptionEquals(IWorkspaceDescription expectedDescription, IWorkspaceDescription actualDescription) throws ComparisonFailure {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)actualDescription.isAutoBuilding()).as("check auto building", new Object[0])).isEqualTo(expectedDescription.isAutoBuilding());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])actualDescription.getBuildOrder()).as("check default build order", new Object[0])).isEqualTo((Object)expectedDescription.getBuildOrder());
        ((AbstractStringAssert)Assertions.assertThat((String)WorkspacePreferences.convertStringArraytoString((String[])actualDescription.getBuildOrder())).as("check build order", new Object[0])).isEqualTo(WorkspacePreferences.convertStringArraytoString((String[])expectedDescription.getBuildOrder()));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)actualDescription.isApplyFileStatePolicy()).as("check apply file state policy", new Object[0])).isEqualTo(expectedDescription.isApplyFileStatePolicy());
        ((AbstractLongAssert)Assertions.assertThat((long)actualDescription.getFileStateLongevity()).as("check file state longevity", new Object[0])).isEqualTo(expectedDescription.getFileStateLongevity());
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDescription.getMaxFileStates()).as("check max files states", new Object[0])).isEqualTo(expectedDescription.getMaxFileStates());
        ((AbstractLongAssert)Assertions.assertThat((long)actualDescription.getMaxFileStateSize()).as("check max file state size", new Object[0])).isEqualTo(expectedDescription.getMaxFileStateSize());
        ((AbstractLongAssert)Assertions.assertThat((long)actualDescription.getSnapshotInterval()).as("check snapshot interval", new Object[0])).isEqualTo(expectedDescription.getSnapshotInterval());
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDescription.getMaxBuildIterations()).as("check max build iterations", new Object[0])).isEqualTo(expectedDescription.getMaxBuildIterations());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)actualDescription.isKeepDerivedState()).as("check keep derived state", new Object[0])).isEqualTo(expectedDescription.isKeepDerivedState());
    }
}

