/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.utils;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileUtilTest {
    private IPath baseTestDir;

    @BeforeEach
    public void setUp() throws Exception {
        this.baseTestDir = FileSystemHelper.getRandomLocation();
        this.baseTestDir.toFile().mkdirs();
    }

    @AfterEach
    public void tearDown() throws Exception {
        FileSystemHelper.clear((File)this.baseTestDir.toFile());
    }

    @Test
    public void testRealPath() throws Exception {
        IPath realPath = this.baseTestDir.append("Test.TXT");
        realPath.toFile().createNewFile();
        IPath testPath = EFS.getLocalFileSystem().isCaseSensitive() ? realPath : IPath.fromOSString((String)realPath.toOSString().toLowerCase());
        Assertions.assertEquals((Object)realPath, (Object)FileUtil.realPath((IPath)testPath));
    }

    @Test
    public void testRealPathOfNonexistingFile() throws Exception {
        IPath realPath = this.baseTestDir.append("ExistingDir");
        realPath.toFile().mkdirs();
        IPath testPath = EFS.getLocalFileSystem().isCaseSensitive() ? realPath : IPath.fromOSString((String)realPath.toOSString().toLowerCase());
        String suffix = "NonexistingDir/NonexistingFile.txt";
        Assertions.assertEquals((Object)realPath.append(suffix), (Object)FileUtil.realPath((IPath)testPath.append(suffix)));
    }

    @Test
    public void testRealURI() throws Exception {
        IPath realPath = this.baseTestDir.append("Test.TXT");
        realPath.toFile().createNewFile();
        IPath testPath = EFS.getLocalFileSystem().isCaseSensitive() ? realPath : IPath.fromOSString((String)realPath.toOSString().toLowerCase());
        URI realURI = URIUtil.toURI((IPath)realPath);
        URI testURI = URIUtil.toURI((IPath)testPath);
        Assertions.assertEquals((Object)realURI, (Object)FileUtil.realURI((URI)testURI));
    }
}

