/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.utils.ObjectMap;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.Test;

public class ObjectMapTest {
    private static final int MAXIMUM = 100;

    @Test
    public void testPut() {
        Integer key;
        ObjectMap map = new ObjectMap();
        Object[] values = new Object[100];
        int i = 0;
        while (i < 100) {
            values[i] = System.currentTimeMillis();
            ++i;
        }
        i = 0;
        while (i < values.length) {
            key = i;
            map.put((Object)key, values[i]);
            Assertions.assertThat((Map)map).containsKey((Object)key);
            Assertions.assertThat((Map)map).containsValue(values[i]);
            Assertions.assertThat((Map)map).hasSize(i + 1);
            ++i;
        }
        Assertions.assertThat((Map)map).hasSize(100);
        i = 0;
        while (i < values.length) {
            key = i;
            Assertions.assertThat((Map)map).containsKey((Object)key);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)map.get((Object)key), (String)("" + i));
            ++i;
        }
    }

    @Test
    public void testPutEmptyMap() {
        ObjectMap map = new ObjectMap(new HashMap());
        map.put(new Object(), new Object());
    }

    @Test
    public void testRemove() {
        Object[] values = new Object[100];
        ObjectMap<Integer, Object> map = this.populateMap(values);
        int i = 99;
        while (i >= 0) {
            Integer key = i;
            map.remove((Object)key);
            Assertions.assertThat(map).doesNotContainKey((Object)key);
            Assertions.assertThat(map).hasSize(i);
            int j = 0;
            while (j < i) {
                Assertions.assertThat(map).containsKey((Object)j);
                ++j;
            }
            --i;
        }
        Assertions.assertThat(map).isEmpty();
    }

    @Test
    public void testContains() {
        Object[] values = new Object[100];
        ObjectMap<Integer, Object> map = this.populateMap(values);
        int i = 0;
        while (i < 100) {
            Assertions.assertThat(map).containsKey((Object)i);
            Assertions.assertThat(map).containsValue(values[i]);
            ++i;
        }
        Assertions.assertThat(map).doesNotContainKey((Object)101);
        Assertions.assertThat(map).doesNotContainKey((Object)-1);
        Assertions.assertThat(map).doesNotContainValue(null);
        Assertions.assertThat(map).doesNotContainValue((Object)ResourceTestUtil.createRandomString());
    }

    @Test
    public void testValues() {
        Object[] values = new Object[100];
        ObjectMap<Integer, Object> map = this.populateMap(values);
        Collection result = map.values();
        int i = 0;
        while (i < 100) {
            Assertions.assertThat((Collection)result).contains(new Object[]{values[i]});
            ++i;
        }
    }

    @Test
    public void testKeySet() {
        Object[] values = new Object[100];
        ObjectMap<Integer, Object> map = this.populateMap(values);
        Set keys = map.keySet();
        Assertions.assertThat((Collection)keys).hasSize(100);
    }

    @Test
    public void testEntrySet() {
        Object[] values = new Object[100];
        ObjectMap<Integer, Object> map = this.populateMap(values);
        Set entries = map.entrySet();
        int i = 0;
        while (i < 100) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.contains(entries, values[i]), (String)("" + i));
            ++i;
        }
    }

    private boolean contains(Set<Map.Entry<Integer, Object>> set, Object value) {
        for (Map.Entry<Integer, Object> entry : set) {
            if (!entry.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    private ObjectMap<Integer, Object> populateMap(Object[] values) {
        ObjectMap map = new ObjectMap();
        int i = 0;
        while (i < values.length) {
            values[i] = System.currentTimeMillis();
            map.put((Object)i, values[i]);
            ++i;
        }
        Assertions.assertThat((Object[])values).hasSize(map.size());
        return map;
    }

    @Test
    public void testBug_62231() {
        ObjectMap map = new ObjectMap();
        map.entrySet();
        map.clear();
        map.entrySet();
    }
}

