/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.watson;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.eclipse.core.internal.watson.DefaultElementComparator;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.internal.watson.ElementTreeSerializationTestHelper;
import org.eclipse.core.tests.internal.watson.IPathConstants;
import org.eclipse.core.tests.internal.watson.TestUtil;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class DeltaFlatteningTest
implements IPathConstants {
    private ElementTree prepareTreeForChange() {
        ElementTree tree = TestUtil.createTestElementTree();
        ElementTree newTree = tree.newEmptyDelta();
        IPath project3 = solution.append("project3");
        IPath folder5 = project3.append("folder5");
        IPath file4 = project2.append("file4");
        IPath file5 = folder1.append("file5");
        newTree.createElement(project3, (Object)"project3");
        newTree.createElement(folder5, (Object)"folder5");
        newTree.deleteElement(file1);
        newTree.createElement(folder2, (Object)"ChangedData");
        newTree.createElement(file4, (Object)"file4");
        newTree.createElement(file5, (Object)"file5");
        newTree.deleteElement(folder3);
        newTree.immutable();
        TestUtil.assertHasPaths(newTree, new IPath[]{solution, project1, project2, project3, file2, file4, file5, folder1, folder2, folder4, folder5});
        TestUtil.assertNoPaths(newTree, new IPath[]{file1, file3, folder3});
        return newTree;
    }

    @ParameterizedTest
    @ArgumentsSource(value=ElementTreeSerializationTestHelper.class)
    public void test0(IPath path, int depth) throws IOException {
        ElementTree tree = TestUtil.createTestElementTree();
        IPath testTreeRootPath = solution;
        ElementTree treeForChange = this.prepareTreeForChange();
        ElementTreeSerializationTestHelper.StreamReader streamReader = (reader, input) -> reader.readDelta(treeForChange, (DataInput)input);
        ElementTreeSerializationTestHelper.StreamWriter streamWriter = (writer, output) -> writer.writeDelta(tree, treeForChange, testTreeRootPath, -1, (DataOutput)output, DefaultElementComparator.getComparator());
        ElementTree newTree = (ElementTree)ElementTreeSerializationTestHelper.doPipeTest(streamWriter, streamReader);
        TestUtil.assertEqualTrees(String.valueOf(this.getClass()) + "test0", tree, newTree, path, depth);
    }
}

