/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.watson;

import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.internal.watson.IPathConstants;
import org.eclipse.core.tests.internal.watson.TestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ElementTreeDeltaChainTest
implements IPathConstants {
    private static final IPath project3 = solution.append("project3");

    @Test
    public void testIllegalMerges() {
        ElementTree tree = TestUtil.createTestElementTree().newEmptyDelta();
        Assertions.assertThrows(RuntimeException.class, () -> {
            ElementTree elementTree2 = tree.mergeDeltaChain(solution, null);
        });
        ElementTree projectTree = new ElementTree();
        projectTree.createElement(solution, (Object)"Dummy");
        projectTree.createElement(project3, (Object)"project3");
        Object[] trees = TestUtil.doManyRoutineOperations(projectTree, project3);
        TestUtil.scramble(trees);
        Assertions.assertThrows(RuntimeException.class, () -> ElementTreeDeltaChainTest.lambda$1(tree, (ElementTree[])trees));
        Assertions.assertThrows(RuntimeException.class, () -> ElementTreeDeltaChainTest.lambda$2(tree, (ElementTree[])trees));
        Assertions.assertThrows(RuntimeException.class, () -> ElementTreeDeltaChainTest.lambda$3(tree, (ElementTree[])trees));
    }

    @Test
    public void testMergeDeltaChain() {
        ElementTree tree = TestUtil.createTestElementTree();
        ElementTree projectTree = new ElementTree();
        projectTree.createElement(solution, (Object)"Dummy");
        projectTree.createElement(project3, (Object)"project3");
        Object[] trees = TestUtil.doManyRoutineOperations(projectTree, project3);
        ElementTree copyTree = new ElementTree();
        copyTree.createElement(solution, (Object)"Dummy");
        copyTree.createElement(project3, (Object)"project3");
        Object[] copies = TestUtil.doManyRoutineOperations(copyTree, project3);
        TestUtil.scramble(trees, copies);
        TestUtil.doRoutineOperations(tree, solution);
        tree = tree.newEmptyDelta();
        ElementTree newTree = tree.mergeDeltaChain(project3, (ElementTree[])trees);
        Assertions.assertNotEquals((Object)newTree, (Object)tree);
        Assertions.assertFalse((boolean)newTree.isImmutable());
        int i = 0;
        while (i < trees.length) {
            TestUtil.assertEqualTrees("testMergeDeltaChain: " + i, copies[i].getSubtree(project3), trees[i].getSubtree(project3));
            ++i;
        }
        TestUtil.assertHasPaths(newTree, TestUtil.getTreePaths());
        TestUtil.assertHasPaths(newTree, new IPath[]{project3});
    }

    @Test
    public void testMergeOverwrite() {
        ElementTree tree = TestUtil.createTestElementTree();
        ElementTree projectTree = new ElementTree();
        projectTree.createElement(solution, (Object)"Dummy");
        projectTree.createElement(project3, (Object)"project3");
        Object[] trees = TestUtil.doManyRoutineOperations(tree, solution);
        TestUtil.scramble(trees);
        ElementTree newTree = projectTree.mergeDeltaChain(solution, (ElementTree[])trees);
        Assertions.assertNotEquals((Object)newTree, (Object)projectTree);
        Assertions.assertEquals((Object)"solution", (Object)newTree.getElementData(solution));
        TestUtil.assertTreeStructure(newTree);
    }

    private static /* synthetic */ void lambda$1(ElementTree elementTree, ElementTree[] elementTreeArray) throws Throwable {
        ElementTree elementTree2 = elementTree.mergeDeltaChain(null, elementTreeArray);
    }

    private static /* synthetic */ void lambda$2(ElementTree elementTree, ElementTree[] elementTreeArray) throws Throwable {
        ElementTree elementTree2 = elementTree.mergeDeltaChain(solution.append("bogosity"), elementTreeArray);
    }

    private static /* synthetic */ void lambda$3(ElementTree elementTree, ElementTree[] elementTreeArray) throws Throwable {
        elementTree.immutable();
        elementTree.mergeDeltaChain(solution, elementTreeArray);
    }
}

