/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.watson;

import org.eclipse.core.internal.events.ResourceComparator;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.IElementComparator;
import org.eclipse.core.internal.watson.IElementTreeData;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.internal.watson.IPathConstants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ElementTreeHasChangesTest
implements IPathConstants {
    @Test
    public void testNoChanges() {
        ElementTree oldTree = ElementTreeHasChangesTest.createTree(solution, project1, project2, file1);
        ElementTree newTree = ElementTreeHasChangesTest.newTree(oldTree);
        boolean hasChanges = ElementTreeHasChangesTest.hasChanges(oldTree, newTree);
        Assertions.assertFalse((boolean)hasChanges, (String)"expected no changes to be detected if the tree was not changed");
    }

    @Test
    public void testAddElement() {
        ElementTree oldTree = ElementTreeHasChangesTest.createTree(solution, project1, project2, file1);
        ElementTree newTree = ElementTreeHasChangesTest.newTree(oldTree);
        ElementTreeHasChangesTest.add(newTree, folder1);
        boolean hasChanges = ElementTreeHasChangesTest.hasChanges(oldTree, newTree);
        Assertions.assertTrue((boolean)hasChanges, (String)"expected changes to be detected after adding an element to the tree");
    }

    @Test
    public void testRemoveElement() {
        ElementTree oldTree = ElementTreeHasChangesTest.createTree(solution, project1, project2, file1);
        ElementTree newTree = ElementTreeHasChangesTest.newTree(oldTree);
        ElementTreeHasChangesTest.remove(newTree, file1);
        boolean hasChanges = ElementTreeHasChangesTest.hasChanges(oldTree, newTree);
        Assertions.assertTrue((boolean)hasChanges, (String)"expected changes to be detected after removing an element from the tree");
    }

    @Test
    public void testAddAndRemoveElement() {
        ElementTree oldTree = ElementTreeHasChangesTest.createTree(solution, project1, project2, file1);
        ElementTree newTree = ElementTreeHasChangesTest.newTree(oldTree);
        ElementTreeHasChangesTest.add(newTree, folder1);
        ElementTreeHasChangesTest.remove(newTree, folder1);
        boolean hasChanges = ElementTreeHasChangesTest.hasChanges(oldTree, newTree);
        Assertions.assertTrue((boolean)hasChanges, (String)"expected changes to be detected after adding and removing the same element to and from the tree");
    }

    @Test
    public void testChangeElementData() {
        IPath[] elements1 = new IPath[]{solution, project1, project2, file1};
        ElementTree oldTree = ElementTreeHasChangesTest.createTree(elements1);
        ElementTree newTree = ElementTreeHasChangesTest.newTree(oldTree);
        newTree.setElementData(file1, (Object)"different data");
        boolean hasChanges = ElementTreeHasChangesTest.hasChanges(oldTree, newTree);
        Assertions.assertTrue((boolean)hasChanges, (String)"expected changes to be detected after changing the data of a tree element");
    }

    @Test
    public void testChangeTreeData() {
        IPath[] elements1 = new IPath[]{solution, project1, project2, file1};
        ElementTree oldTree = ElementTreeHasChangesTest.createTree(elements1);
        ElementTreeHasChangesTest.incrementCharsetGenerationCount(oldTree);
        ElementTree newTree = ElementTreeHasChangesTest.newTree(oldTree);
        ElementTreeHasChangesTest.incrementCharsetGenerationCount(newTree);
        boolean hasChanges = ElementTreeHasChangesTest.hasChanges(oldTree, newTree);
        Assertions.assertTrue((boolean)hasChanges, (String)"expected changes to be detected after changing the data of the tree");
    }

    private static boolean hasChanges(ElementTree oldTree, ElementTree newTree) {
        return ElementTree.hasChanges((ElementTree)oldTree, (ElementTree)newTree, (IElementComparator)ResourceComparator.getBuildComparator(), (boolean)true);
    }

    private static ElementTree createTree(IPath ... paths) {
        ElementTree tree = new ElementTree();
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            ElementTreeHasChangesTest.add(tree, path);
            ++n2;
        }
        return tree;
    }

    private static void incrementCharsetGenerationCount(ElementTree tree) {
        ResourceInfo resourceInfo;
        IElementTreeData treeData = tree.getTreeData();
        if (treeData instanceof ResourceInfo) {
            ResourceInfo ri;
            resourceInfo = ri = (ResourceInfo)treeData;
        } else {
            resourceInfo = new ResourceInfo();
            tree.setTreeData((IElementTreeData)resourceInfo);
        }
        resourceInfo.incrementCharsetGenerationCount();
    }

    private static ElementTree newTree(ElementTree oldTree) {
        return oldTree.newEmptyDelta();
    }

    private static void add(ElementTree tree, IPath path) {
        tree.createElement(path, (Object)path.lastSegment());
    }

    private static void remove(ElementTree tree, IPath path) {
        tree.deleteElement(path);
    }
}

