/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.watson;

import java.util.ArrayList;
import java.util.Stack;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeIterator;
import org.eclipse.core.internal.watson.IElementContentVisitor;
import org.eclipse.core.internal.watson.IElementTreeData;
import org.eclipse.core.runtime.IPath;
import org.junit.jupiter.api.Test;

public class ElementTreeIteratorTest {
    static void setupElementTree(ElementTree tree, int num) {
        IElementTreeData data = new IElementTreeData(){

            public Object clone() {
                try {
                    return super.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    return null;
                }
            }
        };
        IPath sol = IPath.ROOT.append("sol");
        tree.createElement(sol, (Object)data);
        int p = 0;
        while (p < num) {
            IPath proj = sol.append("proj" + p);
            tree.createElement(proj, (Object)data);
            int k = 0;
            while (k < num) {
                IPath folder = proj.append("folder" + k);
                tree.createElement(folder, (Object)data);
                int c = 0;
                while (c < num) {
                    IPath file = folder.append("file" + c);
                    tree.createElement(file, (Object)data);
                    ++c;
                }
                ++k;
            }
            ++p;
        }
    }

    @Test
    public void testConcurrentModification() {
        ElementTree baseTree = new ElementTree();
        int n = 3;
        ElementTreeIteratorTest.setupElementTree(baseTree, n);
        baseTree.immutable();
        ElementTree tree = baseTree.newEmptyDelta();
        this.modifyTree(tree);
        ArrayList elts = new ArrayList();
        IElementContentVisitor visitor = (tree1, requestor, info) -> {
            elts.add(info);
            return true;
        };
        Thread reader = new Thread(() -> {
            int i = 0;
            while (i < 80000) {
                new ElementTreeIterator(tree, IPath.ROOT).iterate(visitor);
                ++i;
            }
        }, "Holmes (reader)");
        Thread writer = new Thread(() -> {
            int i = 0;
            while (i < 1000) {
                this.modifyTree(tree);
                this.recursiveDelete(tree, IPath.ROOT);
                ElementTreeIteratorTest.setupElementTree(tree, 3);
                ++i;
            }
        }, "Doyle (writer)");
        reader.start();
        writer.start();
        try {
            reader.join();
            writer.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void testContentIterator() {
        ElementTree tree = new ElementTree();
        int n = 3;
        ElementTreeIteratorTest.setupElementTree(tree, n);
        ArrayList elts = new ArrayList();
        IElementContentVisitor elementVisitor = (tree1, requestor, info) -> {
            elts.add(requestor.requestPath());
            return true;
        };
        new ElementTreeIterator(tree, IPath.ROOT).iterate(elementVisitor);
        Assertions.assertThat(elts).hasSize(2 + n + n * n + n * n * n);
        elts.clear();
        IPath innerElement = IPath.ROOT.append("sol").append("proj1");
        new ElementTreeIterator(tree, innerElement).iterate(elementVisitor);
        Assertions.assertThat(elts).hasSize(1 + n + n * n);
    }

    void recursiveDelete(ElementTree tree, IPath path) {
        IPath[] children;
        IPath[] iPathArray = children = tree.getChildren(path);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IPath element = iPathArray[n2];
            this.recursiveDelete(tree, element);
            ++n2;
        }
        tree.deleteElement(path);
    }

    protected void modifyTree(ElementTree tree) {
        class MyStack
        extends Stack<IPath> {
            private static final long serialVersionUID = 1L;

            MyStack() {
            }

            public void pushAll(IPath[] array) {
                IPath[] iPathArray = array;
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath element = iPathArray[n2];
                    this.push(element);
                    ++n2;
                }
            }
        }
        MyStack toModify = new MyStack();
        IPath[] children = tree.getChildren(IPath.ROOT);
        toModify.pushAll(children);
        while (!toModify.isEmpty()) {
            IPath visit = (IPath)toModify.pop();
            tree.openElementData(visit);
            toModify.pushAll(tree.getChildren(visit));
        }
    }
}

