/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.watson;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.eclipse.core.internal.watson.ElementTreeReader;
import org.eclipse.core.internal.watson.ElementTreeWriter;
import org.eclipse.core.internal.watson.IElementInfoFlattener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.internal.watson.TestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;

public final class ElementTreeSerializationTestHelper
implements ArgumentsProvider {
    private ElementTreeSerializationTestHelper() {
    }

    public Stream<Arguments> provideArguments(ExtensionContext context) {
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        IPath[] paths = TestUtil.getTreePaths();
        int[] depths = ElementTreeSerializationTestHelper.getTreeDepths();
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            int[] nArray = depths;
            int n3 = depths.length;
            int n4 = 0;
            while (n4 < n3) {
                int depth = nArray[n4];
                arguments.add(Arguments.of((Object[])new Object[]{path, depth}));
                ++n4;
            }
            ++n2;
        }
        return arguments.stream();
    }

    private static int[] getTreeDepths() {
        int[] nArray = new int[6];
        nArray[0] = -1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 3;
        nArray[5] = 4;
        return nArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object doFileTest(Path tempDir, StreamReader reading, StreamWriter writing) throws IOException {
        IElementInfoFlattener fac = ElementTreeSerializationTestHelper.getFlattener();
        Object newTree = null;
        ElementTreeWriter writer = new ElementTreeWriter(fac);
        ElementTreeReader reader = new ElementTreeReader(fac);
        Files.createDirectories(tempDir, new FileAttribute[0]);
        Path tempFile = tempDir.resolve("TestFlattening");
        Throwable throwable = null;
        Object var9_11 = null;
        try (OutputStream fos = Files.newOutputStream(tempFile, new OpenOption[0]);){
            DataOutputStream dos = new DataOutputStream(fos);
            writing.doWrite(writer, dos);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            } else {
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var9_11 = null;
        try {
            InputStream fis = Files.newInputStream(tempFile, new OpenOption[0]);
            try {
                try (DataInputStream dis = new DataInputStream(fis);){
                    newTree = reading.doRead(reader, dis);
                }
                if (fis == null) return newTree;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            fis.close();
            return newTree;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            } else {
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object doPipeTest(StreamWriter streamWriter, StreamReader streamReader) throws IOException {
        IElementInfoFlattener fac = ElementTreeSerializationTestHelper.getFlattener();
        Object refried = null;
        ElementTreeWriter w = new ElementTreeWriter(fac);
        ElementTreeReader r = new ElementTreeReader(fac);
        Throwable throwable = null;
        Object var7_8 = null;
        try {
            PipedOutputStream pout = new PipedOutputStream();
            try {
                block28: {
                    PipedInputStream pin = new PipedInputStream(pout);
                    try {
                        block27: {
                            DataOutputStream oos = new DataOutputStream(pout);
                            try {
                                try (DataInputStream ois = new DataInputStream(pin);){
                                    WriterThread writerThread = new WriterThread(streamWriter, oos, w);
                                    ReaderThread readerThread = new ReaderThread(streamReader, ois, r);
                                    Thread thread1 = new Thread((Runnable)writerThread, "testwriter");
                                    Thread thread2 = new Thread((Runnable)readerThread, "testreader");
                                    thread1.start();
                                    thread2.start();
                                    while (true) {
                                        if (!thread2.isAlive()) {
                                            Assertions.assertNull((Object)writerThread.getExceptionDuringRun(), (String)"exception occurred during write");
                                            Assertions.assertNull((Object)readerThread.getExceptionDuringRun(), (String)"exception occurred during read");
                                            refried = readerThread.getReconstitutedObject();
                                            break;
                                        }
                                        try {
                                            thread2.join();
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (oos == null) break block27;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (oos == null) throw throwable;
                                oos.close();
                                throw throwable;
                            }
                            oos.close();
                        }
                        if (pin == null) break block28;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (pin == null) throw throwable;
                        pin.close();
                        throw throwable;
                    }
                    pin.close();
                }
                if (pout == null) return refried;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                if (pout == null) throw throwable;
                pout.close();
                throw throwable;
            }
            pout.close();
            return refried;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    private static IElementInfoFlattener getFlattener() {
        return new IElementInfoFlattener(){

            public void writeElement(IPath path, Object data, DataOutput output) throws IOException {
                if (data == null) {
                    output.writeUTF("null");
                } else {
                    output.writeUTF((String)data);
                }
            }

            public Object readElement(IPath path, DataInput input) throws IOException {
                String data = input.readUTF();
                if ("null".equals(data)) {
                    return null;
                }
                return data;
            }
        };
    }

    private static class ReaderThread
    implements Runnable {
        private final StreamReader streamReader;
        private final DataInputStream dataInputStream;
        private final ElementTreeReader treeReader;
        private Object refried;
        private volatile IOException exceptionDuringRun;

        ReaderThread(StreamReader streamReader, DataInputStream stream, ElementTreeReader reader) {
            this.streamReader = streamReader;
            this.dataInputStream = stream;
            this.treeReader = reader;
        }

        public Object getReconstitutedObject() {
            return this.refried;
        }

        public IOException getExceptionDuringRun() {
            return this.exceptionDuringRun;
        }

        @Override
        public void run() {
            try {
                this.refried = this.streamReader.doRead(this.treeReader, this.dataInputStream);
            }
            catch (IOException e) {
                this.exceptionDuringRun = e;
            }
        }
    }

    static interface StreamReader {
        public Object doRead(ElementTreeReader var1, DataInputStream var2) throws IOException;
    }

    static interface StreamWriter {
        public void doWrite(ElementTreeWriter var1, DataOutputStream var2) throws IOException;
    }

    private static class WriterThread
    implements Runnable {
        private final StreamWriter streamWriter;
        private DataOutputStream dataOutputStream;
        private ElementTreeWriter treeWriter;
        private volatile IOException exceptionDuringRun;

        WriterThread(StreamWriter streamWriter, DataOutputStream stream, ElementTreeWriter treeWriter) {
            this.streamWriter = streamWriter;
            this.dataOutputStream = stream;
            this.treeWriter = treeWriter;
        }

        public IOException getExceptionDuringRun() {
            return this.exceptionDuringRun;
        }

        @Override
        public void run() {
            try {
                this.streamWriter.doWrite(this.treeWriter, this.dataOutputStream);
                this.dataOutputStream.flush();
            }
            catch (IOException e) {
                this.exceptionDuringRun = e;
            }
        }
    }
}

