/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.watson;

import java.util.ArrayList;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.IElementComparator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.internal.watson.IPathConstants;
import org.eclipse.core.tests.internal.watson.TestElementComparator;

class TestUtil
implements IPathConstants {
    static final IElementComparator fComparator = TestElementComparator.getComparator();

    TestUtil() {
    }

    protected static void assertEqualTrees(String message, ElementTree expected, ElementTree actual) {
        TestUtil.assertEqualTrees(message, expected, actual, IPath.ROOT, -1);
    }

    protected static void assertEqualTrees(String message, ElementTree expected, ElementTree actual, IPath path) {
        TestUtil.assertEqualTrees(message, expected, actual, path, -1);
    }

    protected static void assertEqualTrees(String msg, ElementTree expected, ElementTree actual, IPath path, int depth) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expected.includes(path), (String)msg);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)actual.includes(path), (String)msg);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected.getElementData(path), (Object)actual.getElementData(path), (String)msg);
        if (depth != 0) {
            IPath[] expectedChildren = expected.getChildren(path);
            Object[] actualChildren = actual.getChildren(path);
            ((ObjectArrayAssert)Assertions.assertThat((Object[])actualChildren).describedAs("Number of children", new Object[0])).hasSameSizeAs((Object)expectedChildren);
            int newDepth = depth;
            if (depth != -1) {
                --newDepth;
            }
            int i = 0;
            while (i < expectedChildren.length) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)expectedChildren[i], (Object)actualChildren[i], (String)"children IDs");
                TestUtil.assertEqualTrees("Recursive call", expected, actual, expectedChildren[i], newDepth);
                ++i;
            }
        }
    }

    protected static void assertHasPaths(ElementTree tree, IPath[] paths) {
        int i = 0;
        while (i < paths.length) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tree.includes(paths[i]), (String)("assertHasPaths" + i));
            ++i;
        }
    }

    protected static void assertNoPaths(ElementTree tree, IPath[] paths) {
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tree.includes(path), (String)("assertNoPaths: " + String.valueOf(path)));
            ++n2;
        }
    }

    protected static void assertTreeStructure(ElementTree tree) {
        TestUtil.assertHasPaths(tree, TestUtil.getTreePaths());
        Object[] children = tree.getChildren(IPath.ROOT);
        Assertions.assertThat((Object[])children).hasSize(1);
        children = tree.getChildren((IPath)children[0]);
        Assertions.assertThat((Object[])children).hasSize(2);
        Assertions.assertThat((Object[])tree.getChildren(project1)).isEmpty();
        children = tree.getChildren((IPath)children[1]);
        Assertions.assertThat((Object[])children).hasSize(3);
        Assertions.assertThat((Object[])tree.getChildren(file1)).isEmpty();
        Assertions.assertThat((Object[])tree.getChildren(folder2)).isEmpty();
        children = tree.getChildren((IPath)children[1]);
        Assertions.assertThat((Object[])children).hasSize(3);
        Assertions.assertThat((Object[])tree.getChildren(file2)).isEmpty();
        Assertions.assertThat((Object[])tree.getChildren(folder4)).isEmpty();
        children = tree.getChildren((IPath)children[1]);
        Assertions.assertThat((Object[])children).hasSize(1);
        Assertions.assertThat((Object[])tree.getChildren(file3)).isEmpty();
    }

    static ElementTree createTestElementTree() {
        ElementTree tree = new ElementTree();
        tree.createElement(solution, (Object)"solution");
        tree.createElement(project1, (Object)"project1");
        tree.createElement(project2, (Object)"project2");
        tree.createElement(file1, (Object)"file1");
        tree.createElement(folder1, (Object)"folder1");
        tree.createElement(folder2, (Object)"folder2");
        tree.createElement(file2, (Object)"file2");
        tree.createElement(folder3, (Object)"folder3");
        tree.createElement(folder4, (Object)"folder4");
        tree.createElement(file3, (Object)"file3");
        return tree;
    }

    protected static ElementTree[] doManyRoutineOperations(ElementTree tree, IPath path) {
        IPath[] files;
        ArrayList<ElementTree> trees = new ArrayList<ElementTree>();
        trees.add(tree);
        int repeat = 1;
        tree = tree.newEmptyDelta();
        IPath[] iPathArray = files = TestUtil.getFilePaths(path);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IPath file = iPathArray[n2];
            String data = file.toString();
            tree.createElement(file, (Object)data);
            tree.immutable();
            trees.add(tree);
            tree = tree.newEmptyDelta();
            ++n2;
        }
        int i = 0;
        while (i < repeat) {
            String data = "data" + i;
            IPath[] iPathArray2 = files;
            int n3 = files.length;
            int n4 = 0;
            while (n4 < n3) {
                IPath file = iPathArray2[n4];
                tree.setElementData(file, (Object)data);
                tree.immutable();
                trees.add(tree);
                tree = tree.newEmptyDelta();
                ++n4;
            }
            ++i;
        }
        iPathArray = files;
        n = files.length;
        int n5 = 0;
        while (n5 < n) {
            IPath file = iPathArray[n5];
            tree.deleteElement(file);
            tree.immutable();
            trees.add(tree);
            tree = tree.newEmptyDelta();
            ++n5;
        }
        ElementTree[] results = new ElementTree[trees.size()];
        trees.toArray(results);
        return results;
    }

    protected static ElementTree[] doRoutineOperations(ElementTree tree, IPath path) {
        IPath[] files;
        ArrayList<ElementTree> trees = new ArrayList<ElementTree>();
        trees.add(tree);
        int repeat = 1;
        tree = tree.newEmptyDelta();
        IPath[] iPathArray = files = TestUtil.getFilePaths(path);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IPath file = iPathArray[n2];
            String data = file.toString();
            tree.createElement(file, (Object)data);
            ++n2;
        }
        tree.immutable();
        trees.add(tree);
        tree = tree.newEmptyDelta();
        int i = 0;
        while (i < repeat) {
            String data = "data" + i;
            IPath[] iPathArray2 = files;
            int n3 = files.length;
            int n4 = 0;
            while (n4 < n3) {
                IPath file = iPathArray2[n4];
                tree.setElementData(file, (Object)data);
                ++n4;
            }
            ++i;
        }
        tree.immutable();
        trees.add(tree);
        tree = tree.newEmptyDelta();
        iPathArray = files;
        n = files.length;
        int n5 = 0;
        while (n5 < n) {
            IPath file = iPathArray[n5];
            tree.deleteElement(file);
            ++n5;
        }
        tree.immutable();
        trees.add(tree);
        ElementTree[] results = new ElementTree[trees.size()];
        trees.toArray(results);
        return results;
    }

    protected static IPath[] getFilePaths(IPath project3) {
        String[] names = TestUtil.getJavaLangUnits();
        IPath[] paths = new IPath[names.length];
        int i = 0;
        while (i < paths.length) {
            paths[i] = project3.append(names[i]);
            ++i;
        }
        return paths;
    }

    protected static String[] getJavaLangUnits() {
        return new String[]{"AbstractMethodError.java", "ArithmeticException.java", "ArrayIndexOutOfBoundsException.java", "ArrayStoreException.java", "Boolean.java", "Byte.java", "Character.java", "Class.java", "ClassCastException.java", "ClassCircularityError.java", "ClassFormatError.java", "ClassLoader.java", "ClassNotFoundException.java", "Cloneable.java", "CloneNotSupportedException.java", "Compiler.java", "Double.java", "Error.java"};
    }

    protected static IPath[] getTreePaths() {
        return new IPath[]{solution, project1, project2, folder1, folder2, folder3, folder4, file1, file2, file3};
    }

    protected static void scramble(Object[] first) {
        Random random = new Random(System.currentTimeMillis());
        int len = first.length;
        int i = 0;
        while (i < len * 100) {
            int off2;
            int off1 = (int)(random.nextFloat() * (float)len);
            if (off1 != len && (off2 = (int)(random.nextFloat() * (float)len)) != len) {
                Object temp = first[off1];
                first[off1] = first[off2];
                first[off2] = temp;
            }
            ++i;
        }
    }

    protected static void scramble(Object[] first, Object[] second) {
        Assertions.assertThat((Object[])first).hasSameSizeAs((Object)second);
        Random random = new Random(System.currentTimeMillis());
        int len = first.length;
        int i = 0;
        while (i < len * 100) {
            int off2;
            int off1 = (int)(random.nextFloat() * (float)len);
            if (off1 != len && (off2 = (int)(random.nextFloat() * (float)len)) != len) {
                Object temp = first[off1];
                first[off1] = first[off2];
                first[off2] = temp;
                temp = second[off1];
                second[off1] = second[off2];
                second[off2] = temp;
            }
            ++i;
        }
    }
}

