/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.watson;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Path;
import org.eclipse.core.internal.resources.SaveManager;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.internal.watson.ElementTreeSerializationTestHelper;
import org.eclipse.core.tests.internal.watson.IPathConstants;
import org.eclipse.core.tests.internal.watson.TestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class TreeFlatteningTest
implements IPathConstants {
    private ElementTreeSerializationTestHelper.StreamReader getReader() throws IOException {
        return (reader, input) -> reader.readTree((DataInput)input);
    }

    private ElementTreeSerializationTestHelper.StreamWriter getWriter(ElementTree tree, IPath path, int depth) throws IOException {
        return (writer, output) -> writer.writeTree(tree, path, depth, (DataOutput)output);
    }

    @Test
    public void test0(@TempDir Path tempDir) throws IOException {
        ElementTree tree = TestUtil.createTestElementTree();
        IPath testTreeRootPath = IPathConstants.solution;
        ElementTree newTree = (ElementTree)ElementTreeSerializationTestHelper.doFileTest(tempDir, this.getReader(), this.getWriter(tree, testTreeRootPath, -1));
        TestUtil.assertEqualTrees(String.valueOf(this.getClass()) + "test0", tree, newTree);
    }

    @Test
    public void testSortTreesError() {
        ElementTree tree1 = new ElementTree();
        ElementTree tree11 = tree1.newEmptyDelta();
        ElementTree tree111 = tree11.newEmptyDelta();
        ElementTree tree1111 = tree111.newEmptyDelta();
        Assertions.assertFalse((boolean)tree1111.isImmutable());
        Assertions.assertTrue((boolean)tree111.isImmutable());
        Assertions.assertTrue((boolean)tree11.isImmutable());
        Assertions.assertTrue((boolean)tree1.isImmutable());
        ElementTree[] trees = new ElementTree[]{tree1, tree11, tree111, tree1111};
        ElementTree[] sorted = SaveManager.sortTrees((ElementTree[])trees);
        Assertions.assertNull((Object)sorted);
    }

    @Test
    public void testSortTrees() {
        ElementTree tree1 = new ElementTree();
        ElementTree tree11 = tree1.newEmptyDelta();
        ElementTree tree111 = tree11.newEmptyDelta();
        ElementTree tree1111 = tree111.newEmptyDelta();
        Assertions.assertFalse((boolean)tree1111.isImmutable());
        tree1111.newEmptyDelta();
        Assertions.assertTrue((boolean)tree1111.isImmutable());
        Assertions.assertSame((Object)tree1.getParent(), (Object)tree11);
        Assertions.assertSame((Object)tree11.getParent(), (Object)tree111);
        Assertions.assertSame((Object)tree111.getParent(), (Object)tree1111);
        Assertions.assertSame((Object)tree1111.getParent(), null);
        ElementTree[] trees12 = new ElementTree[]{tree1, tree11, tree111, tree1111};
        ElementTree[] trees21 = this.reversed(trees12);
        int oldest12 = ElementTree.findOldest((ElementTree[])trees12);
        int oldest21 = ElementTree.findOldest((ElementTree[])trees21);
        Assertions.assertSame((Object)trees12[oldest12], (Object)trees21[oldest21]);
        Assertions.assertSame((Object)trees12[oldest12], (Object)tree1);
        System.out.println("oldest=" + trees12[oldest12].toDebugString());
        Object[] sorted12 = SaveManager.sortTrees((ElementTree[])trees12);
        Object[] sorted21 = SaveManager.sortTrees((ElementTree[])trees21);
        Assertions.assertArrayEquals((Object[])sorted12, (Object[])sorted21);
        Assertions.assertSame((Object)tree1111, (Object)sorted12[0]);
        trees12 = new ElementTree[]{tree1, tree1, tree11, tree11, tree111, tree111, tree1111, tree1111};
        trees21 = this.reversed(trees12);
        oldest12 = ElementTree.findOldest((ElementTree[])trees12);
        oldest21 = ElementTree.findOldest((ElementTree[])trees21);
        Assertions.assertSame((Object)trees12[oldest12], (Object)trees21[oldest21]);
        Assertions.assertSame((Object)trees12[oldest12], (Object)tree1);
        System.out.println("oldest=" + trees12[oldest12].toDebugString());
        sorted12 = SaveManager.sortTrees((ElementTree[])trees12);
        sorted21 = SaveManager.sortTrees((ElementTree[])trees21);
        Assertions.assertArrayEquals((Object[])sorted12, (Object[])sorted21);
        Assertions.assertSame((Object)tree1111, (Object)sorted12[0]);
        trees12 = new ElementTree[]{tree1, tree1, tree1111, tree1111};
        trees21 = this.reversed(trees12);
        oldest12 = ElementTree.findOldest((ElementTree[])trees12);
        oldest21 = ElementTree.findOldest((ElementTree[])trees21);
        Assertions.assertSame((Object)trees12[oldest12], (Object)trees21[oldest21]);
        Assertions.assertSame((Object)trees12[oldest12], (Object)tree1);
        System.out.println("oldest=" + trees12[oldest12].toDebugString());
        sorted12 = SaveManager.sortTrees((ElementTree[])trees12);
        sorted21 = SaveManager.sortTrees((ElementTree[])trees21);
        Assertions.assertArrayEquals((Object[])sorted12, (Object[])sorted21);
        Assertions.assertSame((Object)tree1111, (Object)sorted12[0]);
        trees12 = new ElementTree[]{tree1, tree111};
        trees21 = this.reversed(trees12);
        oldest12 = ElementTree.findOldest((ElementTree[])trees12);
        oldest21 = ElementTree.findOldest((ElementTree[])trees21);
        Assertions.assertSame((Object)trees12[oldest12], (Object)trees21[oldest21]);
        Assertions.assertSame((Object)trees12[oldest12], (Object)tree1);
        System.out.println("oldest=" + trees12[oldest12].toDebugString());
        sorted12 = SaveManager.sortTrees((ElementTree[])trees12);
        sorted21 = SaveManager.sortTrees((ElementTree[])trees21);
        Assertions.assertArrayEquals((Object[])sorted12, (Object[])sorted21);
        Assertions.assertSame((Object)tree111, (Object)sorted12[0]);
        trees12 = new ElementTree[]{tree11, tree1111};
        trees21 = this.reversed(trees12);
        oldest12 = ElementTree.findOldest((ElementTree[])trees12);
        oldest21 = ElementTree.findOldest((ElementTree[])trees21);
        Assertions.assertSame((Object)trees12[oldest12], (Object)trees21[oldest21]);
        Assertions.assertSame((Object)trees12[oldest12], (Object)tree11);
        System.out.println("oldest=" + trees12[oldest12].toDebugString());
        sorted12 = SaveManager.sortTrees((ElementTree[])trees12);
        sorted21 = SaveManager.sortTrees((ElementTree[])trees21);
        Assertions.assertArrayEquals((Object[])sorted12, (Object[])sorted21);
        Assertions.assertSame((Object)tree1111, (Object)sorted12[0]);
        trees12 = new ElementTree[]{tree1, tree11, tree11, tree11, tree111, tree1111, tree1111, tree1111};
        trees21 = this.reversed(trees12);
        oldest12 = ElementTree.findOldest((ElementTree[])trees12);
        oldest21 = ElementTree.findOldest((ElementTree[])trees21);
        Assertions.assertSame((Object)trees12[oldest12], (Object)trees21[oldest21]);
        Assertions.assertSame((Object)trees12[oldest12], (Object)tree1);
        System.out.println("oldest=" + trees12[oldest12].toDebugString());
        sorted12 = SaveManager.sortTrees((ElementTree[])trees12);
        sorted21 = SaveManager.sortTrees((ElementTree[])trees21);
        Assertions.assertArrayEquals((Object[])sorted12, (Object[])sorted21);
        Assertions.assertSame((Object)tree1111, (Object)sorted12[0]);
    }

    private ElementTree[] reversed(ElementTree[] trees) {
        ElementTree[] result = new ElementTree[trees.length];
        int i = 0;
        while (i < trees.length) {
            result[i] = trees[trees.length - i - 1];
            ++i;
        }
        return result;
    }

    @ParameterizedTest
    @ArgumentsSource(value=ElementTreeSerializationTestHelper.class)
    public void testExhaustive(IPath path, int depth) throws IOException {
        ElementTree tree = TestUtil.createTestElementTree();
        ElementTree newTree = (ElementTree)ElementTreeSerializationTestHelper.doPipeTest(this.getWriter(tree, path, depth), this.getReader());
        TestUtil.assertEqualTrees(String.valueOf(this.getClass()) + "test0", tree, newTree, path, depth);
    }

    @Test
    public void testNullData() throws IOException {
        ElementTree tree = TestUtil.createTestElementTree();
        tree = tree.newEmptyDelta();
        IPath testTreeRootPath = IPathConstants.solution;
        tree.setElementData(IPathConstants.solution, null);
        tree.setElementData(IPathConstants.folder2, null);
        tree.immutable();
        ElementTree newTree = (ElementTree)ElementTreeSerializationTestHelper.doPipeTest(this.getWriter(tree, testTreeRootPath, -1), this.getReader());
        TestUtil.assertEqualTrees(String.valueOf(this.getClass()) + "test0", tree, newTree);
    }

    @Test
    public void testWriteRoot() throws IOException {
        ElementTree tree = TestUtil.createTestElementTree();
        IPath path = IPath.ROOT;
        ElementTree newTree = (ElementTree)ElementTreeSerializationTestHelper.doPipeTest(this.getWriter(tree, path, -1), this.getReader());
        TestUtil.assertEqualTrees(String.valueOf(this.getClass()) + "test0", tree, newTree, path);
    }
}

