/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.internal.events.NotificationManager;
import org.eclipse.core.internal.resources.CharsetManager;
import org.eclipse.core.internal.resources.ValidateProjectEncoding;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.tests.resources.ContentDescriptionManagerTest;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.TestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CharsetTest {
    @Rule
    public TestName testName = new TestName();
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    static final String SAMPLE_SPECIFIC_XML = "<?xml version=\"1.0\"?><org.eclipse.core.tests.resources.anotherXML/>";
    private static final String SAMPLE_XML_DEFAULT_ENCODING = "<?xml version=\"1.0\"?><org.eclipse.core.resources.tests.root/>";
    static final String SAMPLE_XML_ISO_8859_1_ENCODING = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><org.eclipse.core.resources.tests.root/>";
    static final String SAMPLE_XML_US_ASCII_ENCODING = "<?xml version=\"1.0\" encoding=\"US-ASCII\"?><org.eclipse.core.resources.tests.root/>";
    static final String SAMPLE_DERIVED_ENCODING_TO_FALSE_REGULAR_PREFS = "#Mon Nov 15 17:54:11 CET 2010\nseparateDerivedEncodings=false\neclipse.preferences.version=1";
    static final String[] SAMPLE_DERIVED_ENCODING_AFTER_FALSE_REGULAR_PREFS = new String[]{"separateDerivedEncodings=false", "encoding//b1/a.txt=UTF-8", "eclipse.preferences.version=1"};
    static final String SAMPLE_DERIVED_ENCODING_TO_TRUE_REGULAR_PREFS = "#Mon Nov 15 17:54:11 CET 2010\nseparateDerivedEncodings=true\nencoding//b1/a.txt=UTF-8\neclipse.preferences.version=1";
    static final String[] SAMPLE_DERIVED_ENCODING_AFTER_TRUE_REGULAR_PREFS = new String[]{"separateDerivedEncodings=true", "eclipse.preferences.version=1"};
    static final String[] SAMPLE_DERIVED_ENCODING_AFTER_TRUE_DERIVED_PREFS = new String[]{"encoding//b1/a.txt=UTF-8", "eclipse.preferences.version=1"};
    private String savedWorkspaceCharset;

    @Test
    @Ignore(value="disabled due to bug 67606")
    public void testBug67606() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("MyProject");
        try {
            IFile file = project.getFile("file.txt");
            ResourceTestUtil.createInWorkspace((IResource)file);
            project.setDefaultCharset("FOO", ResourceTestUtil.createTestMonitor());
            workspace.run(monitor -> {
                Assert.assertEquals((String)"0.9", (Object)"FOO", (Object)file.getCharset());
                file.setCharset("BAR", ResourceTestUtil.createTestMonitor());
                Assert.assertEquals((String)"1.0", (Object)"BAR", (Object)file.getCharset());
                file.move(project.getFullPath().append("file2.txt"), 0, monitor);
                IFile file2 = project.getFile("file2.txt");
                ResourceTestUtil.assertExistsInWorkspace((IResource)file2);
                Assert.assertEquals((String)"2.0", (Object)"BAR", (Object)file.getCharset());
            }, null);
        }
        finally {
            ResourceTestUtil.removeFromWorkspace((IResource)project);
        }
    }

    @Test
    public void testCharsetMoveOnFileMove() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("MyProject");
        try {
            IFile file = project.getFile("file.txt");
            ResourceTestUtil.createInWorkspace((IResource)file);
            project.setDefaultCharset("FOO", ResourceTestUtil.createTestMonitor());
            Assert.assertEquals((String)"Setting up Projects default charset was successful", (Object)"FOO", (Object)file.getCharset());
            file.setCharset("BAR", ResourceTestUtil.createTestMonitor());
            Assert.assertEquals((String)"Setting up file's explicit charset was successful", (Object)"BAR", (Object)file.getCharset());
            file.move(project.getFullPath().append("file2.txt"), 0, ResourceTestUtil.createTestMonitor());
            IFile file2 = project.getFile("file2.txt");
            ResourceTestUtil.assertExistsInWorkspace((IResource)file2);
            Assert.assertEquals((String)"The file's charset was correctly copied while coying the file", (Object)"BAR", (Object)file2.getCharset());
        }
        finally {
            ResourceTestUtil.removeFromWorkspace((IResource)project);
        }
    }

    @Test
    @Ignore(value="https://github.com/eclipse-platform/eclipse.platform/issues/634")
    public void testCopyFileCopiesCharset() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("MyProject");
        try {
            project.create(ResourceTestUtil.createTestMonitor());
            project.open(ResourceTestUtil.createTestMonitor());
            IFile file = project.getFile("file.txt");
            ResourceTestUtil.createInWorkspace((IResource)file);
            file.setCharset("FOO", ResourceTestUtil.createTestMonitor());
            Assert.assertEquals((String)"File charset correctly set", (Object)file.getCharset(true), (Object)"FOO");
            file.copy(project.getFullPath().append("file2.txt"), 0, ResourceTestUtil.createTestMonitor());
            IFile copiedFile = project.getFile("file2.txt");
            Assert.assertEquals((String)"File with explicitly set charset keeps charset", (Object)copiedFile.getCharset(true), (Object)"FOO");
        }
        finally {
            ResourceTestUtil.removeFromWorkspace((IResource)project);
        }
    }

    private void assertCharsetIs(String tag, String encoding, IResource[] resources, boolean checkImplicit) throws CoreException {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            String string;
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile) {
                IFile f = (IFile)resource;
                string = f.getCharset(checkImplicit);
            } else {
                string = ((IContainer)resource).getDefaultCharset(checkImplicit);
            }
            String resourceCharset = string;
            Assert.assertEquals((String)(tag + " " + String.valueOf(resource.getFullPath())), (Object)encoding, (Object)resourceCharset);
            ++n2;
        }
    }

    private void clearAllEncodings(IResource root) throws CoreException {
        if (root == null || !root.exists()) {
            return;
        }
        IResourceVisitor visitor = resource -> {
            if (!resource.exists()) {
                return false;
            }
            switch (resource.getType()) {
                case 1: {
                    ((IFile)resource).setCharset(null, ResourceTestUtil.createTestMonitor());
                    break;
                }
                case 8: {
                    break;
                }
                default: {
                    ((IContainer)resource).setDefaultCharset(null, ResourceTestUtil.createTestMonitor());
                }
            }
            return true;
        };
        root.accept(visitor);
        ResourceTestUtil.waitForEncodingRelatedJobs(this.testName.getMethodName());
    }

    private IFile getResourcesPreferenceFile(IProject project, boolean forDerivedResources) {
        if (forDerivedResources) {
            return project.getFolder(".settings").getFile("org.eclipse.core.resources.derived.prefs");
        }
        return project.getFolder(".settings").getFile("org.eclipse.core.resources.prefs");
    }

    private Reader getTextContents(String text) {
        return new StringReader(text);
    }

    private boolean isDerivedEncodingStoredSeparately(IProject project) {
        Preferences node;
        block5: {
            String projectName;
            block4: {
                node = Platform.getPreferencesService().getRootNode().node("project");
                projectName = project.getName();
                try {
                    if (node.nodeExists(projectName)) break block4;
                    return false;
                }
                catch (BackingStoreException e) {
                    return false;
                }
            }
            node = node.node(projectName);
            if (node.nodeExists("org.eclipse.core.resources")) break block5;
            return false;
        }
        node = node.node("org.eclipse.core.resources");
        return node.getBoolean("separateDerivedEncodings", false);
    }

    private void setDerivedEncodingStoredSeparately(IProject project, boolean value) throws BackingStoreException {
        IEclipsePreferences prefs = new ProjectScope(project).getNode("org.eclipse.core.resources");
        if (!value) {
            prefs.remove("separateDerivedEncodings");
        } else {
            prefs.putBoolean("separateDerivedEncodings", true);
        }
        prefs.flush();
    }

    private static IEclipsePreferences getResourcesPreferences() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
    }

    @Before
    public void setUp() throws Exception {
        this.savedWorkspaceCharset = CharsetTest.getResourcesPreferences().get("encoding", "");
    }

    @After
    public void tearDown() throws Exception {
        CharsetTest.getResourcesPreferences().put("encoding", this.savedWorkspaceCharset);
        CharsetTest.getResourcesPreferences().remove("refresh.lightweight.enabled");
        ResourceTestUtil.waitForEncodingRelatedJobs(this.testName.getMethodName());
    }

    @Test
    public void testBug59899() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(ResourceTestUtil.createUniqueString());
        try {
            IFile file = project.getFile("file.txt");
            IFolder folder = project.getFolder("folder");
            ResourceTestUtil.createInWorkspace(new IResource[]{file, folder});
            file.setCharset("FOO", ResourceTestUtil.createTestMonitor());
            folder.setDefaultCharset("BAR", ResourceTestUtil.createTestMonitor());
            project.setDefaultCharset("PROJECT_CHARSET", ResourceTestUtil.createTestMonitor());
            ResourcesPlugin.getWorkspace().getRoot().setDefaultCharset("ROOT_CHARSET", ResourceTestUtil.createTestMonitor());
        }
        finally {
            this.clearAllEncodings((IResource)project);
        }
    }

    @Test
    public void testBug62732() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("MyProject");
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType anotherXML = contentTypeManager.getContentType("org.eclipse.core.tests.resources.anotherXML");
        Assert.assertNotNull((String)"0.5", (Object)anotherXML);
        ResourceTestUtil.createInWorkspace((IResource)project);
        IFile file = project.getFile("file.xml");
        ResourceTestUtil.createInWorkspace(file, SAMPLE_SPECIFIC_XML);
        IContentDescription description = file.getContentDescription();
        Assert.assertNotNull((String)"1.0", (Object)description);
        Assert.assertEquals((String)"1.1", (Object)anotherXML, (Object)description.getContentType());
        description = file.getContentDescription();
        Assert.assertNotNull((String)"2.0", (Object)description);
        Assert.assertEquals((String)"2.1", (Object)anotherXML, (Object)description.getContentType());
    }

    @Test
    public void testBug64503() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("MyProject");
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType text = contentTypeManager.getContentType("org.eclipse.core.runtime.text");
        IFile file = project.getFile("file.txt");
        ResourceTestUtil.createInWorkspace((IResource)file);
        IContentDescription description = file.getContentDescription();
        Assert.assertNotNull((String)"1.0", (Object)description);
        Assert.assertEquals((String)"1.1", (Object)text, (Object)description.getContentType());
        ResourceTestUtil.removeFromWorkspace((IResource)file);
        CoreException e = (CoreException)Assert.assertThrows(CoreException.class, () -> ((IFile)file).getContentDescription());
        Assert.assertEquals((String)"1.3", (long)368L, (long)e.getStatus().getCode());
    }

    @Test
    public void testBug94279() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String originalUserCharset = root.getDefaultCharset(false);
        try {
            root.setDefaultCharset(null, null);
            Assert.assertNull((String)"1.0", (Object)root.getDefaultCharset(false));
            root.setDefaultCharset(null, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNull((String)"1.0", (Object)root.getDefaultCharset(false));
        }
        finally {
            if (originalUserCharset != null) {
                root.setDefaultCharset(originalUserCharset, null);
            }
        }
    }

    @Test
    public void testBug333056() throws Exception {
        IProject project = null;
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            project = workspace.getRoot().getProject("MyProject");
            ResourceTestUtil.createInWorkspace((IResource)project);
            project.setDefaultCharset("BAR", ResourceTestUtil.createTestMonitor());
            IFolder folder = project.getFolder(ResourceTestUtil.createUniqueString());
            IFile file = folder.getFile(ResourceTestUtil.createUniqueString());
            Assert.assertEquals((String)"1.0", (Object)"BAR", (Object)file.getCharset(true));
            ResourceTestUtil.createInWorkspace((IResource)folder);
            Assert.assertEquals((String)"2.0", (Object)"BAR", (Object)file.getCharset(true));
            folder.setDerived(true, ResourceTestUtil.createTestMonitor());
            Assert.assertEquals((String)"3.0", (Object)"BAR", (Object)file.getCharset(true));
            this.setDerivedEncodingStoredSeparately(project, true);
            Assert.assertEquals((String)"5.0", (Object)"BAR", (Object)file.getCharset(true));
        }
        catch (Throwable throwable) {
            this.clearAllEncodings((IResource)project);
            throw throwable;
        }
        this.clearAllEncodings((IResource)project);
    }

    @Test
    public void testBug186984() throws Exception {
        FileWriter writer;
        CharsetTest.getResourcesPreferences().putBoolean("refresh.lightweight.enabled", false);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFile file = project.getFile("file.xml");
        String ascii = "<?xml version=\"1.0\" encoding=\"ascii\"?>";
        String utf = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
        file.getCharset(true);
        ResourceTestUtil.createInWorkspace((IResource)file);
        Assert.assertTrue((boolean)file.getLocation().toFile().delete());
        file.getCharset(true);
        ResourceTestUtil.createInFileSystem((IResource)file);
        ResourceTestUtil.ensureOutOfSync(file);
        file.getCharset(true);
        file.setContents(ascii.getBytes("ascii"), 1, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"4.0", (boolean)file.getCharset().equals("ascii"));
        Assert.assertTrue((String)"4.1", (boolean)file.getContentDescription().getCharset().equals("ascii"));
        ResourceTestUtil.touchInFilesystem((IResource)file);
        Assert.assertTrue((String)"4.2", (boolean)file.getCharset().equals("ascii"));
        CoreException e = (CoreException)Assert.assertThrows(CoreException.class, () -> {
            boolean bl = file.getContentDescription().getCharset().equals("ascii");
        });
        Assert.assertEquals((String)"the file should be out of sync", (long)274L, (long)e.getStatus().getCode());
        CharsetTest.getResourcesPreferences().putBoolean("refresh.lightweight.enabled", true);
        Assert.assertTrue((String)"4.5", (boolean)file.getContentDescription().getCharset().equals("ascii"));
        Job.getJobManager().wakeUp(ResourcesPlugin.FAMILY_AUTO_REFRESH);
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"4.6", (boolean)file.getCharset().equals("ascii"));
        Throwable throwable = null;
        Object var8_10 = null;
        try {
            writer = new FileWriter(file.getLocation().toFile());
            try {
                writer.write(utf);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ResourceTestUtil.touchInFilesystem((IResource)file);
        Assert.assertTrue((String)"5.4", (boolean)file.getCharset().equals("ascii"));
        Assert.assertTrue((String)"5.5", (boolean)file.getContentDescription().getCharset().equals("UTF-8"));
        Job.getJobManager().wakeUp(ResourcesPlugin.FAMILY_AUTO_REFRESH);
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"5.6", (boolean)file.getCharset().equals("UTF-8"));
        throwable = null;
        var8_10 = null;
        try {
            writer = new FileWriter(file.getLocation().toFile());
            try {
                writer.write(ascii);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        ResourceTestUtil.touchInFilesystem((IResource)file);
        Assert.assertTrue((String)"6.7", (boolean)file.getCharset().equals("UTF-8"));
        Assert.assertTrue((String)"6.8", (boolean)file.getContentDescription().getCharset().equals("ascii"));
        Job.getJobManager().wakeUp(ResourcesPlugin.FAMILY_AUTO_REFRESH);
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"6.9", (boolean)file.getCharset().equals("ascii"));
    }

    @Test
    public void testBug207510() throws CoreException, InterruptedException, BackingStoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        CharsetVerifierWithExtraInfo verifier = new CharsetVerifierWithExtraInfo(2);
        MultipleDeltasCharsetVerifier backgroundVerifier = new MultipleDeltasCharsetVerifier(1);
        IProject project1 = workspace.getRoot().getProject("project1");
        try {
            workspace.addResourceChangeListener((IResourceChangeListener)verifier, 1);
            workspace.addResourceChangeListener((IResourceChangeListener)backgroundVerifier, 1);
            IFolder a1 = project1.getFolder("a1");
            IFolder b1 = project1.getFolder("b1");
            IFile a = a1.getFile("a.txt");
            ResourceTestUtil.createInWorkspace(new IResource[]{project1, a1, b1, a});
            verifier.reset();
            verifier.addExpectedChange((IResource)b1, 4, 0x400000);
            b1.setDerived(true, ResourceTestUtil.createTestMonitor());
            verifier.waitForEvent(10000L);
            IFile regularPrefs = this.getResourcesPreferenceFile(project1, false);
            IFile derivedPrefs = this.getResourcesPreferenceFile(project1, true);
            ResourceTestUtil.assertExistsInWorkspace((IResource)regularPrefs);
            ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)derivedPrefs);
            verifier.reset();
            verifier.addExpectedChange((IResource)regularPrefs.getParent(), 4, 0);
            verifier.addExpectedChange((IResource)regularPrefs, 4, 256);
            this.setDerivedEncodingStoredSeparately(project1, true);
            Assert.assertTrue((String)"1.1", (boolean)verifier.waitForEvent(10000L));
            Assert.assertTrue((String)("1.2 " + verifier.getMessage()), (boolean)verifier.isDeltaValid());
            ResourceTestUtil.assertExistsInWorkspace((IResource)regularPrefs);
            ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)derivedPrefs);
            Assert.assertTrue((String)"1.5", (boolean)this.isDerivedEncodingStoredSeparately(project1));
            verifier.reset();
            verifier.addExpectedChange((IResource)a, 4, 0x100000);
            verifier.addExpectedChange((IResource)regularPrefs, 4, 256);
            a.setCharset("UTF-8", ResourceTestUtil.createTestMonitor());
            Assert.assertTrue((String)"2.1", (boolean)verifier.waitForEvent(10000L));
            Assert.assertTrue((String)("2.2 " + verifier.getMessage()), (boolean)verifier.isDeltaValid());
            ResourceTestUtil.assertExistsInWorkspace((IResource)regularPrefs);
            ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)derivedPrefs);
            a.setDerived(true, ResourceTestUtil.createTestMonitor());
            CharsetTest.waitForCharsetManagerJob();
            ResourceTestUtil.assertExistsInWorkspace((IResource)regularPrefs);
            ResourceTestUtil.assertExistsInWorkspace((IResource)derivedPrefs);
            Assert.assertTrue((String)"3.3", (boolean)derivedPrefs.isDerived());
            a.setDerived(false, ResourceTestUtil.createTestMonitor());
            CharsetTest.waitForCharsetManagerJob();
            ResourceTestUtil.assertExistsInWorkspace((IResource)regularPrefs);
            ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)derivedPrefs);
            IFile source = project1.getFolder("a1").getFile("a.txt");
            IFile destination = project1.getFolder("b1").getFile("a.txt");
            backgroundVerifier.reset();
            backgroundVerifier.addExpectedChange((IResource)regularPrefs, 4, 256);
            backgroundVerifier.addExpectedChange((IResource)derivedPrefs, 1, 0);
            a.move(destination.getFullPath(), true, ResourceTestUtil.createTestMonitor());
            a = destination;
            CharsetTest.waitForCharsetManagerJob();
            Assert.assertTrue((String)"5.1", (boolean)backgroundVerifier.waitForAllDeltas(10000L, 15000L));
            backgroundVerifier.assertExpectedDeltasWereReceived("5.2");
            ResourceTestUtil.assertExistsInWorkspace((IResource)regularPrefs);
            ResourceTestUtil.assertExistsInWorkspace((IResource)derivedPrefs);
            ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)source);
            ResourceTestUtil.assertExistsInWorkspace((IResource)destination);
            Assert.assertTrue((String)"5.7", (boolean)derivedPrefs.isDerived());
            this.assertCharsetIs("5.8", "UTF-8", new IResource[]{a}, true);
            verifier.reset();
            backgroundVerifier.reset();
            verifier.addExpectedChange((IResource)regularPrefs, 4, 256);
            backgroundVerifier.addExpectedChange((IResource)derivedPrefs, 2, 0);
            this.setDerivedEncodingStoredSeparately(project1, false);
            Assert.assertTrue((String)"6.1.1", (boolean)verifier.waitForEvent(10000L));
            Assert.assertTrue((String)"6.1.2", (boolean)backgroundVerifier.waitForFirstDelta(10000L));
            Assert.assertTrue((String)("6.2.1 " + verifier.getMessage()), (boolean)verifier.isDeltaValid());
            backgroundVerifier.assertExpectedDeltasWereReceived("6.2.2");
            ResourceTestUtil.assertExistsInWorkspace((IResource)regularPrefs);
            ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)derivedPrefs);
            verifier.reset();
            backgroundVerifier.reset();
            verifier.addExpectedChange((IResource)regularPrefs, 4, 256);
            backgroundVerifier.addExpectedChange((IResource)derivedPrefs, 1, 0);
            this.setDerivedEncodingStoredSeparately(project1, true);
            Assert.assertTrue((String)"7.1.1", (boolean)verifier.waitForEvent(10000L));
            Assert.assertTrue((String)"7.1.2", (boolean)backgroundVerifier.waitForFirstDelta(10000L));
            Assert.assertTrue((String)("7.2.1 " + verifier.getMessage()), (boolean)verifier.isDeltaValid());
            backgroundVerifier.assertExpectedDeltasWereReceived("7.2.2");
            ResourceTestUtil.assertExistsInWorkspace((IResource)regularPrefs);
            ResourceTestUtil.assertExistsInWorkspace((IResource)derivedPrefs);
            Assert.assertTrue((String)"7.5", (boolean)this.isDerivedEncodingStoredSeparately(project1));
            Assert.assertTrue((String)"7.6", (boolean)derivedPrefs.isDerived());
        }
        finally {
            workspace.removeResourceChangeListener((IResourceChangeListener)verifier);
            backgroundVerifier.removeResourceChangeListeners();
            this.clearAllEncodings((IResource)project1);
        }
    }

    @Test
    public void testBug261994() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project1 = workspace.getRoot().getProject("Project1");
        IFile file = project1.getFile("file1.xml");
        ResourceTestUtil.createInWorkspace(file, SAMPLE_XML_ISO_8859_1_ENCODING);
        ContentDescriptionManagerTest.waitForCacheFlush();
        Assert.assertEquals((String)"1.0", (Object)"ISO-8859-1", (Object)file.getCharset());
        ResourceTestUtil.removeFromWorkspace((IResource)file);
        ResourceTestUtil.createInWorkspace(file, SAMPLE_XML_DEFAULT_ENCODING);
        Assert.assertEquals((String)"2.0", (Object)"UTF-8", (Object)file.getCharset());
    }

    @Test
    public void testChangesDifferentProject() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project1 = workspace.getRoot().getProject("Project1");
        IProject project2 = workspace.getRoot().getProject("Project2");
        try {
            IFolder folder = project1.getFolder("folder1");
            IFile file1 = project1.getFile("file1.txt");
            IFile file2 = folder.getFile("file2.txt");
            ResourceTestUtil.createInWorkspace(new IResource[]{file1, file2, project2});
            project1.setDefaultCharset("FOO", ResourceTestUtil.createTestMonitor());
            project2.setDefaultCharset("ZOO", ResourceTestUtil.createTestMonitor());
            folder.setDefaultCharset("BAR", ResourceTestUtil.createTestMonitor());
            folder.move(project2.getFullPath().append("folder"), false, false, null);
            folder = project2.getFolder("folder");
            Assert.assertEquals((String)"1.0", (Object)"BAR", (Object)folder.getDefaultCharset());
            Assert.assertEquals((String)"1.1", (Object)"BAR", (Object)folder.getFile("file2.txt").getCharset());
            Assert.assertEquals((String)"2.0", (Object)project1.getDefaultCharset(), (Object)file1.getCharset());
            file1.move(project2.getFullPath().append("file1.txt"), false, false, null);
            file1 = project2.getFile("file1.txt");
            Assert.assertEquals((String)"2.1", (Object)project2.getDefaultCharset(), (Object)file1.getCharset());
        }
        finally {
            this.clearAllEncodings((IResource)project1);
            this.clearAllEncodings((IResource)project2);
        }
    }

    @Test
    public void testChangesSameProject() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("MyProject");
        try {
            IFolder folder = project.getFolder("folder1");
            IFile file1 = project.getFile("file1.txt");
            IFile file2 = folder.getFile("file2.txt");
            ResourceTestUtil.createInWorkspace(new IResource[]{file1, file2});
            project.setDefaultCharset("FOO", ResourceTestUtil.createTestMonitor());
            file1.setCharset("FRED", ResourceTestUtil.createTestMonitor());
            folder.setDefaultCharset("BAR", ResourceTestUtil.createTestMonitor());
            folder.move(project.getFullPath().append("folder2"), false, false, null);
            folder = project.getFolder("folder2");
            Assert.assertEquals((String)"1.0", (Object)"BAR", (Object)folder.getDefaultCharset());
            Assert.assertEquals((String)"1.1", (Object)"BAR", (Object)folder.getFile("file2.txt").getCharset());
            file2 = folder.getFile("file2.txt");
            file2.move(project.getFullPath().append("file2.txt"), false, false, null);
            file2 = project.getFile("file2.txt");
            Assert.assertEquals((String)"2.0", (Object)project.getDefaultCharset(), (Object)file2.getCharset());
            file1.delete(false, false, null);
            ResourceTestUtil.createInWorkspace(new IResource[]{file1});
            Assert.assertEquals((String)"3.0", (Object)project.getDefaultCharset(), (Object)file1.getCharset());
        }
        finally {
            this.clearAllEncodings((IResource)project);
        }
    }

    @Test
    public void testClosingAndReopeningProject() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("MyProject");
        try {
            IFolder folder = project.getFolder("folder");
            IFile file1 = project.getFile("file1.txt");
            IFile file2 = folder.getFile("file2.txt");
            ResourceTestUtil.createInWorkspace(new IResource[]{file1, file2});
            project.setDefaultCharset("FOO", ResourceTestUtil.createTestMonitor());
            file1.setCharset("FRED", ResourceTestUtil.createTestMonitor());
            folder.setDefaultCharset("BAR", ResourceTestUtil.createTestMonitor());
            project.close(null);
            IProject projectB = workspace.getRoot().getProject(project.getName());
            projectB.open(null);
            ResourceTestUtil.assertExistsInWorkspace((IResource)this.getResourcesPreferenceFile(projectB, false));
            Assert.assertEquals((String)"1.0", (Object)"FOO", (Object)projectB.getDefaultCharset());
            Assert.assertEquals((String)"3.0", (Object)"FRED", (Object)projectB.getFile("file1.txt").getCharset());
            Assert.assertEquals((String)"2.0", (Object)"BAR", (Object)projectB.getFolder("folder").getDefaultCharset());
            Assert.assertEquals((String)"2.1", (Object)"BAR", (Object)projectB.getFolder("folder").getFile("file2.txt").getCharset());
        }
        finally {
            this.clearAllEncodings((IResource)project);
        }
    }

    @Test
    public void testContentBasedCharset() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("MyProject");
        try {
            ResourceTestUtil.createInWorkspace((IResource)project);
            project.setDefaultCharset("FOO", ResourceTestUtil.createTestMonitor());
            IFile file = project.getFile("file.xml");
            Assert.assertEquals((String)"0.9", (Object)"FOO", (Object)project.getDefaultCharset());
            ResourceTestUtil.createInWorkspace(file, SAMPLE_XML_US_ASCII_ENCODING);
            Assert.assertEquals((String)"1.0", (Object)"US-ASCII", (Object)file.getCharset());
            file.setContents(SAMPLE_XML_ISO_8859_1_ENCODING.getBytes(StandardCharsets.ISO_8859_1), false, false, null);
            Assert.assertEquals((String)"2.0", (Object)"ISO-8859-1", (Object)file.getCharset());
            file.setContents(SAMPLE_XML_DEFAULT_ENCODING.getBytes(StandardCharsets.UTF_8), false, false, null);
            Assert.assertEquals((String)"3.0", (Object)"UTF-8", (Object)file.getCharset());
            String UTF8_BOM = new String(IContentDescription.BOM_UTF_8, StandardCharsets.ISO_8859_1);
            file.setContents((UTF8_BOM + SAMPLE_XML_DEFAULT_ENCODING).getBytes(StandardCharsets.ISO_8859_1), false, false, null);
            Assert.assertEquals((String)"4.0", (Object)"UTF-8", (Object)file.getCharset());
            String UTF16_LE_BOM = new String(IContentDescription.BOM_UTF_16LE, StandardCharsets.ISO_8859_1);
            file.setContents((UTF16_LE_BOM + SAMPLE_XML_DEFAULT_ENCODING).getBytes(StandardCharsets.ISO_8859_1), false, false, null);
            Assert.assertEquals((String)"5.0", (Object)"UTF-16", (Object)file.getCharset());
            String UTF16_BE_BOM = new String(IContentDescription.BOM_UTF_16BE, StandardCharsets.ISO_8859_1);
            file.setContents((UTF16_BE_BOM + SAMPLE_XML_DEFAULT_ENCODING).getBytes(StandardCharsets.ISO_8859_1), false, false, null);
            Assert.assertEquals((String)"6.0", (Object)"UTF-16", (Object)file.getCharset());
        }
        finally {
            this.clearAllEncodings((IResource)project);
        }
    }

    @Test
    public void testDefaults() throws CoreException {
        IProject project = null;
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            project = workspace.getRoot().getProject("MyProject");
            IFolder folder1 = project.getFolder("folder1");
            IFolder folder2 = folder1.getFolder("folder2");
            IFile file1 = project.getFile("file1.txt");
            IFile file2 = folder1.getFile("file2.txt");
            IFile file3 = folder2.getFile("file3.txt");
            ResourceTestUtil.createInWorkspace(new IResource[]{project});
            Assert.assertEquals((Object)ResourcesPlugin.getEncoding(), (Object)project.getDefaultCharset(false));
            Object[] markers = project.findMarkers(ValidateProjectEncoding.MARKER_TYPE, false, 1);
            ((ObjectArrayAssert)Assertions.assertThat((Object[])markers).as("check no missing encoding markers", new Object[0])).isEmpty();
            project.setDefaultCharset(null, ResourceTestUtil.createTestMonitor());
            Assert.assertEquals(null, (Object)project.getDefaultCharset(false));
            ResourceTestUtil.waitForEncodingRelatedJobs(this.testName.getMethodName());
            markers = project.findMarkers(ValidateProjectEncoding.MARKER_TYPE, false, 1);
            ((ObjectArrayAssert)Assertions.assertThat((Object[])markers).as("check missing encoding markers", new Object[0])).hasSize(1);
            ResourceTestUtil.createInWorkspace(new IResource[]{file1, file2, file3});
            this.assertCharsetIs("1.0", ResourcesPlugin.getEncoding(), new IResource[]{workspace.getRoot(), project, file1, folder1, file2, folder2, file3}, true);
            this.assertCharsetIs("1.1", null, new IResource[]{project, file1, folder1, file2, folder2, file3}, false);
            workspace.getRoot().setDefaultCharset("FOO", ResourceTestUtil.createTestMonitor());
            markers = project.findMarkers(ValidateProjectEncoding.MARKER_TYPE, false, 1);
            ((ObjectArrayAssert)Assertions.assertThat((Object[])markers).as("check missing encoding markers", new Object[0])).hasSize(1);
            this.assertCharsetIs("2.0", "FOO", new IResource[]{workspace.getRoot(), project, file1, folder1, file2, folder2, file3}, true);
            this.assertCharsetIs("2.1", null, new IResource[]{project, file1, folder1, file2, folder2, file3}, false);
            project.setDefaultCharset("BAR", ResourceTestUtil.createTestMonitor());
            ResourceTestUtil.waitForEncodingRelatedJobs(this.testName.getMethodName());
            markers = project.findMarkers(ValidateProjectEncoding.MARKER_TYPE, false, 1);
            ((ObjectArrayAssert)Assertions.assertThat((Object[])markers).as("check no missing encoding markers", new Object[0])).isEmpty();
            this.assertCharsetIs("3.0", "BAR", new IResource[]{project, file1, folder1, file2, folder2, file3}, true);
            this.assertCharsetIs("3.1", null, new IResource[]{file1, folder1, file2, folder2, file3}, false);
            this.assertCharsetIs("3.2", "FOO", new IResource[]{workspace.getRoot()}, true);
            folder1.setDefaultCharset("FRED", ResourceTestUtil.createTestMonitor());
            this.assertCharsetIs("4.0", "FRED", new IResource[]{folder1, file2, folder2, file3}, true);
            this.assertCharsetIs("4.1", null, new IResource[]{file2, folder2, file3}, false);
            this.assertCharsetIs("4.2", "BAR", new IResource[]{project, file1}, true);
            folder2.setDefaultCharset("ZOO", ResourceTestUtil.createTestMonitor());
            this.assertCharsetIs("5.0", "ZOO", new IResource[]{folder2, file3}, true);
            this.assertCharsetIs("5.1", null, new IResource[]{file3}, false);
            this.assertCharsetIs("5.2", "FRED", new IResource[]{folder1, file2}, true);
            file3.setCharset("ZIT", ResourceTestUtil.createTestMonitor());
            this.assertCharsetIs("6.0", "ZIT", new IResource[]{file3}, false);
            folder2.setDefaultCharset(null, ResourceTestUtil.createTestMonitor());
            this.assertCharsetIs("7.0", folder2.getParent().getDefaultCharset(), new IResource[]{folder2}, true);
            this.assertCharsetIs("7.1", null, new IResource[]{folder2}, false);
            this.assertCharsetIs("7.2", "ZIT", new IResource[]{file3}, false);
            folder1.setDefaultCharset(null, ResourceTestUtil.createTestMonitor());
            this.assertCharsetIs("8.0", folder1.getParent().getDefaultCharset(), new IResource[]{folder1, file2, folder2}, true);
            this.assertCharsetIs("8.1", null, new IResource[]{folder1, file2, folder2}, false);
            this.assertCharsetIs("8.2", "ZIT", new IResource[]{file3}, false);
            project.setDefaultCharset(null, ResourceTestUtil.createTestMonitor());
            this.assertCharsetIs("9.0", project.getParent().getDefaultCharset(), new IResource[]{project, file1, folder1, file2, folder2}, true);
            this.assertCharsetIs("9.1", null, new IResource[]{project, file1, folder1, file2, folder2}, false);
            this.assertCharsetIs("9.2", "ZIT", new IResource[]{file3}, false);
            workspace.getRoot().setDefaultCharset(null, ResourceTestUtil.createTestMonitor());
            this.assertCharsetIs("10.0", project.getParent().getDefaultCharset(), new IResource[]{project, file1, folder1, file2, folder2}, true);
            this.assertCharsetIs("10.1", "ZIT", new IResource[]{file3}, false);
            file3.setCharset(null, ResourceTestUtil.createTestMonitor());
            this.assertCharsetIs("11.0", ResourcesPlugin.getEncoding(), new IResource[]{workspace.getRoot(), project, file1, folder1, file2, folder2, file3}, true);
        }
        catch (Throwable throwable) {
            this.clearAllEncodings((IResource)project);
            throw throwable;
        }
        this.clearAllEncodings((IResource)project);
    }

    @Test
    public void testDeltaOnContentTypeChanges() throws CoreException {
        String USER_SETTING = "USER_CHARSET";
        String PROVIDER_SETTING = "PROVIDER_CHARSET";
        CharsetVerifier backgroundVerifier = new CharsetVerifier(1);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)backgroundVerifier, 1);
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType myType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.myContent2");
        Assert.assertNotNull((String)"0.1", (Object)myType);
        Assert.assertEquals((String)"0.2", (Object)"PROVIDER_CHARSET", (Object)myType.getDefaultCharset());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("project1");
        try {
            IFolder folder1 = project.getFolder("folder1");
            IFile file1 = folder1.getFile("file1.txt");
            IFile file2 = folder1.getFile("file2.resources-mc");
            IFile file3 = project.getFile("file3.resources-mc");
            IFile file4 = project.getFile("file4.resources-mc");
            ResourceTestUtil.createInWorkspace(new IResource[]{file1, file2, file3, file4});
            project.setDefaultCharset("FOO", ResourceTestUtil.createTestMonitor());
            file4.setCharset("BAR", ResourceTestUtil.createTestMonitor());
            backgroundVerifier.reset();
            backgroundVerifier.addExpectedChange(new IResource[]{file2, file3, file4}, 4, 0x100000);
            myType.setDefaultCharset("USER_CHARSET");
            Assert.assertTrue((String)"2.1", (boolean)backgroundVerifier.waitForEvent(10000L));
            Assert.assertTrue((String)("2.2 " + backgroundVerifier.getMessage()), (boolean)backgroundVerifier.isDeltaValid());
            Assert.assertEquals((String)"3.0", (Object)"USER_CHARSET", (Object)file2.getCharset());
            Assert.assertEquals((String)"3.1", (Object)"USER_CHARSET", (Object)file3.getCharset());
            Assert.assertEquals((String)"3.2", (Object)"BAR", (Object)file4.getCharset());
            backgroundVerifier.reset();
            backgroundVerifier.addExpectedChange(new IResource[]{file2, file3, file4}, 4, 0x100000);
            myType.setDefaultCharset(null);
            Assert.assertTrue((String)"4.1", (boolean)backgroundVerifier.waitForEvent(10000L));
            Assert.assertTrue((String)("4.2 " + backgroundVerifier.getMessage()), (boolean)backgroundVerifier.isDeltaValid());
            Assert.assertEquals((String)"5.0", (Object)"PROVIDER_CHARSET", (Object)file2.getCharset());
            Assert.assertEquals((String)"5.1", (Object)"PROVIDER_CHARSET", (Object)file3.getCharset());
            Assert.assertEquals((String)"5.2", (Object)"BAR", (Object)file4.getCharset());
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)backgroundVerifier);
            myType.setDefaultCharset(null);
            this.clearAllEncodings((IResource)project);
        }
    }

    @Test
    public void testDeltaOnPreferenceChanges() throws IOException, CoreException {
        CharsetVerifier backgroundVerifier = new CharsetVerifier(1);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)backgroundVerifier, 1);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("project1");
        try {
            IFolder folder1 = project.getFolder("folder1");
            IFile file1 = folder1.getFile("file1.txt");
            IFile file2 = project.getFile("file2.txt");
            ResourceTestUtil.createInWorkspace(new IResource[]{file1, file2});
            IFile resourcesPrefs = this.getResourcesPreferenceFile(project, false);
            Assert.assertTrue((String)"0.9", (boolean)resourcesPrefs.exists());
            String prefsContent = Files.readString(resourcesPrefs.getLocation().toFile().toPath());
            Assert.assertTrue((boolean)prefsContent.contains(ResourcesPlugin.getEncoding()));
            file1.setCharset("CHARSET1", ResourceTestUtil.createTestMonitor());
            Assert.assertTrue((String)"1.1", (boolean)resourcesPrefs.exists());
            CharsetTest.waitForCharsetManagerJob();
            prefsContent = Files.readString(resourcesPrefs.getLocation().toFile().toPath());
            Assert.assertTrue((boolean)prefsContent.contains(ResourcesPlugin.getEncoding()));
            backgroundVerifier.reset();
            backgroundVerifier.addExpectedChange(new IResource[]{project, folder1, file1, file2, resourcesPrefs, resourcesPrefs.getParent()}, 4, 0x100000);
            resourcesPrefs.setContents(prefsContent.getBytes(), 0, ResourceTestUtil.createTestMonitor());
            Assert.assertTrue((String)"2.1", (boolean)backgroundVerifier.waitForEvent(10000L));
            Assert.assertTrue((String)("2.2 " + backgroundVerifier.getMessage()), (boolean)backgroundVerifier.isDeltaValid());
            Object[] markers = project.findMarkers(ValidateProjectEncoding.MARKER_TYPE, false, 1);
            ((ObjectArrayAssert)Assertions.assertThat((Object[])markers).as("check no missing enconding markers", new Object[0])).isEmpty();
            backgroundVerifier.reset();
            backgroundVerifier.addExpectedChange(new IResource[]{project}, 4, 0x120000);
            backgroundVerifier.addExpectedChange(new IResource[]{folder1, file1, file2, resourcesPrefs.getParent()}, 4, 0x100000);
            resourcesPrefs.delete(true, ResourceTestUtil.createTestMonitor());
            CharsetTest.waitForCharsetManagerJob();
            ResourceTestUtil.waitForEncodingRelatedJobs(this.testName.getMethodName());
            Assert.assertTrue((String)"3.1", (boolean)backgroundVerifier.waitForEvent(10000L));
            Assert.assertTrue((String)("3.2 " + backgroundVerifier.getMessage()), (boolean)backgroundVerifier.isDeltaValid());
            markers = project.findMarkers(ValidateProjectEncoding.MARKER_TYPE, false, 1);
            ((ObjectArrayAssert)Assertions.assertThat((Object[])markers).as("check missing encoding markers", new Object[0])).hasSize(1);
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)backgroundVerifier);
            this.clearAllEncodings((IResource)project);
        }
    }

    @Test
    public void testDeltasContainer() throws CoreException {
        MultipleDeltasCharsetVerifier verifier = new MultipleDeltasCharsetVerifier(2);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)verifier, 1);
        try {
            IFile prefs = this.getResourcesPreferenceFile(project, false);
            IFolder folder1 = project.getFolder("folder1");
            ResourceTestUtil.createInWorkspace(new IResource[]{project, folder1});
            verifier.reset();
            verifier.addExpectedChange((IResource)folder1, 4, 0x100000);
            verifier.addExpectedChange(new IResource[]{prefs.getParent()}, 4, 0);
            verifier.addExpectedChange(new IResource[]{prefs}, 4, 256);
            folder1.setDefaultCharset("new_charset", ResourceTestUtil.createTestMonitor());
            verifier.assertExpectedDeltasWereReceived("1.1.");
            IFolder folder2 = folder1.getFolder("folder2");
            IFile file1 = folder1.getFile("file1.txt");
            IFile file2 = folder2.getFile("file2.txt");
            ResourceTestUtil.createInWorkspace(new IResource[]{folder2, file1, file2});
            verifier.reset();
            verifier.addExpectedChange(new IResource[]{folder1, folder2, file1, file2}, 4, 0x100000);
            verifier.addExpectedChange((IResource)prefs.getParent(), 4, 0);
            verifier.addExpectedChange((IResource)prefs, 4, 256);
            folder1.setDefaultCharset("a_charset", ResourceTestUtil.createTestMonitor());
            verifier.assertExpectedDeltasWereReceived("2.1.");
            folder2.setDefaultCharset("non-Default", ResourceTestUtil.createTestMonitor());
            verifier.reset();
            verifier.addExpectedChange(new IResource[]{folder1, file1}, 4, 0x100000);
            verifier.addExpectedChange((IResource)prefs.getParent(), 4, 0);
            verifier.addExpectedChange((IResource)prefs, 4, 256);
            folder1.setDefaultCharset("newOne", ResourceTestUtil.createTestMonitor());
            verifier.assertExpectedDeltasWereReceived("3.2.");
            verifier.reset();
            verifier.addExpectedChange(new IResource[]{folder1, file1}, 4, 0x100000);
            verifier.addExpectedChange((IResource)prefs.getParent(), 4, 0);
            verifier.addExpectedChange((IResource)prefs, 4, 256);
            folder1.setDefaultCharset("newTwo", ResourceTestUtil.createTestMonitor());
            verifier.assertExpectedDeltasWereReceived("4.2.");
            verifier.reset();
            verifier.addExpectedChange(new IResource[]{folder1, file1}, 4, 0x100000);
            verifier.addExpectedChange((IResource)prefs.getParent(), 4, 0);
            verifier.addExpectedChange((IResource)prefs, 4, 256);
            folder1.setDefaultCharset(null, ResourceTestUtil.createTestMonitor());
            verifier.assertExpectedDeltasWereReceived("5.1.");
            verifier.reset();
            verifier.addExpectedChange(new IResource[]{folder1, file1}, 4, 0x100000);
            verifier.addExpectedChange((IResource)prefs.getParent(), 4, 0);
            verifier.addExpectedChange((IResource)prefs, 4, 256);
            folder1.setDefaultCharset(project.getDefaultCharset(), ResourceTestUtil.createTestMonitor());
            verifier.assertExpectedDeltasWereReceived("6.1.");
            this.clearAllEncodings((IResource)project);
            verifier.reset();
            verifier.addExpectedChange(new IResource[]{project, folder1, folder2, file1, file2, prefs.getParent()}, 4, 0x100000);
            verifier.addExpectedChange((IResource)prefs, 1, 0);
            project.setDefaultCharset("foo", ResourceTestUtil.createTestMonitor());
            ResourceTestUtil.waitForEncodingRelatedJobs(this.testName.getMethodName());
            verifier.assertExpectedDeltasWereReceived("7.2.");
            this.clearAllEncodings((IResource)project);
            verifier.reset();
            verifier.addExpectedChange(new IResource[]{project, folder1, folder2, file1, file2, prefs.getParent()}, 4, 0x100000);
            ResourcesPlugin.getWorkspace().getRoot().setDefaultCharset("foo", ResourceTestUtil.createTestMonitor());
            ResourceTestUtil.waitForEncodingRelatedJobs(this.testName.getMethodName());
            verifier.assertExpectedDeltasWereReceived("8.2.");
        }
        finally {
            verifier.removeResourceChangeListeners();
            this.clearAllEncodings((IResource)project);
        }
    }

    @Test
    public void testDeltasFile() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        MultipleDeltasCharsetVerifier verifier = new MultipleDeltasCharsetVerifier(2);
        workspace.addResourceChangeListener((IResourceChangeListener)verifier, 1);
        IProject project = workspace.getRoot().getProject("MyProject");
        try {
            IFile prefs = this.getResourcesPreferenceFile(project, false);
            IFile file1 = project.getFile("file1.txt");
            ResourceTestUtil.createInWorkspace(file1, ResourceTestUtil.createRandomString());
            verifier.reset();
            verifier.addExpectedChange((IResource)file1, 4, 0x100000);
            verifier.addExpectedChange(new IResource[]{prefs.getParent()}, 4, 0);
            verifier.addExpectedChange(new IResource[]{prefs}, 4, 256);
            file1.setCharset("FOO", ResourceTestUtil.createTestMonitor());
            verifier.assertExpectedDeltasWereReceived("1.0.1");
            verifier.reset();
            verifier.addExpectedChange((IResource)prefs, 4, 256);
            verifier.addExpectedChange((IResource)file1, 4, 0x100000);
            file1.setCharset(null, ResourceTestUtil.createTestMonitor());
            verifier.assertExpectedDeltasWereReceived("1.1.1");
            verifier.reset();
            verifier.addExpectedChange((IResource)prefs, 4, 256);
            verifier.addExpectedChange((IResource)file1, 4, 0x100000);
            file1.setCharset(project.getDefaultCharset(), ResourceTestUtil.createTestMonitor());
            verifier.assertExpectedDeltasWereReceived("1.2.1");
            file1.setCharset("FOO", ResourceTestUtil.createTestMonitor());
            verifier.reset();
            verifier.addExpectedChange((IResource)file1, 4, 0x100000);
            verifier.addExpectedChange((IResource)prefs.getParent(), 4, 0);
            verifier.addExpectedChange((IResource)prefs, 4, 256);
            file1.setCharset("BAR", ResourceTestUtil.createTestMonitor());
            verifier.assertExpectedDeltasWereReceived("1.3.2");
            verifier.reset();
            IFile file2 = project.getFile("file2.txt");
            ResourceTestUtil.createInWorkspace(file2, ResourceTestUtil.createRandomString());
            verifier.addExpectedChange(new IResource[]{file1, file2}, 4, 0x100000);
            verifier.addExpectedChange((IResource)prefs.getParent(), 4, 0);
            verifier.addExpectedChange((IResource)prefs, 4, 256);
            workspace.run(monitor -> {
                file1.setCharset("FOO", ResourceTestUtil.createTestMonitor());
                file2.setCharset("FOO", ResourceTestUtil.createTestMonitor());
            }, ResourceTestUtil.createTestMonitor());
            verifier.assertExpectedDeltasWereReceived("1.4.1");
        }
        finally {
            verifier.removeResourceChangeListeners();
            this.clearAllEncodings((IResource)project);
        }
    }

    @Test
    public void testFileCreation() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("MyProject");
        try {
            IFolder folder = project.getFolder("folder");
            IFile file1 = project.getFile("file1.txt");
            IFile file2 = folder.getFile("file2.txt");
            ResourceTestUtil.createInWorkspace(new IResource[]{file1, file2});
            ResourceTestUtil.assertExistsInWorkspace((IResource)this.getResourcesPreferenceFile(project, false));
            project.setDefaultCharset("FOO", ResourceTestUtil.createTestMonitor());
            ResourceTestUtil.assertExistsInWorkspace((IResource)this.getResourcesPreferenceFile(project, false));
            project.setDefaultCharset(null, ResourceTestUtil.createTestMonitor());
            ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)this.getResourcesPreferenceFile(project, false));
            file1.setCharset("FRED", ResourceTestUtil.createTestMonitor());
            ResourceTestUtil.assertExistsInWorkspace((IResource)this.getResourcesPreferenceFile(project, false));
            folder.setDefaultCharset("BAR", ResourceTestUtil.createTestMonitor());
            ResourceTestUtil.assertExistsInWorkspace((IResource)this.getResourcesPreferenceFile(project, false));
            file1.setCharset(null, ResourceTestUtil.createTestMonitor());
            ResourceTestUtil.assertExistsInWorkspace((IResource)this.getResourcesPreferenceFile(project, false));
            folder.setDefaultCharset(null, ResourceTestUtil.createTestMonitor());
            ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)this.getResourcesPreferenceFile(project, false));
        }
        finally {
            this.clearAllEncodings((IResource)project);
        }
    }

    @Test
    public void testGetCharsetFor() throws CoreException {
        IProject project = null;
        try {
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            IContentType xml = contentTypeManager.getContentType("org.eclipse.core.runtime.xml");
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            project = workspace.getRoot().getProject("MyProject");
            IFile oldFile = project.getFile("oldfile.xml");
            IFile newXMLFile = project.getFile("newfile.xml");
            IFile newTXTFile = project.getFile("newfile.txt");
            IFile newRandomFile = project.getFile("newFile." + (long)(Math.random() * 9.223372036854776E18));
            ResourceTestUtil.createInWorkspace(oldFile, SAMPLE_XML_DEFAULT_ENCODING);
            project.setDefaultCharset("BAR", ResourceTestUtil.createTestMonitor());
            oldFile.setCharset("FOO", ResourceTestUtil.createTestMonitor());
            this.assertCharsetIs("0.1", "BAR", new IResource[]{project, newXMLFile, newTXTFile, newRandomFile}, true);
            this.assertCharsetIs("0.2", "FOO", new IResource[]{oldFile}, true);
            Assert.assertEquals((String)"1.0", (Object)"FOO", (Object)oldFile.getCharsetFor(this.getTextContents("")));
            Assert.assertEquals((String)"1.1", (Object)"FOO", (Object)oldFile.getCharsetFor(this.getTextContents(SAMPLE_XML_DEFAULT_ENCODING)));
            Assert.assertEquals((String)"2.0", (Object)xml.getDefaultCharset(), (Object)newXMLFile.getCharsetFor(this.getTextContents("")));
            Assert.assertEquals((String)"2.1", (Object)xml.getDefaultCharset(), (Object)newXMLFile.getCharsetFor(this.getTextContents(SAMPLE_XML_DEFAULT_ENCODING)));
            Assert.assertEquals((String)"2.2", (Object)"US-ASCII", (Object)newXMLFile.getCharsetFor(this.getTextContents(SAMPLE_XML_US_ASCII_ENCODING)));
            oldFile.setCharset(null, ResourceTestUtil.createTestMonitor());
            Assert.assertEquals((String)"2.3", (Object)xml.getDefaultCharset(), (Object)oldFile.getCharsetFor(this.getTextContents("")));
            Assert.assertEquals((String)"2.4", (Object)xml.getDefaultCharset(), (Object)oldFile.getCharsetFor(this.getTextContents(SAMPLE_XML_DEFAULT_ENCODING)));
            Assert.assertEquals((String)"2.5", (Object)"US-ASCII", (Object)oldFile.getCharsetFor(this.getTextContents(SAMPLE_XML_US_ASCII_ENCODING)));
            Assert.assertEquals((String)"3.0", (Object)project.getDefaultCharset(), (Object)newTXTFile.getCharsetFor(this.getTextContents("")));
            Assert.assertEquals((String)"3.1", (Object)project.getDefaultCharset(), (Object)newRandomFile.getCharsetFor(this.getTextContents("")));
        }
        catch (Throwable throwable) {
            this.clearAllEncodings((IResource)project);
            throw throwable;
        }
        this.clearAllEncodings((IResource)project);
    }

    @Test
    public void testMovingProject() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project1 = workspace.getRoot().getProject("Project1");
        IProject project2 = null;
        try {
            IFolder folder = project1.getFolder("folder1");
            IFile file1 = project1.getFile("file1.txt");
            IFile file2 = folder.getFile("file2.txt");
            ResourceTestUtil.createInWorkspace(new IResource[]{file1, file2});
            project1.setDefaultCharset("FOO", ResourceTestUtil.createTestMonitor());
            folder.setDefaultCharset("BAR", ResourceTestUtil.createTestMonitor());
            Assert.assertEquals((String)"1.0", (Object)"BAR", (Object)folder.getDefaultCharset());
            Assert.assertEquals((String)"1.1", (Object)"BAR", (Object)file2.getCharset());
            Assert.assertEquals((String)"1.2", (Object)"FOO", (Object)file1.getCharset());
            Assert.assertEquals((String)"1.3", (Object)"FOO", (Object)project1.getDefaultCharset());
            project1.move(IPath.fromOSString((String)"Project2"), false, null);
            project2 = workspace.getRoot().getProject("Project2");
            folder = project2.getFolder("folder1");
            file1 = project2.getFile("file1.txt");
            file2 = folder.getFile("file2.txt");
            Assert.assertEquals((String)"2.0", (Object)"BAR", (Object)folder.getDefaultCharset());
            Assert.assertEquals((String)"2.1", (Object)"BAR", (Object)file2.getCharset());
            Assert.assertEquals((String)"2.2", (Object)"FOO", (Object)project2.getDefaultCharset());
            Assert.assertEquals((String)"2.3", (Object)"FOO", (Object)file1.getCharset());
        }
        catch (Throwable throwable) {
            this.clearAllEncodings((IResource)project1);
            this.clearAllEncodings((IResource)project2);
            throw throwable;
        }
        this.clearAllEncodings((IResource)project1);
        this.clearAllEncodings((IResource)project2);
    }

    @Test
    public void testNonExistingResource() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("MyProject");
        try {
            CoreException e = (CoreException)Assert.assertThrows(CoreException.class, () -> project.setDefaultCharset("FOO", ResourceTestUtil.createTestMonitor()));
            Assert.assertEquals((String)"project should not exist yet", (long)368L, (long)e.getStatus().getCode());
            ResourceTestUtil.createInWorkspace((IResource)project);
            project.setDefaultCharset("FOO", ResourceTestUtil.createTestMonitor());
            IFile file = project.getFile("file.xml");
            ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
            Assert.assertEquals((String)"2.2", (Object)"FOO", (Object)file.getCharset());
            e = (CoreException)Assert.assertThrows(CoreException.class, () -> file.setCharset("BAR", ResourceTestUtil.createTestMonitor()));
            Assert.assertEquals((String)"file should not exist yet", (long)368L, (long)e.getStatus().getCode());
            ResourceTestUtil.createInWorkspace((IResource)file);
            file.setCharset("BAR", ResourceTestUtil.createTestMonitor());
            Assert.assertEquals((String)"2.8", (Object)"BAR", (Object)file.getCharset());
            file.delete(0, null);
            ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
            Assert.assertEquals((String)"2.11", (Object)"FOO", (Object)file.getCharset());
        }
        finally {
            this.clearAllEncodings((IResource)project);
        }
    }

    @Test
    public void testBug464072() throws CoreException {
        CharsetTest.getResourcesPreferences().putBoolean("refresh.lightweight.enabled", true);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFile file = project.getFile("file.txt");
        ResourceTestUtil.createInWorkspace((IResource)file);
        file.getLocation().toFile().delete();
        CoreException e = (CoreException)Assert.assertThrows(CoreException.class, () -> ((IFile)file).getContentDescription());
        Assert.assertEquals((String)"the resource should not exist", (long)368L, (long)e.getStatus().getCode());
    }

    @Test
    public void testBug528827() throws CoreException, OperationCanceledException, InterruptedException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)project);
        JobChangeAdapterExtension listener = new JobChangeAdapterExtension();
        Job.getJobManager().addJobChangeListener((IJobChangeListener)listener);
        try {
            String otherCharset = this.getOtherCharset(workspace.getRoot().getDefaultCharset());
            project.setDefaultCharset(otherCharset, ResourceTestUtil.createTestMonitor());
            Assert.assertEquals((Object)otherCharset, (Object)project.getDefaultCharset());
            project.delete(false, ResourceTestUtil.createTestMonitor());
            Thread.sleep(100L);
            Job.getJobManager().wakeUp((Object)"org.eclipse.core.resourcescharsetJobFamily");
            Job.getJobManager().join((Object)"org.eclipse.core.resourcescharsetJobFamily", ResourceTestUtil.createTestMonitor());
            Assert.assertTrue((boolean)listener.getResult().isOK());
        }
        finally {
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)listener);
        }
    }

    private String getOtherCharset(String referenceCharset) {
        return "MIK".equals(referenceCharset) ? "UTF-8" : "MIK";
    }

    static void waitForCharsetManagerJob() {
        CharsetTest.waitForJobFamily(CharsetManager.class);
    }

    static void waitForNotificationManagerJob() {
        CharsetTest.waitForJobFamily(NotificationManager.class);
    }

    private static void waitForJobFamily(Object family) {
        TestUtil.waitForJobs("Waiting for " + String.valueOf(family), 100L, 10000L, family);
    }

    public class CharsetVerifier
    extends ResourceDeltaVerifier {
        static final int IGNORE_BACKGROUND_THREAD = 2;
        static final int IGNORE_CREATION_THREAD = 1;
        private final Thread creationThread = Thread.currentThread();
        private final int flags;

        CharsetVerifier(int flags) {
            this.flags = flags;
        }

        @Override
        void internalVerifyDelta(IResourceDelta delta) {
            IPath path = delta.getFullPath();
            if (path.segmentCount() == 2 && path.segment(1).equals(".project")) {
                return;
            }
            super.internalVerifyDelta(delta);
        }

        private boolean isSet(int mask) {
            return (mask & this.flags) == mask;
        }

        boolean ignoreEvent() {
            return this.isSet(2) && Thread.currentThread() != this.creationThread || this.isSet(1) && Thread.currentThread() == this.creationThread;
        }

        @Override
        public synchronized void resourceChanged(IResourceChangeEvent e) {
            if (this.ignoreEvent()) {
                return;
            }
            super.resourceChanged(e);
            this.notify();
        }

        public synchronized boolean waitForEvent(long limit) {
            Job.getJobManager().wakeUp(CharsetManager.class);
            int i = 1;
            while ((long)i < limit) {
                if (this.hasBeenNotified()) {
                    return true;
                }
                try {
                    this.wait(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
            return this.hasBeenNotified();
        }
    }

    private class CharsetVerifierWithExtraInfo
    extends CharsetVerifier {
        CharsetVerifierWithExtraInfo(int flags) {
            super(flags);
        }

        @Override
        public void verifyDelta(IResourceDelta delta) {
            this.appendToMessage("Delta verification triggered:");
            this.appendToMessage(Arrays.toString(Thread.currentThread().getStackTrace()));
            LinkedList<IResourceDelta> queue = new LinkedList<IResourceDelta>();
            queue.add(delta);
            while (!queue.isEmpty()) {
                IResourceDelta current = (IResourceDelta)queue.removeFirst();
                if (current == null) continue;
                this.appendToMessage("delta child: " + String.valueOf(current) + ", with flags: " + this.convertChangeFlags(current.getFlags()));
                IResourceDelta[] children = current.getAffectedChildren();
                if (children == null) continue;
                queue.addAll(Arrays.asList(children));
            }
            super.verifyDelta(delta);
        }
    }

    private static final class JobChangeAdapterExtension
    extends JobChangeAdapter {
        private IStatus result;

        public void done(IJobChangeEvent event) {
            if (event.getJob().belongsTo((Object)"org.eclipse.core.resourcescharsetJobFamily")) {
                this.result = event.getResult();
            }
        }

        IStatus getResult() {
            return this.result;
        }
    }

    private class MultipleDeltasCharsetVerifier
    extends Assert
    implements IResourceChangeListener {
        private final int flags;
        private final CharsetVerifier singleDeltaVerifier;
        private final List<CharsetVerifier> deltaVerifiers;
        private int expectedDeltasCount;
        private int verifiedDeltasCount;

        MultipleDeltasCharsetVerifier(int flags) {
            this.flags = flags;
            this.singleDeltaVerifier = new CharsetVerifierWithExtraInfo(flags);
            this.deltaVerifiers = new ArrayList<CharsetVerifier>();
            this.expectedDeltasCount = 0;
            this.verifiedDeltasCount = 0;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (!this.singleDeltaVerifier.ignoreEvent()) {
                this.singleDeltaVerifier.resourceChanged(event);
                if (this.verifiedDeltasCount < this.deltaVerifiers.size()) {
                    CharsetVerifier deltaVerifier = this.deltaVerifiers.get(this.verifiedDeltasCount);
                    deltaVerifier.resourceChanged(event);
                    ++this.verifiedDeltasCount;
                }
            }
        }

        boolean waitForAllDeltas(long firstDeltaTimeout, long lastDeltaTimeout) {
            boolean isSingleDelta;
            boolean firstDeltaReceived = this.waitForFirstDelta(firstDeltaTimeout);
            long waitingStart = System.currentTimeMillis();
            if (firstDeltaReceived && (isSingleDelta = this.singleDeltaVerifier.isDeltaValid())) {
                return true;
            }
            if (this.expectedDeltasCount > 0) {
                CharsetVerifier deltaVerifier = this.deltaVerifiers.get(this.deltaVerifiers.size() - 1);
                long waitedSoFar = System.currentTimeMillis() - waitingStart;
                long waitTimeout = lastDeltaTimeout - waitedSoFar;
                return deltaVerifier.waitForEvent(waitTimeout);
            }
            return true;
        }

        boolean waitForFirstDelta(long timeout) {
            return this.singleDeltaVerifier.waitForEvent(timeout);
        }

        void reset() {
            this.singleDeltaVerifier.reset();
            for (CharsetVerifier deltaVerifier : this.deltaVerifiers) {
                deltaVerifier.reset();
            }
            this.deltaVerifiers.clear();
        }

        void assertExpectedDeltasWereReceived(String message) {
            CharsetTest.waitForNotificationManagerJob();
            if (this.expectedDeltasCount > 0 && this.verifiedDeltasCount == 0) {
                MultipleDeltasCharsetVerifier.fail((String)(message + ", expected " + this.expectedDeltasCount + " deltas but received no deltas"));
            }
            if (this.verifiedDeltasCount > 0 && this.expectedDeltasCount == 0) {
                MultipleDeltasCharsetVerifier.fail((String)(message + ", expected no deltas but received " + this.verifiedDeltasCount + " deltas"));
            }
            if (!this.singleDeltaVerifier.isDeltaValid()) {
                if (this.verifiedDeltasCount == 1) {
                    MultipleDeltasCharsetVerifier.fail((String)(message + ", " + this.singleDeltaVerifier.getMessage()));
                } else {
                    boolean validDeltas = true;
                    StringBuilder failMessage = new StringBuilder(message);
                    int i = 0;
                    while (i < this.expectedDeltasCount) {
                        CharsetVerifier deltaVerifier = this.deltaVerifiers.get(i);
                        boolean isValidDelta = deltaVerifier.isDeltaValid();
                        validDeltas &= isValidDelta;
                        failMessage.append(System.lineSeparator());
                        failMessage.append("listing verification result for expected change with index " + i);
                        failMessage.append(System.lineSeparator());
                        failMessage.append("verifier.isValidDelta(): " + isValidDelta);
                        failMessage.append(System.lineSeparator());
                        failMessage.append(deltaVerifier.getMessage());
                        ++i;
                    }
                    MultipleDeltasCharsetVerifier.assertTrue((String)failMessage.toString(), (boolean)validDeltas);
                }
            }
        }

        void addExpectedChange(IResource resource, int status, int changeFlags) {
            this.addExpectedChange(new IResource[]{resource}, status, changeFlags);
        }

        void addExpectedChange(IResource[] resources, int status, int changeFlags) {
            this.singleDeltaVerifier.addExpectedChange(resources, status, changeFlags);
            CharsetVerifierWithExtraInfo deltaVerifier = new CharsetVerifierWithExtraInfo(this.flags);
            deltaVerifier.addExpectedChange(resources, status, changeFlags);
            this.deltaVerifiers.add(deltaVerifier);
            ++this.expectedDeltasCount;
        }

        void removeResourceChangeListeners() {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
    }
}

