/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.internal.content.ContentTypeHandler;
import org.eclipse.core.internal.content.ContentTypeSettings;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.IContentTypeSettings;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ContentDescriptionManagerTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private static final String CONTENT_TYPE_RELATED_NATURE1 = "org.eclipse.core.tests.resources.contentTypeRelated1";
    private static final String CONTENT_TYPE_RELATED_NATURE2 = "org.eclipse.core.tests.resources.contentTypeRelated2";

    public static void waitForCacheFlush() {
        try {
            Job.getJobManager().wakeUp((Object)"org.eclipse.core.resources.contentDescriptionCacheFamily");
            Job.getJobManager().join((Object)"org.eclipse.core.resources.contentDescriptionCacheFamily", null);
        }
        catch (InterruptedException | OperationCanceledException throwable) {
            // empty catch block
        }
    }

    protected InputStream projectDescriptionWithNatures(String project, String[] natures) {
        StringBuilder contents = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?><projectDescription><name>" + project + "</name><natures>");
        String[] stringArray = natures;
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            contents.append("<nature>" + nature + "</nature>");
            ++n2;
        }
        contents.append("</natures></projectDescription>");
        return new ByteArrayInputStream(contents.toString().getBytes());
    }

    @Test
    public void testBug79151() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("MyProject");
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType xml = contentTypeManager.getContentType("org.eclipse.core.runtime.xml");
        String newExtension = "xml_bug_79151";
        IFile file1 = project.getFile("file.xml");
        IFile file2 = project.getFile("file." + newExtension);
        ResourceTestUtil.createInWorkspace(file1, "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><org.eclipse.core.resources.tests.root/>");
        ResourceTestUtil.createInWorkspace(file2, "<?xml version=\"1.0\" encoding=\"US-ASCII\"?><org.eclipse.core.resources.tests.root/>");
        ((Workspace)workspace).getContentDescriptionManager().invalidateCache(true, null);
        ContentDescriptionManagerTest.waitForCacheFlush();
        Assert.assertEquals((String)"0.9", (long)1L, (long)((Workspace)workspace).getContentDescriptionManager().getCacheState());
        IContentDescription description1a = null;
        IContentDescription description1b = null;
        IContentDescription description1c = null;
        IContentDescription description1d = null;
        IContentDescription description2 = null;
        description1a = file1.getContentDescription();
        description2 = file2.getContentDescription();
        Assert.assertNotNull((String)"1.1", (Object)description1a);
        Assert.assertEquals((String)"1.2", (Object)xml, (Object)description1a.getContentType());
        Assert.assertNull((String)"1.3", (Object)description2);
        description1b = file1.getContentDescription();
        Assert.assertNotNull((String)" 2.1", (Object)description1b);
        Assert.assertSame((String)"2.2", (Object)description1a, (Object)description1b);
        try {
            xml.addFileSpec(newExtension, 8);
            description1c = file1.getContentDescription();
            description2 = file2.getContentDescription();
            Assert.assertNotNull((String)"4.1", (Object)description1c);
            Assert.assertNotSame((String)"4.2", (Object)description1a, (Object)description1c);
            Assert.assertEquals((String)"4.3", (Object)xml, (Object)description1c.getContentType());
            Assert.assertNotNull((String)"4.4", (Object)description2);
            Assert.assertEquals((String)"4.5", (Object)xml, (Object)description2.getContentType());
        }
        finally {
            xml.removeFileSpec(newExtension, 8);
        }
        description1d = file1.getContentDescription();
        description2 = file2.getContentDescription();
        Assert.assertNotNull((String)"5.1", (Object)description1d);
        Assert.assertNotSame((String)"5.2", (Object)description1c, (Object)description1d);
        Assert.assertEquals((String)"5.3", (Object)xml, (Object)description1d.getContentType());
        Assert.assertNull((String)"5.4", (Object)description2);
    }

    @Test
    public void testBug94516() throws Exception {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType text = contentTypeManager.getContentType("org.eclipse.core.runtime.text");
        Assert.assertNotNull((String)"0.1", (Object)text);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("proj1");
        IFile unrelatedFile = project.getFile("file.unrelated");
        ResourceTestUtil.createInWorkspace(unrelatedFile, "");
        IContentDescription description = null;
        description = unrelatedFile.getContentDescription();
        Assert.assertNull((String)"0.8", (Object)description);
        try {
            text.addFileSpec(unrelatedFile.getName(), 4);
            description = unrelatedFile.getContentDescription();
            Assert.assertNotNull((String)"1.1", (Object)description);
            Assert.assertEquals((String)"1.2", (Object)text, (Object)description.getContentType());
            ProjectScope projectScope = new ProjectScope(project);
            IEclipsePreferences contentTypePrefs = projectScope.getNode("org.eclipse.core.runtime/content-types");
            contentTypePrefs.putBoolean("enabled", true);
            contentTypePrefs.flush();
            description = unrelatedFile.getContentDescription();
            Assert.assertNull((String)"2.1", (Object)description);
            IContentTypeSettings settings = null;
            settings = text.getSettings((IScopeContext)projectScope);
            Assert.assertNotNull((String)"3.1", (Object)settings);
            Assert.assertNotSame((String)"3.2", (Object)text, (Object)settings);
            Assert.assertTrue((String)"3.3", (boolean)(settings instanceof ContentTypeSettings));
            settings.addFileSpec(unrelatedFile.getFullPath().getFileExtension(), 8);
            contentTypePrefs.flush();
            description = unrelatedFile.getContentDescription();
            Assert.assertNotNull((String)"5.1", (Object)description);
            Assert.assertEquals((String)"5.2", (Object)text, (Object)description.getContentType());
        }
        finally {
            text.removeFileSpec(unrelatedFile.getName(), 4);
        }
    }

    @Test
    public void testNatureContentTypeAssociation() throws Exception {
        InputStream input;
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType baseType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.nature_associated_1");
        IContentType derivedType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.nature_associated_2");
        Assert.assertNotNull((String)"0.1", (Object)baseType);
        Assert.assertNotNull((String)"0.2", (Object)derivedType);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("proj1");
        IFile file = project.getFile("file.nature-associated");
        IFile descFile = project.getFile(".project");
        ResourceTestUtil.createInWorkspace(file, "it really does not matter");
        IContentDescription description = null;
        Throwable throwable = null;
        Object var9_13 = null;
        try {
            input = this.projectDescriptionWithNatures(project.getName(), new String[0]);
            try {
                descFile.setContents(input, 1, ResourceTestUtil.createTestMonitor());
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ContentDescriptionManagerTest.waitForCacheFlush();
        description = file.getContentDescription();
        Assert.assertNotNull((String)"1.2", (Object)description);
        Assert.assertSame((String)"1.3", (Object)((ContentTypeHandler)baseType).getTarget(), (Object)((ContentTypeHandler)description.getContentType()).getTarget());
        throwable = null;
        var9_13 = null;
        try {
            input = this.projectDescriptionWithNatures(project.getName(), new String[]{CONTENT_TYPE_RELATED_NATURE1});
            try {
                descFile.setContents(input, 1, ResourceTestUtil.createTestMonitor());
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        ContentDescriptionManagerTest.waitForCacheFlush();
        description = file.getContentDescription();
        Assert.assertNotNull((String)"2.2", (Object)description);
        Assert.assertSame((String)"2.3", (Object)((ContentTypeHandler)baseType).getTarget(), (Object)((ContentTypeHandler)description.getContentType()).getTarget());
        throwable = null;
        var9_13 = null;
        try {
            input = this.projectDescriptionWithNatures(project.getName(), new String[]{CONTENT_TYPE_RELATED_NATURE2});
            try {
                descFile.setContents(input, 1, ResourceTestUtil.createTestMonitor());
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        ContentDescriptionManagerTest.waitForCacheFlush();
        description = file.getContentDescription();
        Assert.assertNotNull((String)"3.2", (Object)description);
        Assert.assertSame((String)"3.3", (Object)((ContentTypeHandler)derivedType).getTarget(), (Object)((ContentTypeHandler)description.getContentType()).getTarget());
        throwable = null;
        var9_13 = null;
        try {
            input = this.projectDescriptionWithNatures(project.getName(), new String[]{CONTENT_TYPE_RELATED_NATURE1, CONTENT_TYPE_RELATED_NATURE2});
            try {
                descFile.setContents(input, 1, ResourceTestUtil.createTestMonitor());
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
        ContentDescriptionManagerTest.waitForCacheFlush();
        description = file.getContentDescription();
        Assert.assertNotNull((String)"4.2", (Object)description);
        Assert.assertSame((String)"4.3", (Object)((ContentTypeHandler)baseType).getTarget(), (Object)((ContentTypeHandler)description.getContentType()).getTarget());
        descFile.setContents(this.projectDescriptionWithNatures(project.getName(), new String[0]), 1, ResourceTestUtil.createTestMonitor());
        ContentDescriptionManagerTest.waitForCacheFlush();
        description = file.getContentDescription();
        Assert.assertNotNull((String)"5.2", (Object)description);
        Assert.assertSame((String)"5.3", (Object)((ContentTypeHandler)baseType).getTarget(), (Object)((ContentTypeHandler)description.getContentType()).getTarget());
    }

    @Test
    public void testProjectSpecificCharset() throws Exception {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType text = contentTypeManager.getContentType("org.eclipse.core.runtime.text");
        IContentType xml = contentTypeManager.getContentType("org.eclipse.core.runtime.xml");
        Assert.assertNotNull((String)"0.1", (Object)text);
        Assert.assertNotNull((String)"0.2", (Object)xml);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("proj1");
        IFile txtFile = project.getFile("example.txt");
        IFile xmlFile = project.getFile("example.xml");
        ResourceTestUtil.createInWorkspace(txtFile, "");
        ResourceTestUtil.createInWorkspace(xmlFile, "");
        project.setDefaultCharset("FOO", ResourceTestUtil.createTestMonitor());
        Assert.assertEquals((String)"1.0", (Object)"FOO", (Object)txtFile.getCharset());
        Assert.assertEquals((String)"1.1", (Object)"UTF-8", (Object)xmlFile.getCharset());
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences contentTypePrefs = projectScope.getNode("org.eclipse.core.runtime/content-types");
        contentTypePrefs.putBoolean("enabled", true);
        contentTypePrefs.flush();
        IContentTypeSettings settings = null;
        settings = text.getSettings((IScopeContext)projectScope);
        settings.setDefaultCharset("BAR");
        contentTypePrefs.flush();
        Assert.assertEquals((String)"3.0", (Object)"BAR", (Object)txtFile.getCharset());
        Assert.assertEquals((String)"3.1", (Object)"UTF-8", (Object)xmlFile.getCharset());
        settings = xml.getSettings((IScopeContext)projectScope);
        settings.setDefaultCharset("");
        contentTypePrefs.flush();
        Assert.assertEquals((String)"4.1", (Object)"BAR", (Object)txtFile.getCharset());
        Assert.assertEquals((String)"4.2", (Object)"FOO", (Object)xmlFile.getCharset());
    }

    @Test
    public void testProjectSpecificFileAssociations() throws Exception {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType text = contentTypeManager.getContentType("org.eclipse.core.runtime.text");
        IContentType xml = contentTypeManager.getContentType("org.eclipse.core.runtime.xml");
        Assert.assertNotNull((String)"0.1", (Object)text);
        Assert.assertNotNull((String)"0.2", (Object)xml);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("proj1");
        String unrelatedFileExtension = "unrelated";
        IFile txtFile = project.getFile("example.txt");
        IFile xmlFile = project.getFile("example.xml");
        IFile unrelatedFile = project.getFile("file." + unrelatedFileExtension);
        ResourceTestUtil.createInWorkspace(txtFile, "");
        ResourceTestUtil.createInWorkspace(xmlFile, "");
        ResourceTestUtil.createInWorkspace(unrelatedFile, "");
        IContentDescription description = null;
        description = txtFile.getContentDescription();
        Assert.assertNotNull((String)"0.7b", (Object)description);
        Assert.assertEquals((String)"0.7c", (Object)text, (Object)description.getContentType());
        description = xmlFile.getContentDescription();
        Assert.assertNotNull((String)"0.8b", (Object)description);
        Assert.assertEquals((String)"0.8c", (Object)xml, (Object)description.getContentType());
        Assert.assertNull((String)"0.9b", (Object)unrelatedFile.getContentDescription());
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences contentTypePrefs = projectScope.getNode("org.eclipse.core.runtime/content-types");
        contentTypePrefs.putBoolean("enabled", true);
        contentTypePrefs.flush();
        description = txtFile.getContentDescription();
        Assert.assertNotNull((String)"1.0b", (Object)description);
        Assert.assertEquals((String)"1.0c", (Object)text, (Object)description.getContentType());
        description = xmlFile.getContentDescription();
        Assert.assertNotNull((String)"1.1b", (Object)description);
        Assert.assertEquals((String)"1.1c", (Object)xml, (Object)description.getContentType());
        Assert.assertNull((String)"1.2b", (Object)unrelatedFile.getContentDescription());
        IContentTypeSettings settings = null;
        settings = text.getSettings((IScopeContext)projectScope);
        Assert.assertNotNull((String)"2.1", (Object)settings);
        Assert.assertNotSame((String)"2.2", (Object)text, (Object)settings);
        Assert.assertTrue((String)"2.3", (boolean)(settings instanceof ContentTypeSettings));
        settings.addFileSpec(unrelatedFileExtension, 8);
        contentTypePrefs.flush();
        description = unrelatedFile.getContentDescription();
        Assert.assertNotNull((String)"3.2b", (Object)description);
        Assert.assertEquals((String)"3.2c", (Object)text, (Object)description.getContentType());
        description = txtFile.getContentDescription();
        Assert.assertNotNull((String)"3.3b", (Object)description);
        Assert.assertEquals((String)"3.3c", (Object)text, (Object)description.getContentType());
        description = xmlFile.getContentDescription();
        Assert.assertNotNull((String)"3.4b", (Object)description);
        Assert.assertEquals((String)"3.4c", (Object)xml, (Object)description.getContentType());
        contentTypePrefs.putBoolean("enabled", false);
        contentTypePrefs.flush();
        description = txtFile.getContentDescription();
        Assert.assertNotNull((String)"4.0b", (Object)description);
        Assert.assertEquals((String)"4.0c", (Object)text, (Object)description.getContentType());
        description = xmlFile.getContentDescription();
        Assert.assertNotNull((String)"4.1b", (Object)description);
        Assert.assertEquals((String)"4.1c", (Object)xml, (Object)description.getContentType());
        Assert.assertNull((String)"4.2b", (Object)unrelatedFile.getContentDescription());
        contentTypePrefs.putBoolean("enabled", true);
        contentTypePrefs.flush();
        settings.addFileSpec(xmlFile.getName(), 4);
        contentTypePrefs.flush();
        description = unrelatedFile.getContentDescription();
        Assert.assertNotNull((String)"5.2b", (Object)description);
        Assert.assertEquals((String)"5.2c", (Object)text, (Object)description.getContentType());
        description = txtFile.getContentDescription();
        Assert.assertNotNull((String)"5.3b", (Object)description);
        Assert.assertEquals((String)"5.3c", (Object)text, (Object)description.getContentType());
        description = xmlFile.getContentDescription();
        Assert.assertNotNull((String)"5.4b", (Object)description);
        Assert.assertEquals((String)"5.4c", (Object)text, (Object)description.getContentType());
    }
}

