/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.internal.resources.RegexFileInfoMatcher;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceFilterDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class FilteredResourceTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private static final String REGEX_FILTER_PROVIDER = "org.eclipse.core.resources.regexFilterMatcher";
    protected String childName = "File.txt";
    protected IProject closedProject;
    protected IFile existingFileInExistingProject;
    protected IFolder existingFolderInExistingFolder;
    protected IFolder existingFolderInExistingProject;
    protected IProject existingProject;
    protected IPath localFile;
    protected IPath localFolder;
    protected IFile nonExistingFileInExistingFolder;
    protected IFile nonExistingFileInExistingProject;
    protected IFile nonExistingFileInOtherExistingProject;
    protected IFolder nonExistingFolderInExistingFolder;
    protected IFolder nonExistingFolderInExistingProject;
    protected IFolder nonExistingFolderInOtherExistingProject;
    protected IFolder nonExistingFolder2InOtherExistingProject;
    protected IProject otherExistingProject;

    protected void doCleanup() throws Exception {
        ResourceTestUtil.createInWorkspace(new IResource[]{this.existingProject, this.otherExistingProject, this.closedProject, this.existingFolderInExistingProject, this.existingFolderInExistingFolder, this.existingFileInExistingProject});
        this.closedProject.close(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.removeFromWorkspace(new IResource[]{this.nonExistingFolderInExistingProject, this.nonExistingFolderInExistingFolder, this.nonExistingFolderInOtherExistingProject, this.nonExistingFolder2InOtherExistingProject, this.nonExistingFileInExistingProject, this.nonExistingFileInOtherExistingProject, this.nonExistingFileInExistingFolder});
        this.resolve(this.localFolder).toFile().mkdirs();
        ResourceTestUtil.createInFileSystem(this.resolve(this.localFile));
    }

    protected IPath resolve(IPath path) {
        return path;
    }

    protected URI resolve(URI uri) {
        return uri;
    }

    @Before
    public void setUp() throws Exception {
        this.existingProject = ResourcesPlugin.getWorkspace().getRoot().getProject("ExistingProject");
        this.otherExistingProject = ResourcesPlugin.getWorkspace().getRoot().getProject("OtherExistingProject");
        this.closedProject = ResourcesPlugin.getWorkspace().getRoot().getProject("ClosedProject");
        this.existingFolderInExistingProject = this.existingProject.getFolder("existingFolderInExistingProject");
        this.existingFolderInExistingFolder = this.existingFolderInExistingProject.getFolder("existingFolderInExistingFolder");
        this.nonExistingFolderInExistingProject = this.existingProject.getFolder("nonExistingFolderInExistingProject");
        this.nonExistingFolderInOtherExistingProject = this.otherExistingProject.getFolder("nonExistingFolderInOtherExistingProject");
        this.nonExistingFolder2InOtherExistingProject = this.otherExistingProject.getFolder("nonExistingFolder2InOtherExistingProject");
        this.nonExistingFolderInExistingFolder = this.existingFolderInExistingProject.getFolder("nonExistingFolderInExistingFolder");
        this.existingFileInExistingProject = this.existingProject.getFile("existingFileInExistingProject");
        this.nonExistingFileInExistingProject = this.existingProject.getFile("nonExistingFileInExistingProject");
        this.nonExistingFileInOtherExistingProject = this.otherExistingProject.getFile("nonExistingFileInOtherExistingProject");
        this.nonExistingFileInExistingFolder = this.existingFolderInExistingProject.getFile("nonExistingFileInExistingFolder");
        this.localFolder = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(this.resolve(this.localFolder));
        this.localFile = this.localFolder.append(this.childName);
        this.doCleanup();
    }

    @Test
    public void testCreateFilterOnFolder() throws CoreException {
        FileInfoMatcherDescription matcherDescription = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo");
        this.existingFolderInExistingProject.createFilter(13, matcherDescription, 0, ResourceTestUtil.createTestMonitor());
        IFile foo = this.existingFolderInExistingProject.getFile("foo");
        IFile bar = this.existingFolderInExistingProject.getFile("bar");
        ResourceTestUtil.createInWorkspace(new IResource[]{foo, bar});
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        this.existingProject.close(ResourceTestUtil.createTestMonitor());
        this.existingProject.open(ResourceTestUtil.createTestMonitor());
        Object[] filters = this.existingFolderInExistingProject.getFilters();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])filters).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{filter -> {
            ((AbstractStringAssert)Assertions.assertThat((String)filter.getFileInfoMatcherDescription().getId()).as("provider", new Object[0])).isEqualTo(REGEX_FILTER_PROVIDER);
            ((ObjectAssert)Assertions.assertThat((Object)filter.getFileInfoMatcherDescription().getArguments()).as("arguments", new Object[0])).isEqualTo((Object)"foo");
            ((AbstractIntegerAssert)Assertions.assertThat((int)filter.getType()).as("type", new Object[0])).isEqualTo(13);
            ((ObjectAssert)Assertions.assertThat((Object)filter.getResource()).as("resource", new Object[0])).isEqualTo((Object)this.existingFolderInExistingProject);
        }});
        Object[] members = this.existingFolderInExistingProject.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo");
        }});
        IWorkspace workspace = this.existingProject.getWorkspace();
        Assertions.assertThat((Object)bar).matches(it -> !workspace.validateFiltered((IResource)it).isOK(), "is filtered");
        Assertions.assertThat((Object)foo).matches(it -> workspace.validateFiltered((IResource)it).isOK(), "is not filtered");
    }

    @Test
    public void testCreateFilterOnProject() throws CoreException {
        FileInfoMatcherDescription matcherDescription = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo");
        this.existingProject.createFilter(9, matcherDescription, 0, ResourceTestUtil.createTestMonitor());
        IFolder foo = this.existingProject.getFolder("foo");
        IFolder bar = this.existingProject.getFolder("bar");
        ResourceTestUtil.createInWorkspace(new IResource[]{foo, bar});
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        this.existingProject.close(ResourceTestUtil.createTestMonitor());
        this.existingProject.open(ResourceTestUtil.createTestMonitor());
        Object[] filters = this.existingProject.getFilters();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])filters).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{filter -> {
            ((AbstractStringAssert)Assertions.assertThat((String)filter.getFileInfoMatcherDescription().getId()).as("provider", new Object[0])).isEqualTo(REGEX_FILTER_PROVIDER);
            ((ObjectAssert)Assertions.assertThat((Object)filter.getFileInfoMatcherDescription().getArguments()).as("arguments", new Object[0])).isEqualTo((Object)"foo");
            ((AbstractIntegerAssert)Assertions.assertThat((int)filter.getType()).as("type", new Object[0])).isEqualTo(9);
            ((ObjectAssert)Assertions.assertThat((Object)filter.getResource()).as("resource", new Object[0])).isEqualTo((Object)this.existingProject);
        }});
        Object[] members = this.existingProject.members();
        ((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(3)).filteredOn(member -> member.getType() == 2)).allSatisfy(member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(2);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo");
        });
        IWorkspace workspace = this.existingProject.getWorkspace();
        Assertions.assertThat((Object)bar).matches(it -> !workspace.validateFiltered((IResource)it).isOK(), "is filtered");
        Assertions.assertThat((Object)foo).matches(it -> workspace.validateFiltered((IResource)it).isOK(), "is not filtered");
    }

    @Test
    public void testCreateFilterOnLinkedFolder() throws CoreException {
        IPath location = FileSystemHelper.getRandomLocation();
        IFolder folder = this.nonExistingFolderInExistingProject;
        Assert.assertThrows(CoreException.class, () -> folder.createLink(location, 0, ResourceTestUtil.createTestMonitor()));
        FileInfoMatcherDescription matcherDescription = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo");
        folder.createFilter(5, matcherDescription, 0, ResourceTestUtil.createTestMonitor());
        IFile foo = folder.getFile("foo");
        IFile bar = folder.getFile("bar");
        ResourceTestUtil.createInWorkspace(new IResource[]{foo, bar});
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        this.existingProject.close(ResourceTestUtil.createTestMonitor());
        this.existingProject.open(ResourceTestUtil.createTestMonitor());
        Object[] filters = folder.getFilters();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])filters).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{filter -> {
            ((AbstractStringAssert)Assertions.assertThat((String)filter.getFileInfoMatcherDescription().getId()).as("provider", new Object[0])).isEqualTo(REGEX_FILTER_PROVIDER);
            ((ObjectAssert)Assertions.assertThat((Object)filter.getFileInfoMatcherDescription().getArguments()).as("arguments", new Object[0])).isEqualTo((Object)"foo");
            ((AbstractIntegerAssert)Assertions.assertThat((int)filter.getType()).as("type", new Object[0])).isEqualTo(5);
            ((ObjectAssert)Assertions.assertThat((Object)filter.getResource()).as("resource", new Object[0])).isEqualTo((Object)folder);
        }});
        Object[] members = folder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo");
        }});
        IWorkspace workspace = this.existingProject.getWorkspace();
        Assertions.assertThat((Object)bar).matches(it -> !workspace.validateFiltered((IResource)it).isOK(), "is filtered");
        Assertions.assertThat((Object)foo).matches(it -> workspace.validateFiltered((IResource)it).isOK(), "is not filtered");
    }

    @Test
    public void testCreateFilterOnLinkedFolderAndTarget() throws Exception {
        IPath location = this.existingFolderInExistingFolder.getLocation();
        IFolder folder = this.nonExistingFolderInExistingProject;
        folder.createLink(location, 0, ResourceTestUtil.createTestMonitor());
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*\\.cpp");
        FileInfoMatcherDescription matcherDescription2 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*\\.h");
        folder.createFilter(6, matcherDescription1, 0, ResourceTestUtil.createTestMonitor());
        IResourceFilterDescription filterDescription2 = this.existingFolderInExistingFolder.createFilter(6, matcherDescription2, 0, ResourceTestUtil.createTestMonitor());
        Object[] members = folder.members();
        Assertions.assertThat((Object[])members).isEmpty();
        members = this.existingFolderInExistingFolder.members();
        Assertions.assertThat((Object[])members).isEmpty();
        IFile newFile = this.existingFolderInExistingFolder.getFile("foo.cpp");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)newFile.getLocation().toFile().createNewFile()).withFailMessage("file creation not successful: %s", new Object[]{newFile})).isTrue();
        this.existingFolderInExistingFolder.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        members = this.existingFolderInExistingFolder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo.cpp");
        }});
        members = folder.members();
        Assertions.assertThat((Object[])members).isEmpty();
        newFile = this.existingFolderInExistingFolder.getFile("foo.h");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)newFile.getLocation().toFile().createNewFile()).withFailMessage("file creation not successful: %s", new Object[]{newFile})).isTrue();
        this.existingFolderInExistingFolder.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        members = this.existingFolderInExistingFolder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo.cpp");
        }});
        members = folder.members();
        Assertions.assertThat((Object[])members).isEmpty();
        folder.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        members = this.existingFolderInExistingFolder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo.cpp");
        }});
        members = folder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo.h");
        }});
        newFile = this.existingFolderInExistingFolder.getFile("foo.text");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)newFile.getLocation().toFile().createNewFile()).withFailMessage("file creation not successful: %s", new Object[]{newFile})).isTrue();
        this.existingFolderInExistingFolder.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        members = this.existingFolderInExistingFolder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{firstMember -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)firstMember.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)firstMember.getName()).as("name", new Object[0])).isEqualTo("foo.cpp");
        }, secondMember -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)secondMember.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)secondMember.getName()).as("name", new Object[0])).isEqualTo("foo.text");
        }});
        members = folder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{firstMember -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)firstMember.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)firstMember.getName()).as("name", new Object[0])).isEqualTo("foo.h");
        }, secondMember -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)secondMember.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)secondMember.getName()).as("name", new Object[0])).isEqualTo("foo.text");
        }});
        newFile.delete(true, ResourceTestUtil.createTestMonitor());
        members = this.existingFolderInExistingFolder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo.cpp");
        }});
        members = folder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo.h");
        }});
        filterDescription2.delete(0, ResourceTestUtil.createTestMonitor());
        members = this.existingFolderInExistingFolder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{firstMember -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)firstMember.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)firstMember.getName()).as("name", new Object[0])).isEqualTo("foo.cpp");
        }, secondMember -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)secondMember.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)secondMember.getName()).as("name", new Object[0])).isEqualTo("foo.h");
        }});
        members = folder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo.h");
        }});
        this.existingFolderInExistingFolder.createFilter(6, matcherDescription2, 0, ResourceTestUtil.createTestMonitor());
        members = this.existingFolderInExistingFolder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo.cpp");
        }});
        members = folder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo.h");
        }});
    }

    @Test
    public void testIResource_isFiltered() throws CoreException {
        IFolder folder = this.existingFolderInExistingProject.getFolder("virtual_folder.txt");
        IFile file = this.existingFolderInExistingProject.getFile("linked_file.txt");
        folder.create(8192, true, ResourceTestUtil.createTestMonitor());
        file.createLink(this.existingFileInExistingProject.getLocation(), 0, ResourceTestUtil.createTestMonitor());
        FileInfoMatcherDescription matcherDescription = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*\\.txt");
        this.existingFolderInExistingProject.createFilter(2, matcherDescription, 0, ResourceTestUtil.createTestMonitor());
        IWorkspace workspace = this.existingProject.getWorkspace();
        Assertions.assertThat((Object)folder).matches(it -> workspace.validateFiltered((IResource)it).isOK(), "is not filtered");
        Assertions.assertThat((Object)folder).matches(it -> workspace.validateFiltered((IResource)it).isOK(), "is not filtered");
    }

    @Test
    public void testCreateFilterOnLinkedFolderAndTarget2() throws Exception {
        IPath location = this.existingFolderInExistingFolder.getLocation();
        IFolder folder = this.nonExistingFolderInExistingProject;
        folder.createLink(location, 0, ResourceTestUtil.createTestMonitor());
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*\\.h");
        FileInfoMatcherDescription matcherDescription2 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*\\.cpp");
        folder.createFilter(5, matcherDescription1, 0, ResourceTestUtil.createTestMonitor());
        this.existingFolderInExistingFolder.createFilter(5, matcherDescription2, 0, ResourceTestUtil.createTestMonitor());
        IFile newFile = this.existingFolderInExistingFolder.getFile("foo.cpp");
        ResourceTestUtil.createInWorkspace((IResource)newFile);
        Object[] members = this.existingFolderInExistingFolder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo.cpp");
        }});
        newFile = folder.getFile("foo.h");
        ResourceTestUtil.createInWorkspace((IResource)newFile);
        members = folder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo.h");
        }});
        members = this.existingFolderInExistingFolder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).allSatisfy(member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo.cpp");
        });
        this.existingFolderInExistingFolder.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        members = this.existingFolderInExistingFolder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).allSatisfy(member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo.cpp");
        });
        this.modifyFileInWorkspace(folder.getFile("foo.h"));
        members = this.existingFolderInExistingFolder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).allSatisfy(member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo.cpp");
        });
    }

    private void modifyFileInWorkspace(IFile file) throws IOException, CoreException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream fileInputStream = file.getContents(false);){
            ByteArrayOutputStream originalContentStream = new ByteArrayOutputStream();
            fileInputStream.transferTo(originalContentStream);
            String originalContent = new String(originalContentStream.toByteArray(), StandardCharsets.UTF_8);
            String newContent = originalContent + "w";
            file.setContents(newContent.getBytes(StandardCharsets.UTF_8), false, false, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testCreateFilterOnLinkedFolderWithAlias() throws Exception {
        ResourceInfo ri;
        IProject project = this.otherExistingProject;
        IPath parentLoc = this.existingFolderInExistingProject.getLocation();
        IPath childLoc = this.existingFolderInExistingFolder.getLocation();
        IFolder folder1 = this.nonExistingFolderInOtherExistingProject;
        IFolder folder2 = this.nonExistingFolder2InOtherExistingProject;
        Assertions.assertThat((Object)folder1).matches(Predicate.not(IResource::exists), "does not exist");
        Assertions.assertThat((Object)folder2).matches(Predicate.not(IResource::exists), "does not exist");
        Assertions.assertThat((Object)parentLoc).matches(parentLocation -> parentLocation.isPrefixOf(childLoc), "is prefix of child location");
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*");
        IResourceFilterDescription filterDescription1 = folder1.createFilter(10, matcherDescription1, 0, ResourceTestUtil.createTestMonitor());
        folder1.createLink(parentLoc, 0, ResourceTestUtil.createTestMonitor());
        folder2.createLink(childLoc, 0, ResourceTestUtil.createTestMonitor());
        this.existingProject.close(ResourceTestUtil.createTestMonitor());
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)folder1).matches(IResource::exists, "exists")).matches(IResource::isLinked, "is linked")).extracting(IResource::getLocation).isEqualTo((Object)parentLoc);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)folder2).matches(IResource::exists, "exists")).matches(IResource::isLinked, "is linked")).extracting(IResource::getLocation).isEqualTo((Object)childLoc);
        Assertions.assertThat((Object[])folder1.members()).isEmpty();
        Assertions.assertThat((Object[])folder2.members()).isEmpty();
        Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        try {
            workspace.prepareOperation((ISchedulingRule)project, ResourceTestUtil.createTestMonitor());
            workspace.beginOperation(true);
            ri = ((Resource)project).getResourceInfo(false, true);
            ri.clear(16);
        }
        finally {
            workspace.endOperation((ISchedulingRule)project, true);
        }
        project.close(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)project).matches(Predicate.not(IProject::isOpen), "is not open");
        ResourceTestUtil.createInFileSystem(childLoc.append("foo"));
        project.open(0, ResourceTestUtil.createTestMonitor());
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)folder1).matches(IResource::exists, "exists")).matches(IResource::isLinked, "is linked")).extracting(IResource::getLocation).isEqualTo((Object)parentLoc);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)folder2).matches(IResource::exists, "exists")).matches(IResource::isLinked, "is linked")).extracting(IResource::getLocation).isEqualTo((Object)childLoc);
        Assertions.assertThat((Object[])folder1.members()).isEmpty();
        Assertions.assertThat((Object[])folder2.members()).hasSize(1);
        folder2.createLink(parentLoc, 256, ResourceTestUtil.createTestMonitor());
        folder1.createLink(childLoc, 257, ResourceTestUtil.createTestMonitor());
        folder2.createFilter(10, matcherDescription1, 0, ResourceTestUtil.createTestMonitor());
        filterDescription1.delete(0, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])folder1.getFilters()).isEmpty();
        try {
            workspace.prepareOperation((ISchedulingRule)project, ResourceTestUtil.createTestMonitor());
            workspace.beginOperation(true);
            ri = ((Resource)project).getResourceInfo(false, true);
            ri.clear(16);
        }
        finally {
            workspace.endOperation((ISchedulingRule)project, true);
        }
        project.close(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)project).matches(Predicate.not(IProject::isOpen), "is not open");
        project.open(0, ResourceTestUtil.createTestMonitor());
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)folder1).matches(IResource::exists, "exists")).matches(IResource::isLinked, "is linked")).extracting(IResource::getLocation).isEqualTo((Object)childLoc);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)folder2).matches(IResource::exists, "exists")).matches(IResource::isLinked, "is linked")).extracting(IResource::getLocation).isEqualTo((Object)parentLoc);
        Assertions.assertThat((Object[])folder1.members()).hasSize(1);
        Assertions.assertThat((Object[])folder2.members()).isEmpty();
    }

    @Test
    public void testCreateFilterOnLinkedFolderWithAlias2() throws CoreException {
        IProject project = this.otherExistingProject;
        IPath parentLoc = this.existingFolderInExistingProject.getLocation();
        IPath childLoc = this.existingFolderInExistingFolder.getLocation();
        IFolder folder1 = this.nonExistingFolderInOtherExistingProject;
        IFolder folder2 = this.nonExistingFolder2InOtherExistingProject;
        Assertions.assertThat((Object)folder1).matches(Predicate.not(IResource::exists), "does not exist");
        Assertions.assertThat((Object)folder2).matches(Predicate.not(IResource::exists), "does not exist");
        Assertions.assertThat((Object)parentLoc).matches(parentLocation -> parentLocation.isPrefixOf(childLoc), "is prefix of child location");
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*");
        IResourceFilterDescription filterDescription1 = folder1.createFilter(10, matcherDescription1, 0, ResourceTestUtil.createTestMonitor());
        folder1.createLink(parentLoc, 0, ResourceTestUtil.createTestMonitor());
        folder2.createLink(childLoc, 0, ResourceTestUtil.createTestMonitor());
        this.existingProject.close(ResourceTestUtil.createTestMonitor());
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)folder1).matches(IResource::exists, "exists")).matches(IResource::isLinked, "is linked")).extracting(IResource::getLocation).isEqualTo((Object)parentLoc);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)folder2).matches(IResource::exists, "exists")).matches(IResource::isLinked, "is linked")).extracting(IResource::getLocation).isEqualTo((Object)childLoc);
        Assertions.assertThat((Object[])folder1.members()).isEmpty();
        Assertions.assertThat((Object[])folder2.members()).isEmpty();
        Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        try {
            workspace.prepareOperation((ISchedulingRule)project, ResourceTestUtil.createTestMonitor());
            workspace.beginOperation(true);
            ResourceInfo ri = ((Resource)project).getResourceInfo(false, true);
            ri.clear(16);
        }
        finally {
            workspace.endOperation((ISchedulingRule)project, true);
        }
        ResourceTestUtil.createInWorkspace((IResource)folder2.getFile("foo"));
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)folder1).matches(IResource::exists, "exists")).matches(IResource::isLinked, "is linked")).extracting(IResource::getLocation).isEqualTo((Object)parentLoc);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)folder2).matches(IResource::exists, "exists")).matches(IResource::isLinked, "is linked")).extracting(IResource::getLocation).isEqualTo((Object)childLoc);
        Assertions.assertThat((Object[])folder1.members()).isEmpty();
        Assertions.assertThat((Object[])folder2.members()).hasSize(1);
        folder2.createLink(parentLoc, 256, ResourceTestUtil.createTestMonitor());
        folder1.createLink(childLoc, 257, ResourceTestUtil.createTestMonitor());
        folder2.createFilter(10, matcherDescription1, 0, ResourceTestUtil.createTestMonitor());
        filterDescription1.delete(0, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])folder1.getFilters()).isEmpty();
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)folder1).matches(IResource::exists, "exists")).matches(IResource::isLinked, "is linked")).extracting(IResource::getLocation).isEqualTo((Object)childLoc);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)folder2).matches(IResource::exists, "exists")).matches(IResource::isLinked, "is linked")).extracting(IResource::getLocation).isEqualTo((Object)parentLoc);
        Assertions.assertThat((Object[])folder1.members()).hasSize(1);
        Assertions.assertThat((Object[])folder2.members()).isEmpty();
    }

    @Test
    public void testCreateFilterOnLinkedFolderBeforeCreation() throws CoreException {
        IPath location = this.existingFolderInExistingFolder.getLocation();
        IFolder folder = this.nonExistingFolderInExistingProject;
        Assertions.assertThat((Object)folder).matches(Predicate.not(IResource::exists), "does not exist");
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo");
        folder.createFilter(5, matcherDescription1, 0, ResourceTestUtil.createTestMonitor());
        folder.createLink(location, 0, ResourceTestUtil.createTestMonitor());
        IFile foo = folder.getFile("foo");
        IFile bar = folder.getFile("bar");
        ResourceTestUtil.createInWorkspace(new IResource[]{foo, bar});
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        this.existingProject.close(ResourceTestUtil.createTestMonitor());
        this.existingProject.open(ResourceTestUtil.createTestMonitor());
        Object[] filters = folder.getFilters();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])filters).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{filter -> {
            ((AbstractStringAssert)Assertions.assertThat((String)filter.getFileInfoMatcherDescription().getId()).as("provider", new Object[0])).isEqualTo(REGEX_FILTER_PROVIDER);
            ((ObjectAssert)Assertions.assertThat((Object)filter.getFileInfoMatcherDescription().getArguments()).as("arguments", new Object[0])).isEqualTo((Object)"foo");
            ((AbstractIntegerAssert)Assertions.assertThat((int)filter.getType()).as("type", new Object[0])).isEqualTo(5);
            ((ObjectAssert)Assertions.assertThat((Object)filter.getResource()).as("resource", new Object[0])).isEqualTo((Object)folder);
        }});
        Object[] members = folder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo");
        }});
    }

    @Test
    public void testCreateAndRemoveFilterOnFolder() throws CoreException {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo");
        IResourceFilterDescription filterDescription = this.existingFolderInExistingFolder.createFilter(13, matcherDescription1, 0, ResourceTestUtil.createTestMonitor());
        IFile foo = this.existingFolderInExistingFolder.getFile("foo");
        IFile bar = this.existingFolderInExistingFolder.getFile("bar");
        ResourceTestUtil.createInWorkspace(new IResource[]{foo, bar});
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        this.existingProject.close(ResourceTestUtil.createTestMonitor());
        this.existingProject.open(ResourceTestUtil.createTestMonitor());
        filterDescription.delete(0, ResourceTestUtil.createTestMonitor());
        this.existingProject.close(ResourceTestUtil.createTestMonitor());
        this.existingProject.open(ResourceTestUtil.createTestMonitor());
        Object[] filters = this.existingFolderInExistingFolder.getFilters();
        Assertions.assertThat((Object[])filters).isEmpty();
        Object[] members = this.existingFolderInExistingFolder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{firstMember -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)firstMember.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)firstMember.getName()).as("name", new Object[0])).isEqualTo("bar");
        }, secondMember -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)secondMember.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)secondMember.getName()).as("name", new Object[0])).isEqualTo("foo");
        }});
    }

    @Test
    public void testCreateAndRemoveFilterOnFolderWithoutClosingProject() throws CoreException {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo");
        IResourceFilterDescription filterDescription = this.existingFolderInExistingFolder.createFilter(13, matcherDescription1, 0, ResourceTestUtil.createTestMonitor());
        IFile foo = this.existingFolderInExistingFolder.getFile("foo");
        IFile bar = this.existingFolderInExistingFolder.getFile("bar");
        ResourceTestUtil.createInWorkspace(new IResource[]{foo, bar});
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        filterDescription.delete(0, ResourceTestUtil.createTestMonitor());
        Object[] filters = this.existingFolderInExistingFolder.getFilters();
        Assertions.assertThat((Object[])filters).isEmpty();
        Object[] members = this.existingFolderInExistingFolder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{firstMember -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)firstMember.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)firstMember.getName()).as("name", new Object[0])).isEqualTo("bar");
        }, secondMember -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)secondMember.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)secondMember.getName()).as("name", new Object[0])).isEqualTo("foo");
        }});
    }

    @Test
    public void testIncludeOnlyFilter() throws CoreException {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*\\.c");
        this.existingFolderInExistingProject.createFilter(13, matcherDescription1, 0, ResourceTestUtil.createTestMonitor());
        IFile foo = this.existingFolderInExistingProject.getFile("foo.c");
        IFile file = this.existingFolderInExistingProject.getFile("file.c");
        IFile bar = this.existingFolderInExistingProject.getFile("bar.h");
        ResourceTestUtil.createInWorkspace(new IResource[]{foo, bar, file});
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Object[] members = this.existingFolderInExistingProject.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{firstMember -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)firstMember.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)firstMember.getName()).as("name", new Object[0])).isEqualTo("file.c");
        }, secondMember -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)secondMember.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)secondMember.getName()).as("name", new Object[0])).isEqualTo("foo.c");
        }});
        FileInfoMatcherDescription matcherDescription2 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*\\.c");
        this.existingFolderInExistingProject.createFilter(13, matcherDescription2, 0, ResourceTestUtil.createTestMonitor());
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        members = this.existingFolderInExistingProject.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{firstMember -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)firstMember.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)firstMember.getName()).as("name", new Object[0])).isEqualTo("file.c");
        }, secondMember -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)secondMember.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)secondMember.getName()).as("name", new Object[0])).isEqualTo("foo.c");
        }});
    }

    @Test
    public void testExcludeAllFilter() throws CoreException {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*\\.c");
        this.existingFolderInExistingFolder.createFilter(14, matcherDescription1, 0, ResourceTestUtil.createTestMonitor());
        IFile foo = this.existingFolderInExistingFolder.getFile("foo.c");
        IFile file = this.existingFolderInExistingFolder.getFile("file.c");
        IFile fooh = this.existingFolderInExistingFolder.getFile("foo.h");
        IFile bar = this.existingFolderInExistingFolder.getFile("bar.h");
        ResourceTestUtil.createInWorkspace(new IResource[]{foo, bar, file, fooh});
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Object[] members = this.existingFolderInExistingFolder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{firstMember -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)firstMember.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)firstMember.getName()).as("name", new Object[0])).isEqualTo("bar.h");
        }, secondMember -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)secondMember.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)secondMember.getName()).as("name", new Object[0])).isEqualTo("foo.h");
        }});
        FileInfoMatcherDescription matcherDescription2 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo.*");
        this.existingFolderInExistingFolder.createFilter(14, matcherDescription2, 0, ResourceTestUtil.createTestMonitor());
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        members = this.existingFolderInExistingFolder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("bar.h");
        }});
    }

    @Test
    public void testMixedFilter() throws CoreException {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*\\.c");
        FileInfoMatcherDescription matcherDescription2 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo.*");
        this.existingFolderInExistingProject.createFilter(13, matcherDescription1, 0, ResourceTestUtil.createTestMonitor());
        this.existingFolderInExistingProject.createFilter(14, matcherDescription2, 0, ResourceTestUtil.createTestMonitor());
        IFile foo = this.existingFolderInExistingProject.getFile("foo.c");
        IFile file = this.existingFolderInExistingProject.getFile("file.c");
        IFile fooh = this.existingFolderInExistingProject.getFile("foo.h");
        IFile bar = this.existingFolderInExistingProject.getFile("bar.h");
        ResourceTestUtil.createInWorkspace(new IResource[]{foo, bar, file, fooh});
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Object[] members = this.existingFolderInExistingProject.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("file.c");
        }});
    }

    @Test
    public void testInheritedFilter() throws CoreException {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*\\.c");
        FileInfoMatcherDescription matcherDescription2 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo.*");
        this.existingProject.createFilter(21, matcherDescription1, 0, ResourceTestUtil.createTestMonitor());
        this.existingFolderInExistingFolder.createFilter(14, matcherDescription2, 0, ResourceTestUtil.createTestMonitor());
        IFile foo = this.existingFolderInExistingFolder.getFile("foo.c");
        IFile file = this.existingFolderInExistingFolder.getFile("file.c");
        IFile fooh = this.existingFolderInExistingFolder.getFile("foo.h");
        IFile bar = this.existingFolderInExistingFolder.getFile("bar.h");
        ResourceTestUtil.createInWorkspace(new IResource[]{foo, bar, file, fooh});
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Object[] members = this.existingFolderInExistingFolder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("file.c");
        }});
    }

    @Test
    public void testFolderOnlyFilters() throws CoreException {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo.*");
        this.existingFolderInExistingFolder.createFilter(10, matcherDescription1, 0, ResourceTestUtil.createTestMonitor());
        IFile foo = this.existingFolderInExistingFolder.getFile("foo.c");
        IFolder food = this.existingFolderInExistingFolder.getFolder("foo.d");
        ResourceTestUtil.createInWorkspace(new IResource[]{foo, food});
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Object[] members = this.existingFolderInExistingFolder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(1);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo.c");
        }});
    }

    @Test
    public void testFileOnlyFilters() throws CoreException {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo.*");
        this.existingFolderInExistingFolder.createFilter(6, matcherDescription1, 0, ResourceTestUtil.createTestMonitor());
        IFile foo = this.existingFolderInExistingFolder.getFile("foo.c");
        IFolder food = this.existingFolderInExistingFolder.getFolder("foo.d");
        ResourceTestUtil.createInWorkspace(new IResource[]{foo, food});
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Object[] members = this.existingFolderInExistingFolder.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            ((AbstractIntegerAssert)Assertions.assertThat((int)member.getType()).as("type", new Object[0])).isEqualTo(2);
            ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo.d");
        }});
    }

    @Test
    public void testMoveFolderWithFilterToAnotherProject() throws CoreException {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo.*");
        this.existingFolderInExistingProject.createFilter(6, matcherDescription1, 0, ResourceTestUtil.createTestMonitor());
        IFile foo = this.existingFolderInExistingProject.getFile("foo.c");
        IFolder food = this.existingFolderInExistingProject.getFolder("foo.d");
        ResourceTestUtil.createInWorkspace(new IResource[]{foo, food});
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        IFolder destination = this.otherExistingProject.getFolder("destination");
        this.existingFolderInExistingProject.move(destination.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Object[] filters = this.existingFolderInExistingProject.getFilters();
        Assertions.assertThat((Object[])filters).isEmpty();
        filters = destination.getFilters();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])filters).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{filter -> {
            ((AbstractStringAssert)Assertions.assertThat((String)filter.getFileInfoMatcherDescription().getId()).as("provider", new Object[0])).isEqualTo(REGEX_FILTER_PROVIDER);
            ((ObjectAssert)Assertions.assertThat((Object)filter.getFileInfoMatcherDescription().getArguments()).as("arguments", new Object[0])).isEqualTo((Object)"foo.*");
            ((AbstractIntegerAssert)Assertions.assertThat((int)filter.getType()).as("type", new Object[0])).isEqualTo(6);
            ((ObjectAssert)Assertions.assertThat((Object)filter.getResource()).as("resource", new Object[0])).isEqualTo((Object)destination);
        }});
    }

    @Test
    public void testCopyFolderWithFilterToAnotherProject() throws CoreException {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo.*");
        this.existingFolderInExistingProject.createFilter(6, matcherDescription1, 0, ResourceTestUtil.createTestMonitor());
        IFile foo = this.existingFolderInExistingProject.getFile("foo.c");
        IFolder food = this.existingFolderInExistingProject.getFolder("foo.d");
        ResourceTestUtil.createInWorkspace(new IResource[]{foo, food});
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        IFolder destination = this.otherExistingProject.getFolder("destination");
        this.existingFolderInExistingProject.copy(destination.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Object[] filters = this.existingFolderInExistingProject.getFilters();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])filters).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{filter -> {
            ((AbstractStringAssert)Assertions.assertThat((String)filter.getFileInfoMatcherDescription().getId()).as("provider", new Object[0])).isEqualTo(REGEX_FILTER_PROVIDER);
            ((ObjectAssert)Assertions.assertThat((Object)filter.getFileInfoMatcherDescription().getArguments()).as("arguments", new Object[0])).isEqualTo((Object)"foo.*");
            ((AbstractIntegerAssert)Assertions.assertThat((int)filter.getType()).as("type", new Object[0])).isEqualTo(6);
            ((ObjectAssert)Assertions.assertThat((Object)filter.getResource()).as("resource", new Object[0])).isEqualTo((Object)this.existingFolderInExistingProject);
        }});
        filters = destination.getFilters();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])filters).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{filter -> {
            ((AbstractStringAssert)Assertions.assertThat((String)filter.getFileInfoMatcherDescription().getId()).as("provider", new Object[0])).isEqualTo(REGEX_FILTER_PROVIDER);
            ((ObjectAssert)Assertions.assertThat((Object)filter.getFileInfoMatcherDescription().getArguments()).as("arguments", new Object[0])).isEqualTo((Object)"foo.*");
            ((AbstractIntegerAssert)Assertions.assertThat((int)filter.getType()).as("type", new Object[0])).isEqualTo(6);
            ((ObjectAssert)Assertions.assertThat((Object)filter.getResource()).as("resource", new Object[0])).isEqualTo((Object)destination);
        }});
    }

    @Test
    public void testCopyFolderWithFilterToAnotherFolder() throws CoreException {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo.*");
        this.existingFolderInExistingProject.createFilter(6, matcherDescription1, 0, ResourceTestUtil.createTestMonitor());
        IFile foo = this.existingFolderInExistingProject.getFile("foo.c");
        IFolder food = this.existingFolderInExistingProject.getFolder("foo.d");
        ResourceTestUtil.createInWorkspace(new IResource[]{foo, food});
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.createInWorkspace(new IResource[]{this.nonExistingFolderInExistingProject});
        IFolder destination = this.nonExistingFolderInExistingProject.getFolder("destination");
        this.existingFolderInExistingProject.copy(destination.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Object[] filters = this.existingFolderInExistingProject.getFilters();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])filters).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{filter -> {
            ((AbstractStringAssert)Assertions.assertThat((String)filter.getFileInfoMatcherDescription().getId()).as("provider", new Object[0])).isEqualTo(REGEX_FILTER_PROVIDER);
            ((ObjectAssert)Assertions.assertThat((Object)filter.getFileInfoMatcherDescription().getArguments()).as("arguments", new Object[0])).isEqualTo((Object)"foo.*");
            ((AbstractIntegerAssert)Assertions.assertThat((int)filter.getType()).as("type", new Object[0])).isEqualTo(6);
            ((ObjectAssert)Assertions.assertThat((Object)filter.getResource()).as("resource", new Object[0])).isEqualTo((Object)this.existingFolderInExistingProject);
        }});
        filters = destination.getFilters();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])filters).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{filter -> {
            ((AbstractStringAssert)Assertions.assertThat((String)filter.getFileInfoMatcherDescription().getId()).as("provider", new Object[0])).isEqualTo(REGEX_FILTER_PROVIDER);
            ((ObjectAssert)Assertions.assertThat((Object)filter.getFileInfoMatcherDescription().getArguments()).as("arguments", new Object[0])).isEqualTo((Object)"foo.*");
            ((AbstractIntegerAssert)Assertions.assertThat((int)filter.getType()).as("type", new Object[0])).isEqualTo(6);
            ((ObjectAssert)Assertions.assertThat((Object)filter.getResource()).as("resource", new Object[0])).isEqualTo((Object)destination);
        }});
    }

    @Test
    public void testMoveFolderWithFilterToAnotherFolder() throws CoreException {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo.*");
        this.existingFolderInExistingProject.createFilter(6, matcherDescription1, 0, ResourceTestUtil.createTestMonitor());
        IFile foo = this.existingFolderInExistingProject.getFile("foo.c");
        IFolder food = this.existingFolderInExistingProject.getFolder("foo.d");
        ResourceTestUtil.createInWorkspace(new IResource[]{foo, food});
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.createInWorkspace(new IResource[]{this.nonExistingFolderInExistingProject});
        IFolder destination = this.nonExistingFolderInExistingProject.getFolder("destination");
        this.existingFolderInExistingProject.move(destination.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Object[] filters = this.existingFolderInExistingProject.getFilters();
        Assertions.assertThat((Object[])filters).isEmpty();
        filters = destination.getFilters();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])filters).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{filter -> {
            ((AbstractStringAssert)Assertions.assertThat((String)filter.getFileInfoMatcherDescription().getId()).as("provider", new Object[0])).isEqualTo(REGEX_FILTER_PROVIDER);
            ((ObjectAssert)Assertions.assertThat((Object)filter.getFileInfoMatcherDescription().getArguments()).as("arguments", new Object[0])).isEqualTo((Object)"foo.*");
            ((AbstractIntegerAssert)Assertions.assertThat((int)filter.getType()).as("type", new Object[0])).isEqualTo(6);
            ((ObjectAssert)Assertions.assertThat((Object)filter.getResource()).as("resource", new Object[0])).isEqualTo((Object)destination);
        }});
    }

    @Test
    public void testDeleteFolderWithFilterToAnotherFolder() throws CoreException {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo.*");
        FileInfoMatcherDescription matcherDescription2 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*\\.c");
        this.existingFolderInExistingProject.createFilter(6, matcherDescription1, 0, ResourceTestUtil.createTestMonitor());
        this.existingFolderInExistingFolder.createFilter(5, matcherDescription2, 0, ResourceTestUtil.createTestMonitor());
        IFile foo = this.existingFolderInExistingProject.getFile("foo.c");
        IFolder food = this.existingFolderInExistingProject.getFolder("foo.d");
        ResourceTestUtil.createInWorkspace(new IResource[]{foo, food});
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.createInWorkspace(new IResource[]{this.nonExistingFolderInExistingProject});
        this.existingFolderInExistingProject.delete(0, ResourceTestUtil.createTestMonitor());
        Object[] filters = this.existingFolderInExistingProject.getFilters();
        Assertions.assertThat((Object[])filters).isEmpty();
        filters = this.existingFolderInExistingFolder.getFilters();
        Assertions.assertThat((Object[])filters).isEmpty();
    }

    @Test
    public void testInvalidCharactersInRegExFilter() {
        RegexFileInfoMatcher matcher = new RegexFileInfoMatcher();
        Assert.assertThrows(CoreException.class, () -> matcher.initialize(this.existingProject, (Object)"*:*"));
    }

    @Test
    public void testBug302146() throws Exception {
        FileInfoMatcherDescription matcherDescription = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo");
        this.existingFolderInExistingProject.createFilter(13, matcherDescription, 0, ResourceTestUtil.createTestMonitor());
        this.existingProject.close(ResourceTestUtil.createTestMonitor());
        this.existingProject.open(ResourceTestUtil.createTestMonitor());
        Object[] filters = this.existingFolderInExistingProject.getFilters();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])filters).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{filter -> {
            ((AbstractStringAssert)Assertions.assertThat((String)filter.getFileInfoMatcherDescription().getId()).as("provider", new Object[0])).isEqualTo(REGEX_FILTER_PROVIDER);
            ((ObjectAssert)Assertions.assertThat((Object)filter.getFileInfoMatcherDescription().getArguments()).as("arguments", new Object[0])).isEqualTo((Object)"foo");
            ((AbstractIntegerAssert)Assertions.assertThat((int)filter.getType()).as("type", new Object[0])).isEqualTo(13);
            ((ObjectAssert)Assertions.assertThat((Object)filter.getResource()).as("resource", new Object[0])).isEqualTo((Object)this.existingFolderInExistingProject);
        }});
        new ProjectDescriptionReader(this.existingProject).read(this.existingProject.getFile(".project").getLocation());
    }

    @Test
    public void test317783() throws CoreException {
        IFolder folder = this.existingProject.getFolder("foo");
        ResourceTestUtil.createInWorkspace((IResource)folder);
        IFile file = folder.getFile("bar.txt");
        ResourceTestUtil.createInWorkspace(file, "content");
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        FileInfoMatcherDescription matcherDescription = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*");
        this.existingProject.createFilter(10, matcherDescription, 0, ResourceTestUtil.createTestMonitor());
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Object[] members = this.existingProject.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)first.getName()).isEqualTo(".project");
        }, second -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)second.getName()).isEqualTo(this.existingFileInExistingProject.getName());
        }});
        folder.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        members = this.existingProject.members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)first.getName()).isEqualTo(".project");
        }, second -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)second.getName()).isEqualTo(this.existingFileInExistingProject.getName());
        }});
        Assertions.assertThat((Object)folder).matches(Predicate.not(IResource::exists), "does not exist");
        Assertions.assertThat((Object)file).matches(Predicate.not(IResource::exists), "does not exist");
    }

    @Test
    public void test317824() throws CoreException {
        IFolder folder = this.existingProject.getFolder("foo");
        ResourceTestUtil.createInWorkspace((IResource)folder);
        IFile file = folder.getFile("bar.txt");
        ResourceTestUtil.createInWorkspace(file, "content");
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        FileInfoMatcherDescription matcherDescription = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*");
        this.existingProject.createFilter(10, matcherDescription, 0, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])this.existingProject.getFilters()).hasSize(1);
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        IPath newPath = this.existingProject.getFullPath().removeLastSegments(1).append(this.existingProject.getName() + "_moved");
        this.existingProject.move(newPath, true, ResourceTestUtil.createTestMonitor());
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.existingProject.getName() + "_moved");
        Assertions.assertThat((Object)newProject).matches(IResource::exists, "exists");
        Assertions.assertThat((Object[])newProject.getFilters()).hasSize(1);
        newPath = newProject.getFullPath().removeLastSegments(1).append(newProject.getName() + "_copy");
        newProject.copy(newPath, true, ResourceTestUtil.createTestMonitor());
        newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(newProject.getName() + "_copy");
        Assertions.assertThat((Object)newProject).matches(IResource::exists, "exists");
        Assertions.assertThat((Object[])newProject.getFilters()).hasSize(1);
    }

    @Test
    public void test328464() throws CoreException {
        IFolder folder = this.existingProject.getFolder(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)folder);
        IFile file_a_txt = folder.getFile("a.txt");
        ResourceTestUtil.createInWorkspace((IResource)file_a_txt);
        FileInfoMatcherDescription matcherDescription = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"a\\.txt");
        this.existingProject.createFilter(22, matcherDescription, 0, ResourceTestUtil.createTestMonitor());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Assertions.assertThat((Object)file_a_txt).matches(it -> !workspace.validateFiltered((IResource)it).isOK(), "is filtered");
        File ioFile = file_a_txt.getLocation().toFile();
        Assertions.assertThat((File)ioFile).exists();
        ioFile.renameTo(new File(file_a_txt.getLocation().removeLastSegments(1).append("A.txt").toString()));
        Assertions.assertThat((Object)file_a_txt).matches(it -> !workspace.validateFiltered((IResource)it).isOK(), "is filtered");
        folder.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)file_a_txt).matches(Predicate.not(IResource::exists), "does not exists");
        Assertions.assertThat((Object)file_a_txt).matches(it -> !workspace.validateFiltered((IResource)it).isOK(), "is filtered");
        IFile file_A_txt = folder.getFile("A.txt");
        Assertions.assertThat((Object)file_A_txt).matches(IResource::exists, "exists");
        Assertions.assertThat((Object)file_A_txt).matches(it -> workspace.validateFiltered((IResource)it).isOK(), "is not filtered");
    }

    @Test
    public void test343914() throws CoreException {
        String subProjectName = "subProject";
        IPath subProjectLocation = this.existingProject.getLocation().append(subProjectName);
        FileInfoMatcherDescription matcherDescription = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)subProjectName);
        this.existingProject.createFilter(30, matcherDescription, 0, ResourceTestUtil.createTestMonitor());
        IPath fileLocation = subProjectLocation.append("file.txt");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile result = root.getFileForLocation(fileLocation);
        Assertions.assertThat((Object)result).isNull();
        Object[] results = root.findFilesForLocation(fileLocation);
        Assertions.assertThat((Object[])results).isEmpty();
        IPath containerLocation = subProjectLocation.append("folder");
        IContainer resultContainer = root.getContainerForLocation(containerLocation);
        Assertions.assertThat((Object)resultContainer).isNull();
        Object[] resultsContainer = root.findContainersForLocation(containerLocation);
        Assertions.assertThat((Object[])resultsContainer).isEmpty();
        IProject subProject = root.getProject(subProjectName);
        IProjectDescription newProjectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(subProjectName);
        newProjectDescription.setLocation(subProjectLocation);
        subProject.create(newProjectDescription, ResourceTestUtil.createTestMonitor());
        result = root.getFileForLocation(fileLocation);
        ((ObjectAssert)Assertions.assertThat((Object)result).isNotNull()).extracting(IResource::getProject).isEqualTo((Object)subProject);
        results = root.findFilesForLocation(fileLocation);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])results).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{it -> {
            AbstractAssert abstractAssert = Assertions.assertThat((Object)it.getProject()).isEqualTo((Object)subProject);
        }});
        resultContainer = root.getContainerForLocation(containerLocation);
        ((ObjectAssert)Assertions.assertThat((Object)resultContainer).isNotNull()).extracting(IResource::getProject).isEqualTo((Object)subProject);
        resultsContainer = root.findContainersForLocation(containerLocation);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])resultsContainer).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{it -> {
            AbstractAssert abstractAssert = Assertions.assertThat((Object)it.getProject()).isEqualTo((Object)subProject);
        }});
    }
}

