/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class FixDotProjectPathResourceListener
implements IResourceChangeListener,
ILifecycleListener {
    private final Map<IProject, Instant> createdProjects = new HashMap<IProject, Instant>();
    private boolean enabled;
    private final File tmpDir = FixDotProjectPathResourceListener.createTmpDir();

    private static File createTmpDir() {
        try {
            return Files.createTempDirectory(FixDotProjectPathResourceListener.class.getSimpleName(), new FileAttribute[0]).toFile();
        }
        catch (Exception x) {
            return null;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.enabled || event.getDelta() == null) {
            return;
        }
        try {
            event.getDelta().accept(delta -> {
                IProject project;
                IResource iResource = delta.getResource();
                if (iResource instanceof IProject && (project = (IProject)iResource).isOpen() && this.createdProjects.containsKey(project)) {
                    Instant projectCreation = this.createdProjects.remove(project);
                    Path dotProjectOnDisk = project.getLocation().append(".project").toPath();
                    try {
                        BasicFileAttributes attributes = Files.getFileAttributeView(dotProjectOnDisk, BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
                        if (attributes.creationTime().toInstant().isAfter(projectCreation)) {
                            Job job = new Job("Link .project for " + project.getName()){

                                public IStatus run(IProgressMonitor monitor) {
                                    try {
                                        project.getWorkspace().run(pm -> {
                                            project.refreshLocal(2, pm);
                                            FixDotProjectPathResourceListener.this.linkDotProject(project);
                                            project.refreshLocal(2, pm);
                                        }, project.getWorkspace().getRuleFactory().modifyRule((IResource)project.getParent()), 1, monitor);
                                        return Status.OK_STATUS;
                                    }
                                    catch (CoreException ex) {
                                        return ex.getStatus();
                                    }
                                }
                            };
                            job.setRule(project.getWorkspace().getRuleFactory().modifyRule((IResource)project.getParent()));
                            job.setPriority(10);
                            job.schedule(0L);
                        }
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                return delta.getResource().getType() == 8;
            });
        }
        catch (CoreException e) {
            ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
        }
    }

    private void linkDotProject(IProject project) throws CoreException {
        if (!this.enabled) {
            return;
        }
        IFile dotProject = project.getFile(".project");
        if (dotProject.isLinked()) {
            return;
        }
        File targetDiskFile = this.getMetaDataFilePath(project.getName(), dotProject.getProjectRelativePath()).toFile();
        if (!targetDiskFile.exists()) {
            try {
                targetDiskFile.getParentFile().mkdirs();
                Files.copy(dotProject.getLocation().toPath(), targetDiskFile.toPath(), new CopyOption[0]);
            }
            catch (Exception ex) {
                throw new CoreException(Status.error((String)(String.valueOf(targetDiskFile) + " cannot be created"), (Throwable)ex));
            }
        }
        File sourceDiskFile = dotProject.getLocation().toFile();
        dotProject.createLink(IPath.fromFile((File)targetDiskFile), 257, null);
        sourceDiskFile.delete();
    }

    private IPath getMetaDataFilePath(String name, IPath projectRelativePath) {
        return IPath.fromFile((File)this.tmpDir).append(name).append(projectRelativePath);
    }

    public void handleEvent(LifecycleEvent event) throws CoreException {
        if (event.kind == 8) {
            if (event.resource instanceof IProject) {
                IProject project = (IProject)event.resource;
                this.createdProjects.put(project, Instant.now());
            }
        } else if (event.kind == 4096) {
            this.unlinkIfLocal(event.resource);
        } else if (event.kind == 1) {
            this.unlink(event.resource.getProject().getFile(".project"));
        }
    }

    private void unlink(IFile file) {
        if (!file.isLinked()) {
            return;
        }
        File targetFile = file.getProject().getLocation().append(file.getProjectRelativePath()).toFile();
        if (Objects.equals(file.getLocationURI(), targetFile.toURI())) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream contents = file.getContents();){
                Files.copy(contents, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException ex) {
            ex.printStackTrace();
        }
    }

    private void unlinkIfLocal(IResource resource) {
        IProject project;
        if (resource instanceof IProject && (project = (IProject)resource).isOpen()) {
            try {
                Arrays.stream(project.members()).filter(IFile.class::isInstance).map(IFile.class::cast).filter(IResource::isLinked).filter(file -> file.getProject().getLocation().append(file.getProjectRelativePath()).toFile().isFile()).forEach(file -> {
                    try {
                        file.delete(false, false, null);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                });
            }
            catch (CoreException e) {
                ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
            }
        }
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }
}

