/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class FreezeMonitor {
    public static final long FROZEN_TEST_TIMEOUT_MS = 60000L;
    private static Job monitorJob;

    public static void expectCompletionInAMinute() {
        FreezeMonitor.expectCompletionIn(60000L);
    }

    public static void expectCompletionIn(long timeout) {
        FreezeMonitor.done();
        monitorJob = new Job("FreezeMonitor"){

            public IStatus run(IProgressMonitor monitor) {
                ThreadInfo[] allThreads;
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                StringBuilder result = new StringBuilder();
                result.append("Possible frozen test case\n");
                ThreadMXBean threadStuff = ManagementFactory.getThreadMXBean();
                ThreadInfo[] threadInfoArray = allThreads = threadStuff.getThreadInfo(threadStuff.getAllThreadIds(), 200);
                int n = allThreads.length;
                int n2 = 0;
                while (n2 < n) {
                    ThreadInfo threadInfo = threadInfoArray[n2];
                    if (threadInfo != null) {
                        StackTraceElement[] elements;
                        result.append("\"");
                        result.append(threadInfo.getThreadName());
                        result.append("\": ");
                        result.append((Object)threadInfo.getThreadState());
                        result.append("\n");
                        StackTraceElement[] stackTraceElementArray = elements = threadInfo.getStackTrace();
                        int n3 = elements.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            StackTraceElement element = stackTraceElementArray[n4];
                            result.append("    ");
                            result.append(element);
                            result.append("\n");
                            ++n4;
                        }
                        result.append("\n");
                    }
                    ++n2;
                }
                System.out.println(result.toString());
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return FreezeMonitor.class == family;
            }
        };
        monitorJob.schedule(timeout);
    }

    public static void done() {
        if (monitorJob != null) {
            monitorJob.cancel();
            monitorJob = null;
        }
    }
}

