/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.ResourceVisitorVerifier;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class HiddenResourceTest {
    @Rule
    public TestName testName = new TestName();
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    @Test
    public void testRefreshLocal() throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(ResourceTestUtil.createUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] resources = new IResource[]{project, folder, file, subFile};
        ResourceTestUtil.createInWorkspace(resources);
        ResourceTestUtil.waitForEncodingRelatedJobs(this.testName.getMethodName());
        ResourceDeltaVerifier listener = new ResourceDeltaVerifier();
        listener.addExpectedChange((IResource)subFile, 4, 256);
        this.addResourceChangeListener(listener);
        try {
            this.setHidden((IResource)folder, true, 0);
            ResourceTestUtil.ensureOutOfSync(subFile);
            project.refreshLocal(2, ResourceTestUtil.createTestMonitor());
            Assert.assertTrue((String)listener.getMessage(), (boolean)listener.isDeltaValid());
        }
        finally {
            this.removeResourceChangeListener(listener);
        }
    }

    @Test
    public void testFindMember() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(ResourceTestUtil.createUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] resources = new IResource[]{project, folder, file, subFile};
        ResourceTestUtil.createInWorkspace(resources);
        Assert.assertEquals((String)"1.0", (Object)project, (Object)root.findMember(project.getFullPath()));
        Assert.assertEquals((String)"1.1", (Object)folder, (Object)root.findMember(folder.getFullPath()));
        Assert.assertEquals((String)"1.2", (Object)file, (Object)root.findMember(file.getFullPath()));
        Assert.assertEquals((String)"1.3", (Object)subFile, (Object)root.findMember(subFile.getFullPath()));
        this.setHidden((IResource)folder, true, 0);
        Assert.assertEquals((String)"2.1", (Object)project, (Object)root.findMember(project.getFullPath()));
        Assert.assertEquals((String)"2.2", (Object)folder, (Object)root.findMember(folder.getFullPath()));
        Assert.assertEquals((String)"2.3", (Object)file, (Object)root.findMember(file.getFullPath()));
        Assert.assertEquals((String)"2.4", (Object)subFile, (Object)root.findMember(subFile.getFullPath()));
        this.setHidden((IResource)project, true, 2);
        Assert.assertEquals((String)"3.1", (Object)project, (Object)root.findMember(project.getFullPath()));
        Assert.assertEquals((String)"3.2", (Object)folder, (Object)root.findMember(folder.getFullPath()));
        Assert.assertEquals((String)"3.3", (Object)file, (Object)root.findMember(file.getFullPath()));
        Assert.assertEquals((String)"3.4", (Object)subFile, (Object)root.findMember(subFile.getFullPath()));
    }

    @Test
    public void testMembers() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] resources = new IResource[]{project, folder, file, subFile};
        Object[] members = null;
        ResourceTestUtil.createInWorkspace(resources);
        this.assertHidden((IResource)project, false, 2);
        members = project.members();
        Assertions.assertThat((Object[])members).hasSize(4);
        members = folder.members();
        Assertions.assertThat((Object[])members).hasSize(1);
        this.setHidden((IResource)project, true, 2);
        this.assertHidden((IResource)project, true, 2);
        this.assertHidden((IResource)project, true, 2);
        members = project.members();
        Assertions.assertThat((Object[])members).isEmpty();
        members = folder.members();
        Assertions.assertThat((Object[])members).isEmpty();
        this.setHidden((IResource)project, false, 2);
        this.assertHidden((IResource)project, false, 2);
        members = project.members(0);
        Assertions.assertThat((Object[])members).hasSize(4);
        members = project.members(8);
        Assertions.assertThat((Object[])members).hasSize(4);
        members = folder.members();
        Assertions.assertThat((Object[])members).hasSize(1);
        this.setHidden((IResource)folder, true, 0);
        members = project.members();
        Assertions.assertThat((Object[])members).hasSize(3);
        members = folder.members();
        Assertions.assertThat((Object[])members).hasSize(1);
        members = project.members(0);
        Assertions.assertThat((Object[])members).hasSize(3);
        members = folder.members();
        Assertions.assertThat((Object[])members).hasSize(1);
        members = project.members(8);
        Assertions.assertThat((Object[])members).hasSize(4);
        members = folder.members();
        Assertions.assertThat((Object[])members).hasSize(1);
        this.setHidden((IResource)project, true, 2);
        this.assertHidden((IResource)project, true, 2);
        members = project.members(0);
        Assertions.assertThat((Object[])members).isEmpty();
        members = folder.members(0);
        Assertions.assertThat((Object[])members).isEmpty();
        members = project.members(8);
        Assertions.assertThat((Object[])members).hasSize(4);
        members = folder.members(8);
        Assertions.assertThat((Object[])members).hasSize(1);
    }

    @Test
    public void testAccept() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IFolder settings = project.getFolder(".settings");
        IFile prefs = settings.getFile("org.eclipse.core.resources.prefs");
        IResource[] resources = new IResource[]{project, folder, file, subFile, settings, prefs};
        ResourceTestUtil.createInWorkspace(resources);
        IFile description = project.getFile(".project");
        ResourceVisitorVerifier visitor = new ResourceVisitorVerifier();
        visitor.addExpected(resources);
        visitor.addExpected((IResource)description);
        project.accept((IResourceVisitor)visitor);
        Assert.assertTrue((String)visitor.getMessage(), (boolean)visitor.isValid());
        visitor.reset();
        visitor.addExpected(resources);
        visitor.addExpected((IResource)description);
        project.accept((IResourceVisitor)visitor, 2, 0);
        Assert.assertTrue((String)visitor.getMessage(), (boolean)visitor.isValid());
        visitor.reset();
        visitor.addExpected(resources);
        visitor.addExpected((IResource)description);
        project.accept((IResourceVisitor)visitor, 2, 8);
        Assert.assertTrue((String)visitor.getMessage(), (boolean)visitor.isValid());
        this.setHidden((IResource)folder, true, 0);
        visitor.reset();
        visitor.addExpected((IResource)project);
        visitor.addExpected((IResource)file);
        visitor.addExpected((IResource)description);
        visitor.addExpected((IResource)settings);
        visitor.addExpected((IResource)prefs);
        project.accept((IResourceVisitor)visitor);
        Assert.assertTrue((String)visitor.getMessage(), (boolean)visitor.isValid());
        visitor.reset();
        visitor.addExpected((IResource)project);
        visitor.addExpected((IResource)file);
        visitor.addExpected((IResource)description);
        visitor.addExpected((IResource)settings);
        visitor.addExpected((IResource)prefs);
        project.accept((IResourceVisitor)visitor, 2, 0);
        Assert.assertTrue((String)visitor.getMessage(), (boolean)visitor.isValid());
        visitor.reset();
        visitor.addExpected(resources);
        visitor.addExpected((IResource)description);
        project.accept((IResourceVisitor)visitor, 2, 8);
        Assert.assertTrue((String)visitor.getMessage(), (boolean)visitor.isValid());
        visitor.reset();
        folder.accept((IResourceVisitor)visitor);
        Assert.assertTrue((String)visitor.getMessage(), (boolean)visitor.isValid());
        visitor.reset();
        folder.accept((IResourceVisitor)visitor, 2, 0);
        Assert.assertTrue((String)visitor.getMessage(), (boolean)visitor.isValid());
        visitor.reset();
        visitor.addExpected((IResource)folder);
        visitor.addExpected((IResource)subFile);
        folder.accept((IResourceVisitor)visitor, 2, 8);
        Assert.assertTrue((String)visitor.getMessage(), (boolean)visitor.isValid());
    }

    @Test
    public void testCopy() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(ResourceTestUtil.createUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] resources = new IResource[]{project, folder, file, subFile};
        ResourceTestUtil.createInWorkspace(resources);
        IProject destProject = root.getProject("MyOtherProject");
        IFolder destFolder = destProject.getFolder(folder.getName());
        IFile destFile = destProject.getFile(file.getName());
        IFile destSubFile = destFolder.getFile(subFile.getName());
        IResource[] destResources = new IResource[]{destProject, destFolder, destFile, destSubFile};
        ResourceTestUtil.removeFromWorkspace(destResources);
        this.setHidden((IResource)folder, true, 0);
        int flags = 1;
        project.copy(destProject.getFullPath(), flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace(resources);
        ResourceTestUtil.assertExistsInWorkspace(destResources);
        ResourceTestUtil.removeFromWorkspace(destResources);
        ResourceTestUtil.createInWorkspace(resources);
        ResourceTestUtil.createInWorkspace((IResource)destProject);
        this.setHidden((IResource)folder, true, 0);
        folder.copy(destFolder.getFullPath(), flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{folder, subFile});
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{destFolder, destSubFile});
        ResourceTestUtil.removeFromWorkspace(destResources);
        ResourceTestUtil.createInWorkspace(resources);
        this.setHidden((IResource)project, true, 2);
        project.copy(destProject.getFullPath(), flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace(resources);
        ResourceTestUtil.assertExistsInWorkspace(destResources);
        ResourceTestUtil.removeFromWorkspace(destResources);
        ResourceTestUtil.createInWorkspace(resources);
        ResourceTestUtil.createInWorkspace((IResource)destProject);
        this.setHidden((IResource)project, true, 2);
        folder.copy(destFolder.getFullPath(), flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{folder, subFile});
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{destFolder, destSubFile});
    }

    @Test
    public void testMove() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(ResourceTestUtil.createUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] resources = new IResource[]{project, folder, file, subFile};
        ResourceTestUtil.createInWorkspace(resources);
        IProject destProject = root.getProject("MyOtherProject");
        IFolder destFolder = destProject.getFolder(folder.getName());
        IFile destFile = destProject.getFile(file.getName());
        IFile destSubFile = destFolder.getFile(subFile.getName());
        IResource[] destResources = new IResource[]{destProject, destFolder, destFile, destSubFile};
        ResourceTestUtil.removeFromWorkspace(destResources);
        this.setHidden((IResource)folder, true, 0);
        int flags = 1;
        project.move(destProject.getFullPath(), flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(resources);
        ResourceTestUtil.assertExistsInWorkspace(destResources);
        ResourceTestUtil.removeFromWorkspace(destResources);
        ResourceTestUtil.createInWorkspace(resources);
        ResourceTestUtil.createInWorkspace((IResource)destProject);
        this.setHidden((IResource)folder, true, 0);
        folder.move(destFolder.getFullPath(), flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(new IResource[]{folder, subFile});
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{destFolder, destSubFile});
        ResourceTestUtil.removeFromWorkspace(destResources);
        ResourceTestUtil.createInWorkspace(resources);
        this.setHidden((IResource)project, true, 2);
        project.move(destProject.getFullPath(), flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(resources);
        ResourceTestUtil.assertExistsInWorkspace(destResources);
        ResourceTestUtil.removeFromWorkspace(destResources);
        ResourceTestUtil.createInWorkspace(resources);
        ResourceTestUtil.createInWorkspace((IResource)destProject);
        this.setHidden((IResource)project, true, 2);
        folder.move(destFolder.getFullPath(), flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(new IResource[]{folder, subFile});
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{destFolder, destSubFile});
    }

    @Test
    public void testDelete() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(ResourceTestUtil.createUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] resources = new IResource[]{project, folder, file, subFile};
        ResourceTestUtil.createInWorkspace(resources);
        int flags = 5;
        project.delete(flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(resources);
        ResourceTestUtil.createInWorkspace(resources);
        file.delete(flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{project, folder, subFile});
        ResourceTestUtil.createInWorkspace(resources);
        folder.delete(flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(new IResource[]{folder, subFile});
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{project, file});
        ResourceTestUtil.createInWorkspace(resources);
        this.setHidden((IResource)folder, true, 0);
        project.delete(flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(resources);
        ResourceTestUtil.createInWorkspace(resources);
        this.setHidden((IResource)folder, true, 0);
        folder.delete(flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(new IResource[]{folder, subFile});
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{project, file});
        ResourceTestUtil.createInWorkspace(resources);
        this.setHidden((IResource)project, true, 2);
        project.delete(flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(resources);
        ResourceTestUtil.createInWorkspace(resources);
        this.setHidden((IResource)project, true, 2);
        file.delete(flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{project, folder, subFile});
        ResourceTestUtil.createInWorkspace(resources);
        this.setHidden((IResource)project, true, 2);
        folder.delete(flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(new IResource[]{folder, subFile});
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{project, file});
    }

    @Test
    public void testDeltas() throws CoreException {
        IWorkspaceRunnable body;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(ResourceTestUtil.createUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IFile description = project.getFile(".project");
        IFolder settings = project.getFolder(".settings");
        IFile prefs = settings.getFile("org.eclipse.core.resources.prefs");
        IResource[] resources = new IResource[]{project, folder, file, subFile, settings, prefs};
        ResourceDeltaVerifier listener = new ResourceDeltaVerifier();
        try {
            body = monitor -> ResourceTestUtil.createInWorkspace(resources);
            listener.addExpectedChange(resources, 1, 0);
            listener.addExpectedChange((IResource)project, 1, 16384);
            listener.addExpectedChange((IResource)description, 1, 0);
            this.addResourceChangeListener(listener);
            ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
            ResourceTestUtil.waitForBuild();
            ResourceTestUtil.waitForEncodingRelatedJobs(this.testName.getMethodName());
            Assert.assertTrue((String)listener.getMessage(), (boolean)listener.isDeltaValid());
            ResourceTestUtil.removeFromWorkspace(resources);
        }
        finally {
            this.removeResourceChangeListener(listener);
        }
        try {
            body = monitor -> {
                ResourceTestUtil.createInWorkspace(resources);
                this.setHidden((IResource)folder, true, 0);
            };
            listener.reset();
            listener.addExpectedChange(resources, 1, 0);
            listener.addExpectedChange((IResource)project, 1, 16384);
            listener.addExpectedChange((IResource)description, 1, 0);
            this.addResourceChangeListener(listener);
            ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
            Assert.assertTrue((String)listener.getMessage(), (boolean)listener.isDeltaValid());
            ResourceTestUtil.removeFromWorkspace(resources);
        }
        finally {
            this.removeResourceChangeListener(listener);
        }
        try {
            body = monitor -> {
                ResourceTestUtil.createInWorkspace(resources);
                this.setHidden((IResource)project, true, 2);
            };
            listener.reset();
            listener.addExpectedChange(resources, 1, 0);
            listener.addExpectedChange((IResource)project, 1, 16384);
            listener.addExpectedChange((IResource)description, 1, 0);
            this.addResourceChangeListener(listener);
            ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
            Assert.assertTrue((String)("3.1." + listener.getMessage()), (boolean)listener.isDeltaValid());
            ResourceTestUtil.removeFromWorkspace(resources);
        }
        finally {
            this.removeResourceChangeListener(listener);
        }
    }

    private void removeResourceChangeListener(ResourceDeltaVerifier listener) throws CoreException {
        listener.shutDown();
        ResourcesPlugin.getWorkspace().run(p -> ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener), null);
    }

    private void addResourceChangeListener(ResourceDeltaVerifier listener) throws CoreException {
        ResourcesPlugin.getWorkspace().run(p -> {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
            listener.active();
        }, null);
    }

    @Test
    public void testExists() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] resources = new IResource[]{project, folder, file, subFile};
        ResourceTestUtil.createInWorkspace(resources);
        ResourceTestUtil.assertExistsInWorkspace(resources);
        this.setHidden((IResource)folder, true, 0);
        this.assertHidden((IResource)folder, true, 0);
        ResourceTestUtil.assertExistsInWorkspace(resources);
        this.setHidden((IResource)project, true, 2);
        this.assertHidden((IResource)project, true, 2);
        ResourceTestUtil.assertExistsInWorkspace(resources);
    }

    @Test
    public void testSetGet() throws CoreException {
        IResource resource;
        IResource resource2;
        IResource resource3;
        IResource[] resources;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] iResourceArray = resources = new IResource[]{project, folder, file, subFile};
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            resource3 = iResourceArray[n2];
            Assert.assertThrows(CoreException.class, () -> resource3.setHidden(true));
            ++n2;
        }
        ResourceTestUtil.createInWorkspace(resources);
        iResourceArray = resources;
        n = resources.length;
        n2 = 0;
        while (n2 < n) {
            resource = resource2 = iResourceArray[n2];
            Assert.assertTrue((String)("1.0: " + String.valueOf(resource.getFullPath())), (!resource.isHidden() ? 1 : 0) != 0);
            ++n2;
        }
        iResourceArray = resources;
        n = resources.length;
        n2 = 0;
        while (n2 < n) {
            resource3 = iResourceArray[n2];
            resource3.setHidden(true);
            ++n2;
        }
        iResourceArray = resources;
        n = resources.length;
        n2 = 0;
        while (n2 < n) {
            resource = resource2 = iResourceArray[n2];
            switch (resource.getType()) {
                case 1: 
                case 2: 
                case 4: {
                    Assert.assertTrue((String)("3.0: " + String.valueOf(resource.getFullPath())), (boolean)resource.isHidden());
                    break;
                }
                case 8: {
                    Assert.assertFalse((String)("3.1: " + String.valueOf(resource.getFullPath())), (boolean)resource.isHidden());
                }
            }
            ++n2;
        }
        iResourceArray = resources;
        n = resources.length;
        n2 = 0;
        while (n2 < n) {
            resource3 = iResourceArray[n2];
            resource3.setHidden(false);
            ++n2;
        }
        iResourceArray = resources;
        n = resources.length;
        n2 = 0;
        while (n2 < n) {
            resource = resource2 = iResourceArray[n2];
            Assert.assertFalse((String)("5.0: " + String.valueOf(resource.getFullPath())), (boolean)resource.isHidden());
            ++n2;
        }
    }

    @Test
    public void testCreateHiddenResources() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        ResourceTestUtil.createInWorkspace((IResource)project);
        folder.create(4096, true, ResourceTestUtil.createTestMonitor());
        file.create(ResourceTestUtil.createRandomContentsStream(), 4096, ResourceTestUtil.createTestMonitor());
        this.assertHidden((IResource)project, false, 0);
        this.assertHidden((IResource)folder, true, 0);
        this.assertHidden((IResource)file, true, 0);
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        project2.create(null, 4096, ResourceTestUtil.createTestMonitor());
        project2.open(ResourceTestUtil.createTestMonitor());
        this.assertHidden((IResource)project2, true, 0);
    }

    protected void assertHidden(IResource root, boolean value, int depth) throws CoreException {
        IResourceVisitor visitor = resource -> {
            boolean expected = false;
            if (resource.getType() == 4 || resource.getType() == 1 || resource.getType() == 2) {
                expected = value;
            }
            Assert.assertEquals((String)String.valueOf(resource.getFullPath()), (Object)expected, (Object)resource.isHidden());
            return true;
        };
        root.accept(visitor, depth, 8);
    }

    protected void setHidden(IResource root, boolean value, int depth) throws CoreException {
        IResourceVisitor visitor = resource -> {
            resource.setHidden(value);
            return true;
        };
        root.accept(visitor, depth, 8);
    }
}

