/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.TestPerformer;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class IFileTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    public static final String DOES_NOT_EXIST = "DoesNotExistFile";
    public static final String EXISTING = "ExistingFile";
    public static final String LOCAL_ONLY = "LocalOnlyFile";
    public static final String OUT_OF_SYNC = "OutOfSyncFile";
    protected static final IProgressMonitor[] PROGRESS_MONITORS;
    protected static final Boolean[] TRUE_AND_FALSE;
    public static final String WORKSPACE_ONLY = "WorkspaceOnlyFile";
    public static final String EXISTING_HIDDEN = ".ExistingFileHidden";
    public static final String LOCAL_ONLY_HIDDEN = ".LocalOnlyFileHidden";
    public static final String WORKSPACE_ONLY_HIDDEN = ".WorkspaceOnlyFileHidden";
    ArrayList<IFile> allFiles = new ArrayList();
    IProject[] projects = null;

    static {
        IProgressMonitor[] iProgressMonitorArray = new IProgressMonitor[2];
        iProgressMonitorArray[0] = new FussyProgressMonitor();
        PROGRESS_MONITORS = iProgressMonitorArray;
        TRUE_AND_FALSE = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
    }

    public boolean existsAndOpen(IContainer container) {
        if (!container.exists()) {
            return false;
        }
        if (container instanceof IFolder) {
            return true;
        }
        if (container instanceof IProject) {
            IProject project = (IProject)container;
            return project.isOpen();
        }
        throw new IllegalArgumentException("Unhandled container type: " + String.valueOf(container));
    }

    protected void generateInterestingFiles() throws CoreException {
        IProject[] interestingProjects;
        IProject[] iProjectArray = interestingProjects = this.interestingProjects();
        int n = interestingProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.generateInterestingFiles((IContainer)project);
            this.generateInterestingFiles((IContainer)project.getFolder("NonExistentFolder"));
            if (project.exists() && project.isOpen()) {
                IFolder folder = project.getFolder("ExistingFolder");
                folder.create(true, true, ResourceTestUtil.createTestMonitor());
                this.generateInterestingFiles((IContainer)folder);
            }
            ++n2;
        }
    }

    public void generateInterestingFiles(IContainer container) {
        this.allFiles.add(container.getFile(IPath.fromOSString((String)DOES_NOT_EXIST)));
        this.allFiles.add(container.getFile(IPath.fromOSString((String)LOCAL_ONLY)));
        this.allFiles.add(container.getFile(IPath.fromOSString((String)LOCAL_ONLY_HIDDEN)));
        if (this.existsAndOpen(container)) {
            this.allFiles.add(container.getFile(IPath.fromOSString((String)EXISTING)));
            this.allFiles.add(container.getFile(IPath.fromOSString((String)EXISTING_HIDDEN)));
            this.allFiles.add(container.getFile(IPath.fromOSString((String)WORKSPACE_ONLY)));
            this.allFiles.add(container.getFile(IPath.fromOSString((String)WORKSPACE_ONLY_HIDDEN)));
            this.allFiles.add(container.getFile(IPath.fromOSString((String)OUT_OF_SYNC)));
        }
    }

    public IFile[] interestingFiles() throws Exception {
        this.refreshFiles();
        IFile[] result = new IFile[this.allFiles.size()];
        this.allFiles.toArray(result);
        return result;
    }

    public IProject[] interestingProjects() throws CoreException {
        if (this.projects == null) {
            this.projects = new IProject[3];
            IProject openProject = ResourcesPlugin.getWorkspace().getRoot().getProject("OpenProject");
            openProject.create(ResourceTestUtil.createTestMonitor());
            openProject.open(ResourceTestUtil.createTestMonitor());
            this.projects[0] = openProject;
            IProject closedProject = ResourcesPlugin.getWorkspace().getRoot().getProject("ClosedProject");
            closedProject.create(ResourceTestUtil.createTestMonitor());
            this.projects[1] = closedProject;
            this.projects[2] = ResourcesPlugin.getWorkspace().getRoot().getProject("NonExistentProject");
        }
        return this.projects;
    }

    public InputStream[] interestingStreams() {
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        ByteArrayInputStream bis = new ByteArrayInputStream(new byte[0]);
        streams.add(bis);
        streams.add(ResourceTestUtil.createRandomContentsStream());
        bis = new ByteArrayInputStream(new byte[10000]);
        streams.add(bis);
        InputStream[] results = new InputStream[streams.size()];
        streams.toArray(results);
        return results;
    }

    public boolean outOfSync(IFile file) {
        return file.getName().equals(OUT_OF_SYNC) || file.getName().equals(WORKSPACE_ONLY) || file.getName().equals(WORKSPACE_ONLY_HIDDEN);
    }

    public void refreshFile(IFile file) throws CoreException, IOException {
        if (file.getName().equals(LOCAL_ONLY)) {
            ResourceTestUtil.removeFromWorkspace((IResource)file);
            if (file.getProject().exists()) {
                ResourceTestUtil.createInFileSystem((IResource)file);
            }
            return;
        }
        if (file.getName().equals(LOCAL_ONLY_HIDDEN)) {
            ResourceTestUtil.removeFromWorkspace((IResource)file);
            if (file.getProject().exists()) {
                file.getRawLocation().toFile().delete();
                ResourceTestUtil.createInFileSystem((IResource)file);
                if (Platform.OS.isWindows()) {
                    Files.setAttribute(file.getRawLocation().toPath(), "dos:hidden", Boolean.TRUE, new LinkOption[0]);
                }
            }
            return;
        }
        if (file.getName().equals(WORKSPACE_ONLY)) {
            ResourceTestUtil.createInWorkspace((IResource)file);
            ResourceTestUtil.removeFromFileSystem((IResource)file);
            return;
        }
        if (file.getName().equals(WORKSPACE_ONLY_HIDDEN)) {
            file.getRawLocation().toFile().delete();
            ResourceTestUtil.createInFileSystem((IResource)file);
            if (Platform.OS.isWindows()) {
                Files.setAttribute(file.getRawLocation().toPath(), "dos:hidden", Boolean.TRUE, new LinkOption[0]);
            }
            file.refreshLocal(1, null);
            file.getRawLocation().toFile().delete();
            return;
        }
        if (file.getName().equals(DOES_NOT_EXIST)) {
            ResourceTestUtil.removeFromWorkspace((IResource)file);
            if (file.getProject().exists()) {
                ResourceTestUtil.removeFromFileSystem((IResource)file);
            }
            return;
        }
        if (file.getName().equals(EXISTING)) {
            ResourceTestUtil.createInWorkspace((IResource)file);
            return;
        }
        if (file.getName().equals(EXISTING_HIDDEN)) {
            ResourceTestUtil.createInWorkspace((IResource)file);
            if (Platform.OS.isWindows()) {
                Files.setAttribute(file.getRawLocation().toPath(), "dos:hidden", Boolean.TRUE, new LinkOption[0]);
            }
            file.refreshLocal(1, null);
            return;
        }
        if (file.getName().equals(OUT_OF_SYNC)) {
            ResourceTestUtil.createInWorkspace((IResource)file);
            ResourceTestUtil.ensureOutOfSync(file);
            return;
        }
    }

    public void refreshFiles() throws CoreException, IOException {
        for (IFile file : this.allFiles) {
            this.refreshFile(file);
        }
    }

    @Before
    public void setUp() throws Exception {
        this.generateInterestingFiles();
    }

    @Test
    public void testAppendContents() throws Exception {
        IFile target = this.projects[0].getFile("file1");
        target.create(ResourceTestUtil.createInputStream("abc"), false, null);
        Assert.assertEquals((Object)"abc", (Object)target.readString());
        target.appendContents(ResourceTestUtil.createInputStream("def"), false, false, null);
        Assert.assertEquals((Object)"abcdef", (Object)target.readString());
    }

    @Test
    public void testAppendContents2() throws Exception {
        IFile file = this.projects[0].getFile("file1");
        ResourceTestUtil.removeFromWorkspace((IResource)file);
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        file.create(null, false, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"1.0", (!file.isLocal(0) ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.1", (!file.getLocation().toFile().exists() ? 1 : 0) != 0);
        ResourceTestUtil.createInFileSystem((IResource)file);
        Assert.assertTrue((String)"1.2", (!file.isLocal(0) ? 1 : 0) != 0);
        monitor.prepare();
        file.appendContents(ResourceTestUtil.createRandomContentsStream(), 1, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"1.5", (boolean)file.isLocal(0));
        Assert.assertTrue((String)"1.6", (boolean)file.getLocation().toFile().exists());
        ResourceTestUtil.removeFromWorkspace((IResource)file);
        monitor.prepare();
        file.create(null, false, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"2.0", (!file.isLocal(0) ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.1", (!file.getLocation().toFile().exists() ? 1 : 0) != 0);
        monitor.prepare();
        Assert.assertThrows(CoreException.class, () -> file.appendContents(ResourceTestUtil.createRandomContentsStream(), 1, (IProgressMonitor)monitor));
        monitor.sanityCheck();
        Assert.assertTrue((String)"2.4", (!file.isLocal(0) ? 1 : 0) != 0);
        ResourceTestUtil.removeFromWorkspace((IResource)file);
        monitor.prepare();
        file.create(null, false, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"3.0", (!file.isLocal(0) ? 1 : 0) != 0);
        Assert.assertTrue((String)"3.1", (!file.getLocation().toFile().exists() ? 1 : 0) != 0);
        ResourceTestUtil.createInFileSystem((IResource)file);
        Assert.assertTrue((String)"3.2", (!file.isLocal(0) ? 1 : 0) != 0);
        monitor.prepare();
        Assert.assertThrows(CoreException.class, () -> file.appendContents(ResourceTestUtil.createRandomContentsStream(), 0, (IProgressMonitor)monitor));
        monitor.assertUsedUp();
        Assert.assertTrue((String)"3.5", (!file.isLocal(0) ? 1 : 0) != 0);
        ResourceTestUtil.removeFromWorkspace((IResource)file);
        monitor.prepare();
        file.create(null, false, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"4.0", (!file.isLocal(0) ? 1 : 0) != 0);
        Assert.assertTrue((String)"4.1", (!file.getLocation().toFile().exists() ? 1 : 0) != 0);
        monitor.prepare();
        Assert.assertThrows(CoreException.class, () -> file.appendContents(ResourceTestUtil.createRandomContentsStream(), 0, (IProgressMonitor)monitor));
        monitor.sanityCheck();
        Assert.assertTrue((String)"4.4", (!file.isLocal(0) ? 1 : 0) != 0);
        ResourceTestUtil.removeFromWorkspace((IResource)file);
    }

    @Test
    public void testCreate() throws Exception {
        Object[][] inputs = new Object[][]{this.interestingFiles(), this.interestingStreams(), TRUE_AND_FALSE, PROGRESS_MONITORS};
        new TestPerformer("IFileTest.testCreate"){

            @Override
            public void cleanUp(Object[] args, int count) throws Exception {
                IFile file = (IFile)args[0];
                IFileTest.this.refreshFile(file);
            }

            @Override
            public Object[] interestingOldState(Object[] args) throws Exception {
                return null;
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IFile file = (IFile)args[0];
                InputStream stream = (InputStream)args[1];
                boolean force = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (monitor instanceof FussyProgressMonitor) {
                    FussyProgressMonitor fussy = (FussyProgressMonitor)monitor;
                    fussy.prepare();
                }
                file.create(stream, force, monitor);
                if (monitor instanceof FussyProgressMonitor) {
                    FussyProgressMonitor fussy = (FussyProgressMonitor)monitor;
                    fussy.sanityCheck();
                }
                return null;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                boolean fileExistsInFS;
                IFile file = (IFile)args[0];
                IPath fileLocation = file.getLocation();
                boolean force = (Boolean)args[2];
                boolean fileExistsInWS = file.exists();
                boolean bl = fileExistsInFS = fileLocation != null && fileLocation.toFile().exists();
                if (!file.getParent().isAccessible()) {
                    return true;
                }
                if (force && !fileExistsInWS) {
                    return false;
                }
                return fileExistsInWS || fileExistsInFS;
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                IFile file = (IFile)args[0];
                return file.exists();
            }
        }.performTest(inputs);
    }

    @Test
    public void testCreateDerived() throws CoreException {
        IFile derived = this.projects[0].getFile("derived.txt");
        ResourceTestUtil.createInWorkspace((IResource)this.projects[0]);
        ResourceTestUtil.removeFromWorkspace((IResource)derived);
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        derived.create(ResourceTestUtil.createRandomContentsStream(), 1024, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"1.0", (boolean)derived.isDerived());
        Assert.assertTrue((String)"1.1", (!derived.isTeamPrivateMember() ? 1 : 0) != 0);
        monitor.prepare();
        derived.delete(false, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        monitor.prepare();
        derived.create(ResourceTestUtil.createRandomContentsStream(), 0, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"2.0", (!derived.isDerived() ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.1", (!derived.isTeamPrivateMember() ? 1 : 0) != 0);
    }

    @Test
    public void testCreateBytes() throws CoreException {
        IFile derived = this.projects[0].getFile("derived.txt");
        ResourceTestUtil.createInWorkspace((IResource)this.projects[0]);
        ResourceTestUtil.removeFromWorkspace((IResource)derived);
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        derived.create("derived".getBytes(), false, true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((boolean)derived.isDerived());
        Assert.assertFalse((boolean)derived.isTeamPrivateMember());
        Assert.assertEquals((Object)"derived", (Object)derived.readString());
        monitor.prepare();
        derived.delete(false, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        monitor.prepare();
        derived.create("notDerived".getBytes(), false, false, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertFalse((boolean)derived.isDerived());
        Assert.assertFalse((boolean)derived.isTeamPrivateMember());
        Assert.assertEquals((Object)"notDerived", (Object)derived.readString());
        IFolder subFolder = this.projects[0].getFolder("subFolder");
        subFolder.create(true, true, null);
        subFolder.getRawLocation().toFile().delete();
        IFile orphan = subFolder.getFile("myParentDoesNotExist.txt");
        monitor.prepare();
        orphan.write("parentDoesNotExistInFileSystemButInWorkspace".getBytes(), true, false, false, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertEquals((Object)"parentDoesNotExistInFileSystemButInWorkspace", (Object)orphan.readString());
        monitor.prepare();
        orphan.getParent().delete(true, null);
        try {
            orphan.write("parentDoesNotExist - not even in workspace".getBytes(), true, false, false, (IProgressMonitor)monitor);
            Assert.assertFalse((String)"should not be reached", (boolean)true);
        }
        catch (ResourceException expected) {
            monitor.assertUsedUp();
            Assert.assertFalse((boolean)orphan.exists());
        }
    }

    @Test
    public void testWrite() throws CoreException {
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        description.setMaxFileStates(4);
        ResourcesPlugin.getWorkspace().setDescription(description);
        IFile derived = this.projects[0].getFile("derived.txt");
        ResourceTestUtil.createInWorkspace((IResource)this.projects[0]);
        ResourceTestUtil.removeFromWorkspace((IResource)derived);
        int i = 0;
        while (i < 16) {
            boolean setDerived = i % 2 == 0;
            boolean deleteBefore = (i >> 1) % 2 == 0;
            boolean keepHistory = (i >> 2) % 2 == 0;
            boolean oldDerived1 = false;
            if (deleteBefore) {
                derived.delete(false, null);
            } else {
                oldDerived1 = derived.isDerived();
            }
            Assert.assertEquals((Object)(!deleteBefore ? 1 : 0), (Object)derived.exists());
            FussyProgressMonitor monitor = new FussyProgressMonitor();
            AtomicInteger changeCount = new AtomicInteger();
            ResourcesPlugin.getWorkspace().addResourceChangeListener(event -> {
                int n = changeCount.incrementAndGet();
            });
            derived.write(("updateOrCreate" + i).getBytes(), false, setDerived, keepHistory, (IProgressMonitor)monitor);
            Assert.assertEquals((String)"not atomic", (long)1L, (long)changeCount.get());
            monitor.assertUsedUp();
            if (deleteBefore) {
                Assert.assertEquals((Object)setDerived, (Object)derived.isDerived());
            } else {
                Assert.assertEquals((Object)(oldDerived1 || setDerived ? 1 : 0), (Object)derived.isDerived());
            }
            Assert.assertFalse((boolean)derived.isTeamPrivateMember());
            Assert.assertTrue((boolean)derived.exists());
            IFileState[] history1 = derived.getHistory(null);
            changeCount.set(0);
            derived.write(("update" + i).getBytes(), false, false, keepHistory, null);
            boolean oldDerived2 = derived.isDerived();
            Assert.assertEquals((Object)oldDerived2, (Object)derived.isDerived());
            Assert.assertEquals((String)"not atomic", (long)1L, (long)changeCount.get());
            IFileState[] history2 = derived.getHistory(null);
            Assert.assertEquals((long)(keepHistory && !oldDerived2 ? 1 : 0), (long)(history2.length - history1.length));
            ++i;
        }
    }

    public void _testWritePerformanceBatch_() throws CoreException {
        ResourceTestUtil.createInWorkspace((IResource)this.projects[0]);
        HashMap fileMap2 = new HashMap();
        HashMap<IFile, byte[]> fileMap1 = new HashMap<IFile, byte[]>();
        int i = 0;
        while (i < 1000) {
            IFile file = this.projects[0].getFile("My" + i + ".class");
            ResourceTestUtil.removeFromWorkspace((IResource)file);
            (i % 2 == 0 ? fileMap1 : fileMap2).put(file, ("smallFileContent" + i).getBytes());
            ++i;
        }
        long n0 = System.nanoTime();
        ExecutorService executorService = Executors.newWorkStealingPool();
        ResourcesPlugin.getWorkspace().write(fileMap1, false, true, false, null, executorService);
        executorService.shutdownNow();
        long n1 = System.nanoTime();
        System.out.println("parallel write took:" + (n1 - n0) / 1000000L + "ms");
        n0 = System.nanoTime();
        for (Map.Entry e : fileMap2.entrySet()) {
            ((IFile)e.getKey()).write((byte[])e.getValue(), false, true, false, null);
        }
        long n12 = System.nanoTime();
        System.out.println("sequential write took:" + (n12 - n0) / 1000000L + "ms");
    }

    @Test
    public void testWrites() throws CoreException {
        ExecutorService executorService = Executors.newWorkStealingPool();
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        description.setMaxFileStates(4);
        ResourcesPlugin.getWorkspace().setDescription(description);
        IFile derived = this.projects[0].getFile("derived.txt");
        IFile anyOther = this.projects[0].getFile("anyOther.txt");
        ResourceTestUtil.createInWorkspace((IResource)this.projects[0]);
        ResourceTestUtil.removeFromWorkspace((IResource)derived);
        ResourceTestUtil.removeFromWorkspace((IResource)anyOther);
        int i = 0;
        while (i < 16) {
            boolean setDerived = i % 2 == 0;
            boolean deleteBefore = (i >> 1) % 2 == 0;
            boolean keepHistory = (i >> 2) % 2 == 0;
            boolean oldDerived1 = false;
            if (deleteBefore) {
                derived.delete(false, null);
                anyOther.delete(false, null);
            } else {
                oldDerived1 = derived.isDerived();
            }
            Assert.assertEquals((Object)(!deleteBefore ? 1 : 0), (Object)derived.exists());
            FussyProgressMonitor monitor = new FussyProgressMonitor();
            AtomicInteger changeCount = new AtomicInteger();
            ResourcesPlugin.getWorkspace().addResourceChangeListener(event -> {
                int n = changeCount.incrementAndGet();
            });
            String derivedContent = "updateOrCreate" + i;
            String otherContent = "other" + i;
            ResourcesPlugin.getWorkspace().write(Map.of(derived, derivedContent.getBytes(), anyOther, otherContent.getBytes()), false, setDerived, keepHistory, (IProgressMonitor)monitor, executorService);
            Assert.assertEquals((Object)derivedContent, (Object)new String(derived.readAllBytes()));
            Assert.assertEquals((Object)otherContent, (Object)new String(anyOther.readAllBytes()));
            monitor.assertUsedUp();
            if (deleteBefore) {
                Assert.assertEquals((Object)setDerived, (Object)derived.isDerived());
            } else {
                Assert.assertEquals((Object)(oldDerived1 || setDerived ? 1 : 0), (Object)derived.isDerived());
            }
            Assert.assertFalse((boolean)derived.isTeamPrivateMember());
            Assert.assertTrue((boolean)derived.exists());
            IFileState[] history1 = derived.getHistory(null);
            changeCount.set(0);
            derivedContent = "update" + i;
            otherContent = "dude" + i;
            ResourcesPlugin.getWorkspace().write(Map.of(derived, derivedContent.getBytes(), anyOther, otherContent.getBytes()), false, false, keepHistory, null, executorService);
            Assert.assertEquals((Object)derivedContent, (Object)new String(derived.readAllBytes()));
            Assert.assertEquals((Object)otherContent, (Object)new String(anyOther.readAllBytes()));
            boolean oldDerived2 = derived.isDerived();
            Assert.assertEquals((Object)oldDerived2, (Object)derived.isDerived());
            IFileState[] history2 = derived.getHistory(null);
            Assert.assertEquals((long)(keepHistory && !oldDerived2 ? 1 : 0), (long)(history2.length - history1.length));
            ++i;
        }
        executorService.shutdown();
    }

    @Test
    public void testWriteRule() throws CoreException {
        IFile resource = this.projects[0].getFile("derived.txt");
        ResourceTestUtil.createInWorkspace((IResource)this.projects[0]);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        resource.delete(false, null);
        AtomicInteger changeCount = new AtomicInteger();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(event -> {
            int n = changeCount.incrementAndGet();
        });
        workspace.run(pm -> resource.write("create".getBytes(), false, false, false, null), workspace.getRuleFactory().createRule((IResource)resource), 1, null);
        Assert.assertTrue((boolean)resource.exists());
        Assert.assertEquals((String)"not atomic", (long)1L, (long)changeCount.get());
        changeCount.set(0);
        workspace.run(pm -> resource.write("replace".getBytes(), false, false, false, null), workspace.getRuleFactory().modifyRule((IResource)resource), 1, null);
        Assert.assertTrue((boolean)resource.exists());
        Assert.assertEquals((String)"not atomic", (long)1L, (long)changeCount.get());
    }

    @Test
    public void testDeltaOnCreateDerived() throws CoreException {
        IFile derived = this.projects[0].getFile("derived.txt");
        ResourceTestUtil.createInWorkspace((IResource)this.projects[0]);
        ResourceDeltaVerifier verifier = new ResourceDeltaVerifier();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)verifier, 1);
        verifier.addExpectedChange((IResource)derived, 1, 0);
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        derived.create(ResourceTestUtil.createRandomContentsStream(), 1025, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"2.0", (boolean)verifier.isDeltaValid());
    }

    @Test
    public void testCreateDerivedTeamPrivate() throws CoreException {
        IFile teamPrivate = this.projects[0].getFile("teamPrivateDerived.txt");
        ResourceTestUtil.createInWorkspace((IResource)this.projects[0]);
        ResourceTestUtil.removeFromWorkspace((IResource)teamPrivate);
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        teamPrivate.create(ResourceTestUtil.createRandomContentsStream(), 3072, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"1.0", (boolean)teamPrivate.isTeamPrivateMember());
        Assert.assertTrue((String)"1.1", (boolean)teamPrivate.isDerived());
        monitor.prepare();
        teamPrivate.delete(false, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        monitor.prepare();
        teamPrivate.create(ResourceTestUtil.createRandomContentsStream(), 0, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"2.0", (!teamPrivate.isTeamPrivateMember() ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.1", (!teamPrivate.isDerived() ? 1 : 0) != 0);
    }

    @Test
    public void testCreateTeamPrivate() throws CoreException {
        IFile teamPrivate = this.projects[0].getFile("teamPrivate.txt");
        ResourceTestUtil.createInWorkspace((IResource)this.projects[0]);
        ResourceTestUtil.removeFromWorkspace((IResource)teamPrivate);
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        teamPrivate.create(ResourceTestUtil.createRandomContentsStream(), 2048, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"1.0", (boolean)teamPrivate.isTeamPrivateMember());
        Assert.assertTrue((String)"1.1", (!teamPrivate.isDerived() ? 1 : 0) != 0);
        monitor.prepare();
        teamPrivate.delete(false, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        monitor.prepare();
        teamPrivate.create(ResourceTestUtil.createRandomContentsStream(), 0, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"2.0", (!teamPrivate.isTeamPrivateMember() ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.1", (!teamPrivate.isDerived() ? 1 : 0) != 0);
    }

    @Test
    public void testFileCreation() throws Exception {
        InputStream stream22;
        IFile fileWithoutInput = this.projects[0].getFile("file1");
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        Assert.assertTrue((String)"1.0", (!fileWithoutInput.exists() ? 1 : 0) != 0);
        monitor.prepare();
        fileWithoutInput.create(null, true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"1.2", (boolean)fileWithoutInput.exists());
        IFile emptyFile = this.projects[0].getFile("file2");
        Assert.assertTrue((String)"2.0", (!emptyFile.exists() ? 1 : 0) != 0);
        String contents = "";
        monitor.prepare();
        emptyFile.create(ResourceTestUtil.createInputStream(contents), true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"2.2", (boolean)emptyFile.exists());
        Throwable throwable = null;
        Throwable throwable2 = null;
        try {
            stream22 = emptyFile.getContents(false);
            try {
                Assert.assertEquals((long)0L, (long)stream22.available());
                Assertions.assertThat((InputStream)stream22).hasContent(contents);
            }
            finally {
                if (stream22 != null) {
                    stream22.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        IFile fileWithRandomContent = this.projects[0].getFile("file3");
        Assert.assertTrue((String)"3.0", (!fileWithRandomContent.exists() ? 1 : 0) != 0);
        contents = ResourceTestUtil.createRandomString();
        monitor.prepare();
        fileWithRandomContent.create(ResourceTestUtil.createInputStream(contents), true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"3.2", (boolean)fileWithRandomContent.exists());
        throwable2 = null;
        stream22 = null;
        try (InputStream fileInput = fileWithRandomContent.getContents(false);){
            Assertions.assertThat((InputStream)fileInput).hasContent(contents);
        }
        catch (Throwable stream22) {
            if (throwable2 == null) {
                throwable2 = stream22;
            } else if (throwable2 != stream22) {
                throwable2.addSuppressed(stream22);
            }
            throw throwable2;
        }
        IFolder folder = this.projects[0].getFolder("folder1");
        monitor.prepare();
        folder.create(true, true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"4.1", (boolean)folder.exists());
        IFile fileOnFolder = this.projects[0].getFile("folder1");
        monitor.prepare();
        Assert.assertThrows(CoreException.class, () -> fileOnFolder.create(null, true, (IProgressMonitor)monitor));
        monitor.assertUsedUp();
        Assert.assertTrue((String)"4.3", (boolean)folder.exists());
        Assert.assertTrue((String)"4.4", (!fileOnFolder.exists() ? 1 : 0) != 0);
        folder = this.projects[0].getFolder("folder2");
        Assert.assertTrue((String)"5.0", (!folder.exists() ? 1 : 0) != 0);
        IFile fileUnderNonExistentParent = folder.getFile("file4");
        monitor.prepare();
        Assert.assertThrows(CoreException.class, () -> fileUnderNonExistentParent.create(null, true, (IProgressMonitor)monitor));
        monitor.assertUsedUp();
        Assert.assertTrue((String)"5.2", (!folder.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"5.3", (!fileUnderNonExistentParent.exists() ? 1 : 0) != 0);
        IFile fileFromStream = this.projects[0].getFile("file2");
        ResourceTestUtil.removeFromWorkspace((IResource)fileFromStream);
        ResourceTestUtil.removeFromFileSystem((IResource)fileFromStream);
        InputStream content = new InputStream(){

            @Override
            public int read() throws IOException {
                throw new IOException();
            }
        };
        monitor.prepare();
        Assert.assertThrows(CoreException.class, () -> fileFromStream.create(content, false, (IProgressMonitor)monitor));
        monitor.assertUsedUp();
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)fileFromStream);
        ResourceTestUtil.assertDoesNotExistInFileSystem((IResource)fileFromStream);
        folder = this.projects[0].getFolder("folder1");
        monitor.prepare();
        folder.delete(false, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        IFile file = this.projects[0].getFile("file1");
        monitor.prepare();
        file.delete(false, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        file = this.projects[0].getFile("file2");
        monitor.prepare();
        file.delete(false, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        file = this.projects[0].getFile("file3");
        monitor.prepare();
        file.delete(false, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
    }

    @Test
    public void testFileCreation_Bug107188() throws CoreException {
        IFile target = this.projects[0].getFile("file1");
        ResourceTestUtil.removeFromWorkspace((IResource)target);
        ResourceTestUtil.removeFromFileSystem((IResource)target);
        InputStream content = new InputStream(){

            @Override
            public int read() {
                throw new OperationCanceledException();
            }
        };
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        Assert.assertThrows(OperationCanceledException.class, () -> target.create(content, false, (IProgressMonitor)monitor));
        monitor.assertUsedUp();
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)target);
        ResourceTestUtil.assertDoesNotExistInFileSystem((IResource)target);
    }

    @Test
    public void testFileDeletion() throws Throwable {
        IFile target = this.projects[0].getFile("file1");
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        target.create(null, true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"1.0", (boolean)target.exists());
        monitor.prepare();
        target.delete(true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"1.1", (!target.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testFileEmptyDeletion() throws Throwable {
        IFile target = this.projects[0].getFile("file1");
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        target.create(ResourceTestUtil.createInputStream(""), true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"1.0", (boolean)target.exists());
        monitor.prepare();
        target.delete(true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"1.1", (!target.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testFileInFolderCreation() throws CoreException {
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        IFolder folder = this.projects[0].getFolder("folder1");
        folder.create(false, true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        IFile target = folder.getFile("file1");
        monitor.prepare();
        target.create(ResourceTestUtil.createRandomContentsStream(), true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"1.1", (boolean)target.exists());
    }

    @Test
    public void testFileInFolderCreation1() throws Throwable {
        IFolder folder = this.projects[0].getFolder("folder1");
        folder.create(false, true, null);
        IFile target = folder.getFile("file1");
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        target.create(ResourceTestUtil.createRandomContentsStream(), true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"1.0", (boolean)target.exists());
    }

    @Test
    public void testFileInFolderCreation2() throws CoreException {
        IFolder folder = this.projects[0].getFolder("folder1");
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        folder.create(false, true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        IFile target = folder.getFile("file1");
        monitor.prepare();
        target.create(ResourceTestUtil.createRandomContentsStream(), true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"1.1", (boolean)target.exists());
    }

    @Test
    public void testFileMove() throws Throwable {
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        IFile target = this.projects[0].getFile("file1");
        target.create(ResourceTestUtil.createRandomContentsStream(), true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        IFile destination = this.projects[0].getFile("file2");
        monitor.prepare();
        target.move(destination.getFullPath(), true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"1.0", (boolean)destination.exists());
        Assert.assertTrue((String)"1.1", (!target.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testFileOverFolder() throws Throwable {
        IFolder existing = this.projects[0].getFolder("ExistingFolder");
        IFile target = this.projects[0].getFile("ExistingFolder");
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        Assert.assertThrows(CoreException.class, () -> target.create(null, true, (IProgressMonitor)monitor));
        monitor.assertUsedUp();
        Assert.assertTrue((String)"1.1", (boolean)existing.exists());
    }

    @Test
    public void testGetContents() throws Exception {
        Object[][] inputs = new Object[][]{this.interestingFiles()};
        new TestPerformer("IFileTest.testGetContents"){

            @Override
            public void cleanUp(Object[] args, int count) throws Exception {
                IFile file = (IFile)args[0];
                IFileTest.this.refreshFile(file);
            }

            @Override
            public Object[] interestingOldState(Object[] args) throws Exception {
                return null;
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IFile file = (IFile)args[0];
                return file.getContents(false);
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                IFile file = (IFile)args[0];
                if (!file.exists()) {
                    return true;
                }
                return IFileTest.this.outOfSync(file);
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                boolean returnVal;
                IFile file = (IFile)args[0];
                Throwable throwable = null;
                Object var7_7 = null;
                try (InputStream contents = (InputStream)result;){
                    returnVal = file.exists() && contents != null;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                return returnVal;
            }
        }.performTest(inputs);
    }

    @Test
    public void testGetContents2() throws IOException, CoreException {
        IFile target = this.projects[0].getFile("file1");
        String testString = ResourceTestUtil.createRandomString();
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        target.create(null, false, null);
        target.setContents(ResourceTestUtil.createInputStream(testString), true, false, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        ResourceTestUtil.ensureOutOfSync(target);
        CoreException firstException = (CoreException)Assert.assertThrows(CoreException.class, () -> {
            Throwable throwable = null;
            Object var2_2 = null;
            try {
                InputStream content = target.getContents(false);
                if (content != null) {
                    content.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
        Assert.assertEquals((long)274L, (long)firstException.getStatus().getCode());
        Throwable throwable = null;
        Object var6_6 = null;
        try {
            InputStream content = target.getContents(true);
            if (content != null) {
                content.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        CoreException secondException = (CoreException)Assert.assertThrows(CoreException.class, () -> {
            Throwable throwable = null;
            Object var2_2 = null;
            try {
                InputStream content = target.getContents(false);
                if (content != null) {
                    content.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
        Assert.assertEquals((long)274L, (long)secondException.getStatus().getCode());
        InputStream content = new InputStream(){

            @Override
            public int read() throws IOException {
                throw new IOException();
            }
        };
        Throwable throwable3 = null;
        Object var8_10 = null;
        try {
            try {
                monitor.prepare();
                Assert.assertThrows(CoreException.class, () -> target.setContents(content, 0, (IProgressMonitor)monitor));
                monitor.sanityCheck();
            }
            finally {
                if (content != null) {
                    content.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable3 == null) {
                throwable3 = throwable4;
            } else if (throwable3 != throwable4) {
                throwable3.addSuppressed(throwable4);
            }
            throw throwable3;
        }
        ResourceTestUtil.assertExistsInWorkspace((IResource)target);
        ResourceTestUtil.assertExistsInFileSystem((IResource)target);
    }

    @Test
    public void testInvalidFileNames() throws CoreException {
        IFile file;
        String name;
        String[] names;
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        IProject project = this.projects[0];
        String[] stringArray = names = new String[]{"", "/"};
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            name = stringArray[n2];
            Assert.assertThrows(RuntimeException.class, () -> {
                IFile iFile = project.getFile(name);
            });
            ++n2;
        }
        names = new String[]{};
        names = Platform.OS.isWindows() ? new String[]{"a  ", "foo::bar", "prn", "nul", "con", "aux", "clock$", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "AUX", "con.foo", "LPT4.txt", "*", "?", "\"", "<", ">", "|"} : new String[]{};
        stringArray = names;
        n = names.length;
        n2 = 0;
        while (n2 < n) {
            name = stringArray[n2];
            monitor.prepare();
            file = project.getFile(IPath.fromPortableString((String)name));
            Assert.assertTrue((String)("1.0 " + name), (!file.exists() ? 1 : 0) != 0);
            Assert.assertThrows(CoreException.class, () -> file.create(ResourceTestUtil.createRandomContentsStream(), true, (IProgressMonitor)monitor));
            monitor.sanityCheck();
            Assert.assertTrue((String)("1.2 " + name), (!file.exists() ? 1 : 0) != 0);
            ++n2;
        }
        names = Platform.OS.isWindows() ? new String[]{"  a", "hello.prn.txt", "null", "con3", "foo.aux", "lpt0", "com0", "com10", "lpt10", ",", "'", ";", "clock$.class"} : new String[]{"  a", "a  ", "foo:bar", "prn", "nul", "con", "aux", "clock$", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "con.foo", "LPT4.txt", "*", "?", "\"", "<", ">", "|", "hello.prn.txt", "null", "con3", "foo.aux", "lpt0", "com0", "com10", "lpt10", ",", "'", ";"};
        stringArray = names;
        n = names.length;
        n2 = 0;
        while (n2 < n) {
            name = stringArray[n2];
            file = project.getFile(name);
            Assert.assertTrue((String)("2.0 " + name), (!file.exists() ? 1 : 0) != 0);
            monitor.prepare();
            file.create(ResourceTestUtil.createRandomContentsStream(), true, (IProgressMonitor)monitor);
            monitor.assertUsedUp();
            Assert.assertTrue((String)("2.2 " + name), (boolean)file.exists());
            ++n2;
        }
    }

    @Test
    public void testSetContents1() throws Exception {
        Object[][] inputs = new Object[][]{this.interestingFiles(), this.interestingStreams(), TRUE_AND_FALSE, PROGRESS_MONITORS};
        new TestPerformer("IFileTest.testSetContents1"){

            @Override
            public void cleanUp(Object[] args, int count) throws Exception {
                IFile file = (IFile)args[0];
                IFileTest.this.refreshFile(file);
            }

            @Override
            public Object[] interestingOldState(Object[] args) throws Exception {
                return null;
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IFile file = (IFile)args[0];
                InputStream stream = (InputStream)args[1];
                boolean force = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (monitor instanceof FussyProgressMonitor) {
                    FussyProgressMonitor fussy = (FussyProgressMonitor)monitor;
                    fussy.prepare();
                }
                file.setContents(stream, force, false, monitor);
                if (monitor instanceof FussyProgressMonitor) {
                    FussyProgressMonitor fussy = (FussyProgressMonitor)monitor;
                    fussy.sanityCheck();
                }
                return null;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                IFile file = (IFile)args[0];
                boolean force = (Boolean)args[2];
                if (!file.exists()) {
                    return true;
                }
                return !force && IFileTest.this.outOfSync(file);
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                IFile file = (IFile)args[0];
                return file.exists();
            }
        }.performTest(inputs);
    }

    @Test
    public void testSetContents2() throws IOException, CoreException {
        IFile target = this.projects[0].getFile("file1");
        target.create(null, false, null);
        String testString = ResourceTestUtil.createRandomString();
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        target.setContents(ResourceTestUtil.createInputStream(testString), true, false, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream content = target.getContents(false);){
            Assertions.assertThat((InputStream)content).hasContent(testString);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testCreateByteArray() throws IOException, CoreException {
        IFile target = this.projects[0].getFile("file1");
        String testString = ResourceTestUtil.createRandomString();
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        target.create(testString.getBytes(), true, false, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertEquals((Object)testString, (Object)target.readString());
    }

    @Test
    public void testReadNBytes() throws IOException, CoreException {
        IFile file = this.projects[0].getFile("smallfile");
        byte[] bytes = "1234".getBytes(StandardCharsets.US_ASCII);
        file.write(bytes, false, false, false, null);
        try {
            file.readNBytes(-1);
            Assert.assertFalse((boolean)true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        byte[] nBytes0 = file.readNBytes(0);
        Assert.assertEquals((long)0L, (long)nBytes0.length);
        byte[] nBytes1 = file.readNBytes(1);
        Assert.assertEquals((long)1L, (long)nBytes1.length);
        Assert.assertEquals((long)49L, (long)nBytes1[0]);
        byte[] nBytes4 = file.readNBytes(4);
        Assert.assertEquals((long)4L, (long)nBytes4.length);
        byte[] nBytes5 = file.readNBytes(5);
        Assert.assertEquals((long)4L, (long)nBytes5.length);
        byte[] nBytesMax = file.readNBytes(Integer.MAX_VALUE);
        Assert.assertEquals((long)4L, (long)nBytesMax.length);
        Assert.assertArrayEquals((byte[])bytes, (byte[])nBytesMax);
        IFile largefile = this.projects[0].getFile("largefile");
        byte[] largeContent = new byte[50000000];
        largefile.write(largeContent, false, false, false, null);
        byte[] largeBytes = largefile.readNBytes(Integer.MAX_VALUE);
        Assert.assertEquals((long)largeContent.length, (long)largeBytes.length);
        byte[] largeBytes1 = largefile.readNBytes(1);
        Assert.assertEquals((long)1L, (long)largeBytes1.length);
    }

    @Test
    public void testReadAll() throws IOException, CoreException {
        List<Charset> charsets = List.of(StandardCharsets.ISO_8859_1, StandardCharsets.UTF_8, StandardCharsets.UTF_16BE, StandardCharsets.UTF_16LE);
        List<String> fileTypes = List.of(".txt", "");
        String BOM = "\ufeff";
        Charset defaultCharset = Charset.forName(this.projects[0].getDefaultCharset());
        for (String fileType : fileTypes) {
            for (Charset charset : charsets) {
                int bomCount = 0;
                while (bomCount <= (charset.name().contains("UTF") ? 1 : 0)) {
                    boolean setCharset;
                    IFile target = this.projects[0].getFile("file1" + charset.name() + "_" + bomCount + fileType);
                    target.create(null, false, null);
                    String testString = "hallo";
                    boolean bl = setCharset = bomCount == 0;
                    if (setCharset) {
                        target.setCharset(charset.name(), null);
                    }
                    FussyProgressMonitor monitor = new FussyProgressMonitor();
                    byte[] content = ((bomCount == 1 ? BOM : "") + testString).getBytes(charset);
                    target.setContents(content, true, false, (IProgressMonitor)monitor);
                    monitor.assertUsedUp();
                    byte[] allBytes = target.readAllBytes();
                    Assert.assertArrayEquals((String)target.getName(), (byte[])content, (byte[])allBytes);
                    char[] allChars = target.readAllChars();
                    String readString = target.readString();
                    String expected = !setCharset && fileType.isEmpty() && charset != defaultCharset ? new String(content, defaultCharset) : testString;
                    Assert.assertArrayEquals((String)target.getName(), (char[])expected.toCharArray(), (char[])allChars);
                    Assert.assertEquals((String)target.getName(), (Object)expected, (Object)readString);
                    ++bomCount;
                }
            }
        }
    }

    @Test
    public void testSetGetFolderPersistentProperty() throws Throwable {
        IFile target = ResourcesPlugin.getWorkspace().getRoot().getFile(IPath.fromOSString((String)"/Project/File.txt"));
        String value = "this is a test property value";
        QualifiedName name = new QualifiedName("itp-test", "testProperty");
        ResourceTestUtil.removeFromWorkspace((IResource)target);
        Assert.assertThrows(CoreException.class, () -> IFileTest.lambda$18((IResource)target, name));
        Assert.assertThrows(CoreException.class, () -> IFileTest.lambda$19((IResource)target, name, value));
        ResourceTestUtil.createInWorkspace((IResource)target);
        target.setPersistentProperty(name, value);
        Assert.assertTrue((String)"2.0", (boolean)target.getPersistentProperty(name).equals(value));
        QualifiedName nonExistentPropertyName = new QualifiedName("itp-test", "testNonProperty");
        Assert.assertNull((String)"2.1", (Object)target.getPersistentProperty(nonExistentPropertyName));
        QualifiedName nullQualifierName = new QualifiedName(null, "foo");
        Assert.assertThrows(CoreException.class, () -> IFileTest.lambda$20((IResource)target, nullQualifierName, value));
    }

    private static /* synthetic */ void lambda$18(IResource iResource, QualifiedName qualifiedName) throws Throwable {
        String string = iResource.getPersistentProperty(qualifiedName);
    }

    private static /* synthetic */ void lambda$19(IResource iResource, QualifiedName qualifiedName, String string) throws Throwable {
        iResource.setPersistentProperty(qualifiedName, string);
    }

    private static /* synthetic */ void lambda$20(IResource iResource, QualifiedName qualifiedName, String string) throws Throwable {
        iResource.setPersistentProperty(qualifiedName, string);
    }
}

