/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.InputStream;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class IFolderTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    @Test
    public void testChangeCase() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFolder before = project.getFolder("folder");
        IFolder after = project.getFolder("Folder");
        IFile beforeFile = before.getFile("file");
        IFile afterFile = after.getFile("file");
        ResourceTestUtil.createInWorkspace((IResource)before);
        beforeFile.create(ResourceTestUtil.createRandomContentsStream(), false, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace((IResource)before);
        ResourceTestUtil.assertExistsInWorkspace((IResource)beforeFile);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)after);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)afterFile);
        before.move(after.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)before);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)beforeFile);
        ResourceTestUtil.assertExistsInWorkspace((IResource)after);
        ResourceTestUtil.assertExistsInWorkspace((IResource)afterFile);
    }

    @Test
    public void testCopyMissingFolder() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFolder before = project.getFolder("OldFolder");
        IFolder after = project.getFolder("NewFolder");
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.createInWorkspace((IResource)before);
        ResourceTestUtil.removeFromFileSystem((IResource)before);
        Assert.assertThrows(CoreException.class, () -> before.copy(after.getFullPath(), 1, ResourceTestUtil.createTestMonitor()));
        Assert.assertTrue((String)"1.1", (!before.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.2", (!after.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testCreateDerived() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFolder derived = project.getFolder("derived");
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.removeFromWorkspace((IResource)derived);
        derived.create(1024, true, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"1.0", (boolean)derived.isDerived());
        Assert.assertTrue((String)"1.1", (!derived.isTeamPrivateMember() ? 1 : 0) != 0);
        derived.delete(false, ResourceTestUtil.createTestMonitor());
        derived.create(0, true, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.0", (!derived.isDerived() ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.1", (!derived.isTeamPrivateMember() ? 1 : 0) != 0);
    }

    @Test
    public void testDeltaOnCreateDerived() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFolder derived = project.getFolder("derived");
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceDeltaVerifier verifier = new ResourceDeltaVerifier();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)verifier, 1);
        verifier.addExpectedChange((IResource)derived, 1, 0);
        derived.create(1025, true, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.0", (boolean)verifier.isDeltaValid());
    }

    @Test
    public void testCreateDerivedTeamPrivate() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFolder teamPrivate = project.getFolder("teamPrivate");
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.removeFromWorkspace((IResource)teamPrivate);
        teamPrivate.create(3072, true, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"1.0", (boolean)teamPrivate.isTeamPrivateMember());
        Assert.assertTrue((String)"1.1", (boolean)teamPrivate.isDerived());
        teamPrivate.delete(false, ResourceTestUtil.createTestMonitor());
        teamPrivate.create(0, true, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.0", (!teamPrivate.isTeamPrivateMember() ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.1", (!teamPrivate.isDerived() ? 1 : 0) != 0);
    }

    @Test
    public void testCreateTeamPrivate() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFolder teamPrivate = project.getFolder("teamPrivate");
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.removeFromWorkspace((IResource)teamPrivate);
        teamPrivate.create(2048, true, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"1.0", (boolean)teamPrivate.isTeamPrivateMember());
        Assert.assertTrue((String)"1.1", (!teamPrivate.isDerived() ? 1 : 0) != 0);
        teamPrivate.delete(false, ResourceTestUtil.createTestMonitor());
        teamPrivate.create(0, true, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.0", (!teamPrivate.isTeamPrivateMember() ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.1", (!teamPrivate.isDerived() ? 1 : 0) != 0);
    }

    @Test
    public void testFolderCreation() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        IFolder target = project.getFolder("Folder1");
        Assert.assertTrue((String)"1.0", (!target.exists() ? 1 : 0) != 0);
        target.create(true, true, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"1.1", (boolean)target.exists());
        IFolder nestedTarget = target.getFolder("Folder2");
        Assert.assertTrue((String)"2.0", (!nestedTarget.exists() ? 1 : 0) != 0);
        nestedTarget.create(true, true, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.1", (boolean)nestedTarget.exists());
        Assert.assertTrue((String)"3.0", (boolean)target.exists());
        IFolder folderTarget = target;
        Assert.assertThrows(CoreException.class, () -> folderTarget.create(true, true, ResourceTestUtil.createTestMonitor()));
        Assert.assertTrue((String)"3.2", (boolean)target.exists());
        IFile file = target.getFile("File1");
        target = target.getFolder("File1");
        file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"4.0", (boolean)file.exists());
        IFolder subfolderTarget = target;
        Assert.assertThrows(CoreException.class, () -> subfolderTarget.create(true, true, ResourceTestUtil.createTestMonitor()));
        Assert.assertTrue((String)"5.1", (boolean)file.exists());
        Assert.assertTrue((String)"5.2", (!target.exists() ? 1 : 0) != 0);
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            IFolder iFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(IPath.fromOSString((String)"/Folder3"));
        });
        file = project.getFile("File2");
        file.create(null, true, ResourceTestUtil.createTestMonitor());
        target = project.getFolder("File2/Folder4");
        Assert.assertTrue((String)"7.1", (!target.exists() ? 1 : 0) != 0);
        IFolder nonexistentSubfolderTarget = target;
        Assert.assertThrows(CoreException.class, () -> nonexistentSubfolderTarget.create(true, true, ResourceTestUtil.createTestMonitor()));
        Assert.assertTrue((String)"7.3", (boolean)file.exists());
        Assert.assertTrue((String)"7.4", (!target.exists() ? 1 : 0) != 0);
        IFolder folder = project.getFolder("Folder5");
        target = folder.getFolder("Folder6");
        Assert.assertTrue((String)"8.0", (!folder.exists() ? 1 : 0) != 0);
        IFolder nonexistentFolderTarget = target;
        Assert.assertThrows(CoreException.class, () -> nonexistentFolderTarget.create(true, true, ResourceTestUtil.createTestMonitor()));
        Assert.assertTrue((String)"8.2", (!folder.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"8.3", (!target.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testFolderDeletion() throws Throwable {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IResource[] before = ResourceTestUtil.buildResources((IContainer)project, new String[]{"c/", "c/b/", "c/x", "c/b/y", "c/b/z"});
        ResourceTestUtil.createInWorkspace(before);
        ResourceTestUtil.assertExistsInWorkspace(before);
        project.getFolder("c").delete(true, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(before);
    }

    @Test
    public void testFolderMove() throws Throwable {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IResource[] before = ResourceTestUtil.buildResources((IContainer)project, new String[]{"b/", "b/b/", "b/x", "b/b/y", "b/b/z"});
        IResource[] after = ResourceTestUtil.buildResources((IContainer)project, new String[]{"a/", "a/b/", "a/x", "a/b/y", "a/b/z"});
        ResourceTestUtil.createInWorkspace(before);
        String content = ResourceTestUtil.createRandomString();
        IFile file = project.getFile(IPath.fromOSString((String)"b/b/z"));
        file.setContents(ResourceTestUtil.createInputStream(content), true, false, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace(before);
        project.getFolder("b").move(project.getFullPath().append("a"), true, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(before);
        ResourceTestUtil.assertExistsInWorkspace(after);
        file = project.getFile(IPath.fromOSString((String)"a/b/z"));
        Throwable throwable = null;
        Object var7_8 = null;
        try (InputStream fileInput = file.getContents(false);){
            Assertions.assertThat((InputStream)fileInput).hasContent(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testFolderOverFile() throws Throwable {
        IPath path = IPath.fromOSString((String)"/Project/File");
        IFile existing = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        ResourceTestUtil.createInWorkspace((IResource)existing);
        IFolder target = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        Assert.assertThrows((String)"Should not be able to create folder over a file", CoreException.class, () -> target.create(true, true, ResourceTestUtil.createTestMonitor()));
        Assert.assertTrue((String)"2.0", (boolean)existing.exists());
    }

    @Test
    public void testInvalidFolderNames() throws CoreException {
        IFolder folder;
        String name;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        String[] names = new String[]{};
        names = Platform.OS.isWindows() ? new String[]{"prn", "nul", "con", "aux", "clock$", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "AUX", "con.foo", "LPT4.txt", "*", "?", "\"", "<", ">", "|"} : new String[]{};
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            name = stringArray[n2];
            folder = project.getFolder(name);
            Assert.assertTrue((String)("1.0 " + name), (!folder.exists() ? 1 : 0) != 0);
            Assert.assertThrows(CoreException.class, () -> folder.create(true, true, ResourceTestUtil.createTestMonitor()));
            Assert.assertTrue((String)("1.2 " + name), (!folder.exists() ? 1 : 0) != 0);
            ++n2;
        }
        names = Platform.OS.isWindows() ? new String[]{"hello.prn.txt", "null", "con3", "foo.aux", "lpt0", "com0", "com10", "lpt10", ",", "'", ";"} : new String[]{"prn", "nul", "con", "aux", "clock$", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "con.foo", "LPT4.txt", "*", "?", "\"", "<", ">", "|", "hello.prn.txt", "null", "con3", "foo.aux", "lpt0", "com0", "com10", "lpt10", ",", "'", ";"};
        stringArray = names;
        n = names.length;
        n2 = 0;
        while (n2 < n) {
            name = stringArray[n2];
            folder = project.getFolder(name);
            Assert.assertTrue((String)("2.0 " + name), (!folder.exists() ? 1 : 0) != 0);
            folder.create(true, true, ResourceTestUtil.createTestMonitor());
            Assert.assertTrue((String)("2.2 " + name), (boolean)folder.exists());
            ++n2;
        }
    }

    @Test
    public void testLeafFolderMove() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFolder source = project.getFolder("Folder1");
        ResourceTestUtil.createInWorkspace((IResource)source);
        IFolder dest = project.getFolder("Folder2");
        source.move(dest.getFullPath(), true, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace((IResource)dest);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)source);
    }

    @Test
    public void testReadOnlyFolderCopy() throws Exception {
        if (!ResourceTestUtil.isReadOnlySupported()) {
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFolder source = project.getFolder("Folder1");
        ResourceTestUtil.createInWorkspace((IResource)source);
        source.setReadOnly(true);
        IFolder dest = project.getFolder("Folder2");
        source.copy(dest.getFullPath(), true, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace((IResource)dest);
        ResourceTestUtil.assertExistsInWorkspace((IResource)source);
        Assert.assertTrue((String)"1.2", (boolean)dest.isReadOnly());
        source.setReadOnly(false);
        dest.setReadOnly(false);
    }

    @Test
    public void testSetGetFolderPersistentProperty() throws Throwable {
        IFolder target = ResourcesPlugin.getWorkspace().getRoot().getFolder(IPath.fromOSString((String)"/Project/Folder"));
        String value = "this is a test property value";
        QualifiedName name = new QualifiedName("itp-test", "testProperty");
        ResourceTestUtil.removeFromWorkspace((IResource)target);
        Assert.assertThrows(CoreException.class, () -> IFolderTest.lambda$8((IResource)target, name));
        Assert.assertThrows(CoreException.class, () -> IFolderTest.lambda$9((IResource)target, name, value));
        ResourceTestUtil.createInWorkspace((IResource)target);
        target.setPersistentProperty(name, value);
        Assert.assertTrue((String)"2.0", (boolean)target.getPersistentProperty(name).equals(value));
        QualifiedName nonExistentPropertyName = new QualifiedName("itp-test", "testNonProperty");
        Assert.assertNull((String)"2.1", (Object)target.getPersistentProperty(nonExistentPropertyName));
    }

    private static /* synthetic */ void lambda$8(IResource iResource, QualifiedName qualifiedName) throws Throwable {
        String string = iResource.getPersistentProperty(qualifiedName);
    }

    private static /* synthetic */ void lambda$9(IResource iResource, QualifiedName qualifiedName, String string) throws Throwable {
        iResource.setPersistentProperty(qualifiedName, string);
    }
}

