/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IPathVariableChangeEvent;
import org.eclipse.core.resources.IPathVariableChangeListener;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class IPathVariableTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    IPathVariableManager manager = null;
    IProject project = null;

    @Before
    public void setUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        this.project.create(ResourceTestUtil.createTestMonitor());
        this.project.open(ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"1.4", (boolean)this.project.exists());
        this.manager = this.project.getPathVariableManager();
    }

    @After
    public void tearDown() throws Exception {
        String[] names;
        String[] stringArray = names = this.manager.getPathVariableNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.manager.setValue(name, null);
            ++n2;
        }
    }

    @Test
    public void testGetPathVariableNames() throws CoreException {
        String[] names = null;
        this.manager.setValue("one", FileSystemHelper.getRandomLocation());
        names = this.manager.getPathVariableNames();
        List<String> list = Arrays.asList(names);
        Assert.assertTrue((String)"1.2", (boolean)list.contains("one"));
        this.manager.setValue("two", IPath.ROOT);
        names = this.manager.getPathVariableNames();
        list = Arrays.asList(names);
        Assert.assertTrue((String)"2.2", (boolean)list.contains("one"));
        Assert.assertTrue((String)"2.3", (boolean)list.contains("two"));
        this.manager.setValue("one", null);
        names = this.manager.getPathVariableNames();
        list = Arrays.asList(names);
        Assert.assertTrue((String)"3.2", (boolean)list.contains("two"));
        Assert.assertTrue((String)"3.3", (!list.contains("one") ? 1 : 0) != 0);
        this.manager.setValue("two", null);
        names = this.manager.getPathVariableNames();
        list = Arrays.asList(names);
        Assert.assertTrue((String)"4.2", (!list.contains("two") ? 1 : 0) != 0);
        Assert.assertTrue((String)"4.3", (!list.contains("one") ? 1 : 0) != 0);
    }

    @Test
    public void testGetSetValue() throws CoreException {
        boolean WINDOWS = File.separatorChar == '\\';
        IPath pathOne = WINDOWS ? IPath.fromOSString((String)"C:\\testGetSetValue") : IPath.fromOSString((String)"/testGetSetValue");
        IPath pathTwo = IPath.fromOSString((String)"/blort/backup");
        pathTwo = IPath.fromOSString((String)pathTwo.toFile().getAbsolutePath());
        IPath pathOneEdit = WINDOWS ? IPath.fromOSString((String)"D:/foobar") : IPath.fromOSString((String)"/foobar");
        Assert.assertNull((String)"0.0", (Object)this.manager.getValue("one"));
        this.manager.setValue("one", pathOne);
        IPath value = this.manager.getValue("one");
        Assert.assertNotNull((String)"1.1", (Object)value);
        Assert.assertEquals((String)"1.2", (Object)pathOne, (Object)value);
        this.manager.setValue("two", pathTwo);
        value = this.manager.getValue("two");
        Assert.assertNotNull((String)"2.1", (Object)value);
        Assert.assertEquals((String)"2.2", (Object)pathTwo, (Object)value);
        this.manager.setValue("one", pathOneEdit);
        value = this.manager.getValue("one");
        Assert.assertNotNull((String)"3.1", (Object)value);
        Assert.assertTrue((String)"3.2", (boolean)pathOneEdit.equals((Object)value));
        this.manager.setValue("one", null);
        Assert.assertNull((String)"4.1", (Object)this.manager.getValue("one"));
        Assert.assertThrows((String)"Accepted invalid variable name in setValue()", CoreException.class, () -> this.manager.setValue("ECLIPSE$HOME", IPath.ROOT));
        this.manager.setValue("one", IPath.fromOSString((String)"foo/bar"));
        if (WINDOWS) {
            String invalidPathString = "C:/a/\\::/b";
            IPath invalidPath = IPath.fromPortableString((String)invalidPathString);
            Assert.assertTrue((String)"6.0", (boolean)invalidPath.isAbsolute());
            Assert.assertTrue((String)"6.1", (!IPath.EMPTY.isValidPath(invalidPathString) ? 1 : 0) != 0);
            Assert.assertTrue((String)"6.2", (boolean)this.manager.validateValue(invalidPath).isOK());
            this.manager.setValue("one", invalidPath);
        }
    }

    @Test
    public void testIsDefined() throws CoreException {
        Assert.assertTrue((String)"0.0", (!this.manager.isDefined("one") ? 1 : 0) != 0);
        this.manager.setValue("one", IPath.ROOT);
        Assert.assertTrue((String)"1.1", (boolean)this.manager.isDefined("one"));
        this.manager.setValue("one", null);
        Assert.assertTrue((String)"2.1", (!this.manager.isDefined("one") ? 1 : 0) != 0);
    }

    @Test
    public void testResolvePathWithMacro() throws CoreException {
        boolean WINDOWS = File.separatorChar == '\\';
        IPath pathOne = WINDOWS ? IPath.fromOSString((String)"c:/testGetSetValue/foo") : IPath.fromOSString((String)"/testGetSetValue/foo");
        IPath pathTwo = WINDOWS ? IPath.fromOSString((String)"c:/tmp/backup") : IPath.fromOSString((String)"/tmp/backup");
        pathTwo = IPath.fromOSString((String)pathTwo.toFile().getAbsolutePath());
        this.manager.setValue("one", pathOne);
        this.manager.setValue("two", pathTwo);
        this.manager.setValue("three", IPath.fromOSString((String)"${two}/extra"));
        IPath path = IPath.fromOSString((String)"three/bar");
        IPath expected = IPath.fromOSString((String)"/tmp/backup/extra/bar").setDevice(WINDOWS ? "c:" : null);
        IPath actual = this.manager.resolvePath(path);
        Assert.assertEquals((String)"1.0", (Object)expected, (Object)actual);
    }

    @Test
    public void testProjectLoc() {
        IPath path = IPath.fromOSString((String)"${PROJECT_LOC}/bar");
        IPath projectLocation = this.project.getLocation();
        IPath expected = projectLocation.append("bar");
        IPath actual = this.manager.resolvePath(path);
        Assert.assertEquals((String)"1.0", (Object)expected, (Object)actual);
    }

    @Test
    public void testEclipseHome() {
        IPath path = IPath.fromOSString((String)"${ECLIPSE_HOME}/bar");
        IPath expected = IPath.fromOSString((String)Platform.getInstallLocation().getURL().getPath()).append("bar");
        IPath actual = this.manager.resolvePath(path);
        Assert.assertEquals((String)"1.0", (Object)expected, (Object)actual);
    }

    @Test
    public void testWorkspaceLocation() {
        IPath path = IPath.fromOSString((String)"${WORKSPACE_LOC}/bar");
        IPath expected = this.project.getWorkspace().getRoot().getLocation().append("bar");
        IPath actual = this.manager.resolvePath(path);
        Assert.assertEquals((String)"1.0", (Object)expected, (Object)actual);
    }

    @Test
    public void testGetVariableRelativePathLocation() {
        IPath path = this.project.getWorkspace().getRoot().getLocation().append("bar");
        path = IPath.fromOSString((String)Platform.getInstallLocation().getURL().getPath()).append("bar");
        IPath expected = IPath.fromOSString((String)"ECLIPSE_HOME/bar");
        IPath actual = IPathVariableTest.getVariableRelativePathLocation(this.project, path);
        Assert.assertEquals((String)"2.0", (Object)expected, (Object)actual);
        path = this.project.getLocation().append("bar");
        expected = IPath.fromOSString((String)"PROJECT_LOC/bar");
        actual = IPathVariableTest.getVariableRelativePathLocation(this.project, path);
        Assert.assertEquals((String)"3.0", (Object)expected, (Object)actual);
        actual = IPathVariableTest.getVariableRelativePathLocation(this.project, IPath.fromOSString((String)"/nonExistentPath/foo"));
        Assert.assertEquals((String)"4.0", null, (Object)actual);
    }

    private static IPath getVariableRelativePathLocation(IProject project, IPath location) {
        URI variableRelativePathLocation = project.getPathVariableManager().getVariableRelativePathLocation(URIUtil.toURI((IPath)location));
        if (variableRelativePathLocation != null) {
            return URIUtil.toPath((URI)variableRelativePathLocation);
        }
        return null;
    }

    @Test
    public void testResolvePath() throws CoreException {
        boolean WINDOWS = File.separatorChar == '\\';
        IPath pathOne = WINDOWS ? IPath.fromOSString((String)"C:/testGetSetValue/foo") : IPath.fromOSString((String)"/testGetSetValue/foo");
        IPath pathTwo = IPath.fromOSString((String)"/blort/backup");
        pathTwo = IPath.fromOSString((String)pathTwo.toFile().getAbsolutePath());
        this.manager.setValue("one", pathOne);
        this.manager.setValue("two", pathTwo);
        IPath path = IPath.fromOSString((String)"one/bar");
        IPath expected = IPath.fromOSString((String)"/testGetSetValue/foo/bar").setDevice(WINDOWS ? "C:" : null);
        IPath actual = this.manager.resolvePath(path);
        Assert.assertEquals((String)"1.0", (Object)expected, (Object)actual);
        path = IPath.fromOSString((String)"two/myworld");
        expected = IPath.fromOSString((String)"/blort/backup/myworld");
        expected = IPath.fromOSString((String)expected.toFile().getAbsolutePath());
        actual = this.manager.resolvePath(path);
        Assert.assertEquals((String)"2.0", (Object)expected, (Object)actual);
        expected = path = IPath.fromOSString((String)"three/nothere");
        actual = this.manager.resolvePath(path);
        Assert.assertEquals((String)"3.0", (Object)expected, (Object)actual);
        expected = path = IPath.fromOSString((String)"/one").setDevice(WINDOWS ? "C:" : null);
        actual = this.manager.resolvePath(path);
        Assert.assertEquals((String)"4.0", (Object)expected, (Object)actual);
        if (WINDOWS) {
            expected = path = IPath.fromOSString((String)"C:two");
            actual = this.manager.resolvePath(path);
            Assert.assertEquals((String)"5.0", (Object)expected, (Object)actual);
        }
        expected = path = IPath.fromOSString((String)"/one");
        actual = this.manager.resolvePath(path);
        Assert.assertEquals((String)"6.0", (Object)expected, (Object)actual);
        if (WINDOWS) {
            path = IPath.fromOSString((String)"one");
            expected = FileUtil.canonicalPath((IPath)pathOne);
            actual = this.manager.resolvePath(path);
            Assert.assertEquals((String)"7.0", (Object)expected, (Object)actual);
        }
        path = null;
        Assert.assertNull((String)"7.0", (Object)this.manager.resolvePath(path));
    }

    private static IPath convertToRelative(IPathVariableManager manager, IPath path, boolean force, String variableHint) throws CoreException {
        return URIUtil.toPath((URI)manager.convertToRelative(URIUtil.toURI((IPath)path), force, variableHint));
    }

    @Test
    public void testConvertToRelative() throws CoreException {
        boolean WINDOWS = File.separatorChar == '\\';
        IPath pathOne = WINDOWS ? IPath.fromOSString((String)"c:/foo/bar") : IPath.fromOSString((String)"/foo/bar");
        IPath pathTwo = WINDOWS ? IPath.fromOSString((String)"c:/foo/other") : IPath.fromOSString((String)"/foo/other");
        IPath pathThree = WINDOWS ? IPath.fromOSString((String)"c:/random/other/subpath") : IPath.fromOSString((String)"/random/other/subpath");
        IPath file = WINDOWS ? IPath.fromOSString((String)"c:/foo/other/file.txt") : IPath.fromOSString((String)"/foo/other/file.txt");
        this.manager.setValue("ONE", pathOne);
        this.manager.setValue("THREE", pathThree);
        IPath actual = IPathVariableTest.convertToRelative(this.manager, file, false, "ONE");
        IPath expected = file;
        Assert.assertEquals((String)"1.0", (Object)expected, (Object)actual);
        this.manager.setValue("TWO", pathTwo);
        actual = IPathVariableTest.convertToRelative(this.manager, file, false, "ONE");
        expected = file;
        Assert.assertEquals((String)"2.0", (Object)expected, (Object)actual);
        actual = IPathVariableTest.convertToRelative(this.manager, file, false, "TWO");
        expected = IPath.fromOSString((String)"TWO/file.txt");
        Assert.assertEquals((String)"3.0", (Object)expected, (Object)actual);
        actual = IPathVariableTest.convertToRelative(this.manager, file, true, "ONE");
        expected = IPath.fromOSString((String)"PARENT-1-ONE/other/file.txt");
        Assert.assertEquals((String)"4.0", (Object)expected, (Object)actual);
        actual = IPathVariableTest.convertToRelative(this.manager, file, true, "ONE");
        expected = IPath.fromOSString((String)"PARENT-1-ONE/other/file.txt");
        Assert.assertEquals((String)"5.0", (Object)expected, (Object)actual);
        actual = IPathVariableTest.convertToRelative(this.manager, file, true, "TWO");
        expected = IPath.fromOSString((String)"TWO/file.txt");
        Assert.assertEquals((String)"6.0", (Object)expected, (Object)actual);
        actual = IPathVariableTest.convertToRelative(this.manager, file, true, "TWO");
        expected = IPath.fromOSString((String)"TWO/file.txt");
        Assert.assertEquals((String)"7.0", (Object)expected, (Object)actual);
        actual = IPathVariableTest.convertToRelative(this.manager, file, false, null);
        expected = IPath.fromOSString((String)"TWO/file.txt");
        Assert.assertEquals((String)"8.0", (Object)expected, (Object)actual);
        this.manager.setValue("TWO", null);
        actual = IPathVariableTest.convertToRelative(this.manager, file, false, null);
        expected = file;
        Assert.assertEquals((String)"9.0", (Object)expected, (Object)actual);
        actual = IPathVariableTest.convertToRelative(this.manager, file, true, null);
        expected = IPath.fromOSString((String)"PARENT-1-ONE/other/file.txt");
        Assert.assertEquals((String)"10.0", (Object)expected, (Object)actual);
    }

    @Test
    public void testValidateName() {
        Assert.assertTrue((String)"0.0", (boolean)this.manager.validateName("ECLIPSEHOME").isOK());
        Assert.assertTrue((String)"0.1", (boolean)this.manager.validateName("ECLIPSE_HOME").isOK());
        Assert.assertTrue((String)"0.2", (boolean)this.manager.validateName("ECLIPSE_HOME_1").isOK());
        Assert.assertTrue((String)"0.3", (boolean)this.manager.validateName("_").isOK());
        Assert.assertTrue((String)"1.0", (!this.manager.validateName("1FOO").isOK() ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.1", (!this.manager.validateName("FOO%BAR").isOK() ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.2", (!this.manager.validateName("FOO$BAR").isOK() ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.3", (!this.manager.validateName(" FOO").isOK() ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.4", (!this.manager.validateName("FOO ").isOK() ? 1 : 0) != 0);
    }

    @Test
    public void testEmptyURIResolution() {
        IPath path = IPath.fromOSString((String)new String());
        URI uri = URIUtil.toURI((IPath)path);
        this.manager.resolveURI(uri);
        ResourcesPlugin.getWorkspace().getPathVariableManager().resolveURI(uri);
    }

    @Test
    public void testListeners() throws Exception {
        PathVariableChangeVerifier listener = new PathVariableChangeVerifier();
        this.manager.addChangeListener((IPathVariableChangeListener)listener);
        IPath pathOne = IPath.fromOSString((String)"/blort/foobar");
        pathOne = IPath.fromOSString((String)pathOne.toFile().getAbsolutePath());
        IPath pathOneEdit = pathOne.append("myworld");
        try {
            this.manager.setValue("one", pathOne);
            listener.addExpectedEvent(2, "one", pathOne);
            listener.verify();
            listener.reset();
            this.manager.setValue("one", pathOneEdit);
            listener.addExpectedEvent(1, "one", pathOneEdit);
            listener.verify();
            listener.reset();
            this.manager.setValue("one", null);
            listener.addExpectedEvent(3, "one", null);
            listener.verify();
        }
        finally {
            this.manager.removeChangeListener((IPathVariableChangeListener)listener);
        }
    }

    boolean contains(Object[] array, Object obj) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element.equals(obj)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Test
    public void testLinkExistInProjectDescriptionButNotInWorkspace() throws Exception {
        String[] varNames;
        String dorProjectContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><projectDescription><name>ExistingProject</name><comment></comment><projects></projects><buildSpec></buildSpec><natures></natures><variableList><variable>\t\t<name>PROJ_UP</name>\t\t<value>$%7BPARENT-1-PROJECT_LOC%7D</value>\t</variable>\t</variableList></projectDescription>";
        IProject existingProject = ResourcesPlugin.getWorkspace().getRoot().getProject("ExistingProject");
        ResourceTestUtil.createInWorkspace(new IResource[]{existingProject});
        existingProject.close(ResourceTestUtil.createTestMonitor());
        ProjectInfo info = (ProjectInfo)((Project)existingProject).getResourceInfo(false, false);
        info.clear(16);
        String dotProjectPath = existingProject.getLocation().append(".project").toOSString();
        FileWriter fstream = new FileWriter(dotProjectPath);
        Throwable throwable = null;
        Object var7_8 = null;
        try (BufferedWriter out = new BufferedWriter(fstream);){
            out.write(dorProjectContent);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        existingProject.open(ResourceTestUtil.createTestMonitor());
        IPathVariableManager pathVariableManager = existingProject.getPathVariableManager();
        String[] stringArray = varNames = pathVariableManager.getPathVariableNames();
        int n = varNames.length;
        int n2 = 0;
        while (n2 < n) {
            String varName = stringArray[n2];
            pathVariableManager.getURIValue(varName);
            ++n2;
        }
    }

    @Test
    public void testDiscoverLocationOfInvalidFile() throws CoreException {
        IPath filep = IPath.fromOSString((String)"someFile");
        IPath invalidChild = filep.append("invalidChild");
        IFile f = this.project.getFile(filep);
        ResourceTestUtil.createInWorkspace((IResource)f);
        IFile invalidFile = this.project.getFile(invalidChild);
        invalidFile.getLocationURI();
    }

    static class PathVariableChangeVerifier
    implements IPathVariableChangeListener {
        List<Event> expected = new ArrayList<Event>();
        List<Event> actual = new ArrayList<Event>();

        PathVariableChangeVerifier() {
        }

        void addExpectedEvent(int type, String name, IPath value) {
            this.expected.add(new Event(type, name, value));
        }

        void verify() throws VerificationFailedException {
            if (this.expected.size() != this.actual.size()) {
                String message = "Expected size: " + this.expected.size() + " does not equal actual size: " + this.actual.size() + "\n";
                message = message + this.dump();
                throw new VerificationFailedException(message);
            }
            for (Event event : this.expected) {
                if (this.actual.contains(event)) continue;
                Object message = "Expected and actual results differ.\n";
                message = (String)message + this.dump();
                throw new VerificationFailedException((String)message);
            }
        }

        void reset() {
            this.expected = new ArrayList<Event>();
            this.actual = new ArrayList<Event>();
        }

        public void pathVariableChanged(IPathVariableChangeEvent event) {
            this.actual.add(new Event(event.getType(), event.getVariableName(), event.getValue()));
        }

        String dump() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Expected:\n");
            for (Event event : this.expected) {
                buffer.append("\t" + String.valueOf(event) + "\n");
            }
            buffer.append("Actual:\n");
            for (Event event : this.actual) {
                buffer.append("\t" + String.valueOf(event) + "\n");
            }
            return buffer.toString();
        }

        static class Event {
            int type;
            String name;
            IPath value;

            Event(int type, String name, IPath value) {
                this.type = type;
                this.name = name;
                this.value = value;
            }

            /*
             * WARNING - void declaration
             */
            public boolean equals(Object obj) {
                void that;
                if (obj == null || !(obj instanceof Event)) {
                    return false;
                }
                Event event = (Event)obj;
                if (this.type != that.type || !this.name.equals(that.name)) {
                    return false;
                }
                return this.value == null ? that.value == null : this.value.equals((Object)that.value);
            }

            public String toString() {
                StringBuilder buffer = new StringBuilder();
                buffer.append("Event(");
                buffer.append("type: ");
                buffer.append(this.stringForType(this.type));
                buffer.append(" name: ");
                buffer.append(this.name);
                buffer.append(" value: ");
                buffer.append(this.value);
                buffer.append(")");
                return buffer.toString();
            }

            String stringForType(int typeValue) {
                switch (typeValue) {
                    case 2: {
                        return "CREATED";
                    }
                    case 1: {
                        return "CHANGED";
                    }
                    case 3: {
                        return "DELETED";
                    }
                }
                return "UNKNOWN";
            }
        }

        static class VerificationFailedException
        extends Exception {
            private static final long serialVersionUID = 1L;

            VerificationFailedException(String message) {
                super(message);
            }
        }
    }
}

