/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class IProjectDescriptionTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    @Test
    public void testDescriptionConstant() {
        Assert.assertEquals((String)"1.0", (Object)".project", (Object)".project");
    }

    @Test
    public void testBuildSpecBuilder() throws Exception {
        Project project = (Project)ResourcesPlugin.getWorkspace().getRoot().getProject("ProjectTBSB");
        ResourceTestUtil.createInWorkspace((IResource)project);
        project.refreshLocal(2, null);
        IFile descriptionFile = project.getFile(".project");
        Assert.assertTrue((String)"1.0", (boolean)descriptionFile.exists());
        IProjectDescription desc = project.getDescription();
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.core.tests.resources.flexbuilder");
        desc.setBuildSpec(new ICommand[]{command});
        project.setDescription(desc, null);
        project.build(6, null);
        Assert.assertTrue((String)"2.0", (((BuildCommand)project.internalGetDescription().getBuildSpec(false)[0]).getBuilders() != null ? 1 : 0) != 0);
        desc = project.getDescription();
        desc.setBuildSpec(new ICommand[]{command});
        project.setDescription(desc, null);
        Assert.assertTrue((String)"3.0", (((BuildCommand)project.internalGetDescription().getBuildSpec(false)[0]).getBuilders() != null ? 1 : 0) != 0);
    }

    @Test
    public void testDirtyDescription() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IProject target1 = ResourcesPlugin.getWorkspace().getRoot().getProject("target1");
        IProject target2 = ResourcesPlugin.getWorkspace().getRoot().getProject("target2");
        ResourceTestUtil.createInWorkspace((IResource)project);
        IFile descriptionFile = project.getFile(".project");
        Assert.assertTrue((String)"1.0", (boolean)descriptionFile.exists());
        long timestamp = descriptionFile.getLocalTimeStamp();
        Thread.sleep(1000L);
        IProjectDescription description = project.getDescription();
        description.setBuildSpec(description.getBuildSpec());
        description.setComment(description.getComment());
        description.setDynamicReferences(description.getDynamicReferences());
        description.setLocationURI(description.getLocationURI());
        description.setName(description.getName());
        description.setNatureIds(description.getNatureIds());
        description.setReferencedProjects(description.getReferencedProjects());
        project.setDescription(description, 0, null);
        Assert.assertEquals((String)"2.0", (long)timestamp, (long)descriptionFile.getLocalTimeStamp());
        description = project.getDescription();
        description.setDynamicReferences(new IProject[]{target1, target2});
        project.setDescription(description, 0, null);
        Assert.assertEquals((String)"2.1", (long)timestamp, (long)descriptionFile.getLocalTimeStamp());
    }

    @Test
    public void testDirtyBuildSpec() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFile projectDescription = project.getFile(".project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        String key = "key";
        String value1 = "value1";
        String value2 = "value2";
        IProjectDescription description = project.getDescription();
        ICommand newCommand = description.newCommand();
        Map<String, String> args = new HashMap<String, String>();
        args.put(key, value1);
        newCommand.setArguments(args);
        description.setBuildSpec(new ICommand[]{newCommand});
        project.setDescription(description, 0, null);
        long modificationStamp = projectDescription.getModificationStamp();
        description = project.getDescription();
        ICommand command = description.getBuildSpec()[0];
        args = command.getArguments();
        args.put(key, value2);
        command.setArguments(args);
        description.setBuildSpec(new ICommand[]{command});
        project.setDescription(description, 0, null);
        Assert.assertTrue((String)"3.0", (modificationStamp != projectDescription.getModificationStamp() ? 1 : 0) != 0);
    }

    @Test
    public void testDynamicProjectReferences() throws CoreException {
        IProject target1 = ResourcesPlugin.getWorkspace().getRoot().getProject("target1");
        IProject target2 = ResourcesPlugin.getWorkspace().getRoot().getProject("target2");
        ResourceTestUtil.createInWorkspace((IResource)target1);
        ResourceTestUtil.createInWorkspace((IResource)target2);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        IProjectDescription description = project.getDescription();
        description.setReferencedProjects(new IProject[]{target1});
        description.setDynamicReferences(new IProject[]{target2});
        project.setDescription(description, ResourceTestUtil.createTestMonitor());
        Object[] refs = project.getReferencedProjects();
        Assertions.assertThat((Object[])refs).containsExactly((Object[])new IProject[]{target1, target2});
        Assertions.assertThat((Object[])target1.getReferencingProjects()).hasSize(1);
        Assertions.assertThat((Object[])target2.getReferencingProjects()).hasSize(1);
        Assert.assertThrows(CoreException.class, () -> {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProject("DoesNotExist").getReferencedProjects();
        });
    }

    @Test
    public void testProjectReferences() throws CoreException {
        IProject target = ResourcesPlugin.getWorkspace().getRoot().getProject("Project1");
        ResourceTestUtil.createInWorkspace((IResource)target);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project2");
        ResourceTestUtil.createInWorkspace((IResource)project);
        project.open(ResourceTestUtil.createTestMonitor());
        IProjectDescription description = project.getDescription();
        description.setReferencedProjects(new IProject[]{target});
        project.setDescription(description, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])target.getReferencingProjects()).hasSize(1);
        Assert.assertThrows(CoreException.class, () -> {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProject("DoesNotExist").getReferencedProjects();
        });
        Object[] refs = ResourcesPlugin.getWorkspace().getRoot().getProject("DoesNotExist2").getReferencingProjects();
        Assertions.assertThat((Object[])refs).isEmpty();
    }
}

