/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import org.assertj.core.api.Assertions;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class IProjectTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private final FussyProgressMonitor monitor = new FussyProgressMonitor();

    public void ensureExistsInWorkspace(IProject project, IProjectDescription description) throws CoreException {
        if (project == null) {
            return;
        }
        IWorkspaceRunnable body = mon -> {
            project.create(description, mon);
            project.open(mon);
        };
        this.monitor.prepare();
        ResourcesPlugin.getWorkspace().run(body, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
    }

    public void setGetPersistentProperty(IResource target) throws CoreException {
        String value = "this is a test property value";
        QualifiedName name = new QualifiedName("itp-test", "testProperty");
        target.setPersistentProperty(name, value);
        Assert.assertTrue((String)"get not equal set", (boolean)target.getPersistentProperty(name).equals(value));
        name = new QualifiedName("eclipse-test", "testNonProperty");
        Assert.assertNull((String)"non-existant persistent property not missing", (Object)target.getPersistentProperty(name));
    }

    @Before
    public void setUp() throws Exception {
        this.monitor.prepare();
    }

    @Test
    public void testCopy() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Source");
        project.create((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        project.open((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        project.createMarker("org.eclipse.core.resources.taskmarker");
        IProject destination = ResourcesPlugin.getWorkspace().getRoot().getProject("Destination");
        Assert.assertFalse((String)"1.0", (boolean)destination.exists());
        this.monitor.prepare();
        project.copy(destination.getFullPath(), 0, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertTrue((String)"1.1", (boolean)destination.exists());
        Assertions.assertThat((Object[])destination.findMarkers("org.eclipse.core.resources.taskmarker", true, 2)).isEmpty();
    }

    @Test
    public void testGetNature() throws CoreException {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject project = ws.getRoot().getProject("Project");
        Assert.assertThrows(CoreException.class, () -> {
            IProjectNature iProjectNature = project.getNature("org.eclipse.core.tests.resources.simpleNature");
        });
        Assert.assertThrows(CoreException.class, () -> {
            IProjectNature iProjectNature = project.getNature("no.such.nature.Missing");
        });
        this.monitor.prepare();
        project.create((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertThrows(CoreException.class, () -> {
            IProjectNature iProjectNature = project.getNature("org.eclipse.core.tests.resources.simpleNature");
        });
        Assert.assertThrows(CoreException.class, () -> {
            IProjectNature iProjectNature = project.getNature("no.such.nature.Missing");
        });
        this.monitor.prepare();
        project.open((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertNull((String)"3.0", (Object)project.getNature("org.eclipse.core.tests.resources.simpleNature"));
        Assert.assertNull((String)"3.1", (Object)project.getNature("no.such.nature.Missing"));
        Assert.assertNull((String)"3.2", (Object)project.getNature("org.eclipse.core.tests.resources.earthNature"));
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.simpleNature"});
        this.monitor.prepare();
        project.setDescription(desc, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        IProjectNature nature = project.getNature("org.eclipse.core.tests.resources.simpleNature");
        Assert.assertNotNull((String)"5.0", (Object)nature);
        Assert.assertNull((String)"5.1", (Object)project.getNature("no.such.nature.Missing"));
        Assert.assertNull((String)"5.2", (Object)project.getNature("org.eclipse.core.tests.resources.earthNature"));
        Assert.assertEquals((String)"6.0", (Object)project, (Object)nature.getProject());
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject("testGetNature.Destination");
        IProjectNature nature2 = null;
        this.monitor.prepare();
        project.copy(project2.getFullPath(), 0, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        nature2 = project2.getNature("org.eclipse.core.tests.resources.simpleNature");
        Assert.assertNotNull((String)"7.0", (Object)nature2);
        Assert.assertEquals((String)"7.1", (Object)project2, (Object)nature2.getProject());
        Assert.assertEquals((String)"7.2", (Object)project, (Object)nature.getProject());
    }

    @Test
    public void testHasNature() throws CoreException {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject project = ws.getRoot().getProject("Project");
        Assert.assertThrows(CoreException.class, () -> {
            boolean bl = project.hasNature("org.eclipse.core.tests.resources.simpleNature");
        });
        Assert.assertThrows(CoreException.class, () -> {
            boolean bl = project.hasNature("no.such.nature.Missing");
        });
        this.monitor.prepare();
        project.create((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertThrows(CoreException.class, () -> {
            boolean bl = project.hasNature("org.eclipse.core.tests.resources.simpleNature");
        });
        Assert.assertThrows(CoreException.class, () -> {
            boolean bl = project.hasNature("no.such.nature.Missing");
        });
        this.monitor.prepare();
        project.open((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"3.0", (boolean)project.hasNature("org.eclipse.core.tests.resources.simpleNature"));
        Assert.assertFalse((String)"3.1", (boolean)project.hasNature("no.such.nature.Missing"));
        Assert.assertFalse((String)"3.2", (boolean)project.hasNature("org.eclipse.core.tests.resources.earthNature"));
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.simpleNature"});
        this.monitor.prepare();
        project.setDescription(desc, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertTrue((String)"5.0", (boolean)project.hasNature("org.eclipse.core.tests.resources.simpleNature"));
        Assert.assertFalse((String)"5.1", (boolean)project.hasNature("no.such.nature.Missing"));
        Assert.assertFalse((String)"5.2", (boolean)project.hasNature("org.eclipse.core.tests.resources.earthNature"));
    }

    @Test
    public void testInvalidProjectNames() throws CoreException {
        IProject project;
        String name;
        String[] names;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String[] stringArray = names = new String[]{"", "/"};
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            name = stringArray[n2];
            Assert.assertThrows(RuntimeException.class, () -> {
                IProject iProject = root.getProject(name);
            });
            ++n2;
        }
        names = new String[]{};
        if (Platform.OS.isWindows()) {
            names = new String[]{"foo:bar", "prn", "nul", "con", "aux", "clock$", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "AUX", "con.foo", "LPT4.txt", "*", "?", "\"", "<", ">", "|", "::"};
        }
        stringArray = names;
        n = names.length;
        n2 = 0;
        while (n2 < n) {
            name = stringArray[n2];
            project = root.getProject(name);
            Assert.assertFalse((String)("1.0 " + name), (boolean)project.exists());
            Assert.assertThrows(CoreException.class, () -> {
                this.monitor.prepare();
                project.create((IProgressMonitor)this.monitor);
                this.monitor.assertUsedUp();
                this.monitor.prepare();
                project.open((IProgressMonitor)this.monitor);
                this.monitor.assertUsedUp();
            });
            Assert.assertFalse((String)("1.2 " + name), (boolean)project.exists());
            Assert.assertFalse((String)("1.3 " + name), (boolean)project.isOpen());
            ++n2;
        }
        names = Platform.OS.isWindows() ? new String[]{"hello.prn.txt", "null", "con3", "foo.aux", "lpt0", "com0", "com10", "lpt10", ",", "'", ";"} : new String[]{"foo:bar", "prn", "nul", "con", "aux", "clock$", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "con.foo", "LPT4.txt", "*", "?", "\"", "<", ">", "|", "hello.prn.txt", "null", "con3", "foo.aux", "lpt0", "com0", "com10", "lpt10", ",", "'", ";"};
        stringArray = names;
        n = names.length;
        n2 = 0;
        while (n2 < n) {
            name = stringArray[n2];
            project = root.getProject(name);
            Assert.assertFalse((String)("2.0 " + name), (boolean)project.exists());
            this.monitor.prepare();
            project.create((IProgressMonitor)this.monitor);
            this.monitor.assertUsedUp();
            this.monitor.prepare();
            project.open((IProgressMonitor)this.monitor);
            this.monitor.assertUsedUp();
            Assert.assertTrue((String)("2.2 " + name), (boolean)project.exists());
            Assert.assertTrue((String)("2.3 " + name), (boolean)project.isOpen());
            ++n2;
        }
    }

    @Test
    public void testIsNatureEnabled() throws CoreException {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject project = ws.getRoot().getProject("Project");
        Assert.assertThrows(CoreException.class, () -> {
            boolean bl = project.isNatureEnabled("org.eclipse.core.tests.resources.simpleNature");
        });
        Assert.assertThrows(CoreException.class, () -> {
            boolean bl = project.isNatureEnabled("no.such.nature.Missing");
        });
        this.monitor.prepare();
        project.create((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertThrows(CoreException.class, () -> {
            boolean bl = project.isNatureEnabled("org.eclipse.core.tests.resources.simpleNature");
        });
        Assert.assertThrows(CoreException.class, () -> {
            boolean bl = project.isNatureEnabled("no.such.nature.Missing");
        });
        this.monitor.prepare();
        project.open((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"3.0", (boolean)project.isNatureEnabled("org.eclipse.core.tests.resources.simpleNature"));
        Assert.assertFalse((String)"3.1", (boolean)project.isNatureEnabled("no.such.nature.Missing"));
        Assert.assertFalse((String)"3.2", (boolean)project.isNatureEnabled("org.eclipse.core.tests.resources.earthNature"));
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.simpleNature"});
        this.monitor.prepare();
        project.setDescription(desc, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertTrue((String)"5.0", (boolean)project.isNatureEnabled("org.eclipse.core.tests.resources.simpleNature"));
        Assert.assertFalse((String)"5.1", (boolean)project.isNatureEnabled("no.such.nature.Missing"));
        Assert.assertFalse((String)"5.2", (boolean)project.isNatureEnabled("org.eclipse.core.tests.resources.earthNature"));
    }

    @Test
    public void testPathVariableLocation() throws CoreException {
        String projectName = "Project";
        String varName = "ProjectLocatio";
        IPath varValue = Platform.getLocation().removeLastSegments(1);
        IPath rawLocation = IPath.fromOSString((String)"ProjectLocatio").append("ProjectLocation");
        ResourcesPlugin.getWorkspace().getPathVariableManager().setValue("ProjectLocatio", varValue);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription("Project");
        description.setLocation(rawLocation);
        this.monitor.prepare();
        project.create(description, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        project.open((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertEquals((String)"1.0", (Object)varValue, (Object)ResourcesPlugin.getWorkspace().getPathVariableManager().getValue("ProjectLocatio"));
        Assert.assertTrue((String)"1.1", (boolean)project.exists());
        Assert.assertTrue((String)"1.2", (boolean)project.isOpen());
        Assert.assertEquals((String)"1.3", (Object)rawLocation, (Object)project.getRawLocation());
        Assert.assertEquals((String)"1.4", (Object)varValue.append(rawLocation.lastSegment()), (Object)project.getLocation());
    }

    @Test
    public void testProjectCloseOpen() throws CoreException {
        IProject target = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)target);
        IFolder folder = target.getFolder("Folder");
        ResourceTestUtil.createInWorkspace((IResource)folder);
        target.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertTrue((String)"1.1", (boolean)target.exists());
        Assert.assertFalse((String)"1.2", (boolean)target.isOpen());
        Assert.assertFalse((String)"1.3", (boolean)folder.exists());
        this.monitor.prepare();
        target.open((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertTrue((String)"2.1", (boolean)target.isOpen());
        Assert.assertTrue((String)"2.2", (boolean)folder.exists());
    }

    @Test
    public void testProjectCopyVariations() throws CoreException {
        IProject project;
        QualifiedName qname = new QualifiedName("com.example", "myProperty");
        String actual = null;
        String value = "this is my property value.";
        IProject source = project = ResourcesPlugin.getWorkspace().getRoot().getProject("SourceProject");
        String[] children = new String[]{"/1/", "/1/2"};
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, children);
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.createInWorkspace(resources);
        IProject destination = ResourcesPlugin.getWorkspace().getRoot().getProject("DestProject");
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)destination);
        IResource sourceChild = resources[1];
        sourceChild.setPersistentProperty(qname, value);
        source.copy(destination.getFullPath(), false, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        ResourceTestUtil.assertExistsInWorkspace((IResource)project);
        ResourceTestUtil.assertExistsInWorkspace(resources);
        resources = ResourceTestUtil.buildResources((IContainer)destination, children);
        ResourceTestUtil.assertExistsInWorkspace((IResource)destination);
        ResourceTestUtil.assertExistsInWorkspace(resources);
        IResource destChild = resources[1];
        actual = destChild.getPersistentProperty(qname);
        Assert.assertNotNull((String)"1.8", (Object)actual);
        Assert.assertEquals((String)"1.9", (Object)value, (Object)actual);
        this.monitor.prepare();
        ResourcesPlugin.getWorkspace().getRoot().delete(false, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        source = project = ResourcesPlugin.getWorkspace().getRoot().getProject("SourceProject");
        children = new String[]{"/1/", "/1/2"};
        resources = ResourceTestUtil.buildResources((IContainer)project, children);
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.createInWorkspace(resources);
        destination = ResourcesPlugin.getWorkspace().getRoot().getProject("DestProject");
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(destination.getName());
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)destination);
        sourceChild = resources[1];
        sourceChild.setPersistentProperty(qname, value);
        this.monitor.prepare();
        source.copy(description, false, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        ResourceTestUtil.assertExistsInWorkspace((IResource)project);
        ResourceTestUtil.assertExistsInWorkspace(resources);
        resources = ResourceTestUtil.buildResources((IContainer)destination, children);
        ResourceTestUtil.assertExistsInWorkspace((IResource)destination);
        ResourceTestUtil.assertExistsInWorkspace(resources);
        destChild = resources[1];
        actual = destChild.getPersistentProperty(qname);
        Assert.assertNotNull((String)"2.8", (Object)actual);
        Assert.assertEquals((String)"2.9", (Object)value, (Object)actual);
        this.monitor.prepare();
        ResourcesPlugin.getWorkspace().getRoot().delete(false, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        source = project = ResourcesPlugin.getWorkspace().getRoot().getProject("SourceProject");
        children = new String[]{"/1/", "/1/2"};
        resources = ResourceTestUtil.buildResources((IContainer)project, children);
        IProject destProject = ResourcesPlugin.getWorkspace().getRoot().getProject("DestProject");
        destination = destProject.getFolder("MyFolder");
        ResourceTestUtil.createInWorkspace(new IResource[]{project, destProject});
        ResourceTestUtil.createInWorkspace(resources);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)destination);
        this.monitor.prepare();
        IProject projectToCopy = source;
        IProject destinationFolder = destination;
        Assert.assertThrows(CoreException.class, () -> this.lambda$15((IResource)projectToCopy, (IResource)destinationFolder));
        this.monitor.prepare();
        ResourcesPlugin.getWorkspace().getRoot().delete(false, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("SourceProject");
        children = new String[]{"/1/", "/1/2"};
        source = project.getFolder("1");
        resources = ResourceTestUtil.buildResources((IContainer)project, children);
        destination = ResourcesPlugin.getWorkspace().getRoot().getProject("DestProject");
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.createInWorkspace(resources);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)destination);
        this.monitor.prepare();
        IProject folderToCopy = source;
        IProject destinationProject = destination;
        Assert.assertThrows(CoreException.class, () -> this.lambda$16((IResource)folderToCopy, (IResource)destinationProject));
        this.monitor.prepare();
        ResourcesPlugin.getWorkspace().getRoot().delete(true, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
    }

    @Test
    public void testProjectCreateOpenCloseDelete() throws CoreException {
        IProject target = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        target.create((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertTrue((String)"1.1", (boolean)target.exists());
        this.monitor.prepare();
        target.open((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertTrue((String)"2.1", (boolean)target.isOpen());
        this.monitor.prepare();
        target.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"3.1", (boolean)target.isOpen());
        this.monitor.prepare();
        target.delete(true, true, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"4.1", (boolean)target.exists());
    }

    @Test
    public void testProjectCreation() throws CoreException {
        IProject target = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        target.create((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertTrue((String)"1.0", (boolean)target.exists());
        Assert.assertFalse((String)"1.2", (boolean)target.isOpen());
        this.monitor.prepare();
        target.open((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertTrue((String)"2.0", (boolean)target.isOpen());
    }

    @Test
    public void testProjectCreationLineSeparator() throws BackingStoreException, CoreException {
        String newProjectValue;
        String newInstanceValue;
        String systemValue = System.lineSeparator();
        if (systemValue.equals("\n")) {
            newInstanceValue = "\r";
            newProjectValue = "\r\n";
        } else if (systemValue.equals("\r")) {
            newInstanceValue = "\n";
            newProjectValue = "\r\n";
        } else {
            newInstanceValue = "\r";
            newProjectValue = "\n";
        }
        IEclipsePreferences rootNode = Platform.getPreferencesService().getRootNode();
        Preferences instanceNode = rootNode.node("instance").node("org.eclipse.core.runtime");
        String oldInstanceValue = instanceNode.get("line.separator", null);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFile file = project.getFile(".project");
        try {
            ResourceTestUtil.createInWorkspace((IResource)project);
            Assert.assertEquals((String)"1.0", (Object)systemValue, (Object)ResourceTestUtil.getLineSeparatorFromFile(file));
            instanceNode.put("line.separator", newInstanceValue);
            instanceNode.flush();
            IProjectDescription description = project.getDescription();
            description.setComment("some comment");
            this.monitor.prepare();
            project.setDescription(description, (IProgressMonitor)this.monitor);
            this.monitor.assertUsedUp();
            Assert.assertEquals((String)"2.0", (Object)systemValue, (Object)ResourceTestUtil.getLineSeparatorFromFile(file));
            this.monitor.prepare();
            project.delete(true, (IProgressMonitor)this.monitor);
            this.monitor.assertUsedUp();
            ResourceTestUtil.createInWorkspace((IResource)project);
            Assert.assertEquals((String)"3.0", (Object)newInstanceValue, (Object)ResourceTestUtil.getLineSeparatorFromFile(file));
            if (oldInstanceValue == null) {
                instanceNode.remove("line.separator");
            } else {
                instanceNode.put("line.separator", oldInstanceValue);
            }
            instanceNode.flush();
            description = project.getDescription();
            description.setComment("some comment");
            this.monitor.prepare();
            project.setDescription(description, (IProgressMonitor)this.monitor);
            this.monitor.assertUsedUp();
            Assert.assertEquals((String)"4.0", (Object)newInstanceValue, (Object)ResourceTestUtil.getLineSeparatorFromFile(file));
            this.monitor.prepare();
            project.delete(true, (IProgressMonitor)this.monitor);
            this.monitor.assertUsedUp();
            ResourceTestUtil.createInWorkspace((IResource)project);
            Assert.assertEquals((String)"5.0", (Object)systemValue, (Object)ResourceTestUtil.getLineSeparatorFromFile(file));
            Preferences projectNode = rootNode.node("project").node(project.getName()).node("org.eclipse.core.runtime");
            projectNode.put("line.separator", newProjectValue);
            projectNode.flush();
            this.monitor.prepare();
            file.delete(true, (IProgressMonitor)this.monitor);
            this.monitor.assertUsedUp();
            Assert.assertFalse((String)"6.0", (boolean)file.exists());
            this.monitor.prepare();
            ResourcesPlugin.getWorkspace().save(true, (IProgressMonitor)this.monitor);
            this.monitor.assertUsedUp();
            this.monitor.prepare();
            project.refreshLocal(2, (IProgressMonitor)this.monitor);
            this.monitor.assertUsedUp();
            Assert.assertTrue((String)"7.0", (boolean)file.exists());
            Assert.assertEquals((String)"8.0", (Object)newProjectValue, (Object)ResourceTestUtil.getLineSeparatorFromFile(file));
        }
        finally {
            if (oldInstanceValue == null) {
                instanceNode.remove("line.separator");
            } else {
                instanceNode.put("line.separator", oldInstanceValue);
            }
            instanceNode.flush();
            project.delete(true, null);
        }
    }

    @Test
    public void testProjectCreationInvalidLocation() {
        IProject target = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(target.getName());
        description.setLocation(Platform.getLocation().append(".metadata"));
        Assert.assertThrows(CoreException.class, () -> {
            target.create(description, (IProgressMonitor)this.monitor);
            this.monitor.assertUsedUp();
        });
        IProject target2 = ResourcesPlugin.getWorkspace().getRoot().getProject(".metadata");
        IProjectDescription description2 = ResourcesPlugin.getWorkspace().newProjectDescription(target2.getName());
        Assert.assertThrows(CoreException.class, () -> {
            this.monitor.prepare();
            target2.create(description2, (IProgressMonitor)this.monitor);
            this.monitor.assertUsedUp();
        });
        Assert.assertThrows(CoreException.class, () -> {
            this.monitor.prepare();
            target2.create((IProgressMonitor)this.monitor);
            this.monitor.assertUsedUp();
        });
    }

    @Test
    public void testProjectCreationLocationExistsWithDifferentCase() throws CoreException {
        Assume.assumeTrue((String)"only relevant on Windows", (boolean)Platform.OS.isWindows());
        String projectName = ResourceTestUtil.createUniqueString() + "a";
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        project.create((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        project.delete(false, true, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        IProject uppercaseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName.toUpperCase());
        this.monitor.prepare();
        Assert.assertThrows(CoreException.class, () -> uppercaseProject.create((IProgressMonitor)this.monitor));
        this.monitor.assertUsedUp();
        project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        this.monitor.prepare();
        project.create((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
    }

    @Test
    public void testProjectDeletionClosedDefaultInSync() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("myfile.txt");
        IFile otherFile = project.getFile("myotherfile.txt");
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file, otherFile});
        IFileStore projectStore = ((Resource)project).getStore();
        IFileStore fileStore = ((Resource)file).getStore();
        IFileStore otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"1.0", (boolean)project.exists());
        Assert.assertTrue((String)"1.1", (boolean)file.exists());
        Assert.assertTrue((String)"1.2", (boolean)otherFile.exists());
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertTrue((String)"1.4", (boolean)project.exists());
        Assert.assertFalse((String)"1.5", (boolean)project.isOpen());
        Assert.assertFalse((String)"1.6", (boolean)project.isAccessible());
        Assert.assertFalse((String)"1.7", (boolean)file.exists());
        Assert.assertFalse((String)"1.8", (boolean)otherFile.exists());
        int updateFlags = 1;
        this.monitor.prepare();
        project.delete(updateFlags |= 4, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"1.10", (boolean)project.exists());
        Assert.assertFalse((String)"1.11", (boolean)file.exists());
        Assert.assertFalse((String)"1.12", (boolean)otherFile.exists());
        Assert.assertFalse((String)"1.13", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"1.14", (boolean)fileStore.fetchInfo().exists());
        Assert.assertFalse((String)"1.15", (boolean)otherFileStore.fetchInfo().exists());
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file, otherFile});
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"2.0", (boolean)project.exists());
        Assert.assertTrue((String)"2.1", (boolean)file.exists());
        Assert.assertTrue((String)"2.2", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertTrue((String)"2.4", (boolean)project.exists());
        Assert.assertFalse((String)"2.5", (boolean)project.isOpen());
        Assert.assertFalse((String)"2.6", (boolean)project.isAccessible());
        Assert.assertFalse((String)"2.7", (boolean)file.exists());
        Assert.assertFalse((String)"2.8", (boolean)otherFile.exists());
        updateFlags = 4;
        this.monitor.prepare();
        project.delete(updateFlags, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"2.10", (boolean)project.exists());
        Assert.assertFalse((String)"2.11", (boolean)file.exists());
        Assert.assertFalse((String)"2.12", (boolean)otherFile.exists());
        Assert.assertFalse((String)"2.13", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"2.14", (boolean)fileStore.fetchInfo().exists());
        Assert.assertFalse((String)"2.15", (boolean)otherFileStore.fetchInfo().exists());
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file, otherFile});
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"3.0", (boolean)project.exists());
        Assert.assertTrue((String)"3.1", (boolean)file.exists());
        Assert.assertTrue((String)"3.2", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertTrue((String)"3.4", (boolean)project.exists());
        Assert.assertFalse((String)"3.5", (boolean)project.isOpen());
        Assert.assertFalse((String)"3.6", (boolean)project.isAccessible());
        Assert.assertFalse((String)"3.7", (boolean)file.exists());
        Assert.assertFalse((String)"3.8", (boolean)otherFile.exists());
        updateFlags = 1;
        this.monitor.prepare();
        project.delete(updateFlags |= 8, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"3.10", (boolean)project.exists());
        Assert.assertFalse((String)"3.11", (boolean)file.exists());
        Assert.assertFalse((String)"3.12", (boolean)otherFile.exists());
        Assert.assertTrue((String)"3.13", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"3.14", (boolean)fileStore.fetchInfo().exists());
        Assert.assertTrue((String)"3.15", (boolean)otherFileStore.fetchInfo().exists());
        projectStore.delete(0, null);
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file, otherFile});
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"4.0", (boolean)project.exists());
        Assert.assertTrue((String)"4.1", (boolean)file.exists());
        Assert.assertTrue((String)"4.2", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertTrue((String)"4.4", (boolean)project.exists());
        Assert.assertFalse((String)"4.5", (boolean)project.isOpen());
        Assert.assertFalse((String)"4.6", (boolean)project.isAccessible());
        Assert.assertFalse((String)"4.7", (boolean)file.exists());
        Assert.assertFalse((String)"4.8", (boolean)otherFile.exists());
        updateFlags = 8;
        this.monitor.prepare();
        project.delete(updateFlags, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"4.10", (boolean)project.exists());
        Assert.assertFalse((String)"4.11", (boolean)file.exists());
        Assert.assertFalse((String)"4.12", (boolean)otherFile.exists());
        Assert.assertTrue((String)"4.13", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"4.14", (boolean)fileStore.fetchInfo().exists());
        Assert.assertTrue((String)"4.15", (boolean)otherFileStore.fetchInfo().exists());
        projectStore.delete(0, null);
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file, otherFile});
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"5.0", (boolean)project.exists());
        Assert.assertTrue((String)"5.1", (boolean)file.exists());
        Assert.assertTrue((String)"5.2", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertTrue((String)"5.4", (boolean)project.exists());
        Assert.assertFalse((String)"5.5", (boolean)project.isOpen());
        Assert.assertFalse((String)"5.6", (boolean)project.isAccessible());
        Assert.assertFalse((String)"5.7", (boolean)file.exists());
        Assert.assertFalse((String)"5.8", (boolean)otherFile.exists());
        updateFlags = 1;
        this.monitor.prepare();
        project.delete(updateFlags, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"5.10", (boolean)project.exists());
        Assert.assertFalse((String)"5.11", (boolean)file.exists());
        Assert.assertFalse((String)"5.12", (boolean)otherFile.exists());
        Assert.assertTrue((String)"5.13", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"5.14", (boolean)fileStore.fetchInfo().exists());
        Assert.assertTrue((String)"5.15", (boolean)otherFileStore.fetchInfo().exists());
        projectStore.delete(0, null);
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file, otherFile});
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"6.0", (boolean)project.exists());
        Assert.assertTrue((String)"6.1", (boolean)file.exists());
        Assert.assertTrue((String)"6.2", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertTrue((String)"6.4", (boolean)project.exists());
        Assert.assertFalse((String)"6.5", (boolean)project.isOpen());
        Assert.assertFalse((String)"6.6", (boolean)project.isAccessible());
        Assert.assertFalse((String)"6.7", (boolean)file.exists());
        Assert.assertFalse((String)"6.8", (boolean)otherFile.exists());
        updateFlags = 0;
        this.monitor.prepare();
        project.delete(updateFlags, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"6.10", (boolean)project.exists());
        Assert.assertFalse((String)"6.11", (boolean)file.exists());
        Assert.assertFalse((String)"6.12", (boolean)otherFile.exists());
        Assert.assertTrue((String)"6.13", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"6.14", (boolean)fileStore.fetchInfo().exists());
        Assert.assertTrue((String)"6.15", (boolean)otherFileStore.fetchInfo().exists());
        projectStore.delete(0, null);
    }

    @Test
    public void testProjectDeletionClosedDefaultOutOfSync() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("myfile.txt");
        IFile otherFile = project.getFile("myotherfile.txt");
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file});
        IFileStore projectStore = ((Resource)project).getStore();
        IFileStore fileStore = ((Resource)file).getStore();
        IFileStore otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"1.0", (boolean)project.exists());
        Assert.assertTrue((String)"1.1", (boolean)file.exists());
        Assert.assertFalse((String)"1.2", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        ResourceTestUtil.createInFileSystem(otherFileStore);
        Assert.assertTrue((String)"1.5", (boolean)otherFileStore.fetchInfo().exists());
        Assert.assertTrue((String)"1.6", (boolean)project.exists());
        Assert.assertFalse((String)"1.7", (boolean)project.isOpen());
        Assert.assertFalse((String)"1.8", (boolean)project.isAccessible());
        Assert.assertFalse((String)"1.9", (boolean)file.exists());
        Assert.assertFalse((String)"1.10", (boolean)otherFile.exists());
        int updateFlags = 1;
        this.monitor.prepare();
        project.delete(updateFlags |= 4, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"1.12", (boolean)project.exists());
        Assert.assertFalse((String)"1.13", (boolean)file.exists());
        Assert.assertFalse((String)"1.14", (boolean)otherFile.exists());
        Assert.assertFalse((String)"1.15", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"1.16", (boolean)fileStore.fetchInfo().exists());
        Assert.assertFalse((String)"1.17", (boolean)otherFileStore.fetchInfo().exists());
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file});
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"2.0", (boolean)project.exists());
        Assert.assertTrue((String)"2.1", (boolean)file.exists());
        Assert.assertFalse((String)"2.2", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        ResourceTestUtil.createInFileSystem(otherFileStore);
        Assert.assertTrue((String)"2.5", (boolean)otherFileStore.fetchInfo().exists());
        Assert.assertTrue((String)"2.6", (boolean)project.exists());
        Assert.assertFalse((String)"2.7", (boolean)project.isOpen());
        Assert.assertFalse((String)"2.8", (boolean)project.isAccessible());
        Assert.assertFalse((String)"2.9", (boolean)file.exists());
        Assert.assertFalse((String)"2.10", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.delete(4, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"2.12", (boolean)project.exists());
        Assert.assertFalse((String)"2.13", (boolean)file.exists());
        Assert.assertFalse((String)"2.14", (boolean)otherFile.exists());
        Assert.assertFalse((String)"2.15", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"2.16", (boolean)fileStore.fetchInfo().exists());
        Assert.assertFalse((String)"2.17", (boolean)otherFileStore.fetchInfo().exists());
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file});
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"3.0", (boolean)project.exists());
        Assert.assertTrue((String)"3.1", (boolean)file.exists());
        Assert.assertFalse((String)"3.2", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        ResourceTestUtil.createInFileSystem(otherFileStore);
        Assert.assertTrue((String)"3.5", (boolean)otherFileStore.fetchInfo().exists());
        Assert.assertTrue((String)"3.6", (boolean)project.exists());
        Assert.assertFalse((String)"3.7", (boolean)project.isOpen());
        Assert.assertFalse((String)"3.8", (boolean)project.isAccessible());
        Assert.assertFalse((String)"3.9", (boolean)file.exists());
        Assert.assertFalse((String)"3.10", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.delete(9, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"3.12", (boolean)project.exists());
        Assert.assertFalse((String)"3.13", (boolean)file.exists());
        Assert.assertFalse((String)"3.14", (boolean)otherFile.exists());
        Assert.assertTrue((String)"3.15", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"3.16", (boolean)fileStore.fetchInfo().exists());
        Assert.assertTrue((String)"3.17", (boolean)otherFileStore.fetchInfo().exists());
        projectStore.delete(0, null);
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file});
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"4.0", (boolean)project.exists());
        Assert.assertTrue((String)"4.1", (boolean)file.exists());
        Assert.assertFalse((String)"4.2", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        ResourceTestUtil.createInFileSystem(otherFileStore);
        Assert.assertTrue((String)"4.5", (boolean)otherFileStore.fetchInfo().exists());
        Assert.assertTrue((String)"4.6", (boolean)project.exists());
        Assert.assertFalse((String)"4.7", (boolean)project.isOpen());
        Assert.assertFalse((String)"4.8", (boolean)project.isAccessible());
        Assert.assertFalse((String)"4.9", (boolean)file.exists());
        Assert.assertFalse((String)"4.10", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.delete(8, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"4.12", (boolean)project.exists());
        Assert.assertFalse((String)"4.13", (boolean)file.exists());
        Assert.assertFalse((String)"4.14", (boolean)otherFile.exists());
        Assert.assertTrue((String)"4.15", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"4.16", (boolean)fileStore.fetchInfo().exists());
        Assert.assertTrue((String)"4.17", (boolean)otherFileStore.fetchInfo().exists());
        projectStore.delete(0, null);
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file});
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"5.0", (boolean)project.exists());
        Assert.assertTrue((String)"5.1", (boolean)file.exists());
        Assert.assertFalse((String)"5.2", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        ResourceTestUtil.createInFileSystem(otherFileStore);
        Assert.assertTrue((String)"5.5", (boolean)otherFileStore.fetchInfo().exists());
        Assert.assertTrue((String)"5.6", (boolean)project.exists());
        Assert.assertFalse((String)"5.7", (boolean)project.isOpen());
        Assert.assertFalse((String)"5.8", (boolean)project.isAccessible());
        Assert.assertFalse((String)"5.9", (boolean)file.exists());
        Assert.assertFalse((String)"5.10", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.delete(1, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"5.12", (boolean)project.exists());
        Assert.assertFalse((String)"5.13", (boolean)file.exists());
        Assert.assertFalse((String)"5.14", (boolean)otherFile.exists());
        Assert.assertTrue((String)"5.15", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"5.16", (boolean)fileStore.fetchInfo().exists());
        Assert.assertTrue((String)"5.17", (boolean)otherFileStore.fetchInfo().exists());
        projectStore.delete(0, null);
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file});
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"6.0", (boolean)project.exists());
        Assert.assertTrue((String)"6.1", (boolean)file.exists());
        Assert.assertFalse((String)"6.2", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        ResourceTestUtil.createInFileSystem(otherFileStore);
        Assert.assertTrue((String)"6.5", (boolean)otherFileStore.fetchInfo().exists());
        Assert.assertTrue((String)"6.6", (boolean)project.exists());
        Assert.assertFalse((String)"6.7", (boolean)project.isOpen());
        Assert.assertFalse((String)"6.8", (boolean)project.isAccessible());
        Assert.assertFalse((String)"6.9", (boolean)file.exists());
        Assert.assertFalse((String)"6.10", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.delete(0, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"6.12", (boolean)project.exists());
        Assert.assertFalse((String)"6.13", (boolean)file.exists());
        Assert.assertFalse((String)"6.14", (boolean)otherFile.exists());
        Assert.assertTrue((String)"6.15", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"6.16", (boolean)fileStore.fetchInfo().exists());
        Assert.assertTrue((String)"6.17", (boolean)otherFileStore.fetchInfo().exists());
        projectStore.delete(0, null);
    }

    @Test
    public void testProjectDeletionClosedUserDefinedInSync() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("myfile.txt");
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        IFileStore projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace((IResource)file);
        IFileStore fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"1.2", (boolean)project.exists());
        Assert.assertTrue((String)"1.3", (boolean)file.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        int updateFlags = 1;
        this.monitor.prepare();
        project.delete(updateFlags |= 4, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"1.6", (boolean)project.exists());
        Assert.assertFalse((String)"1.7", (boolean)file.exists());
        Assert.assertFalse((String)"1.8", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"1.9", (boolean)fileStore.fetchInfo().exists());
        projectStore.delete(0, null);
        projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace((IResource)file);
        fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"2.2", (boolean)project.exists());
        Assert.assertTrue((String)"2.3", (boolean)file.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        project.delete(4, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"2.6", (boolean)project.exists());
        Assert.assertFalse((String)"2.7", (boolean)file.exists());
        Assert.assertFalse((String)"2.8", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"2.9", (boolean)fileStore.fetchInfo().exists());
        projectStore.delete(0, null);
        projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace((IResource)file);
        fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"3.2", (boolean)project.exists());
        Assert.assertTrue((String)"3.3", (boolean)file.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        project.delete(9, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"3.6", (boolean)project.exists());
        Assert.assertFalse((String)"3.7", (boolean)file.exists());
        Assert.assertTrue((String)"3.8", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"3.9", (boolean)fileStore.fetchInfo().exists());
        projectStore.delete(0, null);
        projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace((IResource)file);
        fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"4.2", (boolean)project.exists());
        Assert.assertTrue((String)"4.3", (boolean)file.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        project.delete(8, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"4.6", (boolean)project.exists());
        Assert.assertFalse((String)"4.7", (boolean)file.exists());
        Assert.assertTrue((String)"4.8", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"4.9", (boolean)fileStore.fetchInfo().exists());
        projectStore.delete(0, null);
        projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file});
        fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"5.2", (boolean)project.exists());
        Assert.assertTrue((String)"5.3", (boolean)file.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        project.delete(1, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"5.6", (boolean)project.exists());
        Assert.assertFalse((String)"5.7", (boolean)file.exists());
        Assert.assertTrue((String)"5.8", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"5.9", (boolean)fileStore.fetchInfo().exists());
        projectStore.delete(0, null);
        projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace((IResource)file);
        fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"6.2", (boolean)project.exists());
        Assert.assertTrue((String)"6.3", (boolean)file.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        project.delete(0, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"6.6", (boolean)project.exists());
        Assert.assertFalse((String)"6.7", (boolean)file.exists());
        Assert.assertTrue((String)"6.8", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"6.9", (boolean)fileStore.fetchInfo().exists());
        projectStore.delete(0, null);
    }

    @Test
    public void testProjectDeletionClosedUserDefinedOutOfSync() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("myfile.txt");
        IFile otherFile = project.getFile("myotherfile.txt");
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        IFileStore projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace((IResource)file);
        ResourceTestUtil.createInFileSystem((IResource)otherFile);
        IFileStore fileStore = ((Resource)file).getStore();
        IFileStore otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"1.0", (boolean)project.exists());
        Assert.assertTrue((String)"1.1", (boolean)file.exists());
        Assert.assertFalse((String)"1.2", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        int updateFlags = 1;
        this.monitor.prepare();
        project.delete(updateFlags |= 4, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"1.5", (boolean)project.exists());
        Assert.assertFalse((String)"1.6", (boolean)file.exists());
        Assert.assertFalse((String)"1.7", (boolean)otherFile.exists());
        Assert.assertFalse((String)"1.8", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"1.9", (boolean)fileStore.fetchInfo().exists());
        Assert.assertFalse((String)"1.10", (boolean)otherFileStore.fetchInfo().exists());
        projectStore.delete(0, null);
        projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace((IResource)file);
        ResourceTestUtil.createInFileSystem((IResource)otherFile);
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"2.0", (boolean)project.exists());
        Assert.assertTrue((String)"2.1", (boolean)file.exists());
        Assert.assertFalse((String)"2.2", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        project.delete(4, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"2.5", (boolean)project.exists());
        Assert.assertFalse((String)"2.6", (boolean)file.exists());
        Assert.assertFalse((String)"2.7", (boolean)otherFile.exists());
        Assert.assertFalse((String)"2.8", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"2.9", (boolean)fileStore.fetchInfo().exists());
        Assert.assertFalse((String)"2.10", (boolean)otherFileStore.fetchInfo().exists());
        projectStore.delete(0, null);
        projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace((IResource)file);
        ResourceTestUtil.createInFileSystem((IResource)otherFile);
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"3.0", (boolean)project.exists());
        Assert.assertTrue((String)"3.1", (boolean)file.exists());
        Assert.assertFalse((String)"3.2", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        project.delete(9, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"3.5", (boolean)project.exists());
        Assert.assertFalse((String)"3.6", (boolean)file.exists());
        Assert.assertFalse((String)"3.7", (boolean)otherFile.exists());
        Assert.assertTrue((String)"3.8", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"3.9", (boolean)fileStore.fetchInfo().exists());
        Assert.assertTrue((String)"3.10", (boolean)otherFileStore.fetchInfo().exists());
        projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace((IResource)file);
        ResourceTestUtil.createInFileSystem((IResource)otherFile);
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"4.0", (boolean)project.exists());
        Assert.assertTrue((String)"4.1", (boolean)file.exists());
        Assert.assertFalse((String)"4.2", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        project.delete(8, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"4.5", (boolean)project.exists());
        Assert.assertFalse((String)"4.6", (boolean)file.exists());
        Assert.assertFalse((String)"4.7", (boolean)otherFile.exists());
        Assert.assertTrue((String)"4.8", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"4.9", (boolean)fileStore.fetchInfo().exists());
        Assert.assertTrue((String)"4.10", (boolean)otherFileStore.fetchInfo().exists());
        projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file});
        ResourceTestUtil.createInFileSystem((IResource)otherFile);
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"5.0", (boolean)project.exists());
        Assert.assertTrue((String)"5.1", (boolean)file.exists());
        Assert.assertFalse((String)"5.2", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        project.delete(1, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"5.5", (boolean)project.exists());
        Assert.assertFalse((String)"5.6", (boolean)file.exists());
        Assert.assertFalse((String)"5.7", (boolean)otherFile.exists());
        Assert.assertTrue((String)"5.8", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"5.9", (boolean)fileStore.fetchInfo().exists());
        Assert.assertTrue((String)"5.10", (boolean)otherFileStore.fetchInfo().exists());
        projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace((IResource)file);
        ResourceTestUtil.waitForRefresh();
        ResourceTestUtil.createInFileSystem((IResource)otherFile);
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"6.0", (boolean)project.exists());
        Assert.assertTrue((String)"6.1", (boolean)file.exists());
        Assert.assertFalse((String)"6.2", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        project.delete(0, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"6.5", (boolean)project.exists());
        Assert.assertFalse((String)"6.6", (boolean)file.exists());
        Assert.assertFalse((String)"6.7", (boolean)otherFile.exists());
        Assert.assertTrue((String)"6.8", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"6.9", (boolean)fileStore.fetchInfo().exists());
        Assert.assertTrue((String)"6.10", (boolean)otherFileStore.fetchInfo().exists());
        projectStore.delete(0, null);
    }

    @Test
    public void testProjectDeletionOpenDefaultInSync() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("myfile.txt");
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file});
        IFileStore projectStore = ((Resource)project).getStore();
        IFileStore fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"1.0", (boolean)project.exists());
        Assert.assertTrue((String)"1.1", (boolean)file.exists());
        int updateFlags = 1;
        project.delete(updateFlags |= 4, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"1.3", (boolean)project.exists());
        Assert.assertFalse((String)"1.4", (boolean)file.exists());
        Assert.assertFalse((String)"1.5", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"1.6", (boolean)fileStore.fetchInfo().exists());
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file});
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"2.0", (boolean)project.exists());
        Assert.assertTrue((String)"2.1", (boolean)file.exists());
        this.monitor.prepare();
        project.delete(4, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"2.3", (boolean)project.exists());
        Assert.assertFalse((String)"2.4", (boolean)file.exists());
        Assert.assertFalse((String)"2.5", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"2.6", (boolean)fileStore.fetchInfo().exists());
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file});
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"3.0", (boolean)project.exists());
        Assert.assertTrue((String)"3.1", (boolean)file.exists());
        this.monitor.prepare();
        project.delete(9, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"3.3", (boolean)project.exists());
        Assert.assertFalse((String)"3.4", (boolean)file.exists());
        Assert.assertTrue((String)"3.5", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"3.6", (boolean)fileStore.fetchInfo().exists());
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file});
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"4.0", (boolean)project.exists());
        Assert.assertTrue((String)"4.1", (boolean)file.exists());
        this.monitor.prepare();
        project.delete(8, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"4.3", (boolean)project.exists());
        Assert.assertFalse((String)"4.4", (boolean)file.exists());
        Assert.assertTrue((String)"4.5", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"4.6", (boolean)fileStore.fetchInfo().exists());
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file});
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"5.0", (boolean)project.exists());
        Assert.assertTrue((String)"5.1", (boolean)file.exists());
        this.monitor.prepare();
        project.delete(1, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"5.3", (boolean)project.exists());
        Assert.assertFalse((String)"5.4", (boolean)file.exists());
        Assert.assertFalse((String)"5.5", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"5.6", (boolean)fileStore.fetchInfo().exists());
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file});
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"6.0", (boolean)project.exists());
        Assert.assertTrue((String)"6.1", (boolean)file.exists());
        this.monitor.prepare();
        project.delete(0, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"6.3", (boolean)project.exists());
        Assert.assertFalse((String)"6.4", (boolean)file.exists());
        Assert.assertFalse((String)"6.5", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"6.6", (boolean)fileStore.fetchInfo().exists());
    }

    @Test
    public void testProjectDeletionOpenDefaultOutOfSync() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("myfile.txt");
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.createInFileSystem((IResource)file);
        IFileStore projectStore = ((Resource)project).getStore();
        IFileStore fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"1.0", (boolean)project.exists());
        Assert.assertFalse((String)"1.1", (boolean)file.exists());
        int updateFlags = 1;
        this.monitor.prepare();
        project.delete(updateFlags |= 4, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"1.3", (boolean)project.exists());
        Assert.assertFalse((String)"1.4", (boolean)file.exists());
        Assert.assertFalse((String)"1.5", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"1.6", (boolean)fileStore.fetchInfo().exists());
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.createInFileSystem((IResource)file);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"2.0", (boolean)project.exists());
        Assert.assertFalse((String)"2.1", (boolean)file.exists());
        this.monitor.prepare();
        project.delete(4, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"2.3", (boolean)project.exists());
        Assert.assertFalse((String)"2.4", (boolean)file.exists());
        Assert.assertFalse((String)"2.5", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"2.6", (boolean)fileStore.fetchInfo().exists());
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.createInFileSystem((IResource)file);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"3.0", (boolean)project.exists());
        Assert.assertFalse((String)"3.1", (boolean)file.exists());
        this.monitor.prepare();
        project.delete(9, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"3.3", (boolean)project.exists());
        Assert.assertFalse((String)"3.4", (boolean)file.exists());
        Assert.assertTrue((String)"3.5", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"3.6", (boolean)fileStore.fetchInfo().exists());
        projectStore.delete(0, null);
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.createInFileSystem((IResource)file);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"4.0", (boolean)project.exists());
        Assert.assertFalse((String)"4.1", (boolean)file.exists());
        this.monitor.prepare();
        project.delete(8, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"4.3", (boolean)project.exists());
        Assert.assertFalse((String)"4.4", (boolean)file.exists());
        Assert.assertTrue((String)"4.5", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"4.6", (boolean)fileStore.fetchInfo().exists());
        projectStore.delete(0, null);
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.createInFileSystem((IResource)file);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"5.0", (boolean)project.exists());
        Assert.assertFalse((String)"5.1", (boolean)file.exists());
        this.monitor.prepare();
        project.delete(1, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"5.3", (boolean)project.exists());
        Assert.assertFalse((String)"5.4", (boolean)file.exists());
        Assert.assertFalse((String)"5.5", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"5.6", (boolean)fileStore.fetchInfo().exists());
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.waitForRefresh();
        ResourceTestUtil.createInFileSystem((IResource)file);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"6.0", (boolean)project.exists());
        Assert.assertFalse((String)"6.1", (boolean)file.exists());
        Assert.assertThrows(CoreException.class, () -> {
            this.monitor.prepare();
            project.delete(0, (IProgressMonitor)this.monitor);
            this.monitor.assertUsedUp();
        });
        Assert.assertTrue((String)"6.3", (boolean)project.exists());
        Assert.assertFalse((String)"6.4", (boolean)file.exists());
        Assert.assertTrue((String)"6.5", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"6.6", (boolean)fileStore.fetchInfo().exists());
    }

    @Test
    public void testProjectDeletionOpenUserDefinedInSync() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("myfile.txt");
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        IFileStore projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace((IResource)file);
        IFileStore fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"1.2", (boolean)project.exists());
        Assert.assertTrue((String)"1.3", (boolean)file.exists());
        int updateFlags = 1;
        this.monitor.prepare();
        project.delete(updateFlags |= 4, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"1.5", (boolean)project.exists());
        Assert.assertFalse((String)"1.6", (boolean)file.exists());
        Assert.assertFalse((String)"1.7", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"1.8", (boolean)fileStore.fetchInfo().exists());
        projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace((IResource)file);
        fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"2.2", (boolean)project.exists());
        Assert.assertTrue((String)"2.3", (boolean)file.exists());
        this.monitor.prepare();
        project.delete(4, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"2.5", (boolean)project.exists());
        Assert.assertFalse((String)"2.6", (boolean)file.exists());
        Assert.assertFalse((String)"2.7", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"2.8", (boolean)fileStore.fetchInfo().exists());
        projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace((IResource)file);
        fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"3.2", (boolean)project.exists());
        Assert.assertTrue((String)"3.3", (boolean)file.exists());
        this.monitor.prepare();
        project.delete(9, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"3.5", (boolean)project.exists());
        Assert.assertFalse((String)"3.6", (boolean)file.exists());
        Assert.assertTrue((String)"3.7", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"3.8", (boolean)fileStore.fetchInfo().exists());
        projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace((IResource)file);
        fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"4.2", (boolean)project.exists());
        Assert.assertTrue((String)"4.3", (boolean)file.exists());
        this.monitor.prepare();
        project.delete(8, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"4.5", (boolean)project.exists());
        Assert.assertFalse((String)"4.6", (boolean)file.exists());
        Assert.assertTrue((String)"4.7", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"4.8", (boolean)fileStore.fetchInfo().exists());
        projectStore.delete(0, null);
        projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file});
        fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"5.2", (boolean)project.exists());
        Assert.assertTrue((String)"5.3", (boolean)file.exists());
        this.monitor.prepare();
        project.delete(1, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"5.5", (boolean)project.exists());
        Assert.assertFalse((String)"5.6", (boolean)file.exists());
        Assert.assertFalse((String)"5.7", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"5.8", (boolean)fileStore.fetchInfo().exists());
        projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace((IResource)file);
        fileStore = ((Resource)file).getStore();
        Assert.assertTrue((String)"6.2", (boolean)project.exists());
        Assert.assertTrue((String)"6.3", (boolean)file.exists());
        this.monitor.prepare();
        project.delete(0, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"6.5", (boolean)project.exists());
        Assert.assertFalse((String)"6.6", (boolean)file.exists());
        Assert.assertFalse((String)"6.7", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"6.8", (boolean)fileStore.fetchInfo().exists());
    }

    @Test
    public void testProjectDeletionOpenUserDefinedOutOfSync() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("testProjectDeletionOpenUserDefinedOutOfSync");
        IFile file = project.getFile("myfile.txt");
        IFile otherFile = project.getFile("myotherfile.txt");
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        IFileStore projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace((IResource)file);
        ResourceTestUtil.createInFileSystem((IResource)otherFile);
        IFileStore fileStore = ((Resource)file).getStore();
        IFileStore otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"1.0", (boolean)project.exists());
        Assert.assertTrue((String)"1.1", (boolean)file.exists());
        Assert.assertFalse((String)"1.2", (boolean)otherFile.exists());
        int updateFlags = 1;
        this.monitor.prepare();
        project.delete(updateFlags |= 4, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"1.4", (boolean)project.exists());
        Assert.assertFalse((String)"1.5", (boolean)file.exists());
        Assert.assertFalse((String)"1.6", (boolean)otherFile.exists());
        Assert.assertFalse((String)"1.7", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"1.8", (boolean)fileStore.fetchInfo().exists());
        Assert.assertFalse((String)"1.9", (boolean)otherFileStore.fetchInfo().exists());
        projectStore.delete(0, null);
        projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace((IResource)file);
        ResourceTestUtil.createInFileSystem((IResource)otherFile);
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"2.0", (boolean)project.exists());
        Assert.assertTrue((String)"2.1", (boolean)file.exists());
        Assert.assertFalse((String)"2.2", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.delete(4, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"2.4", (boolean)project.exists());
        Assert.assertFalse((String)"2.5", (boolean)file.exists());
        Assert.assertFalse((String)"2.6", (boolean)otherFile.exists());
        Assert.assertFalse((String)"2.7", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"2.8", (boolean)fileStore.fetchInfo().exists());
        Assert.assertFalse((String)"2.9", (boolean)otherFileStore.fetchInfo().exists());
        projectStore.delete(0, null);
        projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace((IResource)file);
        ResourceTestUtil.createInFileSystem((IResource)otherFile);
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"3.0", (boolean)project.exists());
        Assert.assertTrue((String)"3.1", (boolean)file.exists());
        Assert.assertFalse((String)"3.2", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.delete(9, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"3.4", (boolean)project.exists());
        Assert.assertFalse((String)"3.5", (boolean)file.exists());
        Assert.assertFalse((String)"3.6", (boolean)otherFile.exists());
        Assert.assertTrue((String)"3.7", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"3.8", (boolean)fileStore.fetchInfo().exists());
        Assert.assertTrue((String)"3.9", (boolean)otherFileStore.fetchInfo().exists());
        projectStore.delete(0, null);
        projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace((IResource)file);
        ResourceTestUtil.createInFileSystem((IResource)otherFile);
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"4.0", (boolean)project.exists());
        Assert.assertTrue((String)"4.1", (boolean)file.exists());
        Assert.assertFalse((String)"4.2", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.delete(8, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"4.4", (boolean)project.exists());
        Assert.assertFalse((String)"4.5", (boolean)file.exists());
        Assert.assertFalse((String)"4.6", (boolean)otherFile.exists());
        Assert.assertTrue((String)"4.7", (boolean)projectStore.fetchInfo().exists());
        Assert.assertTrue((String)"4.8", (boolean)fileStore.fetchInfo().exists());
        Assert.assertTrue((String)"4.9", (boolean)otherFileStore.fetchInfo().exists());
        projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file});
        ResourceTestUtil.createInFileSystem((IResource)otherFile);
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"5.0", (boolean)project.exists());
        Assert.assertTrue((String)"5.1", (boolean)file.exists());
        Assert.assertFalse((String)"5.2", (boolean)otherFile.exists());
        this.monitor.prepare();
        project.delete(1, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"5.4", (boolean)project.exists());
        Assert.assertFalse((String)"5.5", (boolean)file.exists());
        Assert.assertFalse((String)"5.6", (boolean)otherFile.exists());
        Assert.assertFalse((String)"5.7", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"5.8", (boolean)fileStore.fetchInfo().exists());
        Assert.assertFalse((String)"5.9", (boolean)otherFileStore.fetchInfo().exists());
        projectStore = this.workspaceRule.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        ResourceTestUtil.createInWorkspace((IResource)file);
        ResourceTestUtil.waitForRefresh();
        ResourceTestUtil.createInFileSystem((IResource)otherFile);
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        Assert.assertTrue((String)"6.0", (boolean)project.exists());
        Assert.assertTrue((String)"6.1", (boolean)file.exists());
        Assert.assertFalse((String)"6.2", (boolean)otherFile.exists());
        Assert.assertThrows(CoreException.class, () -> {
            this.monitor.prepare();
            project.delete(0, (IProgressMonitor)this.monitor);
            this.monitor.assertUsedUp();
        });
        Assert.assertTrue((String)"6.4", (boolean)project.exists());
        Assert.assertFalse((String)"6.5", (boolean)file.exists());
        Assert.assertFalse((String)"6.6", (boolean)otherFile.exists());
        Assert.assertTrue((String)"6.7", (boolean)projectStore.fetchInfo().exists());
        Assert.assertFalse((String)"6.8", (boolean)fileStore.fetchInfo().exists());
        Assert.assertTrue((String)"6.9", (boolean)otherFileStore.fetchInfo().exists());
    }

    @Test
    public void testProjectDescriptionDynamic() {
        IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription("foo");
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject("P1");
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject("P2");
        Assertions.assertThat((Object[])desc.getDynamicReferences()).isEmpty();
        IProject[] refs = new IProject[]{project1, project2};
        desc.setDynamicReferences(refs);
        Object[] result = desc.getDynamicReferences();
        Assertions.assertThat((Object[])result).containsExactly((Object[])new IProject[]{project1, project2});
        result[0] = null;
        result[1] = null;
        result = desc.getDynamicReferences();
        Assertions.assertThat((Object[])result).containsExactly((Object[])new IProject[]{project1, project2});
        refs = new IProject[]{project1, project2, project2, project1, project1};
        desc.setDynamicReferences(refs);
        result = desc.getDynamicReferences();
        Assertions.assertThat((Object[])result).containsExactly((Object[])new IProject[]{project1, project2});
    }

    @Test
    public void testProjectDescriptionReferences() {
        IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription("foo");
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject("P1");
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject("P2");
        Assert.assertEquals((String)"1.0", (Object)"foo", (Object)desc.getName());
        Assertions.assertThat((Object[])desc.getReferencedProjects()).isEmpty();
        IProject[] refs = new IProject[]{project1, project2};
        desc.setReferencedProjects(refs);
        Object[] result = desc.getReferencedProjects();
        Assertions.assertThat((Object[])result).containsExactly((Object[])new IProject[]{project1, project2});
        result[0] = null;
        result[1] = null;
        result = desc.getReferencedProjects();
        Assertions.assertThat((Object[])result).containsExactly((Object[])new IProject[]{project1, project2});
        refs = new IProject[]{project1, project2, project2, project1, project1};
        desc.setReferencedProjects(refs);
        result = desc.getReferencedProjects();
        Assertions.assertThat((Object[])result).containsExactly((Object[])new IProject[]{project1, project2});
    }

    @Test
    public void testProjectLocationValidation() throws CoreException {
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject("Project1");
        IPath root = ResourcesPlugin.getWorkspace().getRoot().getLocation().removeLastSegments(1).append("temp");
        IPath path = root.append("foo");
        Assert.assertTrue((String)"1.0", (boolean)ResourcesPlugin.getWorkspace().validateProjectLocation(project1, path).isOK());
        path = Platform.getLocation().append("Project2");
        Assert.assertFalse((String)"1.1", (boolean)ResourcesPlugin.getWorkspace().validateProjectLocation(project1, path).isOK());
        path = Platform.getLocation().append(project1.getName());
        Assert.assertTrue((String)"1.2", (boolean)ResourcesPlugin.getWorkspace().validateProjectLocation(project1, path).isOK());
        project1.create((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription("Project2");
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject("Project2");
        path = root.append("project2");
        Assert.assertTrue((String)"2.0", (boolean)ResourcesPlugin.getWorkspace().validateProjectLocation(project2, path).isOK());
        desc.setLocation(path);
        this.monitor.prepare();
        project2.create(desc, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        IProject project3 = ResourcesPlugin.getWorkspace().getRoot().getProject("Project3");
        this.monitor.prepare();
        project3.create((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        path = root.append("project3");
        Assert.assertTrue((String)"3.1", (boolean)ResourcesPlugin.getWorkspace().validateProjectLocation(project3, path).isOK());
        Assert.assertTrue((String)"4.0", (boolean)ResourcesPlugin.getWorkspace().validateProjectLocation(project3, root).isOK());
        Assert.assertFalse((String)"4.1", (boolean)ResourcesPlugin.getWorkspace().validateProjectLocation(project3, root.append("project2")).isOK());
        Assert.assertTrue((String)"4.2", (boolean)ResourcesPlugin.getWorkspace().validateProjectLocation(project3, root.append("project2/foo")).isOK());
        Assert.assertTrue((String)"4.3", (boolean)ResourcesPlugin.getWorkspace().validateProjectLocation(project3, null).isOK());
        Assert.assertTrue((String)"4.4", (boolean)ResourcesPlugin.getWorkspace().validateProjectLocation(project3, root.append("%20foo")).isOK());
        Assert.assertTrue((String)"5.0", (boolean)ResourcesPlugin.getWorkspace().validateProjectLocation(null, root).isOK());
        Assert.assertFalse((String)"5.1", (boolean)ResourcesPlugin.getWorkspace().validateProjectLocation(null, root.append("project2")).isOK());
        Assert.assertTrue((String)"5.2", (boolean)ResourcesPlugin.getWorkspace().validateProjectLocation(null, root.append("project2/foo")).isOK());
        Assert.assertTrue((String)"5.3", (boolean)ResourcesPlugin.getWorkspace().validateProjectLocation(null, root.append("%20foo")).isOK());
        this.monitor.prepare();
        project1.delete(true, true, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        project2.delete(true, true, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        project3.delete(true, true, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
    }

    @Test
    public void testProjectLocationWithEscapes() throws CoreException {
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject("Project1");
        IPath root = ResourcesPlugin.getWorkspace().getRoot().getLocation().removeLastSegments(1).append("temp");
        IPath location = root.append("%20foo bar");
        IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription(project1.getName());
        desc.setLocation(location);
        project1.create(desc, (IProgressMonitor)this.monitor);
        this.workspaceRule.deleteOnTearDown(location);
        this.monitor.assertUsedUp();
        project1.open(null);
        Assert.assertTrue((String)"1.0", (boolean)project1.exists());
        Assert.assertTrue((String)"1.1", (boolean)project1.isAccessible());
        Assert.assertEquals((String)"1.2", (Object)location, (Object)project1.getLocation());
        Assert.assertEquals((String)"1.3", (Object)location, (Object)project1.getRawLocation());
        this.monitor.prepare();
        project1.delete(1, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
    }

    @Test
    public void testProjectMoveContent() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        String[] children = new String[]{"/1/", "/1/2"};
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, children);
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.createInWorkspace(resources);
        IProjectDescription destination = project.getDescription();
        IPath oldPath = project.getLocation();
        IPath newPath = FileSystemHelper.getTempDir().append(Long.toString(System.currentTimeMillis()));
        this.workspaceRule.deleteOnTearDown(newPath);
        destination.setLocation(newPath);
        this.monitor.prepare();
        project.move(destination, false, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        newPath = project.getLocation();
        Assert.assertFalse((String)"2.0", (boolean)oldPath.equals((Object)newPath));
        IResourceVisitor visitor = resource -> {
            ResourceTestUtil.assertExistsInWorkspace(resource);
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
    }

    @Test
    public void testProjectMoveVariations() throws CoreException {
        IProject project;
        Object[] markers = null;
        String actual = null;
        QualifiedName qname = new QualifiedName("com.example", "myProperty");
        String value = "this is my property value.";
        IProject source = project = ResourcesPlugin.getWorkspace().getRoot().getProject("SourceProject");
        String[] children = new String[]{"/1/", "/1/2"};
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, children);
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.createInWorkspace(resources);
        IProject destination = ResourcesPlugin.getWorkspace().getRoot().getProject("DestProject");
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)destination);
        IResource sourceChild = resources[1];
        sourceChild.setPersistentProperty(qname, value);
        sourceChild.createMarker("org.eclipse.core.resources.problemmarker");
        this.monitor.prepare();
        source.move(destination.getFullPath(), false, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)project);
        ResourceTestUtil.assertDoesNotExistInWorkspace(resources);
        resources = ResourceTestUtil.buildResources((IContainer)destination, children);
        ResourceTestUtil.assertExistsInWorkspace((IResource)destination);
        ResourceTestUtil.assertExistsInWorkspace(resources);
        IResource destChild = resources[1];
        actual = destChild.getPersistentProperty(qname);
        Assert.assertNotNull((String)"1.7", (Object)actual);
        Assert.assertEquals((String)"1.8", (Object)value, (Object)actual);
        markers = destChild.findMarkers(null, true, 0);
        Assertions.assertThat((Object[])markers).hasSize(1);
        this.monitor.prepare();
        ResourcesPlugin.getWorkspace().getRoot().delete(false, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        source = project = ResourcesPlugin.getWorkspace().getRoot().getProject("SourceProject");
        children = new String[]{"/1/", "/1/2"};
        resources = ResourceTestUtil.buildResources((IContainer)project, children);
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.createInWorkspace(resources);
        sourceChild = resources[1];
        sourceChild.setPersistentProperty(qname, value);
        sourceChild.createMarker("org.eclipse.core.resources.problemmarker");
        destination = ResourcesPlugin.getWorkspace().getRoot().getProject("DestProject");
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(destination.getName());
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)destination);
        this.monitor.prepare();
        source.move(description, false, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)project);
        ResourceTestUtil.assertDoesNotExistInWorkspace(resources);
        resources = ResourceTestUtil.buildResources((IContainer)destination, children);
        ResourceTestUtil.assertExistsInWorkspace((IResource)destination);
        ResourceTestUtil.assertExistsInWorkspace(resources);
        destChild = resources[1];
        actual = destChild.getPersistentProperty(qname);
        Assert.assertNotNull((String)"2.10", (Object)actual);
        Assert.assertEquals((String)"2.11", (Object)value, (Object)actual);
        markers = destChild.findMarkers(null, true, 0);
        Assertions.assertThat((Object[])markers).hasSize(1);
        this.monitor.prepare();
        ResourcesPlugin.getWorkspace().getRoot().delete(false, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        IProject destProject = ResourcesPlugin.getWorkspace().getRoot().getProject("DestProject");
        Assert.assertThrows(CoreException.class, () -> {
            IProject source1 = ResourcesPlugin.getWorkspace().getRoot().getProject("SourceProject");
            IFolder destination1 = destProject.getFolder("MyFolder");
            this.monitor.prepare();
            source1.move(destination1.getFullPath(), true, (IProgressMonitor)this.monitor);
            this.monitor.assertUsedUp();
        });
        Assert.assertThrows(CoreException.class, () -> {
            IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject("MySourceProject");
            String[] children1 = new String[]{"/1/", "/1/2"};
            ResourceTestUtil.buildResources((IContainer)project1, children1);
            IFolder source1 = project1.getFolder("1");
            IProject destination1 = ResourcesPlugin.getWorkspace().getRoot().getProject("MyDestProject");
            this.monitor.prepare();
            source1.move(destination1.getFullPath(), true, (IProgressMonitor)this.monitor);
            this.monitor.assertUsedUp();
        });
    }

    @Test
    public void testProjectMoveVariations_bug307140() throws CoreException {
        IProject originalProject = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        originalProject.create((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        originalProject.open((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        IPath originalLocation = originalProject.getLocation();
        IFolder originalProjectSubFolder = originalProject.getFolder(ResourceTestUtil.createUniqueString());
        Assert.assertThrows(CoreException.class, () -> {
            IProjectDescription originalDescription = originalProject.getDescription();
            originalDescription.setLocation(originalProjectSubFolder.getLocation());
            this.monitor.prepare();
            originalProject.move(originalDescription, true, (IProgressMonitor)this.monitor);
            this.monitor.assertUsedUp();
        });
        Assert.assertEquals((String)"3.0", (Object)originalLocation, (Object)originalProject.getLocation());
        this.monitor.prepare();
        ResourcesPlugin.getWorkspace().getRoot().delete(false, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        IProject destinationProject = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        IProjectDescription newDescription = ResourcesPlugin.getWorkspace().newProjectDescription(destinationProject.getName());
        newDescription.setLocation(FileSystemHelper.getRandomLocation());
        this.monitor.prepare();
        destinationProject.create(newDescription, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        destinationProject.open((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        IPath destinationLocation = destinationProject.getLocation();
        IFolder destinationProjectSubFolder = destinationProject.getFolder(ResourceTestUtil.createUniqueString());
        Assert.assertThrows(CoreException.class, () -> {
            IProjectDescription destinationDescription = destinationProject.getDescription();
            destinationDescription.setLocation(destinationProjectSubFolder.getLocation());
            this.monitor.prepare();
            destinationProject.move(destinationDescription, true, (IProgressMonitor)this.monitor);
            this.monitor.assertUsedUp();
        });
        Assert.assertEquals((String)"7.0", (Object)destinationLocation, (Object)destinationProject.getLocation());
    }

    @Test
    public void testRenameExternalProject() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("SourceProject");
        String[] children = new String[]{"/1/", "/1/2"};
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, children);
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        description.setLocationURI(this.workspaceRule.getTempStore().toURI());
        this.monitor.prepare();
        project.create(description, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        project.open((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.createInWorkspace(resources);
        IResource sourceChild = resources[1];
        QualifiedName qname = new QualifiedName("com.example", "myProperty");
        String propertyValue = "this is my property value.";
        String actualPropertyValue = null;
        sourceChild.setPersistentProperty(qname, propertyValue);
        sourceChild.createMarker("org.eclipse.core.resources.problemmarker");
        IProject destination = ResourcesPlugin.getWorkspace().getRoot().getProject("DestProject");
        description.setName(destination.getName());
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)destination);
        this.monitor.prepare();
        project.move(description, false, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)project);
        ResourceTestUtil.assertDoesNotExistInWorkspace(resources);
        resources = ResourceTestUtil.buildResources((IContainer)destination, children);
        ResourceTestUtil.assertExistsInWorkspace((IResource)destination);
        ResourceTestUtil.assertExistsInWorkspace(resources);
        IResource destChild = resources[1];
        actualPropertyValue = destChild.getPersistentProperty(qname);
        Assert.assertNotNull((String)"2.10", (Object)actualPropertyValue);
        Assert.assertEquals((String)"2.11", (Object)propertyValue, (Object)actualPropertyValue);
        Object[] markers = destChild.findMarkers(null, true, 0);
        Assertions.assertThat((Object[])markers).hasSize(1);
        this.monitor.prepare();
        ResourcesPlugin.getWorkspace().getRoot().delete(false, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
    }

    @Test
    public void testReplaceLocation() throws Exception {
        IProject target = ResourcesPlugin.getWorkspace().getRoot().getProject("testReplaceLocation");
        ResourceTestUtil.createInWorkspace((IResource)target);
        IFileStore projectStore = this.workspaceRule.getTempStore();
        IFileStore childFile = projectStore.getChild("File.txt");
        IFolder folder = target.getFolder("Folder");
        IFile file = folder.getFile("File.txt");
        ResourceTestUtil.createInWorkspace((IResource)file);
        IFile newFile = target.getFile(childFile.getName());
        ResourceTestUtil.createInFileSystem(childFile);
        IProjectDescription description = target.getDescription();
        description.setLocationURI(projectStore.toURI());
        this.monitor.prepare();
        target.move(description, 256, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"2.0", (boolean)folder.exists());
        Assert.assertFalse((String)"2.1", (boolean)file.exists());
        Assert.assertTrue((String)"2.2", (boolean)newFile.exists());
        description = target.getDescription();
        description.setLocationURI(null);
        this.monitor.prepare();
        target.move(description, 256, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertTrue((String)"3.0", (boolean)folder.exists());
        Assert.assertTrue((String)"3.1", (boolean)file.exists());
        Assert.assertFalse((String)"3.2", (boolean)newFile.exists());
    }

    @Test
    public void testSetGetProjectPersistentProperty() throws CoreException {
        IProject target = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)target);
        this.setGetPersistentProperty((IResource)target);
    }

    @Test
    public void testWorkspaceNotificationClose() throws CoreException {
        int[] count = new int[1];
        IResourceChangeListener listener = event -> {
            Assert.assertEquals((String)"1.0", (long)2L, (long)event.getType());
            nArray[0] = count[0] + 1;
            Assert.assertEquals((String)"1.1", (long)4L, (long)event.getResource().getType());
            Assert.assertTrue((String)"1.2", (boolean)event.getResource().exists());
            Assert.assertTrue((String)"1.3", (boolean)((IProject)event.getResource()).isOpen());
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(listener, 2);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        this.monitor.prepare();
        project.create((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        project.open((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertTrue((String)"1.5", (boolean)project.exists());
        Assert.assertTrue((String)"1.6", (boolean)project.isOpen());
        this.monitor.prepare();
        project.close((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertEquals((String)"1.8", (long)1L, (long)count[0]);
        Assert.assertTrue((String)"1.9", (boolean)project.exists());
        Assert.assertFalse((String)"1.10", (boolean)project.isOpen());
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
    }

    @Test
    public void testWorkspaceNotificationDelete() throws CoreException {
        int[] count = new int[1];
        IResourceChangeListener listener = event -> {
            Assert.assertEquals((String)"1.0", (long)4L, (long)event.getType());
            nArray[0] = count[0] + 1;
            Assert.assertEquals((String)"1.1", (long)4L, (long)event.getResource().getType());
            Assert.assertTrue((String)"1.2", (boolean)event.getResource().exists());
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(listener, 4);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        this.monitor.prepare();
        project.create((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        project.open((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertTrue((String)"1.4", (boolean)project.exists());
        this.monitor.prepare();
        project.delete(1, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertEquals((String)"1.6", (long)1L, (long)count[0]);
        Assert.assertFalse((String)"1.7", (boolean)project.exists());
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
    }

    @Test
    public void testWorkspaceNotificationMove() throws CoreException {
        int[] count = new int[1];
        IResourceChangeListener listener = event -> {
            Assert.assertEquals((String)"1.0", (long)4L, (long)event.getType());
            nArray[0] = count[0] + 1;
            Assert.assertEquals((String)"1.1", (long)4L, (long)event.getResource().getType());
            Assert.assertTrue((String)"1.2", (boolean)event.getResource().exists());
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(listener, 4);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        this.monitor.prepare();
        project.create((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        project.open((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertTrue((String)"1.4", (boolean)project.exists());
        this.monitor.prepare();
        project.move(IPath.fromOSString((String)"MyNewProject"), 1, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertEquals((String)"1.6", (long)1L, (long)count[0]);
        Assert.assertFalse((String)"1.7", (boolean)project.exists());
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
    }

    @Test
    public void testCreateHiddenProject() throws CoreException {
        IProject hiddenProject = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.removeFromWorkspace((IResource)hiddenProject);
        this.monitor.prepare();
        hiddenProject.create(null, 4096, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertTrue((String)"2.0", (boolean)hiddenProject.isHidden());
        this.monitor.prepare();
        hiddenProject.delete(false, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        hiddenProject.create((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        Assert.assertFalse((String)"4.0", (boolean)hiddenProject.isHidden());
    }

    @Test
    public void testProjectDeletion_Bug347220() throws CoreException {
        String projectName = ResourceTestUtil.createUniqueString();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IFolder folder = project.getFolder(ResourceTestUtil.createUniqueString());
        IFile file = folder.getFile(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace(new IResource[]{project, folder, file});
        project.open((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        file.setContents(ResourceTestUtil.createRandomString().getBytes(), true, true, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        this.monitor.prepare();
        project.delete(true, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        IPath p = ((Workspace)ResourcesPlugin.getWorkspace()).getMetaArea().locationFor((IResource)project);
        Assert.assertFalse((String)"1.0", (boolean)p.toFile().exists());
        IProject otherProject = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)otherProject);
        this.monitor.prepare();
        otherProject.open((IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
        IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        this.monitor.prepare();
        otherProject.move(desc, true, (IProgressMonitor)this.monitor);
        this.monitor.assertUsedUp();
    }

    private /* synthetic */ void lambda$15(IResource iResource, IResource iResource2) throws Throwable {
        iResource.copy(iResource2.getFullPath(), true, (IProgressMonitor)this.monitor);
    }

    private /* synthetic */ void lambda$16(IResource iResource, IResource iResource2) throws Throwable {
        iResource.copy(iResource2.getFullPath(), true, (IProgressMonitor)this.monitor);
    }
}

