/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.util.Map;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class IResourceChangeEventTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    protected IProject project1;
    protected IProject project2;
    protected IFolder folder1;
    protected IFolder folder2;
    protected IFolder folder3;
    protected IFile file1;
    protected IFile file2;
    protected IFile file3;
    protected IMarker marker1;
    protected IMarker marker2;
    protected IMarker marker3;
    protected IResource[] allResources;

    @Before
    public void setUp() throws Exception {
        this.project1 = ResourcesPlugin.getWorkspace().getRoot().getProject("Project1");
        this.project2 = ResourcesPlugin.getWorkspace().getRoot().getProject("Project2");
        this.folder1 = this.project1.getFolder("Folder1");
        this.folder2 = this.folder1.getFolder("Folder2");
        this.folder3 = this.folder1.getFolder("Folder3");
        this.file1 = this.folder1.getFile("File1");
        this.file2 = this.folder1.getFile("File2");
        this.file3 = this.folder2.getFile("File3");
        this.allResources = new IResource[]{this.project1, this.project2, this.folder1, this.folder2, this.folder3, this.file1, this.file2, this.file3};
        IWorkspaceRunnable body = monitor -> {
            ResourceTestUtil.createInWorkspace(this.allResources);
            this.marker2 = this.file2.createMarker("org.eclipse.core.resources.bookmark");
            this.marker3 = this.file3.createMarker("org.eclipse.core.resources.bookmark");
        };
        ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testFindMarkerDeltas() throws CoreException {
        IResourceChangeListener listener = event -> {
            Object[] deltas = event.findMarkerDeltas("org.eclipse.core.resources.bookmark", false);
            this.verifyDeltas((IMarkerDelta[])deltas);
            deltas = event.findMarkerDeltas("org.eclipse.core.resources.bookmark", true);
            this.verifyDeltas((IMarkerDelta[])deltas);
            deltas = event.findMarkerDeltas("org.eclipse.core.resources.marker", false);
            Assertions.assertThat((Object[])deltas).isEmpty();
            deltas = event.findMarkerDeltas("org.eclipse.core.resources.marker", true);
            this.verifyDeltas((IMarkerDelta[])deltas);
            deltas = event.findMarkerDeltas("org.eclipse.core.resources.problemmarker", true);
            Assertions.assertThat((Object[])deltas).isEmpty();
            deltas = event.findMarkerDeltas(null, true);
            this.verifyDeltas((IMarkerDelta[])deltas);
            deltas = event.findMarkerDeltas(null, false);
            this.verifyDeltas((IMarkerDelta[])deltas);
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(listener);
        IWorkspaceRunnable body = monitor -> {
            this.marker1 = this.file1.createMarker("org.eclipse.core.resources.bookmark");
            this.marker2.delete();
            this.marker3.setAttribute("Foo", true);
        };
        try {
            ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
        }
    }

    @Test
    public void testFindMarkerDeltasInEmptyDelta() throws CoreException {
        IResourceChangeListener listener = event -> {
            Assertions.assertThat((Object[])event.findMarkerDeltas("org.eclipse.core.resources.bookmark", false)).isEmpty();
            Assertions.assertThat((Object[])event.findMarkerDeltas("org.eclipse.core.resources.bookmark", true)).isEmpty();
            Assertions.assertThat((Object[])event.findMarkerDeltas("org.eclipse.core.resources.marker", false)).isEmpty();
            Assertions.assertThat((Object[])event.findMarkerDeltas("org.eclipse.core.resources.marker", true)).isEmpty();
            Assertions.assertThat((Object[])event.findMarkerDeltas("org.eclipse.core.resources.problemmarker", true)).isEmpty();
            Assertions.assertThat((Object[])event.findMarkerDeltas(null, true)).isEmpty();
            Assertions.assertThat((Object[])event.findMarkerDeltas(null, false)).isEmpty();
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(listener);
        try {
            this.file1.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
        }
    }

    protected void verifyDeltas(IMarkerDelta[] deltas) {
        Map<Long, Integer> deltaIdToKind = Map.of(this.marker1.getId(), 1, this.marker2.getId(), 2, this.marker3.getId(), 4);
        ((ObjectArrayAssert)((ObjectArrayAssert)((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])deltas).hasSize(3)).allSatisfy(delta -> {
            ((AbstractStringAssert)Assertions.assertThat((String)delta.getType()).as("type", new Object[0])).isEqualTo("org.eclipse.core.resources.bookmark");
            ((AbstractIntegerAssert)((AbstractIntegerAssert)Assertions.assertThat((int)delta.getKind()).as("kind", new Object[0])).isNotNull()).isEqualTo(deltaIdToKind.get(delta.getId()));
        })).anySatisfy(delta -> {
            AbstractIntegerAssert abstractIntegerAssert = Assertions.assertThat((int)delta.getKind()).isEqualTo(1);
        })).anySatisfy(delta -> {
            AbstractIntegerAssert abstractIntegerAssert = Assertions.assertThat((int)delta.getKind()).isEqualTo(2);
        })).anySatisfy(delta -> {
            AbstractIntegerAssert abstractIntegerAssert = Assertions.assertThat((int)delta.getKind()).isEqualTo(4);
        });
    }
}

