/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;

public class IResourceChangeListenerTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private static final ThrowingRunnable NOOP_RUNNABLE = () -> {};
    protected static final String VERIFIER_NAME = "TestListener";
    IFile file1;
    IFile file2;
    IFile file3;
    IFolder folder1;
    IFolder folder2;
    IFolder folder3;
    IFolder settings;
    IProject project1;
    IFile project1MetaData;
    IFile prefs;
    IProject project2;
    IFile project2MetaData;
    ResourceDeltaVerifier verifier;

    @Test
    public void testBenchMark_1GBYQEZ() throws Throwable {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.verifier);
        ResourcesPlugin.getWorkspace().getRoot().delete(false, ResourceTestUtil.createTestMonitor());
        final AtomicReference exceptionInListener = new AtomicReference();
        IResourceChangeListener listener = new IResourceChangeListener(){
            private int fCounter;

            public void resourceChanged(IResourceChangeEvent event) {
                try {
                    System.out.println("Start");
                    int i = 0;
                    while (i < 10) {
                        this.fCounter = 0;
                        long start = System.currentTimeMillis();
                        IResourceDelta delta = event.getDelta();
                        delta.accept(delta2 -> {
                            ++this.fCounter;
                            return true;
                        });
                        long end = System.currentTimeMillis();
                        System.out.println("    Number of deltas: " + this.fCounter + ". Time needed: " + (end - start));
                        ++i;
                    }
                    System.out.println("End");
                }
                catch (CoreException e) {
                    exceptionInListener.set(e);
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(listener);
        IWorkspaceRunnable body = monitor -> {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Test");
            IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
            IPath root = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            IPath contents = root.append("temp/testing");
            this.workspaceRule.deleteOnTearDown(root.append("temp"));
            description.setLocation(contents);
            project.create(description, ResourceTestUtil.createTestMonitor());
            project.open(ResourceTestUtil.createTestMonitor());
            project.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        };
        ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
        body = monitor -> {
            IResourceVisitor visitor = resource -> {
                resource.touch(ResourceTestUtil.createTestMonitor());
                return true;
            };
            ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
        };
        ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
        if (exceptionInListener.get() != null) {
            throw (CoreException)((Object)exceptionInListener.get());
        }
    }

    public void assertDelta() {
        Assert.assertTrue((String)this.verifier.getMessage(), (boolean)this.verifier.isDeltaValid());
    }

    void assertNotDeltaIncludes(IResourceDelta delta, IResource[] resources) {
        IResourceDelta[] children;
        IResource deltaResource = delta.getResource();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            Assert.assertTrue((!deltaResource.equals((Object)resource) ? 1 : 0) != 0);
            ++n2;
        }
        IResourceDelta[] iResourceDeltaArray = children = delta.getAffectedChildren();
        int n3 = children.length;
        n = 0;
        while (n < n3) {
            IResourceDelta element = iResourceDeltaArray[n];
            this.assertNotDeltaIncludes(element, resources);
            ++n;
        }
    }

    void assertNotDeltaVisits(IResourceDelta delta, IResource[] resources) throws CoreException {
        delta.accept(delta2 -> {
            IResource deltaResource = delta2.getResource();
            IResource[] iResourceArray2 = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray2[n2];
                Assert.assertTrue((!deltaResource.equals((Object)resource) ? 1 : 0) != 0);
                ++n2;
            }
            return true;
        });
    }

    @Before
    public void setUp() throws Exception {
        this.project1 = ResourcesPlugin.getWorkspace().getRoot().getProject("Project1");
        this.project2 = ResourcesPlugin.getWorkspace().getRoot().getProject("Project2");
        this.folder1 = this.project1.getFolder("Folder1");
        this.folder2 = this.folder1.getFolder("Folder2");
        this.folder3 = this.folder1.getFolder("File1");
        this.settings = this.project1.getFolder(".settings");
        this.prefs = this.settings.getFile("org.eclipse.core.resources.prefs");
        this.file1 = this.folder1.getFile("File1");
        this.file2 = this.folder1.getFile("File2");
        this.file3 = this.folder2.getFile("File1");
        this.project1MetaData = this.project1.getFile(".project");
        this.project2MetaData = this.project2.getFile(".project");
        IWorkspaceRunnable body = monitor -> {
            this.project1.create(ResourceTestUtil.createTestMonitor());
            this.project1.open(ResourceTestUtil.createTestMonitor());
            this.folder1.create(true, true, ResourceTestUtil.createTestMonitor());
            this.file1.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        };
        this.verifier = new ResourceDeltaVerifier();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.verifier, 1);
        ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        ResourceTestUtil.waitForRefresh();
        this.verifier.reset();
    }

    @After
    public void tearDown() throws Exception {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.verifier);
    }

    @Test
    public void test_1GDK9OG() throws Throwable {
        AtomicReference<ThrowingRunnable> listenerInMainThreadCallback = new AtomicReference<ThrowingRunnable>(NOOP_RUNNABLE);
        IResourceChangeListener listener = event -> {
            try {
                IWorkspaceRunnable body = monitor -> {
                    IResourceDeltaVisitor visitor = delta -> {
                        IResource resource = delta.getResource();
                        resource.touch(ResourceTestUtil.createTestMonitor());
                        resource.createMarker("org.eclipse.core.resources.problemmarker");
                        return true;
                    };
                    event.getDelta().accept(visitor);
                };
                ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
            }
            catch (CoreException e) {
                listenerInMainThreadCallback.set(() -> {
                    throw e;
                });
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(listener, 16);
        try {
            IWorkspaceRunnable body = new IWorkspaceRunnable(){
                final IResourceVisitor visitor = resource -> {
                    resource.touch(ResourceTestUtil.createTestMonitor());
                    return true;
                };

                public void run(IProgressMonitor monitor) throws CoreException {
                    ResourcesPlugin.getWorkspace().getRoot().accept(this.visitor);
                }
            };
            ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
            try {
                Job.getJobManager().wakeUp(ResourcesPlugin.FAMILY_AUTO_BUILD);
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            }
            catch (InterruptedException | OperationCanceledException throwable) {}
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
        }
        listenerInMainThreadCallback.get().run();
    }

    @Test
    public void testAddAndRemoveFile() throws CoreException {
        this.verifier.reset();
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("Creating and deleting", 100);
            try {
                this.file2.create(ResourceTestUtil.createRandomContentsStream(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                this.file2.delete(true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"Unexpected notification on no change", (!this.verifier.hasBeenNotified() ? 1 : 0) != 0);
    }

    @Test
    public void testAddAndRemoveFolder() throws CoreException {
        this.verifier.reset();
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("Creating and deleting", 100);
            try {
                this.folder2.create(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                this.folder2.delete(true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"Unexpected notification on no change", (!this.verifier.hasBeenNotified() ? 1 : 0) != 0);
    }

    @Test
    public void testAddFile() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.file2, 1, 0);
        this.file2.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testAddFileAndFolder() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.folder2, 1, 0);
        this.verifier.addExpectedChange((IResource)this.file3, 1, 0);
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("Creating folder and file", 100);
            try {
                this.folder2.create(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                this.file3.create(ResourceTestUtil.createRandomContentsStream(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testAddFolder() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.folder2, 1, 0);
        this.folder2.create(true, true, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testAddProject() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.project2, 1, 0);
        this.verifier.addExpectedChange((IResource)this.project2MetaData, 1, 0);
        this.project2.create(ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testBug45996() throws Throwable {
        AtomicReference<ThrowingRunnable> listenerInMainThreadCallback = new AtomicReference<ThrowingRunnable>(NOOP_RUNNABLE);
        IResourceChangeListener listener = event -> {
            try {
                IWorkspaceRunnable body = monitor -> {
                    IResourceDeltaVisitor visitor = delta -> {
                        IResource resource = delta.getResource();
                        resource.touch(ResourceTestUtil.createTestMonitor());
                        resource.createMarker("org.eclipse.core.resources.problemmarker");
                        return true;
                    };
                    event.getDelta().accept(visitor);
                };
                ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
            }
            catch (CoreException e) {
                return;
            }
            listenerInMainThreadCallback.set(() -> Assert.fail((String)"1.0"));
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(listener, 1);
        try {
            IWorkspaceRunnable body = new IWorkspaceRunnable(){
                final IResourceVisitor visitor = resource -> {
                    resource.touch(ResourceTestUtil.createTestMonitor());
                    return true;
                };

                public void run(IProgressMonitor monitor) throws CoreException {
                    ResourcesPlugin.getWorkspace().getRoot().accept(this.visitor);
                }
            };
            ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
        }
        listenerInMainThreadCallback.get().run();
    }

    @Test
    public void testBuildKind() throws CoreException {
        SimpleListener preBuild = new SimpleListener();
        SimpleListener postBuild = new SimpleListener();
        SimpleListener postChange = new SimpleListener();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            ResourceTestUtil.setAutoBuilding(false);
            workspace.addResourceChangeListener((IResourceChangeListener)preBuild, 8);
            workspace.addResourceChangeListener((IResourceChangeListener)postBuild, 16);
            workspace.addResourceChangeListener((IResourceChangeListener)postChange, 1);
            int[] triggers = new int[]{10, 6, 15};
            int i = 0;
            while (i < triggers.length) {
                int trigger = triggers[i];
                workspace.run(monitor -> {
                    this.file1.touch(null);
                    workspace.build(trigger, monitor);
                }, ResourceTestUtil.createTestMonitor());
                Assert.assertEquals((String)("1.0." + i), (Object)workspace, (Object)preBuild.source);
                Assert.assertEquals((String)("1.1." + i), (Object)workspace, (Object)postBuild.source);
                Assert.assertEquals((String)("1.2." + i), (Object)workspace, (Object)postChange.source);
                Assert.assertEquals((String)("1.3." + i), (long)trigger, (long)preBuild.trigger);
                Assert.assertEquals((String)("1.4." + i), (long)trigger, (long)postBuild.trigger);
                Assert.assertEquals((String)("1.5." + i), (long)0L, (long)postChange.trigger);
                workspace.run(monitor -> {
                    this.file1.touch(null);
                    this.project1.build(trigger, ResourceTestUtil.createTestMonitor());
                }, ResourceTestUtil.createTestMonitor());
                Assert.assertEquals((String)("2.0." + i), (Object)this.project1, (Object)preBuild.source);
                Assert.assertEquals((String)("2.2." + i), (Object)this.project1, (Object)postBuild.source);
                Assert.assertEquals((String)("2.2." + i), (Object)workspace, (Object)postChange.source);
                Assert.assertEquals((String)("2.3." + i), (long)trigger, (long)preBuild.trigger);
                Assert.assertEquals((String)("2.4." + i), (long)trigger, (long)postBuild.trigger);
                Assert.assertEquals((String)("2.5." + i), (long)0L, (long)postChange.trigger);
                ++i;
            }
            ResourceTestUtil.setAutoBuilding(true);
            this.file1.touch(null);
            ResourceTestUtil.waitForBuild();
            int trigger = 9;
            Assert.assertEquals((String)"1.0", (Object)workspace, (Object)preBuild.source);
            Assert.assertEquals((String)"1.1", (Object)workspace, (Object)postBuild.source);
            Assert.assertEquals((String)"1.2", (Object)workspace, (Object)postChange.source);
            Assert.assertEquals((String)"1.3", (long)trigger, (long)preBuild.trigger);
            Assert.assertEquals((String)"1.4", (long)trigger, (long)postBuild.trigger);
            Assert.assertEquals((String)"1.5", (long)0L, (long)postChange.trigger);
        }
        finally {
            workspace.removeResourceChangeListener((IResourceChangeListener)preBuild);
            workspace.removeResourceChangeListener((IResourceChangeListener)postBuild);
            workspace.removeResourceChangeListener((IResourceChangeListener)postChange);
        }
    }

    @Test
    public void testChangeFile() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.file1, 4, 256);
        this.file1.setContents(ResourceTestUtil.createRandomContentsStream(), true, false, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testTouchFileWithAutobuildOff() throws Exception {
        SimpleListener preBuild = new SimpleListener();
        SimpleListener postBuild = new SimpleListener();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            ResourceTestUtil.setAutoBuilding(false);
            workspace.addResourceChangeListener((IResourceChangeListener)preBuild, 8);
            workspace.addResourceChangeListener((IResourceChangeListener)postBuild, 16);
            this.file1.touch(ResourceTestUtil.createTestMonitor());
            ((Workspace)ResourcesPlugin.getWorkspace()).getBuildManager().waitForAutoBuildOff();
            int trigger = 9;
            Assert.assertEquals((String)"Should see PRE_BUILD event", (long)trigger, (long)preBuild.trigger);
            Assert.assertEquals((String)"Should see POST_BUILD event", (long)trigger, (long)postBuild.trigger);
            Assert.assertEquals((String)"Should see workspace root on PRE_BUILD event", (Object)workspace, (Object)preBuild.source);
            Assert.assertEquals((String)"Should see workspace root on POST_BUILD event", (Object)workspace, (Object)postBuild.source);
        }
        finally {
            workspace.removeResourceChangeListener((IResourceChangeListener)preBuild);
            workspace.removeResourceChangeListener((IResourceChangeListener)postBuild);
        }
    }

    @Test
    public void testChangeFileToFolder() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.file1, 4, 295168);
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("Deleting and Creating", 100);
            try {
                this.file1.delete(true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                this.folder3.create(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testChangeFolderToFile() throws CoreException {
        this.verifier.reset();
        ResourcesPlugin.getWorkspace().run(m -> {
            this.file1.delete(true, ResourceTestUtil.createTestMonitor());
            this.folder3.create(true, true, ResourceTestUtil.createTestMonitor());
        }, null);
        this.verifier.addExpectedChange((IResource)this.file1, 4, 295168);
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("Deleting and Creating", 100);
            try {
                this.folder3.delete(true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                this.file1.create(ResourceTestUtil.createRandomContentsStream(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testChangeProject() throws CoreException {
        this.verifier.reset();
        ResourcesPlugin.getWorkspace().run(m -> {
            this.project2.create(ResourceTestUtil.createTestMonitor());
            this.project2.open(ResourceTestUtil.createTestMonitor());
        }, null);
        IProjectDescription desc = this.project2.getDescription();
        desc.setReferencedProjects(new IProject[]{this.project1});
        this.verifier.addExpectedChange((IResource)this.project2, 4, 524288);
        this.verifier.addExpectedChange((IResource)this.project2MetaData, 4, 256);
        this.project2.setDescription(desc, 1, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testCopyChangeFile() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.folder2, 1, 0);
        this.verifier.addExpectedChange((IResource)this.file3, 1, 0, null, null);
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("Creating and moving", 150);
            try {
                this.folder2.create(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                this.file1.copy(this.file3.getFullPath(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                this.file3.setContents(ResourceTestUtil.createRandomContentsStream(), 0, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testCopyFile() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.folder2, 1, 0);
        this.verifier.addExpectedChange((IResource)this.file3, 1, 0, null, null);
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("Creating and moving", 100);
            try {
                this.folder2.create(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                this.file1.copy(this.file3.getFullPath(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testCloseOpenReplaceFile() throws CoreException {
        this.verifier.reset();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.verifier);
        this.verifier.addExpectedChange((IResource)this.file1, 4, 262400);
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("Deleting and Creating", 100);
            try {
                this.file1.delete(true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                this.file1.create(ResourceTestUtil.createRandomContentsStream(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testDeleteInPostBuildListener() throws Throwable {
        AtomicReference exceptionInListener = new AtomicReference();
        IResourceChangeListener listener = event -> {
            try {
                event.getDelta().accept(delta -> {
                    IResource resource = delta.getResource();
                    if (resource.getType() == 1) {
                        ((IFile)resource).delete(true, true, null);
                    }
                    return true;
                });
            }
            catch (CoreException e) {
                exceptionInListener.set(e);
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(listener, 16);
        try {
            ResourcesPlugin.getWorkspace().run(monitor -> ResourcesPlugin.getWorkspace().getRoot().accept(resource -> {
                resource.touch(ResourceTestUtil.createTestMonitor());
                return true;
            }), ResourceTestUtil.createTestMonitor());
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
        }
        if (exceptionInListener.get() != null) {
            throw (CoreException)((Object)exceptionInListener.get());
        }
    }

    @Test
    public void testDeleteMoveFile() throws CoreException {
        this.verifier.reset();
        this.file2.create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        this.verifier.reset();
        int flags = 266496;
        this.verifier.addExpectedChange((IResource)this.file1, 4, flags, this.file2.getFullPath(), null);
        this.verifier.addExpectedChange((IResource)this.file2, 2, 8192, null, this.file1.getFullPath());
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("deleting and moving", 100);
            try {
                this.file1.delete(0, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                this.file2.move(this.file1.getFullPath(), 0, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteProject() throws Throwable {
        AtomicReference<ThrowingRunnable> listenerInMainThreadCallback = new AtomicReference<ThrowingRunnable>(NOOP_RUNNABLE);
        this.verifier.reset();
        IMarker marker = this.project1.createMarker("org.eclipse.core.resources.taskmarker");
        class Listener1
        implements IResourceChangeListener {
            public boolean done = false;
            private final /* synthetic */ AtomicReference val$listenerInMainThreadCallback;
            private final /* synthetic */ IMarker val$marker;

            Listener1(AtomicReference atomicReference, IMarker iMarker) {
                this.val$listenerInMainThreadCallback = atomicReference;
                this.val$marker = iMarker;
            }

            public void resourceChanged(IResourceChangeEvent event) {
                this.done = true;
                IMarkerDelta[] deltas = event.findMarkerDeltas("org.eclipse.core.resources.taskmarker", false);
                this.val$listenerInMainThreadCallback.set(() -> {
                    ((ObjectArrayAssert)Assertions.assertThat((Object[])deltas).hasSize(1)).allSatisfy(delta -> {
                        Assertions.assertThat((long)delta.getId()).isEqualTo(this.val$marker.getId());
                        Assertions.assertThat((int)delta.getKind()).isEqualTo(2);
                    });
                    Listener1 listener1 = this;
                    synchronized (listener1) {
                        this.notifyAll();
                    }
                });
            }
        }
        Listener1 listener = new Listener1(listenerInMainThreadCallback, marker);
        try {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 1);
            this.project1.delete(true, false, ResourceTestUtil.createTestMonitor());
            Listener1 listener1 = listener;
            synchronized (listener1) {
                int i = 0;
                while (!listener.done) {
                    try {
                        listener.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Assert.assertTrue((String)"2.0", (++i < 60 ? 1 : 0) != 0);
                }
            }
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        }
        listenerInMainThreadCallback.get().run();
    }

    @Test
    public void testDeleteFolderDuringRefresh() throws Throwable {
        this.project1 = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        this.project1.create(ResourceTestUtil.createTestMonitor());
        this.project1.open(ResourceTestUtil.createTestMonitor());
        this.project2 = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        this.project2.create(ResourceTestUtil.createTestMonitor());
        this.project2.open(ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"1.0", (boolean)this.project1.isOpen());
        Assert.assertTrue((String)"2.0", (boolean)this.project2.isOpen());
        IFolder f = this.project1.getFolder(ResourceTestUtil.createUniqueString());
        f.create(true, true, ResourceTestUtil.createTestMonitor());
        class Listener1
        implements IResourceChangeListener {
            public volatile boolean deletePerformed = false;
            public volatile Exception exception;
            private final /* synthetic */ IFolder val$f;

            Listener1(IFolder iFolder) {
                this.val$f = iFolder;
            }

            public void resourceChanged(IResourceChangeEvent event) {
                new Job("deleteFolder"){

                    public boolean belongsTo(Object family) {
                        return family == ResourcesPlugin.FAMILY_MANUAL_REFRESH;
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            val$f.delete(true, ResourceTestUtil.createTestMonitor());
                            deletePerformed = true;
                        }
                        catch (Exception e) {
                            exception = e;
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
        Listener1 listener1 = new Listener1(f);
        try {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener1, 32);
            this.project2.refreshLocal(2, ResourceTestUtil.createTestMonitor());
            Job.getJobManager().wakeUp(ResourcesPlugin.FAMILY_MANUAL_REFRESH);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, null);
            Assert.assertTrue((String)"deletion did unexpectedly not succeed", (boolean)listener1.deletePerformed);
            ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)f);
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener1);
        }
        if (listener1.exception != null) {
            throw listener1.exception;
        }
    }

    @Test
    public void testRefreshOtherProjectDuringRefresh() throws Throwable {
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        p.create(null);
        p.open(null);
        this.project1 = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        this.project1.create(null);
        this.project1.open(null);
        Assert.assertTrue((String)"1.0", (boolean)p.isOpen());
        Assert.assertTrue((String)"2.0", (boolean)this.project1.isOpen());
        class Listener1
        implements IResourceChangeListener {
            public volatile boolean refreshPerformed = false;
            public volatile Exception exception;
            private final /* synthetic */ IProject val$p;

            Listener1(IProject iProject) {
                this.val$p = iProject;
            }

            public void resourceChanged(final IResourceChangeEvent event) {
                new Job("refreshProject"){

                    public boolean belongsTo(Object family) {
                        return family == ResourcesPlugin.FAMILY_MANUAL_REFRESH;
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            if (event.getResource() != val$p) {
                                val$p.refreshLocal(2, null);
                            }
                            refreshPerformed = true;
                        }
                        catch (Exception e) {
                            exception = e;
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
        Listener1 listener1 = new Listener1(p);
        class Listener2
        implements IResourceChangeListener {
            public volatile boolean refreshSucceeded = false;
            private final /* synthetic */ IProject val$p;

            Listener2(IProject iProject) {
                this.val$p = iProject;
            }

            public void resourceChanged(IResourceChangeEvent event) {
                try {
                    if (event.getResource() != this.val$p) {
                        this.val$p.refreshLocal(2, null);
                        this.refreshSucceeded = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Listener2 listener2 = new Listener2(p);
        try {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener1, 32);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener2, 32);
            this.project1.refreshLocal(2, ResourceTestUtil.createTestMonitor());
            Job.getJobManager().wakeUp(ResourcesPlugin.FAMILY_MANUAL_REFRESH);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, null);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)listener1.refreshPerformed).withFailMessage("Refreshing resource in first resource change listener did not succeed", new Object[0])).isTrue();
            if (listener1.exception != null) {
                throw listener1.exception;
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)listener2.refreshSucceeded).withFailMessage("Refreshing resource in second resource change listener unexpectedly succeeded", new Object[0])).isFalse();
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener1);
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener2);
        }
    }

    @Test
    public void testPreRefreshNotification() throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.project1 = root.getProject(ResourceTestUtil.createUniqueString());
        this.project1.create(null);
        this.project1.open(null);
        Assert.assertTrue((String)"1.0", (boolean)this.project1.isOpen());
        class Listener1
        implements IResourceChangeListener {
            public volatile boolean wasPerformed = false;
            public volatile Object eventSource;
            public volatile Object eventResource;

            Listener1() {
            }

            public void resourceChanged(IResourceChangeEvent event) {
                this.wasPerformed = true;
                this.eventSource = event.getSource();
                this.eventResource = event.getResource();
            }
        }
        Listener1 listener1 = new Listener1();
        try {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener1, 32);
            root.refreshLocal(2, ResourceTestUtil.createTestMonitor());
            Job.getJobManager().wakeUp(ResourcesPlugin.FAMILY_MANUAL_REFRESH);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, null);
            Assert.assertTrue((String)"2.0", (boolean)listener1.wasPerformed);
            Assert.assertEquals((String)"3.0", (Object)ResourcesPlugin.getWorkspace(), (Object)listener1.eventSource);
            Assert.assertEquals((String)"4.0", null, (Object)listener1.eventResource);
            this.project1.refreshLocal(2, ResourceTestUtil.createTestMonitor());
            Job.getJobManager().wakeUp(ResourcesPlugin.FAMILY_MANUAL_REFRESH);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, null);
            Assert.assertTrue((String)"5.0", (boolean)listener1.wasPerformed);
            Assert.assertEquals((String)"6.0", (Object)this.project1, (Object)listener1.eventSource);
            Assert.assertEquals((String)"7.0", (Object)this.project1, (Object)listener1.eventResource);
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener1);
        }
    }

    @Test
    public void testHiddenPhantomChanges() throws Throwable {
        AtomicReference<ThrowingRunnable> listenerInMainThreadCallback = new AtomicReference<ThrowingRunnable>(NOOP_RUNNABLE);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFolder phantomFolder = this.project1.getFolder("PhantomFolder");
        IFile phantomFile = this.folder1.getFile("PhantomFile");
        IResource[] phantomResources = new IResource[]{phantomFolder, phantomFile};
        QualifiedName partner = new QualifiedName("Test", "Infected");
        IResourceChangeListener listener = event -> {
            ThrowingRunnable oldCallback = (ThrowingRunnable)listenerInMainThreadCallback.get();
            listenerInMainThreadCallback.set(() -> {
                oldCallback.run();
                this.assertNotDeltaIncludes(event.getDelta(), phantomResources);
                this.assertNotDeltaVisits(event.getDelta(), phantomResources);
            });
        };
        workspace.addResourceChangeListener(listener);
        workspace.getSynchronizer().add(partner);
        ResourceTestUtil.removeFromWorkspace(phantomResources);
        try {
            workspace.run(monitor -> workspace.getSynchronizer().setSyncInfo(partner, (IResource)phantomFolder, new byte[]{1}), ResourceTestUtil.createTestMonitor());
            IFile fileInFolder = phantomFolder.getFile("FileInPrivateFolder");
            workspace.getSynchronizer().setSyncInfo(partner, (IResource)fileInFolder, new byte[]{1});
            workspace.getSynchronizer().setSyncInfo(partner, (IResource)fileInFolder, new byte[]{2});
            workspace.getSynchronizer().flushSyncInfo(partner, (IResource)fileInFolder, 2);
            workspace.run(monitor -> {
                phantomFolder.delete(0, ResourceTestUtil.createTestMonitor());
                this.file1.setContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
            }, ResourceTestUtil.createTestMonitor());
            workspace.run(monitor -> workspace.getSynchronizer().setSyncInfo(partner, (IResource)phantomFile, new byte[]{2}), ResourceTestUtil.createTestMonitor());
            workspace.getSynchronizer().setSyncInfo(partner, (IResource)phantomFile, new byte[]{3});
            workspace.getSynchronizer().flushSyncInfo(partner, (IResource)phantomFile, 2);
        }
        finally {
            workspace.removeResourceChangeListener(listener);
        }
        listenerInMainThreadCallback.get().run();
    }

    @Test
    public void testHiddenTeamPrivateChanges() throws Throwable {
        AtomicReference<ThrowingRunnable> listenerInMainThreadCallback = new AtomicReference<ThrowingRunnable>(NOOP_RUNNABLE);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFolder teamPrivateFolder = this.project1.getFolder("TeamPrivateFolder");
        IFile teamPrivateFile = this.folder1.getFile("TeamPrivateFile");
        IResource[] privateResources = new IResource[]{teamPrivateFolder, teamPrivateFile};
        IResourceChangeListener listener = event -> {
            ThrowingRunnable oldCallback = (ThrowingRunnable)listenerInMainThreadCallback.get();
            listenerInMainThreadCallback.set(() -> {
                oldCallback.run();
                this.assertNotDeltaIncludes(event.getDelta(), privateResources);
                this.assertNotDeltaVisits(event.getDelta(), privateResources);
            });
        };
        workspace.addResourceChangeListener(listener);
        try {
            workspace.run(monitor -> {
                teamPrivateFolder.create(true, true, ResourceTestUtil.createTestMonitor());
                teamPrivateFolder.setTeamPrivateMember(true);
            }, ResourceTestUtil.createTestMonitor());
            IFile fileInFolder = teamPrivateFolder.getFile("FileInPrivateFolder");
            fileInFolder.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
            fileInFolder.setContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
            fileInFolder.delete(0, ResourceTestUtil.createTestMonitor());
            workspace.run(monitor -> {
                teamPrivateFolder.delete(0, ResourceTestUtil.createTestMonitor());
                this.file1.setContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
            }, ResourceTestUtil.createTestMonitor());
            workspace.run(monitor -> {
                teamPrivateFile.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
                teamPrivateFile.setTeamPrivateMember(true);
            }, ResourceTestUtil.createTestMonitor());
            teamPrivateFile.setContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
            teamPrivateFile.delete(0, ResourceTestUtil.createTestMonitor());
        }
        finally {
            workspace.removeResourceChangeListener(listener);
        }
        listenerInMainThreadCallback.get().run();
    }

    @Test
    public void testModifyMoveFile() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.folder2, 1, 0);
        this.verifier.addExpectedChange((IResource)this.file1, 2, 8192, null, this.file3.getFullPath());
        this.verifier.addExpectedChange((IResource)this.file3, 1, 4352, this.file1.getFullPath(), null);
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("Creating and moving", 100);
            try {
                this.folder2.create(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                this.file1.setContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
                this.file1.move(this.file3.getFullPath(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testMoveFile() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.folder2, 1, 0);
        this.verifier.addExpectedChange((IResource)this.file1, 2, 8192, null, this.file3.getFullPath());
        this.verifier.addExpectedChange((IResource)this.file3, 1, 4096, this.file1.getFullPath(), null);
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("Creating and moving", 100);
            try {
                this.folder2.create(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                this.file1.move(this.file3.getFullPath(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testMoveFileAddMarker() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.folder2, 1, 0);
        this.verifier.addExpectedChange((IResource)this.file1, 2, 8192, null, this.file3.getFullPath());
        this.verifier.addExpectedChange((IResource)this.file3, 1, 135168, this.file1.getFullPath(), null);
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("Creating and moving", 100);
            try {
                this.folder2.create(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                this.file1.move(this.file3.getFullPath(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                this.file3.createMarker("org.eclipse.core.resources.taskmarker");
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testMoveFileDeleteFolder() throws CoreException {
        this.file1.delete(0, null);
        this.file2.create(ResourceTestUtil.createRandomContentsStream(), 0, null);
        this.folder3.create(0, true, null);
        this.verifier.reset();
        this.verifier.addExpectedChange((IResource)this.file2, 2, 8192, null, this.file1.getFullPath());
        int flags = 299264;
        this.verifier.addExpectedChange((IResource)this.file1, 4, flags, this.file2.getFullPath(), null);
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("Deleting and moving", 100);
            try {
                this.folder3.delete(1, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                this.file2.move(this.file1.getFullPath(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testMoveFileDeleteSourceParent() throws CoreException {
        this.file1.delete(0, null);
        ResourceTestUtil.createInWorkspace((IResource)this.file3);
        this.verifier.reset();
        this.verifier.addExpectedChange((IResource)this.folder2, 2, 0, null, null);
        this.verifier.addExpectedChange((IResource)this.file1, 1, 4096, this.file3.getFullPath(), null);
        this.verifier.addExpectedChange((IResource)this.file3, 2, 8192, null, this.file1.getFullPath());
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("Creating and moving", 100);
            try {
                this.file3.move(this.file1.getFullPath(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                this.folder2.delete(0, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testMoveModifyFile() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.folder2, 1, 0);
        this.verifier.addExpectedChange((IResource)this.file1, 2, 8192, null, this.file3.getFullPath());
        this.verifier.addExpectedChange((IResource)this.file3, 1, 4352, this.file1.getFullPath(), null);
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("Creating and moving", 100);
            try {
                this.folder2.create(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                this.file1.move(this.file3.getFullPath(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                this.file3.setContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testMoveMoveFile() throws CoreException {
        this.file2 = this.project1.getFile("File2");
        this.file3 = this.project1.getFile("File3");
        this.verifier.addExpectedChange((IResource)this.file1, 2, 8192, null, this.file3.getFullPath());
        this.verifier.addExpectedChange((IResource)this.file3, 1, 4096, this.file1.getFullPath(), null);
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("moving and moving file", 100);
            try {
                this.file1.move(this.file2.getFullPath(), false, null);
                this.file2.move(this.file3.getFullPath(), false, null);
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testMoveMoveFolder() throws CoreException {
        this.folder2 = this.project1.getFolder("Folder2");
        this.folder3 = this.project1.getFolder("Folder3");
        this.file3 = this.folder3.getFile(this.file1.getName());
        this.verifier.addExpectedChange((IResource)this.folder1, 2, 8192, null, this.folder3.getFullPath());
        this.verifier.addExpectedChange((IResource)this.folder3, 1, 4096, this.folder1.getFullPath(), null);
        this.verifier.addExpectedChange((IResource)this.file1, 2, 8192, null, this.file3.getFullPath());
        this.verifier.addExpectedChange((IResource)this.file3, 1, 4096, this.file1.getFullPath(), null);
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("moving and moving folder", 100);
            try {
                this.folder1.move(this.folder2.getFullPath(), false, null);
                this.folder2.move(this.folder3.getFullPath(), false, null);
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testMoveProject1() throws CoreException {
        this.verifier.reset();
        this.verifier.addExpectedChange((IResource)this.project1, 2, 8192, null, this.project2.getFullPath());
        this.verifier.addExpectedChange((IResource)this.project1.getFile(".project"), 2, 8192, null, this.project2.getFile(".project").getFullPath());
        this.verifier.addExpectedChange((IResource)this.folder1, 2, 8192, null, this.project2.getFolder(this.folder1.getProjectRelativePath()).getFullPath());
        this.verifier.addExpectedChange((IResource)this.file1, 2, 8192, null, this.project2.getFile(this.file1.getProjectRelativePath()).getFullPath());
        this.verifier.addExpectedChange((IResource)this.settings, 2, 8192, null, this.project2.getFolder(this.settings.getProjectRelativePath()).getFullPath());
        this.verifier.addExpectedChange((IResource)this.prefs, 2, 8192, null, this.project2.getFile(this.prefs.getProjectRelativePath()).getFullPath());
        this.verifier.addExpectedChange((IResource)this.project2, 1, 544768, this.project1.getFullPath(), null);
        this.verifier.addExpectedChange((IResource)this.project2.getFile(".project"), 1, 4352, this.project1.getFile(".project").getFullPath(), null);
        this.verifier.addExpectedChange((IResource)this.project2.getFolder(this.folder1.getProjectRelativePath()), 1, 4096, this.folder1.getFullPath(), null);
        this.verifier.addExpectedChange((IResource)this.project2.getFile(this.file1.getProjectRelativePath()), 1, 4096, this.file1.getFullPath(), null);
        this.verifier.addExpectedChange((IResource)this.project2.getFolder(this.settings.getProjectRelativePath()), 1, 4096, this.settings.getFullPath(), null);
        this.verifier.addExpectedChange((IResource)this.project2.getFile(this.prefs.getProjectRelativePath()), 1, 4096, this.prefs.getFullPath(), null);
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("Creating and moving", 100);
            try {
                this.project1.move(this.project2.getFullPath(), 0, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testMoveProject2() throws CoreException {
        IPath path = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(path);
        this.verifier.addExpectedChange((IResource)this.project1, 4, 524288);
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("Creating and moving", 100);
            try {
                IProjectDescription desc = this.project1.getDescription();
                desc.setLocation(path);
                this.project1.move(desc, 0, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testMulti() throws CoreException {
        class Listener
        implements IResourceChangeListener {
            public volatile boolean done = false;
            public volatile int eventType = -1;

            Listener() {
            }

            public void resourceChanged(IResourceChangeEvent event) {
                this.eventType = event.getType();
                this.done = true;
            }
        }
        Listener listener1 = new Listener();
        Listener listener2 = new Listener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener1, 1);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener2, 16);
        try {
            this.project1.touch(ResourceTestUtil.createTestMonitor());
            int i = 0;
            while (!listener1.done || !listener2.done) {
                Assert.assertTrue((String)"Listeners were never called", (++i < 600 ? 1 : 0) != 0);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Assert.assertEquals((String)"Improper change event processed by first listener", (long)1L, (long)listener1.eventType);
            Assert.assertEquals((String)"Improper change event processed by second listener", (long)16L, (long)listener2.eventType);
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener1);
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener2);
        }
    }

    @Test
    public void testAutoPublishService() throws Throwable {
        LogReaderService reader;
        AtomicReference<ThrowingRunnable> logListenerInMainThreadCallback = new AtomicReference<ThrowingRunnable>(NOOP_RUNNABLE);
        class Loggy
        implements LogListener {
            public boolean done = false;
            private final /* synthetic */ AtomicReference val$logListenerInMainThreadCallback;

            Loggy(AtomicReference atomicReference) {
                this.val$logListenerInMainThreadCallback = atomicReference;
            }

            public void logged(LogEntry entry) {
                String message = entry.getMessage();
                LogLevel level = entry.getLogLevel();
                if (level == LogLevel.WARN && message.startsWith("event.mask of IResourceChangeListener")) {
                    this.done = true;
                    this.val$logListenerInMainThreadCallback.set(() -> Assert.assertEquals((Object)"event.mask of IResourceChangeListener service: expected Integer but was class java.lang.String (from class org.eclipse.core.tests.resources.IResourceChangeListenerTest$2Listener): Not an integer", (Object)message));
                }
            }
        }
        Loggy loggy = new Loggy(logListenerInMainThreadCallback);
        class Listener
        implements IResourceChangeListener {
            public volatile boolean done = false;
            public volatile int eventType = -1;

            Listener() {
            }

            public void resourceChanged(IResourceChangeEvent event) {
                this.eventType = event.getType();
                this.done = true;
            }
        }
        Listener listener1 = new Listener();
        Listener listener2 = new Listener();
        Listener listener3 = new Listener();
        Bundle bundle = FrameworkUtil.getBundle(ResourcesPlugin.getWorkspace().getClass());
        BundleContext context = bundle.getBundleContext();
        ServiceReference logReaderService = context.getServiceReference(LogReaderService.class);
        LogReaderService logReaderService2 = reader = logReaderService == null ? null : (LogReaderService)context.getService(logReaderService);
        if (reader != null) {
            reader.addLogListener((LogListener)loggy);
        }
        ServiceRegistration reg1 = context.registerService(IResourceChangeListener.class, (Object)listener1, null);
        ServiceRegistration reg2 = context.registerService(IResourceChangeListener.class, (Object)listener2, IResourceChangeListenerTest.with("event.mask", 16));
        ServiceRegistration reg3 = context.registerService(IResourceChangeListener.class, (Object)listener3, IResourceChangeListenerTest.with("event.mask", "Not an integer"));
        try {
            Assert.assertTrue((boolean)this.waitUntil(() -> reg1.getReference().getUsingBundles() != null));
            Assert.assertTrue((boolean)this.waitUntil(() -> reg2.getReference().getUsingBundles() != null));
            Assert.assertTrue((boolean)this.waitUntil(() -> reg3.getReference().getUsingBundles() != null));
            this.project1.touch(ResourceTestUtil.createTestMonitor());
            Assert.assertTrue((boolean)this.waitUntil(() -> listener.done && listener2.done && listener3.done && (loggy.done || reader == null)));
        }
        finally {
            if (reader != null) {
                reader.removeLogListener((LogListener)loggy);
            }
            if (logReaderService != null) {
                context.ungetService(logReaderService);
            }
            if (reg1 != null) {
                reg1.unregister();
            }
            if (reg2 != null) {
                reg2.unregister();
            }
            if (reg3 != null) {
                reg3.unregister();
            }
        }
        Assert.assertEquals((String)"Improper change event processed by first listener", (long)1L, (long)listener1.eventType);
        Assert.assertEquals((String)"Improper change event processed by second listener", (long)16L, (long)listener2.eventType);
        Assert.assertEquals((String)"Improper change event processed by third listener", (long)1L, (long)listener3.eventType);
        logListenerInMainThreadCallback.get().run();
    }

    public boolean waitUntil(BooleanSupplier condition) {
        int i = 0;
        while (!condition.getAsBoolean()) {
            if (i++ > 600) {
                return false;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return true;
    }

    private static Dictionary<String, Object> with(String key, Object value) {
        Hashtable<String, Object> dict = new Hashtable<String, Object>();
        dict.put(key, value);
        return dict;
    }

    @Test
    public void testProjectDescriptionComment() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.project1, 4, 524288);
        this.verifier.addExpectedChange((IResource)this.project1MetaData, 4, 256);
        IProjectDescription description = this.project1.getDescription();
        description.setComment("new comment");
        this.project1.setDescription(description, 0, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testProjectDescriptionDynamicRefs() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.project1, 4, 524288);
        IProjectDescription description = this.project1.getDescription();
        description.setDynamicReferences(new IProject[]{this.project2});
        this.project1.setDescription(description, 0, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testProjectDescriptionNatures() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.project1, 4, 524288);
        this.verifier.addExpectedChange((IResource)this.project1MetaData, 4, 256);
        IProjectDescription description = this.project1.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.core.tests.resources.simpleNature"});
        this.project1.setDescription(description, 0, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testProjectDescriptionStaticRefs() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.project1, 4, 524288);
        this.verifier.addExpectedChange((IResource)this.project1MetaData, 4, 256);
        IProjectDescription description = this.project1.getDescription();
        description.setReferencedProjects(new IProject[]{this.project2});
        this.project1.setDescription(description, 0, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testRemoveFile() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.file1, 2, 0);
        this.file1.delete(true, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testRemoveFileAndFolder() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.folder1, 2, 0);
        this.verifier.addExpectedChange((IResource)this.file1, 2, 0);
        this.folder1.delete(true, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testReplaceFile() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.file1, 4, 262400);
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("Deleting and Creating", 100);
            try {
                this.file1.delete(true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                this.file1.create(ResourceTestUtil.createRandomContentsStream(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testReplaceFolderWithFolder() throws CoreException {
        this.folder2 = this.project1.getFolder("Folder2");
        this.folder3 = this.project1.getFolder("Folder3");
        this.verifier.reset();
        ResourcesPlugin.getWorkspace().run(m -> {
            this.file1.delete(false, null);
            this.folder2.create(false, true, null);
        }, null);
        this.verifier.reset();
        this.verifier.addExpectedChange((IResource)this.folder1, 2, 8192, null, this.folder2.getFullPath());
        int flags = 274688;
        this.verifier.addExpectedChange((IResource)this.folder2, 4, flags, this.folder1.getFullPath(), this.folder3.getFullPath());
        this.verifier.addExpectedChange((IResource)this.folder3, 1, 4096, this.folder2.getFullPath(), null);
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("replace folder with folder", 100);
            try {
                this.folder2.move(this.folder3.getFullPath(), false, null);
                this.folder1.move(this.folder2.getFullPath(), false, null);
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testSetLocal() throws CoreException {
        this.verifier.reset();
        this.file1.setLocal(true, 2, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"Unexpected notification on no change", (!this.verifier.hasBeenNotified() ? 1 : 0) != 0);
        this.verifier.reset();
        this.file1.setLocal(false, 2, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"Unexpected notification on no change", (!this.verifier.hasBeenNotified() ? 1 : 0) != 0);
    }

    @Test
    public void testSwapFiles() throws CoreException {
        this.file1 = this.project1.getFile("File1");
        this.file2 = this.project1.getFile("File2");
        this.file3 = this.project1.getFile("File3");
        this.verifier.reset();
        ResourcesPlugin.getWorkspace().run(m -> {
            this.file1.create((InputStream)new ByteArrayInputStream(new byte[]{65}), false, null);
            this.file2.create((InputStream)new ByteArrayInputStream(new byte[]{67}), false, null);
        }, null);
        this.verifier.reset();
        int flags = 274688;
        this.verifier.addExpectedChange((IResource)this.file1, 4, 274688, this.file2.getFullPath(), this.file2.getFullPath());
        this.verifier.addExpectedChange((IResource)this.file2, 4, 274688, this.file1.getFullPath(), this.file1.getFullPath());
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("swap files", 100);
            try {
                this.file1.move(this.file3.getFullPath(), false, null);
                this.file2.move(this.file1.getFullPath(), false, null);
                this.file3.move(this.file2.getFullPath(), false, null);
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testSwapFolders() throws CoreException {
        this.verifier.reset();
        ResourcesPlugin.getWorkspace().run(m -> {
            this.folder2 = this.project1.getFolder("Folder2");
            this.folder3 = this.project1.getFolder("Folder3");
            this.file1.delete(false, null);
            this.folder2.create(false, true, null);
        }, null);
        this.verifier.reset();
        int flags = 274688;
        this.verifier.addExpectedChange((IResource)this.folder1, 4, 274688, this.folder2.getFullPath(), this.folder2.getFullPath());
        this.verifier.addExpectedChange((IResource)this.folder2, 4, 274688, this.folder1.getFullPath(), this.folder1.getFullPath());
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("swap folders", 100);
            try {
                this.folder1.move(this.folder3.getFullPath(), false, null);
                this.folder2.move(this.folder1.getFullPath(), false, null);
                this.folder3.move(this.folder2.getFullPath(), false, null);
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testTeamPrivateChanges() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFolder teamPrivateFolder = this.project1.getFolder("TeamPrivateFolder");
        IFile teamPrivateFile = this.folder1.getFile("TeamPrivateFile");
        this.verifier.reset();
        this.verifier.addExpectedChange((IResource)teamPrivateFolder, 1, 0);
        workspace.run(monitor -> {
            teamPrivateFolder.create(true, true, ResourceTestUtil.createTestMonitor());
            teamPrivateFolder.setTeamPrivateMember(true);
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
        this.verifier.reset();
        IFile fileInFolder = teamPrivateFolder.getFile("FileInPrivateFolder");
        this.verifier.addExpectedChange((IResource)fileInFolder, 1, 0);
        fileInFolder.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
        this.verifier.reset();
        this.verifier.addExpectedChange((IResource)fileInFolder, 4, 256);
        fileInFolder.setContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
        this.verifier.reset();
        this.verifier.addExpectedChange((IResource)fileInFolder, 2, 0);
        fileInFolder.delete(0, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
        this.verifier.reset();
        this.verifier.addExpectedChange((IResource)teamPrivateFolder, 2, 0);
        this.verifier.addExpectedChange((IResource)this.file1, 4, 256);
        workspace.run(monitor -> {
            teamPrivateFolder.delete(0, ResourceTestUtil.createTestMonitor());
            this.file1.setContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
        this.verifier.reset();
        this.verifier.addExpectedChange((IResource)teamPrivateFile, 1, 0);
        workspace.run(monitor -> {
            teamPrivateFile.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
            teamPrivateFile.setTeamPrivateMember(true);
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
        this.verifier.reset();
        this.verifier.addExpectedChange((IResource)teamPrivateFile, 4, 256);
        teamPrivateFile.setContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
        this.verifier.reset();
        this.verifier.addExpectedChange((IResource)teamPrivateFile, 2, 0);
        teamPrivateFile.delete(0, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
        this.verifier.reset();
    }

    @Test
    public void testTwoFileChanges() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.file1, 4, 256);
        this.verifier.addExpectedChange((IResource)this.file2, 1, 0);
        ResourcesPlugin.getWorkspace().run(m -> {
            m.beginTask("setting contents and creating", 100);
            try {
                this.file1.setContents(ResourceTestUtil.createRandomContentsStream(), true, false, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
                this.file2.create(ResourceTestUtil.createRandomContentsStream(), true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)m, (int)50));
            }
            finally {
                m.done();
            }
        }, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testRemoveAndCreateUnderlyingFileForLinkedResource() throws CoreException, IOException {
        IPath path = FileSystemHelper.getTempDir().addTrailingSeparator().append(ResourceTestUtil.createUniqueString());
        this.workspaceRule.deleteOnTearDown(path);
        path.toFile().createNewFile();
        IFile linkedFile = this.project1.getFile(ResourceTestUtil.createUniqueString());
        linkedFile.createLink(path, 0, ResourceTestUtil.createTestMonitor());
        this.verifier.addExpectedChange((IResource)linkedFile, 4, 0x200000);
        path.toFile().delete();
        this.project1.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
        this.verifier.addExpectedChange((IResource)linkedFile, 4, 0x200100);
        path.toFile().createNewFile();
        this.project1.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testRemoveAndCreateUnderlyingFolderForLinkedResource() throws CoreException {
        IPath path = FileSystemHelper.getTempDir().addTrailingSeparator().append(ResourceTestUtil.createUniqueString());
        this.workspaceRule.deleteOnTearDown(path);
        path.toFile().mkdir();
        IFolder linkedFolder = this.project1.getFolder(ResourceTestUtil.createUniqueString());
        linkedFolder.createLink(path, 0, ResourceTestUtil.createTestMonitor());
        this.verifier.addExpectedChange((IResource)linkedFolder, 4, 0x200000);
        path.toFile().delete();
        this.project1.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
        this.verifier.addExpectedChange((IResource)linkedFolder, 4, 0x200000);
        path.toFile().mkdir();
        this.project1.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    @Test
    public void testBug228354() throws CoreException {
        IPath path = FileSystemHelper.getTempDir().addTrailingSeparator().append(ResourceTestUtil.createUniqueString());
        this.workspaceRule.deleteOnTearDown(path);
        path.toFile().mkdir();
        IFolder linkedFolder = this.project1.getFolder(ResourceTestUtil.createUniqueString());
        linkedFolder.createLink(path, 0, ResourceTestUtil.createTestMonitor());
        IFolder regularFolder = this.project1.getFolder(ResourceTestUtil.createUniqueString());
        regularFolder.create(true, true, ResourceTestUtil.createTestMonitor());
        this.verifier.addExpectedChange((IResource)regularFolder, 2, 0);
        regularFolder.delete(true, ResourceTestUtil.createTestMonitor());
        this.assertDelta();
    }

    static class SimpleListener
    implements IResourceChangeListener {
        Object source;
        int trigger;

        SimpleListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            this.source = event.getSource();
            this.trigger = event.getBuildKind();
        }
    }
}

