/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class IResourceDeltaTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    protected IProject project1;
    protected IProject project2;
    protected IFolder folder1;
    protected IFolder folder2;
    protected IFolder folder3;
    protected IFile file1;
    protected IFile file2;
    protected IFile file3;
    protected IFile file4;
    protected IResource[] allResources;

    @Before
    public void setUp() throws Exception {
        this.project1 = ResourcesPlugin.getWorkspace().getRoot().getProject("Project1");
        this.project2 = ResourcesPlugin.getWorkspace().getRoot().getProject("Project2");
        this.folder1 = this.project1.getFolder("Folder1");
        this.folder2 = this.folder1.getFolder("Folder2");
        this.folder3 = this.folder1.getFolder("Folder3");
        this.file1 = this.folder1.getFile("File1");
        this.file2 = this.folder1.getFile("File2");
        this.file3 = this.folder2.getFile("File3");
        this.file4 = this.folder1.getFile("File4");
        this.allResources = new IResource[]{this.project1, this.project2, this.folder1, this.folder2, this.folder3, this.file1, this.file2, this.file3};
        IWorkspaceRunnable body = monitor -> ResourceTestUtil.createInWorkspace(this.allResources);
        ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testFindMember() throws CoreException {
        IResourceChangeListener listener = event -> {
            IResourceDelta delta = event.getDelta();
            Assert.assertNotNull((String)"1.0", (Object)delta.findMember(this.project1.getFullPath()));
            Assert.assertNotNull((String)"1.1", (Object)delta.findMember(this.file1.getFullPath()));
            Assert.assertNotNull((String)"1.2", (Object)delta.findMember(this.folder2.getFullPath()));
            Assert.assertNotNull((String)"1.3", (Object)delta.findMember(this.file3.getFullPath()));
            Assert.assertNotNull((String)"1.4", (Object)delta.findMember(this.file4.getFullPath()));
            Assert.assertNull((String)"1.5", (Object)delta.findMember(this.project2.getFullPath()));
            Assert.assertNull((String)"1.6", (Object)delta.findMember(this.file2.getFullPath()));
            Assert.assertNull((String)"1.7", (Object)delta.findMember(this.folder3.getFullPath()));
            delta = delta.findMember(this.project1.getFullPath());
            Assert.assertNotNull((String)"2.1", (Object)delta.findMember(this.file1.getProjectRelativePath()));
            Assert.assertNotNull((String)"2.2", (Object)delta.findMember(this.folder2.getProjectRelativePath()));
            Assert.assertNotNull((String)"2.3", (Object)delta.findMember(this.file3.getProjectRelativePath()));
            Assert.assertNotNull((String)"2.4", (Object)delta.findMember(this.file4.getProjectRelativePath()));
            Assert.assertNull((String)"2.5", (Object)delta.findMember(this.project2.getFullPath()));
            Assert.assertNull((String)"2.6", (Object)delta.findMember(this.file2.getProjectRelativePath()));
            Assert.assertNull((String)"2.7", (Object)delta.findMember(this.folder3.getProjectRelativePath()));
            Assert.assertNull((String)"2.8", (Object)delta.findMember(this.project1.getFullPath()));
            Assert.assertNull((String)"2.9", (Object)delta.findMember(this.file1.getFullPath()));
            delta = delta.findMember(this.file1.getProjectRelativePath());
            Assert.assertEquals((String)"3.1", (Object)delta, (Object)delta.findMember(IPath.ROOT));
            Assert.assertNull((String)"3.2", (Object)delta.findMember(IPath.fromOSString((String)"foo")));
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(listener);
        IWorkspaceRunnable body = monitor -> {
            this.file1.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
            this.folder2.delete(true, ResourceTestUtil.createTestMonitor());
            this.file4.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        };
        try {
            ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
        }
    }
}

