/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.core.tests.harness.CancelingProgressMonitor;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.TestPerformer;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;

public class IResourceTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    protected static final Boolean[] FALSE_AND_TRUE = new Boolean[]{Boolean.FALSE, Boolean.TRUE};
    protected static final IPath[] interestingPaths = IResourceTest.getInterestingPaths();
    protected static IResource[] interestingResources;
    protected static Set<IResource> nonExistingResources;
    protected static final IProgressMonitor[] PROGRESS_MONITORS;
    protected static final int S_CHANGED = 3;
    protected static final int S_DOES_NOT_EXIST = 4;
    protected static final int S_FILE_TO_FOLDER = 6;
    protected static final int S_FILESYSTEM_ONLY = 1;
    protected static final int S_FOLDER_TO_FILE = 5;
    protected static final int S_UNCHANGED = 2;
    protected static final int S_WORKSPACE_ONLY = 0;
    protected static final Boolean[] TRUE_AND_FALSE;
    protected static Set<IResource> unsynchronizedResources;
    ResourceDeltaVerifier verifier;

    static {
        nonExistingResources = new HashSet<IResource>();
        IProgressMonitor[] iProgressMonitorArray = new IProgressMonitor[3];
        iProgressMonitorArray[0] = new FussyProgressMonitor();
        iProgressMonitorArray[1] = new CancelingProgressMonitor();
        PROGRESS_MONITORS = iProgressMonitorArray;
        TRUE_AND_FALSE = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
        unsynchronizedResources = new HashSet<IResource>();
    }

    protected static Set<File> getAllFilesForDirectory(File dir) {
        HashSet<File> result = new HashSet<File>(50);
        String[] members = dir.list();
        if (members != null) {
            String[] stringArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                String member2 = stringArray[n2];
                File member = new File(dir, member2);
                result.add(member);
                if (member.isDirectory()) {
                    result.addAll(IResourceTest.getAllFilesForDirectory(member));
                }
                ++n2;
            }
        }
        return result;
    }

    protected static Set<File> getAllFilesForResource(IResource resource, boolean considerUnsyncLocalFiles) throws CoreException {
        HashSet<File> result;
        block3: {
            File file;
            block4: {
                result = new HashSet<File>(50);
                if (resource.getLocation() == null || resource.getType() == 4 && !((IProject)resource).isOpen()) break block3;
                file = resource.getLocation().toFile();
                if (!considerUnsyncLocalFiles) break block4;
                if (!file.exists()) break block3;
                result.add(file);
                if (!file.isDirectory()) break block3;
                result.addAll(IResourceTest.getAllFilesForDirectory(file));
                break block3;
            }
            if (resource.exists()) {
                result.add(file);
                if (resource.getType() != 1) {
                    IResource[] children;
                    IContainer container = (IContainer)resource;
                    IResource[] iResourceArray = children = container.members();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource member = iResourceArray[n2];
                        result.addAll(IResourceTest.getAllFilesForResource(member, considerUnsyncLocalFiles));
                        ++n2;
                    }
                }
            }
        }
        return result;
    }

    protected static Set<IResource> getAllResourcesForResource(IResource resource) throws CoreException {
        HashSet<IResource> result = new HashSet<IResource>(50);
        if (resource.exists()) {
            result.add(resource);
            if (resource.getType() != 1 && resource.isAccessible()) {
                IResource[] children;
                IContainer container = (IContainer)resource;
                IResource[] iResourceArray = children = container.members();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    result.addAll(IResourceTest.getAllResourcesForResource(member));
                    ++n2;
                }
            }
        }
        return result;
    }

    protected IResource[] buildInterestingResources() throws CoreException {
        IProject emptyProject = ResourcesPlugin.getWorkspace().getRoot().getProject("EmptyProject");
        IProject fullProject = ResourcesPlugin.getWorkspace().getRoot().getProject("FullProject");
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)fullProject, new String[]{"1", "2/", "3/", "3/1", "3/2/"});
        IResource[] result = new IResource[resources.length + 3];
        result[0] = ResourcesPlugin.getWorkspace().getRoot();
        result[1] = emptyProject;
        result[2] = fullProject;
        System.arraycopy(resources, 0, result, 3, resources.length);
        ResourceTestUtil.createInWorkspace(result);
        return result;
    }

    private IResource[] buildSampleResources(IContainer root) throws Exception {
        IResource[] result = ResourceTestUtil.buildResources(root, new String[]{"1/", "1/1/", "1/1/1/", "1/1/1/1", "1/1/2/", "1/1/2/1/", "1/1/2/2/", "1/1/2/3/", "1/2/", "1/2/1", "1/2/2", "1/2/3/", "1/2/3/1", "1/2/3/2", "1/2/3/3", "1/2/3/4", "2", "2"});
        ResourceTestUtil.createInWorkspace(result);
        result[result.length - 1] = root.getFolder(IPath.fromOSString((String)"2/"));
        nonExistingResources.add(result[result.length - 1]);
        IResource[] deleted = ResourceTestUtil.buildResources(root, new String[]{"1/1/2/1/", "1/2/3/1"});
        ResourceTestUtil.removeFromWorkspace(deleted);
        nonExistingResources.addAll(Arrays.asList(deleted));
        IResource[] unsynchronized = ResourceTestUtil.buildResources(root, new String[]{"1/2/3/3"});
        ResourceTestUtil.ensureOutOfSync((IFile)unsynchronized[0]);
        unsynchronizedResources.add(unsynchronized[0]);
        unsynchronized = ResourceTestUtil.buildResources(root, new String[]{"1/1/2/2/1"});
        ResourceTestUtil.removeFromWorkspace(unsynchronized);
        IResource[] iResourceArray = unsynchronized;
        int n = unsynchronized.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            ResourceTestUtil.createInFileSystem(resource);
            ++n2;
        }
        unsynchronizedResources.add(unsynchronized[0]);
        return result;
    }

    private static IPath[] getInterestingPaths() {
        String[] interestingPathnames = new String[]{"1/", "1/1/", "1/1/1/", "1/1/1/1", "1/1/2/1/", "1/1/2/2/", "1/1/2/3/", "1/2/", "1/2/1", "1/2/2", "1/2/3/", "1/2/3/1", "1/2/3/2", "1/2/3/3", "1/2/3/4", "2", "2/1", "2/2", "2/3", "2/4", "2/1/", "2/2/", "2/3/", "2/4/", ".."};
        IPath[] paths = new IPath[interestingPathnames.length];
        int i = 0;
        while (i < interestingPathnames.length) {
            paths[i] = IPath.fromOSString((String)interestingPathnames[i]);
            ++i;
        }
        return paths;
    }

    protected boolean checkAfterState(IResource receiver, IResource target, int state, int depth) {
        Assert.assertTrue((String)this.verifier.getMessage(), (boolean)this.verifier.isDeltaValid());
        switch (state) {
            case 1: {
                ResourceTestUtil.assertExistsInFileSystem(target);
                if (this.hasParent(target, receiver, depth) || target.equals((Object)receiver)) {
                    ResourceTestUtil.assertExistsInWorkspace(target);
                    break;
                }
                ResourceTestUtil.assertDoesNotExistInWorkspace(target);
                break;
            }
            case 2: 
            case 3: {
                ResourceTestUtil.assertExistsInWorkspace(target);
                ResourceTestUtil.assertExistsInFileSystem(target);
                break;
            }
            case 0: {
                ResourceTestUtil.assertDoesNotExistInFileSystem(target);
                if (this.hasParent(target, receiver, depth) || target.equals((Object)receiver)) {
                    ResourceTestUtil.assertDoesNotExistInWorkspace(target);
                    break;
                }
                ResourceTestUtil.assertExistsInWorkspace(target);
                break;
            }
            case 4: {
                ResourceTestUtil.assertDoesNotExistInWorkspace(target);
                ResourceTestUtil.assertDoesNotExistInFileSystem(target);
                break;
            }
            case 5: {
                break;
            }
        }
        return true;
    }

    public void cleanUpAfterRefreshTest(Object[] args) throws CoreException {
        int depth;
        IResource receiver = (IResource)args[0];
        IResource target = (IResource)args[1];
        int state = (Integer)args[2];
        if (!this.makesSense(receiver, target, state, depth = ((Integer)args[3]).intValue())) {
            return;
        }
        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
        IResource changedTarget = ResourcesPlugin.getWorkspace().getRoot().findMember(target.getFullPath());
        if (changedTarget != null && changedTarget.getType() != target.getType()) {
            ResourceTestUtil.removeFromWorkspace(changedTarget);
        }
        ResourceTestUtil.createInWorkspace(interestingResources);
    }

    protected IProject[] getProjects(IResource[] resources) {
        ArrayList<IProject> list = new ArrayList<IProject>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getType() == 4) {
                list.add((IProject)resource);
            }
            ++n2;
        }
        return list.toArray(new IProject[list.size()]);
    }

    protected boolean hasParent(IResource resource1, IResource resource2, int depth) {
        if (depth == 0) {
            return false;
        }
        if (depth == 1) {
            return resource2.equals((Object)resource1.getParent());
        }
        IContainer parent = resource1.getParent();
        while (parent != null) {
            if (parent.equals((Object)resource2)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    protected Integer[] interestingDepths() {
        return new Integer[]{0, 1, 2};
    }

    protected Integer[] interestingStates() {
        return new Integer[]{0, 1, 2, 3, 4};
    }

    protected boolean isFile(IResource r) {
        return r.getType() == 1;
    }

    protected boolean isFolder(IResource r) {
        return r.getType() == 2;
    }

    protected boolean isProject(IResource r) {
        return r.getType() == 4;
    }

    protected boolean makesSense(IResource receiver, IResource target, int state, int depth) {
        if (target.getType() == 4 || target.getType() == 8) {
            return false;
        }
        if (this.hasParent(receiver, target, 2)) {
            return false;
        }
        switch (state) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return this.isFile(target);
            }
            case 4: {
                return true;
            }
            case 5: {
                return this.isFolder(target);
            }
            case 6: {
                return this.isFile(target);
            }
        }
        return true;
    }

    @Before
    public void setUp() throws Exception {
        ResourceTestUtil.setAutoBuilding(false);
        this.initializeProjects();
    }

    private void initializeProjects() throws Exception {
        IResource element;
        nonExistingResources.clear();
        IProject closedProject = ResourcesPlugin.getWorkspace().getRoot().getProject("ClosedProject");
        closedProject.create(null);
        closedProject.open(null);
        IResource[] resourcesInClosedProject = this.buildSampleResources((IContainer)closedProject);
        closedProject.close(null);
        IProject openProject = ResourcesPlugin.getWorkspace().getRoot().getProject("openProject");
        openProject.create(null);
        openProject.open(null);
        IResource[] resourcesInOpenProject = this.buildSampleResources((IContainer)openProject);
        IProject nonExistingProject = ResourcesPlugin.getWorkspace().getRoot().getProject("nonExistingProject");
        nonExistingProject.create(null);
        nonExistingProject.open(null);
        nonExistingProject.delete(true, null);
        ArrayList<Object> resources = new ArrayList<Object>();
        resources.add(openProject);
        IResource[] iResourceArray = resourcesInOpenProject;
        int n = resourcesInOpenProject.length;
        int n2 = 0;
        while (n2 < n) {
            element = iResourceArray[n2];
            resources.add(element);
            ++n2;
        }
        resources.add(closedProject);
        iResourceArray = resourcesInClosedProject;
        n = resourcesInClosedProject.length;
        n2 = 0;
        while (n2 < n) {
            element = iResourceArray[n2];
            resources.add(element);
            nonExistingResources.add(element);
            ++n2;
        }
        resources.add(nonExistingProject);
        nonExistingResources.add((IResource)nonExistingProject);
        interestingResources = new IResource[resources.size()];
        resources.toArray(interestingResources);
    }

    protected void setupBeforeState(IResource receiver, IResource target, int state, int depth, boolean addVerifier) throws OperationCanceledException, InterruptedException, CoreException, IOException {
        Job.getJobManager().wakeUp(ResourcesPlugin.FAMILY_AUTO_REFRESH);
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, ResourceTestUtil.createTestMonitor());
        if (addVerifier && this.verifier == null) {
            this.verifier = new ResourceDeltaVerifier();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.verifier);
        }
        ResourceTestUtil.createInWorkspace((IResource)target.getParent());
        switch (state) {
            case 0: {
                ResourceTestUtil.createInWorkspace(target);
                ResourceTestUtil.removeFromFileSystem(target);
                if (!addVerifier) break;
                this.verifier.reset();
                if (!this.hasParent(target, receiver, depth) && !target.equals((Object)receiver)) break;
                this.verifier.addExpectedDeletion(target);
                break;
            }
            case 1: {
                ResourceTestUtil.removeFromWorkspace(target);
                ResourceTestUtil.createInFileSystem(target);
                if (!addVerifier) break;
                this.verifier.reset();
                if (!this.hasParent(target, receiver, depth) && !target.equals((Object)receiver)) break;
                this.verifier.addExpectedChange(target, 1, 0);
                break;
            }
            case 2: {
                ResourceTestUtil.createInWorkspace(target);
                if (!addVerifier) break;
                this.verifier.reset();
                break;
            }
            case 3: {
                ResourceTestUtil.createInWorkspace(target);
                ResourceTestUtil.touchInFilesystem(target);
                if (!addVerifier) break;
                this.verifier.reset();
                if (!this.hasParent(target, receiver, depth) && !target.equals((Object)receiver)) break;
                this.verifier.addExpectedChange(target, 4, 256);
                break;
            }
            case 4: {
                ResourceTestUtil.removeFromWorkspace(target);
                ResourceTestUtil.removeFromFileSystem(target);
                if (!addVerifier) break;
                this.verifier.reset();
                break;
            }
            case 5: {
                ResourceTestUtil.createInWorkspace(target);
                ResourceTestUtil.removeFromFileSystem(target);
                ResourceTestUtil.createInFileSystem(target);
                if (!addVerifier) break;
                this.verifier.reset();
                if (!this.hasParent(target, receiver, depth) && !target.equals((Object)receiver)) break;
                this.verifier.addExpectedChange(target, 4, 295168);
                break;
            }
            case 6: {
                ResourceTestUtil.createInWorkspace(target);
                ResourceTestUtil.removeFromFileSystem(target);
                target.getLocation().toFile().mkdirs();
                if (!addVerifier) break;
                this.verifier.reset();
                if (!this.hasParent(target, receiver, depth) && !target.equals((Object)receiver)) break;
                this.verifier.addExpectedChange(target, 4, 295168);
            }
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.verifier != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.verifier);
        }
        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
        interestingResources = null;
        nonExistingResources.clear();
        unsynchronizedResources.clear();
    }

    @Test
    public void testAccept2() throws Exception {
        class LoggingResourceVisitor
        implements IResourceVisitor {
            Vector<IResource> visitedResources = new Vector();

            LoggingResourceVisitor() {
            }

            void clear() {
                this.visitedResources.removeAllElements();
            }

            void recordVisit(IResource r) {
                this.visitedResources.addElement(r);
            }

            public boolean visit(IResource r) {
                throw new RuntimeException("this class is abstract");
            }
        }
        final LoggingResourceVisitor deepVisitor = new LoggingResourceVisitor(this){
            {
            }

            @Override
            public boolean visit(IResource r) {
                this.recordVisit(r);
                return true;
            }
        };
        final LoggingResourceVisitor shallowVisitor = new LoggingResourceVisitor(this){
            {
            }

            @Override
            public boolean visit(IResource r) {
                this.recordVisit(r);
                return false;
            }
        };
        LoggingResourceVisitor[] interestingVisitors = new LoggingResourceVisitor[]{shallowVisitor, deepVisitor};
        Object[][] inputs = new Object[][]{interestingResources, interestingVisitors, TRUE_AND_FALSE};
        new TestPerformer("IResourceTest.testAccept2"){
            {
                super($anonymous0);
            }

            @Override
            public Object[] interestingOldState(Object[] args) {
                return null;
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IResource resource = (IResource)args[0];
                IResourceVisitor visitor = (IResourceVisitor)args[1];
                Boolean includePhantoms = (Boolean)args[2];
                resource.accept(visitor, 2, includePhantoms.booleanValue());
                return null;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                deepVisitor.clear();
                shallowVisitor.clear();
                IResource resource = (IResource)args[0];
                return nonExistingResources.contains(resource) || !resource.isAccessible();
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) {
                IResource resource = (IResource)args[0];
                LoggingResourceVisitor visitor = (LoggingResourceVisitor)args[1];
                Vector<IResource> visitedResources = visitor.visitedResources;
                if (visitor == shallowVisitor) {
                    return visitedResources.size() == 1 && visitedResources.elementAt(0).equals((Object)resource);
                }
                if (visitor == deepVisitor) {
                    if (resource.getType() == 1) {
                        return visitedResources.size() == 1 && visitedResources.elementAt(0).equals((Object)resource);
                    }
                    IContainer container = (IContainer)resource;
                    int memberCount = 0;
                    try {
                    }
                    catch (CoreException ex) {
                        return false;
                    }
                    return visitedResources.size() >= (memberCount += container.members().length) + 1 && visitedResources.elementAt(0).equals((Object)resource);
                }
                return false;
            }
        }.performTest(inputs);
    }

    @Test
    public void testAcceptDoNotCheckExistence() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFolder a = project.getFolder("a");
        ResourceTestUtil.createInWorkspace((IResource)project);
        Assert.assertThrows(CoreException.class, () -> a.accept(resource -> {
            Assert.fail((String)"1.0");
            return true;
        }, 1, 0));
        Assert.assertThrows(CoreException.class, () -> a.accept(proxy -> {
            Assert.fail((String)"2.0");
            return true;
        }, 0));
        a.accept(resource -> {
            Assert.fail((String)"3.0");
            return true;
        }, 1, 16);
        a.accept(proxy -> {
            Assert.fail((String)"4.0");
            return true;
        }, 16);
    }

    @Test
    public void testAcceptProxyVisitorWithDepth() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFolder a = project.getFolder("a");
        IFile a1 = a.getFile("a1.txt");
        IFile a2 = a.getFile("a2.txt");
        IFolder b = a.getFolder("b");
        IFile b1 = b.getFile("b1.txt");
        IFile b2 = b.getFile("b2.txt");
        IFolder c = b.getFolder("c");
        IFile c1 = c.getFile("c1.txt");
        IFile c2 = c.getFile("c2.txt");
        HashSet<IResource> toVisit = new HashSet<IResource>();
        int[] toVisitCount = new int[1];
        IResourceProxyVisitor visitor = proxy -> {
            toVisit.remove(proxy.requestResource());
            nArray[0] = toVisitCount[0] - 1;
            return true;
        };
        ResourceTestUtil.createInWorkspace(new IResource[]{project, a, a1, a2, b, b1, b2, c, c1, c2});
        toVisit.addAll(Arrays.asList(a));
        toVisitCount[0] = 1;
        a.accept(visitor, 0, 0);
        Assert.assertTrue((String)"1.0", (boolean)toVisit.isEmpty());
        Assert.assertEquals((String)"1.1", (long)0L, (long)toVisitCount[0]);
        toVisit.addAll(Arrays.asList(a, a1, a2, b));
        toVisitCount[0] = 4;
        a.accept(visitor, 1, 0);
        Assert.assertTrue((String)"2.0", (boolean)toVisit.isEmpty());
        Assert.assertEquals((String)"2.1", (long)0L, (long)toVisitCount[0]);
        toVisit.addAll(Arrays.asList(a, a1, a2, b, b1, b2, c, c1, c2));
        toVisitCount[0] = 9;
        a.accept(visitor, 2, 0);
        Assert.assertTrue((String)"3.0", (boolean)toVisit.isEmpty());
        Assert.assertEquals((String)"3.1", (long)0L, (long)toVisitCount[0]);
    }

    @Test
    public void testAddLocalProject() throws CoreException {
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject("NewProject");
        IPath projectPath = project1.getLocation().removeLastSegments(1).append("NewProject");
        this.workspaceRule.deleteOnTearDown(projectPath);
        projectPath.toFile().mkdirs();
        project1.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        project2.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"1.1", (boolean)project1.exists());
        Assert.assertTrue((String)"1.2", (boolean)project1.isSynchronized(2));
        Assert.assertFalse((String)"1.3", (boolean)project2.exists());
        Assert.assertTrue((String)"1.4", (boolean)project2.isSynchronized(2));
    }

    @Test
    public void testConstants() {
        Assert.assertEquals((String)"1.0", (long)0L, (long)0L);
        Assert.assertEquals((String)"2.1", (long)1L, (long)1L);
        Assert.assertEquals((String)"2.2", (long)2L, (long)2L);
        Assert.assertEquals((String)"2.3", (long)4L, (long)4L);
        Assert.assertEquals((String)"2.4", (long)8L, (long)8L);
        Assert.assertEquals((String)"3.1", (long)0L, (long)0L);
        Assert.assertEquals((String)"3.2", (long)1L, (long)1L);
        Assert.assertEquals((String)"3.1", (long)2L, (long)2L);
        Assert.assertEquals((String)"4.1", (long)-1L, (long)-1L);
        Assert.assertEquals((String)"5.1", (long)1L, (long)1L);
        Assert.assertEquals((String)"5.2", (long)2L, (long)2L);
        Assert.assertEquals((String)"5.3", (long)4L, (long)4L);
        Assert.assertEquals((String)"5.4", (long)8L, (long)8L);
        Assert.assertEquals((String)"6.1", (long)1L, (long)1L);
        Assert.assertEquals((String)"6.2", (long)2L, (long)2L);
        Assert.assertEquals((String)"6.2", (long)8L, (long)8L);
    }

    @Test
    public void testCopy() throws Exception {
        ResourcesPlugin.getWorkspace().getRoot().accept(resource -> {
            if (resource.isAccessible()) {
                resource.createMarker("org.eclipse.core.resources.taskmarker");
            }
            return true;
        });
        Object[][] inputs = new Object[][]{interestingResources, interestingPaths, TRUE_AND_FALSE, PROGRESS_MONITORS};
        new ProjectsReinitializingTestPerformer(this, "IResourceTest.testCopy"){

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IResource resource = (IResource)args[0];
                IPath destination = (IPath)args[1];
                Boolean force = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (monitor instanceof FussyProgressMonitor) {
                    FussyProgressMonitor fussy = (FussyProgressMonitor)monitor;
                    fussy.prepare();
                }
                resource.copy(destination, force.booleanValue(), monitor);
                if (monitor instanceof FussyProgressMonitor) {
                    FussyProgressMonitor fussy = (FussyProgressMonitor)monitor;
                    fussy.sanityCheck();
                }
                return null;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) throws Exception {
                IProgressMonitor monitor;
                IResource resource = (IResource)args[0];
                IPath destination = (IPath)args[1];
                boolean forceUpdate = (Boolean)args[2];
                if (this.shouldMoveOrCopyFail(resource, destination, forceUpdate, monitor = (IProgressMonitor)args[3], this::setReasonForExpectedFail)) {
                    return true;
                }
                if (!forceUpdate && !this.isProject(resource) && this.hasUnsynchronizedContents(resource)) {
                    this.reinitializeProjectsAfterTestIteration();
                    this.setReasonForExpectedFail("source has unsynchronized contents and move is not enforced");
                    return true;
                }
                return false;
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws CoreException {
                IResource source = (IResource)args[0];
                IPath destination = (IPath)args[1];
                IPath path = destination.isAbsolute() ? destination : source.getParent().getFullPath().append(destination);
                IResource copy = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                if (copy == null) {
                    return false;
                }
                if (!copy.exists()) {
                    return false;
                }
                if (copy.findMarkers("org.eclipse.core.resources.taskmarker", true, 2).length > 0) {
                    return false;
                }
                this.reinitializeProjectsAfterTestIteration();
                return true;
            }
        }.performTest(inputs);
    }

    private boolean shouldMoveOrCopyFail(IResource source, IPath destination, boolean forceUpdate, IProgressMonitor monitor, Consumer<String> expectedFailMessageReceiver) {
        File destinationFile;
        if (monitor instanceof CancelingProgressMonitor) {
            expectedFailMessageReceiver.accept("canceling progress monitor is used");
            return true;
        }
        if (!source.isAccessible()) {
            expectedFailMessageReceiver.accept("source is not accessible");
            return true;
        }
        File destinationParent = destination.isAbsolute() ? destination.removeLastSegments(1).toFile() : source.getLocation().removeLastSegments(1).append(destination.removeLastSegments(1)).toFile();
        File file = destinationFile = destination.isAbsolute() ? destination.toFile() : source.getLocation().removeLastSegments(1).append(destination).removeTrailingSeparator().toFile();
        if (!destinationParent.exists()) {
            expectedFailMessageReceiver.accept("parent of destination does not exist");
            return true;
        }
        if (!destinationParent.isDirectory()) {
            expectedFailMessageReceiver.accept("parent of destination is not a directory");
            return true;
        }
        if (destinationFile.exists()) {
            expectedFailMessageReceiver.accept("destination already exists");
            return true;
        }
        if (destinationFile.toString().startsWith(source.getLocation().toFile().toString())) {
            expectedFailMessageReceiver.accept("destination is child of source");
            return true;
        }
        return false;
    }

    private boolean hasUnsynchronizedContents(IResource resource) throws CoreException {
        final boolean[] hasUnsynchronizedResources = new boolean[1];
        resource.accept(new IResourceVisitor(){

            public boolean visit(IResource toVisit) throws CoreException {
                File target = toVisit.getLocation().toFile();
                if (target.exists() != toVisit.exists()) {
                    hasUnsynchronizedResources[0] = true;
                    return false;
                }
                if (target.isFile() != (toVisit.getType() == 1)) {
                    hasUnsynchronizedResources[0] = true;
                    return false;
                }
                if (unsynchronizedResources.contains(toVisit)) {
                    hasUnsynchronizedResources[0] = true;
                    return false;
                }
                if (target.isFile()) {
                    return false;
                }
                String[] list = target.list();
                if (list == null) {
                    return true;
                }
                IContainer container = (IContainer)toVisit;
                String[] stringArray = list;
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile child;
                    String element = stringArray[n2];
                    File file = new File(target, element);
                    Object object = child = file.isFile() ? container.getFile(IPath.fromOSString((String)element)) : container.getFolder(IPath.fromOSString((String)element));
                    if (!child.exists()) {
                        this.visit((IResource)child);
                    }
                    ++n2;
                }
                return true;
            }
        });
        return hasUnsynchronizedResources[0];
    }

    @Test
    public void testCopyProjectWithResFilterToExternLocation() throws CoreException {
        IProject sourceProj = this.createProject(true);
        IProject destProj = ResourcesPlugin.getWorkspace().getRoot().getProject("testCopyProject2");
        IPath targetLocation = IPath.fromOSString((String)FileSystemHelper.getRandomLocation((IPath)FileSystemHelper.getTempDir()).append(destProj.getName()).toOSString());
        this.workspaceRule.deleteOnTearDown(targetLocation);
        IProjectDescription desc = this.prepareDestProjDesc(sourceProj, destProj, targetLocation);
        LogListener logListener = this.copyProject(sourceProj, desc);
        logListener.assertNoLoggedErrors();
        IPath destProjLocInWs = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(destProj.getName());
        Assert.assertFalse((String)"Project folder should not exist in workspace when copied to external location", (boolean)destProjLocInWs.toFile().exists());
    }

    @Test
    public void testCopyProjectWithoutResFilterToExternLocation() throws CoreException {
        IProject sourceProj = this.createProject(false);
        IProject destProj = ResourcesPlugin.getWorkspace().getRoot().getProject("testCopyProject2");
        IPath targetLocation = IPath.fromOSString((String)FileSystemHelper.getRandomLocation((IPath)FileSystemHelper.getTempDir()).append(destProj.getName()).toOSString());
        this.workspaceRule.deleteOnTearDown(targetLocation);
        IProjectDescription desc = this.prepareDestProjDesc(sourceProj, destProj, targetLocation);
        LogListener logListener = this.copyProject(sourceProj, desc);
        logListener.assertNoLoggedErrors();
        IPath destProjLocInWs = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(destProj.getName());
        Assert.assertFalse((String)"Project folder should not exist in workspace when copied to external location", (boolean)destProjLocInWs.toFile().exists());
        Assert.assertTrue((String)"Project folder should exist in external location", (boolean)destProj.getLocation().toFile().exists());
    }

    @Test
    public void testCopyProjectWithResFilterWithinWorkspace() throws CoreException {
        IProject sourceProj = this.createProject(true);
        IProject destProj = ResourcesPlugin.getWorkspace().getRoot().getProject("testCopyProject2");
        IProjectDescription desc = this.prepareDestProjDesc(sourceProj, destProj, null);
        LogListener logListener = this.copyProject(sourceProj, desc);
        logListener.assertNoLoggedErrors();
        IPath destProjLocInWs = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(destProj.getName());
        Assert.assertTrue((String)"Project folder should exist in workspace when copied with default location", (boolean)destProjLocInWs.toFile().exists());
    }

    private LogListener copyProject(IProject sourceProj, IProjectDescription desc) throws CoreException {
        LogListener logListener = null;
        try {
            logListener = new LogListener();
            Platform.addLogListener((ILogListener)logListener);
            sourceProj.copy(desc, 0, ResourceTestUtil.createTestMonitor());
        }
        finally {
            Platform.removeLogListener((ILogListener)logListener);
        }
        return logListener;
    }

    private IProjectDescription prepareDestProjDesc(IProject sourceProj, IProject destProj, IPath destLocation) throws CoreException {
        ResourceTestUtil.removeFromWorkspace((IResource)destProj);
        IProjectDescription desc = sourceProj.getDescription();
        desc.setName(destProj.getName());
        desc.setLocation(destLocation);
        return desc;
    }

    private IProject createProject(boolean applyResFilter) throws CoreException {
        IProject sourceProj = ResourcesPlugin.getWorkspace().getRoot().getProject("testProject");
        sourceProj.create(ResourceTestUtil.createTestMonitor());
        sourceProj.open(ResourceTestUtil.createTestMonitor());
        if (applyResFilter) {
            String MULTI_FILT_ID = "org.eclipse.ui.ide.multiFilter";
            String FILT_ARG = "1.0-length-equals-false-false-10485760";
            FileInfoMatcherDescription filterDesc = new FileInfoMatcherDescription(MULTI_FILT_ID, (Object)FILT_ARG);
            int EXCL_FILE_GT = 22;
            sourceProj.createFilter(EXCL_FILE_GT, filterDesc, 128, ResourceTestUtil.createTestMonitor());
        }
        return sourceProj;
    }

    @Test
    public void testDelete() throws Exception {
        IProgressMonitor[] iProgressMonitorArray = new IProgressMonitor[2];
        iProgressMonitorArray[0] = new FussyProgressMonitor();
        IProgressMonitor[] monitors = iProgressMonitorArray;
        Object[][] inputs = new Object[][]{FALSE_AND_TRUE, monitors, interestingResources};
        String CANCELED = "canceled";
        new ProjectsReinitializingTestPerformer(this, "IResourceTest.testDelete"){

            @Override
            public Object[] interestingOldState(Object[] args) throws Exception {
                Boolean force = (Boolean)args[0];
                IResource resource = (IResource)args[2];
                return new Object[]{resource.isAccessible(), IResourceTest.getAllFilesForResource(resource, force), IResourceTest.getAllResourcesForResource(resource)};
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                Boolean force = (Boolean)args[0];
                IProgressMonitor monitor = (IProgressMonitor)args[1];
                IResource resource = (IResource)args[2];
                if (monitor instanceof FussyProgressMonitor) {
                    FussyProgressMonitor fussy = (FussyProgressMonitor)monitor;
                    fussy.prepare();
                }
                try {
                    if (resource.exists()) {
                        workspaceRule.deleteOnTearDown(resource.getLocation());
                    }
                    resource.delete(force.booleanValue(), monitor);
                }
                catch (OperationCanceledException e) {
                    return "canceled";
                }
                if (monitor instanceof FussyProgressMonitor) {
                    FussyProgressMonitor fussy = (FussyProgressMonitor)monitor;
                    fussy.sanityCheck();
                }
                return null;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean shouldFail(Object[] args, int count) throws Exception {
                Boolean force = (Boolean)args[0];
                IProgressMonitor monitor = (IProgressMonitor)args[1];
                IResource resource = (IResource)args[2];
                if (monitor instanceof CancelingProgressMonitor) {
                    return false;
                }
                if (force != false) return false;
                if (!resource.exists()) {
                    return false;
                }
                if (resource.getType() != 4) {
                    if (!this.hasUnsynchronizedContents(resource)) return false;
                    this.reinitializeProjectsAfterTestIteration();
                    this.setReasonForExpectedFail("source has unsynchronized contents");
                    return true;
                }
                IProject project = (IProject)resource;
                try {
                    IResource[] children;
                    if (!project.isOpen()) {
                        return false;
                    }
                    IResource[] iResourceArray = children = project.members();
                    int n = children.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return false;
                        }
                        IResource member = iResourceArray[n2];
                        if (this.shouldFail(new Object[]{args[0], args[1], member}, count)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                catch (CoreException ex) {
                    ex.printStackTrace();
                    throw new RuntimeException("there is a problem in the testing method 'shouldFail'");
                }
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                Boolean force = (Boolean)args[0];
                IProgressMonitor monitor = (IProgressMonitor)args[1];
                IResource resource = (IResource)args[2];
                if (result == "canceled") {
                    return monitor instanceof CancelingProgressMonitor;
                }
                boolean wasResourceAccessible = (Boolean)oldState[0];
                if (resource.getType() != 4 && wasResourceAccessible) {
                    IResource[] children;
                    IResource[] iResourceArray = children = ((IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember(resource.getFullPath().removeLastSegments(1))).members();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource element = iResourceArray[n2];
                        if (resource == element) {
                            return false;
                        }
                        ++n2;
                    }
                }
                if (wasResourceAccessible && !IResourceTest.getAllFilesForResource(resource, force).isEmpty()) {
                    return false;
                }
                Set oldFiles = (Set)oldState[1];
                for (File oldFile : oldFiles) {
                    if (oldFile.exists() != wasResourceAccessible) continue;
                    return false;
                }
                Set oldResources = (Set)oldState[2];
                for (IResource oldResource : oldResources) {
                    if (!oldResource.exists() && ResourcesPlugin.getWorkspace().getRoot().findMember(oldResource.getFullPath()) == null) continue;
                    return false;
                }
                this.reinitializeProjectsAfterTestIteration();
                return true;
            }
        }.performTest(inputs);
    }

    @Test
    public void testDerived() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("Project");
        IFolder folder = project.getFolder("folder");
        IFile file = folder.getFile("target");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        this.verifier = new ResourceDeltaVerifier();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.verifier, 1);
        Assert.assertFalse((String)"2.1.1", (boolean)root.isDerived());
        Assert.assertFalse((String)"2.1.2", (boolean)project.isDerived());
        Assert.assertFalse((String)"2.1.3", (boolean)folder.isDerived());
        Assert.assertFalse((String)"2.1.4", (boolean)file.isDerived());
        root.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((String)"2.2.1", (boolean)root.isDerived());
        Assert.assertFalse((String)"2.2.2", (boolean)project.isDerived());
        Assert.assertFalse((String)"2.2.3", (boolean)folder.isDerived());
        Assert.assertFalse((String)"2.2.4", (boolean)file.isDerived());
        Assert.assertTrue((String)("2.2.5" + this.verifier.getMessage()), (boolean)this.verifier.isDeltaValid());
        this.verifier.reset();
        root.setDerived(false, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((String)"2.3.1", (boolean)root.isDerived());
        Assert.assertFalse((String)"2.3.2", (boolean)project.isDerived());
        Assert.assertFalse((String)"2.3.3", (boolean)folder.isDerived());
        Assert.assertFalse((String)"2.3.4", (boolean)file.isDerived());
        Assert.assertTrue((String)("2.3.5" + this.verifier.getMessage()), (boolean)this.verifier.isDeltaValid());
        this.verifier.reset();
        project.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((String)"3.1.1", (boolean)root.isDerived());
        Assert.assertFalse((String)"3.1.2", (boolean)project.isDerived());
        Assert.assertFalse((String)"3.1.3", (boolean)folder.isDerived());
        Assert.assertFalse((String)"3.1.4", (boolean)file.isDerived());
        Assert.assertTrue((String)("3.1.5" + this.verifier.getMessage()), (boolean)this.verifier.isDeltaValid());
        this.verifier.reset();
        project.setDerived(false, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((String)"3.2.1", (boolean)root.isDerived());
        Assert.assertFalse((String)"3.2.2", (boolean)project.isDerived());
        Assert.assertFalse((String)"3.2.3", (boolean)folder.isDerived());
        Assert.assertFalse((String)"3.2.4", (boolean)file.isDerived());
        Assert.assertTrue((String)("3.2.5" + this.verifier.getMessage()), (boolean)this.verifier.isDeltaValid());
        this.verifier.reset();
        this.verifier.addExpectedChange((IResource)folder, 4, 0x400000);
        folder.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((String)"4.1.1", (boolean)root.isDerived());
        Assert.assertFalse((String)"4.1.2", (boolean)project.isDerived());
        Assert.assertTrue((String)"4.1.3", (boolean)folder.isDerived());
        Assert.assertFalse((String)"4.1.4", (boolean)file.isDerived());
        Assert.assertTrue((String)("4.1.5" + this.verifier.getMessage()), (boolean)this.verifier.isDeltaValid());
        this.verifier.reset();
        this.verifier.addExpectedChange((IResource)folder, 4, 0x400000);
        folder.setDerived(false, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((String)"4.2.1", (boolean)root.isDerived());
        Assert.assertFalse((String)"4.2.2", (boolean)project.isDerived());
        Assert.assertFalse((String)"4.2.3", (boolean)folder.isDerived());
        Assert.assertFalse((String)"4.2.4", (boolean)file.isDerived());
        Assert.assertTrue((String)("4.2.5" + this.verifier.getMessage()), (boolean)this.verifier.isDeltaValid());
        this.verifier.reset();
        this.verifier.addExpectedChange((IResource)file, 4, 0x400000);
        file.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((String)"5.1.1", (boolean)root.isDerived());
        Assert.assertFalse((String)"5.1.2", (boolean)project.isDerived());
        Assert.assertFalse((String)"5.1.3", (boolean)folder.isDerived());
        Assert.assertTrue((String)"5.1.4", (boolean)file.isDerived());
        Assert.assertTrue((String)("5.1.5" + this.verifier.getMessage()), (boolean)this.verifier.isDeltaValid());
        this.verifier.reset();
        this.verifier.addExpectedChange((IResource)file, 4, 0x400000);
        file.setDerived(false, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((String)"5.2.1", (boolean)root.isDerived());
        Assert.assertFalse((String)"5.2.2", (boolean)project.isDerived());
        Assert.assertFalse((String)"5.2.3", (boolean)folder.isDerived());
        Assert.assertFalse((String)"5.2.4", (boolean)file.isDerived());
        Assert.assertTrue((String)("5.2.5" + this.verifier.getMessage()), (boolean)this.verifier.isDeltaValid());
        this.verifier.reset();
        project.delete(true, ResourceTestUtil.createTestMonitor());
        Assert.assertFalse((String)"8.1", (boolean)project.isDerived());
        Assert.assertFalse((String)"8.2", (boolean)folder.isDerived());
        Assert.assertFalse((String)"8.3", (boolean)file.isDerived());
        Assert.assertThrows(CoreException.class, () -> project.setDerived(false, (IProgressMonitor)new NullProgressMonitor()));
        Assert.assertThrows(CoreException.class, () -> folder.setDerived(false, (IProgressMonitor)new NullProgressMonitor()));
        Assert.assertThrows(CoreException.class, () -> file.setDerived(false, (IProgressMonitor)new NullProgressMonitor()));
    }

    @Test
    public void testDeprecatedDerived() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("Project");
        IFolder folder = project.getFolder("folder");
        IFile file = folder.getFile("target");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        Assert.assertFalse((String)"2.1.1", (boolean)root.isDerived());
        Assert.assertFalse((String)"2.1.2", (boolean)project.isDerived());
        Assert.assertFalse((String)"2.1.3", (boolean)folder.isDerived());
        Assert.assertFalse((String)"2.1.4", (boolean)file.isDerived());
        root.setDerived(true);
        Assert.assertFalse((String)"2.2.1", (boolean)root.isDerived());
        Assert.assertFalse((String)"2.2.2", (boolean)project.isDerived());
        Assert.assertFalse((String)"2.2.3", (boolean)folder.isDerived());
        Assert.assertFalse((String)"2.2.4", (boolean)file.isDerived());
        root.setDerived(false);
        Assert.assertFalse((String)"2.3.1", (boolean)root.isDerived());
        Assert.assertFalse((String)"2.3.2", (boolean)project.isDerived());
        Assert.assertFalse((String)"2.3.3", (boolean)folder.isDerived());
        Assert.assertFalse((String)"2.3.4", (boolean)file.isDerived());
        project.setDerived(true);
        Assert.assertFalse((String)"3.1.1", (boolean)root.isDerived());
        Assert.assertFalse((String)"3.1.2", (boolean)project.isDerived());
        Assert.assertFalse((String)"3.1.3", (boolean)folder.isDerived());
        Assert.assertFalse((String)"3.1.4", (boolean)file.isDerived());
        project.setDerived(false);
        Assert.assertFalse((String)"3.2.1", (boolean)root.isDerived());
        Assert.assertFalse((String)"3.2.2", (boolean)project.isDerived());
        Assert.assertFalse((String)"3.2.3", (boolean)folder.isDerived());
        Assert.assertFalse((String)"3.2.4", (boolean)file.isDerived());
        folder.setDerived(true);
        Assert.assertFalse((String)"4.1.1", (boolean)root.isDerived());
        Assert.assertFalse((String)"4.1.2", (boolean)project.isDerived());
        Assert.assertTrue((String)"4.1.3", (boolean)folder.isDerived());
        Assert.assertFalse((String)"4.1.4", (boolean)file.isDerived());
        folder.setDerived(false);
        Assert.assertFalse((String)"4.2.1", (boolean)root.isDerived());
        Assert.assertFalse((String)"4.2.2", (boolean)project.isDerived());
        Assert.assertFalse((String)"4.2.3", (boolean)folder.isDerived());
        Assert.assertFalse((String)"4.2.4", (boolean)file.isDerived());
        file.setDerived(true);
        Assert.assertFalse((String)"5.1.1", (boolean)root.isDerived());
        Assert.assertFalse((String)"5.1.2", (boolean)project.isDerived());
        Assert.assertFalse((String)"5.1.3", (boolean)folder.isDerived());
        Assert.assertTrue((String)"5.1.4", (boolean)file.isDerived());
        file.setDerived(false);
        Assert.assertFalse((String)"5.2.1", (boolean)root.isDerived());
        Assert.assertFalse((String)"5.2.2", (boolean)project.isDerived());
        Assert.assertFalse((String)"5.2.3", (boolean)folder.isDerived());
        Assert.assertFalse((String)"5.2.4", (boolean)file.isDerived());
        project.delete(true, true, ResourceTestUtil.createTestMonitor());
        Assert.assertFalse((String)"8.1", (boolean)project.isDerived());
        Assert.assertFalse((String)"8.2", (boolean)folder.isDerived());
        Assert.assertFalse((String)"8.3", (boolean)file.isDerived());
        Assert.assertThrows(CoreException.class, () -> project.setDerived(false));
        Assert.assertThrows(CoreException.class, () -> folder.setDerived(false));
        Assert.assertThrows(CoreException.class, () -> file.setDerived(false));
    }

    @Test
    public void testDerivedUsingAncestors() throws CoreException {
        IResource resource2;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(ResourceTestUtil.createUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file1 = folder.getFile("file1.txt");
        IFile file2 = folder.getFile("file2.txt");
        IResource[] resources = new IResource[]{project, folder, file1, file2};
        ResourceTestUtil.createInWorkspace(resources);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = resource2 = iResourceArray[n2];
            Assert.assertFalse((String)("1.0: " + String.valueOf(resource.getFullPath())), (boolean)resource.isDerived());
            ++n2;
        }
        root.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((String)("2.1: " + String.valueOf(root.getFullPath())), (boolean)root.isDerived(512));
        Assert.assertFalse((String)("2.2: " + String.valueOf(project.getFullPath())), (boolean)project.isDerived(512));
        Assert.assertFalse((String)("2.3: " + String.valueOf(folder.getFullPath())), (boolean)folder.isDerived(512));
        Assert.assertFalse((String)("2.4: " + String.valueOf(file1.getFullPath())), (boolean)file1.isDerived(512));
        Assert.assertFalse((String)("2.5: " + String.valueOf(file2.getFullPath())), (boolean)file2.isDerived(512));
        project.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((String)("3.0: " + String.valueOf(project.getFullPath())), (boolean)project.isDerived(512));
        Assert.assertFalse((String)("3.1: " + String.valueOf(folder.getFullPath())), (boolean)folder.isDerived(512));
        Assert.assertFalse((String)("3.2: " + String.valueOf(file1.getFullPath())), (boolean)file1.isDerived(512));
        Assert.assertFalse((String)("3.3: " + String.valueOf(file2.getFullPath())), (boolean)file2.isDerived(512));
        folder.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((String)("4.1: " + String.valueOf(folder.getFullPath())), (boolean)folder.isDerived());
        Assert.assertFalse((String)("4.2: " + String.valueOf(file1.getFullPath())), (boolean)file1.isDerived());
        Assert.assertFalse((String)("4.3: " + String.valueOf(file2.getFullPath())), (boolean)file2.isDerived());
        Assert.assertTrue((String)("4.4: " + String.valueOf(folder.getFullPath())), (boolean)folder.isDerived(512));
        Assert.assertTrue((String)("4.5: " + String.valueOf(file1.getFullPath())), (boolean)file1.isDerived(512));
        Assert.assertTrue((String)("4.6: " + String.valueOf(file2.getFullPath())), (boolean)file2.isDerived(512));
        folder.setDerived(false, (IProgressMonitor)new NullProgressMonitor());
        iResourceArray = resources;
        n = resources.length;
        n2 = 0;
        while (n2 < n) {
            resource2 = iResourceArray[n2];
            Assert.assertFalse((String)("7.0: " + String.valueOf(resource2.getFullPath())), (boolean)resource2.isDerived());
            ++n2;
        }
    }

    @Test
    public void testEquals() throws Exception {
        Object[][] inputs = new Object[][]{interestingResources, interestingResources};
        new TestPerformer("IResourceTest.testEquals"){

            @Override
            public Object[] interestingOldState(Object[] args) throws Exception {
                return null;
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IResource resource0 = (IResource)args[0];
                IResource resource1 = (IResource)args[1];
                return resource0.equals((Object)resource1) ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                return false;
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                boolean expectedResult;
                IResource resource0 = (IResource)args[0];
                IResource resource1 = (IResource)args[1];
                boolean booleanResult = (Boolean)result;
                boolean bl = expectedResult = resource0.getFullPath().equals((Object)resource1.getFullPath()) && resource0.getType() == resource1.getType() && resource0.getWorkspace().equals(resource1.getWorkspace());
                if (booleanResult) {
                    Assert.assertEquals((String)"hashCode should be equal if equals returns true", (long)resource0.hashCode(), (long)resource1.hashCode());
                }
                return booleanResult == expectedResult;
            }
        }.performTest(inputs);
    }

    @Test
    public void testExists() throws Exception {
        Object[][] inputs = new Object[][]{interestingResources};
        new TestPerformer("IResourceTest.testExists"){

            @Override
            public Object[] interestingOldState(Object[] args) throws Exception {
                return null;
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IResource resource = (IResource)args[0];
                return resource.exists() ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                return false;
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                boolean booleanResult = (Boolean)result;
                IResource resource = (IResource)args[0];
                return booleanResult ^ nonExistingResources.contains(resource);
            }
        }.performTest(inputs);
    }

    @Test
    public void testGetLocation() throws Exception {
        Object[][] inputs = new Object[][]{interestingResources};
        new TestPerformer("IResourceTest.testGetLocation"){

            @Override
            public Object[] interestingOldState(Object[] args) {
                return null;
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IResource resource = (IResource)args[0];
                return resource.getLocation();
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                return false;
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) {
                IResource resource = (IResource)args[0];
                IPath resultPath = (IPath)result;
                if (resource.getType() == 4) {
                    if (!resource.exists()) {
                        return resultPath == null;
                    }
                    return resultPath != null;
                }
                if (!resource.getProject().exists()) {
                    return resultPath == null;
                }
                return resultPath != null;
            }
        }.performTest(inputs);
    }

    @Test
    public void testGetModificationStamp() throws CoreException {
        IProject[] projects;
        ResourcesPlugin.getWorkspace().getRoot().delete(5, ResourceTestUtil.createTestMonitor());
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)ResourcesPlugin.getWorkspace().getRoot(), new String[]{"/1/", "/1/1", "/1/2", "/1/3", "/2/", "/2/1"});
        HashMap<Object, Long> table = new HashMap<Object, Long>(resources.length);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource2 = iResourceArray[n2];
            if (resource2.getType() != 8) {
                Assert.assertEquals((String)("1.0." + String.valueOf(resource2.getFullPath())), (long)-1L, (long)resource2.getModificationStamp());
            }
            ++n2;
        }
        IProject[] iProjectArray = projects = this.getProjects(resources);
        int n3 = projects.length;
        int n4 = 0;
        while (n4 < n3) {
            IProject project2;
            IProject project = project2 = iProjectArray[n4];
            project.create(ResourceTestUtil.createTestMonitor());
            Assert.assertEquals((String)("2.1." + String.valueOf(project.getFullPath())), (long)-1L, (long)project.getModificationStamp());
            ++n4;
        }
        iProjectArray = projects;
        n3 = projects.length;
        n4 = 0;
        while (n4 < n3) {
            IProject project2;
            IProject project = project2 = iProjectArray[n4];
            Assert.assertEquals((String)("3.1." + String.valueOf(project.getFullPath())), (long)-1L, (long)project.getModificationStamp());
            project.open(ResourceTestUtil.createTestMonitor());
            Assert.assertNotEquals((String)("3.3." + String.valueOf(project.getFullPath())), (long)-1L, (long)project.getModificationStamp());
            table.put(project.getFullPath(), project.getModificationStamp());
            ++n4;
        }
        iProjectArray = resources;
        n3 = resources.length;
        n4 = 0;
        while (n4 < n3) {
            IProject resource3 = iProjectArray[n4];
            if (resource3.getType() != 4) {
                Assert.assertEquals((String)("3.4." + String.valueOf(resource3.getFullPath())), (long)-1L, (long)resource3.getModificationStamp());
                ResourceTestUtil.createInWorkspace((IResource)resource3);
                Assert.assertNotEquals((String)("3.5." + String.valueOf(resource3.getFullPath())), (long)-1L, (long)resource3.getModificationStamp());
                table.put(resource3.getFullPath(), resource3.getModificationStamp());
            }
            ++n4;
        }
        iProjectArray = projects;
        n3 = projects.length;
        n4 = 0;
        while (n4 < n3) {
            IProject project2;
            IProject project = project2 = iProjectArray[n4];
            project.close(ResourceTestUtil.createTestMonitor());
            ++n4;
        }
        iProjectArray = resources;
        n3 = resources.length;
        n4 = 0;
        while (n4 < n3) {
            IProject resource4 = iProjectArray[n4];
            if (resource4.getType() != 8) {
                Assert.assertEquals((String)("4.1." + String.valueOf(resource4.getFullPath())), (long)-1L, (long)resource4.getModificationStamp());
            }
            ++n4;
        }
        iProjectArray = projects;
        n3 = projects.length;
        n4 = 0;
        while (n4 < n3) {
            IProject project2;
            IProject project = project2 = iProjectArray[n4];
            project.open(ResourceTestUtil.createTestMonitor());
            ++n4;
        }
        iProjectArray = resources;
        n3 = resources.length;
        n4 = 0;
        while (n4 < n3) {
            IProject resource5 = iProjectArray[n4];
            if (resource5.getType() != 4) {
                Object v = table.get(resource5.getFullPath());
                Assert.assertNotNull((String)("5.1." + String.valueOf(resource5.getFullPath())), v);
                long old = (Long)v;
                Assert.assertEquals((String)("5.2." + String.valueOf(resource5.getFullPath())), (long)old, (long)resource5.getModificationStamp());
            }
            ++n4;
        }
        HashMap<IPath, Long> tempTable = new HashMap<IPath, Long>(resources.length);
        IResource[] iResourceArray2 = resources;
        int n5 = resources.length;
        n3 = 0;
        while (n3 < n5) {
            IResource resource6 = iResourceArray2[n3];
            if (resource6.getType() != 8) {
                resource6.touch(ResourceTestUtil.createTestMonitor());
                long stamp = resource6.getModificationStamp();
                Object v = table.get(resource6.getFullPath());
                Assert.assertNotNull((String)("6.0." + String.valueOf(resource6.getFullPath())), v);
                long old = (Long)v;
                Assert.assertNotEquals((String)("6.1." + String.valueOf(resource6.getFullPath())), (long)old, (long)stamp);
                tempTable.put(resource6.getFullPath(), stamp);
            }
            ++n3;
        }
        table.clear();
        table.putAll(tempTable);
        ResourcesPlugin.getWorkspace().getRoot().setLocal(false, 2, ResourceTestUtil.createTestMonitor());
        IResourceVisitor visitor = resource -> {
            if (resource.getType() == 8 || resource.getType() == 4) {
                Assert.assertNotEquals((String)("7.2" + String.valueOf(resource.getFullPath())), (long)-1L, (long)resource.getModificationStamp());
            } else {
                Assert.assertEquals((String)("7.3." + String.valueOf(resource.getFullPath())), (long)-1L, (long)resource.getModificationStamp());
            }
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor, 2, false);
        ResourcesPlugin.getWorkspace().getRoot().setLocal(true, 2, ResourceTestUtil.createTestMonitor());
        tempTable.clear();
        IResource[] iResourceArray3 = resources;
        int n6 = resources.length;
        n5 = 0;
        while (n5 < n6) {
            IResource resource7 = iResourceArray3[n5];
            if (resource7.getType() != 8) {
                long stamp = resource7.getModificationStamp();
                Assert.assertNotEquals((String)("8.2." + String.valueOf(resource7.getFullPath())), (long)-1L, (long)stamp);
                Object v = table.get(resource7.getFullPath());
                Assert.assertNotNull((String)("8.3." + String.valueOf(resource7.getFullPath())), v);
                long old = (Long)v;
                Assert.assertNotEquals((String)("8.4." + String.valueOf(resource7.getFullPath())), (long)-1L, (long)old);
                tempTable.put(resource7.getFullPath(), stamp);
            }
            ++n5;
        }
        table.clear();
        table.putAll(tempTable);
        ResourcesPlugin.getWorkspace().getRoot().setLocal(true, 2, ResourceTestUtil.createTestMonitor());
        iResourceArray3 = resources;
        n6 = resources.length;
        n5 = 0;
        while (n5 < n6) {
            IResource resource8 = iResourceArray3[n5];
            if (resource8.getType() != 8) {
                long newStamp = resource8.getModificationStamp();
                Assert.assertNotEquals((String)("9.2." + String.valueOf(resource8.getFullPath())), (long)-1L, (long)newStamp);
                Object v = table.get(resource8.getFullPath());
                Assert.assertNotNull((String)("9.3." + String.valueOf(resource8.getFullPath())), v);
                long oldStamp = (Long)v;
                Assert.assertEquals((String)("9.4." + String.valueOf(resource8.getFullPath())), (long)oldStamp, (long)newStamp);
            }
            ++n5;
        }
        ResourcesPlugin.getWorkspace().getRoot().delete(true, ResourceTestUtil.createTestMonitor());
        iResourceArray3 = resources;
        n6 = resources.length;
        n5 = 0;
        while (n5 < n6) {
            IResource resource9 = iResourceArray3[n5];
            if (resource9.getType() != 8) {
                Assert.assertEquals((String)("10.1" + String.valueOf(resource9.getFullPath())), (long)-1L, (long)resource9.getModificationStamp());
            }
            ++n5;
        }
        ResourceTestUtil.createInWorkspace((IResource[])this.getProjects(resources));
        iResourceArray3 = resources;
        n6 = resources.length;
        n5 = 0;
        while (n5 < n6) {
            IResource resource10 = iResourceArray3[n5];
            if (resource10 instanceof IFolder) {
                IFolder folder = (IFolder)resource10;
                folder.create(true, false, ResourceTestUtil.createTestMonitor());
            } else if (resource10 instanceof IFile) {
                IFile file = (IFile)resource10;
                file.create(null, true, ResourceTestUtil.createTestMonitor());
            }
            ++n5;
        }
        iResourceArray3 = resources;
        n6 = resources.length;
        n5 = 0;
        while (n5 < n6) {
            IResource resource11 = iResourceArray3[n5];
            switch (resource11.getType()) {
                case 8: {
                    break;
                }
                case 4: {
                    Assert.assertNotEquals((String)("11.1." + String.valueOf(resource11.getFullPath())), (long)-1L, (long)resource11.getModificationStamp());
                    break;
                }
                default: {
                    Assert.assertEquals((String)("11.2." + String.valueOf(resource11.getFullPath())), (long)-1L, (long)resource11.getModificationStamp());
                }
            }
            ++n5;
        }
        ResourcesPlugin.getWorkspace().getRoot().setLocal(true, 2, ResourceTestUtil.createTestMonitor());
        visitor = resource -> {
            if (resource.getType() != 8) {
                Assert.assertNotEquals((String)("12.1." + String.valueOf(resource.getFullPath())), (long)-1L, (long)resource.getModificationStamp());
            }
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor, 2, false);
    }

    @Test
    public void testGetModificationStampAfterReplace() throws Exception {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(IPath.fromOSString((String)"/project/f"));
        ResourceTestUtil.createInWorkspace((IResource)file);
        long modificationStamp = file.getModificationStamp();
        Assert.assertNotEquals((String)"1.1", (long)modificationStamp, (long)-1L);
        ResourcesPlugin.getWorkspace().run(monitor -> {
            file.delete(false, ResourceTestUtil.createTestMonitor());
            file.create(InputStream.nullInputStream(), true, ResourceTestUtil.createTestMonitor());
        }, ResourceTestUtil.createTestMonitor());
        Assert.assertNotEquals((String)"1.0", (long)modificationStamp, (long)file.getModificationStamp());
    }

    @Test
    public void testGetRawLocation() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFolder topFolder = project.getFolder("TopFolder");
        IFile topFile = project.getFile("TopFile");
        IFile deepFile = topFolder.getFile("DeepFile");
        IResource[] allResources = new IResource[]{project, topFolder, topFile, deepFile};
        Assert.assertNull((String)"2.0", (Object)project.getRawLocation());
        Assert.assertNull((String)"2.1", (Object)topFolder.getRawLocation());
        Assert.assertNull((String)"2.2", (Object)topFile.getRawLocation());
        Assert.assertNull((String)"2.3", (Object)deepFile.getRawLocation());
        ResourceTestUtil.createInWorkspace(allResources);
        Assert.assertNull((String)"2.0", (Object)project.getRawLocation());
        IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        Assert.assertEquals((String)"2.1", (Object)workspaceLocation.append(topFolder.getFullPath()), (Object)topFolder.getRawLocation());
        Assert.assertEquals((String)"2.2", (Object)workspaceLocation.append(topFile.getFullPath()), (Object)topFile.getRawLocation());
        Assert.assertEquals((String)"2.3", (Object)workspaceLocation.append(deepFile.getFullPath()), (Object)deepFile.getRawLocation());
        project.close(ResourceTestUtil.createTestMonitor());
        Assert.assertNull((String)"3.0", (Object)project.getRawLocation());
        Assert.assertEquals((String)"3.1", (Object)workspaceLocation.append(topFolder.getFullPath()), (Object)topFolder.getRawLocation());
        Assert.assertEquals((String)"3.2", (Object)workspaceLocation.append(topFile.getFullPath()), (Object)topFile.getRawLocation());
        Assert.assertEquals((String)"3.3", (Object)workspaceLocation.append(deepFile.getFullPath()), (Object)deepFile.getRawLocation());
        IPath projectLocation = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(projectLocation);
        IPath folderLocation = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(folderLocation);
        IPath fileLocation = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(fileLocation);
        IPath variableLocation = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(variableLocation);
        String variableName = "IResourceTest_VariableName";
        IPathVariableManager varMan = ResourcesPlugin.getWorkspace().getPathVariableManager();
        try {
            varMan.setValue("IResourceTest_VariableName", variableLocation);
            project.open(ResourceTestUtil.createTestMonitor());
            IProjectDescription description = project.getDescription();
            description.setLocation(projectLocation);
            project.move(description, 0, ResourceTestUtil.createTestMonitor());
            Assert.assertEquals((String)"4.0", (Object)projectLocation, (Object)project.getRawLocation());
            Assert.assertEquals((String)"4.1", (Object)projectLocation.append(topFolder.getProjectRelativePath()), (Object)topFolder.getRawLocation());
            Assert.assertEquals((String)"4.2", (Object)projectLocation.append(topFile.getProjectRelativePath()), (Object)topFile.getRawLocation());
            Assert.assertEquals((String)"4.3", (Object)projectLocation.append(deepFile.getProjectRelativePath()), (Object)deepFile.getRawLocation());
            project.close(ResourceTestUtil.createTestMonitor());
            Assert.assertEquals((String)"5.0", (Object)projectLocation, (Object)project.getRawLocation());
            Assert.assertEquals((String)"5.1", (Object)projectLocation.append(topFolder.getProjectRelativePath()), (Object)topFolder.getRawLocation());
            Assert.assertEquals((String)"5.2", (Object)projectLocation.append(topFile.getProjectRelativePath()), (Object)topFile.getRawLocation());
            Assert.assertEquals((String)"5.3", (Object)projectLocation.append(deepFile.getProjectRelativePath()), (Object)deepFile.getRawLocation());
            project.open(ResourceTestUtil.createTestMonitor());
            ResourceTestUtil.removeFromWorkspace((IResource)topFolder);
            ResourceTestUtil.removeFromWorkspace((IResource)topFile);
            ResourceTestUtil.createInFileSystem(EFS.getFileSystem((String)"file").getStore(fileLocation));
            folderLocation.toFile().mkdirs();
            topFolder.createLink(folderLocation, 0, ResourceTestUtil.createTestMonitor());
            topFile.createLink(fileLocation, 0, ResourceTestUtil.createTestMonitor());
            ResourceTestUtil.createInWorkspace((IResource)deepFile);
            Assert.assertEquals((String)"6.0", (Object)fileLocation, (Object)topFile.getRawLocation());
            Assert.assertEquals((String)"6.1", (Object)folderLocation, (Object)topFolder.getRawLocation());
            Assert.assertEquals((String)"6.2", (Object)folderLocation.append(deepFile.getName()), (Object)deepFile.getRawLocation());
            project.close(ResourceTestUtil.createTestMonitor());
            Assert.assertEquals((String)"7.0", (Object)projectLocation.append(topFile.getProjectRelativePath()), (Object)topFile.getRawLocation());
            Assert.assertEquals((String)"7.1", (Object)projectLocation.append(topFolder.getProjectRelativePath()), (Object)topFolder.getRawLocation());
            Assert.assertEquals((String)"7.3", (Object)projectLocation.append(deepFile.getProjectRelativePath()), (Object)deepFile.getRawLocation());
            project.open(ResourceTestUtil.createTestMonitor());
            IPath variableFolderLocation = IPath.fromOSString((String)"IResourceTest_VariableName").append("/VarFolderName");
            IPath variableFileLocation = IPath.fromOSString((String)"IResourceTest_VariableName").append("/VarFileName");
            ResourceTestUtil.removeFromWorkspace((IResource)topFolder);
            ResourceTestUtil.removeFromWorkspace((IResource)topFile);
            ResourceTestUtil.createInFileSystem(EFS.getFileSystem((String)"file").getStore(varMan.resolvePath(variableFileLocation)));
            varMan.resolvePath(variableFolderLocation).toFile().mkdirs();
            topFolder.createLink(variableFolderLocation, 0, ResourceTestUtil.createTestMonitor());
            topFile.createLink(variableFileLocation, 0, ResourceTestUtil.createTestMonitor());
            ResourceTestUtil.createInWorkspace((IResource)deepFile);
            Assert.assertEquals((String)"8.0", (Object)variableFileLocation, (Object)topFile.getRawLocation());
            Assert.assertEquals((String)"8.1", (Object)variableFolderLocation, (Object)topFolder.getRawLocation());
            Assert.assertEquals((String)"8.3", (Object)varMan.resolvePath(variableFolderLocation).append(deepFile.getName()), (Object)deepFile.getRawLocation());
            project.close(ResourceTestUtil.createTestMonitor());
            Assert.assertEquals((String)"9.0", (Object)projectLocation.append(topFile.getProjectRelativePath()), (Object)topFile.getRawLocation());
            Assert.assertEquals((String)"9.1", (Object)projectLocation.append(topFolder.getProjectRelativePath()), (Object)topFolder.getRawLocation());
            Assert.assertEquals((String)"9.3", (Object)projectLocation.append(deepFile.getProjectRelativePath()), (Object)deepFile.getRawLocation());
        }
        finally {
            varMan.setValue("IResourceTest_VariableName", null);
        }
    }

    @Test
    public void testIsConflicting() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFolder a = project.getFolder("a");
        IFolder b = project.getFolder("b");
        ResourceTestUtil.createInWorkspace(new IResource[]{project, a, b});
        ISchedulingRule multi = MultiRule.combine((ISchedulingRule)a, (ISchedulingRule)b);
        Assert.assertEquals((Object)false, (Object)a.isConflicting((ISchedulingRule)b));
        Assert.assertEquals((Object)false, (Object)b.isConflicting((ISchedulingRule)a));
        Assert.assertEquals((Object)true, (Object)a.isConflicting(multi));
        Assert.assertEquals((Object)true, (Object)multi.isConflicting((ISchedulingRule)a));
        Assert.assertEquals((Object)true, (Object)b.isConflicting(multi));
        Assert.assertEquals((Object)true, (Object)multi.isConflicting((ISchedulingRule)b));
        project.delete(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testIsConflicting2() throws CoreException {
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        ISchedulingRule wrapper = new ISchedulingRule(){

            public boolean isConflicting(ISchedulingRule rule) {
                return this == rule || project.isConflicting(rule);
            }

            public boolean contains(ISchedulingRule rule) {
                return this == rule || project.contains(rule);
            }
        };
        ISchedulingRule multi = MultiRule.combine((ISchedulingRule)wrapper, (ISchedulingRule)new ISchedulingRule(){

            public boolean isConflicting(ISchedulingRule rule) {
                return this == rule;
            }

            public boolean contains(ISchedulingRule rule) {
                return this == rule;
            }
        });
        Assert.assertEquals((Object)false, (Object)project.isConflicting(wrapper));
        Assert.assertEquals((Object)false, (Object)project.isConflicting(multi));
        Assert.assertEquals((Object)true, (Object)wrapper.isConflicting((ISchedulingRule)project));
        Assert.assertEquals((Object)true, (Object)multi.isConflicting((ISchedulingRule)project));
        project.delete(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testIsSynchronized() throws Exception {
        ResourcesPlugin.getWorkspace().getRoot().delete(true, true, ResourceTestUtil.createTestMonitor());
        interestingResources = this.buildInterestingResources();
        Object[][] inputs = new Object[][]{interestingResources, interestingResources, this.interestingStates(), this.interestingDepths()};
        new TestPerformer("IResourceTest.testRefreshLocal"){

            @Override
            public void cleanUp(Object[] args, int count) throws CoreException {
                IResourceTest.this.cleanUpAfterRefreshTest(args);
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                int depth;
                IResource receiver = (IResource)args[0];
                IResource target = (IResource)args[1];
                int state = (Integer)args[2];
                if (!IResourceTest.this.makesSense(receiver, target, state, depth = ((Integer)args[3]).intValue())) {
                    return null;
                }
                IResourceTest.this.setupBeforeState(receiver, target, state, depth, false);
                return receiver.isSynchronized(depth);
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                return false;
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) {
                if (result == null) {
                    return true;
                }
                boolean bResult = (Boolean)result;
                IResource receiver = (IResource)args[0];
                IResource target = (IResource)args[1];
                int state = (Integer)args[2];
                int depth = (Integer)args[3];
                if (!receiver.equals((Object)target) && !IResourceTest.this.hasParent(target, receiver, depth)) {
                    return bResult;
                }
                switch (state) {
                    case 2: 
                    case 4: {
                        return bResult;
                    }
                    case 0: 
                    case 1: 
                    case 3: 
                    case 5: 
                    case 6: {
                        return !bResult;
                    }
                }
                return false;
            }
        }.performTest(inputs);
    }

    @Test
    public void testMove() throws Exception {
        Object[][] inputs = new Object[][]{interestingResources, interestingPaths, TRUE_AND_FALSE, PROGRESS_MONITORS};
        new ProjectsReinitializingTestPerformer(this, "IResourceTest.testMove"){

            @Override
            public Object[] interestingOldState(Object[] args) {
                return null;
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IResource resource = (IResource)args[0];
                IPath destination = (IPath)args[1];
                Boolean force = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (monitor instanceof FussyProgressMonitor) {
                    FussyProgressMonitor fussy = (FussyProgressMonitor)monitor;
                    fussy.prepare();
                }
                resource.move(destination, force.booleanValue(), monitor);
                if (monitor instanceof FussyProgressMonitor) {
                    FussyProgressMonitor fussy = (FussyProgressMonitor)monitor;
                    fussy.sanityCheck();
                }
                return null;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) throws Exception {
                IProgressMonitor monitor;
                IResource resource = (IResource)args[0];
                IPath destination = (IPath)args[1];
                boolean forceUpdate = (Boolean)args[2];
                if (this.shouldMoveOrCopyFail(resource, destination, forceUpdate, monitor = (IProgressMonitor)args[3], this::setReasonForExpectedFail)) {
                    return true;
                }
                if (!forceUpdate && this.hasUnsynchronizedContents(resource)) {
                    this.reinitializeProjectsAfterTestIteration();
                    this.setReasonForExpectedFail("source has unsynchronized contents and move is not enforced");
                    return true;
                }
                return false;
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) {
                this.reinitializeProjectsAfterTestIteration();
                return true;
            }
        }.performTest(inputs);
    }

    @Test
    public void testMultiCreation() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("bar");
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, new String[]{"a/", "a/b"});
        project.create(null);
        project.open(null);
        ResourceTestUtil.assertExistsInWorkspace((IResource)project);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            switch (resource.getType()) {
                case 1: {
                    ((IFile)resource).create(null, false, ResourceTestUtil.createTestMonitor());
                    break;
                }
                case 2: {
                    ((IFolder)resource).create(false, true, ResourceTestUtil.createTestMonitor());
                    break;
                }
                case 4: {
                    ((IProject)resource).create(ResourceTestUtil.createTestMonitor());
                }
            }
            ++n2;
        }
        ResourceTestUtil.assertExistsInWorkspace(resources);
        project.delete(true, false, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testProjectDescriptionFileModification() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("P1");
        IFile file = project.getFile(".project");
        project.create(null);
        project.open(null);
        long stamp = file.getModificationStamp();
        project.close(null);
        project.open(null);
        Assert.assertEquals((long)stamp, (long)file.getModificationStamp());
    }

    @Test
    public void testProperties() throws CoreException {
        QualifiedName qn1 = new QualifiedName("package", "property1");
        QualifiedName qn2 = new QualifiedName("package", "property2");
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("P1");
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject("P2");
        project.create(null);
        project.open(null);
        project.setPersistentProperty(qn1, "value1");
        project.setPersistentProperty(qn2, "value2");
        project.setSessionProperty(qn1, (Object)"value1");
        project.setSessionProperty(qn2, (Object)"value2");
        Assert.assertEquals((Object)"value1", (Object)project.getPersistentProperty(qn1));
        Assert.assertEquals((Object)"value2", (Object)project.getPersistentProperty(qn2));
        Assert.assertEquals((Object)"value1", (Object)project.getSessionProperty(qn1));
        Assert.assertEquals((Object)"value2", (Object)project.getSessionProperty(qn2));
        Map props = project.getPersistentProperties();
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"value1", props.get(qn1));
        Assert.assertEquals((Object)"value2", props.get(qn2));
        props = project.getSessionProperties();
        Assert.assertEquals((Object)"value1", props.get(qn1));
        Assert.assertEquals((Object)"value2", props.get(qn2));
        project.setPersistentProperty(qn1, null);
        project.setSessionProperty(qn1, null);
        props = project.getPersistentProperties();
        Assert.assertEquals((long)1L, (long)props.size());
        Assert.assertNull(props.get(qn1));
        Assert.assertEquals((Object)"value2", props.get(qn2));
        props = project.getSessionProperties();
        Assert.assertNull(props.get(qn1));
        Assert.assertEquals((Object)"value2", props.get(qn2));
        project.copy(project2.getFullPath(), true, null);
        props = project2.getPersistentProperties();
        Assert.assertEquals((long)1L, (long)props.size());
        Assert.assertNull(props.get(qn1));
        Assert.assertEquals((Object)"value2", props.get(qn2));
        props = project2.getSessionProperties();
        Assert.assertNull(props.get(qn1));
        Assert.assertNull(props.get(qn2));
        project.close(null);
        project.open(null);
        props = project.getPersistentProperties();
        Assert.assertEquals((long)1L, (long)props.size());
        Assert.assertNull(props.get(qn1));
        Assert.assertEquals((Object)"value2", props.get(qn2));
        props = project.getSessionProperties();
        Assert.assertNull(props.get(qn1));
        Assert.assertNull(props.get(qn2));
    }

    @Deprecated
    @Test
    public void testReadOnly() throws CoreException {
        if (!ResourceTestUtil.isReadOnlySupported()) {
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFile file = project.getFile("target");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        Assert.assertFalse((String)"1.0", (boolean)file.isReadOnly());
        file.setReadOnly(true);
        Assert.assertTrue((String)"1.2", (boolean)file.isReadOnly());
        file.setReadOnly(false);
        Assert.assertFalse((String)"1.4", (boolean)file.isReadOnly());
        Assert.assertFalse((String)"2.0", (boolean)project.isReadOnly());
        project.setReadOnly(true);
        Assert.assertTrue((String)"2.2", (boolean)project.isReadOnly());
        project.setReadOnly(false);
        Assert.assertFalse((String)"2.4", (boolean)project.isReadOnly());
    }

    @Test
    public void testRefreshLocal() throws Exception {
        ResourcesPlugin.getWorkspace().getRoot().delete(true, true, ResourceTestUtil.createTestMonitor());
        interestingResources = this.buildInterestingResources();
        Object[][] inputs = new Object[][]{interestingResources, interestingResources, this.interestingStates(), this.interestingDepths()};
        new TestPerformer("IResourceTest.testRefreshLocal"){

            @Override
            public void cleanUp(Object[] args, int count) throws CoreException {
                IResourceTest.this.cleanUpAfterRefreshTest(args);
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                int depth;
                IResource receiver = (IResource)args[0];
                IResource target = (IResource)args[1];
                int state = (Integer)args[2];
                if (!IResourceTest.this.makesSense(receiver, target, state, depth = ((Integer)args[3]).intValue())) {
                    return null;
                }
                IResourceTest.this.setupBeforeState(receiver, target, state, depth, true);
                receiver.refreshLocal(depth, ResourceTestUtil.createTestMonitor());
                return Boolean.TRUE;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                return false;
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) {
                if (result == null) {
                    return true;
                }
                IResource receiver = (IResource)args[0];
                IResource target = (IResource)args[1];
                int state = (Integer)args[2];
                int depth = (Integer)args[3];
                return IResourceTest.this.checkAfterState(receiver, target, state, depth);
            }
        }.performTest(inputs);
    }

    @Test
    public void testRefreshLocalWithDepth() throws Exception {
        IResource[] resources;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFolder folder = project.getFolder("Folder");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        String[] hierarchy = new String[]{"Folder/", "Folder/Folder/", "Folder/Folder/Folder/", "Folder/Folder/Folder/Folder/"};
        IResource[] iResourceArray = resources = ResourceTestUtil.buildResources((IContainer)folder, hierarchy);
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            ResourceTestUtil.createInFileSystem(resource);
            ++n2;
        }
        ResourceTestUtil.assertDoesNotExistInWorkspace(resources);
        folder.refreshLocal(1, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace((IResource)folder.getFolder("Folder"));
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)folder.getFolder("Folder/Folder"));
    }

    @Test
    public void testRefreshWithMissingParent() throws Exception {
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        IFolder folder = project1.getFolder("Folder");
        IFile file = folder.getFile("File");
        ResourceTestUtil.createInFileSystem((IResource)file);
        file.refreshLocal(2, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testRevertModificationStamp() throws Throwable {
        IResource resource2;
        ResourcesPlugin.getWorkspace().getRoot().accept(resource -> {
            if (!resource.isAccessible()) {
                return false;
            }
            long oldStamp = resource.getModificationStamp();
            resource.touch(null);
            long newStamp = resource.getModificationStamp();
            if (resource.getType() == 8) {
                Assert.assertEquals((String)("1.0." + String.valueOf(resource.getFullPath())), (long)oldStamp, (long)newStamp);
            } else {
                Assert.assertNotEquals((String)("1.0." + String.valueOf(resource.getFullPath())), (long)oldStamp, (long)newStamp);
            }
            resource.revertModificationStamp(oldStamp);
            Assert.assertEquals((String)("1.1." + String.valueOf(resource.getFullPath())), (long)oldStamp, (long)resource.getModificationStamp());
            return true;
        });
        IResource[] resources = this.buildInterestingResources();
        long[] illegal = new long[]{-1L, -10L, -100L};
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            resource2 = iResourceArray[n2];
            if (resource2.isAccessible()) {
                long[] lArray = illegal;
                int n3 = illegal.length;
                int n4 = 0;
                while (n4 < n3) {
                    long element = lArray[n4];
                    Assert.assertThrows(RuntimeException.class, () -> resource2.revertModificationStamp(element));
                    ++n4;
                }
            }
            ++n2;
        }
        ResourcesPlugin.getWorkspace().getRoot().delete(4, ResourceTestUtil.createTestMonitor());
        iResourceArray = resources;
        n = resources.length;
        n2 = 0;
        while (n2 < n) {
            resource2 = iResourceArray[n2];
            ThrowingRunnable revertOperation = () -> resource2.revertModificationStamp(1L);
            if (resource2.getType() == 8) {
                revertOperation.run();
            } else {
                Assert.assertThrows(CoreException.class, (ThrowingRunnable)revertOperation);
            }
            ++n2;
        }
    }

    @Test
    public void testSetLocalTimeStamp() throws Exception {
        ResourcesPlugin.getWorkspace().getRoot().delete(true, true, ResourceTestUtil.createTestMonitor());
        interestingResources = this.buildInterestingResources();
        Long[] interestingTimes = new Long[]{-1L, System.currentTimeMillis() - 1000L, System.currentTimeMillis() - 100L, System.currentTimeMillis(), 0xFFFFFFFE00L};
        Object[][] inputs = new Object[][]{interestingResources, interestingTimes};
        new TestPerformer("IResourceTest.testRefreshLocal"){

            @Override
            public void cleanUp(Object[] args, int count) {
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws CoreException {
                IResource receiver = (IResource)args[0];
                long time = (Long)args[1];
                long actual = receiver.setLocalTimeStamp(time);
                return actual;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                long time = (Long)args[1];
                return time < 0L;
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) {
                IResource receiver = (IResource)args[0];
                if (receiver.getType() == 8) {
                    return true;
                }
                long time = (Long)args[1];
                long actual = (Long)result;
                if (actual != receiver.getLocalTimeStamp()) {
                    return false;
                }
                return Math.abs(actual - time) <= 2000L;
            }
        }.performTest(inputs);
    }

    @Test
    public void testTeamPrivateMember() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("Project");
        IFolder folder = project.getFolder("folder");
        IFile file = folder.getFile("target");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        Assert.assertFalse((String)"2.1.1", (boolean)root.isTeamPrivateMember());
        Assert.assertFalse((String)"2.1.2", (boolean)project.isTeamPrivateMember());
        Assert.assertFalse((String)"2.1.3", (boolean)folder.isTeamPrivateMember());
        Assert.assertFalse((String)"2.1.4", (boolean)file.isTeamPrivateMember());
        root.setTeamPrivateMember(true);
        Assert.assertFalse((String)"2.2.1", (boolean)root.isTeamPrivateMember());
        Assert.assertFalse((String)"2.2.2", (boolean)project.isTeamPrivateMember());
        Assert.assertFalse((String)"2.2.3", (boolean)folder.isTeamPrivateMember());
        Assert.assertFalse((String)"2.2.4", (boolean)file.isTeamPrivateMember());
        root.setTeamPrivateMember(false);
        Assert.assertFalse((String)"2.3.1", (boolean)root.isTeamPrivateMember());
        Assert.assertFalse((String)"2.3.2", (boolean)project.isTeamPrivateMember());
        Assert.assertFalse((String)"2.3.3", (boolean)folder.isTeamPrivateMember());
        Assert.assertFalse((String)"2.3.4", (boolean)file.isTeamPrivateMember());
        project.setTeamPrivateMember(true);
        Assert.assertFalse((String)"3.1.1", (boolean)root.isTeamPrivateMember());
        Assert.assertFalse((String)"3.1.2", (boolean)project.isTeamPrivateMember());
        Assert.assertFalse((String)"3.1.3", (boolean)folder.isTeamPrivateMember());
        Assert.assertFalse((String)"3.1.4", (boolean)file.isTeamPrivateMember());
        project.setTeamPrivateMember(false);
        Assert.assertFalse((String)"3.2.1", (boolean)root.isTeamPrivateMember());
        Assert.assertFalse((String)"3.2.2", (boolean)project.isTeamPrivateMember());
        Assert.assertFalse((String)"3.2.3", (boolean)folder.isTeamPrivateMember());
        Assert.assertFalse((String)"3.2.4", (boolean)file.isTeamPrivateMember());
        folder.setTeamPrivateMember(true);
        Assert.assertFalse((String)"4.1.1", (boolean)root.isTeamPrivateMember());
        Assert.assertFalse((String)"4.1.2", (boolean)project.isTeamPrivateMember());
        Assert.assertTrue((String)"4.1.3", (boolean)folder.isTeamPrivateMember());
        Assert.assertFalse((String)"4.1.4", (boolean)file.isTeamPrivateMember());
        folder.setTeamPrivateMember(false);
        Assert.assertFalse((String)"4.2.1", (boolean)root.isTeamPrivateMember());
        Assert.assertFalse((String)"4.2.2", (boolean)project.isTeamPrivateMember());
        Assert.assertFalse((String)"4.2.3", (boolean)folder.isTeamPrivateMember());
        Assert.assertFalse((String)"4.2.4", (boolean)file.isTeamPrivateMember());
        file.setTeamPrivateMember(true);
        Assert.assertFalse((String)"5.1.1", (boolean)root.isTeamPrivateMember());
        Assert.assertFalse((String)"5.1.2", (boolean)project.isTeamPrivateMember());
        Assert.assertFalse((String)"5.1.3", (boolean)folder.isTeamPrivateMember());
        Assert.assertTrue((String)"5.1.4", (boolean)file.isTeamPrivateMember());
        file.setTeamPrivateMember(false);
        Assert.assertFalse((String)"5.2.1", (boolean)root.isTeamPrivateMember());
        Assert.assertFalse((String)"5.2.2", (boolean)project.isTeamPrivateMember());
        Assert.assertFalse((String)"5.2.3", (boolean)folder.isTeamPrivateMember());
        Assert.assertFalse((String)"5.2.4", (boolean)file.isTeamPrivateMember());
        project.delete(true, ResourceTestUtil.createTestMonitor());
        Assert.assertFalse((String)"8.1", (boolean)project.isTeamPrivateMember());
        Assert.assertFalse((String)"8.2", (boolean)folder.isTeamPrivateMember());
        Assert.assertFalse((String)"8.3", (boolean)file.isTeamPrivateMember());
        Assert.assertThrows(CoreException.class, () -> project.setTeamPrivateMember(false));
        Assert.assertThrows(CoreException.class, () -> folder.setTeamPrivateMember(false));
        Assert.assertThrows(CoreException.class, () -> file.setTeamPrivateMember(false));
    }

    @Test
    public void testAcceptProxyVisitorAlphabetic() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("P");
        IFolder settings = project.getFolder(".settings");
        IFile prefs = settings.getFile("org.eclipse.core.resources.prefs");
        IFolder a = project.getFolder("a");
        IFile a1 = a.getFile("a1.txt");
        IFile a2 = a.getFile("a2.txt");
        IFolder b = a.getFolder("b");
        IFile b1 = b.getFile("b1.txt");
        IFile b2 = b.getFile("B2.txt");
        ResourceTestUtil.createInWorkspace(new IResource[]{project, settings, prefs, a, a1, a2, b, b1, b2});
        ArrayList actualOrder = new ArrayList();
        IResourceProxyVisitor visitor = proxy -> {
            actualOrder.add(proxy.requestResource());
            return true;
        };
        project.accept(visitor, 2, 0);
        List<IResource> expectedOrder = Arrays.asList(project, project.getFile(".project"), settings, prefs, a, a1, a2, b, b2, b1);
        Assert.assertEquals((String)"1.0", (Object)expectedOrder.toString(), (Object)((Object)actualOrder).toString());
    }

    private static class LogListener
    implements ILogListener {
        private final List<IStatus> errors = new ArrayList<IStatus>();

        private LogListener() {
        }

        public void logging(IStatus status, String plugin) {
            if (status.getSeverity() == 4) {
                this.errors.add(status);
            }
        }

        void assertNoLoggedErrors() {
            Assertions.assertThat(this.errors).isEmpty();
        }
    }

    private abstract class ProjectsReinitializingTestPerformer
    extends TestPerformer {
        private boolean reinitializeOnCleanup;

        public ProjectsReinitializingTestPerformer(String name) {
            super(name);
            this.reinitializeOnCleanup = false;
        }

        protected void reinitializeProjectsAfterTestIteration() {
            this.reinitializeOnCleanup = true;
        }

        @Override
        public void cleanUp(Object[] args, int countArg) throws Exception {
            if (this.reinitializeOnCleanup) {
                ResourceTestUtil.waitForBuild();
                ResourcesPlugin.getWorkspace().getRoot().delete(true, true, ResourceTestUtil.createTestMonitor());
                IResourceTest.this.initializeProjects();
                this.reinitializeOnCleanup = false;
            }
            super.cleanUp(args, countArg);
        }
    }
}

