/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Hashtable;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.SyncInfoReader;
import org.eclipse.core.internal.resources.Synchronizer;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ISynchronizerTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    public static int NUMBER_OF_PARTNERS = 100;
    public IResource[] resources;

    protected void flushAllSyncInfo(IResource root) throws CoreException {
        Assert.assertNotNull((Object)root);
        ISynchronizer synchronizer = ResourcesPlugin.getWorkspace().getSynchronizer();
        QualifiedName[] partners = synchronizer.getPartners();
        IWorkspaceRunnable body = monitor -> {
            IResourceVisitor visitor = resource -> {
                QualifiedName[] qualifiedNameArray2 = partners;
                int n = partners.length;
                int n2 = 0;
                while (n2 < n) {
                    QualifiedName partner = qualifiedNameArray2[n2];
                    synchronizer.setSyncInfo(partner, resource, null);
                    ++n2;
                }
                return true;
            };
            root.accept(visitor, 2, true);
        };
        ResourcesPlugin.getWorkspace().run(body, null);
    }

    @Before
    public void setUp() throws Exception {
        this.resources = ResourceTestUtil.buildResources((IContainer)ResourcesPlugin.getWorkspace().getRoot(), new String[]{"/", "1/", "1/1", "1/2/", "1/2/1", "1/2/2/", "2/", "2/1", "2/2/", "2/2/1", "2/2/2/"});
        ResourceTestUtil.createInWorkspace(this.resources);
    }

    @After
    public void tearDown() throws Exception {
        QualifiedName[] names;
        QualifiedName[] qualifiedNameArray = names = ResourcesPlugin.getWorkspace().getSynchronizer().getPartners();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            QualifiedName name = qualifiedNameArray[n2];
            ResourcesPlugin.getWorkspace().getSynchronizer().remove(name);
            ++n2;
        }
    }

    private void assertExpectedSyncInfo(IResource resource, byte[] actualSyncInfo, byte[] expectedSyncInfo) {
        if (resource.getType() == 8) {
            ((AbstractByteArrayAssert)Assertions.assertThat((byte[])actualSyncInfo).as("sync info for root resource: %s", new Object[]{resource.getFullPath()})).isNull();
            return;
        }
        ((AbstractByteArrayAssert)((AbstractByteArrayAssert)Assertions.assertThat((byte[])actualSyncInfo).as("sync info for non-root resource: %s", new Object[]{resource.getFullPath()})).isNotNull()).isEqualTo((Object)expectedSyncInfo);
    }

    @Test
    public void testDeleteResources() throws CoreException {
        QualifiedName qname = new QualifiedName("org.eclipse.core.tests.resources", "myTarget");
        ISynchronizer synchronizer = ResourcesPlugin.getWorkspace().getSynchronizer();
        synchronizer.add(qname);
        Hashtable table = new Hashtable(10);
        IResourceVisitor visitor = resource -> {
            if (resource.getType() == 8) {
                return true;
            }
            byte[] b = ResourceTestUtil.createRandomString().getBytes();
            table.put(resource.getFullPath(), b);
            synchronizer.setSyncInfo(qname, resource, b);
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
        visitor = resource -> {
            byte[] actual = synchronizer.getSyncInfo(qname, resource);
            byte[] expected = (byte[])table.get(resource.getFullPath());
            this.assertExpectedSyncInfo(resource, actual, expected);
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        IWorkspaceRunnable body = monitor -> {
            IProject[] iProjectArray2 = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IResource[] children;
                IProject project = iProjectArray2[n2];
                IResource[] iResourceArray = children = project.members();
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResource element = iResourceArray[n4];
                    element.delete(false, ResourceTestUtil.createTestMonitor());
                    ++n4;
                }
                ++n2;
            }
        };
        ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
        visitor = resource -> {
            byte[] actual = synchronizer.getSyncInfo(qname, resource);
            byte[] expected = (byte[])table.get(resource.getFullPath());
            this.assertExpectedSyncInfo(resource, actual, expected);
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            project.delete(false, ResourceTestUtil.createTestMonitor());
            ++n2;
        }
        visitor = resource -> {
            Assert.assertNull((String)resource.getFullPath().toString(), (Object)synchronizer.getSyncInfo(qname, resource));
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
    }

    @Test
    public void testDeleteResources2() throws CoreException {
        QualifiedName qname = new QualifiedName("org.eclipse.core.tests.resources", "myTarget");
        ISynchronizer synchronizer = ResourcesPlugin.getWorkspace().getSynchronizer();
        synchronizer.add(qname);
        Hashtable table = new Hashtable(10);
        IResourceVisitor visitor = resource -> {
            if (resource.getType() == 8) {
                return true;
            }
            byte[] b = ResourceTestUtil.createRandomString().getBytes();
            table.put(resource.getFullPath(), b);
            synchronizer.setSyncInfo(qname, resource, b);
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
        visitor = resource -> {
            byte[] actual = synchronizer.getSyncInfo(qname, resource);
            byte[] expected = (byte[])table.get(resource.getFullPath());
            this.assertExpectedSyncInfo(resource, actual, expected);
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        IWorkspaceRunnable body = monitor -> {
            IProject[] iProjectArray2 = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray2[n2];
                IResource[] iResourceArray = project.members();
                int n3 = iResourceArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResource element = iResourceArray[n4];
                    if (!element.getName().equals(".project")) {
                        element.delete(false, ResourceTestUtil.createTestMonitor());
                    }
                    ++n4;
                }
                ++n2;
            }
        };
        ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
        visitor = resource -> {
            byte[] actual = synchronizer.getSyncInfo(qname, resource);
            byte[] expected = (byte[])table.get(resource.getFullPath());
            this.assertExpectedSyncInfo(resource, actual, expected);
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
        body = monitor -> {
            IProject[] iProjectArray2 = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray2[n2];
                IResource[] iResourceArray = project.members(true);
                int n3 = iResourceArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResource element = iResourceArray[n4];
                    synchronizer.setSyncInfo(qname, element, null);
                    ++n4;
                }
                ++n2;
            }
        };
        ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
        visitor = resource -> {
            int type = resource.getType();
            if (type == 8 || type == 4) {
                return true;
            }
            if (type == 1 && resource.getParent().getType() == 4 && resource.getName().equals(".project")) {
                return true;
            }
            Assert.assertNull((String)("5.0." + String.valueOf(resource.getFullPath())), (Object)synchronizer.getSyncInfo(qname, resource));
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor, 2, true);
    }

    @Test
    public void testMoveResource() throws CoreException {
        QualifiedName qname = new QualifiedName("org.eclipse.core.tests.resources", "myTarget");
        ISynchronizer synchronizer = ResourcesPlugin.getWorkspace().getSynchronizer();
        ResourcesPlugin.getWorkspace().getRoot().delete(true, ResourceTestUtil.createTestMonitor());
        IResource[] testResources = ResourceTestUtil.buildResources((IContainer)ResourcesPlugin.getWorkspace().getRoot(), new String[]{"/Foo", "/Foo/file.txt"});
        IProject project = (IProject)testResources[0];
        IFile source = (IFile)testResources[1];
        ResourceTestUtil.createInWorkspace(testResources);
        synchronizer.add(qname);
        byte[] b = new byte[]{1, 2, 3, 4};
        synchronizer.setSyncInfo(qname, (IResource)source, b);
        IFile destination = project.getFile("newFile.txt");
        source.move(destination.getFullPath(), true, ResourceTestUtil.createTestMonitor());
        byte[] syncInfo = synchronizer.getSyncInfo(qname, (IResource)source);
        ((AbstractByteArrayAssert)((AbstractByteArrayAssert)Assertions.assertThat((byte[])syncInfo).as("sync info at source: %s", new Object[]{source.getFullPath()})).isNotNull()).isEqualTo((Object)b);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])synchronizer.getSyncInfo(qname, (IResource)destination)).as("sync info at destination: %s", new Object[]{destination.getFullPath()})).isNull();
    }

    @Test
    public void testMoveResource2() throws CoreException {
        QualifiedName qname = new QualifiedName("org.eclipse.core.tests.resources", "myTarget");
        ISynchronizer synchronizer = ResourcesPlugin.getWorkspace().getSynchronizer();
        ResourcesPlugin.getWorkspace().getRoot().delete(true, ResourceTestUtil.createTestMonitor());
        IResource[] toTest = ResourceTestUtil.buildResources((IContainer)ResourcesPlugin.getWorkspace().getRoot(), new String[]{"/Foo", "/Foo/file.txt"});
        IProject sourceProject = (IProject)toTest[0];
        IFile sourceFile = (IFile)toTest[1];
        ResourceTestUtil.createInWorkspace(toTest);
        synchronizer.add(qname);
        byte[] b = new byte[]{1, 2, 3, 4};
        synchronizer.setSyncInfo(qname, (IResource)sourceProject, b);
        synchronizer.setSyncInfo(qname, (IResource)sourceFile, b);
        IFile destFile = sourceProject.getFile("newFile.txt");
        sourceFile.move(destFile.getFullPath(), true, ResourceTestUtil.createTestMonitor());
        byte[] syncInfo = synchronizer.getSyncInfo(qname, (IResource)sourceFile);
        ((AbstractByteArrayAssert)((AbstractByteArrayAssert)((AbstractByteArrayAssert)Assertions.assertThat((byte[])syncInfo).as("sync info at source: %s", new Object[]{sourceFile.getFullPath()})).isNotNull()).isNotNull()).isEqualTo((Object)b);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])synchronizer.getSyncInfo(qname, (IResource)destFile)).as("sync info at destination: %s", new Object[]{destFile.getFullPath()})).isNull();
        destFile.move(sourceFile.getFullPath(), true, ResourceTestUtil.createTestMonitor());
        syncInfo = synchronizer.getSyncInfo(qname, (IResource)sourceFile);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])syncInfo).as("sync info at source: %s", new Object[]{sourceFile.getFullPath()})).isEqualTo((Object)b);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])synchronizer.getSyncInfo(qname, (IResource)destFile)).as("sync info at destination: %s", new Object[]{destFile.getFullPath()})).isNull();
        IProject destProject = ResourcesPlugin.getWorkspace().getRoot().getProject("newProject");
        sourceProject.move(destProject.getFullPath(), true, ResourceTestUtil.createTestMonitor());
        Assert.assertNull((String)"7.1", (Object)synchronizer.getSyncInfo(qname, (IResource)sourceProject));
        Assert.assertNull((String)"7.2", (Object)synchronizer.getSyncInfo(qname, (IResource)sourceFile));
        syncInfo = synchronizer.getSyncInfo(qname, (IResource)destProject.getFile(sourceFile.getName()));
        ((AbstractByteArrayAssert)((AbstractByteArrayAssert)Assertions.assertThat((byte[])syncInfo).as("sync info for resource: %s", new Object[]{sourceFile.getFullPath()})).isNotNull()).isEqualTo((Object)b);
        syncInfo = synchronizer.getSyncInfo(qname, (IResource)destProject);
        ((AbstractByteArrayAssert)((AbstractByteArrayAssert)Assertions.assertThat((byte[])syncInfo).as("sync info for resource: %s", new Object[]{sourceFile.getFullPath()})).isNotNull()).isEqualTo((Object)b);
    }

    @Test
    public void testRegistration() {
        QualifiedName[] partners = new QualifiedName[NUMBER_OF_PARTNERS];
        int i = 0;
        while (i < NUMBER_OF_PARTNERS) {
            QualifiedName name;
            partners[i] = name = new QualifiedName("org.eclipse.core.deployment", "myTarget" + i);
            ++i;
        }
        ISynchronizer synchronizer = ResourcesPlugin.getWorkspace().getSynchronizer();
        int i2 = 0;
        while (i2 < NUMBER_OF_PARTNERS) {
            synchronizer.add(partners[i2]);
            synchronizer.add(partners[i2]);
            ++i2;
        }
        Object[] list = synchronizer.getPartners();
        Assertions.assertThat((Object[])list).hasSize(NUMBER_OF_PARTNERS);
        int i3 = 0;
        while (i3 < NUMBER_OF_PARTNERS) {
            synchronizer.remove(partners[i3]);
            ++i3;
        }
        Assertions.assertThat((Object[])synchronizer.getPartners()).isEmpty();
    }

    @Test
    public void testSave() throws Exception {
        Object var11_17;
        Throwable throwable;
        Hashtable table = new Hashtable(10);
        QualifiedName qname = new QualifiedName("org.eclipse.core.tests.resources", "myTarget");
        Synchronizer synchronizer = (Synchronizer)ResourcesPlugin.getWorkspace().getSynchronizer();
        synchronizer.add(qname);
        IResourceVisitor visitor = resource -> {
            if (resource.getType() == 8) {
                return true;
            }
            byte[] b = ResourceTestUtil.createRandomString().getBytes();
            synchronizer.setSyncInfo(qname, resource, b);
            table.put(resource.getFullPath(), b);
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
        IPath syncInfoPath = Platform.getLocation().append(".testsyncinfo");
        File file = syncInfoPath.toFile();
        this.workspaceRule.deleteOnTearDown(syncInfoPath);
        Throwable throwable2 = null;
        Object var8_10 = null;
        try (FileOutputStream fileOutput = new FileOutputStream(file);){
            throwable = null;
            var11_17 = null;
            try (DataOutputStream output = new DataOutputStream(fileOutput);){
                ArrayList list = new ArrayList(5);
                visitor = resource -> {
                    ResourceInfo info = ((Resource)resource).getResourceInfo(false, false);
                    if (info == null) {
                        return true;
                    }
                    IPathRequestor requestor = new IPathRequestor(){

                        public IPath requestPath() {
                            return resource.getFullPath();
                        }

                        public String requestName() {
                            return resource.getName();
                        }
                    };
                    try {
                        synchronizer.saveSyncInfo(info, requestor, output, list);
                    }
                    catch (IOException e) {
                        CoreException wrappedException = new CoreException((IStatus)new Status(4, "org.eclipse.core.tests.resources", "Could not save sync info"));
                        wrappedException.addSuppressed((Throwable)e);
                        throw wrappedException;
                    }
                    return true;
                };
                ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        this.flushAllSyncInfo((IResource)ResourcesPlugin.getWorkspace().getRoot());
        throwable2 = null;
        var8_10 = null;
        try (InputStream fileInput = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            throwable = null;
            var11_17 = null;
            try (DataInputStream input = new DataInputStream(fileInput);){
                IWorkspaceRunnable body = monitor -> {
                    SyncInfoReader reader = new SyncInfoReader((Workspace)ResourcesPlugin.getWorkspace(), synchronizer);
                    try {
                        reader.readSyncInfo(input);
                    }
                    catch (IOException e) {
                        CoreException wrappedException = new CoreException((IStatus)new Status(4, "org.eclipse.core.tests.resources", "Could not read sync info"));
                        wrappedException.addSuppressed((Throwable)e);
                        throw wrappedException;
                    }
                };
                ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable6) {
            if (throwable2 == null) {
                throwable2 = throwable6;
            } else if (throwable2 != throwable6) {
                throwable2.addSuppressed(throwable6);
            }
            throw throwable2;
        }
        visitor = resource -> {
            byte[] actual = synchronizer.getSyncInfo(qname, resource);
            byte[] expected = (byte[])table.get(resource.getFullPath());
            this.assertExpectedSyncInfo(resource, actual, expected);
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
    }

    @Test
    public void testSnap() {
    }

    @Test
    public void testSyncInfo() throws CoreException {
        QualifiedName qname = new QualifiedName("org.eclipse.core.tests.resources", "myTarget");
        ISynchronizer synchronizer = ResourcesPlugin.getWorkspace().getSynchronizer();
        Hashtable table = new Hashtable(10);
        IResourceVisitor visitor = resource -> {
            if (resource.getType() == 8) {
                return true;
            }
            byte[] b = ResourceTestUtil.createRandomString().getBytes();
            table.put(resource.getFullPath(), b);
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
        visitor = resource -> {
            if (resource.getType() == 8) {
                return true;
            }
            Assert.assertThrows(CoreException.class, () -> synchronizer.setSyncInfo(qname, resource, (byte[])table.get(resource.getFullPath())));
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
        visitor = resource -> {
            Assert.assertThrows(CoreException.class, () -> {
                byte[] byArray = synchronizer.getSyncInfo(qname, resource);
            });
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
        synchronizer.add(qname);
        visitor = resource -> {
            byte[] actual = synchronizer.getSyncInfo(qname, resource);
            Assert.assertNull((String)("3.0." + String.valueOf(resource.getFullPath())), (Object)actual);
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
        visitor = resource -> {
            synchronizer.setSyncInfo(qname, resource, (byte[])table.get(resource.getFullPath()));
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
        visitor = resource -> {
            byte[] actual = synchronizer.getSyncInfo(qname, resource);
            byte[] expected = (byte[])table.get(resource.getFullPath());
            this.assertExpectedSyncInfo(resource, actual, expected);
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
        visitor = resource -> {
            if (resource.getType() == 8) {
                return true;
            }
            byte[] b = ResourceTestUtil.createRandomString().getBytes();
            synchronizer.setSyncInfo(qname, resource, b);
            table.put(resource.getFullPath(), b);
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
        visitor = resource -> {
            byte[] actual = synchronizer.getSyncInfo(qname, resource);
            byte[] expected = (byte[])table.get(resource.getFullPath());
            this.assertExpectedSyncInfo(resource, actual, expected);
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
        synchronizer.remove(qname);
        visitor = resource -> {
            Assert.assertThrows(CoreException.class, () -> {
                byte[] byArray = synchronizer.getSyncInfo(qname, resource);
            });
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
    }

    @Test
    public void testPhantomRemoval() throws CoreException {
        QualifiedName partner = new QualifiedName("org.eclipse.core.tests.resources", "myTarget");
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ISynchronizer synchronizer = workspace.getSynchronizer();
        synchronizer.add(partner);
        IProject project = workspace.getRoot().getProject("MyProject");
        IFolder folder = project.getFolder("foo");
        IFile file1 = folder.getFile("file1.txt");
        IFile file2 = folder.getFile("file2.txt");
        ResourceTestUtil.createInWorkspace(new IResource[]{file1, file2});
        synchronizer.setSyncInfo(partner, (IResource)folder, ResourceTestUtil.createRandomString().getBytes());
        synchronizer.setSyncInfo(partner, (IResource)file1, ResourceTestUtil.createRandomString().getBytes());
        synchronizer.setSyncInfo(partner, (IResource)file2, ResourceTestUtil.createRandomString().getBytes());
        Assert.assertTrue((String)"1.1", (boolean)file1.exists());
        Assert.assertTrue((String)"1.2", (!file1.isPhantom() ? 1 : 0) != 0);
        file1.delete(true, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.1", (!file1.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.2", (boolean)file1.isPhantom());
        synchronizer.setSyncInfo(partner, (IResource)file1, null);
        Assert.assertTrue((String)"3.1", (!file1.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"3.2", (!file1.isPhantom() ? 1 : 0) != 0);
        Assert.assertTrue((String)"4.1", (boolean)folder.exists());
        Assert.assertTrue((String)"4.2", (!folder.isPhantom() ? 1 : 0) != 0);
        Assert.assertTrue((String)"4.3", (boolean)file2.exists());
        Assert.assertTrue((String)"4.4", (!file2.isPhantom() ? 1 : 0) != 0);
        folder.delete(true, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"5.1", (!folder.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"5.2", (boolean)folder.isPhantom());
        Assert.assertTrue((String)"5.3", (!file2.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"5.4", (boolean)file2.isPhantom());
        synchronizer.setSyncInfo(partner, (IResource)folder, null);
        Assert.assertTrue((String)"6.1", (!folder.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"6.2", (!folder.isPhantom() ? 1 : 0) != 0);
        Assert.assertTrue((String)"6.3", (!file2.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"6.4", (!file2.isPhantom() ? 1 : 0) != 0);
        synchronizer.remove(partner);
        ResourceTestUtil.removeFromWorkspace((IResource)project);
    }
}

