/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.internal.filesystem.wrapper.WrapperFileSystem;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;

public class IWorkspaceRootTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    @Test
    public void testFindFilesNonCanonicalPath() throws Exception {
        Assume.assumeTrue((String)"only relevant on Windows", (boolean)Platform.OS.isWindows());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("testFindFilesNonCanonicalPath");
        ResourceTestUtil.createInWorkspace((IResource)project);
        IFile link = project.getFile("file.txt");
        IFileStore fileStore = this.workspaceRule.getTempStore();
        ResourceTestUtil.createInFileSystem(fileStore);
        Assert.assertEquals((String)"0.1", (Object)"file", (Object)fileStore.getFileSystem().getScheme());
        IPath fileLocationLower = URIUtil.toPath((URI)fileStore.toURI());
        fileLocationLower = fileLocationLower.setDevice(fileLocationLower.getDevice().toLowerCase());
        IPath fileLocationUpper = fileLocationLower.setDevice(fileLocationLower.getDevice().toUpperCase());
        link.createLink(fileLocationLower, 0, ResourceTestUtil.createTestMonitor());
        Object[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(fileLocationUpper);
        Assertions.assertThat((Object[])files).containsExactly((Object[])new IFile[]{link});
    }

    @Test
    public void testFindContainersForLocation() throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject p1 = root.getProject("p1");
        IProject p2 = root.getProject("p2");
        this.testFindContainersForLocation(p1, p2);
    }

    private void replaceProject(IProject project, URI newLocation) throws CoreException {
        IProjectDescription projectDesc = project.getDescription();
        projectDesc.setLocationURI(newLocation);
        project.move(projectDesc, 256, null);
    }

    @Test
    public void testFindContainersForLocationOnWrappedFileSystem() throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject p1 = root.getProject("p1");
        IProject p2 = root.getProject("p2");
        ResourceTestUtil.createInWorkspace(new IResource[]{p1, p2});
        this.replaceProject(p1, WrapperFileSystem.getWrappedURI(p1.getLocationURI()));
        this.replaceProject(p2, WrapperFileSystem.getWrappedURI(p2.getLocationURI()));
        this.testFindContainersForLocation(p1, p2);
    }

    private void testFindContainersForLocation(IProject p1, IProject p2) throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Object[] result = root.findContainersForLocation(root.getLocation());
        Assertions.assertThat((Object[])result).containsExactly((Object[])new IContainer[]{root});
        IFolder parent = p2.getFolder("parent");
        IFolder link = parent.getFolder("link");
        ResourceTestUtil.createInWorkspace(new IResource[]{p1, p2, parent});
        link.createLink(p1.getLocationURI(), 0, ResourceTestUtil.createTestMonitor());
        this.assertResources("2.0", (IResource)p1, (IResource)link, (IResource[])root.findContainersForLocation(p1.getLocation()));
        IFolder existing = p2.getFolder("existing");
        ResourceTestUtil.createInWorkspace((IResource)existing);
        this.assertResources("3.0", (IResource)existing, (IResource[])root.findContainersForLocation(existing.getLocation()));
        this.assertResources("3.1", (IResource)existing, (IResource[])root.findContainersForLocationURI(existing.getLocationURI()));
        IFolder nonExisting = p2.getFolder("nonExisting");
        this.assertResources("3.2", (IResource)nonExisting, (IResource[])root.findContainersForLocation(nonExisting.getLocation()));
        this.assertResources("3.3", (IResource)nonExisting, (IResource[])root.findContainersForLocationURI(nonExisting.getLocationURI()));
        this.assertResources("3.4", (IResource)existing, (IResource[])root.findContainersForLocation(existing.getLocation().makeRelative()));
        this.assertResources("3.5", (IResource)nonExisting, (IResource[])root.findContainersForLocation(nonExisting.getLocation().makeRelative()));
        URI relative = new URI(null, "hello", null);
        Assert.assertThrows(RuntimeException.class, () -> {
            IContainer[] iContainerArray = root.findContainersForLocationURI(relative);
        });
        IFolder otherLink = p1.getFolder("otherLink");
        IFileStore linkStore = this.workspaceRule.getTempStore();
        URI location = linkStore.toURI();
        linkStore.mkdir(0, ResourceTestUtil.createTestMonitor());
        otherLink.createLink(location, 0, ResourceTestUtil.createTestMonitor());
        result = root.findContainersForLocationURI(location);
        this.assertResources("5.1", (IResource)otherLink, (IResource[])result);
        IFolder child = otherLink.getFolder("link-child");
        URI childLocation = linkStore.getChild(child.getName()).toURI();
        result = root.findContainersForLocationURI(childLocation);
        this.assertResources("5.1", (IResource)child, (IResource[])result);
    }

    @Test
    public void testFindFilesForLocationOnWrappedFileSystem() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("p1");
        ResourceTestUtil.createInWorkspace((IResource)project);
        this.replaceProject(project, WrapperFileSystem.getWrappedURI(project.getLocationURI()));
        this.testFindFilesForLocation(project);
    }

    @Test
    public void testFindFilesForLocation() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.testFindFilesForLocation(root.getProject("p1"));
    }

    private void testFindFilesForLocation(IProject project) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Object[] result = root.findFilesForLocation(root.getLocation());
        Assertions.assertThat((Object[])result).isEmpty();
        IFile existing = project.getFile("file1");
        ResourceTestUtil.createInWorkspace((IResource)existing);
        IPath existingFileLocation = existing.getLocation();
        result = root.findFilesForLocation(existingFileLocation);
        this.assertResources("2.0", (IResource)existing, (IResource[])result);
        result = root.findFilesForLocationURI(existing.getLocationURI());
        this.assertResources("2.1", (IResource)existing, (IResource[])result);
        IFile nonExisting = project.getFile("nonExisting");
        result = root.findFilesForLocation(nonExisting.getLocation());
        this.assertResources("3.1", (IResource)nonExisting, (IResource[])result);
        result = root.findFilesForLocationURI(nonExisting.getLocationURI());
        this.assertResources("3.2", (IResource)nonExisting, (IResource[])result);
        result = root.findFilesForLocation(existingFileLocation.makeRelative());
        this.assertResources("4.0", (IResource)existing, (IResource[])result);
        result = root.findFilesForLocation(nonExisting.getLocation().makeRelative());
        this.assertResources("4.1", (IResource)nonExisting, (IResource[])result);
        if (!Workspace.caseSensitive) {
            IPath differentCase = IPath.fromOSString((String)existingFileLocation.toOSString().toUpperCase());
            result = root.findFilesForLocation(differentCase);
            this.assertResources("5.0", (IResource)existing, (IResource[])result);
            result = root.findFilesForLocationURI(existing.getLocationURI());
            this.assertResources("5.1", (IResource)existing, (IResource[])result);
        }
        IFolder link = project.getFolder("link");
        IFileStore linkStore = this.workspaceRule.getTempStore();
        URI location = linkStore.toURI();
        linkStore.mkdir(0, ResourceTestUtil.createTestMonitor());
        link.createLink(location, 0, ResourceTestUtil.createTestMonitor());
        IFile child = link.getFile("link-child.txt");
        URI childLocation = linkStore.getChild(child.getName()).toURI();
        result = root.findFilesForLocationURI(childLocation);
        this.assertResources("2.1", (IResource)child, (IResource[])result);
    }

    private void assertResources(String message, IResource expected, IResource[] actual) {
        ((ObjectArrayAssert)Assertions.assertThat((Object[])actual).describedAs(message, new Object[0])).containsExactly((Object[])new IResource[]{expected});
    }

    private void assertResources(String message, IResource expected0, IResource expected1, IResource[] actual) {
        ((ObjectArrayAssert)Assertions.assertThat((Object[])actual).describedAs(message, new Object[0])).containsExactlyInAnyOrder((Object[])new IResource[]{expected0, expected1});
    }

    @Test
    public void testGetContainerForLocation() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Assert.assertEquals((String)"1.0", (Object)root, (Object)root.getContainerForLocation(root.getLocation()));
    }

    @Test
    public void testGetFile() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFile(IPath.fromOSString((String)"//P1/a.txt"));
        Assert.assertTrue((String)"1.0", (!file.getFullPath().isUNC() ? 1 : 0) != 0);
    }

    @Test
    public void testGetFileForLocation() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Assert.assertTrue((String)"1.0", (root.getFileForLocation(root.getLocation()) == null ? 1 : 0) != 0);
    }

    @Test
    public void testPersistentProperty() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String value = "this is a test property value";
        QualifiedName name = new QualifiedName("test", "testProperty");
        root.setPersistentProperty(name, value);
        String storedValue = root.getPersistentProperty(name);
        Assert.assertEquals((String)"2.0", (Object)value, (Object)storedValue);
        name = new QualifiedName("test", "testNonProperty");
        storedValue = root.getPersistentProperty(name);
        Assert.assertEquals((String)"3.0", null, (Object)storedValue);
    }

    @Test
    public void testPersistentPropertyInRunnable() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String value = "this is a test property value";
        QualifiedName name = new QualifiedName("test", "testProperty");
        ResourcesPlugin.getWorkspace().run(monitor -> root.setPersistentProperty(name, "this is a test property value"), ResourceTestUtil.createTestMonitor());
        String[] storedValue = new String[1];
        ResourcesPlugin.getWorkspace().run(monitor -> {
            String string = root.getPersistentProperty(name);
        }, ResourceTestUtil.createTestMonitor());
        Assert.assertEquals((String)"2.0", (Object)"this is a test property value", (Object)storedValue[0]);
        QualifiedName name2 = new QualifiedName("test", "testNonProperty");
        String[] changedStoredValue = new String[1];
        ResourcesPlugin.getWorkspace().run(monitor -> {
            String string = root.getPersistentProperty(name2);
        }, ResourceTestUtil.createTestMonitor());
        Assert.assertEquals((String)"3.0", null, (Object)changedStoredValue[0]);
    }

    @Test
    public void testRefreshLocal() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        project.close(ResourceTestUtil.createTestMonitor());
        root.refreshLocal(2, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testBug234343_folderInHiddenProject() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject hiddenProject = root.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.removeFromWorkspace((IResource)hiddenProject);
        hiddenProject.create(null, 4096, ResourceTestUtil.createTestMonitor());
        hiddenProject.open(ResourceTestUtil.createTestMonitor());
        IFolder folder = hiddenProject.getFolder("foo");
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        Object[] containers = root.findContainersForLocationURI(folder.getLocationURI());
        Assertions.assertThat((Object[])containers).isEmpty();
        containers = root.findContainersForLocationURI(folder.getLocationURI(), 8);
        Assertions.assertThat((Object[])containers).hasSize(1);
    }

    @Test
    public void testBug234343_fileInHiddenProject() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject hiddenProject = root.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.removeFromWorkspace((IResource)hiddenProject);
        hiddenProject.create(null, 4096, ResourceTestUtil.createTestMonitor());
        hiddenProject.open(ResourceTestUtil.createTestMonitor());
        IFile file = hiddenProject.getFile("foo");
        file.create((InputStream)new ByteArrayInputStream("foo".getBytes()), true, ResourceTestUtil.createTestMonitor());
        Object[] files = root.findFilesForLocationURI(file.getLocationURI());
        Assertions.assertThat((Object[])files).isEmpty();
        files = root.findFilesForLocationURI(file.getLocationURI(), 8);
        Assertions.assertThat((Object[])files).hasSize(1);
        Object[] containers = root.findContainersForLocationURI(file.getLocationURI());
        Assertions.assertThat((Object[])containers).isEmpty();
        containers = root.findContainersForLocationURI(file.getLocationURI(), 8);
        Assertions.assertThat((Object[])containers).hasSize(1);
    }

    @Test
    public void testBug476585() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("a");
        ResourceTestUtil.createInWorkspace((IResource)project);
        String subProjectName = "subProject";
        IPath subProjectLocation = project.getLocation().append(subProjectName);
        IPath fileLocation = subProjectLocation.append("file.txt");
        IFile file = root.getFileForLocation(fileLocation);
        Assert.assertEquals((String)"1.0", (Object)project, (Object)file.getProject());
        IPath containerLocation = subProjectLocation.append("folder");
        IContainer container = root.getContainerForLocation(containerLocation);
        Assert.assertEquals((String)"1.1", (Object)project, (Object)container.getProject());
        IProject subProject = root.getProject(subProjectName);
        IProjectDescription newProjectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(subProjectName);
        newProjectDescription.setLocation(subProjectLocation);
        subProject.create(newProjectDescription, ResourceTestUtil.createTestMonitor());
        file = root.getFileForLocation(fileLocation);
        Assert.assertNotNull((String)"2.0", (Object)file);
        Assert.assertEquals((String)"2.1", (Object)subProject, (Object)file.getProject());
        container = root.getContainerForLocation(containerLocation);
        Assert.assertNotNull((String)"2.2", (Object)container);
        Assert.assertEquals((String)"2.3", (Object)subProject, (Object)container.getProject());
    }

    @Test
    public void testFindMethodsWithHiddenAndTeamPrivateFlags() throws Exception {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[16];
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 1;
        nArray[9] = 1;
        nArray[10] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[16];
        nArray2[0] = 8;
        nArray2[1] = 1;
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[6] = 1;
        nArray2[7] = 1;
        nArray2[8] = 1;
        nArray2[9] = 1;
        nArray2[10] = 1;
        nArrayArray[1] = nArray2;
        nArrayArray[2] = new int[]{10, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int[] nArray3 = new int[16];
        nArray3[0] = 2;
        nArray3[6] = 1;
        nArray3[7] = 1;
        nArray3[8] = 1;
        nArray3[9] = 1;
        nArray3[10] = 1;
        nArray3[11] = 1;
        nArray3[12] = 1;
        nArray3[13] = 1;
        nArray3[14] = 1;
        nArray3[15] = 1;
        nArrayArray[3] = nArray3;
        this.checkFindMethods(0, nArrayArray);
        int[][] nArrayArray2 = new int[4][];
        int[] nArray4 = new int[16];
        nArray4[6] = 1;
        nArrayArray2[0] = nArray4;
        int[] nArray5 = new int[16];
        nArray5[0] = 8;
        nArray5[1] = 1;
        nArray5[2] = 1;
        nArray5[3] = 1;
        nArray5[4] = 1;
        nArray5[5] = 1;
        nArray5[6] = 1;
        nArray5[7] = 1;
        nArray5[8] = 1;
        nArray5[9] = 1;
        nArray5[10] = 1;
        nArrayArray2[1] = nArray5;
        nArrayArray2[2] = new int[]{10, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int[] nArray6 = new int[16];
        nArray6[0] = 2;
        nArray6[6] = 1;
        nArray6[11] = 1;
        nArrayArray2[3] = nArray6;
        this.checkFindMethods(4096, nArrayArray2);
        int[][] nArrayArray3 = new int[4][];
        int[] nArray7 = new int[16];
        nArray7[6] = 1;
        nArrayArray3[0] = nArray7;
        int[] nArray8 = new int[16];
        nArray8[0] = 8;
        nArray8[1] = 1;
        nArray8[6] = 1;
        nArrayArray3[1] = nArray8;
        nArrayArray3[2] = new int[]{10, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int[] nArray9 = new int[16];
        nArray9[0] = 2;
        nArray9[6] = 1;
        nArray9[7] = 1;
        nArray9[8] = 1;
        nArray9[9] = 1;
        nArray9[10] = 1;
        nArray9[11] = 1;
        nArray9[12] = 1;
        nArray9[13] = 1;
        nArray9[14] = 1;
        nArray9[15] = 1;
        nArrayArray3[3] = nArray9;
        this.checkFindMethods(2048, nArrayArray3);
        int[][] nArrayArray4 = new int[4][];
        int[] nArray10 = new int[16];
        nArray10[6] = 1;
        nArrayArray4[0] = nArray10;
        int[] nArray11 = new int[16];
        nArray11[0] = 8;
        nArray11[1] = 1;
        nArray11[6] = 1;
        nArrayArray4[1] = nArray11;
        nArrayArray4[2] = new int[]{10, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int[] nArray12 = new int[16];
        nArray12[0] = 2;
        nArray12[6] = 1;
        nArray12[11] = 1;
        nArrayArray4[3] = nArray12;
        this.checkFindMethods(6144, nArrayArray4);
    }

    public void checkFindMethods(int updateFlags, int[][] results) throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.removeFromWorkspace((IResource)project);
        project.create(null, 0, ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IFolder teamFolder = this.createFolder((IContainer)project, 2048, false);
        IFile mFileInTeamFolder = this.createFile((IContainer)teamFolder, updateFlags, false);
        IFile mLinkedFileInTeamFolder = this.createFile((IContainer)teamFolder, updateFlags, true);
        IFolder mFolderInTeamFolder = this.createFolder((IContainer)teamFolder, updateFlags, false);
        IFolder mLinkedFolderInTeamFolder = this.createFolder((IContainer)teamFolder, updateFlags, true);
        IFolder hiddenFolder = this.createFolder((IContainer)project, 4096, false);
        IFile mFileInHiddenFolder = this.createFile((IContainer)hiddenFolder, updateFlags, false);
        IFile mLinkedFileInHiddenFolder = this.createFile((IContainer)hiddenFolder, updateFlags, true);
        IFolder mFolderInHiddenFolder = this.createFolder((IContainer)hiddenFolder, updateFlags, false);
        IFolder mLinkedFolderInHiddenFolder = this.createFolder((IContainer)hiddenFolder, updateFlags, true);
        IFolder folder = this.createFolder((IContainer)project, 0, false);
        IFile mFileInFolder = this.createFile((IContainer)folder, updateFlags, false);
        IFile mLinkedFileInFolder = this.createFile((IContainer)folder, updateFlags, true);
        IFolder mFolderInFolder = this.createFolder((IContainer)folder, updateFlags, false);
        IFolder mLinkedFolderInFolder = this.createFolder((IContainer)folder, updateFlags, true);
        int[][] nArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            int[] result = nArray[n2];
            this.checkFindContainers(hiddenFolder.getLocationURI(), result[0], result[1]);
            this.checkFindFiles(mFileInHiddenFolder.getLocationURI(), result[0], result[4]);
            this.checkFindFiles(mLinkedFileInHiddenFolder.getLocationURI(), result[0], result[5]);
            this.checkFindContainers(mFolderInHiddenFolder.getLocationURI(), result[0], result[2]);
            this.checkFindContainers(mLinkedFolderInHiddenFolder.getLocationURI(), result[0], result[3]);
            this.checkFindContainers(folder.getLocationURI(), result[0], result[6]);
            this.checkFindFiles(mFileInFolder.getLocationURI(), result[0], result[7]);
            this.checkFindFiles(mLinkedFileInFolder.getLocationURI(), result[0], result[8]);
            this.checkFindContainers(mFolderInFolder.getLocationURI(), result[0], result[9]);
            this.checkFindContainers(mLinkedFolderInFolder.getLocationURI(), result[0], result[10]);
            this.checkFindContainers(teamFolder.getLocationURI(), result[0], result[11]);
            this.checkFindFiles(mFileInTeamFolder.getLocationURI(), result[0], result[12]);
            this.checkFindFiles(mLinkedFileInTeamFolder.getLocationURI(), result[0], result[13]);
            this.checkFindContainers(mFolderInTeamFolder.getLocationURI(), result[0], result[14]);
            this.checkFindContainers(mLinkedFolderInTeamFolder.getLocationURI(), result[0], result[15]);
            ++n2;
        }
    }

    private void checkFindFiles(URI location, int memberFlags, int foundResources) {
        Object[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(location, memberFlags);
        Assertions.assertThat((Object[])files).hasSize(foundResources);
    }

    private void checkFindContainers(URI location, int memberFlags, int foundResources) {
        Object[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(location, memberFlags);
        Assertions.assertThat((Object[])containers).hasSize(foundResources);
    }

    private IFile createFile(IContainer parent, int updateFlags, boolean linked) throws Exception {
        IFile file = parent.getFile(IPath.fromOSString((String)ResourceTestUtil.createUniqueString()));
        if (linked) {
            IPath path = FileSystemHelper.getTempDir().append(ResourceTestUtil.createUniqueString());
            path.toFile().createNewFile();
            file.createLink(URIUtil.toURI((IPath)path), updateFlags, ResourceTestUtil.createTestMonitor());
            if ((updateFlags & 0x800) == 2048) {
                file.setTeamPrivateMember(true);
            }
        } else {
            file.create("content".getBytes(), updateFlags, ResourceTestUtil.createTestMonitor());
        }
        return file;
    }

    private IFolder createFolder(IContainer parent, int updateFlags, boolean linked) throws CoreException {
        IFolder folder = parent.getFolder(IPath.fromOSString((String)ResourceTestUtil.createUniqueString()));
        if (linked) {
            IPath path = FileSystemHelper.getTempDir().append(ResourceTestUtil.createUniqueString());
            path.toFile().mkdir();
            folder.createLink(URIUtil.toURI((IPath)path), updateFlags, ResourceTestUtil.createTestMonitor());
            if ((updateFlags & 0x800) == 2048) {
                folder.setTeamPrivateMember(true);
            }
        } else {
            folder.create(updateFlags, true, ResourceTestUtil.createTestMonitor());
        }
        return folder;
    }
}

