/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.eclipse.core.internal.resources.TestingSupport;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFilterMatcherDescriptor;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.resources.ResourceTestPluginConstants;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class IWorkspaceTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    private IResource[] buildResourceHierarchy() throws CoreException {
        return ResourceTestUtil.buildResources((IContainer)ResourcesPlugin.getWorkspace().getRoot(), new String[]{"/", "/Project/", "/Project/Folder/", "/Project/Folder/File"});
    }

    private void ensureResourceHierarchyExist() throws CoreException {
        ResourceTestUtil.createInWorkspace(this.buildResourceHierarchy());
    }

    protected IProjectNatureDescriptor findNature(IProjectNatureDescriptor[] descriptors, String id) {
        IProjectNatureDescriptor[] iProjectNatureDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectNatureDescriptor descriptor = iProjectNatureDescriptorArray[n2];
            if (descriptor.getNatureId().equals(id)) {
                return descriptor;
            }
            ++n2;
        }
        return null;
    }

    @Test
    public void testCancelRunnable() {
        Assert.assertThrows(OperationCanceledException.class, () -> ResourcesPlugin.getWorkspace().run(monitor -> {
            throw new OperationCanceledException();
        }, ResourceTestUtil.createTestMonitor()));
    }

    @Test
    public void testCopy() throws Exception {
        IResource[] resources = this.buildResourceHierarchy();
        IProject project = (IProject)resources[1];
        IFolder folder = (IFolder)resources[2];
        IFile file = (IFile)resources[3];
        IFile file2 = folder.getFile("File2");
        IFile file3 = folder.getFile("File3");
        IFolder folder2 = project.getFolder("Folder2");
        IFolder folderCopy = folder2.getFolder("Folder");
        IFile fileCopy = folder2.getFile("File");
        IFile file2Copy = folder2.getFile("File2");
        Assert.assertThrows(CoreException.class, () -> {
            IStatus iStatus = ResourcesPlugin.getWorkspace().copy(new IResource[]{file}, folder.getFullPath(), false, ResourceTestUtil.createTestMonitor());
        });
        this.ensureResourceHierarchyExist();
        Assert.assertThrows(CoreException.class, () -> {
            IStatus iStatus = ResourcesPlugin.getWorkspace().copy(new IResource[]{file}, folder2.getFullPath().append("figment"), false, ResourceTestUtil.createTestMonitor());
        });
        Assert.assertThrows(CoreException.class, () -> {
            IStatus iStatus = ResourcesPlugin.getWorkspace().copy(new IResource[]{file}, folder2.getFullPath(), false, ResourceTestUtil.createTestMonitor());
        });
        folder2.create(false, true, ResourceTestUtil.createTestMonitor());
        Assert.assertThrows(CoreException.class, () -> {
            IStatus iStatus = ResourcesPlugin.getWorkspace().copy(new IResource[]{file2}, folder2.getFullPath(), false, ResourceTestUtil.createTestMonitor());
        });
        Assert.assertThrows(CoreException.class, () -> {
            IStatus iStatus = ResourcesPlugin.getWorkspace().copy(new IResource[]{file, file2}, folder2.getFullPath(), false, ResourceTestUtil.createTestMonitor());
        });
        Assert.assertTrue((String)"1.5", (boolean)fileCopy.exists());
        fileCopy.delete(true, ResourceTestUtil.createTestMonitor());
        IFile projectFile = project.getFile("ProjectPhile");
        file2.create(ResourceTestUtil.createRandomContentsStream(), false, ResourceTestUtil.createTestMonitor());
        file3.create(ResourceTestUtil.createRandomContentsStream(), false, ResourceTestUtil.createTestMonitor());
        projectFile.create(ResourceTestUtil.createRandomContentsStream(), false, ResourceTestUtil.createTestMonitor());
        Assert.assertThrows(CoreException.class, () -> {
            IStatus iStatus = ResourcesPlugin.getWorkspace().copy(new IResource[]{file, projectFile}, folder2.getFullPath(), false, ResourceTestUtil.createTestMonitor());
        });
        Assert.assertThrows(CoreException.class, () -> {
            IStatus iStatus = ResourcesPlugin.getWorkspace().copy(new IResource[]{file, file2, file}, folder2.getFullPath(), false, ResourceTestUtil.createTestMonitor());
        });
        Assert.assertThrows(CoreException.class, () -> {
            IFolder folder3 = folder2.getFolder("Folder3");
            folder3.create(false, true, ResourceTestUtil.createTestMonitor());
            ResourcesPlugin.getWorkspace().copy(new IResource[]{folder2}, folder3.getFullPath(), false, ResourceTestUtil.createTestMonitor());
        });
        Assert.assertThrows(CoreException.class, () -> {
            file2Copy.create(ResourceTestUtil.createRandomContentsStream(), false, ResourceTestUtil.createTestMonitor());
            ResourcesPlugin.getWorkspace().copy(new IResource[]{file, file2}, folder2.getFullPath(), false, ResourceTestUtil.createTestMonitor());
        });
        ResourceTestUtil.removeFromWorkspace((IResource)file2Copy);
        ResourceTestUtil.removeFromFileSystem((IResource)file2Copy);
        fileCopy = folder2.getFile("File");
        Assert.assertTrue((String)"2.2", (boolean)fileCopy.exists());
        fileCopy.delete(true, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.ensureOutOfSync(file);
        Assert.assertThrows(CoreException.class, () -> {
            IStatus iStatus = ResourcesPlugin.getWorkspace().copy(new IResource[]{file}, folder2.getFullPath(), false, ResourceTestUtil.createTestMonitor());
        });
        file.refreshLocal(0, null);
        ResourcesPlugin.getWorkspace().copy(new IResource[0], folder2.getFullPath(), false, ResourceTestUtil.createTestMonitor());
        ResourcesPlugin.getWorkspace().copy(new IResource[]{file}, folder2.getFullPath(), false, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"3.2", (boolean)fileCopy.exists());
        ResourceTestUtil.removeFromWorkspace((IResource)fileCopy);
        ResourceTestUtil.removeFromFileSystem((IResource)fileCopy);
        ResourcesPlugin.getWorkspace().copy(new IResource[]{file, file2}, folder2.getFullPath(), false, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"3.4", (boolean)fileCopy.exists());
        Assert.assertTrue((String)"3.5", (boolean)file2Copy.exists());
        ResourceTestUtil.removeFromWorkspace((IResource)fileCopy);
        ResourceTestUtil.removeFromWorkspace((IResource)file2Copy);
        ResourceTestUtil.removeFromFileSystem((IResource)fileCopy);
        ResourceTestUtil.removeFromFileSystem((IResource)file2Copy);
        ResourcesPlugin.getWorkspace().copy(new IResource[]{folder}, folder2.getFullPath(), false, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"3.7", (boolean)folderCopy.exists());
        Assertions.assertThat((Object[])folderCopy.members()).hasSizeGreaterThan(0);
        ResourceTestUtil.removeFromWorkspace((IResource)folderCopy);
        ResourceTestUtil.removeFromFileSystem((IResource)folderCopy);
    }

    @Test
    public void testDelete() throws CoreException {
        IResource[] resources = this.buildResourceHierarchy();
        IProject project = (IProject)resources[1];
        IFolder folder = (IFolder)resources[2];
        IFile file = (IFile)resources[3];
        Assert.assertTrue((boolean)ResourcesPlugin.getWorkspace().delete(new IResource[]{project, folder, file}, false, ResourceTestUtil.createTestMonitor()).isOK());
        Assert.assertTrue((boolean)ResourcesPlugin.getWorkspace().delete(new IResource[]{file}, false, ResourceTestUtil.createTestMonitor()).isOK());
        Assert.assertTrue((boolean)ResourcesPlugin.getWorkspace().delete(new IResource[0], false, ResourceTestUtil.createTestMonitor()).isOK());
        this.ensureResourceHierarchyExist();
        resources = new IResource[]{file, project, folder};
        Assert.assertTrue((boolean)ResourcesPlugin.getWorkspace().delete(resources, false, ResourceTestUtil.createTestMonitor()).isOK());
        ResourceTestUtil.assertDoesNotExistInWorkspace(resources);
        this.ensureResourceHierarchyExist();
        resources = new IResource[]{file};
        Assert.assertTrue((boolean)ResourcesPlugin.getWorkspace().delete(resources, false, ResourceTestUtil.createTestMonitor()).isOK());
        ResourceTestUtil.assertDoesNotExistInFileSystem(resources);
        ResourceTestUtil.assertDoesNotExistInWorkspace(resources);
        file.create(ResourceTestUtil.createRandomContentsStream(), false, ResourceTestUtil.createTestMonitor());
        resources = new IResource[]{};
        Assert.assertTrue((boolean)ResourcesPlugin.getWorkspace().delete(resources, false, ResourceTestUtil.createTestMonitor()).isOK());
        ResourceTestUtil.assertDoesNotExistInFileSystem(resources);
        ResourceTestUtil.assertDoesNotExistInWorkspace(resources);
        this.ensureResourceHierarchyExist();
        IProject fakeProject = ResourcesPlugin.getWorkspace().getRoot().getProject("pigment");
        IFolder fakeFolder = fakeProject.getFolder("ligament");
        resources = new IResource[]{file, folder, fakeFolder, project, fakeProject};
        Assert.assertTrue((boolean)ResourcesPlugin.getWorkspace().delete(resources, false, ResourceTestUtil.createTestMonitor()).isOK());
        ResourceTestUtil.assertDoesNotExistInWorkspace(resources);
        this.ensureResourceHierarchyExist();
        resources = new IResource[]{fakeProject, file};
        Assert.assertTrue((boolean)ResourcesPlugin.getWorkspace().delete(resources, false, ResourceTestUtil.createTestMonitor()).isOK());
        ResourceTestUtil.assertDoesNotExistInFileSystem(resources);
        ResourceTestUtil.assertDoesNotExistInWorkspace(resources);
        file.create(ResourceTestUtil.createRandomContentsStream(), false, ResourceTestUtil.createTestMonitor());
        resources = new IResource[]{fakeProject};
        Assert.assertTrue((boolean)ResourcesPlugin.getWorkspace().delete(resources, false, ResourceTestUtil.createTestMonitor()).isOK());
        ResourceTestUtil.assertDoesNotExistInWorkspace(resources);
        this.ensureResourceHierarchyExist();
    }

    @Test
    public void testForgetSavedTree() {
        ResourcesPlugin.getWorkspace().forgetSavedTree(null);
    }

    @Test
    public void testGetNatureDescriptors() {
        IProjectNatureDescriptor[] descriptors = ResourcesPlugin.getWorkspace().getNatureDescriptors();
        IProjectNatureDescriptor current = this.findNature(descriptors, "org.eclipse.core.tests.resources.simpleNature");
        Assert.assertNotNull((String)"2.0", (Object)current);
        Assert.assertEquals((String)"2.1", (Object)"org.eclipse.core.tests.resources.simpleNature", (Object)current.getNatureId());
        Assert.assertEquals((String)"2.2", (Object)"Simple", (Object)current.getLabel());
        Assertions.assertThat((Object[])current.getRequiredNatureIds()).isEmpty();
        Assertions.assertThat((Object[])current.getNatureSetIds()).isEmpty();
        current = this.findNature(descriptors, "org.eclipse.core.tests.resources.snowNature");
        Assert.assertNotNull((String)"3.0", (Object)current);
        Assert.assertEquals((String)"3.1", (Object)"org.eclipse.core.tests.resources.snowNature", (Object)current.getNatureId());
        Assert.assertEquals((String)"3.2", (Object)"Snow", (Object)current.getLabel());
        Object[] required = current.getRequiredNatureIds();
        Assertions.assertThat((Object[])required).containsExactly((Object[])new String[]{"org.eclipse.core.tests.resources.waterNature"});
        Object[] sets = current.getNatureSetIds();
        Assertions.assertThat((Object[])sets).containsExactly((Object[])new String[]{"org.eclipse.core.tests.resources.otherSet"});
        current = this.findNature(descriptors, "org.eclipse.core.tests.resources.waterNature");
        Assert.assertNotNull((String)"4.0", (Object)current);
        Assert.assertEquals((String)"4.1", (Object)"org.eclipse.core.tests.resources.waterNature", (Object)current.getNatureId());
        Assert.assertEquals((String)"4.2", (Object)"Water", (Object)current.getLabel());
        required = current.getRequiredNatureIds();
        Assertions.assertThat((Object[])required).isEmpty();
        sets = current.getNatureSetIds();
        Assertions.assertThat((Object[])sets).containsExactly((Object[])new String[]{"org.eclipse.core.tests.resources.stateSet"});
        current = this.findNature(descriptors, "org.eclipse.core.tests.resources.earthNature");
        Assert.assertNotNull((String)"5.0", (Object)current);
        Assert.assertEquals((String)"5.1", (Object)"org.eclipse.core.tests.resources.earthNature", (Object)current.getNatureId());
        Assert.assertEquals((String)"5.2", (Object)"Earth", (Object)current.getLabel());
        required = current.getRequiredNatureIds();
        Assertions.assertThat((Object[])required).isEmpty();
        sets = current.getNatureSetIds();
        Assertions.assertThat((Object[])sets).containsExactly((Object[])new String[]{"org.eclipse.core.tests.resources.stateSet"});
        current = this.findNature(descriptors, "org.eclipse.core.tests.resources.mudNature");
        Assert.assertNotNull((String)"6.0", (Object)current);
        Assert.assertEquals((String)"6.1", (Object)"org.eclipse.core.tests.resources.mudNature", (Object)current.getNatureId());
        Assert.assertEquals((String)"6.2", (Object)"Mud", (Object)current.getLabel());
        required = current.getRequiredNatureIds();
        Assertions.assertThat((Object[])required).containsExactlyInAnyOrder((Object[])new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.earthNature"});
        sets = current.getNatureSetIds();
        Assertions.assertThat((Object[])sets).containsExactly((Object[])new String[]{"org.eclipse.core.tests.resources.otherSet"});
        current = this.findNature(descriptors, "org.eclipse.core.tests.resources.invalidNature");
        Assert.assertNotNull((String)"7.0", (Object)current);
        Assert.assertEquals((String)"7.1", (Object)"org.eclipse.core.tests.resources.invalidNature", (Object)current.getNatureId());
        Assert.assertEquals((String)"7.2", (Object)"", (Object)current.getLabel());
        required = current.getRequiredNatureIds();
        Assertions.assertThat((Object[])required).isEmpty();
        sets = current.getNatureSetIds();
        Assertions.assertThat((Object[])sets).isEmpty();
        current = this.findNature(descriptors, "org.eclipse.core.tests.resources.cycle1");
        Assert.assertNotNull((String)"8.0", (Object)current);
        Assert.assertEquals((String)"8.1", (Object)"org.eclipse.core.tests.resources.cycle1", (Object)current.getNatureId());
        Assert.assertEquals((String)"8.2", (Object)"Cycle1", (Object)current.getLabel());
        required = current.getRequiredNatureIds();
        Assertions.assertThat((Object[])required).containsExactly((Object[])new String[]{"org.eclipse.core.tests.resources.cycle2"});
        sets = current.getNatureSetIds();
        Assertions.assertThat((Object[])sets).isEmpty();
        current = this.findNature(descriptors, "org.eclipse.core.tests.resources.cycle2");
        Assert.assertNotNull((String)"5.0", (Object)current);
        Assert.assertEquals((String)"9.1", (Object)"org.eclipse.core.tests.resources.cycle2", (Object)current.getNatureId());
        Assert.assertEquals((String)"9.2", (Object)"Cycle2", (Object)current.getLabel());
        required = current.getRequiredNatureIds();
        Assertions.assertThat((Object[])required).containsExactly((Object[])new String[]{"org.eclipse.core.tests.resources.cycle3"});
        sets = current.getNatureSetIds();
        Assertions.assertThat((Object[])sets).isEmpty();
        current = this.findNature(descriptors, "org.eclipse.core.tests.resources.cycle3");
        Assert.assertNotNull((String)"10.0", (Object)current);
        Assert.assertEquals((String)"10.1", (Object)"org.eclipse.core.tests.resources.cycle3", (Object)current.getNatureId());
        Assert.assertEquals((String)"10.2", (Object)"Cycle3", (Object)current.getLabel());
        required = current.getRequiredNatureIds();
        Assertions.assertThat((Object[])required).containsExactly((Object[])new String[]{"org.eclipse.core.tests.resources.cycle1"});
        sets = current.getNatureSetIds();
        Assertions.assertThat((Object[])sets).isEmpty();
    }

    @Test
    public void testGetNatureDescriptor() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProjectNatureDescriptor current = ws.getNatureDescriptor("org.eclipse.core.tests.resources.simpleNature");
        Assert.assertNotNull((String)"2.0", (Object)current);
        Assert.assertEquals((String)"2.1", (Object)"org.eclipse.core.tests.resources.simpleNature", (Object)current.getNatureId());
        Assert.assertEquals((String)"2.2", (Object)"Simple", (Object)current.getLabel());
        Assertions.assertThat((Object[])current.getRequiredNatureIds()).isEmpty();
        Assertions.assertThat((Object[])current.getNatureSetIds()).isEmpty();
        current = ws.getNatureDescriptor("org.eclipse.core.tests.resources.snowNature");
        Assert.assertNotNull((String)"3.0", (Object)current);
        Assert.assertEquals((String)"3.1", (Object)"org.eclipse.core.tests.resources.snowNature", (Object)current.getNatureId());
        Assert.assertEquals((String)"3.2", (Object)"Snow", (Object)current.getLabel());
        Object[] required = current.getRequiredNatureIds();
        Assertions.assertThat((Object[])required).containsExactly((Object[])new String[]{"org.eclipse.core.tests.resources.waterNature"});
        Object[] sets = current.getNatureSetIds();
        Assertions.assertThat((Object[])sets).containsExactly((Object[])new String[]{"org.eclipse.core.tests.resources.otherSet"});
        current = ws.getNatureDescriptor("org.eclipse.core.tests.resources.waterNature");
        Assert.assertNotNull((String)"4.0", (Object)current);
        Assert.assertEquals((String)"4.1", (Object)"org.eclipse.core.tests.resources.waterNature", (Object)current.getNatureId());
        Assert.assertEquals((String)"4.2", (Object)"Water", (Object)current.getLabel());
        required = current.getRequiredNatureIds();
        Assertions.assertThat((Object[])required).isEmpty();
        sets = current.getNatureSetIds();
        Assertions.assertThat((Object[])sets).containsExactly((Object[])new String[]{"org.eclipse.core.tests.resources.stateSet"});
        current = ws.getNatureDescriptor("org.eclipse.core.tests.resources.earthNature");
        Assert.assertNotNull((String)"5.0", (Object)current);
        Assert.assertEquals((String)"5.1", (Object)"org.eclipse.core.tests.resources.earthNature", (Object)current.getNatureId());
        Assert.assertEquals((String)"5.2", (Object)"Earth", (Object)current.getLabel());
        required = current.getRequiredNatureIds();
        Assertions.assertThat((Object[])required).isEmpty();
        sets = current.getNatureSetIds();
        Assertions.assertThat((Object[])sets).containsExactly((Object[])new String[]{"org.eclipse.core.tests.resources.stateSet"});
        current = ws.getNatureDescriptor("org.eclipse.core.tests.resources.mudNature");
        Assert.assertNotNull((String)"6.0", (Object)current);
        Assert.assertEquals((String)"6.1", (Object)"org.eclipse.core.tests.resources.mudNature", (Object)current.getNatureId());
        Assert.assertEquals((String)"6.2", (Object)"Mud", (Object)current.getLabel());
        required = current.getRequiredNatureIds();
        Assertions.assertThat((Object[])required).containsExactlyInAnyOrder((Object[])new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.earthNature"});
        sets = current.getNatureSetIds();
        Assertions.assertThat((Object[])sets).containsExactly((Object[])new String[]{"org.eclipse.core.tests.resources.otherSet"});
        current = ws.getNatureDescriptor("org.eclipse.core.tests.resources.invalidNature");
        Assert.assertNotNull((String)"7.0", (Object)current);
        Assert.assertEquals((String)"7.1", (Object)"org.eclipse.core.tests.resources.invalidNature", (Object)current.getNatureId());
        Assert.assertEquals((String)"7.2", (Object)"", (Object)current.getLabel());
        required = current.getRequiredNatureIds();
        Assertions.assertThat((Object[])required).isEmpty();
        sets = current.getNatureSetIds();
        Assertions.assertThat((Object[])sets).isEmpty();
        current = ws.getNatureDescriptor("org.eclipse.core.tests.resources.cycle1");
        Assert.assertNotNull((String)"8.0", (Object)current);
        Assert.assertEquals((String)"8.1", (Object)"org.eclipse.core.tests.resources.cycle1", (Object)current.getNatureId());
        Assert.assertEquals((String)"8.2", (Object)"Cycle1", (Object)current.getLabel());
        required = current.getRequiredNatureIds();
        Assertions.assertThat((Object[])required).containsExactly((Object[])new String[]{"org.eclipse.core.tests.resources.cycle2"});
        sets = current.getNatureSetIds();
        Assertions.assertThat((Object[])sets).isEmpty();
        current = ws.getNatureDescriptor("org.eclipse.core.tests.resources.cycle2");
        Assert.assertNotNull((String)"5.0", (Object)current);
        Assert.assertEquals((String)"9.1", (Object)"org.eclipse.core.tests.resources.cycle2", (Object)current.getNatureId());
        Assert.assertEquals((String)"9.2", (Object)"Cycle2", (Object)current.getLabel());
        required = current.getRequiredNatureIds();
        Assertions.assertThat((Object[])required).containsExactly((Object[])new String[]{"org.eclipse.core.tests.resources.cycle3"});
        sets = current.getNatureSetIds();
        Assertions.assertThat((Object[])sets).isEmpty();
        current = ws.getNatureDescriptor("org.eclipse.core.tests.resources.cycle3");
        Assert.assertNotNull((String)"10.0", (Object)current);
        Assert.assertEquals((String)"10.1", (Object)"org.eclipse.core.tests.resources.cycle3", (Object)current.getNatureId());
        Assert.assertEquals((String)"10.2", (Object)"Cycle3", (Object)current.getLabel());
        required = current.getRequiredNatureIds();
        Assertions.assertThat((Object[])required).containsExactly((Object[])new String[]{"org.eclipse.core.tests.resources.cycle1"});
        sets = current.getNatureSetIds();
        Assertions.assertThat((Object[])sets).isEmpty();
    }

    @Test
    public void testMove() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile anotherFile = project.getFile("anotherFile.txt");
        IFile oneMoreFile = project.getFile("oneMoreFile.txt");
        ResourceTestUtil.createInWorkspace(new IResource[]{project, folder, file, anotherFile, oneMoreFile});
        IResource[] resources = new IResource[]{file, anotherFile, oneMoreFile};
        ResourcesPlugin.getWorkspace().move(resources, folder.getFullPath(), true, ResourceTestUtil.createTestMonitor());
        Assert.assertFalse((String)"1.1", (boolean)file.exists());
        Assert.assertFalse((String)"1.2", (boolean)anotherFile.exists());
        Assert.assertFalse((String)"1.3", (boolean)oneMoreFile.exists());
        Assert.assertTrue((String)"1.4", (boolean)folder.getFile(file.getName()).exists());
        Assert.assertTrue((String)"1.5", (boolean)folder.getFile(anotherFile.getName()).exists());
        Assert.assertTrue((String)"1.6", (boolean)folder.getFile(oneMoreFile.getName()).exists());
        resources = new IResource[]{folder.getFile(file.getName()), folder.getFile(anotherFile.getName()), folder.getFile(oneMoreFile.getName()), folder.getFile(oneMoreFile.getName())};
        IStatus status = ResourcesPlugin.getWorkspace().move(resources, project.getFullPath(), true, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.1", (boolean)status.isOK());
        Assert.assertTrue((String)"2.3", (boolean)file.exists());
        Assert.assertTrue((String)"2.4", (boolean)anotherFile.exists());
        Assert.assertTrue((String)"2.5", (boolean)oneMoreFile.exists());
        Assert.assertFalse((String)"2.6", (boolean)folder.getFile(file.getName()).exists());
        Assert.assertFalse((String)"2.7", (boolean)folder.getFile(anotherFile.getName()).exists());
        Assert.assertFalse((String)"2.8", (boolean)folder.getFile(oneMoreFile.getName()).exists());
        IResource[] resources2 = new IResource[]{file, anotherFile, oneMoreFile, project};
        CoreException ex = (CoreException)Assert.assertThrows(CoreException.class, () -> {
            IStatus iStatus = ResourcesPlugin.getWorkspace().move(resources2, folder.getFullPath(), true, ResourceTestUtil.createTestMonitor());
        });
        Assert.assertFalse((String)"3.1", (boolean)ex.getStatus().isOK());
        Assertions.assertThat((Object[])ex.getStatus().getChildren()).hasSize(1);
        Assert.assertFalse((String)"3.3", (boolean)file.exists());
        Assert.assertFalse((String)"3.4", (boolean)anotherFile.exists());
        Assert.assertFalse((String)"3.5", (boolean)oneMoreFile.exists());
        Assert.assertTrue((String)"3.6", (boolean)folder.getFile(file.getName()).exists());
        Assert.assertTrue((String)"3.7", (boolean)folder.getFile(anotherFile.getName()).exists());
        Assert.assertTrue((String)"3.8", (boolean)folder.getFile(oneMoreFile.getName()).exists());
        IResource[] resources3 = new IResource[]{folder.getFile(file.getName()), folder.getFile(anotherFile.getName()), folder.getFile("inexisting"), folder.getFile(oneMoreFile.getName())};
        CoreException ex2 = (CoreException)Assert.assertThrows(CoreException.class, () -> {
            IStatus iStatus = ResourcesPlugin.getWorkspace().move(resources3, project.getFullPath(), true, ResourceTestUtil.createTestMonitor());
        });
        Assert.assertFalse((String)"4.1", (boolean)ex2.getStatus().isOK());
        Assert.assertTrue((String)"4.3", (boolean)file.exists());
        Assert.assertTrue((String)"4.4", (boolean)anotherFile.exists());
        Assert.assertTrue((String)"4.5", (boolean)oneMoreFile.exists());
        Assert.assertFalse((String)"4.6", (boolean)folder.getFile(file.getName()).exists());
        Assert.assertFalse((String)"4.7", (boolean)folder.getFile(anotherFile.getName()).exists());
        Assert.assertFalse((String)"4.8", (boolean)folder.getFile(oneMoreFile.getName()).exists());
    }

    @Test
    public void testMultiCopy() throws Exception {
        IResource[] resources = this.buildResourceHierarchy();
        IProject project = (IProject)resources[1];
        IFolder folder = (IFolder)resources[2];
        ResourceTestUtil.createInWorkspace((IResource)folder);
        ResourceTestUtil.createInFileSystem((IResource)folder);
        IFile file1 = project.getFile("file.txt");
        ResourceTestUtil.createInWorkspace((IResource)file1);
        ResourceTestUtil.createInFileSystem((IResource)file1);
        IFile anotherFile = project.getFile("anotherFile.txt");
        ResourceTestUtil.createInWorkspace((IResource)anotherFile);
        ResourceTestUtil.createInFileSystem((IResource)anotherFile);
        IFile oneMoreFile = project.getFile("oneMoreFile.txt");
        ResourceTestUtil.createInWorkspace((IResource)oneMoreFile);
        ResourceTestUtil.createInFileSystem((IResource)oneMoreFile);
        resources = new IResource[]{file1, anotherFile, oneMoreFile};
        ResourcesPlugin.getWorkspace().copy(resources, folder.getFullPath(), true, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"1.1", (boolean)file1.exists());
        Assert.assertTrue((String)"1.2", (boolean)anotherFile.exists());
        Assert.assertTrue((String)"1.3", (boolean)oneMoreFile.exists());
        Assert.assertTrue((String)"1.4", (boolean)folder.getFile(file1.getName()).exists());
        Assert.assertTrue((String)"1.5", (boolean)folder.getFile(anotherFile.getName()).exists());
        Assert.assertTrue((String)"1.6", (boolean)folder.getFile(oneMoreFile.getName()).exists());
        ResourceTestUtil.removeFromWorkspace((IResource)folder.getFile(file1.getName()));
        ResourceTestUtil.removeFromWorkspace((IResource)folder.getFile(anotherFile.getName()));
        ResourceTestUtil.removeFromWorkspace((IResource)folder.getFile(oneMoreFile.getName()));
        ResourceTestUtil.removeFromFileSystem((IResource)folder.getFile(file1.getName()));
        ResourceTestUtil.removeFromFileSystem((IResource)folder.getFile(anotherFile.getName()));
        ResourceTestUtil.removeFromFileSystem((IResource)folder.getFile(oneMoreFile.getName()));
        resources = new IResource[]{file1, anotherFile, oneMoreFile, file1};
        ResourcesPlugin.getWorkspace().copy(resources, folder.getFullPath(), true, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.2", (boolean)file1.exists());
        Assert.assertTrue((String)"2.3", (boolean)anotherFile.exists());
        Assert.assertTrue((String)"2.4", (boolean)oneMoreFile.exists());
        Assert.assertTrue((String)"2.5", (boolean)folder.getFile(file1.getName()).exists());
        Assert.assertTrue((String)"2.6", (boolean)folder.getFile(anotherFile.getName()).exists());
        Assert.assertTrue((String)"2.7", (boolean)folder.getFile(oneMoreFile.getName()).exists());
        ResourceTestUtil.removeFromWorkspace((IResource)folder.getFile(file1.getName()));
        ResourceTestUtil.removeFromWorkspace((IResource)folder.getFile(anotherFile.getName()));
        ResourceTestUtil.removeFromWorkspace((IResource)folder.getFile(oneMoreFile.getName()));
        ResourceTestUtil.removeFromFileSystem((IResource)folder.getFile(file1.getName()));
        ResourceTestUtil.removeFromFileSystem((IResource)folder.getFile(anotherFile.getName()));
        ResourceTestUtil.removeFromFileSystem((IResource)folder.getFile(oneMoreFile.getName()));
        IResource[] resources2 = new IResource[]{file1, anotherFile, oneMoreFile, project};
        CoreException e = (CoreException)Assert.assertThrows(CoreException.class, () -> {
            IStatus iStatus = ResourcesPlugin.getWorkspace().copy(resources2, folder.getFullPath(), true, ResourceTestUtil.createTestMonitor());
        });
        IStatus status = e.getStatus();
        Assert.assertFalse((String)"3.1", (boolean)status.isOK());
        Assertions.assertThat((Object[])status.getChildren()).hasSize(1);
        Assert.assertTrue((String)"3.3", (boolean)file1.exists());
        Assert.assertTrue((String)"3.4", (boolean)anotherFile.exists());
        Assert.assertTrue((String)"3.5", (boolean)oneMoreFile.exists());
        Assert.assertTrue((String)"3.6", (boolean)folder.getFile(file1.getName()).exists());
        Assert.assertTrue((String)"3.7", (boolean)folder.getFile(anotherFile.getName()).exists());
        Assert.assertTrue((String)"3.8", (boolean)folder.getFile(oneMoreFile.getName()).exists());
        ResourceTestUtil.removeFromWorkspace((IResource)folder.getFile(file1.getName()));
        ResourceTestUtil.removeFromWorkspace((IResource)folder.getFile(anotherFile.getName()));
        ResourceTestUtil.removeFromWorkspace((IResource)folder.getFile(oneMoreFile.getName()));
        ResourceTestUtil.removeFromFileSystem((IResource)folder.getFile(file1.getName()));
        ResourceTestUtil.removeFromFileSystem((IResource)folder.getFile(anotherFile.getName()));
        ResourceTestUtil.removeFromFileSystem((IResource)folder.getFile(oneMoreFile.getName()));
        IResource[] resources3 = new IResource[]{file1, anotherFile, project.getFile("inexisting"), oneMoreFile};
        CoreException ex = (CoreException)Assert.assertThrows(CoreException.class, () -> {
            IStatus iStatus = ResourcesPlugin.getWorkspace().copy(resources3, folder.getFullPath(), true, ResourceTestUtil.createTestMonitor());
        });
        status = ex.getStatus();
        Assert.assertFalse((String)"4.1", (boolean)status.isOK());
        Assert.assertTrue((String)"4.2", (boolean)file1.exists());
        Assert.assertTrue((String)"4.3", (boolean)anotherFile.exists());
        Assert.assertTrue((String)"4.4", (boolean)oneMoreFile.exists());
        Assert.assertTrue((String)"4.5", (boolean)folder.getFile(file1.getName()).exists());
        Assert.assertTrue((String)"4.6", (boolean)folder.getFile(anotherFile.getName()).exists());
        Assert.assertTrue((String)"4.7 Fails because of 1FVFOOQ", (boolean)folder.getFile(oneMoreFile.getName()).exists());
        IProject destination = ResourcesPlugin.getWorkspace().getRoot().getProject("destination");
        CoreException ex2 = (CoreException)Assert.assertThrows(CoreException.class, () -> IWorkspaceTest.lambda$16(project, (IResource)destination));
        status = ex2.getStatus();
        Assert.assertFalse((String)"5.1", (boolean)status.isOK());
        Assertions.assertThat((Object[])status.getChildren()).hasSize(1);
    }

    @Test
    public void testMultiCreation() throws Throwable {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("bar");
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, new String[]{"a/", "a/b"});
        IWorkspaceRunnable body = monitor -> {
            project.create(null);
            project.open(null);
            IResource[] iResourceArray2 = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray2[n2];
                switch (resource.getType()) {
                    case 1: {
                        ((IFile)resource).create(null, false, ResourceTestUtil.createTestMonitor());
                        break;
                    }
                    case 2: {
                        ((IFolder)resource).create(false, true, ResourceTestUtil.createTestMonitor());
                        break;
                    }
                    case 4: {
                        ((IProject)resource).create(ResourceTestUtil.createTestMonitor());
                    }
                }
                ++n2;
            }
        };
        ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace((IResource)project);
        ResourceTestUtil.assertExistsInWorkspace(resources);
    }

    @Test
    public void testMultiDeletion() throws Throwable {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("testProject");
        IResource[] before = ResourceTestUtil.buildResources((IContainer)project, new String[]{"c/", "c/b/", "c/x", "c/b/y", "c/b/z"});
        ResourceTestUtil.createInWorkspace(before);
        ResourceTestUtil.assertExistsInWorkspace(before);
        ResourcesPlugin.getWorkspace().delete(before, true, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(before);
    }

    @Test
    public void testMultiSetDescription() throws CoreException {
        int THREAD_COUNT = 2;
        CoreException[] errorPointer = new CoreException[1];
        Thread[] threads = new Thread[2];
        int i = 0;
        while (i < 2) {
            threads[i] = new Thread(() -> {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IWorkspaceDescription description = workspace.getDescription();
                int j = 0;
                while (j < 100) {
                    description.setAutoBuilding(false);
                    try {
                        workspace.setDescription(description);
                    }
                    catch (CoreException e1) {
                        coreExceptionArray[0] = e1;
                        return;
                    }
                    description.setAutoBuilding(true);
                    try {
                        workspace.setDescription(description);
                    }
                    catch (CoreException e2) {
                        coreExceptionArray[0] = e2;
                        return;
                    }
                    ++j;
                }
            }, "Autobuild " + i);
            threads[i].start();
            ++i;
        }
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n2;
        }
        if (errorPointer[0] != null) {
            throw errorPointer[0];
        }
    }

    @Test
    public void testSave() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Broken");
        ResourceTestUtil.createInWorkspace((IResource)project);
        TestingSupport.waitForSnapshot();
        IFile descriptionFile = project.getFile(".project");
        descriptionFile.delete(0, null);
        IStatus result = ResourcesPlugin.getWorkspace().save(true, ResourceTestUtil.createTestMonitor());
        Assert.assertEquals((String)"1.0", (long)2L, (long)result.getSeverity());
    }

    @Test
    public void testSortNatureSet() {
        String[][] invalid;
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        String[][] stringArray = invalid = ResourceTestPluginConstants.getInvalidNatureSets();
        int n = invalid.length;
        int n2 = 0;
        while (n2 < n) {
            String[] element = stringArray[n2];
            Object[] sorted = ws.sortNatureSet(element);
            Assertions.assertThat((Object[])sorted).hasSizeLessThanOrEqualTo(element.length);
            ++n2;
        }
        Object[] sorted = ws.sortNatureSet(new String[0]);
        Assertions.assertThat((Object[])sorted).isEmpty();
        sorted = ws.sortNatureSet(new String[]{"org.eclipse.core.tests.resources.simpleNature"});
        Assertions.assertThat((Object[])sorted).containsExactly((Object[])new String[]{"org.eclipse.core.tests.resources.simpleNature"});
        sorted = ws.sortNatureSet(new String[]{"org.eclipse.core.tests.resources.snowNature", "org.eclipse.core.tests.resources.waterNature"});
        Assertions.assertThat((Object[])sorted).containsExactly((Object[])new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.snowNature"});
        sorted = ws.sortNatureSet(new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.simpleNature", "org.eclipse.core.tests.resources.snowNature"});
        Assertions.assertThat((Object[])sorted).satisfiesAnyOf(new ThrowingConsumer[]{order -> {
            AbstractObjectArrayAssert abstractObjectArrayAssert = Assertions.assertThat((Object[])order).containsExactly((Object[])new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.snowNature", "org.eclipse.core.tests.resources.simpleNature"});
        }, order -> {
            AbstractObjectArrayAssert abstractObjectArrayAssert = Assertions.assertThat((Object[])order).containsExactly((Object[])new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.simpleNature", "org.eclipse.core.tests.resources.snowNature"});
        }, order -> {
            AbstractObjectArrayAssert abstractObjectArrayAssert = Assertions.assertThat((Object[])order).containsExactly((Object[])new String[]{"org.eclipse.core.tests.resources.simpleNature", "org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.snowNature"});
        }});
    }

    @Test
    public void testValidateEdit() throws CoreException {
        if (!ResourceTestUtil.isReadOnlySupported()) {
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        IFile file = project.getFile("myfile.txt");
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file});
        IStatus result = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, null);
        Assert.assertTrue((String)"1.0", (boolean)result.isOK());
        file.setReadOnly(true);
        result = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, null);
        Assert.assertEquals((String)"1.1", (long)4L, (long)result.getSeverity());
        file.setReadOnly(false);
    }

    @Test
    public void testValidateLinkLocation() {
    }

    @Test
    public void testValidateName() {
        Assert.assertTrue((String)"1.1", (boolean)ResourcesPlugin.getWorkspace().validateName("abcdef", 1).isOK());
        if (Platform.OS.isWindows()) {
            Assert.assertFalse((String)"2.1", (boolean)ResourcesPlugin.getWorkspace().validateName("dsa:sf", 1).isOK());
            Assert.assertFalse((String)"2.2", (boolean)ResourcesPlugin.getWorkspace().validateName("*dsasf", 1).isOK());
            Assert.assertFalse((String)"2.3", (boolean)ResourcesPlugin.getWorkspace().validateName("?dsasf", 1).isOK());
            Assert.assertFalse((String)"2.4", (boolean)ResourcesPlugin.getWorkspace().validateName("\"dsasf", 1).isOK());
            Assert.assertFalse((String)"2.5", (boolean)ResourcesPlugin.getWorkspace().validateName("<dsasf", 1).isOK());
            Assert.assertFalse((String)"2.6", (boolean)ResourcesPlugin.getWorkspace().validateName(">dsasf", 1).isOK());
            Assert.assertFalse((String)"2.7", (boolean)ResourcesPlugin.getWorkspace().validateName("|dsasf", 1).isOK());
            Assert.assertFalse((String)"2.8", (boolean)ResourcesPlugin.getWorkspace().validateName("\"dsasf", 1).isOK());
            Assert.assertFalse((String)"2.10", (boolean)ResourcesPlugin.getWorkspace().validateName("\\dsasf", 1).isOK());
            Assert.assertFalse((String)"2.11", (boolean)ResourcesPlugin.getWorkspace().validateName("...", 4).isOK());
            Assert.assertFalse((String)"2.12", (boolean)ResourcesPlugin.getWorkspace().validateName("foo.", 1).isOK());
            int i = 0;
            while (i <= 31) {
                Assert.assertFalse((String)("2.13 Windows should NOT accept character #" + i), (boolean)ResourcesPlugin.getWorkspace().validateName("anything" + (char)i + "something", 1).isOK());
                ++i;
            }
            Assert.assertTrue((String)"2.14 Windows should accept character #32", (boolean)ResourcesPlugin.getWorkspace().validateName("anything something", 1).isOK());
            Assert.assertFalse((String)"2.15 Windows should NOT accept space at the end", (boolean)ResourcesPlugin.getWorkspace().validateName("foo ", 1).isOK());
            Assert.assertTrue((String)"2.16 Windows should accept space in the middle", (boolean)ResourcesPlugin.getWorkspace().validateName("fo o", 1).isOK());
            Assert.assertTrue((String)"2.17 Windows should accept space in at the beginning", (boolean)ResourcesPlugin.getWorkspace().validateName(" foo", 1).isOK());
        } else {
            Assert.assertTrue((String)"3.3", (boolean)ResourcesPlugin.getWorkspace().validateName("...", 1).isOK());
            Assert.assertTrue((String)"3.4", (boolean)ResourcesPlugin.getWorkspace().validateName("....", 4).isOK());
            Assert.assertTrue((String)"3.7", (boolean)ResourcesPlugin.getWorkspace().validateName("abc.", 1).isOK());
            int i = 1;
            while (i <= 32) {
                Assert.assertTrue((String)("3.8 Unix-style filesystems should accept character #" + i), (boolean)ResourcesPlugin.getWorkspace().validateName("anything" + (char)i + "something", 1).isOK());
                ++i;
            }
            Assert.assertTrue((String)"3.9 Unix-style filesystems should accept space at the end", (boolean)ResourcesPlugin.getWorkspace().validateName("foo ", 1).isOK());
        }
        Assert.assertFalse((String)"2.9", (boolean)ResourcesPlugin.getWorkspace().validateName("/dsasf", 1).isOK());
        Assert.assertFalse((String)"2.9", (boolean)ResourcesPlugin.getWorkspace().validateName("", 1).isOK());
        Assert.assertFalse((String)"3.1", (boolean)ResourcesPlugin.getWorkspace().validateName(".", 1).isOK());
        Assert.assertFalse((String)"3.2", (boolean)ResourcesPlugin.getWorkspace().validateName("..", 1).isOK());
        Assert.assertTrue((String)"3.3", (boolean)ResourcesPlugin.getWorkspace().validateName("...z", 1).isOK());
        Assert.assertTrue((String)"3.4", (boolean)ResourcesPlugin.getWorkspace().validateName("....z", 1).isOK());
        Assert.assertTrue((String)"3.5", (boolean)ResourcesPlugin.getWorkspace().validateName("....abc", 1).isOK());
        Assert.assertTrue((String)"3.6", (boolean)ResourcesPlugin.getWorkspace().validateName("abc....def", 1).isOK());
        Assert.assertTrue((String)"3.7", (boolean)ResourcesPlugin.getWorkspace().validateName("abc.d...z", 1).isOK());
    }

    @Test
    public void testValidateNatureSet() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        String[][] invalid = ResourceTestPluginConstants.getInvalidNatureSets();
        int i = 0;
        while (i < invalid.length) {
            IStatus result = ws.validateNatureSet(invalid[i]);
            Assert.assertFalse((String)("invalid (severity): " + i), (boolean)result.isOK());
            Assert.assertNotEquals((String)("invalid (code): " + i), (long)0L, (long)result.getCode());
            ++i;
        }
        String[][] valid = ResourceTestPluginConstants.getValidNatureSets();
        int i2 = 0;
        while (i2 < valid.length) {
            IStatus result = ws.validateNatureSet(valid[i2]);
            Assert.assertTrue((String)("valid (severity): " + i2), (boolean)result.isOK());
            Assert.assertEquals((String)("valid (code): " + i2), (long)0L, (long)result.getCode());
            ++i2;
        }
    }

    @Test
    public void testValidatePath() {
        Assert.assertTrue((String)"1.1", (boolean)ResourcesPlugin.getWorkspace().validatePath("/one/two/three/four/", 3).isOK());
        boolean WINDOWS = Platform.OS.isWindows();
        if (WINDOWS) {
            Assert.assertFalse((String)"2.1", (boolean)ResourcesPlugin.getWorkspace().validatePath("\\dsa:sf", 1).isOK());
            Assert.assertFalse((String)"2.2", (boolean)ResourcesPlugin.getWorkspace().validatePath("/abc/*dsasf", 1).isOK());
            Assert.assertFalse((String)"2.3", (boolean)ResourcesPlugin.getWorkspace().validatePath("/abc/?dsasf", 1).isOK());
            Assert.assertFalse((String)"2.4", (boolean)ResourcesPlugin.getWorkspace().validatePath("/abc/\"dsasf", 1).isOK());
            Assert.assertFalse((String)"2.5", (boolean)ResourcesPlugin.getWorkspace().validatePath("/abc/<dsasf", 1).isOK());
            Assert.assertFalse((String)"2.6", (boolean)ResourcesPlugin.getWorkspace().validatePath("/abc/>dsasf", 1).isOK());
            Assert.assertFalse((String)"2.7", (boolean)ResourcesPlugin.getWorkspace().validatePath("/abc/|dsasf", 1).isOK());
            Assert.assertFalse((String)"2.8", (boolean)ResourcesPlugin.getWorkspace().validatePath("/abc/\"dsasf", 1).isOK());
            Assert.assertFalse((String)"5.2", (boolean)ResourcesPlugin.getWorkspace().validatePath("\\", 1).isOK());
            Assert.assertFalse((String)"5.4", (boolean)ResourcesPlugin.getWorkspace().validatePath("device:/abc/123", 1).isOK());
            Assert.assertFalse((String)"3.1", (boolean)ResourcesPlugin.getWorkspace().validatePath("/abc/.../defghi", 1).isOK());
            Assert.assertFalse((String)"3.2", (boolean)ResourcesPlugin.getWorkspace().validatePath("/abc/..../defghi", 1).isOK());
            Assert.assertFalse((String)"3.3", (boolean)ResourcesPlugin.getWorkspace().validatePath("/abc/def..../ghi", 1).isOK());
        } else {
            Assert.assertTrue((String)"3.1", (boolean)ResourcesPlugin.getWorkspace().validatePath("/abc/.../defghi", 1).isOK());
            Assert.assertTrue((String)"3.2", (boolean)ResourcesPlugin.getWorkspace().validatePath("/abc/..../defghi", 1).isOK());
            Assert.assertTrue((String)"3.3", (boolean)ResourcesPlugin.getWorkspace().validatePath("/abc/def..../ghi", 1).isOK());
        }
        Assert.assertTrue((String)"3.4", (boolean)ResourcesPlugin.getWorkspace().validatePath("/abc/../ghi/j", 1).isOK());
        Assert.assertTrue((String)"3.5", (boolean)ResourcesPlugin.getWorkspace().validatePath("/abc/....def/ghi", 1).isOK());
        Assert.assertTrue((String)"3.6", (boolean)ResourcesPlugin.getWorkspace().validatePath("/abc/def....ghi/jkl", 1).isOK());
        Assert.assertTrue((String)"4.1", (boolean)ResourcesPlugin.getWorkspace().validatePath("/abc/.?./../def/as", 1).isOK());
        Assert.assertTrue((String)"4.2", (boolean)ResourcesPlugin.getWorkspace().validatePath("/abc/;*?\"'/../def/safd", 1).isOK());
        Assert.assertTrue((String)"4.3", (boolean)(ResourcesPlugin.getWorkspace().validatePath("/abc;*?\"':/def/asdf/sadf", 1).isOK() ^ WINDOWS));
        Assert.assertFalse((String)"5.1", (boolean)ResourcesPlugin.getWorkspace().validatePath("/", 1).isOK());
        Assert.assertFalse((String)"5.3", (boolean)ResourcesPlugin.getWorkspace().validatePath("", 1).isOK());
        Assert.assertTrue((String)"6.6", (boolean)ResourcesPlugin.getWorkspace().validatePath("/asf", 4).isOK());
        Assert.assertFalse((String)"6.7", (boolean)ResourcesPlugin.getWorkspace().validatePath("/asf", 1).isOK());
        Assert.assertTrue((String)"6.8", (boolean)ResourcesPlugin.getWorkspace().validatePath("/asf", 5).isOK());
        Assert.assertTrue((String)"6.10", (boolean)ResourcesPlugin.getWorkspace().validatePath("/project/.metadata", 1).isOK());
        Assert.assertTrue((String)"6.11", (boolean)ResourcesPlugin.getWorkspace().validatePath("/.metadata/project", 1).isOK());
    }

    @Test
    public void testValidateProjectLocation() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("Project");
        Assert.assertTrue((String)"1.1", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"/one/two/three/four/")).isOK());
        boolean WINDOWS = Platform.OS.isWindows();
        if (WINDOWS) {
            Assert.assertFalse((String)"2.1", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"d:\\dsa:sf")).isOK());
            Assert.assertFalse((String)"2.2", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"/abc/*dsasf")).isOK());
            Assert.assertFalse((String)"2.3", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"/abc/?dsasf")).isOK());
            Assert.assertFalse((String)"2.4", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"/abc/\"dsasf")).isOK());
            Assert.assertFalse((String)"2.5", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"/abc/<dsasf")).isOK());
            Assert.assertFalse((String)"2.6", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"/abc/>dsasf")).isOK());
            Assert.assertFalse((String)"2.7", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"/abc/|dsasf")).isOK());
            Assert.assertFalse((String)"2.8", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"/abc/\"dsasf")).isOK());
            Assert.assertFalse((String)"3.1", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"/abc/.../defghi")).isOK());
            Assert.assertFalse((String)"3.2", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"/abc/..../defghi")).isOK());
            Assert.assertFalse((String)"3.3", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"/abc/def..../ghi")).isOK());
        } else {
            Assert.assertTrue((String)"3.1", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"/abc/.../defghi")).isOK());
            Assert.assertTrue((String)"3.2", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"/abc/..../defghi")).isOK());
            Assert.assertTrue((String)"3.3", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"/abc/def..../ghi")).isOK());
        }
        Assert.assertTrue((String)"3.4", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"/abc/....def/ghi")).isOK());
        Assert.assertTrue((String)"3.5", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"/abc/def....ghi/jkl")).isOK());
        Assert.assertTrue((String)"4.1", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"/abc/.?./../def/as")).isOK());
        Assert.assertTrue((String)"4.2", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"/abc/;*?\"'/../def/safd")).isOK());
        Assert.assertFalse((String)"4.3", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"c:/abc;*?\"':/def/asdf/sadf")).isOK());
        IPath platformLocation = Platform.getLocation();
        Assert.assertFalse((String)"5.1", (boolean)workspace.validateProjectLocation(project, (IPath)new Path(platformLocation.getDevice(), "/")).isOK());
        Assert.assertFalse((String)"5.2", (boolean)workspace.validateProjectLocation(project, (IPath)new Path(platformLocation.getDevice(), "\\")).isOK());
        Assert.assertFalse((String)"5.3", (boolean)workspace.validateProjectLocation(project, (IPath)new Path(platformLocation.getDevice(), "")).isOK());
        Assert.assertFalse((String)"5.4", (boolean)workspace.validateProjectLocation(project, platformLocation).isOK());
        Assert.assertFalse((String)"5.5", (boolean)workspace.validateProjectLocation(project, platformLocation.append("foo")).isOK());
        IPath anotherDevice = platformLocation.setDevice("u:");
        Assert.assertTrue((String)"6.1", (boolean)workspace.validateProjectLocation(project, (IPath)new Path("u:", "/")).isOK());
        if (WINDOWS) {
            Assert.assertTrue((String)"6.2", (boolean)workspace.validateProjectLocation(project, (IPath)new Path("u:", "\\")).isOK());
        }
        Assert.assertTrue((String)"6.4", (boolean)workspace.validateProjectLocation(project, anotherDevice).isOK());
        Assert.assertTrue((String)"6.5", (boolean)workspace.validateProjectLocation(project, anotherDevice.append("foo")).isOK());
        Assert.assertFalse((String)"7.1", (boolean)workspace.validateProjectLocation(project, (IPath)new Path("u:", "")).isOK());
        Assert.assertFalse((String)"7.2", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"c:")).isOK());
        Assert.assertFalse((String)"7.3", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"c:foo")).isOK());
        Assert.assertFalse((String)"7.4", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"foo/bar")).isOK());
        Assert.assertFalse((String)"7.5", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"c:foo/bar")).isOK());
        String PATH_VAR_NAME = "FOOVAR";
        IPath PATH_VAR_VALUE = FileSystemHelper.getRandomLocation();
        try {
            IPath varPath = IPath.fromOSString((String)"FOOVAR");
            workspace.getPathVariableManager().setValue("FOOVAR", PATH_VAR_VALUE);
            Assert.assertTrue((String)"8.1", (boolean)workspace.validateProjectLocation(project, varPath).isOK());
            Assert.assertTrue((String)"8.2", (boolean)workspace.validateProjectLocation(project, varPath.append("test")).isOK());
            Assert.assertTrue((String)"8.3", (boolean)workspace.validateProjectLocation(project, varPath.append("test/ing")).isOK());
        }
        finally {
            workspace.getPathVariableManager().setValue("FOOVAR", null);
        }
        IPath openProjectLocation = FileSystemHelper.getTempDir().append("OpenProject");
        IProject open = workspace.getRoot().getProject("OpenProject");
        IProjectDescription openDesc = workspace.newProjectDescription(open.getName());
        openDesc.setLocation(openProjectLocation);
        IPath closedProjectLocation = FileSystemHelper.getTempDir().append("ClosedProject");
        IProject closed = workspace.getRoot().getProject("ClosedProject");
        IProjectDescription closedDesc = workspace.newProjectDescription(closed.getName());
        closedDesc.setLocation(closedProjectLocation);
        open.create(openDesc, null);
        open.open(null);
        closed.create(closedDesc, null);
        IPath linkLocation = FileSystemHelper.getRandomLocation();
        try {
            IProjectDescription desc = open.getDescription();
            desc.setReferencedProjects(new IProject[]{project});
            open.setDescription(desc, 1, ResourceTestUtil.createTestMonitor());
            Assert.assertFalse((String)"9.1", (boolean)workspace.validateProjectLocation(project, openProjectLocation).isOK());
            Assert.assertFalse((String)"9.2", (boolean)workspace.validateProjectLocation(project, closedProjectLocation).isOK());
            Assert.assertTrue((String)"9.3", (boolean)workspace.validateProjectLocation(open, openProjectLocation).isOK());
            Assert.assertFalse((String)"9.4", (boolean)workspace.validateProjectLocation(open, openProjectLocation.append("sub")).isOK());
            linkLocation.toFile().mkdirs();
            Assert.assertTrue((String)"10.1", (boolean)workspace.validateProjectLocation(open, linkLocation).isOK());
            IFolder link = open.getFolder("link");
            link.createLink(linkLocation, 0, ResourceTestUtil.createTestMonitor());
            Assert.assertFalse((String)"10.2", (boolean)workspace.validateProjectLocation(open, linkLocation).isOK());
            Assert.assertFalse((String)"10.3", (boolean)workspace.validateProjectLocation(open, linkLocation.append("sub")).isOK());
            Assert.assertTrue((String)"10.4", (boolean)workspace.validateProjectLocation(project, linkLocation).isOK());
            IPath defaultProjectLocation = workspace.getRoot().getLocation();
            Assert.assertTrue((String)"11.1", (boolean)workspace.validateProjectLocation(project, defaultProjectLocation.append(project.getName())).isOK());
            Assert.assertFalse((String)"11.2", (boolean)workspace.validateProjectLocation(project, defaultProjectLocation.append("foo")).isOK());
        }
        finally {
            Workspace.clear((File)linkLocation.toFile());
            try {
                open.delete(4, ResourceTestUtil.createTestMonitor());
                open.delete(4, ResourceTestUtil.createTestMonitor());
            }
            catch (CoreException coreException) {}
            ResourceTestUtil.removeFromFileSystem(openProjectLocation.toFile());
            ResourceTestUtil.removeFromFileSystem(closedProjectLocation.toFile());
        }
        Assert.assertFalse((String)"12.1", (boolean)workspace.validateProjectLocation(project, platformLocation.addTrailingSeparator().append(".metadata")).isOK());
        IProject metadataProject = workspace.getRoot().getProject(".metadata");
        Assert.assertFalse((String)"12.2", (boolean)workspace.validateProjectLocation(metadataProject, null).isOK());
        Assert.assertTrue((String)"23.1", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"/asf")).isOK());
        Assert.assertTrue((String)"23.2", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"/project/.metadata")).isOK());
        Assert.assertTrue((String)"23.3", (boolean)workspace.validateProjectLocation(project, IPath.fromOSString((String)"/.metadata/project")).isOK());
    }

    @Test
    public void testValidateProjectLocationURI() throws URISyntaxException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("Project");
        URI uri = new URI("eferfsdfwer");
        Assert.assertFalse((String)"1.0", (boolean)workspace.validateProjectLocationURI(project, uri).isOK());
        uri = new URI("blorts://foo.com?bad");
        Assert.assertFalse((String)"1.1", (boolean)workspace.validateProjectLocationURI(project, uri).isOK());
    }

    @Test
    public void testWorkspaceService() {
        BundleContext context = FrameworkUtil.getBundle(IWorkspaceTest.class).getBundleContext();
        ServiceReference ref = context.getServiceReference(IWorkspace.class);
        Assert.assertNotNull((String)"1.0", (Object)ref);
        IWorkspace ws = (IWorkspace)context.getService(ref);
        Assert.assertNotNull((String)"1.1", (Object)ws);
    }

    @Test
    public void testGetFilterMatcherDescriptor() {
        IFilterMatcherDescriptor descriptor = ResourcesPlugin.getWorkspace().getFilterMatcherDescriptor("");
        Assert.assertNull((String)"1.0", (Object)descriptor);
        descriptor = ResourcesPlugin.getWorkspace().getFilterMatcherDescriptor("org.eclipse.core.resources.regexFilterMatcher");
        Assert.assertNotNull((String)"1.1", (Object)descriptor);
    }

    private static /* synthetic */ void lambda$16(IProject iProject, IResource iResource) throws Throwable {
        IStatus iStatus = ResourcesPlugin.getWorkspace().copy(new IResource[]{iProject}, iResource.getFullPath(), true, ResourceTestUtil.createTestMonitor());
    }
}

