/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class LinkedDotProjectTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    private void linkDotProject(IProject project) throws CoreException {
        IFile dotProject = project.getFile(".project");
        if (dotProject.isLinked()) {
            return;
        }
        File targetDiskFile = ResourcesPlugin.getWorkspace().getRoot().getLocation().removeLastSegments(1).append(project.getName()).append(".project").toFile();
        if (!targetDiskFile.exists()) {
            try {
                targetDiskFile.getParentFile().mkdirs();
                Files.copy(dotProject.getLocation().toPath(), targetDiskFile.toPath(), new CopyOption[0]);
            }
            catch (Exception ex) {
                throw new CoreException(Status.error((String)(String.valueOf(targetDiskFile) + " cannot be created"), (Throwable)ex));
            }
        }
        File sourceDiskFile = dotProject.getLocation().toFile();
        dotProject.createLink(IPath.fromFile((File)targetDiskFile), 257, null);
        sourceDiskFile.delete();
    }

    @Test
    public void testGetNature() throws CoreException {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject project = ws.getRoot().getProject("Project");
        Assert.assertThrows(CoreException.class, () -> {
            IProjectNature iProjectNature = project.getNature("org.eclipse.core.tests.resources.simpleNature");
        });
        Assert.assertThrows(CoreException.class, () -> {
            IProjectNature iProjectNature = project.getNature("no.such.nature.Missing");
        });
        project.create(null);
        Assert.assertThrows(CoreException.class, () -> {
            IProjectNature iProjectNature = project.getNature("org.eclipse.core.tests.resources.simpleNature");
        });
        Assert.assertThrows(CoreException.class, () -> {
            IProjectNature iProjectNature = project.getNature("no.such.nature.Missing");
        });
        project.open((IProgressMonitor)new NullProgressMonitor());
        this.linkDotProject(project);
        Assert.assertFalse((boolean)project.getLocation().isPrefixOf(project.getFile(".project").getLocation()));
        Assert.assertNull((String)"3.1", (Object)project.getNature("no.such.nature.Missing"));
        Assert.assertNull((String)"3.2", (Object)project.getNature("org.eclipse.core.tests.resources.earthNature"));
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.earthNature"});
        project.setDescription(desc, null);
        IProjectNature nature = project.getNature("org.eclipse.core.tests.resources.earthNature");
        Assert.assertNotNull((String)"5.0", (Object)nature);
        Assert.assertNull((String)"5.1", (Object)project.getNature("no.such.nature.Missing"));
        Assert.assertEquals((String)"6.0", (Object)project, (Object)nature.getProject());
        Assert.assertFalse((boolean)project.getLocation().isPrefixOf(project.getFile(".project").getLocation()));
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject("testGetNature.Destination");
        IProjectNature nature2 = null;
        project.copy(project2.getFullPath(), 0, null);
        Assert.assertNotEquals((Object)project.getFile(".project").getLocationURI(), (Object)project2.getFile(".project").getLocationURI());
        Assert.assertTrue((boolean)project2.getLocation().isPrefixOf(project2.getFile(".project").getLocation()));
        nature2 = project2.getNature("org.eclipse.core.tests.resources.earthNature");
        Assert.assertNotNull((String)"7.0", (Object)nature2);
        Assert.assertEquals((String)"7.1", (Object)project2, (Object)nature2.getProject());
        Assert.assertEquals((String)"7.2", (Object)project, (Object)nature.getProject());
    }
}

