/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.projectvariables.ProjectLocationVariableResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public class LinkedResourceSyncMoveAndCopyTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    protected IProject existingProject;
    protected IProject otherExistingProject;

    protected IPath resolve(IPath path) {
        return path;
    }

    protected URI resolve(URI uri) {
        return uri;
    }

    @Before
    public void setUp() throws Exception {
        this.existingProject = ResourcesPlugin.getWorkspace().getRoot().getProject("ExistingProject");
        this.otherExistingProject = ResourcesPlugin.getWorkspace().getRoot().getProject("OtherExistingProject");
        ResourceTestUtil.createInWorkspace(new IResource[]{this.existingProject, this.otherExistingProject});
    }

    public void internalMovedAndCopyTest(IResource resource, int copyMoveFlag, boolean copyMoveSucceeds) {
    }

    @Test
    public void testFileLinkedToNonExistent_Deep() throws Exception {
        IFile fileLink = this.existingProject.getFile(ResourceTestUtil.createUniqueString());
        IPath fileLocation = FileSystemHelper.getRandomLocation();
        fileLink.createLink(fileLocation, 16, ResourceTestUtil.createTestMonitor());
        CoreException exception = (CoreException)Assert.assertThrows(CoreException.class, () -> fileLink.setContents(ResourceTestUtil.createRandomString().getBytes(), 0, ResourceTestUtil.createTestMonitor()));
        Assert.assertEquals((String)"1.2", (long)269L, (long)exception.getStatus().getCode());
        Assert.assertTrue((String)"2.0", (boolean)fileLink.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)fileLink, 0, false);
        ResourceTestUtil.createInFileSystem(fileLocation);
        this.workspaceRule.deleteOnTearDown(fileLocation);
        exception = (CoreException)Assert.assertThrows(CoreException.class, () -> fileLink.setContents(ResourceTestUtil.createRandomString().getBytes(), 0, ResourceTestUtil.createTestMonitor()));
        Assert.assertEquals((String)"2.2", (long)274L, (long)exception.getStatus().getCode());
        Assert.assertFalse((String)"3.0", (boolean)fileLink.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)fileLink, 0, false);
        fileLink.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"5.0", (boolean)fileLink.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)fileLink, 0, true);
    }

    @Test
    public void testFileLinkedToNonExistent_Shallow() throws Exception {
        IFile fileLink = this.existingProject.getFile(ResourceTestUtil.createUniqueString());
        IPath fileLocation = FileSystemHelper.getRandomLocation();
        fileLink.createLink(fileLocation, 16, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.0", (boolean)fileLink.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)fileLink, 32, true);
        ResourceTestUtil.createInFileSystem(fileLocation);
        this.workspaceRule.deleteOnTearDown(fileLocation);
        Assert.assertFalse((String)"3.0", (boolean)fileLink.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)fileLink, 32, true);
        fileLink.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"5.0", (boolean)fileLink.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)fileLink, 32, true);
    }

    @Test
    public void testFolderLinkedToNonExistent_Deep() throws CoreException {
        IFolder folderLink = this.existingProject.getFolder(ResourceTestUtil.createUniqueString());
        IPath folderLocation = FileSystemHelper.getRandomLocation();
        folderLink.createLink(folderLocation, 16, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"3.0", (boolean)folderLink.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folderLink, 0, false);
        folderLocation.toFile().mkdir();
        this.workspaceRule.deleteOnTearDown(folderLocation);
        Assert.assertFalse((String)"3.0", (boolean)folderLink.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folderLink, 0, true);
        folderLink.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"5.0", (boolean)folderLink.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folderLink, 0, true);
    }

    @Test
    public void testFolderLinkedToNonExistent_Shallow() throws CoreException {
        IFolder folderLink = this.existingProject.getFolder(ResourceTestUtil.createUniqueString());
        IPath folderLocation = FileSystemHelper.getRandomLocation();
        folderLink.createLink(folderLocation, 16, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.0", (boolean)folderLink.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folderLink, 32, true);
        folderLocation.toFile().mkdir();
        this.workspaceRule.deleteOnTearDown(folderLocation);
        Assert.assertFalse((String)"3.0", (boolean)folderLink.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folderLink, 32, true);
        folderLink.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"5.0", (boolean)folderLink.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folderLink, 32, true);
    }

    @Test
    public void testMoveFolderWithLinksToNonExisitngLocations_withShallow() throws CoreException {
        IFolder folderWithLinks = this.existingProject.getFolder(ResourceTestUtil.createUniqueString());
        folderWithLinks.create(true, true, ResourceTestUtil.createTestMonitor());
        IPath fileLocation = FileSystemHelper.getRandomLocation();
        IFile linkedFile = folderWithLinks.getFile(ResourceTestUtil.createUniqueString());
        linkedFile.createLink(fileLocation, 16, ResourceTestUtil.createTestMonitor());
        folderWithLinks.move(this.otherExistingProject.getFolder(ResourceTestUtil.createUniqueString()).getFullPath(), 32, ResourceTestUtil.createTestMonitor());
        Assert.assertThrows(CoreException.class, () -> folderWithLinks.move(this.otherExistingProject.getFolder(ResourceTestUtil.createUniqueString()).getFullPath(), 0, ResourceTestUtil.createTestMonitor()));
        Assert.assertFalse((String)"5.0", (boolean)folderWithLinks.exists());
        Assert.assertFalse((String)"6.0", (boolean)linkedFile.exists());
    }

    @Test
    @Ignore(value="see bug 299024")
    public void testCopyFolderWithLinksToNonExistingLocations_withShallow() throws CoreException {
        IFolder folderWithLinks = this.existingProject.getFolder(ResourceTestUtil.createUniqueString());
        folderWithLinks.create(true, true, ResourceTestUtil.createTestMonitor());
        IPath fileLocation = FileSystemHelper.getRandomLocation();
        IFile linkedFile = folderWithLinks.getFile(ResourceTestUtil.createUniqueString());
        linkedFile.createLink(fileLocation, 16, ResourceTestUtil.createTestMonitor());
        folderWithLinks.copy(this.otherExistingProject.getFolder(ResourceTestUtil.createUniqueString()).getFullPath(), 32, ResourceTestUtil.createTestMonitor());
        Assert.assertThrows(CoreException.class, () -> folderWithLinks.copy(this.otherExistingProject.getFolder(ResourceTestUtil.createUniqueString()).getFullPath(), 0, ResourceTestUtil.createTestMonitor()));
        Assert.assertTrue((String)"5.0", (boolean)folderWithLinks.exists());
        Assert.assertTrue((String)"6.0", (boolean)linkedFile.exists());
    }

    @Test
    public void testFolderWithFileLinkedToNonExistent_Deep() throws Exception {
        IFolder folder = this.existingProject.getFolder(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)folder);
        IFile fileLinkInFolder = folder.getFile(ResourceTestUtil.createUniqueString());
        IPath fileLocation = FileSystemHelper.getRandomLocation();
        fileLinkInFolder.createLink(fileLocation, 16, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((boolean)folder.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folder, 0, false);
        ResourceTestUtil.createInFileSystem(fileLocation);
        this.workspaceRule.deleteOnTearDown(fileLocation);
        Assert.assertFalse((boolean)folder.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folder, 0, false);
        folder.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((boolean)folder.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folder, 0, true);
    }

    @Test
    public void testFolderWithFileLinkedToNonExistent_Shallow() throws Exception {
        IFolder folder = this.existingProject.getFolder(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)folder);
        IFile fileLinkInFolder = folder.getFile(ResourceTestUtil.createUniqueString());
        IPath fileLocation = FileSystemHelper.getRandomLocation();
        fileLinkInFolder.createLink(fileLocation, 16, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((boolean)folder.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folder, 32, true);
        ResourceTestUtil.createInFileSystem(fileLocation);
        this.workspaceRule.deleteOnTearDown(fileLocation);
        Assert.assertFalse((boolean)folder.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folder, 32, true);
        folder.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((boolean)folder.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folder, 32, true);
    }

    @Test
    public void testFolderWithFolderLinkedToNonExistent_Deep() throws CoreException {
        IFolder folder = this.existingProject.getFolder(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)folder);
        IFolder folderLinkInFolder = folder.getFolder(ResourceTestUtil.createUniqueString());
        IPath folderLocation = FileSystemHelper.getRandomLocation();
        folderLinkInFolder.createLink(folderLocation, 16, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((boolean)folder.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folder, 0, false);
        folderLocation.toFile().mkdir();
        this.workspaceRule.deleteOnTearDown(folderLocation);
        Assert.assertFalse((boolean)folder.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folder, 0, true);
        folder.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((boolean)folder.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folder, 0, true);
    }

    @Test
    public void testFolderWithFolderLinkedToNonExistent_Shallow() throws CoreException {
        IFolder folder = this.existingProject.getFolder(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)folder);
        IFolder folderLinkInFolder = folder.getFolder(ResourceTestUtil.createUniqueString());
        IPath folderLocation = FileSystemHelper.getRandomLocation();
        folderLinkInFolder.createLink(folderLocation, 16, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((boolean)folder.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folder, 32, true);
        folderLocation.toFile().mkdir();
        this.workspaceRule.deleteOnTearDown(folderLocation);
        Assert.assertFalse((boolean)folder.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folder, 32, true);
        folder.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((boolean)folder.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folder, 32, true);
    }

    @Test
    public void test361201() throws CoreException {
        String linkName = ResourceTestUtil.createUniqueString();
        IFile fileLink = this.existingProject.getFile(linkName);
        IFile file = this.existingProject.getFolder("dir").getFile("foo.txt");
        ResourceTestUtil.createInWorkspace((IResource)file.getParent());
        ResourceTestUtil.createInWorkspace(file, "content");
        IPath fileLocation = file.getLocation();
        URI relativeLocation = this.existingProject.getPathVariableManager().convertToRelative(URIUtil.toURI((IPath)fileLocation), true, ProjectLocationVariableResolver.NAME);
        fileLink.createLink(relativeLocation, 16, ResourceTestUtil.createTestMonitor());
        IProject destination = ResourcesPlugin.getWorkspace().getRoot().getProject("DestProject");
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(destination.getName());
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)destination);
        this.existingProject.move(description, 32, ResourceTestUtil.createTestMonitor());
        IProject destProject = ResourcesPlugin.getWorkspace().getRoot().getProject("DestProject");
        ResourceTestUtil.assertExistsInWorkspace((IResource)destProject);
        ResourceTestUtil.assertExistsInWorkspace((IResource)destProject.getFile(linkName));
    }
}

