/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.harness.CancelingProgressMonitor;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.TestPerformer;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;

public class LinkedResourceTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    protected String childName = "File.txt";
    protected IProject closedProject;
    protected IFile existingFileInExistingProject;
    protected IFolder existingFolderInExistingFolder;
    protected IFolder existingFolderInExistingProject;
    protected IProject existingProject;
    protected IProject existingProjectInSubDirectory;
    protected IPath localFile;
    protected IPath localFolder;
    protected IFile nonExistingFileInExistingFolder;
    protected IFile nonExistingFileInExistingProject;
    protected IFile nonExistingFileInOtherExistingProject;
    protected IFolder nonExistingFolderInExistingFolder;
    protected IFolder nonExistingFolderInExistingProject;
    protected IFolder nonExistingFolderInNonExistingFolder;
    protected IFolder nonExistingFolderInNonExistingProject;
    protected IFolder nonExistingFolderInOtherExistingProject;
    protected IPath nonExistingLocation;
    protected IProject nonExistingProject;
    protected IProject otherExistingProject;

    protected void doCleanup() throws Exception {
        ResourceTestUtil.waitForRefresh();
        ResourceTestUtil.createInWorkspace(new IResource[]{this.existingProject, this.otherExistingProject, this.closedProject, this.existingFolderInExistingProject, this.existingFolderInExistingFolder, this.existingFileInExistingProject});
        this.closedProject.close(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.removeFromWorkspace(new IResource[]{this.nonExistingProject, this.nonExistingFolderInExistingProject, this.nonExistingFolderInExistingFolder, this.nonExistingFolderInOtherExistingProject, this.nonExistingFolderInNonExistingProject, this.nonExistingFolderInNonExistingFolder, this.nonExistingFileInExistingProject, this.nonExistingFileInOtherExistingProject, this.nonExistingFileInExistingFolder});
        ResourceTestUtil.removeFromFileSystem(this.resolve(this.nonExistingLocation).toFile());
        this.resolve(this.localFolder).toFile().mkdirs();
        ResourceTestUtil.createInFileSystem(this.resolve(this.localFile));
    }

    private byte[] getFileContents(IFile file) throws CoreException, IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedInputStream inputStream = new BufferedInputStream(file.getContents());){
            ((InputStream)inputStream).transferTo(bout);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return bout.toByteArray();
    }

    protected IPath resolve(IPath path) {
        return path;
    }

    protected URI resolve(URI uri) {
        return uri;
    }

    @Before
    public void setUp() throws Exception {
        this.existingProject = ResourcesPlugin.getWorkspace().getRoot().getProject("ExistingProject");
        this.existingProjectInSubDirectory = ResourcesPlugin.getWorkspace().getRoot().getProject("ExistingProjectInSubDirectory");
        this.otherExistingProject = ResourcesPlugin.getWorkspace().getRoot().getProject("OtherExistingProject");
        this.closedProject = ResourcesPlugin.getWorkspace().getRoot().getProject("ClosedProject");
        this.existingFolderInExistingProject = this.existingProject.getFolder("existingFolderInExistingProject");
        this.existingFolderInExistingFolder = this.existingFolderInExistingProject.getFolder("existingFolderInExistingFolder");
        this.nonExistingFolderInExistingProject = this.existingProject.getFolder("nonExistingFolderInExistingProject");
        this.nonExistingFolderInOtherExistingProject = this.otherExistingProject.getFolder("nonExistingFolderInOtherExistingProject");
        this.nonExistingFolderInNonExistingFolder = this.nonExistingFolderInExistingProject.getFolder("nonExistingFolderInNonExistingFolder");
        this.nonExistingFolderInExistingFolder = this.existingFolderInExistingProject.getFolder("nonExistingFolderInExistingFolder");
        this.nonExistingProject = ResourcesPlugin.getWorkspace().getRoot().getProject("NonProject");
        this.nonExistingFolderInNonExistingProject = this.nonExistingProject.getFolder("nonExistingFolderInNonExistingProject");
        this.existingFileInExistingProject = this.existingProject.getFile("existingFileInExistingProject");
        this.nonExistingFileInExistingProject = this.existingProject.getFile("nonExistingFileInExistingProject");
        this.nonExistingFileInOtherExistingProject = this.otherExistingProject.getFile("nonExistingFileInOtherExistingProject");
        this.nonExistingFileInExistingFolder = this.existingFolderInExistingProject.getFile("nonExistingFileInExistingFolder");
        this.localFolder = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(this.resolve(this.localFolder));
        this.nonExistingLocation = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(this.resolve(this.nonExistingLocation));
        this.localFile = this.localFolder.append(this.childName);
        this.doCleanup();
        if (!this.existingProjectInSubDirectory.exists()) {
            IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription(this.existingProjectInSubDirectory.getName());
            File dir = this.existingProject.getLocation().toFile();
            dir = dir.getParentFile();
            dir = new File(String.valueOf(dir) + File.separator + "sub");
            this.workspaceRule.deleteOnTearDown(IPath.fromOSString((String)dir.getAbsolutePath()));
            dir = new File(String.valueOf(dir) + File.separator + "dir" + File.separator + "more" + File.separator + "proj");
            dir.mkdirs();
            desc.setLocation(IPath.fromOSString((String)dir.getAbsolutePath()));
            this.existingProjectInSubDirectory.create(desc, ResourceTestUtil.createTestMonitor());
        }
        if (!this.existingProjectInSubDirectory.isOpen()) {
            this.existingProjectInSubDirectory.open(ResourceTestUtil.createTestMonitor());
        }
    }

    @Test
    public void testAllowMissingLocal() throws CoreException {
        IPath location = FileSystemHelper.getRandomLocation();
        IFolder folder = this.nonExistingFolderInExistingProject;
        Assert.assertThrows(CoreException.class, () -> folder.createLink(location, 0, ResourceTestUtil.createTestMonitor()));
        folder.createLink(location, 16, ResourceTestUtil.createTestMonitor());
        Assert.assertEquals((String)"1.2", (Object)this.resolve(location), (Object)folder.getLocation());
        Assert.assertTrue((String)"1.3", (!this.resolve(location).toFile().exists() ? 1 : 0) != 0);
        Assertions.assertThat((Object[])folder.members()).isEmpty();
        folder.delete(0, ResourceTestUtil.createTestMonitor());
        IPath nonExistentLocation = Platform.OS.isWindows() ? IPath.fromOSString((String)"b:\\does\\not\\exist") : IPath.fromOSString((String)"/dev/null/does/not/exist");
        IPath canonicalPathLocation = FileUtil.canonicalPath((IPath)nonExistentLocation);
        Assert.assertThrows(CoreException.class, () -> folder.createLink(canonicalPathLocation, 0, ResourceTestUtil.createTestMonitor()));
        folder.createLink(canonicalPathLocation, 16, ResourceTestUtil.createTestMonitor());
        Assert.assertEquals((String)"2.3", (Object)canonicalPathLocation, (Object)folder.getLocation());
        Assert.assertTrue((String)"2.4", (!canonicalPathLocation.toFile().exists() ? 1 : 0) != 0);
        Assert.assertThrows(CoreException.class, () -> folder.getFile("abc.txt").create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor()));
    }

    @Test
    public void testBlockedFolder() throws Exception {
        ResourceTestUtil.createInFileSystem((IResource)this.nonExistingFolderInExistingProject);
        IFile blockedFile = this.nonExistingFolderInExistingProject.getFile("BlockedFile");
        ResourceTestUtil.createInFileSystem(blockedFile.getLocation());
        this.nonExistingFolderInExistingProject.createLink(this.localFolder, 0, ResourceTestUtil.createTestMonitor());
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"1.2", (!blockedFile.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.3", (boolean)this.nonExistingFolderInExistingProject.exists());
        Assert.assertTrue((String)"1.4", (boolean)this.nonExistingFolderInExistingProject.getFile(this.childName).exists());
        Assert.assertEquals((String)"1.5", (Object)this.nonExistingFolderInExistingProject.getLocation(), (Object)this.resolve(this.localFolder));
        this.nonExistingFolderInExistingProject.delete(0, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.0", (!blockedFile.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.1", (!this.nonExistingFolderInExistingProject.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.2", (!this.nonExistingFolderInExistingProject.getFile(this.childName).exists() ? 1 : 0) != 0);
        Assert.assertEquals((String)"2.3", (Object)this.nonExistingFolderInExistingProject.getLocation(), (Object)this.existingProject.getLocation().append(this.nonExistingFolderInExistingProject.getName()));
        this.existingProject.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"3.0", (boolean)blockedFile.exists());
        Assert.assertTrue((String)"3.1", (boolean)this.nonExistingFolderInExistingProject.exists());
        Assert.assertTrue((String)"3.2", (!this.nonExistingFolderInExistingProject.getFile(this.childName).exists() ? 1 : 0) != 0);
        Assert.assertEquals((String)"3.3", (Object)this.nonExistingFolderInExistingProject.getLocation(), (Object)this.existingProject.getLocation().append(this.nonExistingFolderInExistingProject.getName()));
        Assert.assertThrows(CoreException.class, () -> this.nonExistingFolderInExistingProject.createLink(this.localFolder, 0, ResourceTestUtil.createTestMonitor()));
    }

    @Test
    public void testChangeLinkGender() throws Exception {
        IFolder folder = this.nonExistingFolderInExistingProject;
        IFile file = folder.getProject().getFile(folder.getProjectRelativePath());
        IPath resolvedLocation = this.resolve(this.localFolder);
        folder.createLink(this.localFolder, 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.removeFromFileSystem(resolvedLocation.toFile());
        ResourceTestUtil.createInFileSystem(resolvedLocation);
        folder.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"3.0", (!folder.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"3.1", (boolean)file.exists());
        Assert.assertTrue((String)"3.2", (boolean)file.isLinked());
        Assert.assertEquals((String)"3.3", (Object)resolvedLocation, (Object)file.getLocation());
        ResourceTestUtil.removeFromFileSystem(resolvedLocation.toFile());
        resolvedLocation.toFile().mkdirs();
        folder.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"4.0", (boolean)folder.exists());
        Assert.assertTrue((String)"4.1", (!file.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"4.2", (boolean)folder.isLinked());
        Assert.assertEquals((String)"4.3", (Object)resolvedLocation, (Object)folder.getLocation());
    }

    @Test
    public void testCopyFile() throws Exception {
        IResource[] sources = new IResource[]{this.nonExistingFileInExistingProject, this.nonExistingFileInExistingFolder};
        IResource[] destinationResources = new IResource[]{this.existingProject, this.closedProject, this.nonExistingFileInOtherExistingProject, this.nonExistingFileInExistingFolder};
        Boolean[] deepCopy = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
        IProgressMonitor[] iProgressMonitorArray = new IProgressMonitor[3];
        iProgressMonitorArray[0] = new FussyProgressMonitor();
        iProgressMonitorArray[1] = new CancelingProgressMonitor();
        IProgressMonitor[] monitors = iProgressMonitorArray;
        Object[][] inputs = new Object[][]{sources, destinationResources, deepCopy, monitors};
        new TestPerformer("LinkedResourceTest.testCopyFile"){
            protected static final String CANCELED = "canceled";

            @Override
            public void cleanUp(Object[] args, int count) throws Exception {
                super.cleanUp(args, count);
                try {
                    LinkedResourceTest.this.doCleanup();
                }
                catch (Exception e) {
                    throw new IllegalStateException("invocation " + count + " failed to cleanup", e);
                }
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IFile source = (IFile)args[0];
                IResource destination = (IResource)args[1];
                boolean isDeep = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (monitor instanceof FussyProgressMonitor) {
                    FussyProgressMonitor fussy = (FussyProgressMonitor)monitor;
                    fussy.prepare();
                }
                try {
                    source.createLink(LinkedResourceTest.this.localFile, 0, null);
                    source.copy(destination.getFullPath(), isDeep ? 0 : 32, monitor);
                }
                catch (OperationCanceledException e) {
                    return CANCELED;
                }
                if (monitor instanceof FussyProgressMonitor) {
                    FussyProgressMonitor fussy = (FussyProgressMonitor)monitor;
                    fussy.sanityCheck();
                }
                return null;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                IFile source = (IFile)args[0];
                IResource destination = (IResource)args[1];
                boolean isDeep = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (monitor instanceof CancelingProgressMonitor) {
                    return false;
                }
                if (source.equals((Object)destination)) {
                    return true;
                }
                IContainer parent = destination.getParent();
                if (!isDeep && parent == null) {
                    return true;
                }
                if (!parent.isAccessible()) {
                    return true;
                }
                return destination.exists();
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                IFile source = (IFile)args[0];
                IResource destination = (IResource)args[1];
                boolean isDeep = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (result == CANCELED) {
                    return monitor instanceof CancelingProgressMonitor;
                }
                if (!destination.exists()) {
                    return false;
                }
                if (isDeep) {
                    if (destination.isLinked()) {
                        return false;
                    }
                    if (source.getLocation().equals((Object)destination.getLocation())) {
                        return false;
                    }
                    if (!destination.getProject().getLocation().isPrefixOf(destination.getLocation())) {
                        return false;
                    }
                } else {
                    if (!destination.isLinked()) {
                        return false;
                    }
                    if (!source.getLocation().equals((Object)destination.getLocation())) {
                        return false;
                    }
                    if (!source.getRawLocation().equals((Object)destination.getRawLocation())) {
                        return false;
                    }
                    if (!source.getLocationURI().equals(destination.getLocationURI())) {
                        return false;
                    }
                }
                return true;
            }
        }.performTest(inputs);
    }

    @Test
    public void testCopyFolder() throws Exception {
        IFolder[] sources = new IFolder[]{this.nonExistingFolderInExistingProject, this.nonExistingFolderInExistingFolder};
        IResource[] destinations = new IResource[]{this.existingProject, this.closedProject, this.nonExistingProject, this.existingFolderInExistingProject, this.nonExistingFolderInOtherExistingProject, this.nonExistingFolderInExistingFolder};
        Boolean[] deepCopy = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
        IProgressMonitor[] iProgressMonitorArray = new IProgressMonitor[3];
        iProgressMonitorArray[0] = new FussyProgressMonitor();
        iProgressMonitorArray[1] = new CancelingProgressMonitor();
        IProgressMonitor[] monitors = iProgressMonitorArray;
        Object[][] inputs = new Object[][]{sources, destinations, deepCopy, monitors};
        new TestPerformer("LinkedResourceTest.testCopyFolder"){
            protected static final String CANCELED = "canceled";

            @Override
            public void cleanUp(Object[] args, int count) throws Exception {
                super.cleanUp(args, count);
                try {
                    LinkedResourceTest.this.doCleanup();
                }
                catch (Exception e) {
                    throw new IllegalStateException("invocation " + count + " failed to cleanup", e);
                }
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IFolder source = (IFolder)args[0];
                IResource destination = (IResource)args[1];
                boolean isDeep = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (monitor instanceof FussyProgressMonitor) {
                    FussyProgressMonitor fussy = (FussyProgressMonitor)monitor;
                    fussy.prepare();
                }
                try {
                    source.createLink(LinkedResourceTest.this.localFolder, 0, null);
                    source.copy(destination.getFullPath(), isDeep ? 0 : 32, monitor);
                }
                catch (OperationCanceledException e) {
                    return CANCELED;
                }
                if (monitor instanceof FussyProgressMonitor) {
                    FussyProgressMonitor fussy = (FussyProgressMonitor)monitor;
                    fussy.sanityCheck();
                }
                return null;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                IFolder source = (IFolder)args[0];
                IResource destination = (IResource)args[1];
                boolean isDeep = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (monitor instanceof CancelingProgressMonitor) {
                    return false;
                }
                IContainer parent = destination.getParent();
                if (destination.getType() == 4) {
                    return true;
                }
                if (source.equals((Object)destination)) {
                    return true;
                }
                if (!isDeep && parent == null) {
                    return true;
                }
                if (!parent.isAccessible()) {
                    return true;
                }
                return destination.exists();
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                IFolder source = (IFolder)args[0];
                IResource destination = (IResource)args[1];
                boolean isDeep = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (result == CANCELED) {
                    return monitor instanceof CancelingProgressMonitor;
                }
                if (!destination.exists()) {
                    return false;
                }
                if (isDeep) {
                    if (destination.isLinked()) {
                        return false;
                    }
                    if (source.getLocation().equals((Object)destination.getLocation())) {
                        return false;
                    }
                    if (!destination.getProject().getLocation().isPrefixOf(destination.getLocation())) {
                        return false;
                    }
                } else {
                    if (!destination.isLinked()) {
                        return false;
                    }
                    if (!source.getLocation().equals((Object)destination.getLocation())) {
                        return false;
                    }
                    if (!source.getLocationURI().equals(destination.getLocationURI())) {
                        return false;
                    }
                    if (!source.getRawLocation().equals((Object)destination.getRawLocation())) {
                        return false;
                    }
                }
                return true;
            }
        }.performTest(inputs);
    }

    @Test
    public void testCopyMissingFile() throws CoreException {
        IPath location = FileSystemHelper.getRandomLocation();
        IFile linkedFile = this.nonExistingFileInExistingProject;
        linkedFile.createLink(location, 16, ResourceTestUtil.createTestMonitor());
        IFile dest = this.existingProject.getFile("FailedCopyDest");
        Assert.assertThrows(CoreException.class, () -> linkedFile.copy(dest.getFullPath(), 0, ResourceTestUtil.createTestMonitor()));
        Assert.assertTrue((String)"2.1", (!dest.exists() ? 1 : 0) != 0);
        Assert.assertThrows(CoreException.class, () -> linkedFile.copy(dest.getFullPath(), 1, ResourceTestUtil.createTestMonitor()));
        Assert.assertTrue((String)"2.3", (!dest.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testCopyMissingFolder() throws CoreException {
        IPath location = FileSystemHelper.getRandomLocation();
        IFolder linkedFolder = this.nonExistingFolderInExistingProject;
        linkedFolder.createLink(location, 16, ResourceTestUtil.createTestMonitor());
        IFolder dest = this.existingProject.getFolder("FailedCopyDest");
        Assert.assertThrows(CoreException.class, () -> linkedFolder.copy(dest.getFullPath(), 0, ResourceTestUtil.createTestMonitor()));
        Assert.assertTrue((String)"2.1", (!dest.exists() ? 1 : 0) != 0);
        Assert.assertThrows(CoreException.class, () -> linkedFolder.copy(dest.getFullPath(), 1, ResourceTestUtil.createTestMonitor()));
        Assert.assertTrue((String)"2.3", (!dest.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testCopyProjectWithLinks() throws Exception {
        IPath fileLocation = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(fileLocation);
        IFile linkedFile = this.nonExistingFileInExistingProject;
        IFolder linkedFolder = this.nonExistingFolderInExistingProject;
        ResourceTestUtil.createInFileSystem(this.resolve(fileLocation));
        linkedFolder.createLink(this.localFolder, 0, ResourceTestUtil.createTestMonitor());
        linkedFile.createLink(fileLocation, 0, ResourceTestUtil.createTestMonitor());
        IProject destination = ResourcesPlugin.getWorkspace().getRoot().getProject("CopyTargetProject");
        this.existingProject.copy(destination.getFullPath(), 32, ResourceTestUtil.createTestMonitor());
        IFile newFile = destination.getFile(linkedFile.getProjectRelativePath());
        Assert.assertTrue((String)"3.0", (boolean)newFile.isLinked());
        Assert.assertEquals((String)"3.1", (Object)linkedFile.getLocation(), (Object)newFile.getLocation());
        IFolder newFolder = destination.getFolder(linkedFolder.getProjectRelativePath());
        Assert.assertTrue((String)"4.0", (boolean)newFolder.isLinked());
        Assert.assertEquals((String)"4.1", (Object)linkedFolder.getLocation(), (Object)newFolder.getLocation());
        destination.delete(0, ResourceTestUtil.createTestMonitor());
        this.existingProject.copy(destination.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"5.1", (!newFile.isLinked() ? 1 : 0) != 0);
        Assert.assertEquals((String)"5.2", (Object)destination.getLocation().append(newFile.getProjectRelativePath()), (Object)newFile.getLocation());
        Assert.assertTrue((String)"5.3", (!newFolder.isLinked() ? 1 : 0) != 0);
        Assert.assertEquals((String)"5.4", (Object)destination.getLocation().append(newFolder.getProjectRelativePath()), (Object)newFolder.getLocation());
        destination.delete(0, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"6.0", (boolean)this.resolve(fileLocation).toFile().delete());
        Assert.assertThrows(CoreException.class, () -> this.existingProject.copy(destination.getFullPath(), 0, ResourceTestUtil.createTestMonitor()));
        Assert.assertTrue((String)"6.2", (boolean)destination.exists());
        Assert.assertTrue((String)"6.2.1", (!destination.getFile(linkedFile.getName()).exists() ? 1 : 0) != 0);
        IResource[] srcChildren = this.existingProject.members();
        int i = 0;
        while (i < srcChildren.length) {
            if (!srcChildren[i].equals((Object)linkedFile)) {
                Assert.assertNotNull((String)("6.3." + i), (Object)destination.findMember(srcChildren[i].getProjectRelativePath()));
            }
            ++i;
        }
        destination.delete(0, ResourceTestUtil.createTestMonitor());
        Assert.assertThrows(CoreException.class, () -> this.existingProject.copy(destination.getFullPath(), 1, ResourceTestUtil.createTestMonitor()));
        Assert.assertTrue((String)"6.7", (boolean)destination.exists());
        Assert.assertTrue((String)"6.7.1", (!destination.getFile(linkedFile.getName()).exists() ? 1 : 0) != 0);
        srcChildren = this.existingProject.members();
        i = 0;
        while (i < srcChildren.length) {
            if (!srcChildren[i].equals((Object)linkedFile)) {
                Assert.assertNotNull((String)("6.8." + i), (Object)destination.findMember(srcChildren[i].getProjectRelativePath()));
            }
            ++i;
        }
    }

    @Test
    public void testCreateFolderInBackground() throws Exception {
        IFileStore rootStore = this.workspaceRule.getTempStore();
        rootStore.mkdir(0, ResourceTestUtil.createTestMonitor());
        IFileStore childStore = rootStore.getChild("file.txt");
        ResourceTestUtil.createInFileSystem(childStore);
        IFolder link = this.nonExistingFolderInExistingProject;
        link.createLink(rootStore.toURI(), 128, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForRefresh();
        IFile linkChild = link.getFile(childStore.getName());
        Assert.assertTrue((String)"1.0", (boolean)link.exists());
        Assert.assertTrue((String)"1.1", (boolean)link.isSynchronized(2));
        Assert.assertTrue((String)"1.2", (boolean)linkChild.exists());
        Assert.assertTrue((String)"1.3", (boolean)linkChild.isSynchronized(2));
    }

    @Test
    public void testCreateLinkCaseVariant() throws Throwable {
        IFolder link = this.nonExistingFolderInExistingProject;
        IFolder variant = link.getParent().getFolder(IPath.fromOSString((String)link.getName().toUpperCase()));
        ResourceTestUtil.createInWorkspace((IResource)variant);
        ThrowingRunnable linkCreation = () -> link.createLink(this.localFolder, 0, ResourceTestUtil.createTestMonitor());
        if (Workspace.caseSensitive) {
            linkCreation.run();
        } else {
            Assert.assertThrows(CoreException.class, (ThrowingRunnable)linkCreation);
        }
    }

    @Test
    public void testCreateLinkInDotProject() throws Exception {
        IFile dotProject = this.existingProject.getFile(".project");
        IFile link = this.nonExistingFileInExistingProject;
        byte[] oldContents = null;
        link.createLink(this.localFile, 0, ResourceTestUtil.createTestMonitor());
        oldContents = this.getFileContents(dotProject);
        link.delete(0, ResourceTestUtil.createTestMonitor());
        byte[] finalContents = oldContents;
        ResourcesPlugin.getWorkspace().run(monitor -> dotProject.setContents(finalContents, 0, ResourceTestUtil.createTestMonitor()), ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)dotProject), 0, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testCreateProjectWithDeepLinks() throws CoreException {
        IProject project = this.existingProject;
        IFolder parent = this.existingFolderInExistingProject;
        IFolder folder = this.nonExistingFolderInExistingFolder;
        folder.createLink(this.localFolder, 0, ResourceTestUtil.createTestMonitor());
        project.delete(8, ResourceTestUtil.createTestMonitor());
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(128, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"1.0", (boolean)folder.exists());
        Assert.assertTrue((String)"1.1", (boolean)parent.exists());
        Assert.assertTrue((String)"1.2", (boolean)parent.isLocal(2));
    }

    @Test
    public void testCreateHiddenLinkedResources() throws CoreException {
        IFolder folder = this.existingProject.getFolder("folder");
        IFile file = this.existingProject.getFile("file.txt");
        folder.createLink(this.localFolder, 4096, ResourceTestUtil.createTestMonitor());
        file.createLink(this.localFile, 4096, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"3.0", (boolean)folder.isHidden());
        Assert.assertTrue((String)"4.0", (boolean)file.isHidden());
    }

    @Test
    public void testDeepMoveProjectWithLinks() throws Exception {
        IPath fileLocation = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(fileLocation);
        IFile file = this.nonExistingFileInExistingProject;
        IFolder folder = this.nonExistingFolderInExistingProject;
        IFile childFile = folder.getFile(this.childName);
        IResource[] oldResources = new IResource[]{file, folder, this.existingProject, childFile};
        ResourceTestUtil.createInFileSystem(this.resolve(fileLocation));
        folder.createLink(this.localFolder, 0, ResourceTestUtil.createTestMonitor());
        file.createLink(fileLocation, 0, ResourceTestUtil.createTestMonitor());
        IProject destination = ResourcesPlugin.getWorkspace().getRoot().getProject("MoveTargetProject");
        IFile newFile = destination.getFile(file.getProjectRelativePath());
        IFolder newFolder = destination.getFolder(folder.getProjectRelativePath());
        IFile newChildFile = newFolder.getFile(this.childName);
        IResource[] newResources = new IResource[]{destination, newFile, newFolder, newChildFile};
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)destination);
        this.existingProject.move(destination.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace(newResources);
        ResourceTestUtil.assertDoesNotExistInWorkspace(oldResources);
        Assert.assertTrue((String)"3.2", (boolean)this.existingProject.isSynchronized(2));
        Assert.assertTrue((String)"3.3", (boolean)destination.isSynchronized(2));
        Assert.assertTrue((String)"3.4", (!newFile.isLinked() ? 1 : 0) != 0);
        Assert.assertEquals((String)"3.5", (Object)destination.getLocation().append(newFile.getProjectRelativePath()), (Object)newFile.getLocation());
        Assert.assertTrue((String)"3.6", (!newFolder.isLinked() ? 1 : 0) != 0);
        Assert.assertEquals((String)"3.7", (Object)destination.getLocation().append(newFolder.getProjectRelativePath()), (Object)newFolder.getLocation());
        Assert.assertTrue((String)"3.8", (boolean)destination.isSynchronized(2));
    }

    @Test
    public void testDeleteLinkParent() throws CoreException {
        IFolder link = this.nonExistingFolderInExistingFolder;
        IFolder linkParent = this.existingFolderInExistingProject;
        IFile linkChild = link.getFile("child.txt");
        IFileStore childStore = null;
        link.createLink(this.localFolder, 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.createInWorkspace((IResource)linkChild);
        childStore = EFS.getStore((URI)linkChild.getLocationURI());
        Assert.assertTrue((String)"1.0", (boolean)linkParent.exists());
        Assert.assertTrue((String)"1.1", (boolean)link.exists());
        Assert.assertTrue((String)"1.2", (boolean)linkChild.exists());
        linkParent.delete(2, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.0", (!linkParent.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.1", (!link.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.2", (!linkChild.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.3", (boolean)childStore.fetchInfo().exists());
    }

    @Test
    public void testDeleteProjectWithLinks() throws CoreException {
        IFolder link = this.nonExistingFolderInExistingProject;
        link.createLink(this.localFolder, 0, ResourceTestUtil.createTestMonitor());
        this.existingProject.delete(8, ResourceTestUtil.createTestMonitor());
        this.existingProject.create(ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"1.0", (!link.exists() ? 1 : 0) != 0);
        this.existingProject.open(ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.0", (boolean)link.exists());
        Assert.assertTrue((String)"2.1", (boolean)link.isLinked());
        Assert.assertEquals((String)"2.2", (Object)this.resolve(this.localFolder), (Object)link.getLocation());
    }

    @Test
    public void testDeleteLink_Bug351823() throws CoreException {
        IProject project = this.existingProject;
        IFile link = project.getFile(ResourceTestUtil.createUniqueString());
        link.createLink(this.localFile, 0, ResourceTestUtil.createTestMonitor());
        IFile descriptionFile = project.getFile(".project");
        ResourceAttributes attrs = descriptionFile.getResourceAttributes();
        attrs.setReadOnly(true);
        descriptionFile.setResourceAttributes(attrs);
        try {
            Assert.assertThrows(CoreException.class, () -> link.delete(false, ResourceTestUtil.createTestMonitor()));
            Assert.assertTrue((String)"2.0", (boolean)link.exists());
            Assert.assertTrue((String)"3.0", (boolean)link.isLinked());
            HashMap links = ((Project)project).internalGetDescription().getLinks();
            Assert.assertNotNull((String)"4.0", (Object)links);
            Assert.assertEquals((String)"5.0", (long)1L, (long)links.size());
            LinkDescription linkDesc = (LinkDescription)links.values().iterator().next();
            Assert.assertEquals((String)"6.0", (Object)link.getProjectRelativePath(), (Object)linkDesc.getProjectRelativePath());
            Assert.assertThrows(CoreException.class, () -> link.delete(false, ResourceTestUtil.createTestMonitor()));
        }
        finally {
            attrs = descriptionFile.getResourceAttributes();
            attrs.setReadOnly(false);
            descriptionFile.setResourceAttributes(attrs);
        }
    }

    @Test
    public void testDeleteFolderWithLinks() throws CoreException {
        IProject project = this.existingProject;
        IFolder folder = this.existingFolderInExistingProject;
        IFile file1 = folder.getFile(ResourceTestUtil.createUniqueString());
        IFile file2 = project.getFile(ResourceTestUtil.createUniqueString());
        file1.createLink(this.localFile, 0, ResourceTestUtil.createTestMonitor());
        file2.createLink(this.localFile, 0, ResourceTestUtil.createTestMonitor());
        HashMap links = ((Project)project).internalGetDescription().getLinks();
        LinkDescription linkDescription1 = (LinkDescription)links.get(file1.getProjectRelativePath());
        Assert.assertNotNull((String)"1.0", (Object)linkDescription1);
        Assert.assertEquals((String)"1.1", (Object)URIUtil.toURI((IPath)this.localFile), (Object)linkDescription1.getLocationURI());
        LinkDescription linkDescription2 = (LinkDescription)links.get(file2.getProjectRelativePath());
        Assert.assertNotNull((String)"2.0", (Object)linkDescription2);
        Assert.assertEquals((String)"2.1", (Object)URIUtil.toURI((IPath)this.localFile), (Object)linkDescription2.getLocationURI());
        folder.delete(true, ResourceTestUtil.createTestMonitor());
        links = ((Project)project).internalGetDescription().getLinks();
        linkDescription1 = (LinkDescription)links.get(file1.getProjectRelativePath());
        Assert.assertNull((String)"3.0", (Object)linkDescription1);
        linkDescription2 = (LinkDescription)links.get(file2.getProjectRelativePath());
        Assert.assertNotNull((String)"4.0", (Object)linkDescription2);
        Assert.assertEquals((String)"4.1", (Object)URIUtil.toURI((IPath)this.localFile), (Object)linkDescription2.getLocationURI());
    }

    @Test
    public void testFindFilesForLocationCaseVariant() throws CoreException {
        Assume.assumeTrue((String)"only relevant on Windows", (boolean)Platform.OS.isWindows());
        IFolder link = this.nonExistingFolderInExistingProject;
        IPath localLocation = this.resolve(this.localFolder);
        IPath upperCase = localLocation.setDevice(localLocation.getDevice().toUpperCase());
        IPath lowerCase = localLocation.setDevice(localLocation.getDevice().toLowerCase());
        link.createLink(upperCase, 0, ResourceTestUtil.createTestMonitor());
        IPath lowerCaseFilePath = lowerCase.append("file.txt");
        Object[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(lowerCaseFilePath);
        Assertions.assertThat((Object[])files).hasSize(1);
    }

    @Test
    public void testIsLinked() throws CoreException {
        IResource[] toTest;
        IResource[] iResourceArray = toTest = new IResource[]{this.closedProject, this.existingFileInExistingProject, this.existingFolderInExistingFolder, this.existingFolderInExistingProject, this.existingProject, this.nonExistingFileInExistingFolder, this.nonExistingFileInExistingProject, this.nonExistingFileInOtherExistingProject, this.nonExistingFolderInExistingFolder, this.nonExistingFolderInExistingProject, this.nonExistingFolderInNonExistingFolder, this.nonExistingFolderInNonExistingProject, this.nonExistingFolderInOtherExistingProject, this.nonExistingProject, this.otherExistingProject};
        int n = toTest.length;
        int n2 = 0;
        while (n2 < n) {
            IResource t = iResourceArray[n2];
            Assert.assertTrue((String)("1.0 " + String.valueOf(t)), (!t.isLinked() ? 1 : 0) != 0);
            Assert.assertTrue((String)("1.1 " + String.valueOf(t)), (!t.isLinked(0) ? 1 : 0) != 0);
            Assert.assertTrue((String)("1.2 " + String.valueOf(t)), (!t.isLinked(512) ? 1 : 0) != 0);
            ++n2;
        }
        IFolder link = this.nonExistingFolderInExistingProject;
        link.createLink(this.localFolder, 0, ResourceTestUtil.createTestMonitor());
        IFile child = link.getFile(this.childName);
        Assert.assertTrue((String)"2.0", (boolean)child.exists());
        Assert.assertTrue((String)"2.1", (boolean)link.isLinked());
        Assert.assertTrue((String)"2.2", (boolean)link.isLinked(0));
        Assert.assertTrue((String)"2.3", (boolean)link.isLinked(512));
        Assert.assertTrue((String)"2.1", (!child.isLinked() ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.2", (!child.isLinked(0) ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.3", (boolean)child.isLinked(512));
    }

    @Test
    public void testSetLinkLocation() throws CoreException {
        IResource[] toTest;
        IResource[] iResourceArray = toTest = new IResource[]{this.closedProject, this.existingFileInExistingProject, this.existingFolderInExistingFolder, this.existingFolderInExistingProject, this.existingProject, this.nonExistingFileInExistingFolder, this.nonExistingFileInExistingProject, this.nonExistingFileInOtherExistingProject, this.nonExistingFolderInExistingFolder, this.nonExistingFolderInExistingProject, this.nonExistingFolderInNonExistingFolder, this.nonExistingFolderInNonExistingProject, this.nonExistingFolderInOtherExistingProject, this.nonExistingProject, this.otherExistingProject};
        int n = toTest.length;
        int n2 = 0;
        while (n2 < n) {
            IResource toTest1 = iResourceArray[n2];
            Assert.assertTrue((String)("1.0 " + String.valueOf(toTest1)), (!toTest1.isLinked() ? 1 : 0) != 0);
            Assert.assertTrue((String)("1.1 " + String.valueOf(toTest1)), (!toTest1.isLinked(0) ? 1 : 0) != 0);
            Assert.assertTrue((String)("1.2 " + String.valueOf(toTest1)), (!toTest1.isLinked(512) ? 1 : 0) != 0);
            ++n2;
        }
        IFolder link = this.nonExistingFolderInExistingProject;
        link.createLink(this.localFolder, 0, ResourceTestUtil.createTestMonitor());
        IFile child = link.getFile(this.childName);
        Assert.assertTrue((String)"2.0", (boolean)child.exists());
        Assert.assertTrue((String)"2.1", (boolean)link.isLinked());
        Assert.assertTrue((String)"2.2", (boolean)link.isLinked(0));
        Assert.assertTrue((String)"2.3", (boolean)link.isLinked(512));
        Assert.assertTrue((String)"2.1", (!child.isLinked() ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.2", (!child.isLinked(0) ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.3", (boolean)child.isLinked(512));
        link.createLink(this.existingFileInExistingProject.getLocationURI(), 256, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"3.1", (boolean)link.isLinked());
        Assert.assertTrue((String)"3.2", (boolean)link.isLinked(0));
        Assert.assertTrue((String)"3.3", (boolean)link.isLinked(512));
        Assert.assertTrue((String)"3.4", (boolean)link.getLocation().equals((Object)this.existingFileInExistingProject.getLocation()));
    }

    @Test
    public void testSetLinkLocationSwapLinkedResource() throws CoreException {
        IPath parentLoc = this.existingFolderInExistingProject.getLocation();
        IPath childLoc = this.existingFolderInExistingFolder.getLocation();
        this.nonExistingFolderInExistingProject.createLink(parentLoc, 0, ResourceTestUtil.createTestMonitor());
        this.nonExistingFolderInOtherExistingProject.createLink(childLoc, 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.createInWorkspace((IResource)this.nonExistingFolderInOtherExistingProject.getFile("foo"));
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.existingFolderInExistingFolder.members()).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            AbstractStringAssert abstractStringAssert = ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo");
        }});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.nonExistingFolderInOtherExistingProject.members()).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            AbstractStringAssert abstractStringAssert = ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo");
        }});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.nonExistingFolderInExistingProject.members()).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            AbstractStringAssert abstractStringAssert = ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo(this.existingFolderInExistingFolder.getName());
        }});
        this.nonExistingFolderInExistingProject.createLink(childLoc, 256, ResourceTestUtil.createTestMonitor());
        this.nonExistingFolderInOtherExistingProject.createLink(parentLoc, 256, ResourceTestUtil.createTestMonitor());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.existingFolderInExistingFolder.members()).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            AbstractStringAssert abstractStringAssert = ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo");
        }});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.nonExistingFolderInOtherExistingProject.members()).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            AbstractStringAssert abstractStringAssert = ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo(this.existingFolderInExistingFolder.getName());
        }});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.nonExistingFolderInExistingProject.members()).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{member -> {
            AbstractStringAssert abstractStringAssert = ((AbstractStringAssert)Assertions.assertThat((String)member.getName()).as("name", new Object[0])).isEqualTo("foo");
        }});
        Assertions.assertThat((Object)this.nonExistingFolderInExistingProject.getLocation()).isEqualTo((Object)childLoc);
    }

    @Test
    public void testSetLinkLocationPath() throws CoreException {
        IResource[] toTest;
        IResource[] iResourceArray = toTest = new IResource[]{this.closedProject, this.existingFileInExistingProject, this.existingFolderInExistingFolder, this.existingFolderInExistingProject, this.existingProject, this.nonExistingFileInExistingFolder, this.nonExistingFileInExistingProject, this.nonExistingFileInOtherExistingProject, this.nonExistingFolderInExistingFolder, this.nonExistingFolderInExistingProject, this.nonExistingFolderInNonExistingFolder, this.nonExistingFolderInNonExistingProject, this.nonExistingFolderInOtherExistingProject, this.nonExistingProject, this.otherExistingProject};
        int n = toTest.length;
        int n2 = 0;
        while (n2 < n) {
            IResource toTest1 = iResourceArray[n2];
            Assert.assertTrue((String)("1.0 " + String.valueOf(toTest1)), (!toTest1.isLinked() ? 1 : 0) != 0);
            Assert.assertTrue((String)("1.1 " + String.valueOf(toTest1)), (!toTest1.isLinked(0) ? 1 : 0) != 0);
            Assert.assertTrue((String)("1.2 " + String.valueOf(toTest1)), (!toTest1.isLinked(512) ? 1 : 0) != 0);
            ++n2;
        }
        IFolder link = this.nonExistingFolderInExistingProject;
        link.createLink(this.localFolder, 0, ResourceTestUtil.createTestMonitor());
        IFile child = link.getFile(this.childName);
        Assert.assertTrue((String)"2.0", (boolean)child.exists());
        Assert.assertTrue((String)"2.1", (boolean)link.isLinked());
        Assert.assertTrue((String)"2.2", (boolean)link.isLinked(0));
        Assert.assertTrue((String)"2.3", (boolean)link.isLinked(512));
        Assert.assertTrue((String)"2.1", (!child.isLinked() ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.2", (!child.isLinked(0) ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.3", (boolean)child.isLinked(512));
        link.createLink(this.existingFileInExistingProject.getLocation(), 256, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"3.1", (boolean)link.isLinked());
        Assert.assertTrue((String)"3.2", (boolean)link.isLinked(0));
        Assert.assertTrue((String)"3.3", (boolean)link.isLinked(512));
        Assert.assertTrue((String)"3.4", (boolean)link.getLocation().equals((Object)this.existingFileInExistingProject.getLocation()));
    }

    @Test
    public void testLinkedFileInLinkedFolder() throws CoreException, IOException {
        IProject project = this.existingProject;
        IFolder top = project.getFolder("topFolder");
        IFolder linkedFolder = top.getFolder("linkedFolder");
        IFolder subFolder = linkedFolder.getFolder("subFolder");
        IFile linkedFile = subFolder.getFile("Link.txt");
        IFileStore folderStore = this.workspaceRule.getTempStore();
        IFileStore subFolderStore = folderStore.getChild(subFolder.getName());
        IFileStore fileStore = this.workspaceRule.getTempStore();
        IPath folderLocation = URIUtil.toPath((URI)folderStore.toURI());
        IPath fileLocation = URIUtil.toPath((URI)fileStore.toURI());
        subFolderStore.mkdir(0, ResourceTestUtil.createTestMonitor());
        fileStore.openOutputStream(0, ResourceTestUtil.createTestMonitor()).close();
        ResourceTestUtil.createInWorkspace((IResource)top);
        linkedFolder.createLink(folderStore.toURI(), 0, ResourceTestUtil.createTestMonitor());
        linkedFile.createLink(fileStore.toURI(), 0, ResourceTestUtil.createTestMonitor());
        Assert.assertEquals((String)"1.0", (Object)folderLocation, (Object)linkedFolder.getLocation());
        Assert.assertEquals((String)"1.1", (Object)folderLocation.append(subFolder.getName()), (Object)subFolder.getLocation());
        Assert.assertEquals((String)"1.2", (Object)fileLocation, (Object)linkedFile.getLocation());
        Assert.assertEquals((String)"1.0", (Object)folderStore.toURI(), (Object)linkedFolder.getLocationURI());
        Assert.assertEquals((String)"1.1", (Object)subFolderStore.toURI(), (Object)subFolder.getLocationURI());
        Assert.assertEquals((String)"1.2", (Object)fileStore.toURI(), (Object)linkedFile.getLocationURI());
    }

    @Test
    public void testLinkFile() throws Exception {
        IResource[] interestingResources = new IResource[]{this.existingFileInExistingProject, this.nonExistingFileInExistingProject, this.nonExistingFileInExistingFolder};
        IPath[] interestingLocations = new IPath[]{this.localFile, this.localFolder, this.nonExistingLocation};
        IProgressMonitor[] iProgressMonitorArray = new IProgressMonitor[3];
        iProgressMonitorArray[0] = new FussyProgressMonitor();
        iProgressMonitorArray[1] = new CancelingProgressMonitor();
        IProgressMonitor[] monitors = iProgressMonitorArray;
        Object[][] inputs = new Object[][]{interestingResources, interestingLocations, monitors};
        new TestPerformer("LinkedResourceTest.testLinkFile"){
            protected static final String CANCELED = "canceled";

            @Override
            public void cleanUp(Object[] args, int count) throws Exception {
                super.cleanUp(args, count);
                try {
                    LinkedResourceTest.this.doCleanup();
                }
                catch (Exception e) {
                    throw new IllegalStateException("invocation " + count + " failed to cleanup", e);
                }
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IFile file = (IFile)args[0];
                IPath location = (IPath)args[1];
                IProgressMonitor monitor = (IProgressMonitor)args[2];
                if (monitor instanceof FussyProgressMonitor) {
                    FussyProgressMonitor fussy = (FussyProgressMonitor)monitor;
                    fussy.prepare();
                }
                try {
                    file.createLink(location, 0, monitor);
                }
                catch (OperationCanceledException e) {
                    return CANCELED;
                }
                if (monitor instanceof FussyProgressMonitor) {
                    FussyProgressMonitor fussy = (FussyProgressMonitor)monitor;
                    fussy.sanityCheck();
                }
                return null;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                IResource resource = (IResource)args[0];
                IPath location = (IPath)args[1];
                IProgressMonitor monitor = (IProgressMonitor)args[2];
                if (monitor instanceof CancelingProgressMonitor) {
                    return false;
                }
                if (resource.exists()) {
                    return true;
                }
                IPath resolvedLocation = LinkedResourceTest.this.resolve(location);
                if (!resolvedLocation.toFile().exists()) {
                    return true;
                }
                if (ResourcesPlugin.getWorkspace().getRoot().findMember(resource.getFullPath()) != null) {
                    return true;
                }
                if (!resource.getParent().isAccessible()) {
                    return true;
                }
                if (!ResourcesPlugin.getWorkspace().validateName(resource.getName(), 2).isOK()) {
                    return true;
                }
                return resolvedLocation.toFile().isDirectory();
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                IFile resource = (IFile)args[0];
                IPath location = (IPath)args[1];
                IProgressMonitor monitor = (IProgressMonitor)args[2];
                if (result == CANCELED) {
                    return monitor instanceof CancelingProgressMonitor;
                }
                IPath resolvedLocation = LinkedResourceTest.this.resolve(location);
                if (!resource.exists() || !resolvedLocation.toFile().exists()) {
                    return false;
                }
                if (!resource.getLocation().equals((Object)resolvedLocation)) {
                    return false;
                }
                return resource.isSynchronized(2);
            }
        }.performTest(inputs);
    }

    @Test
    public void testLinkFolder() throws Exception {
        IResource[] interestingResources = new IResource[]{this.existingFolderInExistingProject, this.existingFolderInExistingFolder, this.nonExistingFolderInExistingProject, this.nonExistingFolderInNonExistingProject, this.nonExistingFolderInNonExistingFolder, this.nonExistingFolderInExistingFolder};
        IPath[] interestingLocations = new IPath[]{this.localFile, this.localFolder, this.nonExistingLocation};
        IProgressMonitor[] iProgressMonitorArray = new IProgressMonitor[3];
        iProgressMonitorArray[0] = new FussyProgressMonitor();
        iProgressMonitorArray[1] = new CancelingProgressMonitor();
        IProgressMonitor[] monitors = iProgressMonitorArray;
        Object[][] inputs = new Object[][]{interestingResources, interestingLocations, monitors};
        new TestPerformer("LinkedResourceTest.testLinkFolder"){
            protected static final String CANCELED = "canceled";

            @Override
            public void cleanUp(Object[] args, int count) throws Exception {
                super.cleanUp(args, count);
                try {
                    LinkedResourceTest.this.doCleanup();
                }
                catch (Exception e) {
                    throw new IllegalStateException("invocation " + count + " failed to cleanup", e);
                }
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IFolder folder = (IFolder)args[0];
                IPath location = (IPath)args[1];
                IProgressMonitor monitor = (IProgressMonitor)args[2];
                if (monitor instanceof FussyProgressMonitor) {
                    FussyProgressMonitor fussy = (FussyProgressMonitor)monitor;
                    fussy.prepare();
                }
                try {
                    folder.createLink(location, 0, monitor);
                }
                catch (OperationCanceledException e) {
                    return CANCELED;
                }
                if (monitor instanceof FussyProgressMonitor) {
                    FussyProgressMonitor fussy = (FussyProgressMonitor)monitor;
                    fussy.sanityCheck();
                }
                return null;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                IResource resource = (IResource)args[0];
                IPath location = (IPath)args[1];
                IProgressMonitor monitor = (IProgressMonitor)args[2];
                if (monitor instanceof CancelingProgressMonitor) {
                    return false;
                }
                if (resource.exists()) {
                    return true;
                }
                if (!LinkedResourceTest.this.resolve(location).toFile().exists()) {
                    return true;
                }
                if (ResourcesPlugin.getWorkspace().getRoot().findMember(resource.getFullPath()) != null) {
                    return true;
                }
                if (!resource.getParent().isAccessible()) {
                    return true;
                }
                if (!ResourcesPlugin.getWorkspace().validateName(resource.getName(), 2).isOK()) {
                    return true;
                }
                return LinkedResourceTest.this.resolve(location).toFile().isFile();
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                IFolder resource = (IFolder)args[0];
                IPath location = (IPath)args[1];
                IProgressMonitor monitor = (IProgressMonitor)args[2];
                if (result == CANCELED) {
                    return monitor instanceof CancelingProgressMonitor;
                }
                IPath resolvedLocation = LinkedResourceTest.this.resolve(location);
                if (!resource.exists() || !resolvedLocation.toFile().exists()) {
                    return false;
                }
                if (!resource.getLocation().equals((Object)resolvedLocation)) {
                    return false;
                }
                return resource.getFile(LinkedResourceTest.this.childName).exists();
            }
        }.performTest(inputs);
    }

    @Test
    public void testValidateEmptyLinkLocation() {
        IFolder folder = this.nonExistingFolderInExistingProject;
        IPath newLocation = IPath.fromOSString((String)"");
        URI newLocationURI = URIUtil.toURI((IPath)newLocation);
        IStatus linkedResourceStatus = ResourcesPlugin.getWorkspace().validateLinkLocation((IResource)folder, newLocation);
        Assert.assertEquals((String)"1.0", (long)4L, (long)linkedResourceStatus.getSeverity());
        linkedResourceStatus = ResourcesPlugin.getWorkspace().validateLinkLocationURI((IResource)folder, newLocationURI);
        Assert.assertEquals((String)"1.1", (long)4L, (long)linkedResourceStatus.getSeverity());
    }

    @Test
    public void testLocationWithColon() throws CoreException {
        Assume.assumeFalse((String)"not relevant on Windows, as it does not allow a location with colon in the name", (boolean)Platform.OS.isWindows());
        IFolder folder = this.nonExistingFolderInExistingProject;
        IPath location = IPath.fromOSString((String)"c:/temp");
        folder.createLink(location, 16, ResourceTestUtil.createTestMonitor());
        Assert.assertEquals((String)"1.0", (Object)location, (Object)folder.getRawLocation());
    }

    @Test
    public void testModificationStamp() throws Exception {
        IPath location = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(location);
        IFile linkedFile = this.nonExistingFileInExistingProject;
        linkedFile.createLink(location, 16, ResourceTestUtil.createTestMonitor());
        Assert.assertEquals((String)"1.0", (long)-1L, (long)linkedFile.getModificationStamp());
        this.resolve(location).toFile().createNewFile();
        linkedFile.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.0", (linkedFile.getModificationStamp() >= 0L ? 1 : 0) != 0);
        ResourceTestUtil.removeFromFileSystem(this.resolve(location).toFile());
        linkedFile.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assert.assertEquals((String)"4.0", (long)-1L, (long)linkedFile.getModificationStamp());
    }

    @Test
    public void testMoveFile() throws Exception {
        IResource[] sources = new IResource[]{this.nonExistingFileInExistingProject, this.nonExistingFileInExistingFolder};
        IResource[] destinations = new IResource[]{this.existingProject, this.closedProject, this.nonExistingFileInOtherExistingProject, this.nonExistingFileInExistingFolder};
        Boolean[] deepCopy = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
        IProgressMonitor[] iProgressMonitorArray = new IProgressMonitor[3];
        iProgressMonitorArray[0] = new FussyProgressMonitor();
        iProgressMonitorArray[1] = new CancelingProgressMonitor();
        IProgressMonitor[] monitors = iProgressMonitorArray;
        Object[][] inputs = new Object[][]{sources, destinations, deepCopy, monitors};
        new TestPerformer("LinkedResourceTest.testMoveFile"){
            protected static final String CANCELED = "canceled";

            @Override
            public void cleanUp(Object[] args, int count) throws Exception {
                super.cleanUp(args, count);
                try {
                    LinkedResourceTest.this.doCleanup();
                }
                catch (Exception e) {
                    throw new IllegalStateException("invocation " + count + " failed to cleanup", e);
                }
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IFile source = (IFile)args[0];
                IResource destination = (IResource)args[1];
                boolean isDeep = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (monitor instanceof FussyProgressMonitor) {
                    FussyProgressMonitor fussy = (FussyProgressMonitor)monitor;
                    fussy.prepare();
                }
                try {
                    source.createLink(LinkedResourceTest.this.localFile, 0, null);
                    source.move(destination.getFullPath(), isDeep ? 0 : 32, monitor);
                }
                catch (OperationCanceledException e) {
                    return CANCELED;
                }
                if (monitor instanceof FussyProgressMonitor) {
                    FussyProgressMonitor fussy = (FussyProgressMonitor)monitor;
                    fussy.sanityCheck();
                }
                return null;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                IFile source = (IFile)args[0];
                IResource destination = (IResource)args[1];
                boolean isDeep = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (monitor instanceof CancelingProgressMonitor) {
                    return false;
                }
                IContainer parent = destination.getParent();
                if (!isDeep && parent == null) {
                    return true;
                }
                if (!parent.isAccessible()) {
                    return true;
                }
                if (source.equals((Object)destination)) {
                    return true;
                }
                if (source.getType() != destination.getType()) {
                    return true;
                }
                return destination.exists();
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                IResource destination = (IResource)args[1];
                boolean isDeep = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                IPath sourceLocation = LinkedResourceTest.this.resolve(LinkedResourceTest.this.localFile);
                URI sourceLocationURI = URIUtil.toURI((IPath)sourceLocation);
                if (result == CANCELED) {
                    return monitor instanceof CancelingProgressMonitor;
                }
                if (!destination.exists()) {
                    return false;
                }
                if (isDeep) {
                    if (destination.isLinked()) {
                        return false;
                    }
                    if (LinkedResourceTest.this.resolve(LinkedResourceTest.this.localFile).equals((Object)destination.getLocation())) {
                        return false;
                    }
                    if (!destination.getProject().getLocation().isPrefixOf(destination.getLocation())) {
                        return false;
                    }
                } else {
                    if (!destination.isLinked()) {
                        return false;
                    }
                    if (!sourceLocation.equals((Object)destination.getLocation())) {
                        return false;
                    }
                    if (!sourceLocationURI.equals(destination.getLocationURI())) {
                        return false;
                    }
                }
                return true;
            }
        }.performTest(inputs);
    }

    @Test
    public void testMoveFolder() throws Exception {
        IResource[] sourceResources = new IResource[]{this.nonExistingFolderInExistingProject, this.nonExistingFolderInExistingFolder};
        IResource[] destinationResources = new IResource[]{this.existingProject, this.closedProject, this.nonExistingProject, this.existingFolderInExistingProject, this.nonExistingFolderInOtherExistingProject, this.nonExistingFolderInExistingFolder};
        IProgressMonitor[] iProgressMonitorArray = new IProgressMonitor[3];
        iProgressMonitorArray[0] = new FussyProgressMonitor();
        iProgressMonitorArray[1] = new CancelingProgressMonitor();
        IProgressMonitor[] monitors = iProgressMonitorArray;
        Object[][] inputs = new Object[][]{sourceResources, destinationResources, monitors};
        new TestPerformer("LinkedResourceTest.testMoveFolder"){
            protected static final String CANCELED = "canceled";

            @Override
            public void cleanUp(Object[] args, int count) throws Exception {
                super.cleanUp(args, count);
                try {
                    LinkedResourceTest.this.doCleanup();
                }
                catch (Exception e) {
                    throw new IllegalStateException("invocation " + count + " failed to cleanup", e);
                }
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IFolder source = (IFolder)args[0];
                IResource destination = (IResource)args[1];
                IProgressMonitor monitor = (IProgressMonitor)args[2];
                if (monitor instanceof FussyProgressMonitor) {
                    FussyProgressMonitor fussy = (FussyProgressMonitor)monitor;
                    fussy.prepare();
                }
                try {
                    source.createLink(LinkedResourceTest.this.localFolder, 0, null);
                    source.move(destination.getFullPath(), 32, monitor);
                }
                catch (OperationCanceledException e) {
                    return CANCELED;
                }
                if (monitor instanceof FussyProgressMonitor) {
                    FussyProgressMonitor fussy = (FussyProgressMonitor)monitor;
                    fussy.sanityCheck();
                }
                return null;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                IFolder source = (IFolder)args[0];
                IResource destination = (IResource)args[1];
                IProgressMonitor monitor = (IProgressMonitor)args[2];
                if (monitor instanceof CancelingProgressMonitor) {
                    return false;
                }
                IContainer parent = destination.getParent();
                if (parent == null) {
                    return true;
                }
                if (source.equals((Object)destination)) {
                    return true;
                }
                if (source.getType() != destination.getType()) {
                    return true;
                }
                if (!parent.isAccessible()) {
                    return true;
                }
                return destination.exists();
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                IResource destination = (IResource)args[1];
                IProgressMonitor monitor = (IProgressMonitor)args[2];
                if (result == CANCELED) {
                    return monitor instanceof CancelingProgressMonitor;
                }
                if (!destination.exists()) {
                    return false;
                }
                if (!destination.isLinked()) {
                    return false;
                }
                return LinkedResourceTest.this.resolve(LinkedResourceTest.this.localFolder).equals((Object)destination.getLocation());
            }
        }.performTest(inputs);
    }

    @Test
    public void testMoveMissingFile() throws CoreException {
        IPath location = FileSystemHelper.getRandomLocation();
        IFile linkedFile = this.nonExistingFileInExistingProject;
        linkedFile.createLink(location, 16, ResourceTestUtil.createTestMonitor());
        IFile dest = this.existingProject.getFile("FailedMoveDest");
        Assert.assertThrows(CoreException.class, () -> linkedFile.move(dest.getFullPath(), 0, ResourceTestUtil.createTestMonitor()));
        Assert.assertTrue((String)"2.1", (!dest.exists() ? 1 : 0) != 0);
        Assert.assertThrows(CoreException.class, () -> linkedFile.move(dest.getFullPath(), 1, ResourceTestUtil.createTestMonitor()));
        Assert.assertTrue((String)"2.3", (!dest.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testMoveMissingFolder() throws CoreException {
        IPath location = FileSystemHelper.getRandomLocation();
        IFolder linkedFolder = this.nonExistingFolderInExistingProject;
        linkedFolder.createLink(location, 16, ResourceTestUtil.createTestMonitor());
        IFolder dest = this.existingProject.getFolder("FailedMoveDest");
        Assert.assertThrows(CoreException.class, () -> linkedFolder.move(dest.getFullPath(), 0, ResourceTestUtil.createTestMonitor()));
        Assert.assertTrue((String)"2.1", (!dest.exists() ? 1 : 0) != 0);
        Assert.assertThrows(CoreException.class, () -> linkedFolder.move(dest.getFullPath(), 1, ResourceTestUtil.createTestMonitor()));
        Assert.assertTrue((String)"2.3", (!dest.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testMoveProjectWithLinks() throws Exception {
        IPath fileLocation = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(fileLocation);
        IFile file = this.nonExistingFileInExistingProject;
        IFolder folder = this.nonExistingFolderInExistingProject;
        IFile childFile = folder.getFile(this.childName);
        IResource[] oldResources = new IResource[]{file, folder, this.existingProject, childFile};
        ResourceTestUtil.createInFileSystem(this.resolve(fileLocation));
        folder.createLink(this.localFolder, 0, ResourceTestUtil.createTestMonitor());
        file.createLink(fileLocation, 0, ResourceTestUtil.createTestMonitor());
        IProject destination = ResourcesPlugin.getWorkspace().getRoot().getProject("MoveTargetProject");
        IFile newFile = destination.getFile(file.getProjectRelativePath());
        IFolder newFolder = destination.getFolder(folder.getProjectRelativePath());
        IFile newChildFile = newFolder.getFile(this.childName);
        IResource[] newResources = new IResource[]{destination, newFile, newFolder, newChildFile};
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)destination);
        this.existingProject.move(destination.getFullPath(), 32, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace(newResources);
        ResourceTestUtil.assertDoesNotExistInWorkspace(oldResources);
        Assert.assertTrue((String)"3.2", (boolean)newFile.isLinked());
        Assert.assertEquals((String)"3.3", (Object)this.resolve(fileLocation), (Object)newFile.getLocation());
        Assert.assertTrue((String)"3.4", (boolean)newFolder.isLinked());
        Assert.assertEquals((String)"3.5", (Object)this.resolve(this.localFolder), (Object)newFolder.getLocation());
        Assert.assertTrue((String)"3.6", (boolean)destination.isSynchronized(2));
        destination.move(this.existingProject.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace(oldResources);
        ResourceTestUtil.assertDoesNotExistInWorkspace(newResources);
        Assert.assertTrue((String)"5.3", (!file.isLinked() ? 1 : 0) != 0);
        Assert.assertTrue((String)"5.4", (!folder.isLinked() ? 1 : 0) != 0);
        Assert.assertEquals((String)"5.5", (Object)this.existingProject.getLocation().append(file.getProjectRelativePath()), (Object)file.getLocation());
        Assert.assertEquals((String)"5.6", (Object)this.existingProject.getLocation().append(folder.getProjectRelativePath()), (Object)folder.getLocation());
        Assert.assertTrue((String)"5.7", (boolean)this.existingProject.isSynchronized(2));
        Assert.assertTrue((String)"5.8", (boolean)destination.isSynchronized(2));
    }

    @Test
    public void testMoveProjectWithLinks2() throws Exception {
        IPath fileLocation = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(fileLocation);
        IFile linkedFile = this.existingProject.getFile("(test)");
        ResourceTestUtil.createInFileSystem(this.resolve(fileLocation));
        linkedFile.createLink(fileLocation, 0, ResourceTestUtil.createTestMonitor());
        IProject destination = ResourcesPlugin.getWorkspace().getRoot().getProject("CopyTargetProject");
        this.existingProject.move(destination.getFullPath(), 32, ResourceTestUtil.createTestMonitor());
        IFile newFile = destination.getFile(linkedFile.getProjectRelativePath());
        Assert.assertTrue((String)"3.0", (boolean)newFile.isLinked());
        Assert.assertEquals((String)"3.1", (Object)this.resolve(fileLocation), (Object)newFile.getLocation());
    }

    @Test
    public void testMoveFolderWithLinks() throws Exception {
        IFolder folderWithLinks = this.existingProject.getFolder(ResourceTestUtil.createUniqueString());
        folderWithLinks.create(true, true, ResourceTestUtil.createTestMonitor());
        IPath fileLocation = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(fileLocation);
        ResourceTestUtil.createInFileSystem(this.resolve(fileLocation));
        IFile linkedFile = folderWithLinks.getFile(ResourceTestUtil.createUniqueString());
        linkedFile.createLink(fileLocation, 0, ResourceTestUtil.createTestMonitor());
        String string = ResourceTestUtil.readStringInFileSystem(this.existingProject.getFile(".project"));
        Assert.assertTrue((String)"3.0", (boolean)string.contains(linkedFile.getProjectRelativePath().toString()));
        folderWithLinks.move(this.otherExistingProject.getFolder(ResourceTestUtil.createUniqueString()).getFullPath(), 48, ResourceTestUtil.createTestMonitor());
        Assert.assertFalse((String)"5.0", (boolean)folderWithLinks.exists());
        Assert.assertFalse((String)"6.0", (boolean)linkedFile.exists());
        HashMap links = ((ProjectDescription)this.existingProject.getDescription()).getLinks();
        Assert.assertNull((String)"8.0", (Object)links);
        string = ResourceTestUtil.readStringInFileSystem(this.existingProject.getFile(".project"));
        Assert.assertEquals((String)"9.0", (long)-1L, (long)string.indexOf(linkedFile.getProjectRelativePath().toString()));
    }

    @Test
    public void testNatureVeto() throws CoreException {
        IProjectDescription description = this.existingProject.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.core.tests.resources.simpleNature"});
        this.existingProject.setDescription(description, 0, ResourceTestUtil.createTestMonitor());
        Assert.assertThrows(CoreException.class, () -> this.nonExistingFolderInExistingProject.createLink(this.localFolder, 0, ResourceTestUtil.createTestMonitor()));
        Assert.assertThrows(CoreException.class, () -> this.nonExistingFileInExistingProject.createLink(this.localFile, 0, ResourceTestUtil.createTestMonitor()));
        this.existingProject.delete(1, ResourceTestUtil.createTestMonitor());
        this.existingProject.create(ResourceTestUtil.createTestMonitor());
        this.existingProject.open(ResourceTestUtil.createTestMonitor());
        this.nonExistingFolderInExistingProject.createLink(this.localFolder, 0, ResourceTestUtil.createTestMonitor());
        IProjectDescription descriptionAfterProjectRecreation = this.existingProject.getDescription();
        descriptionAfterProjectRecreation.setNatureIds(new String[]{"org.eclipse.core.tests.resources.simpleNature"});
        Assert.assertThrows(CoreException.class, () -> this.existingProject.setDescription(descriptionAfterProjectRecreation, 0, ResourceTestUtil.createTestMonitor()));
    }

    @Test
    public void testNestedLink() throws CoreException {
        IFileStore store1 = this.workspaceRule.getTempStore();
        IFileStore store2 = this.workspaceRule.getTempStore();
        URI location1 = store1.toURI();
        URI location2 = store2.toURI();
        IFolder link = this.existingProject.getFolder("aA");
        IFolder linkChild = link.getFolder("b");
        store1.mkdir(0, ResourceTestUtil.createTestMonitor());
        store2.mkdir(0, ResourceTestUtil.createTestMonitor());
        link.createLink(location1, 0, ResourceTestUtil.createTestMonitor());
        linkChild.createLink(location2, 0, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"1.0", (boolean)link.exists());
        Assert.assertTrue((String)"1.1", (boolean)link.isLinked());
        Assert.assertTrue((String)"1.2", (boolean)linkChild.exists());
        Assert.assertTrue((String)"1.3", (boolean)linkChild.isLinked());
        Assert.assertEquals((String)"1.4", (Object)location1, (Object)link.getLocationURI());
        Assert.assertEquals((String)"1.5", (Object)location2, (Object)linkChild.getLocationURI());
        this.existingProject.delete(8, ResourceTestUtil.createTestMonitor());
        this.existingProject.create(ResourceTestUtil.createTestMonitor());
        this.existingProject.open(0, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.0", (boolean)link.exists());
        Assert.assertTrue((String)"2.1", (boolean)link.isLinked());
        Assert.assertTrue((String)"2.2", (boolean)linkChild.exists());
        Assert.assertTrue((String)"2.3", (boolean)linkChild.isLinked());
        Assert.assertEquals((String)"2.4", (Object)location1, (Object)link.getLocationURI());
        Assert.assertEquals((String)"2.5", (Object)location2, (Object)linkChild.getLocationURI());
    }

    @Test
    public void testRefreshDeepLink() throws Exception {
        IFolder link = this.nonExistingFolderInExistingFolder;
        IPath linkLocation = this.localFolder;
        IPath localChild = linkLocation.append("Child");
        IFile linkChild = link.getFile(localChild.lastSegment());
        ResourceTestUtil.createInFileSystem(this.resolve(localChild));
        link.createLink(linkLocation, 0, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"1.0", (boolean)link.exists());
        Assert.assertTrue((String)"1.1", (boolean)linkChild.exists());
        IProject project = link.getProject();
        project.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.0", (boolean)link.exists());
        Assert.assertTrue((String)"2.1", (boolean)linkChild.exists());
    }

    @Test
    public void testLinkedFolderWithOverlappingLocation_Bug293935_() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath projectLocation = this.existingProject.getLocation();
        IFolder folderByIPath = this.existingProject.getFolder("overlappingLinkedFolderByIPath");
        Assert.assertTrue((String)"1.1", (!workspace.validateLinkLocation((IResource)folderByIPath, projectLocation).isOK() ? 1 : 0) != 0);
        Assert.assertThrows(CoreException.class, () -> folderByIPath.createLink(projectLocation, 0, ResourceTestUtil.createTestMonitor()));
        URI projectLocationURI = this.existingProject.getLocationURI();
        IFolder folderByURI = this.existingProject.getFolder("overlappingLinkedFolderByURI");
        Assert.assertTrue((String)"2.1", (!workspace.validateLinkLocationURI((IResource)folderByURI, projectLocationURI).isOK() ? 1 : 0) != 0);
        Assert.assertThrows(CoreException.class, () -> folderByURI.createLink(projectLocationURI, 0, ResourceTestUtil.createTestMonitor()));
        IPath projectLocationWithoutDevice = projectLocation.setDevice(null);
        IFolder folderByUnixLikeIPath = this.existingProject.getFolder("overlappingLinkedFolderByUnixLikeIPath");
        Assert.assertTrue((String)"3.1", (!workspace.validateLinkLocation((IResource)folderByUnixLikeIPath, projectLocationWithoutDevice).isOK() ? 1 : 0) != 0);
        Assert.assertThrows(CoreException.class, () -> folderByUnixLikeIPath.createLink(projectLocationWithoutDevice, 0, ResourceTestUtil.createTestMonitor()));
        URI projectLocationURIWithoutDevice = URIUtil.toURI((String)projectLocationWithoutDevice.toString());
        IFolder folderByUnixLikeURI = this.existingProject.getFolder("overlappingLinkedFolderByUnixLikeURI");
        Assert.assertTrue((String)"4.1", (!workspace.validateLinkLocationURI((IResource)folderByUnixLikeURI, projectLocationURIWithoutDevice).isOK() ? 1 : 0) != 0);
        Assert.assertThrows(CoreException.class, () -> folderByUnixLikeURI.createLink(projectLocationURIWithoutDevice, 0, ResourceTestUtil.createTestMonitor()));
    }

    @Test
    public void testLinkedFolderWithSymlink_Bug338010() throws Exception {
        Assume.assumeTrue((String)"only relevant for platforms supporting symbolic links", (boolean)FileSystemHelper.canCreateSymLinks());
        IPath baseLocation = FileSystemHelper.getRandomLocation();
        IPath resolvedBaseLocation = this.resolve(baseLocation);
        this.workspaceRule.deleteOnTearDown(resolvedBaseLocation);
        IPath symlinkTarget = resolvedBaseLocation.append("dir1/target");
        symlinkTarget.toFile().mkdirs();
        FileSystemHelper.createSymLink((File)resolvedBaseLocation.toFile(), (String)"symlink", (String)symlinkTarget.toOSString(), (boolean)true);
        IPath linkChildLocation = baseLocation.append("symlink/dir2");
        IPath resolvedLinkChildLocation = this.resolve(linkChildLocation);
        File linkChild = resolvedLinkChildLocation.toFile();
        linkChild.mkdir();
        Assert.assertTrue((String)("Could not create link at location: " + String.valueOf(linkChild)), (boolean)linkChild.exists());
        IFolder folder = this.nonExistingFolderInExistingProject;
        folder.createLink(linkChildLocation, 0, ResourceTestUtil.createTestMonitor());
        Assert.assertEquals((String)"1.2", (Object)resolvedLinkChildLocation, (Object)folder.getLocation());
    }

    @Test
    public void testDeleteLinkTarget_Bug507084() throws Exception {
        Assume.assumeTrue((String)"only relevant for platforms supporting symbolic links", (boolean)FileSystemHelper.canCreateSymLinks());
        IPath baseLocation = FileSystemHelper.getRandomLocation();
        IPath resolvedBaseLocation = this.resolve(baseLocation);
        this.workspaceRule.deleteOnTearDown(resolvedBaseLocation);
        IPath symlinkTarget = resolvedBaseLocation.append("dir1/A");
        symlinkTarget.append("B/C").toFile().mkdirs();
        IPath linkParentDir = resolvedBaseLocation.append("dir2");
        linkParentDir.toFile().mkdirs();
        FileSystemHelper.createSymLink((File)linkParentDir.toFile(), (String)"symlink", (String)symlinkTarget.toOSString(), (boolean)true);
        IFolder folder = this.nonExistingFolderInExistingProject;
        IPath symLink = linkParentDir.append("symlink");
        folder.createLink(symLink, 0, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"1.1", (boolean)folder.exists());
        Assert.assertTrue((String)"1.2", (boolean)folder.getFolder("B/C").exists());
        Assert.assertEquals((String)"1.3", (Object)symLink, (Object)folder.getLocation());
        symLink.toFile().delete();
        linkParentDir.toFile().delete();
        Assert.assertFalse((String)"2.1", (boolean)linkParentDir.toFile().exists());
        folder.getParent().refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"3.1", (boolean)folder.exists());
        Assert.assertFalse((String)"3.2", (boolean)folder.getFolder("B").exists());
        Assert.assertFalse((String)"3.3", (boolean)folder.getFolder("B/C").exists());
    }
}

