/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.resources.LinkedResourceTest;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LinkedResourceWithPathVariableTest
extends LinkedResourceTest {
    private static final String VARIABLE_NAME = "ROOT";
    private static final String PROJECT_VARIABLE_NAME = "PROOT";
    private static final String PROJECT_RELATIVE_VARIABLE_NAME = "RELATIVE_PROOT";
    private static final String PROJECT_RELATIVE_VARIABLE_VALUE = "${PROOT}";
    private IFileStore toSetWritable = null;

    @Override
    @Before
    public void setUp() throws Exception {
        IPath base = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(base);
        ResourcesPlugin.getWorkspace().getPathVariableManager().setValue(VARIABLE_NAME, base);
        base = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(base);
        super.setUp();
        this.existingProject.getPathVariableManager().setValue(PROJECT_VARIABLE_NAME, base);
        this.existingProject.getPathVariableManager().setValue(PROJECT_RELATIVE_VARIABLE_NAME, IPath.fromPortableString((String)PROJECT_RELATIVE_VARIABLE_VALUE));
    }

    @After
    public void tearDown() throws Exception {
        if (this.toSetWritable != null) {
            IFileInfo info = this.toSetWritable.fetchInfo();
            info.setAttribute(2, false);
            this.toSetWritable.putInfo(info, 1024, ResourceTestUtil.createTestMonitor());
            this.toSetWritable = null;
        }
        ResourcesPlugin.getWorkspace().getPathVariableManager().setValue(VARIABLE_NAME, null);
    }

    protected void convertLineEndings(IFileStore inStore, IFileStore outStore, IProgressMonitor mon) throws CoreException, IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            is = inStore.openInputStream(0, mon);
            os = outStore.openOutputStream(0, (IProgressMonitor)new NullProgressMonitor());
            int prevb = 0;
            int ib = is.read();
            while (ib >= 0) {
                switch (ib) {
                    case 13: {
                        os.write(10);
                        break;
                    }
                    case 10: {
                        if (prevb == 13) break;
                        os.write(13);
                        os.write(10);
                        break;
                    }
                    default: {
                        os.write(ib);
                    }
                }
                prevb = ib;
                ib = is.read();
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    private IPath getRandomLocation() {
        IPathVariableManager pathVars = ResourcesPlugin.getWorkspace().getPathVariableManager();
        IPath parent = IPath.fromOSString((String)VARIABLE_NAME);
        IPath path = FileSystemHelper.computeRandomLocation((IPath)parent);
        while (pathVars.resolvePath(path).toFile().exists()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            path = FileSystemHelper.computeRandomLocation((IPath)parent);
        }
        this.workspaceRule.deleteOnTearDown(pathVars.resolvePath(path));
        return path;
    }

    public IPath getRandomProjectLocation() {
        IPathVariableManager pathVars = ResourcesPlugin.getWorkspace().getPathVariableManager();
        IPath parent = IPath.fromOSString((String)PROJECT_VARIABLE_NAME);
        IPath path = FileSystemHelper.computeRandomLocation((IPath)parent);
        while (pathVars.resolvePath(path).toFile().exists()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            path = FileSystemHelper.computeRandomLocation((IPath)parent);
        }
        this.workspaceRule.deleteOnTearDown(pathVars.resolvePath(path));
        return path;
    }

    public IPath getRandomRelativeProjectLocation() {
        IPathVariableManager pathVars = ResourcesPlugin.getWorkspace().getPathVariableManager();
        IPath parent = IPath.fromOSString((String)PROJECT_RELATIVE_VARIABLE_NAME);
        IPath path = FileSystemHelper.computeRandomLocation((IPath)parent);
        while (pathVars.resolvePath(path).toFile().exists()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            path = FileSystemHelper.computeRandomLocation((IPath)parent);
        }
        this.workspaceRule.deleteOnTearDown(pathVars.resolvePath(path));
        return path;
    }

    @Override
    protected IPath resolve(IPath path) {
        return ResourcesPlugin.getWorkspace().getPathVariableManager().resolvePath(path);
    }

    @Override
    protected URI resolve(URI uri) {
        return ResourcesPlugin.getWorkspace().getPathVariableManager().resolveURI(uri);
    }

    @Test
    public void testProjectResolution() {
        IPath relativeValue;
        IPathVariableManager manager = this.existingProject.getPathVariableManager();
        IPath value = manager.getValue(PROJECT_VARIABLE_NAME);
        Assert.assertTrue((String)"1.0", (!value.equals((Object)(relativeValue = manager.getValue(PROJECT_RELATIVE_VARIABLE_NAME))) ? 1 : 0) != 0);
        IPath resolvedValue = manager.resolvePath(value);
        Assert.assertTrue((String)"1.1", (boolean)value.equals((Object)resolvedValue));
        IPath resolvedRelativeValue = manager.resolvePath(relativeValue);
        Assert.assertTrue((String)"1.2", (!relativeValue.equals((Object)resolvedRelativeValue) ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.3", (boolean)resolvedValue.equals((Object)resolvedRelativeValue));
    }

    @Test
    public void testFileVariableRemoved() throws Exception {
        IPathVariableManager manager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        IFile file = this.nonExistingFileInExistingProject;
        IPath existingValue = manager.getValue(VARIABLE_NAME);
        IPath variableBasedLocation = this.getRandomLocation();
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        file.createLink(variableBasedLocation, 16, null);
        file.setContents(ResourceTestUtil.createInputStream("contents for a file"), 1, null);
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        ResourceTestUtil.assertExistsInFileSystem((IResource)file);
        manager.setValue(VARIABLE_NAME, null);
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        file.refreshLocal(1, ResourceTestUtil.createTestMonitor());
        file.getProject().refreshLocal(2, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        Assert.assertThrows(CoreException.class, () -> file.setContents(ResourceTestUtil.createInputStream("new contents"), 0, null));
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        Assert.assertNull((String)"3.6", (Object)file.getLocation());
        IFile other = this.existingProject.getFile("OtherVar");
        ResourcesPlugin.getWorkspace().validateLinkLocation((IResource)other, this.getRandomLocation());
        manager.setValue(VARIABLE_NAME, existingValue);
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        Assert.assertNotNull((String)"5.1", (Object)file.getLocation());
        ResourceTestUtil.assertExistsInFileSystem((IResource)file);
        Assert.assertEquals((String)"5.3", (Object)"contents for a file", (Object)file.readString());
    }

    @Test
    public void testFileProjectVariableRemoved() throws Exception {
        IPathVariableManager manager = this.existingProject.getPathVariableManager();
        IFile file = this.nonExistingFileInExistingProject;
        IPath existingValue = manager.getValue(PROJECT_VARIABLE_NAME);
        IPath variableBasedLocation = this.getRandomProjectLocation();
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        file.createLink(variableBasedLocation, 16, null);
        file.setContents(ResourceTestUtil.createInputStream("contents for a file"), 1, null);
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        ResourceTestUtil.assertExistsInFileSystem((IResource)file);
        manager.setValue(PROJECT_VARIABLE_NAME, null);
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        file.refreshLocal(1, ResourceTestUtil.createTestMonitor());
        file.getProject().refreshLocal(2, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        Assert.assertThrows(CoreException.class, () -> file.setContents(ResourceTestUtil.createInputStream("new contents"), 0, null));
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        Assert.assertNull((String)"3.6", (Object)file.getLocation());
        IFile other = this.existingProject.getFile("OtherVar");
        ResourcesPlugin.getWorkspace().validateLinkLocation((IResource)other, this.getRandomLocation());
        manager.setValue(PROJECT_VARIABLE_NAME, existingValue);
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        Assert.assertNotNull((String)"5.1", (Object)file.getLocation());
        ResourceTestUtil.assertExistsInFileSystem((IResource)file);
        Assert.assertEquals((String)"5.3", (Object)"contents for a file", (Object)file.readString());
    }

    @Test
    public void testMoveFileToDifferentProject() throws Exception {
        IFile file = this.existingProjectInSubDirectory.getFile("my_link");
        IPath variableBasedLocation = null;
        IPath targetPath = this.existingProjectInSubDirectory.getLocation().removeLastSegments(1).append("outside.txt");
        if (!targetPath.toFile().exists()) {
            targetPath.toFile().createNewFile();
        }
        this.workspaceRule.deleteOnTearDown(targetPath);
        variableBasedLocation = this.convertToRelative(targetPath, (IResource)file, true, null);
        IPath resolvedPath = URIUtil.toPath((URI)file.getPathVariableManager().resolveURI(URIUtil.toURI((IPath)variableBasedLocation)));
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        file.createLink(variableBasedLocation, 16, null);
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        ResourceTestUtil.assertExistsInFileSystem((IResource)file);
        IFile newFile = this.nonExistingFileInExistingFolder;
        file.move(newFile.getFullPath(), 32, null);
        ResourceTestUtil.assertExistsInWorkspace((IResource)newFile);
        Assert.assertTrue((String)"3,2", (!newFile.getLocation().equals((Object)newFile.getRawLocation()) ? 1 : 0) != 0);
        Assert.assertEquals((String)"3,3", (Object)newFile.getLocation(), (Object)resolvedPath);
    }

    private IPath convertToRelative(IPath path, IResource res, boolean force, String variableHint) throws CoreException {
        return URIUtil.toPath((URI)res.getPathVariableManager().convertToRelative(URIUtil.toURI((IPath)path), force, variableHint));
    }

    @Test
    public void testPROJECT_LOC_MoveFileToDifferentProject() throws Exception {
        String[] existingVariables;
        String[] stringArray = existingVariables = this.nonExistingFileInExistingFolder.getProject().getPathVariableManager().getPathVariableNames();
        int n = existingVariables.length;
        int n2 = 0;
        while (n2 < n) {
            String existingVariable = stringArray[n2];
            try {
                this.nonExistingFileInExistingFolder.getProject().getPathVariableManager().setValue(existingVariable, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
        IFile file = this.existingProjectInSubDirectory.getFile("my_link2");
        IPath variableBasedLocation = null;
        IPath targetPath = this.existingProjectInSubDirectory.getLocation().removeLastSegments(3).append("outside.txt");
        if (!targetPath.toFile().exists()) {
            targetPath.toFile().createNewFile();
        }
        this.workspaceRule.deleteOnTearDown(targetPath);
        this.existingProjectInSubDirectory.getPathVariableManager().setValue("P_RELATIVE", IPath.fromPortableString((String)"${PARENT-3-PROJECT_LOC}"));
        variableBasedLocation = IPath.fromPortableString((String)"P_RELATIVE/outside.txt");
        IPath resolvedPath = this.existingProjectInSubDirectory.getPathVariableManager().resolvePath(variableBasedLocation);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        file.createLink(variableBasedLocation, 16, null);
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        ResourceTestUtil.assertExistsInFileSystem((IResource)file);
        IFile newFile = this.nonExistingFileInExistingFolder;
        file.move(newFile.getFullPath(), 32, null);
        ResourceTestUtil.assertExistsInWorkspace((IResource)newFile);
        IPath newLocation = newFile.getLocation();
        Assert.assertTrue((String)"3,2", (!newLocation.equals((Object)newFile.getRawLocation()) ? 1 : 0) != 0);
        IPath newRawLocation = newFile.getRawLocation();
        Assert.assertTrue((String)"3,4", (boolean)newRawLocation.equals((Object)variableBasedLocation));
        Assert.assertTrue((String)"3,5", (boolean)newLocation.equals((Object)resolvedPath));
    }

    @Test
    public void testMoveFileProjectVariable() throws CoreException {
        IPathVariableManager manager = this.existingProject.getPathVariableManager();
        IFile file = this.nonExistingFileInExistingProject;
        IPath variableBasedLocation = this.getRandomProjectLocation();
        IPath resolvedPath = manager.resolvePath(variableBasedLocation);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        file.createLink(variableBasedLocation, 16, null);
        file.setContents(ResourceTestUtil.createInputStream("contents for a file"), 1, null);
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        ResourceTestUtil.assertExistsInFileSystem((IResource)file);
        IFile newFile = this.nonExistingFileInExistingFolder;
        file.move(newFile.getFullPath(), 32, null);
        ResourceTestUtil.assertExistsInWorkspace((IResource)newFile);
        Assert.assertTrue((String)"3,2", (!newFile.getLocation().equals((Object)newFile.getRawLocation()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"3,3", (boolean)newFile.getRawLocation().equals((Object)variableBasedLocation));
        Assert.assertTrue((String)"3,4", (boolean)newFile.getRawLocation().equals((Object)variableBasedLocation));
        Assert.assertTrue((String)"3,5", (boolean)newFile.getLocation().equals((Object)resolvedPath));
    }

    @Test
    public void testMoveFileToNewProjectProjectVariable() throws CoreException {
        IPathVariableManager manager = this.existingProject.getPathVariableManager();
        IFile file = this.nonExistingFileInExistingProject;
        IPath variableBasedLocation = this.getRandomRelativeProjectLocation();
        IPath resolvedPath = manager.resolvePath(variableBasedLocation);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        file.createLink(variableBasedLocation, 16, null);
        file.setContents(ResourceTestUtil.createInputStream("contents for a file"), 1, null);
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        ResourceTestUtil.assertExistsInFileSystem((IResource)file);
        IFile newFile = this.nonExistingFileInOtherExistingProject;
        file.move(newFile.getFullPath(), 32, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace((IResource)newFile);
        Assert.assertTrue((String)"3,2", (!newFile.getLocation().equals((Object)newFile.getRawLocation()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"3,3", (boolean)newFile.getRawLocation().equals((Object)variableBasedLocation));
        Assert.assertTrue((String)"3,4", (boolean)newFile.getLocation().equals((Object)resolvedPath));
    }

    @Test
    public void testFileProjectRelativeVariableRemoved() throws Exception {
        IPathVariableManager manager = this.existingProject.getPathVariableManager();
        IFile file = this.nonExistingFileInExistingProject;
        IPath existingValue = manager.getValue(PROJECT_RELATIVE_VARIABLE_NAME);
        IPath variableBasedLocation = this.getRandomRelativeProjectLocation();
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        file.createLink(variableBasedLocation, 16, null);
        file.setContents("contents for a file".getBytes(), 1, null);
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        ResourceTestUtil.assertExistsInFileSystem((IResource)file);
        manager.setValue(PROJECT_RELATIVE_VARIABLE_NAME, null);
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        file.refreshLocal(1, ResourceTestUtil.createTestMonitor());
        file.getProject().refreshLocal(2, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        Assert.assertThrows(CoreException.class, () -> file.setContents(ResourceTestUtil.createInputStream("new contents"), 0, null));
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        Assert.assertNull((String)"3.6", (Object)file.getLocation());
        IFile other = this.existingProject.getFile("OtherVar");
        ResourcesPlugin.getWorkspace().validateLinkLocation((IResource)other, this.getRandomLocation());
        manager.setValue(PROJECT_RELATIVE_VARIABLE_NAME, existingValue);
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        Assert.assertNotNull((String)"5.1", (Object)file.getLocation());
        ResourceTestUtil.assertExistsInFileSystem((IResource)file);
        Assert.assertEquals((String)"5.3", (Object)"contents for a file", (Object)file.readString());
    }

    @Test
    public void testFolderVariableRemoved() throws CoreException {
        IPathVariableManager manager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        IFolder folder = this.nonExistingFolderInExistingProject;
        IFile childFile = folder.getFile(this.childName);
        IPath existingValue = manager.getValue(VARIABLE_NAME);
        IPath variableBasedLocation = this.getRandomLocation();
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)folder);
        folder.createLink(variableBasedLocation, 16, null);
        childFile.create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        childFile.setContents(ResourceTestUtil.createInputStream("contents for a file"), 1, null);
        ResourceTestUtil.assertExistsInWorkspace((IResource)folder);
        ResourceTestUtil.assertExistsInWorkspace((IResource)childFile);
        ResourceTestUtil.assertExistsInFileSystem((IResource)folder);
        ResourceTestUtil.assertExistsInFileSystem((IResource)childFile);
        manager.setValue(VARIABLE_NAME, null);
        ResourceTestUtil.assertExistsInWorkspace((IResource)folder);
        folder.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        folder.getProject().refreshLocal(2, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace((IResource)folder);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)childFile);
        IFile destination = folder.getFile(this.existingFileInExistingProject.getName());
        Assert.assertThrows(CoreException.class, () -> this.existingFileInExistingProject.copy(destination.getFullPath(), 0, ResourceTestUtil.createTestMonitor()));
        Assert.assertTrue((String)"3.6", (!destination.exists() ? 1 : 0) != 0);
        Assert.assertThrows(CoreException.class, () -> destination.create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor()));
        IFolder subFolder = folder.getFolder("SubFolder");
        Assert.assertThrows(CoreException.class, () -> subFolder.create(0, true, ResourceTestUtil.createTestMonitor()));
        Assert.assertThrows(CoreException.class, () -> childFile.setContents(ResourceTestUtil.createInputStream("new contents"), 0, null));
        ResourceTestUtil.assertExistsInWorkspace((IResource)folder);
        Assert.assertNull((String)"4.2", (Object)folder.getLocation());
        manager.setValue(VARIABLE_NAME, existingValue);
        ResourceTestUtil.assertExistsInWorkspace((IResource)folder);
        Assert.assertNotNull((String)"6.1", (Object)folder.getLocation());
        ResourceTestUtil.assertExistsInFileSystem((IResource)folder);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)childFile);
        ResourceTestUtil.assertExistsInFileSystem((IResource)childFile);
        folder.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace((IResource)folder);
        ResourceTestUtil.assertExistsInWorkspace((IResource)childFile);
    }

    @Test
    public void testImportWrongLineEndings_Bug210664() throws Exception {
        IProject proj = this.existingProject;
        IPath randomLocationWithPathVariable = this.getRandomLocation();
        IFileStore projStore = EFS.getStore((URI)proj.getLocationURI());
        if ((projStore.getFileSystem().attributes() & 2) == 0) {
            return;
        }
        IFolder folder = proj.getFolder("SOME_LINK");
        folder.createLink(randomLocationWithPathVariable, 16, null);
        IFileStore projFile = projStore.getChild(".project");
        proj.delete(8, ResourceTestUtil.createTestMonitor());
        IFileStore projNew = projStore.getChild(".project.new");
        this.convertLineEndings(projFile, projNew, ResourceTestUtil.createTestMonitor());
        projNew.move(projFile, 2, ResourceTestUtil.createTestMonitor());
        IFileInfo info = projFile.fetchInfo(0, ResourceTestUtil.createTestMonitor());
        info.setAttribute(2, true);
        projFile.putInfo(info, 1024, ResourceTestUtil.createTestMonitor());
        this.toSetWritable = projFile;
        proj.create(null);
        proj.open(0, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testFolderProjectVariableRemoved() throws CoreException {
        IPathVariableManager manager = this.existingProject.getPathVariableManager();
        IFolder folder = this.nonExistingFolderInExistingProject;
        IFile childFile = folder.getFile(this.childName);
        IPath existingValue = manager.getValue(PROJECT_VARIABLE_NAME);
        IPath variableBasedLocation = this.getRandomProjectLocation();
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)folder);
        folder.createLink(variableBasedLocation, 16, null);
        childFile.create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        childFile.setContents(ResourceTestUtil.createInputStream("contents for a file"), 1, null);
        ResourceTestUtil.assertExistsInWorkspace((IResource)folder);
        ResourceTestUtil.assertExistsInWorkspace((IResource)childFile);
        ResourceTestUtil.assertExistsInFileSystem((IResource)folder);
        ResourceTestUtil.assertExistsInFileSystem((IResource)childFile);
        manager.setValue(PROJECT_VARIABLE_NAME, null);
        ResourceTestUtil.assertExistsInWorkspace((IResource)folder);
        folder.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        folder.getProject().refreshLocal(2, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace((IResource)folder);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)childFile);
        IFile destination = folder.getFile(this.existingFileInExistingProject.getName());
        Assert.assertThrows(CoreException.class, () -> this.existingFileInExistingProject.copy(destination.getFullPath(), 0, ResourceTestUtil.createTestMonitor()));
        Assert.assertTrue((String)"3.6", (!destination.exists() ? 1 : 0) != 0);
        Assert.assertThrows(CoreException.class, () -> destination.create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor()));
        IFolder subFolder = folder.getFolder("SubFolder");
        Assert.assertThrows(CoreException.class, () -> subFolder.create(0, true, ResourceTestUtil.createTestMonitor()));
        Assert.assertThrows(CoreException.class, () -> childFile.setContents(ResourceTestUtil.createInputStream("new contents"), 0, null));
        ResourceTestUtil.assertExistsInWorkspace((IResource)folder);
        Assert.assertNull((String)"4.2", (Object)folder.getLocation());
        manager.setValue(PROJECT_VARIABLE_NAME, existingValue);
        ResourceTestUtil.assertExistsInWorkspace((IResource)folder);
        Assert.assertNotNull((String)"6.1", (Object)folder.getLocation());
        ResourceTestUtil.assertExistsInFileSystem((IResource)folder);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)childFile);
        ResourceTestUtil.assertExistsInFileSystem((IResource)childFile);
        folder.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace((IResource)folder);
        ResourceTestUtil.assertExistsInWorkspace((IResource)childFile);
    }

    @Test
    public void testUndefinedVariable() throws CoreException {
        IPath folderLocation = IPath.fromOSString((String)"NOVAR/folder");
        IPath fileLocation = IPath.fromOSString((String)"NOVAR/abc.txt");
        IFile testFile = this.existingProject.getFile("UndefinedVar.txt");
        IFolder testFolder = this.existingProject.getFolder("UndefinedVarTest");
        Assert.assertThrows(CoreException.class, () -> testFile.createLink(fileLocation, 0, ResourceTestUtil.createTestMonitor()));
        Assert.assertThrows(CoreException.class, () -> testFolder.createLink(folderLocation, 0, ResourceTestUtil.createTestMonitor()));
        Assert.assertTrue((String)"1.2", (ResourcesPlugin.getWorkspace().validateLinkLocation((IResource)testFolder, folderLocation).getSeverity() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.3", (ResourcesPlugin.getWorkspace().validateLinkLocation((IResource)testFile, fileLocation).getSeverity() == 2 ? 1 : 0) != 0);
        testFile.createLink(fileLocation, 16, ResourceTestUtil.createTestMonitor());
        testFolder.createLink(folderLocation, 16, ResourceTestUtil.createTestMonitor());
        IPath copyFileDestination = this.existingProject.getFullPath().append("CopyFileDest");
        IPath copyFolderDestination = this.existingProject.getFullPath().append("CopyFolderDest");
        Assert.assertThrows(CoreException.class, () -> testFile.copy(copyFileDestination, 0, ResourceTestUtil.createTestMonitor()));
        Assert.assertThrows(CoreException.class, () -> testFolder.copy(copyFolderDestination, 0, ResourceTestUtil.createTestMonitor()));
        IPath moveFileDestination = this.existingProject.getFullPath().append("MoveFileDest");
        IPath moveFolderDestination = this.existingProject.getFullPath().append("MoveFolderDest");
        Assert.assertThrows(CoreException.class, () -> testFile.move(moveFileDestination, 0, ResourceTestUtil.createTestMonitor()));
        Assert.assertThrows(CoreException.class, () -> testFolder.move(moveFolderDestination, 0, ResourceTestUtil.createTestMonitor()));
        testFile.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        testFolder.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        testFile.refreshLocal(0, ResourceTestUtil.createTestMonitor());
        testFolder.refreshLocal(0, ResourceTestUtil.createTestMonitor());
        this.existingProject.refreshLocal(0, ResourceTestUtil.createTestMonitor());
        IProject project = testFolder.getProject();
        IProjectDescription desc = project.getDescription();
        desc.setName("moveDest");
        project.move(desc, 33, ResourceTestUtil.createTestMonitor());
        testFile.delete(0, ResourceTestUtil.createTestMonitor());
        testFolder.delete(0, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testVariableChanged() throws Exception {
        IPathVariableManager manager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        IPath existingValue = manager.getValue(VARIABLE_NAME);
        IFile file = this.nonExistingFileInExistingProject;
        IPath variableBasedLocation = this.getRandomLocation();
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        file.createLink(variableBasedLocation, 16, ResourceTestUtil.createTestMonitor());
        file.setContents(ResourceTestUtil.createInputStream("contents for a file"), 1, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        ResourceTestUtil.assertExistsInFileSystem((IResource)file);
        IPath newLocation = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(newLocation);
        manager.setValue(VARIABLE_NAME, newLocation);
        CoreException exception = (CoreException)Assert.assertThrows(CoreException.class, () -> file.setContents(ResourceTestUtil.createInputStream("new contents"), 0, ResourceTestUtil.createTestMonitor()));
        Assert.assertEquals((String)"3.1", (long)274L, (long)exception.getStatus().getCode());
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        ResourceTestUtil.assertDoesNotExistInFileSystem((IResource)file);
        file.setContents(ResourceTestUtil.createInputStream("contents in different location"), 1, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInFileSystem((IResource)file);
        IPath expectedNewLocation = manager.resolvePath(variableBasedLocation);
        IPath actualNewLocation = file.getLocation();
        Assert.assertEquals((String)"4.2", (Object)expectedNewLocation, (Object)actualNewLocation);
        Assert.assertEquals((Object)"contents in different location", (Object)file.readString());
        ResourceTestUtil.removeFromFileSystem((IResource)file);
        manager.setValue(VARIABLE_NAME, existingValue);
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        ResourceTestUtil.assertExistsInFileSystem((IResource)file);
        Assert.assertEquals((String)"5.3", (Object)"contents for a file", (Object)file.readString());
    }

    @Test
    public void testProjectVariableChanged() throws Exception {
        IPathVariableManager manager = this.existingProject.getPathVariableManager();
        IPath existingValue = manager.getValue(PROJECT_VARIABLE_NAME);
        IFile file = this.nonExistingFileInExistingProject;
        IPath variableBasedLocation = this.getRandomProjectLocation();
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        file.createLink(variableBasedLocation, 16, ResourceTestUtil.createTestMonitor());
        file.setContents(ResourceTestUtil.createInputStream("contents for a file"), 1, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        ResourceTestUtil.assertExistsInFileSystem((IResource)file);
        IPath newLocation = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(newLocation);
        manager.setValue(PROJECT_VARIABLE_NAME, newLocation);
        CoreException exception = (CoreException)Assert.assertThrows(CoreException.class, () -> file.setContents(ResourceTestUtil.createInputStream("new contents"), 0, ResourceTestUtil.createTestMonitor()));
        Assert.assertEquals((String)"3.1", (long)274L, (long)exception.getStatus().getCode());
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        ResourceTestUtil.assertDoesNotExistInFileSystem((IResource)file);
        file.setContents(ResourceTestUtil.createInputStream("contents in different location"), 1, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInFileSystem((IResource)file);
        IPath expectedNewLocation = manager.resolvePath(variableBasedLocation);
        IPath actualNewLocation = file.getLocation();
        Assert.assertEquals((String)"4.2", (Object)expectedNewLocation, (Object)actualNewLocation);
        Assert.assertEquals((Object)"contents in different location", (Object)file.readString());
        ResourceTestUtil.removeFromFileSystem((IResource)file);
        manager.setValue(PROJECT_VARIABLE_NAME, existingValue);
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        ResourceTestUtil.assertExistsInFileSystem((IResource)file);
        Assert.assertEquals((String)"5.3", (Object)"contents for a file", (Object)file.readString());
    }

    @Test
    public void testNonRedundentPathVariablesGenerated() throws Exception {
        IFile file = this.existingProjectInSubDirectory.getFile("my_link");
        IPathVariableManager pathVariableManager = this.existingProjectInSubDirectory.getPathVariableManager();
        IPath variableBasedLocation = null;
        IPath targetPath = this.existingProjectInSubDirectory.getLocation().removeLastSegments(1).append("outside.txt");
        if (!targetPath.toFile().exists()) {
            targetPath.toFile().createNewFile();
        }
        this.workspaceRule.deleteOnTearDown(targetPath);
        variableBasedLocation = this.convertToRelative(targetPath, (IResource)file, true, null);
        IPath resolvedPath = URIUtil.toPath((URI)pathVariableManager.resolveURI(URIUtil.toURI((IPath)variableBasedLocation)));
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        Assert.assertEquals((String)"3.1", (Object)targetPath, (Object)resolvedPath);
        variableBasedLocation = this.convertToRelative(targetPath, (IResource)file, true, null);
        resolvedPath = URIUtil.toPath((URI)pathVariableManager.resolveURI(URIUtil.toURI((IPath)variableBasedLocation)));
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        Assert.assertEquals((String)"5.1", (Object)targetPath, (Object)resolvedPath);
    }

    @Test
    public void testConvertToUserEditableFormat() {
        IPathVariableManager pathVariableManager = this.existingProject.getPathVariableManager();
        String[][] table = new String[][]{{"C:\\foo\\bar", "C:\\foo\\bar", "C:/foo/bar"}, {"C:/foo/bar", "C:/foo/bar"}, {"VAR/foo/bar", "VAR/foo/bar"}, {"${VAR}/foo/bar", "${VAR}/foo/bar"}, {"${VAR}/../foo/bar", "${VAR}/../foo/bar", "${PARENT-1-VAR}/foo/bar"}, {"${PARENT-1-VAR}/foo/bar", "${VAR}/../foo/bar"}, {"${PARENT-0-VAR}/foo/bar", "${VAR}/foo/bar", "${VAR}/foo/bar"}, {"${PARENT-VAR}/foo/bar", "${PARENT-VAR}/foo/bar"}, {"${PARENT-2}/foo/bar", "${PARENT-2}/foo/bar"}, {"${PARENT}/foo/bar", "${PARENT}/foo/bar"}, {"${PARENT-2-VAR}/foo/bar", "${VAR}/../../foo/bar"}, {"${PARENT-2-VAR}/foo/${PARENT-4-BAR}", "${VAR}/../../foo/${BAR}/../../../.."}, {"${PARENT-2-VAR}/foo${PARENT-4-BAR}", "${VAR}/../../foo${BAR}/../../../.."}, {"${PARENT-2-VAR}/${PARENT-4-BAR}/foo", "${VAR}/../../${BAR}/../../../../foo"}, {"${PARENT-2-VAR}/f${PARENT-4-BAR}/oo", "${VAR}/../../f${BAR}/../../../../oo"}};
        int i = 0;
        while (i < table.length) {
            String result = pathVariableManager.convertToUserEditableFormat(this.toOS(table[i][0]), false);
            Assert.assertEquals((String)("1." + i), (Object)this.toOS(table[i][1]), (Object)result);
            String original = pathVariableManager.convertFromUserEditableFormat(result, false);
            Assert.assertEquals((String)("2." + i), (Object)this.toOS(table[i].length == 2 ? table[i][0] : table[i][2]), (Object)original);
            ++i;
        }
        String[][] tableLocationFormat = new String[][]{{"C:\\foo\\bar", "C:\\foo\\bar", "C:/foo/bar"}, {"C:/foo/bar", "C:/foo/bar"}, {"VAR/foo/bar", "VAR/foo/bar"}, {"${VAR}/../foo/bar", "${VAR}/../foo/bar", "PARENT-1-VAR/foo/bar"}, {"PARENT-1-VAR/foo/bar", "VAR/../foo/bar"}, {"PARENT-0-VAR/foo/bar", "VAR/foo/bar", "VAR/foo/bar"}, {"PARENT-VAR/foo/bar", "PARENT-VAR/foo/bar"}, {"PARENT-2/foo/bar", "PARENT-2/foo/bar"}, {"PARENT/foo/bar", "PARENT/foo/bar"}, {"PARENT-2-VAR/foo/bar", "VAR/../../foo/bar"}, {"PARENT-2-VAR/foo/PARENT-4-BAR", "VAR/../../foo/PARENT-4-BAR"}, {"PARENT-2-VAR/fooPARENT-4-BAR", "VAR/../../fooPARENT-4-BAR"}, {"PARENT-2-VAR/PARENT-4-BAR/foo", "VAR/../../PARENT-4-BAR/foo"}, {"PARENT-2-VAR/fPARENT-4-BAR/oo", "VAR/../../fPARENT-4-BAR/oo"}, {"/foo/bar", "/foo/bar"}};
        int i2 = 0;
        while (i2 < table.length) {
            String result = pathVariableManager.convertToUserEditableFormat(this.toOS(tableLocationFormat[i2][0]), true);
            Assert.assertEquals((String)("3." + i2), (Object)this.toOS(tableLocationFormat[i2][1]), (Object)result);
            String original = pathVariableManager.convertFromUserEditableFormat(result, true);
            Assert.assertEquals((String)("4." + i2), (Object)this.toOS(tableLocationFormat[i2].length == 2 ? tableLocationFormat[i2][0] : tableLocationFormat[i2][2]), (Object)original);
            ++i2;
        }
    }

    private String toOS(String path) {
        return path.replace('/', File.separatorChar);
    }

    @Test
    public void testPrefixVariablesAreNotConfused() {
        URI uri = this.nonExistingFileInExistingFolder.getPathVariableManager().getURIValue("PARENT");
        Assert.assertEquals((String)"1.0", (Object)uri, null);
        uri = this.nonExistingFileInExistingFolder.getPathVariableManager().getURIValue("PARENT_LOC");
        Assert.assertNotNull((String)"1.1", (Object)uri);
    }

    @Test
    public void test338185() {
        IPathVariableManager manager = this.existingProject.getPathVariableManager();
        String[] variables = manager.getPathVariableNames();
        boolean found = false;
        String[] stringArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            String variable = stringArray[n2];
            if (variable.equals("Test338185")) {
                found = true;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)found);
    }
}

