/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.resources.IMarkerSetElement;
import org.eclipse.core.internal.resources.MarkerAttributeMap;
import org.eclipse.core.internal.resources.MarkerInfo;
import org.eclipse.core.internal.resources.MarkerSet;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class MarkerSetTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    private void assertMarkerElementsEqual(IMarkerSetElement[] array1, IMarkerSetElement[] array2) {
        Assert.assertNotNull((Object)array1);
        Assert.assertNotNull((Object)array2);
        Assertions.assertThat((Object[])array1).hasSameSizeAs((Object)array2);
        IMarkerSetElement[] m1 = new IMarkerSetElement[array1.length];
        System.arraycopy(array1, 0, m1, 0, array1.length);
        IMarkerSetElement[] m2 = new IMarkerSetElement[array2.length];
        System.arraycopy(array2, 0, m2, 0, array2.length);
        Comparator compare = (e1, e2) -> {
            long id2;
            long id1 = e1.getId();
            if (id1 == (id2 = e2.getId())) {
                return 0;
            }
            return id1 < id2 ? -1 : 1;
        };
        Arrays.sort(m1, compare);
        Arrays.sort(m2, compare);
        int i = 0;
        while (i < m1.length) {
            Assert.assertEquals((long)m1[i].getId(), (long)m2[i].getId());
            ++i;
        }
    }

    @Test
    public void testAdd() {
        MarkerSet set = new MarkerSet();
        int max = 100;
        MarkerInfo info = null;
        MarkerInfo[] infos = new MarkerInfo[max];
        int i = 0;
        while (i < max) {
            info = new MarkerInfo("org.eclipse.core.resources.problemmarker", (long)i);
            info.setAttribute("message", (Object)ResourceTestUtil.createRandomString(), true);
            infos[i] = info;
            ++i;
        }
        i = 0;
        while (i < infos.length) {
            info = infos[i];
            set.add((IMarkerSetElement)info);
            Assert.assertTrue((String)("2.0." + i), (boolean)set.contains(info.getId()));
            Assert.assertEquals((String)("2.1." + i), (long)(i + 1), (long)set.size());
            ++i;
        }
        Assert.assertEquals((String)"3.0", (long)max, (long)set.size());
        i = 0;
        while (i < infos.length) {
            info = infos[i];
            Assert.assertTrue((String)("3.1." + i), (boolean)set.contains(info.getId()));
            Assert.assertNotNull((String)("3.2." + i), (Object)set.get(info.getId()));
            ++i;
        }
    }

    @Test
    public void testElements() {
        MarkerSet set = new MarkerSet();
        int max = 100;
        MarkerInfo info = null;
        MarkerInfo[] infos = new MarkerInfo[max];
        int i = 0;
        while (i < max) {
            info = new MarkerInfo("org.eclipse.core.resources.problemmarker", (long)i);
            info.setAttribute("message", (Object)ResourceTestUtil.createRandomString(), true);
            infos[i] = info;
            ++i;
        }
        set.addAll((IMarkerSetElement[])infos);
        Assert.assertEquals((String)"1.0", (long)max, (long)set.size());
        this.assertMarkerElementsEqual(set.elements(), (IMarkerSetElement[])infos);
    }

    @Test
    public void testRemove() {
        MarkerSet set = new MarkerSet();
        int max = 100;
        MarkerInfo info = null;
        MarkerInfo[] infos = new MarkerInfo[max];
        int i = 0;
        while (i < max) {
            info = new MarkerInfo("org.eclipse.core.resources.problemmarker", (long)i);
            info.setAttribute("message", (Object)ResourceTestUtil.createRandomString(), true);
            infos[i] = info;
            ++i;
        }
        set.addAll((IMarkerSetElement[])infos);
        Assert.assertEquals((String)"1.0", (long)max, (long)set.size());
        i = max - 1;
        while (i >= 0) {
            info = infos[i];
            set.remove((IMarkerSetElement)info);
            Assert.assertTrue((String)("2.0." + i), (!set.contains(info.getId()) ? 1 : 0) != 0);
            Assert.assertEquals((String)("2.1," + i), (long)i, (long)set.size());
            int j = 0;
            while (j < i) {
                Assert.assertTrue((String)("2.2." + j), (boolean)set.contains(infos[j].getId()));
                ++j;
            }
            --i;
        }
        Assert.assertEquals((String)"3.0", (long)0L, (long)set.size());
    }

    @Test
    public void testMarkerAttributeMap() {
        MarkerAttributeMap map = new MarkerAttributeMap();
        String notInternalString = String.valueOf("notIntern".toCharArray());
        Assert.assertNotSame((Object)notInternalString.intern(), (Object)notInternalString);
        map.put(notInternalString, (Object)notInternalString);
        String key = (String)((Map.Entry)map.entrySet().iterator().next()).getKey();
        Assert.assertSame((Object)notInternalString.intern(), (Object)key);
        try {
            map.put(null, (Object)1);
            Assert.fail((String)"NPE for nul key expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            map.put("0", null);
            Assert.fail((String)"NPE for null value expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        map.put("1", (Object)1);
        map.put("2", (Object)"2");
        Map map2 = map.toMap();
        Assert.assertEquals((Object)"2", map2.get("2"));
        Assert.assertEquals((Object)1, map2.get("1"));
        map2.put(null, 1);
        map2.put("0", null);
    }
}

