/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.MarkerReader;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.tests.resources.MarkerAttributeChangeListener;
import org.eclipse.core.tests.resources.MarkersChangeListener;
import org.eclipse.core.tests.resources.MarkersNumberOfDeltasChangeListener;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class MarkerTest {
    @Rule
    public TestName testName = new TestName();
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    public static final String TRANSIENT_MARKER = "org.eclipse.core.tests.resources.transientmarker";
    public static final String TEST_PROBLEM_MARKER = "org.eclipse.core.tests.resources.testproblem";
    IResource[] resources;
    private boolean originalRefreshSetting;
    private MarkersChangeListener registeredResourceChangeLister;

    private void setResourceChangeListener(MarkersChangeListener listener) throws CoreException {
        if (this.registeredResourceChangeLister != null) {
            ResourcesPlugin.getWorkspace().run(p -> ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.registeredResourceChangeLister), null);
        }
        this.registeredResourceChangeLister = listener;
        if (listener == null) {
            return;
        }
        ResourcesPlugin.getWorkspace().run(p -> ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener), null);
    }

    protected void addChildren(ArrayList<String> result, IPath root, int breadth, int depth) {
        int i = 1;
        while (i < breadth + 1) {
            IPath child = root.append("" + i);
            if (depth == 0) {
                result.add(child.toString());
                return;
            }
            child = child.addTrailingSeparator();
            result.add(child.toString());
            this.addChildren(result, child, breadth, depth - 1);
            ++i;
        }
    }

    protected void assertMarkersDoNotExist(IMarker[] markers) {
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            this.assertMarkerDoesNotExist(marker);
            ++n2;
        }
    }

    protected void assertMarkerDoesNotExist(IMarker marker) {
        Assert.assertFalse((String)String.format("marker '%s' exists unexpectedly for resource '%s'", marker, marker.getResource()), (boolean)marker.exists());
    }

    protected void assertMarkersExist(IMarker[] markers) {
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            this.assertMarkerExists(marker);
            ++n2;
        }
    }

    protected void assertMarkerExists(IMarker marker) {
        Assert.assertTrue((String)String.format("marker '%s' does not exist for resource '%s'", marker, marker.getResource()), (boolean)marker.exists());
    }

    private void assertMarkerHasAttributeValue(IMarker marker, String attributeName, Object expectedValue) throws CoreException {
        ObjectAssert asserted = (ObjectAssert)Assertions.assertThat((Object)marker.getAttribute(attributeName)).as("attribute %s of marker %s", new Object[]{attributeName, marker});
        if (expectedValue == null) {
            asserted.isNull();
        } else {
            asserted.isEqualTo(expectedValue);
        }
    }

    private void assertSingleMarkerWithId(IMarker[] markers, long id) {
        ((ObjectArrayAssert)Assertions.assertThat((Object[])markers).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{marker -> {
            AbstractLongAssert abstractLongAssert = ((AbstractLongAssert)Assertions.assertThat((long)marker.getId()).as("id of marker %s", new Object[]{marker})).isEqualTo(id);
        }});
    }

    private void assertMarkerIsSubtype(IMarker marker, String superType) throws CoreException {
        Assert.assertTrue((String)String.format("Marker '%s' is no subtype of %s", marker, superType), (boolean)marker.isSubtypeOf(superType));
    }

    private void assertMarkerIsNoSubtype(IMarker marker, String superType) throws CoreException {
        Assert.assertFalse((String)String.format("Marker '%s' is subtype of %s", marker, superType), (boolean)marker.isSubtypeOf(superType));
    }

    public IResource[] createLargeHierarchy() throws CoreException {
        ArrayList<String> result = new ArrayList<String>();
        result.add("/");
        new MarkerTest().addChildren(result, IPath.ROOT, 3, 4);
        String[] names = result.toArray(new String[result.size()]);
        IResource[] created = ResourceTestUtil.buildResources((IContainer)ResourcesPlugin.getWorkspace().getRoot(), names);
        ResourceTestUtil.createInWorkspace(created);
        return created;
    }

    protected IMarker[] createMarkers(IResource[] hosts, String type) throws CoreException {
        IMarker[] result = new IMarker[hosts.length];
        ResourcesPlugin.getWorkspace().run(monitor -> {
            int i = 0;
            while (i < hosts.length) {
                iMarkerArray[i] = hosts[i].createMarker(type);
                ++i;
            }
        }, ResourceTestUtil.createTestMonitor());
        return result;
    }

    public void createProblem(IResource host, int severity) throws CoreException {
        IMarker marker = host.createMarker("org.eclipse.core.resources.problemmarker");
        marker.setAttribute("severity", severity);
    }

    @Before
    public void setUp() throws Exception {
        this.resources = ResourceTestUtil.buildResources((IContainer)ResourcesPlugin.getWorkspace().getRoot(), new String[]{"/", "1/", "1/1", "1/2/", "1/2/1", "1/2/2/", "2/", "2/1", "2/2/", "2/2/1", "2/2/2/"});
        ResourceTestUtil.createInWorkspace(this.resources);
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        this.originalRefreshSetting = prefs.getBoolean("refresh.enabled", false);
        prefs.putBoolean("refresh.enabled", false);
        Job.getJobManager().wakeUp(ResourcesPlugin.FAMILY_AUTO_REFRESH);
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, null);
    }

    @After
    public void tearDown() throws Exception {
        if (this.registeredResourceChangeLister != null) {
            this.setResourceChangeListener(null);
        }
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        prefs.putBoolean("refresh.enabled", this.originalRefreshSetting);
    }

    @Test
    public void testMarkerChangesInDelta3() throws CoreException {
        MarkersChangeListener listener = new MarkersChangeListener();
        this.setResourceChangeListener(listener);
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember("1");
        IMarker[] markers = new IMarker[4];
        IPath destination = resource.getFullPath().removeLastSegments(1).append(resource.getFullPath().lastSegment() + "new");
        markers[0] = resource.createMarker("org.eclipse.core.resources.bookmark");
        IResource child = ((IProject)resource).members()[0];
        markers[1] = child.createMarker("org.eclipse.core.resources.taskmarker");
        listener.reset();
        resource.move(destination, false, ResourceTestUtil.createTestMonitor());
        IResource destinationResource = ResourcesPlugin.getWorkspace().getRoot().findMember(destination);
        markers[2] = destinationResource.getMarker(markers[0].getId());
        IResource destinationChild = ((IProject)destinationResource).findMember(child.getName());
        markers[3] = destinationChild.getMarker(markers[1].getId());
        listener.assertNumberOfAffectedResources(4);
        listener.assertChanges(resource, null, new IMarker[]{markers[0]}, null);
        listener.assertChanges(child, null, new IMarker[]{markers[1]}, null);
        listener.assertChanges(destinationResource, new IMarker[]{markers[2]}, null, null);
        listener.assertChanges(destinationChild, new IMarker[]{markers[3]}, null, null);
        resource = ResourcesPlugin.getWorkspace().getRoot().findMember("2");
        destination = resource.getFullPath().removeLastSegments(1).append(resource.getFullPath().lastSegment() + "copy");
        resource.createMarker("org.eclipse.core.resources.bookmark");
        listener.reset();
        resource.copy(destination, false, ResourceTestUtil.createTestMonitor());
        listener.assertNumberOfAffectedResources(0);
        ResourcesPlugin.getWorkspace().getRoot().deleteMarkers(null, true, 2);
    }

    @Test
    public void testCopyResource() {
    }

    @Test
    public void testCreateMarker() throws CoreException {
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            MarkersChangeListener listener = new MarkersChangeListener();
            this.setResourceChangeListener(listener);
            IMarker[] markers = new IMarker[]{resource.createMarker("org.eclipse.core.resources.problemmarker"), resource.createMarker("org.eclipse.core.resources.bookmark"), resource.createMarker("org.eclipse.core.resources.taskmarker")};
            this.assertMarkersExist(markers);
            listener.assertNumberOfAffectedResources(1);
            listener.assertChanges(resource, markers, null, null);
            Assert.assertThrows((String)resource.getFullPath().toString(), RuntimeException.class, () -> {
                IMarker iMarker = resource.createMarker(null);
            });
            ++n2;
        }
        IFile testResource = ResourcesPlugin.getWorkspace().getRoot().getFile(IPath.fromOSString((String)"non/existant/resource"));
        Assert.assertFalse((String)("resource should not exist: " + String.valueOf(testResource)), (boolean)testResource.exists());
        Assert.assertThrows((String)testResource.getFullPath().toString(), CoreException.class, () -> MarkerTest.lambda$5((IResource)testResource));
    }

    @Test
    public void testCreateMarkerWithAttributes() throws CoreException {
        MarkersChangeListener listener = new MarkersChangeListener();
        this.setResourceChangeListener(listener);
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            listener.reset();
            IMarker[] markers = new IMarker[]{resource.createMarker("org.eclipse.core.resources.problemmarker", null), resource.createMarker("org.eclipse.core.resources.bookmark", Collections.emptyMap()), resource.createMarker("org.eclipse.core.resources.taskmarker", Map.of("message", "My text"))};
            this.assertMarkersExist(markers);
            listener.assertNumberOfAffectedResources(1);
            listener.assertChanges(resource, markers, null, null);
            ++n2;
        }
    }

    @Test
    public void testCreateNullMarkerWithAttributesShouldFail() {
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            Assert.assertThrows(RuntimeException.class, () -> {
                IMarker iMarker = resource.createMarker(null, null);
            });
            ++n2;
        }
    }

    @Test
    public void testCreateMarkerWithAttributesOnAResourceWhichDoesNotExistShouldFail() {
        IFile testResource = ResourcesPlugin.getWorkspace().getRoot().getFile(IPath.fromOSString((String)"non/existant/resource"));
        Assert.assertFalse((String)("resource should not exist: " + String.valueOf(testResource)), (boolean)testResource.exists());
        Assert.assertThrows((String)testResource.getFullPath().toString(), CoreException.class, () -> MarkerTest.lambda$7((IResource)testResource));
    }

    @Test
    public void testThatSettingAttributesTriggerAdditionalResourceChangeEvent() throws CoreException {
        MarkersNumberOfDeltasChangeListener listener = new MarkersNumberOfDeltasChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            listener.reset();
            IMarker marker = resource.createMarker(TEST_PROBLEM_MARKER);
            marker.setAttribute("message", (Object)ResourceTestUtil.createRandomString());
            marker.setAttribute("priority", 2);
            Assertions.assertThat((int)listener.numberOfChanges()).isEqualTo(3);
            ++n2;
        }
    }

    @Test
    public void testThatMarkersWithAttributesOnlyTriggerOnResourceChangeEvent() throws CoreException {
        MarkersNumberOfDeltasChangeListener listener = new MarkersNumberOfDeltasChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            listener.reset();
            listener.reset();
            resource.createMarker(TEST_PROBLEM_MARKER, Map.of("message", ResourceTestUtil.createRandomString(), "priority", 2));
            Assertions.assertThat((int)listener.numberOfChanges()).isEqualTo(1);
            ++n2;
        }
    }

    @Test
    public void testCreationTime() throws CoreException {
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            IMarker marker = element.createMarker("org.eclipse.core.resources.problemmarker");
            ((AbstractLongAssert)Assertions.assertThat((long)marker.getCreationTime()).withFailMessage("creation time for marker in resource %s is not set", new Object[]{element.getFullPath()})).isNotZero();
            ++n2;
        }
    }

    @Test
    public void testDeleteMarker() throws CoreException {
        IMarker marker = null;
        MarkersChangeListener listener = new MarkersChangeListener();
        this.setResourceChangeListener(listener);
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            listener.reset();
            marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
            listener.assertNumberOfAffectedResources(1);
            listener.assertChanges(resource, new IMarker[]{marker}, null, null);
            this.assertMarkerExists(marker);
            listener.reset();
            marker.delete();
            this.assertMarkerDoesNotExist(marker);
            listener.assertNumberOfAffectedResources(1);
            listener.assertChanges(resource, null, new IMarker[]{marker}, null);
            marker.delete();
            IMarker[] markers = new IMarker[3];
            markers[0] = resource.createMarker("org.eclipse.core.resources.bookmark");
            this.assertMarkerExists(markers[0]);
            markers[1] = resource.createMarker("org.eclipse.core.resources.taskmarker");
            this.assertMarkerExists(markers[1]);
            markers[2] = resource.createMarker("org.eclipse.core.resources.problemmarker");
            this.assertMarkerExists(markers[2]);
            listener.reset();
            ResourcesPlugin.getWorkspace().deleteMarkers(markers);
            listener.assertNumberOfAffectedResources(1);
            listener.assertChanges(resource, null, markers, null);
            this.assertMarkersDoNotExist(markers);
            ++n2;
        }
    }

    @Test
    public void testDeleteMarkers() throws CoreException {
        IMarker[] markers = this.createMarkers(this.resources, "org.eclipse.core.resources.problemmarker");
        ResourcesPlugin.getWorkspace().deleteMarkers(markers);
        this.assertMarkersDoNotExist(markers);
        ResourcesPlugin.getWorkspace().deleteMarkers(new IMarker[0]);
    }

    @Test
    public void testFindMarkers() throws CoreException {
        Object[] markers = this.createMarkers(this.resources, "org.eclipse.core.resources.problemmarker");
        Object[] found = ResourcesPlugin.getWorkspace().getRoot().findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
        Assertions.assertThat((Object[])found).containsExactlyInAnyOrder(markers);
        found = ResourcesPlugin.getWorkspace().getRoot().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        Assertions.assertThat((Object[])found).containsExactlyInAnyOrder(markers);
        found = ResourcesPlugin.getWorkspace().getRoot().findMarkers("org.eclipse.core.resources.bookmark", false, 2);
        Assertions.assertThat((Object[])found).isEmpty();
        Vector allMarkers = new Vector(markers.length * 3);
        Collections.addAll(allMarkers, markers);
        markers = this.createMarkers(this.resources, "org.eclipse.core.resources.bookmark");
        Collections.addAll(allMarkers, markers);
        markers = this.createMarkers(this.resources, "org.eclipse.core.resources.taskmarker");
        Collections.addAll(allMarkers, markers);
        found = ResourcesPlugin.getWorkspace().getRoot().findMarkers(null, false, 2);
        Assertions.assertThat((Object[])found).containsExactlyInAnyOrderElementsOf(allMarkers);
        found = ResourcesPlugin.getWorkspace().getRoot().findMarkers("org.eclipse.core.resources.marker", true, 2);
        Assertions.assertThat((Object[])found).containsExactlyInAnyOrderElementsOf(allMarkers);
    }

    @Test
    public void test_35300() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)project);
        String MARKER_ID = "foomarker.example.com";
        int expected = 4;
        IMarker marker = project.createMarker(MARKER_ID);
        marker.setAttribute("transient", expected);
        int actual = marker.getAttribute("transient", -1);
        Assertions.assertThat((int)actual).isEqualTo(expected);
        marker.setAttribute("message", (Object)ResourceTestUtil.createRandomString());
    }

    @Test
    public void test_10989() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        ResourceTestUtil.createInWorkspace((IResource)project);
        IFile file = project.getFile("foo.txt");
        file.create(ResourceTestUtil.createRandomContentsStream(), true, null);
        file.createMarker("org.eclipse.core.resources.problemmarker");
        Object[] found = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        Assertions.assertThat((Object[])found).hasSize(1);
        found = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        Assertions.assertThat((Object[])found).hasSize(1);
        project.delete(true, true, null);
    }

    @Test
    public void test_289811() throws CoreException {
        String testValue = ResourceTestUtil.createRandomString();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        project.create(null);
        project.open(null);
        IFile file = project.getFile("foo.txt");
        file.create(ResourceTestUtil.createRandomContentsStream(), true, null);
        IMarker marker = file.createMarker("org.eclipse.core.resources.problemmarker");
        marker.setAttributes(new HashMap());
        marker.setAttribute("severity", (Object)testValue);
        this.assertMarkerHasAttributeValue(marker, "severity", testValue);
        project.delete(true, true, null);
    }

    @Test
    public void testFindMaxProblemSeverity() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("testFindMaxProblemSeverity");
        IFolder folder = project.getFolder("top");
        IFolder sub = folder.getFolder("sub");
        IFile topFile = folder.getFile("a.txt");
        IFile subFile = sub.getFile("b.txt");
        IResource[] allResources = new IResource[]{project, folder, sub, topFile, subFile};
        ResourceTestUtil.createInWorkspace(allResources);
        Assertions.assertThat((int)root.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2)).isEqualTo(-1);
        Assertions.assertThat((int)root.findMaxProblemSeverity("org.eclipse.core.resources.taskmarker", true, 2)).isEqualTo(-1);
        Assertions.assertThat((int)root.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 0)).isEqualTo(-1);
        this.createProblem((IResource)subFile, 0);
        Assertions.assertThat((int)root.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2)).isEqualTo(0);
        Assertions.assertThat((int)root.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 1)).isEqualTo(-1);
        Assertions.assertThat((int)root.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 0)).isEqualTo(-1);
        Assertions.assertThat((int)root.findMaxProblemSeverity("org.eclipse.core.resources.taskmarker", true, 2)).isEqualTo(-1);
        Assertions.assertThat((int)folder.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2)).isEqualTo(0);
        Assertions.assertThat((int)folder.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 1)).isEqualTo(-1);
        Assertions.assertThat((int)folder.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 0)).isEqualTo(-1);
        Assertions.assertThat((int)folder.findMaxProblemSeverity("org.eclipse.core.resources.taskmarker", true, 2)).isEqualTo(-1);
        Assertions.assertThat((int)sub.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2)).isEqualTo(0);
        Assertions.assertThat((int)sub.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 1)).isEqualTo(0);
        Assertions.assertThat((int)sub.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 0)).isEqualTo(-1);
        Assertions.assertThat((int)sub.findMaxProblemSeverity("org.eclipse.core.resources.taskmarker", true, 2)).isEqualTo(-1);
        Assertions.assertThat((int)subFile.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2)).isEqualTo(0);
        Assertions.assertThat((int)subFile.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", false, 1)).isEqualTo(0);
        Assertions.assertThat((int)subFile.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 0)).isEqualTo(0);
        Assertions.assertThat((int)subFile.findMaxProblemSeverity("org.eclipse.core.resources.taskmarker", true, 2)).isEqualTo(-1);
        this.createProblem((IResource)topFile, 2);
        Assertions.assertThat((int)root.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2)).isEqualTo(2);
        Assertions.assertThat((int)folder.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 1)).isEqualTo(2);
        Assertions.assertThat((int)topFile.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 1)).isEqualTo(2);
        Assertions.assertThat((int)sub.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 1)).isEqualTo(0);
        Assertions.assertThat((int)subFile.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 0)).isEqualTo(0);
    }

    @Test
    public void testIsSubTypeOf() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("testisSubType");
        String INVALID_MARKER = "does.not.exist.at.AllMarker";
        ResourceTestUtil.createInWorkspace((IResource)project);
        IMarker marker = project.createMarker("org.eclipse.core.resources.marker");
        IMarker task = project.createMarker("org.eclipse.core.resources.taskmarker");
        IMarker problem = project.createMarker("org.eclipse.core.resources.problemmarker");
        IMarker testProblem = project.createMarker(TEST_PROBLEM_MARKER);
        IMarker invalid = project.createMarker("does.not.exist.at.AllMarker");
        this.assertMarkerIsSubtype(marker, "org.eclipse.core.resources.marker");
        this.assertMarkerIsNoSubtype(marker, "org.eclipse.core.resources.taskmarker");
        this.assertMarkerIsNoSubtype(marker, "org.eclipse.core.resources.problemmarker");
        this.assertMarkerIsNoSubtype(marker, TEST_PROBLEM_MARKER);
        this.assertMarkerIsNoSubtype(marker, "does.not.exist.at.AllMarker");
        this.assertMarkerIsSubtype(task, "org.eclipse.core.resources.marker");
        this.assertMarkerIsSubtype(task, "org.eclipse.core.resources.taskmarker");
        this.assertMarkerIsNoSubtype(task, "org.eclipse.core.resources.problemmarker");
        this.assertMarkerIsNoSubtype(task, TEST_PROBLEM_MARKER);
        this.assertMarkerIsNoSubtype(task, "does.not.exist.at.AllMarker");
        this.assertMarkerIsSubtype(problem, "org.eclipse.core.resources.marker");
        this.assertMarkerIsNoSubtype(problem, "org.eclipse.core.resources.taskmarker");
        this.assertMarkerIsSubtype(problem, "org.eclipse.core.resources.problemmarker");
        this.assertMarkerIsNoSubtype(problem, TEST_PROBLEM_MARKER);
        this.assertMarkerIsNoSubtype(problem, "does.not.exist.at.AllMarker");
        this.assertMarkerIsSubtype(testProblem, "org.eclipse.core.resources.marker");
        this.assertMarkerIsNoSubtype(testProblem, "org.eclipse.core.resources.taskmarker");
        this.assertMarkerIsSubtype(testProblem, "org.eclipse.core.resources.problemmarker");
        this.assertMarkerIsSubtype(testProblem, TEST_PROBLEM_MARKER);
        this.assertMarkerIsNoSubtype(testProblem, "does.not.exist.at.AllMarker");
        this.assertMarkerIsNoSubtype(invalid, "org.eclipse.core.resources.marker");
        this.assertMarkerIsNoSubtype(invalid, "org.eclipse.core.resources.taskmarker");
        this.assertMarkerIsNoSubtype(invalid, "org.eclipse.core.resources.problemmarker");
        this.assertMarkerIsNoSubtype(invalid, TEST_PROBLEM_MARKER);
        this.assertMarkerIsSubtype(invalid, "does.not.exist.at.AllMarker");
    }

    @Test
    public void testMarkerChangesInDelta() throws CoreException {
        IWorkspaceRoot resource;
        MarkersChangeListener listener = new MarkersChangeListener();
        this.setResourceChangeListener(listener);
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            resource = iResourceArray[n2];
            IMarker[] markers = new IMarker[3];
            listener.reset();
            markers[0] = resource.createMarker("org.eclipse.core.resources.problemmarker");
            this.assertMarkerExists(markers[0]);
            listener.assertNumberOfAffectedResources(1);
            listener.assertChanges((IResource)resource, new IMarker[]{markers[0]}, null, null);
            listener.reset();
            markers[1] = resource.createMarker("org.eclipse.core.resources.bookmark");
            markers[2] = resource.createMarker("org.eclipse.core.resources.taskmarker");
            this.assertMarkersExist(new IMarker[]{markers[1], markers[2]});
            listener.assertNumberOfAffectedResources(1);
            listener.assertChanges((IResource)resource, new IMarker[]{markers[1], markers[2]}, null, null);
            listener.reset();
            markers[0].setAttribute("message", (Object)"My text.");
            listener.assertNumberOfAffectedResources(1);
            listener.assertChanges((IResource)resource, null, null, new IMarker[]{markers[0]});
            listener.reset();
            markers[1].setAttribute("severity", (Object)"Low");
            markers[2].setAttribute("priority", (Object)"Normal");
            listener.assertNumberOfAffectedResources(1);
            listener.assertChanges((IResource)resource, null, null, new IMarker[]{markers[1], markers[2]});
            listener.reset();
            markers[0].delete();
            this.assertMarkerDoesNotExist(markers[0]);
            listener.assertNumberOfAffectedResources(1);
            listener.assertChanges((IResource)resource, null, new IMarker[]{markers[0]}, null);
            listener.reset();
            resource.deleteMarkers(null, false, 0);
            this.assertMarkersDoNotExist(new IMarker[]{markers[1], markers[2]});
            listener.assertNumberOfAffectedResources(1);
            listener.assertChanges((IResource)resource, null, new IMarker[]{markers[1], markers[2]}, null);
            markers[0] = resource.createMarker("org.eclipse.core.resources.problemmarker");
            markers[1] = resource.createMarker("org.eclipse.core.resources.bookmark");
            listener.reset();
            markers[0].delete();
            this.assertMarkerDoesNotExist(markers[0]);
            markers[1].setAttribute("message", (Object)ResourceTestUtil.createRandomString());
            markers[2] = resource.createMarker("org.eclipse.core.resources.taskmarker");
            listener.assertNumberOfAffectedResources(1);
            listener.assertChanges((IResource)resource, new IMarker[]{markers[2]}, new IMarker[]{markers[0]}, new IMarker[]{markers[1]});
            ++n2;
        }
        resource = ResourcesPlugin.getWorkspace().getRoot();
        resource.deleteMarkers(null, true, 2);
        IMarker marker = resource.createMarker("org.eclipse.core.resources.bookmark");
        listener.reset();
        resource.delete(true, ResourceTestUtil.createTestMonitor());
        this.assertMarkerDoesNotExist(marker);
        listener.assertChanges((IResource)resource, null, new IMarker[]{marker}, null);
    }

    @Test
    public void testMarkerDeltaAttributes() throws CoreException {
        IMarker[] markers = new IMarker[3];
        IWorkspaceRunnable body = monitor -> {
            iMarkerArray[0] = this.resources[0].createMarker("org.eclipse.core.resources.bookmark");
            iMarkerArray[1] = this.resources[1].createMarker("org.eclipse.core.resources.bookmark");
            markers[1].setAttribute("charStart", 5);
            iMarkerArray[2] = this.resources[2].createMarker("org.eclipse.core.resources.problemmarker");
            markers[2].setAttribute("done", true);
            markers[2].setAttribute("priority", 2);
            markers[2].setAttribute("message", (Object)"Hello");
        };
        ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
        MarkerAttributeChangeListener listener = new MarkerAttributeChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        listener.expectChanges(markers[0]);
        markers[0].setAttribute("message", (Object)"Message");
        listener.verifyChanges();
        listener.expectChanges(markers[0]);
        markers[0].setAttribute("message", (Object)"NewMessage");
        listener.verifyChanges();
        listener.expectChanges(markers[0]);
        markers[0].setAttribute("message", null);
        listener.verifyChanges();
        listener.expectChanges(markers[2]);
        markers[2].setAttribute("charEnd", 5);
        listener.verifyChanges();
        listener.expectChanges(markers[1]);
        ResourcesPlugin.getWorkspace().run(monitor -> {
            markers[1].setAttribute("charStart", 5);
            markers[1].setAttribute("charEnd", 10);
        }, ResourceTestUtil.createTestMonitor());
        listener.verifyChanges();
        listener.expectChanges(markers[1]);
        ResourcesPlugin.getWorkspace().run(monitor -> {
            markers[1].setAttribute("charStart", 5);
            markers[1].setAttribute("charStart", null);
        }, ResourceTestUtil.createTestMonitor());
        listener.verifyChanges();
        listener.expectChanges(markers);
        ResourcesPlugin.getWorkspace().run(monitor -> {
            markers[0].setAttribute("charStart", 5);
            markers[1].setAttribute("charStart", 10);
            markers[2].setAttribute("priority", 0);
        }, ResourceTestUtil.createTestMonitor());
        listener.verifyChanges();
    }

    @Test
    public void testMarkerDeltasCopyResource() throws CoreException {
        IProject[] projects;
        MarkersChangeListener listener = new MarkersChangeListener();
        this.setResourceChangeListener(listener);
        Hashtable table = new Hashtable(1);
        int[] count = new int[]{0};
        IWorkspaceRunnable body = monitor -> {
            IResourceVisitor visitor = resource -> {
                if (resource.getType() == 8 || resource.getType() == 4) {
                    return true;
                }
                IMarker marker = resource.createMarker("org.eclipse.core.resources.bookmark");
                table.put(resource, marker);
                nArray[0] = count[0] + 1;
                return true;
            };
            ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
        };
        ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
        listener.reset();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IResource[] children;
            IProject project = iProjectArray[n2];
            IResource[] iResourceArray = children = project.members();
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                IResource element = iResourceArray[n4];
                IPath destination = IPath.fromOSString((String)(element.getName() + "copy"));
                element.copy(destination, true, ResourceTestUtil.createTestMonitor());
                ++n4;
            }
            ++n2;
        }
        listener.assertNumberOfAffectedResources(0);
    }

    @Test
    public void testMarkerDeltasMerge() throws CoreException {
        MarkersChangeListener listener = new MarkersChangeListener();
        this.setResourceChangeListener(listener);
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            IWorkspaceRunnable addAndRemoveOperation = monitor -> {
                listener.reset();
                IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
                this.assertMarkerExists(marker);
                marker.delete();
                this.assertMarkerDoesNotExist(marker);
            };
            ResourcesPlugin.getWorkspace().run(addAndRemoveOperation, ResourceTestUtil.createTestMonitor());
            listener.assertNumberOfAffectedResources(0);
            listener.assertChanges(resource, null, null, null);
            AtomicReference addAndChangeMarker = new AtomicReference();
            IWorkspaceRunnable addAndChangeOperation = monitor -> {
                listener.reset();
                addAndChangeMarker.set(resource.createMarker("org.eclipse.core.resources.problemmarker"));
                this.assertMarkerExists((IMarker)addAndChangeMarker.get());
                ((IMarker)addAndChangeMarker.get()).setAttribute("message", (Object)"my message text");
                this.assertMarkerHasAttributeValue((IMarker)addAndChangeMarker.get(), "message", "my message text");
            };
            ResourcesPlugin.getWorkspace().run(addAndChangeOperation, ResourceTestUtil.createTestMonitor());
            listener.assertNumberOfAffectedResources(1);
            listener.assertChanges(resource, new IMarker[]{(IMarker)addAndChangeMarker.get()}, null, null);
            IMarker changeAndChangeMarker = resource.createMarker("org.eclipse.core.resources.problemmarker");
            this.assertMarkerExists(changeAndChangeMarker);
            IWorkspaceRunnable changeAndChangeOperation = monitor -> {
                listener.reset();
                changeAndChangeMarker.setAttribute("message", (Object)"my message text");
                this.assertMarkerHasAttributeValue(changeAndChangeMarker, "message", "my message text");
                changeAndChangeMarker.setAttribute("priority", 2);
                this.assertMarkerHasAttributeValue(changeAndChangeMarker, "priority", 2);
            };
            ResourcesPlugin.getWorkspace().run(changeAndChangeOperation, ResourceTestUtil.createTestMonitor());
            listener.assertNumberOfAffectedResources(1);
            listener.assertChanges(resource, null, null, new IMarker[]{changeAndChangeMarker});
            IMarker changeAndRemoveMarker = resource.createMarker("org.eclipse.core.resources.problemmarker");
            this.assertMarkerExists(changeAndRemoveMarker);
            IWorkspaceRunnable changeAndRemoveOperation = monitor -> {
                listener.reset();
                changeAndRemoveMarker.setAttribute("message", (Object)"my message text");
                this.assertMarkerHasAttributeValue(changeAndRemoveMarker, "message", "my message text");
                changeAndRemoveMarker.delete();
                this.assertMarkerDoesNotExist(changeAndRemoveMarker);
            };
            ResourcesPlugin.getWorkspace().run(changeAndRemoveOperation, ResourceTestUtil.createTestMonitor());
            listener.assertNumberOfAffectedResources(1);
            listener.assertChanges(resource, null, new IMarker[]{changeAndRemoveMarker}, null);
            resource.deleteMarkers(null, true, 0);
            ++n2;
        }
    }

    @Test
    public void testMarkerDeltasMoveFolder() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("MyProject");
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subFile.txt");
        ResourceTestUtil.createInWorkspace(new IResource[]{project, folder, file, subFile});
        ResourceTestUtil.waitForEncodingRelatedJobs(this.testName.getMethodName());
        IFolder destFolder = project.getFolder("myOtherFolder");
        IFile destSubFile = destFolder.getFile(subFile.getName());
        MarkersChangeListener listener = new MarkersChangeListener();
        this.setResourceChangeListener(listener);
        IMarker folderMarker = folder.createMarker("org.eclipse.core.resources.bookmark");
        IMarker subFileMarker = subFile.createMarker("org.eclipse.core.resources.bookmark");
        listener = new MarkersChangeListener();
        this.setResourceChangeListener(listener);
        folder.move(destFolder.getFullPath(), 1, ResourceTestUtil.createTestMonitor());
        listener.assertChanges((IResource)folder, null, new IMarker[]{folderMarker}, null);
        IMarker[] folderMarkers = destFolder.findMarkers(null, true, 0);
        this.assertSingleMarkerWithId(folderMarkers, folderMarker.getId());
        listener.assertChanges((IResource)destFolder, new IMarker[]{folderMarkers[0]}, null, null);
        listener.assertChanges((IResource)subFile, null, new IMarker[]{subFileMarker}, null);
        IMarker[] subFolderMarkers = destSubFile.findMarkers(null, true, 0);
        this.assertSingleMarkerWithId(subFolderMarkers, subFileMarker.getId());
        listener.assertChanges((IResource)destSubFile, new IMarker[]{subFolderMarkers[0]}, null, null);
    }

    @Test
    public void testMarkerDeltasMoveFile() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("MyProject");
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subFile.txt");
        ResourceTestUtil.createInWorkspace(new IResource[]{project, folder, file, subFile});
        ResourceTestUtil.waitForEncodingRelatedJobs(this.testName.getMethodName());
        IFile destFile = folder.getFile(file.getName());
        IFile destSubFile = project.getFile(subFile.getName());
        MarkersChangeListener listener = new MarkersChangeListener();
        this.setResourceChangeListener(listener);
        IMarker fileMarker = file.createMarker("org.eclipse.core.resources.bookmark");
        IMarker subFileMarker = subFile.createMarker("org.eclipse.core.resources.bookmark");
        listener.reset();
        file.move(destFile.getFullPath(), 1, ResourceTestUtil.createTestMonitor());
        subFile.move(destSubFile.getFullPath(), 1, ResourceTestUtil.createTestMonitor());
        listener.assertChanges((IResource)file, null, new IMarker[]{fileMarker}, null);
        IMarker[] markers = destFile.findMarkers(null, true, 0);
        this.assertSingleMarkerWithId(markers, fileMarker.getId());
        listener.assertChanges((IResource)destFile, new IMarker[]{markers[0]}, null, null);
        listener.assertChanges((IResource)subFile, null, new IMarker[]{subFileMarker}, null);
        markers = destSubFile.findMarkers(null, true, 0);
        this.assertSingleMarkerWithId(markers, subFileMarker.getId());
        listener.assertChanges((IResource)destSubFile, new IMarker[]{markers[0]}, null, null);
    }

    @Test
    public void testMarkerDeltasMoveProject() throws CoreException {
        IProject[] projects;
        MarkersChangeListener listener = new MarkersChangeListener();
        this.setResourceChangeListener(listener);
        Hashtable table = new Hashtable(1);
        int[] count = new int[]{0};
        IWorkspaceRunnable body = monitor -> {
            IResourceVisitor visitor = resource -> {
                if (resource.getType() == 8) {
                    return true;
                }
                IMarker marker = resource.createMarker("org.eclipse.core.resources.bookmark");
                table.put(resource, marker);
                nArray[0] = count[0] + 1;
                return true;
            };
            ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
        };
        ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
        listener.reset();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IPath destination = IPath.fromOSString((String)(project.getName() + "move"));
            project.move(destination, true, ResourceTestUtil.createTestMonitor());
            ++n2;
        }
        IResourceVisitor visitor = resource -> {
            if (resource.getType() == 8) {
                return true;
            }
            String name = resource.getFullPath().segment(0);
            IPath path = IPath.fromOSString((String)name.substring(0, name.length() - 4)).makeAbsolute();
            path = path.append(resource.getFullPath().removeFirstSegments(1));
            Resource oldResource = ((Workspace)ResourcesPlugin.getWorkspace()).newResource(path, resource.getType());
            IMarker marker = (IMarker)table.get(oldResource);
            Assertions.assertThat((Object)marker).isNotNull();
            listener.assertChanges((IResource)oldResource, null, new IMarker[]{marker}, null);
            IMarker[] markers = resource.findMarkers(null, true, 0);
            this.assertSingleMarkerWithId(markers, marker.getId());
            listener.assertChanges(resource, new IMarker[]{markers[0]}, null, null);
            return true;
        };
        listener.assertNumberOfAffectedResources(count[0] * 2);
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
    }

    @Test
    public void testMarkerSave() throws Exception {
        Object var9_15;
        Throwable throwable;
        IMarker[] newMarkers = this.createMarkers(this.resources, "org.eclipse.core.resources.problemmarker");
        Object[] expected = new IMarker[newMarkers.length * 3];
        System.arraycopy(newMarkers, 0, expected, 0, newMarkers.length);
        newMarkers = this.createMarkers(this.resources, "org.eclipse.core.resources.bookmark");
        System.arraycopy(newMarkers, 0, expected, newMarkers.length, newMarkers.length);
        newMarkers = this.createMarkers(this.resources, "org.eclipse.core.resources.taskmarker");
        System.arraycopy(newMarkers, 0, expected, newMarkers.length * 2, newMarkers.length);
        MarkerManager manager = ((Workspace)ResourcesPlugin.getWorkspace()).getMarkerManager();
        File file = Platform.getLocation().append(".testmarkers").toFile();
        Throwable throwable2 = null;
        Object var6_8 = null;
        try (FileOutputStream fileOutput = new FileOutputStream(file);){
            throwable = null;
            var9_15 = null;
            try (DataOutputStream output = new DataOutputStream(fileOutput);){
                ArrayList list = new ArrayList(5);
                IResourceVisitor visitor = resource -> {
                    ResourceInfo info = ((Resource)resource).getResourceInfo(false, false);
                    if (info == null) {
                        return true;
                    }
                    IPathRequestor requestor = new IPathRequestor(){

                        public IPath requestPath() {
                            return resource.getFullPath();
                        }

                        public String requestName() {
                            return resource.getName();
                        }
                    };
                    try {
                        manager.save(info, requestor, output, list);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("saving failed", e);
                    }
                    return true;
                };
                ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        ResourcesPlugin.getWorkspace().getRoot().deleteMarkers(null, true, 2);
        this.assertMarkersDoNotExist((IMarker[])expected);
        throwable2 = null;
        var6_8 = null;
        try (InputStream fileInput = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            throwable = null;
            var9_15 = null;
            try (DataInputStream input = new DataInputStream(fileInput);){
                IWorkspaceRunnable body = monitor -> {
                    MarkerReader reader = new MarkerReader((Workspace)ResourcesPlugin.getWorkspace());
                    try {
                        reader.read(input, true);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("failed reading markers", e);
                    }
                };
                ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable6) {
            if (throwable2 == null) {
                throwable2 = throwable6;
            } else if (throwable2 != throwable6) {
                throwable2.addSuppressed(throwable6);
            }
            throw throwable2;
        }
        this.assertMarkersExist((IMarker[])expected);
        Object[] actual = ResourcesPlugin.getWorkspace().getRoot().findMarkers(null, false, 2);
        Assertions.assertThat((Object[])actual).containsExactlyInAnyOrder(expected);
        Assert.assertTrue((String)"deleting file failed", (boolean)file.delete());
    }

    @Test
    public void testMarkerSaveTransient() throws Exception {
        Object var10_16;
        Throwable throwable;
        ArrayList persistentMarkers = new ArrayList();
        IResourceVisitor visitor = resource -> {
            IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
            persistentMarkers.add(marker);
            marker = resource.createMarker("org.eclipse.core.resources.bookmark");
            persistentMarkers.add(marker);
            marker = resource.createMarker(TRANSIENT_MARKER);
            marker = resource.createMarker("org.eclipse.core.resources.bookmark");
            marker.setAttribute("transient", (Object)Boolean.TRUE);
            marker = resource.createMarker("org.eclipse.core.resources.bookmark");
            marker.setAttribute("transient", (Object)Boolean.FALSE);
            persistentMarkers.add(marker);
            marker = resource.createMarker(TRANSIENT_MARKER);
            marker.setAttribute("transient", (Object)Boolean.FALSE);
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
        MarkerManager manager = ((Workspace)ResourcesPlugin.getWorkspace()).getMarkerManager();
        Object[] expected = persistentMarkers.toArray(new IMarker[persistentMarkers.size()]);
        File file = Platform.getLocation().append(".testmarkers").toFile();
        Throwable throwable2 = null;
        Object var7_9 = null;
        try (FileOutputStream fileOutput = new FileOutputStream(file);){
            throwable = null;
            var10_16 = null;
            try (DataOutputStream output = new DataOutputStream(fileOutput);){
                ArrayList list = new ArrayList(5);
                visitor = resource -> {
                    ResourceInfo info = ((Resource)resource).getResourceInfo(false, false);
                    if (info == null) {
                        return true;
                    }
                    IPathRequestor requestor = new IPathRequestor(){

                        public IPath requestPath() {
                            return resource.getFullPath();
                        }

                        public String requestName() {
                            return resource.getName();
                        }
                    };
                    try {
                        manager.save(info, requestor, output, list);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("saving failed", e);
                    }
                    return true;
                };
                ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        ResourcesPlugin.getWorkspace().getRoot().deleteMarkers(null, true, 2);
        this.assertMarkersDoNotExist((IMarker[])expected);
        throwable2 = null;
        var7_9 = null;
        try (InputStream fileInput = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            throwable = null;
            var10_16 = null;
            try (DataInputStream input = new DataInputStream(fileInput);){
                IWorkspaceRunnable body = monitor -> {
                    MarkerReader reader = new MarkerReader((Workspace)ResourcesPlugin.getWorkspace());
                    try {
                        reader.read(input, true);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Failed reading markers", e);
                    }
                };
                ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable6) {
            if (throwable2 == null) {
                throwable2 = throwable6;
            } else if (throwable2 != throwable6) {
                throwable2.addSuppressed(throwable6);
            }
            throw throwable2;
        }
        this.assertMarkersExist((IMarker[])expected);
        Object[] actual = ResourcesPlugin.getWorkspace().getRoot().findMarkers(null, false, 2);
        Assertions.assertThat((Object[])actual).containsExactlyInAnyOrder(expected);
        Assert.assertTrue((String)"deleting file failed", (boolean)file.delete());
    }

    @Test
    public void testMoveResource() {
    }

    @Test
    public void testProjectCloseOpen() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProjects()[0];
        IMarker marker = project.createMarker("org.eclipse.core.resources.bookmark");
        this.assertMarkerExists(marker);
        project.close(ResourceTestUtil.createTestMonitor());
        this.assertMarkerDoesNotExist(marker);
        project.open(ResourceTestUtil.createTestMonitor());
        this.assertMarkerExists(marker);
    }

    @Test
    public void testSetGetAttribute() throws CoreException {
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            String resourcePath = resource.getFullPath().toString();
            IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
            this.assertMarkerHasAttributeValue(marker, "message", null);
            String testMessage = ResourceTestUtil.createRandomString();
            marker.setAttribute("message", (Object)testMessage);
            this.assertMarkerHasAttributeValue(marker, "message", testMessage);
            marker.setAttribute("message", null);
            this.assertMarkerHasAttributeValue(marker, "message", null);
            String[] keys = new String[]{"location", "severity", "done"};
            Object[] values = new Object[]{ResourceTestUtil.createRandomString(), 5, Boolean.FALSE};
            Map<String, Object> originalMap = Map.of(keys[0], values[0], keys[1], values[1], keys[2], values[2]);
            marker.setAttributes(keys, values);
            Object[] found = marker.getAttributes(keys);
            ((ObjectArrayAssert)Assertions.assertThat((Object[])found).as(resourcePath, new Object[0])).isEqualTo((Object)values);
            marker.setAttribute("severity", null);
            values[1] = null;
            found = marker.getAttributes(keys);
            ((ObjectArrayAssert)Assertions.assertThat((Object[])found).as(resourcePath, new Object[0])).isEqualTo((Object)values);
            values[1] = 5;
            marker.setAttribute("severity", values[1]);
            ((MapAssert)Assertions.assertThat((Map)marker.getAttributes()).as(resourcePath, new Object[0])).isEqualTo(originalMap);
            Assert.assertThrows((String)resourcePath, RuntimeException.class, () -> {
                Object object = marker.getAttribute(null);
            });
            Assert.assertThrows((String)resourcePath, RuntimeException.class, () -> {
                Object[] objectArray = marker.getAttributes(null);
            });
            Assert.assertThrows((String)resourcePath, RuntimeException.class, () -> marker.setAttribute(null, (Object)ResourceTestUtil.createRandomString()));
            Assert.assertThrows((String)resourcePath, RuntimeException.class, () -> marker.setAttributes(null, (Object[])new String[]{ResourceTestUtil.createRandomString()}));
            Assert.assertThrows((String)resourcePath, RuntimeException.class, () -> marker.setAttributes(new String[]{"message"}, null));
            marker.delete();
            Assert.assertThrows((String)resourcePath, CoreException.class, () -> marker.setAttribute("message", (Object)"Hello"));
            Assert.assertThrows((String)resourcePath, CoreException.class, () -> marker.setAttributes(new String[]{"lineNumber"}, new Object[]{4}));
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("message", "Hello");
            Assert.assertThrows((String)resourcePath, CoreException.class, () -> marker.setAttributes((Map)attributes));
            ++n2;
        }
    }

    @Test
    public void testGetAttributesEquality() throws Exception {
        String value = "Some value";
        int i = 0;
        while (i < this.resources.length) {
            IMarker marker = this.resources[i].createMarker("org.eclipse.core.resources.problemmarker", Map.of(String.valueOf(i), "Some value"));
            this.assertMarkerHasAttributeValue(marker, String.valueOf(i), "Some value");
            Map existing = marker.getAttributes();
            Map<String, String> otherAttributes = Map.of(String.valueOf(i), "Some value");
            Assertions.assertThat(otherAttributes).isEqualTo((Object)existing);
            ++i;
        }
    }

    @Test
    public void testSetGetAttribute2() throws CoreException {
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            String resourcePath = resource.getFullPath().toString();
            IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
            ((ObjectAssert)Assertions.assertThat((Object)marker.getAttribute("message")).as(resourcePath, new Object[0])).isNull();
            ((AbstractStringAssert)Assertions.assertThat((String)marker.getAttribute("message", "default")).as(resourcePath, new Object[0])).isEqualTo("default");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)marker.getAttribute("message", true)).as(resourcePath, new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)marker.getAttribute("message", 5)).as(resourcePath, new Object[0])).isEqualTo(5);
            Assertions.assertThat((Map)marker.getAttributes()).isNull();
            ((ObjectAssert)Assertions.assertThat((Object)marker.getAttributes(new String[]{"message"})[0]).as(resourcePath, new Object[0])).isNull();
            String testMessage = ResourceTestUtil.createRandomString();
            marker.setAttribute("message", (Object)testMessage);
            this.assertMarkerHasAttributeValue(marker, "message", testMessage);
            marker.setAttribute("message", null);
            this.assertMarkerHasAttributeValue(marker, "message", null);
            String[] keys = new String[]{"location", "severity", "done"};
            Object[] values = new Object[]{ResourceTestUtil.createRandomString(), 5, Boolean.FALSE};
            Map<String, Object> originalMap = Map.of(keys[0], values[0], keys[1], values[1], keys[2], values[2]);
            marker.setAttributes(keys, values);
            Object[] found = marker.getAttributes(keys);
            ((ObjectArrayAssert)Assertions.assertThat((Object[])found).as(resourcePath, new Object[0])).isEqualTo((Object)values);
            marker.setAttribute("severity", null);
            values[1] = null;
            found = marker.getAttributes(keys);
            ((ObjectArrayAssert)Assertions.assertThat((Object[])found).as(resourcePath, new Object[0])).isEqualTo((Object)values);
            values[1] = 5;
            marker.setAttribute("severity", values[1]);
            ((MapAssert)Assertions.assertThat((Map)marker.getAttributes()).as(resourcePath, new Object[0])).isEqualTo(originalMap);
            Assert.assertThrows((String)resourcePath, RuntimeException.class, () -> {
                Object object = marker.getAttribute(null);
            });
            Assert.assertThrows((String)resourcePath, RuntimeException.class, () -> {
                String string = marker.getAttribute(null, "default");
            });
            Assert.assertThrows((String)resourcePath, RuntimeException.class, () -> {
                boolean bl = marker.getAttribute(null, true);
            });
            Assert.assertThrows((String)resourcePath, RuntimeException.class, () -> {
                int n = marker.getAttribute(null, 5);
            });
            Assert.assertThrows((String)resourcePath, RuntimeException.class, () -> {
                Object[] objectArray = marker.getAttributes(null);
            });
            Assert.assertThrows((String)resourcePath, RuntimeException.class, () -> marker.setAttribute(null, (Object)ResourceTestUtil.createRandomString()));
            Assert.assertThrows((String)resourcePath, RuntimeException.class, () -> marker.setAttributes(null, (Object[])new String[]{ResourceTestUtil.createRandomString()}));
            Assert.assertThrows((String)resourcePath, RuntimeException.class, () -> marker.setAttributes(new String[]{"message"}, null));
            Map retrievedAttributes = marker.getAttributes();
            retrievedAttributes.put("1", null);
            retrievedAttributes.put("2", 2);
            marker.setAttributes(retrievedAttributes);
            this.assertMarkerHasAttributeValue(marker, "1", null);
            this.assertMarkerHasAttributeValue(marker, "2", 2);
            retrievedAttributes.put(null, 1);
            Map reretrievedAttributes = marker.getAttributes();
            reretrievedAttributes.put(null, 1);
            Assert.assertThrows((String)resourcePath, RuntimeException.class, () -> marker.setAttributes(reretrievedAttributes));
            ((ObjectAssert)Assertions.assertThat((Object)marker.getAttribute("2")).as(resourcePath, new Object[0])).isNotNull();
            ((MapAssert)Assertions.assertThat((Map)marker.getAttributes()).as(resourcePath, new Object[0])).isNotNull();
            marker.setAttributes(null);
            ((ObjectAssert)Assertions.assertThat((Object)marker.getAttribute("1")).as(resourcePath, new Object[0])).isNull();
            ((ObjectAssert)Assertions.assertThat((Object)marker.getAttribute("2")).as(resourcePath, new Object[0])).isNull();
            ((MapAssert)Assertions.assertThat((Map)marker.getAttributes()).as(resourcePath, new Object[0])).isNull();
            ++n2;
        }
    }

    private static /* synthetic */ void lambda$5(IResource iResource) throws Throwable {
        IMarker iMarker = iResource.createMarker("org.eclipse.core.resources.problemmarker");
    }

    private static /* synthetic */ void lambda$7(IResource iResource) throws Throwable {
        IMarker iMarker = iResource.createMarker("org.eclipse.core.resources.problemmarker", Map.of("message", "My text"));
    }
}

