/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;

public class MarkersChangeListener
implements IResourceChangeListener {
    protected HashMap<IPath, List<IMarkerDelta>> changes;

    public MarkersChangeListener() {
        this.reset();
    }

    public void assertChanges(IResource resource, IMarker[] added, IMarker[] removed, IMarker[] changed) {
        IPath path = resource == null ? IPath.ROOT : resource.getFullPath();
        List<IMarkerDelta> v = this.changes.get(path);
        if (v == null) {
            v = new Vector<IMarkerDelta>();
        }
        int numChanges = (added == null ? 0 : added.length) + (removed == null ? 0 : removed.length) + (changed == null ? 0 : changed.length);
        ((AbstractIntegerAssert)Assertions.assertThat((int)numChanges).as("number of markers for resource %s", new Object[]{path})).isEqualTo(v.size());
        for (IMarkerDelta delta : v) {
            switch (delta.getKind()) {
                case 1: {
                    ((ObjectArrayAssert)Assertions.assertThat((Object[])added).as("check added markers contain resource %s", new Object[]{path})).contains((Object[])new IMarker[]{delta.getMarker()});
                    break;
                }
                case 2: {
                    ((ObjectArrayAssert)Assertions.assertThat((Object[])removed).as("check removed markers contain resource %s", new Object[]{path})).contains((Object[])new IMarker[]{delta.getMarker()});
                    break;
                }
                case 4: {
                    ((ObjectArrayAssert)Assertions.assertThat((Object[])changed).as("check changed markers contain resource %s", new Object[]{path})).contains((Object[])new IMarker[]{delta.getMarker()});
                    break;
                }
                default: {
                    throw new IllegalArgumentException("delta with unsupported kind: " + String.valueOf(delta));
                }
            }
        }
    }

    public void assertNumberOfAffectedResources(int expectedNumberOfResource) {
        Assertions.assertThat(this.changes).hasSize(expectedNumberOfResource);
    }

    public void reset() {
        this.changes = new HashMap();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.resourceChanged(event.getDelta());
    }

    protected void resourceChanged(IResourceDelta delta) {
        IResourceDelta[] children;
        if (delta == null) {
            return;
        }
        if ((delta.getFlags() & 0x20000) != 0) {
            IMarkerDelta[] markerDeltas;
            IPath path = delta.getFullPath();
            List<IMarkerDelta> v = this.changes.get(path);
            if (v == null) {
                v = new Vector<IMarkerDelta>();
                this.changes.put(path, v);
            }
            IMarkerDelta[] iMarkerDeltaArray = markerDeltas = delta.getMarkerDeltas();
            int n = markerDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
                v.add(markerDelta);
                ++n2;
            }
        }
        IResourceDelta[] iResourceDeltaArray = children = delta.getAffectedChildren();
        int n = children.length;
        int n3 = 0;
        while (n3 < n) {
            IResourceDelta element = iResourceDeltaArray[n3];
            this.resourceChanged(element);
            ++n3;
        }
    }
}

