/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.CheckMissingNaturesListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.tests.internal.resources.SimpleNature;
import org.eclipse.core.tests.resources.ResourceTestPluginConstants;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;

public class NatureTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    IProject project;

    private void setNatures(IProject project, String[] natures, boolean shouldFail) throws Throwable {
        this.setNatures(project, natures, shouldFail, false);
    }

    private void setNatures(IProject project, String[] natures, boolean shouldFail, boolean silent) throws Throwable {
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(natures);
        int flags = silent ? 66 : 2;
        ThrowingRunnable descriptionSetter = () -> project.setDescription(desc, flags, ResourceTestUtil.createTestMonitor());
        if (shouldFail) {
            Assert.assertThrows(CoreException.class, (ThrowingRunnable)descriptionSetter);
        } else {
            descriptionSetter.run();
        }
    }

    @After
    public void tearDown() throws Exception {
        this.project.delete(true, null);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").putInt("missingNatureMarkerSeverity", 1);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").flush();
    }

    @Before
    public void setUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
    }

    private void assertHasEnabledNature(String nature) throws CoreException {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.project.hasNature(nature)).withFailMessage("project '%s' is expected to have nature: %s", new Object[]{this.project, nature})).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.project.isNatureEnabled(nature)).withFailMessage("project '%s' is expected to have nature enabled: %s", new Object[]{this.project, nature})).isTrue();
    }

    private void assertDoesNotHaveNature(String nature) throws CoreException {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.project.hasNature(nature)).withFailMessage("project '%s' is not expected to have nature: %s", new Object[]{this.project, nature})).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.project.isNatureEnabled(nature)).withFailMessage("project '%s' is not expected to have nature enabled: %s", new Object[]{this.project, nature})).isFalse();
    }

    @Test
    public void testInvalidAdditions() throws Throwable {
        ResourceTestUtil.createInWorkspace((IResource)this.project);
        this.setNatures(this.project, new String[]{"org.eclipse.core.tests.resources.simpleNature"}, false);
        this.setNatures(this.project, new String[]{"org.eclipse.core.tests.resources.simpleNature", "no.such.nature.Missing"}, true);
        this.assertHasEnabledNature("org.eclipse.core.tests.resources.simpleNature");
        this.assertDoesNotHaveNature("no.such.nature.Missing");
        this.setNatures(this.project, new String[]{"org.eclipse.core.tests.resources.simpleNature", "org.eclipse.core.tests.resources.snowNature"}, true);
        this.assertHasEnabledNature("org.eclipse.core.tests.resources.simpleNature");
        this.assertDoesNotHaveNature("org.eclipse.core.tests.resources.snowNature");
        this.setNatures(this.project, new String[]{"org.eclipse.core.tests.resources.earthNature"}, false);
        this.setNatures(this.project, new String[]{"org.eclipse.core.tests.resources.earthNature", "org.eclipse.core.tests.resources.waterNature"}, true);
        this.assertHasEnabledNature("org.eclipse.core.tests.resources.earthNature");
        this.assertDoesNotHaveNature("org.eclipse.core.tests.resources.waterNature");
    }

    @Test
    public void testInvalidRemovals() throws Throwable {
        ResourceTestUtil.createInWorkspace((IResource)this.project);
        this.setNatures(this.project, new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.snowNature"}, false);
        this.setNatures(this.project, new String[]{"org.eclipse.core.tests.resources.snowNature"}, true);
        this.assertHasEnabledNature("org.eclipse.core.tests.resources.waterNature");
        this.assertHasEnabledNature("org.eclipse.core.tests.resources.snowNature");
    }

    @Test
    public void testNatureLifecyle() throws Throwable {
        ResourceTestUtil.createInWorkspace((IResource)this.project);
        this.setNatures(this.project, new String[]{"org.eclipse.core.tests.resources.simpleNature"}, false);
        SimpleNature instance = SimpleNature.getInstance();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)instance.wasConfigured).withFailMessage("Simple nature has not been configured", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)instance.wasDeconfigured).withFailMessage("Simple nature has been deconfigured", new Object[0])).isFalse();
        instance.reset();
        this.setNatures(this.project, new String[0], false);
        instance = SimpleNature.getInstance();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)instance.wasConfigured).withFailMessage("Simple nature has been configured", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)instance.wasDeconfigured).withFailMessage("Simple nature has not been deconfigured", new Object[0])).isTrue();
        instance.reset();
        this.setNatures(this.project, new String[]{"org.eclipse.core.tests.resources.simpleNature"}, false, true);
        instance = SimpleNature.getInstance();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)instance.wasConfigured).withFailMessage("Simple nature has been configured", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)instance.wasDeconfigured).withFailMessage("Simple nature has been deconfigured", new Object[0])).isFalse();
        this.assertHasEnabledNature("org.eclipse.core.tests.resources.simpleNature");
        instance.reset();
        this.setNatures(this.project, new String[0], false, true);
        instance = SimpleNature.getInstance();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)instance.wasConfigured).withFailMessage("Simple nature has been configured", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)instance.wasDeconfigured).withFailMessage("Simple nature has been deconfigured", new Object[0])).isFalse();
        this.assertDoesNotHaveNature("org.eclipse.core.tests.resources.simpleNature");
    }

    @Test
    public void testSimpleNature() throws Throwable {
        String[][] invalid;
        String[][] valid;
        ResourceTestUtil.createInWorkspace((IResource)this.project);
        String[][] stringArray = valid = ResourceTestPluginConstants.getValidNatureSets();
        int n = valid.length;
        int n2 = 0;
        while (n2 < n) {
            String[] element = stringArray[n2];
            this.setNatures(this.project, element, false);
            ++n2;
        }
        Object[] currentSet = new String[]{"org.eclipse.core.tests.resources.simpleNature"};
        this.setNatures(this.project, (String[])currentSet, false);
        String[][] stringArray2 = invalid = ResourceTestPluginConstants.getInvalidNatureSets();
        int n3 = invalid.length;
        int n4 = 0;
        while (n4 < n3) {
            String[] element = stringArray2[n4];
            this.setNatures(this.project, element, true);
            this.assertHasEnabledNature("org.eclipse.core.tests.resources.simpleNature");
            this.assertDoesNotHaveNature("org.eclipse.core.tests.resources.waterNature");
            Assertions.assertThat((Object[])currentSet).isEqualTo((Object)this.project.getDescription().getNatureIds());
            ++n4;
        }
    }

    @Test
    public void testBug127562Nature() throws Throwable {
        String[][] valid;
        ResourceTestUtil.createInWorkspace((IResource)this.project);
        IWorkspace ws = this.project.getWorkspace();
        String[][] stringArray = valid = ResourceTestPluginConstants.getValidNatureSets();
        int n = valid.length;
        int n2 = 0;
        while (n2 < n) {
            String[] element = stringArray[n2];
            this.setNatures(this.project, element, false);
            ++n2;
        }
        String[] currentSet = new String[]{"org.eclipse.core.tests.resources.bug127562Nature"};
        this.setNatures(this.project, currentSet, false, true);
        IJobManager manager = Job.getJobManager();
        try {
            manager.beginRule(ws.getRuleFactory().modifyRule((IResource)this.project), null);
            Assert.assertThrows(IllegalArgumentException.class, () -> this.project.getNature("org.eclipse.core.tests.resources.bug127562Nature").configure());
        }
        finally {
            manager.endRule(ws.getRuleFactory().modifyRule((IResource)this.project));
        }
        try {
            manager.beginRule((ISchedulingRule)ws.getRoot(), null);
            this.project.getNature("org.eclipse.core.tests.resources.bug127562Nature").configure();
        }
        finally {
            manager.endRule((ISchedulingRule)ws.getRoot());
        }
    }

    @Test
    public void testBug297871() throws Throwable {
        ResourceTestUtil.createInWorkspace((IResource)this.project);
        IFileStore descStore = ((org.eclipse.core.internal.resources.File)this.project.getFile(".project")).getStore();
        File desc = descStore.toLocalFile(0, ResourceTestUtil.createTestMonitor());
        File descTmp = new File(desc.getPath() + ".tmp");
        Files.copy(desc.toPath(), descTmp.toPath(), new CopyOption[0]);
        this.setNatures(this.project, new String[]{"org.eclipse.core.tests.resources.earthNature"}, false);
        this.assertHasEnabledNature("org.eclipse.core.tests.resources.earthNature");
        Assertions.assertThat((Object)this.project.getNature("org.eclipse.core.tests.resources.earthNature")).isNotNull();
        Files.copy(descTmp.toPath(), desc.toPath(), StandardCopyOption.REPLACE_EXISTING);
        ResourceTestUtil.touchInFilesystem((IResource)this.project.getFile(".project"));
        this.project.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        this.assertDoesNotHaveNature("org.eclipse.core.tests.resources.earthNature");
        Assertions.assertThat((Object)this.project.getNature("org.eclipse.core.tests.resources.earthNature")).isNull();
    }

    @Test
    public void testBug338055() throws Exception {
        final boolean[] finished = new boolean[1];
        ResourceTestUtil.createInWorkspace((IResource)this.project);
        final AtomicReference failureInJob = new AtomicReference();
        Job simulateNatureAccessJob = new Job("CheckNatureJob"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (!finished[0]) {
                        if (NatureTest.this.project.exists() && NatureTest.this.project.isOpen()) {
                            NatureTest.this.project.isNatureEnabled("org.eclipse.core.tests.resources.simpleNature");
                        }
                        this.schedule();
                    }
                }
                catch (CoreException e) {
                    failureInJob.set(e);
                }
                return Status.OK_STATUS;
            }
        };
        simulateNatureAccessJob.schedule();
        Thread.sleep(1000L);
        IFileStore descStore = ((org.eclipse.core.internal.resources.File)this.project.getFile(".project")).getStore();
        StringBuilder description = new StringBuilder();
        description.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><projectDescription><name></name><comment></comment><projects></projects><buildSpec></buildSpec><natures>");
        description.append("<nature>org.eclipse.core.tests.resources.simpleNature</nature>");
        int i = 0;
        while (i < 100) {
            description.append("<nature>nature" + i + "</nature>");
            ++i;
        }
        description.append("</natures></projectDescription>\n");
        Throwable throwable = null;
        Object var7_9 = null;
        try (OutputStream output = descStore.openOutputStream(0, ResourceTestUtil.createTestMonitor());){
            output.write(description.toString().getBytes());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.project.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        finished[0] = true;
        simulateNatureAccessJob.join();
        this.assertHasEnabledNature("org.eclipse.core.tests.resources.simpleNature");
    }

    @Test
    public void testMissingNatureAddsMarker() throws Exception {
        ResourceTestUtil.createInWorkspace((IResource)this.project);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").putInt("missingNatureMarkerSeverity", 1);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").flush();
        IProjectDescription desc = this.project.getDescription();
        desc.setNatureIds(new String[]{"no.such.nature.Missing"});
        this.project.setDescription(desc, 65, ResourceTestUtil.createTestMonitor());
        this.project.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        this.project.build(6, ResourceTestUtil.createTestMonitor());
        Job.getJobManager().wakeUp((Object)CheckMissingNaturesListener.MARKER_TYPE);
        Job.getJobManager().join((Object)CheckMissingNaturesListener.MARKER_TYPE, ResourceTestUtil.createTestMonitor());
        Object[] markers = this.project.findMarkers(CheckMissingNaturesListener.MARKER_TYPE, false, 1);
        Assertions.assertThat((Object[])markers).hasSize(1);
        Object marker = markers[0];
        Assertions.assertThat((Object)marker.getAttribute("natureId")).isEqualTo((Object)"no.such.nature.Missing");
        Assertions.assertThat((int)marker.getAttribute("charStart", -42)).isNotEqualTo(-42);
        Assertions.assertThat((int)marker.getAttribute("charEnd", -42)).isNotEqualTo(-42);
        String content = ((IFile)marker.getResource()).readString();
        String marked = content.substring(marker.getAttribute("charStart", -42), marker.getAttribute("charEnd", -42));
        Assertions.assertThat((String)marked).isEqualTo("no.such.nature.Missing");
    }

    @Test
    public void testMissingNatureWithWhitespacesSetChars() throws Exception {
        ResourceTestUtil.createInWorkspace((IResource)this.project);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").putInt("missingNatureMarkerSeverity", 1);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").flush();
        IFile dotProjectFile = this.project.getFile(".project");
        dotProjectFile.setContents(("<projectDescription><name>" + this.project.getName() + "</name><natures><nature> no.such.nature.Missing  </nature></natures></projectDescription>").getBytes(), false, false, ResourceTestUtil.createTestMonitor());
        this.project.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        this.project.build(6, ResourceTestUtil.createTestMonitor());
        Job.getJobManager().wakeUp((Object)CheckMissingNaturesListener.MARKER_TYPE);
        Job.getJobManager().join((Object)CheckMissingNaturesListener.MARKER_TYPE, ResourceTestUtil.createTestMonitor());
        Object[] markers = this.project.findMarkers(CheckMissingNaturesListener.MARKER_TYPE, false, 1);
        Assertions.assertThat((Object[])markers).hasSize(1);
        Object marker = markers[0];
        Assertions.assertThat((Object)marker.getAttribute("natureId")).isEqualTo((Object)"no.such.nature.Missing");
        Assertions.assertThat((int)marker.getAttribute("charStart", -42)).isNotEqualTo(-42);
        Assertions.assertThat((int)marker.getAttribute("charEnd", -42)).isNotEqualTo(-42);
        String content = ((IFile)marker.getResource()).readString();
        String marked = content.substring(marker.getAttribute("charStart", -42), marker.getAttribute("charEnd", -42));
        Assertions.assertThat((String)marked).isEqualTo("no.such.nature.Missing");
    }

    @Test
    public void testKnownNatureDoesntAddMarker() throws Exception {
        ResourceTestUtil.createInWorkspace((IResource)this.project);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").putInt("missingNatureMarkerSeverity", 1);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").flush();
        IProjectDescription desc = this.project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.simpleNature"});
        this.project.setDescription(desc, ResourceTestUtil.createTestMonitor());
        this.project.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        this.project.build(6, ResourceTestUtil.createTestMonitor());
        Job.getJobManager().wakeUp((Object)CheckMissingNaturesListener.MARKER_TYPE);
        Job.getJobManager().join((Object)CheckMissingNaturesListener.MARKER_TYPE, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])this.project.findMarkers(CheckMissingNaturesListener.MARKER_TYPE, false, 1)).isEmpty();
    }

    @Test
    public void testListenToPreferenceChange() throws Exception {
        this.testMissingNatureAddsMarker();
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").putInt("missingNatureMarkerSeverity", 0);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").flush();
        Job.getJobManager().wakeUp((Object)CheckMissingNaturesListener.MARKER_TYPE);
        Job.getJobManager().join((Object)CheckMissingNaturesListener.MARKER_TYPE, ResourceTestUtil.createTestMonitor());
        Object[] markers = this.project.findMarkers(CheckMissingNaturesListener.MARKER_TYPE, false, 1);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])markers).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{marker -> {
            AbstractIntegerAssert abstractIntegerAssert = Assertions.assertThat((int)marker.getAttribute("severity", -42)).isEqualTo(0);
        }});
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").putInt("missingNatureMarkerSeverity", -1);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").flush();
        Job.getJobManager().wakeUp((Object)CheckMissingNaturesListener.MARKER_TYPE);
        Job.getJobManager().join((Object)CheckMissingNaturesListener.MARKER_TYPE, ResourceTestUtil.createTestMonitor());
        markers = this.project.findMarkers(CheckMissingNaturesListener.MARKER_TYPE, false, 1);
        Assertions.assertThat((Object[])markers).isEmpty();
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").putInt("missingNatureMarkerSeverity", 2);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").flush();
        Job.getJobManager().wakeUp((Object)CheckMissingNaturesListener.MARKER_TYPE);
        Job.getJobManager().join((Object)CheckMissingNaturesListener.MARKER_TYPE, ResourceTestUtil.createTestMonitor());
        markers = this.project.findMarkers(CheckMissingNaturesListener.MARKER_TYPE, false, 1);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])markers).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{marker -> {
            AbstractIntegerAssert abstractIntegerAssert = Assertions.assertThat((int)marker.getAttribute("severity", -42)).isEqualTo(2);
        }});
    }
}

