/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.internal.filesystem.ram.MemoryTree;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class NonLocalLinkedResourceTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    protected IFileStore createFolderStore(String name) throws CoreException {
        IFileSystem system = this.getFileSystem();
        IFileStore store = system.getStore(IPath.ROOT.append(name));
        store.mkdir(0, ResourceTestUtil.createTestMonitor());
        return store;
    }

    protected IFileSystem getFileSystem() throws CoreException {
        return EFS.getFileSystem((String)"mem");
    }

    @After
    public void tearDown() throws Exception {
        MemoryTree.TREE.deleteAll();
    }

    @Test
    public void testCopyFile() throws CoreException {
        IFileStore sourceStore = this.createFolderStore("source");
        IFileStore destinationStore = this.createFolderStore("destination");
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("project");
        IFolder source = project.getFolder("source");
        IFolder destination = project.getFolder("destination");
        IFile sourceFile = source.getFile("file.txt");
        IFile destinationFile = destination.getFile(sourceFile.getName());
        IFile localFile = project.getFile(sourceFile.getName());
        ResourceTestUtil.createInWorkspace((IResource)project);
        source.createLink(sourceStore.toURI(), 0, ResourceTestUtil.createTestMonitor());
        destination.createLink(destinationStore.toURI(), 0, ResourceTestUtil.createTestMonitor());
        sourceFile.create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        sourceFile.copy(destinationFile.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        sourceFile.copy(localFile.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.removeFromWorkspace((IResource)destinationFile);
        localFile.copy(destinationFile.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Assert.assertThrows(CoreException.class, () -> localFile.copy(localFile.getFullPath(), 0, ResourceTestUtil.createTestMonitor()));
    }

    @Test
    public void testCopyFolder() throws CoreException {
        IFileStore sourceStore = this.createFolderStore("source");
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("project");
        IFolder parentFolder = project.getFolder("parent");
        IFolder source = parentFolder.getFolder("source");
        IFolder destination = project.getFolder("destination");
        ResourceTestUtil.createInWorkspace((IResource)project);
        parentFolder.create(0, true, ResourceTestUtil.createTestMonitor());
        source.createLink(sourceStore.toURI(), 0, ResourceTestUtil.createTestMonitor());
        source.copy(destination.getFullPath(), 32, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"1.1", (boolean)destination.exists());
        destination.delete(0, ResourceTestUtil.createTestMonitor());
        source.copy(destination.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.1", (boolean)destination.exists());
        Assert.assertThrows(CoreException.class, () -> source.copy(destination.getFullPath(), 0, ResourceTestUtil.createTestMonitor()));
        Assert.assertThrows(CoreException.class, () -> source.copy(source.getFullPath(), 0, ResourceTestUtil.createTestMonitor()));
    }

    @Test
    public void testMoveFile() throws CoreException {
        IFileStore sourceStore = this.createFolderStore("source");
        IFileStore destinationStore = this.createFolderStore("destination");
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("project");
        IFolder source = project.getFolder("source");
        IFolder destination = project.getFolder("destination");
        IFile sourceFile = source.getFile("file.txt");
        IFile destinationFile = destination.getFile(sourceFile.getName());
        IFile localFile = project.getFile(sourceFile.getName());
        ResourceTestUtil.createInWorkspace((IResource)project);
        source.createLink(sourceStore.toURI(), 0, ResourceTestUtil.createTestMonitor());
        destination.createLink(destinationStore.toURI(), 0, ResourceTestUtil.createTestMonitor());
        sourceFile.create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        sourceFile.move(destinationFile.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        destinationFile.move(sourceFile.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        sourceFile.move(localFile.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        localFile.move(destinationFile.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Assert.assertThrows(CoreException.class, () -> localFile.copy(localFile.getFullPath(), 0, ResourceTestUtil.createTestMonitor()));
    }

    @Test
    public void test342060() throws CoreException {
        IFileStore sourceStore = this.createBogusFolderStore("source");
        IFileStore destinationStore = this.createBogusFolderStore("destination");
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("project");
        IFolder source = project.getFolder("source");
        IFolder destination = project.getFolder("destination");
        IFile sourceFile = source.getFile("file.txt");
        ResourceTestUtil.createInWorkspace((IResource)project);
        source.createLink(sourceStore.toURI(), 0, ResourceTestUtil.createTestMonitor());
        destination.createLink(destinationStore.toURI(), 0, ResourceTestUtil.createTestMonitor());
        sourceFile.create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        project.move(IPath.fromPortableString((String)"movedProject"), 0, ResourceTestUtil.createTestMonitor());
    }

    protected IFileStore createBogusFolderStore(String name) throws CoreException {
        IFileSystem system = this.getBogusFileSystem();
        IFileStore store = system.getStore(IPath.ROOT.append(name));
        this.workspaceRule.deleteOnTearDown(IPath.fromOSString((String)system.getStore(IPath.ROOT).toLocalFile(0, ResourceTestUtil.createTestMonitor()).getPath()));
        store.mkdir(0, ResourceTestUtil.createTestMonitor());
        return store;
    }

    protected IFileSystem getBogusFileSystem() throws CoreException {
        return EFS.getFileSystem((String)"bogus");
    }
}

