/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.internal.resources.ValidateProjectEncoding;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.eclipse.osgi.util.NLS;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;

public class ProjectEncodingTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private static final int IGNORE = -1;
    private IProject project;

    @After
    public void tearDown() throws Exception {
        if (this.project != null) {
            this.project.delete(true, true, null);
        }
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").putInt("missingEncodingMarkerSeverity", 1);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").flush();
    }

    @Test
    public void test_ProjectWithoutEncoding_PreferenceIsSetToIgnore_NoMarkerIsPlaced() throws Exception {
        this.givenPreferenceIsSetTo(-1);
        this.whenProjectIsCreated();
        this.whenProjectSpecificEncodingWasRemoved();
        this.thenProjectHasNoEncodingMarker();
    }

    @Test
    public void test_ProjectWithoutEncoding_PreferenceIsSetToInfo_InfoMarkerIsPlaced() throws Exception {
        this.verifyMarkerIsAddedToProjectWithNoEncodingIfPreferenceIsSetTo(0);
    }

    @Test
    public void test_ProjectWithoutEncoding_PreferenceIsSetToWarning_WarningMarkerIsPlaced() throws Exception {
        this.verifyMarkerIsAddedToProjectWithNoEncodingIfPreferenceIsSetTo(1);
    }

    @Test
    public void test_ProjectWithoutEncoding_PreferenceIsSetToError_ErrorMarkerIsPlaced() throws Exception {
        this.verifyMarkerIsAddedToProjectWithNoEncodingIfPreferenceIsSetTo(2);
    }

    private void verifyMarkerIsAddedToProjectWithNoEncodingIfPreferenceIsSetTo(int severity) throws Exception {
        this.givenPreferenceIsSetTo(severity);
        this.whenProjectIsCreated();
        this.whenProjectSpecificEncodingWasRemoved();
        this.thenProjectHasEncodingMarkerOfSeverity(severity);
    }

    private void verifyNoMarkerIsAddedToProjectWithEncodingIfPreferenceIsSetTo(int severity) throws Exception {
        this.givenPreferenceIsSetTo(severity);
        this.whenProjectIsCreated();
        this.whenProjectSpecificEncodingWasSet();
        this.thenProjectHasNoEncodingMarker();
    }

    @Test
    public void test_ProjectWithEncoding_PreferenceIsSetToIgnore_NoMarkerIsPlaced() throws Exception {
        this.verifyNoMarkerIsAddedToProjectWithEncodingIfPreferenceIsSetTo(-1);
    }

    @Test
    public void test_ProjectWithEncoding_PreferenceIsSetToInfo_NoMarkerIsPlaced() throws Exception {
        this.verifyNoMarkerIsAddedToProjectWithEncodingIfPreferenceIsSetTo(0);
    }

    @Test
    public void test_ProjectWithEncoding_PreferenceIsSetToWarning_NoMarkerIsPlaced() throws Exception {
        this.verifyNoMarkerIsAddedToProjectWithEncodingIfPreferenceIsSetTo(1);
    }

    @Test
    public void test_ProjectWithEncoding_PreferenceIsSetToError_NoMarkerIsPlaced() throws Exception {
        this.verifyNoMarkerIsAddedToProjectWithEncodingIfPreferenceIsSetTo(2);
    }

    @Test
    public void test_ProjectWithoutEncoding_PreferenceChanges_MarkerIsReplacedAccordingly() throws Exception {
        this.givenPreferenceIsSetTo(1);
        this.whenProjectIsCreated();
        this.whenProjectSpecificEncodingWasRemoved();
        this.thenProjectHasEncodingMarkerOfSeverity(1);
        this.whenPreferenceIsChangedTo(0);
        this.thenProjectHasEncodingMarkerOfSeverity(0);
        this.whenPreferenceIsChangedTo(2);
        this.thenProjectHasEncodingMarkerOfSeverity(2);
        this.whenPreferenceIsChangedTo(-1);
        this.thenProjectHasNoEncodingMarker();
        this.whenPreferenceIsChangedTo(1);
        this.thenProjectHasEncodingMarkerOfSeverity(1);
    }

    @Test
    public void test_ProjectEncodingWasAdded_ProblemMarkerIsGone() throws Exception {
        this.givenPreferenceIsSetTo(1);
        this.whenProjectIsCreated();
        this.whenProjectSpecificEncodingWasRemoved();
        this.thenProjectHasEncodingMarkerOfSeverity(1);
        this.whenProjectSpecificEncodingWasSet();
        this.thenProjectHasNoEncodingMarker();
    }

    private void whenPreferenceIsChangedTo(int severity) throws Exception {
        this.givenPreferenceIsSetTo(severity);
    }

    private void givenPreferenceIsSetTo(int value) throws Exception {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        node.putInt("missingEncodingMarkerSeverity", value);
        node.flush();
        Job.getJobManager().wakeUp(ValidateProjectEncoding.class);
        Job.getJobManager().join(ValidateProjectEncoding.class, ResourceTestUtil.createTestMonitor());
    }

    private void whenProjectIsCreated() throws CoreException {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)this.project);
    }

    private void whenProjectSpecificEncodingWasRemoved() throws Exception {
        this.project.setDefaultCharset(null, null);
        this.buildAndWaitForBuildFinish();
    }

    private void whenProjectSpecificEncodingWasSet() throws Exception {
        this.project.setDefaultCharset("UTF-8", null);
        this.buildAndWaitForBuildFinish();
    }

    private void thenProjectHasNoEncodingMarker() throws Exception {
        Object[] markers = this.project.findMarkers(ValidateProjectEncoding.MARKER_TYPE, false, 1);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])markers).describedAs("Expected to find no marker for project specific file encoding", new Object[0])).isEmpty();
    }

    private void thenProjectHasEncodingMarkerOfSeverity(int expectedSeverity) throws Exception {
        MatcherAssert.assertThat((Object)this.project, this.hasEncodingMarkerOfSeverity(expectedSeverity));
    }

    private BaseMatcher<IProject> hasEncodingMarkerOfSeverity(final int expectedSeverity) {
        return new DiagnosingMatcher<IProject>(){

            public boolean matches(Object item, Description mismatchDescription) {
                IProject theProject = (IProject)item;
                try {
                    IMarker[] markers = theProject.findMarkers(ValidateProjectEncoding.MARKER_TYPE, false, 1);
                    if (markers.length == 1) {
                        IMarker marker = markers[0];
                        String[] attributeNames = new String[]{"message", "severity", "location"};
                        Object[] values = marker.getAttributes(attributeNames);
                        boolean msgOk = this.getExpectedMarkerMessage().equals(values[0]);
                        boolean sevOk = Integer.valueOf(expectedSeverity).equals(values[1]);
                        boolean locOk = ProjectEncodingTest.this.project.getFullPath().toString().equals(values[2]);
                        if (!msgOk) {
                            mismatchDescription.appendText("\n has marker message: " + String.valueOf(values[0]));
                        }
                        if (!sevOk) {
                            mismatchDescription.appendText("\n has marker severity: " + String.valueOf(values[1]));
                        }
                        if (!locOk) {
                            mismatchDescription.appendText("\n has marker location: " + String.valueOf(values[2]));
                        }
                        return msgOk && sevOk && locOk;
                    }
                    mismatchDescription.appendText("\n has " + markers.length + " encoding markers");
                }
                catch (CoreException e) {
                    mismatchDescription.appendText("\n cannot access markers: " + e.getMessage());
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("\n has marker of message: '" + this.getExpectedMarkerMessage() + "'");
                description.appendText("\n has marker severity: " + expectedSeverity);
                description.appendText("\n has location: <path of the project>");
            }

            private String getExpectedMarkerMessage() {
                return NLS.bind((String)Messages.resources_checkExplicitEncoding_problemText, (Object)ProjectEncodingTest.this.project.getName());
            }
        };
    }

    private void buildAndWaitForBuildFinish() {
        ResourceTestUtil.waitForBuild();
    }
}

