/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Rule;
import org.junit.Test;

public class ProjectOrderTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    void addProjectReference(IProject source, IProject target) throws CoreException {
        IProjectDescription pd = source.getDescription();
        IProject[] a = pd.getReferencedProjects();
        HashSet<IProject> x = new HashSet<IProject>();
        x.addAll(Arrays.asList(a));
        x.add(target);
        IProject[] r = new IProject[x.size()];
        x.toArray(r);
        pd.setReferencedProjects(r);
        source.setDescription(pd, null);
    }

    @Test
    public void test0() throws CoreException {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = ws.getRoot();
        IProject p0 = root.getProject("p0");
        IProject p1 = root.getProject("p1");
        IProject p2 = root.getProject("p2");
        IProject p3 = root.getProject("p3");
        IProject p4 = root.getProject("p4");
        IProject p5 = root.getProject("p5");
        p0.create(null);
        p0.open(null);
        p1.create(null);
        p1.open(null);
        p2.create(null);
        p2.open(null);
        p3.create(null);
        p3.open(null);
        p4.create(null);
        p4.open(null);
        p5.create(null);
        p5.open(null);
        this.addProjectReference(p2, p1);
        this.addProjectReference(p3, p2);
        this.addProjectReference(p4, p3);
        IProject[] projects = new IProject[]{p4, p3, p2, p5, p1, p0};
        IProject[][] oldOrder = ws.computePrerequisiteOrder(projects);
        Assertions.assertThat((Object[])oldOrder[1]).isEmpty();
        List<IProject> x = Arrays.asList(oldOrder[0]);
        Assertions.assertThat(x).hasSize(6);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p0)).as("index p0", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p1)).as("index p1", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p2)).as("index p2", new Object[0])).isGreaterThan(x.indexOf(p1));
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p3)).as("index p3", new Object[0])).isGreaterThan(x.indexOf(p2));
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p4)).as("index p4", new Object[0])).isGreaterThan(x.indexOf(p3));
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p5)).as("index p5", new Object[0])).isGreaterThanOrEqualTo(0);
        IWorkspace.ProjectOrder order = ws.computeProjectOrder(projects);
        x = Arrays.asList(order.projects);
        Assertions.assertThat((Object)order).matches(it -> !it.hasCycles, "has no cycles");
        Assertions.assertThat((Object[][])order.knots).isEmpty();
        Assertions.assertThat(x).hasSize(6);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p0)).as("index p0", new Object[0])).isLessThan(x.indexOf(p1));
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p2)).as("index p2", new Object[0])).isGreaterThan(x.indexOf(p1));
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p3)).as("index p3", new Object[0])).isGreaterThan(x.indexOf(p2));
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p4)).as("index p4", new Object[0])).isGreaterThan(x.indexOf(p3));
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p5)).as("index p5", new Object[0])).isGreaterThan(x.indexOf(p4));
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p5)).as("index p5", new Object[0])).isGreaterThanOrEqualTo(0);
    }

    @Test
    public void test1() throws CoreException {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = ws.getRoot();
        IProject p0 = root.getProject("p0");
        IProject p1 = root.getProject("p1");
        IProject[] projects = new IProject[]{};
        IProject[][] oldOrder = ws.computePrerequisiteOrder(projects);
        List<IProject> x = Arrays.asList(oldOrder[0]);
        Assertions.assertThat((Object[])oldOrder[1]).isEmpty();
        Assertions.assertThat(x).isEmpty();
        IWorkspace.ProjectOrder order = ws.computeProjectOrder(projects);
        x = Arrays.asList(order.projects);
        Assertions.assertThat((Object)order).matches(it -> !it.hasCycles, "has no cycles");
        Assertions.assertThat((Object[][])order.knots).isEmpty();
        Assertions.assertThat(x).isEmpty();
        p0.create(null);
        p0.open(null);
        projects = new IProject[]{p0};
        oldOrder = ws.computePrerequisiteOrder(projects);
        x = Arrays.asList(oldOrder[0]);
        Assertions.assertThat((Object[])oldOrder[1]).isEmpty();
        Assertions.assertThat(x).hasSize(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p0)).as("index p0", new Object[0])).isGreaterThanOrEqualTo(0);
        order = ws.computeProjectOrder(projects);
        x = Arrays.asList(order.projects);
        Assertions.assertThat((Object)order).matches(it -> !it.hasCycles, "has no cycles");
        Assertions.assertThat((Object[][])order.knots).isEmpty();
        Assertions.assertThat(x).hasSize(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p0)).as("index p0", new Object[0])).isGreaterThanOrEqualTo(0);
        p0.close(null);
        projects = new IProject[]{p0};
        oldOrder = ws.computePrerequisiteOrder(projects);
        x = Arrays.asList(oldOrder[0]);
        Assertions.assertThat((Object[])oldOrder[1]).isEmpty();
        Assertions.assertThat(x).isEmpty();
        order = ws.computeProjectOrder(projects);
        x = Arrays.asList(order.projects);
        Assertions.assertThat((Object)order).matches(it -> !it.hasCycles, "has no cycles");
        Assertions.assertThat((Object[][])order.knots).isEmpty();
        Assertions.assertThat(x).isEmpty();
        projects = new IProject[]{p0, p1};
        oldOrder = ws.computePrerequisiteOrder(projects);
        x = Arrays.asList(oldOrder[0]);
        Assertions.assertThat((Object[])oldOrder[1]).isEmpty();
        Assertions.assertThat(x).isEmpty();
        order = ws.computeProjectOrder(projects);
        x = Arrays.asList(order.projects);
        Assertions.assertThat((Object)order).matches(it -> !it.hasCycles, "has no cycles");
        Assertions.assertThat((Object[][])order.knots).isEmpty();
        Assertions.assertThat(x).isEmpty();
        p0.delete(4, null);
        p0.create(null);
        p0.open(null);
        p1.create(null);
        p1.open(null);
        projects = new IProject[]{p1, p0};
        oldOrder = ws.computePrerequisiteOrder(projects);
        x = Arrays.asList(oldOrder[0]);
        Assertions.assertThat((Object[])oldOrder[1]).isEmpty();
        Assertions.assertThat(x).hasSize(2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p0)).as("index p0", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p1)).as("index p1", new Object[0])).isGreaterThanOrEqualTo(0);
        order = ws.computeProjectOrder(projects);
        x = Arrays.asList(order.projects);
        Assertions.assertThat(x).hasSize(2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p0)).as("index p0", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p1)).as("index p1", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p0)).as("index p0", new Object[0])).isLessThan(x.indexOf(p1));
        Assertions.assertThat((Object)order).matches(it -> !it.hasCycles, "has no cycles");
        Assertions.assertThat((Object[][])order.knots).isEmpty();
        p0.close(null);
        oldOrder = ws.computePrerequisiteOrder(projects);
        x = Arrays.asList(oldOrder[0]);
        Assertions.assertThat((Object[])oldOrder[1]).isEmpty();
        Assertions.assertThat(x).hasSize(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p0)).as("index p0", new Object[0])).isLessThan(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p1)).as("index p1", new Object[0])).isGreaterThanOrEqualTo(0);
        order = ws.computeProjectOrder(projects);
        x = Arrays.asList(order.projects);
        Assertions.assertThat((Object)order).matches(it -> !it.hasCycles, "has no cycles");
        Assertions.assertThat((Object[][])order.knots).isEmpty();
        Assertions.assertThat(x).hasSize(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p0)).as("index p0", new Object[0])).isLessThan(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p1)).as("index p1", new Object[0])).isGreaterThanOrEqualTo(0);
        p0.open(null);
        p1.close(null);
        oldOrder = ws.computePrerequisiteOrder(projects);
        x = Arrays.asList(oldOrder[0]);
        Assertions.assertThat((Object[])oldOrder[1]).isEmpty();
        Assertions.assertThat(x).hasSize(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p0)).as("index p0", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p1)).as("index p1", new Object[0])).isLessThan(0);
        order = ws.computeProjectOrder(projects);
        x = Arrays.asList(order.projects);
        Assertions.assertThat((Object)order).matches(it -> !it.hasCycles, "has no cycles");
        Assertions.assertThat((Object[][])order.knots).isEmpty();
        Assertions.assertThat(x).hasSize(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p0)).as("index p0", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p1)).as("index p1", new Object[0])).isLessThan(0);
        p0.delete(4, null);
        p1.delete(4, null);
        p0.create(null);
        p0.open(null);
        p1.create(null);
        p1.open(null);
        this.addProjectReference(p0, p1);
        projects = new IProject[]{p1, p0};
        oldOrder = ws.computePrerequisiteOrder(projects);
        x = Arrays.asList(oldOrder[0]);
        Assertions.assertThat((Object[])oldOrder[1]).isEmpty();
        Assertions.assertThat(x).hasSize(2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p0)).as("index p0", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p1)).as("index p1", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p0)).as("index p0", new Object[0])).isGreaterThan(x.indexOf(p1));
        order = ws.computeProjectOrder(projects);
        x = Arrays.asList(order.projects);
        Assertions.assertThat(x).hasSize(2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p0)).as("index p0", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p1)).as("index p1", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p0)).as("index p0", new Object[0])).isGreaterThan(x.indexOf(p1));
        Assertions.assertThat((Object)order).matches(it -> !it.hasCycles, "has no cycles");
        Assertions.assertThat((Object[][])order.knots).isEmpty();
        p0.delete(4, null);
        p1.delete(4, null);
        p0.create(null);
        p0.open(null);
        p1.create(null);
        p1.open(null);
        this.addProjectReference(p1, p0);
        projects = new IProject[]{p1, p0};
        oldOrder = ws.computePrerequisiteOrder(projects);
        x = Arrays.asList(oldOrder[0]);
        Assertions.assertThat((Object[])oldOrder[1]).isEmpty();
        Assertions.assertThat(x).hasSize(2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p0)).as("index p0", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p1)).as("index p1", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p1)).as("index p1", new Object[0])).isGreaterThan(x.indexOf(p0));
        order = ws.computeProjectOrder(projects);
        x = Arrays.asList(order.projects);
        Assertions.assertThat((Object)order).matches(it -> !it.hasCycles, "has no cycles");
        Assertions.assertThat((Object[][])order.knots).isEmpty();
        Assertions.assertThat(x).hasSize(2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p0)).as("index p0", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p1)).as("index p1", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p1)).as("index p1", new Object[0])).isGreaterThan(x.indexOf(p0));
        p0.delete(4, null);
        p1.delete(4, null);
        p0.create(null);
        p0.open(null);
        p1.create(null);
        p1.open(null);
        this.addProjectReference(p1, p0);
        this.addProjectReference(p0, p1);
        projects = new IProject[]{p1, p0};
        oldOrder = ws.computePrerequisiteOrder(projects);
        x = Arrays.asList(oldOrder[0]);
        List<IProject> unordered = Arrays.asList(oldOrder[1]);
        Assertions.assertThat((Object[])oldOrder[1]).hasSize(2);
        Assertions.assertThat(x).isEmpty();
        Assertions.assertThat(unordered).hasSize(2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)unordered.indexOf(p0)).as("index p0", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)unordered.indexOf(p1)).as("index p1", new Object[0])).isGreaterThanOrEqualTo(0);
        order = ws.computeProjectOrder(projects);
        x = Arrays.asList(order.projects);
        Assertions.assertThat((Object)order).matches(it -> it.hasCycles, "has cycles");
        Assertions.assertThat((Object[][])order.knots).hasNumberOfRows(1);
        Assertions.assertThat(x).hasSize(2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p0)).as("index p0", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p1)).as("index p1", new Object[0])).isGreaterThanOrEqualTo(0);
        List<IProject> knot = Arrays.asList(order.knots[0]);
        Assertions.assertThat(knot).hasSize(2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)knot.indexOf(p0)).as("index p0", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)knot.indexOf(p1)).as("index p1", new Object[0])).isGreaterThanOrEqualTo(0);
        p0.close(null);
        oldOrder = ws.computePrerequisiteOrder(projects);
        x = Arrays.asList(oldOrder[0]);
        Assertions.assertThat((Object[])oldOrder[1]).isEmpty();
        Assertions.assertThat(x).hasSize(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p1)).as("index p1", new Object[0])).isGreaterThanOrEqualTo(0);
        order = ws.computeProjectOrder(projects);
        x = Arrays.asList(order.projects);
        Assertions.assertThat((Object)order).matches(it -> !it.hasCycles, "has no cycles");
        Assertions.assertThat((Object[][])order.knots).isEmpty();
        Assertions.assertThat(x).hasSize(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p1)).as("index p1", new Object[0])).isGreaterThanOrEqualTo(0);
        p0.open(null);
        p1.close(null);
        oldOrder = ws.computePrerequisiteOrder(projects);
        x = Arrays.asList(oldOrder[0]);
        Assertions.assertThat((Object[])oldOrder[1]).isEmpty();
        Assertions.assertThat(x).hasSize(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p0)).as("index p0", new Object[0])).isGreaterThanOrEqualTo(0);
        order = ws.computeProjectOrder(projects);
        x = Arrays.asList(order.projects);
        Assertions.assertThat((Object)order).matches(it -> !it.hasCycles, "has no cycles");
        Assertions.assertThat((Object[][])order.knots).isEmpty();
        Assertions.assertThat(x).hasSize(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p0)).as("index p0", new Object[0])).isGreaterThanOrEqualTo(0);
        p1.open(null);
        oldOrder = ws.computePrerequisiteOrder(projects);
        x = Arrays.asList(oldOrder[0]);
        unordered = Arrays.asList(oldOrder[1]);
        Assertions.assertThat((Object[])oldOrder[1]).hasSize(2);
        Assertions.assertThat(x).isEmpty();
        Assertions.assertThat(unordered).hasSize(2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)unordered.indexOf(p0)).as("index p0", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)unordered.indexOf(p1)).as("index p1", new Object[0])).isGreaterThanOrEqualTo(0);
        order = ws.computeProjectOrder(projects);
        x = Arrays.asList(order.projects);
        Assertions.assertThat((Object)order).matches(it -> it.hasCycles, "has cycles");
        Assertions.assertThat((Object[][])order.knots).hasNumberOfRows(1);
        Assertions.assertThat(x).hasSize(2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p0)).as("index p0", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(p1)).as("index p1", new Object[0])).isGreaterThanOrEqualTo(0);
        knot = Arrays.asList(order.knots[0]);
        Assertions.assertThat(x).hasSize(2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)knot.indexOf(p0)).as("index p0", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)knot.indexOf(p1)).as("index p1", new Object[0])).isGreaterThanOrEqualTo(0);
        p0.delete(4, null);
        p1.delete(4, null);
    }

    @Test
    public void test2() throws CoreException {
        List<IProject> temp;
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = ws.getRoot();
        IProject a = root.getProject("a");
        IProject b = root.getProject("b");
        IProject c = root.getProject("c");
        IProject d = root.getProject("d");
        IProject e = root.getProject("e");
        IProject f = root.getProject("f");
        IProject g = root.getProject("g");
        IProject h = root.getProject("h");
        a.create(null);
        a.open(null);
        b.create(null);
        b.open(null);
        c.create(null);
        c.open(null);
        d.create(null);
        d.open(null);
        e.create(null);
        e.open(null);
        f.create(null);
        f.open(null);
        g.create(null);
        g.open(null);
        h.create(null);
        h.open(null);
        this.addProjectReference(b, a);
        this.addProjectReference(a, e);
        this.addProjectReference(e, b);
        this.addProjectReference(c, d);
        this.addProjectReference(d, c);
        this.addProjectReference(f, g);
        this.addProjectReference(g, f);
        this.addProjectReference(h, h);
        this.addProjectReference(c, b);
        this.addProjectReference(f, b);
        this.addProjectReference(g, c);
        this.addProjectReference(h, d);
        this.addProjectReference(h, g);
        IProject[] projects = new IProject[]{a, b, c, d, e, f, g, h};
        IProject[][] oldOrder = ws.computePrerequisiteOrder(projects);
        List<IProject> x = Arrays.asList(oldOrder[0]);
        List<IProject> unordered = Arrays.asList(oldOrder[1]);
        Assertions.assertThat(x).hasSize(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(h)).as("index h", new Object[0])).isGreaterThanOrEqualTo(0);
        Assertions.assertThat(unordered).hasSize(7);
        ((AbstractIntegerAssert)Assertions.assertThat((int)unordered.indexOf(a)).as("index a", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)unordered.indexOf(b)).as("index b", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)unordered.indexOf(c)).as("index c", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)unordered.indexOf(d)).as("index d", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)unordered.indexOf(e)).as("index e", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)unordered.indexOf(f)).as("index f", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)unordered.indexOf(g)).as("index g", new Object[0])).isGreaterThanOrEqualTo(0);
        IWorkspace.ProjectOrder order = ws.computeProjectOrder(projects);
        x = Arrays.asList(order.projects);
        Assertions.assertThat(x).hasSize(8);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(a)).as("index a", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(b)).as("index b", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(c)).as("index c", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(d)).as("index d", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(e)).as("index e", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(f)).as("index f", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(g)).as("index g", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(h)).as("index h", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(b)).as("index b", new Object[0])).isLessThan(x.indexOf(c));
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(b)).as("index b", new Object[0])).isLessThan(x.indexOf(d));
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(a)).as("index a", new Object[0])).isLessThan(x.indexOf(c));
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(a)).as("index a", new Object[0])).isLessThan(x.indexOf(d));
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(e)).as("index e", new Object[0])).isLessThan(x.indexOf(c));
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(e)).as("index e", new Object[0])).isLessThan(x.indexOf(d));
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(c)).as("index c", new Object[0])).isLessThan(x.indexOf(f));
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(c)).as("index c", new Object[0])).isLessThan(x.indexOf(g));
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(d)).as("index d", new Object[0])).isLessThan(x.indexOf(f));
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(d)).as("index d", new Object[0])).isLessThan(x.indexOf(g));
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(f)).as("index f", new Object[0])).isLessThan(x.indexOf(h));
        ((AbstractIntegerAssert)Assertions.assertThat((int)x.indexOf(g)).as("index g", new Object[0])).isLessThan(x.indexOf(h));
        Assertions.assertThat((Object)order).matches(it -> it.hasCycles, "has cycles");
        Assertions.assertThat((Object[][])order.knots).hasNumberOfRows(3);
        List<IProject> k1 = Arrays.asList(order.knots[0]);
        List<IProject> k2 = Arrays.asList(order.knots[1]);
        List<IProject> k3 = Arrays.asList(order.knots[2]);
        if (k2.indexOf(b) >= 0) {
            temp = k1;
            k1 = k2;
            k2 = temp;
        } else if (k3.indexOf(b) >= 0) {
            temp = k1;
            k1 = k3;
            k3 = temp;
        }
        if (k3.indexOf(c) >= 0) {
            temp = k2;
            k2 = k3;
            k3 = temp;
        }
        Assertions.assertThat(k1).hasSize(3);
        ((AbstractIntegerAssert)Assertions.assertThat((int)k1.indexOf(a)).as("index a", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)k1.indexOf(b)).as("index b", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)k1.indexOf(e)).as("index e", new Object[0])).isGreaterThanOrEqualTo(0);
        Assertions.assertThat(k2).hasSize(2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)k2.indexOf(c)).as("index c", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)k2.indexOf(d)).as("index d", new Object[0])).isGreaterThanOrEqualTo(0);
        Assertions.assertThat(k3).hasSize(2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)k3.indexOf(f)).as("index f", new Object[0])).isGreaterThanOrEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)k3.indexOf(g)).as("index g", new Object[0])).isGreaterThanOrEqualTo(0);
    }
}

