/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;

public class ProjectSnapshotPerfManualTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    public static final String bigSiteDevice = "c:";
    public static final IPath bigSiteLocation = new Path("c:", "/test");
    private static final String DIR_NAME = ".settings";
    private static final String REFRESH_SNAPSHOT_FILE_LOCATION = ".settings/resource-index.zip";

    protected int countChildren(File root) {
        String[] children = root.list();
        if (children == null) {
            return 0;
        }
        int result = 0;
        String[] stringArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            File child = new File(root, element);
            if (child.isDirectory()) {
                result += this.countChildren(child);
            }
            ++result;
            ++n2;
        }
        return result;
    }

    @Test
    public void testSnapshotImportPerformance() throws Exception {
        Assume.assumeTrue((boolean)bigSiteLocation.toFile().isDirectory());
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyTestProject");
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        description.setLocation(bigSiteLocation);
        int numberOfFiles = this.countChildren(bigSiteLocation.toFile());
        System.out.println("Number of local resources: " + numberOfFiles);
        project.create(description, null);
        new PerformanceTestRunner(){

            protected void test() throws CoreException {
                project.open(null);
            }
        }.run(this.getClass(), "Original open", 1, 1);
        ResourceTestUtil.createInWorkspace((IResource)project.getFolder(DIR_NAME));
        IPath projPath = project.getLocation();
        projPath = projPath.append(REFRESH_SNAPSHOT_FILE_LOCATION);
        final URI snapshotLocation = URIUtil.toURI((IPath)projPath);
        project.saveSnapshot(1, snapshotLocation, null);
        project.close(null);
        project.delete(false, false, null);
        project.create(description, null);
        new PerformanceTestRunner(){

            protected void test() throws CoreException {
                project.loadSnapshot(1, snapshotLocation, null);
                project.open(0, null);
            }
        }.run(this.getClass(), "Snapshot open", 1, 1);
        final ResourceDeltaVerifier[] verifier = new ResourceDeltaVerifier[1];
        new PerformanceTestRunner(){

            protected void test() throws CoreException {
                verifier[0] = new ResourceDeltaVerifier();
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)verifier[0]);
                verifier[0].reset();
                IFolder settings = project.getFolder(ProjectSnapshotPerfManualTest.DIR_NAME);
                IFile snapshot = project.getFile(ProjectSnapshotPerfManualTest.REFRESH_SNAPSHOT_FILE_LOCATION);
                verifier[0].addExpectedChange((IResource)settings, 4, 0);
                verifier[0].addExpectedChange((IResource)snapshot, 1, 0);
                project.refreshLocal(2, null);
            }
        }.run(this.getClass(), "Forced refresh only", 1, 1);
        verifier[0].verifyDelta(null);
        Assert.assertTrue((String)("1.0 " + verifier[0].getMessage()), (boolean)verifier[0].isDeltaValid());
        project.close(null);
        project.delete(false, false, null);
        IPath snapshotFile = bigSiteLocation.append(REFRESH_SNAPSHOT_FILE_LOCATION);
        snapshotFile.toFile().delete();
        project.create(description, null);
        new PerformanceTestRunner(){

            protected void test() throws CoreException {
                project.open(null);
            }
        }.run(this.getClass(), "Second refresh open", 1, 1);
        project.close(null);
        project.delete(false, false, null);
    }
}

