/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ProjectSnapshotTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private static final String REFRESH_SNAPSHOT_FILE_LOCATION = "resource-index.zip";
    protected IProject[] projects = new IProject[2];

    @Before
    public void setUp() throws Exception {
        this.projects[0] = ResourcesPlugin.getWorkspace().getRoot().getProject("p1");
        this.projects[1] = ResourcesPlugin.getWorkspace().getRoot().getProject("p2");
        ResourceTestUtil.createInWorkspace((IResource[])this.projects);
    }

    private void populateProject(IProject project) throws Exception {
        IFile file = project.getFile("file");
        ResourceTestUtil.createInFileSystem((IResource)file);
        IFolder folder = project.getFolder("folder");
        IFolder subfolder = folder.getFolder("subfolder");
        IFile subfile = folder.getFile("subfile");
        ResourceTestUtil.createInFileSystem((IResource)folder);
        ResourceTestUtil.createInFileSystem((IResource)subfolder);
        ResourceTestUtil.createInFileSystem((IResource)subfile);
    }

    private URI getSnapshotLocation(IProject project) {
        IPath projPath = project.getLocation();
        projPath = projPath.append(REFRESH_SNAPSHOT_FILE_LOCATION);
        return URIUtil.toURI((IPath)projPath);
    }

    @Test
    public void testSaveNullSnapshot() throws Throwable {
        Assert.assertThrows(CoreException.class, () -> this.projects[0].saveSnapshot(1, null, null));
    }

    @Test
    public void testLoadNoRefresh() throws Throwable {
        IProject project = this.projects[0];
        this.populateProject(project);
        project.refreshLocal(2, null);
        URI snapshotLocation = this.getSnapshotLocation(this.projects[1]);
        project.saveSnapshot(1, snapshotLocation, null);
        project.close(null);
        project.delete(true, false, null);
        project.create(null);
        project.loadSnapshot(1, snapshotLocation, null);
        project.open(0, null);
        IFile file = project.getFile("file");
        IFolder folder = project.getFolder("folder");
        IFolder subfolder = folder.getFolder("subfolder");
        IFile subfile = folder.getFile("subfile");
        Assert.assertTrue((String)"1.1", (boolean)file.exists());
        Assert.assertTrue((String)"1.2", (boolean)folder.exists());
        Assert.assertTrue((String)"1.3", (boolean)subfolder.exists());
        Assert.assertTrue((String)"1.4", (boolean)subfile.exists());
    }

    @Test
    public void testLoadWithRefresh() throws Throwable {
        IProject project = this.projects[0];
        this.populateProject(project);
        project.refreshLocal(2, null);
        URI snapshotLocation = this.getSnapshotLocation(this.projects[1]);
        project.saveSnapshot(1, snapshotLocation, null);
        TimeUnit.MILLISECONDS.sleep(1001L);
        project.close(null);
        project.delete(true, false, null);
        project.create(null);
        project.loadSnapshot(1, snapshotLocation, null);
        project.open(0, null);
        ResourceDeltaVerifier verifier = new ResourceDeltaVerifier();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)verifier);
        verifier.reset();
        IFile file = project.getFile("file");
        IFolder folder = project.getFolder("folder");
        IFolder subfolder = folder.getFolder("subfolder");
        IFile subfile = folder.getFile("subfile");
        verifier.addExpectedChange((IResource)file, 2, 0);
        verifier.addExpectedChange((IResource)folder, 2, 0);
        verifier.addExpectedChange((IResource)subfolder, 2, 0);
        verifier.addExpectedChange((IResource)subfile, 2, 0);
        verifier.addExpectedChange((IResource)project, 4, 524288);
        IFile dotProject = project.getFile(".project");
        verifier.addExpectedChange((IResource)dotProject, 4, 256);
        project.refreshLocal(2, null);
        verifier.verifyDelta(null);
        Assert.assertTrue((String)("1.0 " + verifier.getMessage()), (boolean)verifier.isDeltaValid());
        Assert.assertTrue((String)"1.1", (!file.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.2", (!folder.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.3", (!subfolder.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.4", (!subfile.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testLoadWithRename() throws Throwable {
        IProject project = this.projects[0];
        this.populateProject(project);
        project.refreshLocal(2, null);
        URI snapshotLocation = this.getSnapshotLocation(this.projects[1]);
        project.saveSnapshot(1, snapshotLocation, null);
        project.close(null);
        project.delete(true, false, null);
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("p3");
        project.create(null);
        project.loadSnapshot(1, snapshotLocation, null);
        project.open(0, null);
        IFile file = project.getFile("file");
        IFolder folder = project.getFolder("folder");
        IFolder subfolder = folder.getFolder("subfolder");
        IFile subfile = folder.getFile("subfile");
        Assert.assertTrue((String)"1.1", (boolean)file.exists());
        Assert.assertTrue((String)"1.2", (boolean)folder.exists());
        Assert.assertTrue((String)"1.3", (boolean)subfolder.exists());
        Assert.assertTrue((String)"1.4", (boolean)subfile.exists());
    }

    @Test
    public void testLoadWithRename2() throws Throwable {
        IProject project = this.projects[0];
        this.populateProject(project);
        project.refreshLocal(2, null);
        project.move(IPath.ROOT.append("p0"), true, null);
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("p0");
        IFile file2 = project.getFile("file2");
        ResourceTestUtil.createInFileSystem((IResource)file2);
        project.getFile("file3");
        URI snapshotLocation = this.getSnapshotLocation(this.projects[1]);
        project.saveSnapshot(1, snapshotLocation, null);
        project.close(null);
        project.delete(true, false, null);
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("p3");
        project.create(null);
        project.loadSnapshot(1, snapshotLocation, null);
        project.open(0, null);
        IFile file = project.getFile("file");
        IFolder folder = project.getFolder("folder");
        IFolder subfolder = folder.getFolder("subfolder");
        IFile subfile = folder.getFile("subfile");
        Assert.assertTrue((String)"1.1", (boolean)file.exists());
        Assert.assertTrue((String)"1.2", (boolean)folder.exists());
        Assert.assertTrue((String)"1.3", (boolean)subfolder.exists());
        Assert.assertTrue((String)"1.4", (boolean)subfile.exists());
    }

    @Test
    public void testAutoLoadInvalidURI() throws Throwable {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("project");
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        ((ProjectDescription)description).setSnapshotLocationURI(URI.create("./relative/uri.zip"));
        project.create(description, null);
        ResourceTestUtil.createInFileSystem((IResource)project.getFolder("foo"));
        Assert.assertFalse((String)"1.0", (boolean)project.getFolder("foo").exists());
        project.open(null);
        Assert.assertTrue((String)"1.1", (boolean)project.isOpen());
        Assert.assertTrue((String)"1.2", (boolean)project.getFolder("foo").exists());
        Assert.assertThrows(CoreException.class, () -> project.saveSnapshot(2, URI.create("NON_EXISTING/foo/bar.zip"), null));
    }

    @Test
    public void testAutoLoadMissingSnapshot() throws Throwable {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("project");
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        ((ProjectDescription)description).setSnapshotLocationURI(this.workspaceRule.getTempStore().toURI());
        project.create(description, null);
        ResourceTestUtil.createInFileSystem((IResource)project.getFile("foo"));
        Assert.assertFalse((String)"1.0", (boolean)project.getFile("foo").exists());
        project.open(null);
        Assert.assertTrue((String)"1.1", (boolean)project.isOpen());
        Assert.assertTrue((String)"1.2", (boolean)project.getFile("foo").exists());
    }

    @Test
    public void testAutoLoadWithRename() throws Throwable {
        IFileStore tempStore = this.workspaceRule.getTempStore();
        tempStore.mkdir(0, null);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("project");
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        description.setLocationURI(tempStore.getChild("project").toURI());
        project.create(description, null);
        project.open(null);
        this.populateProject(project);
        project.refreshLocal(2, null);
        URI snapshotLocation = tempStore.getChild("project-index.zip").toURI();
        snapshotLocation = project.getPathVariableManager().convertToRelative(snapshotLocation, true, null);
        project.saveSnapshot(3, snapshotLocation, null);
        IFileStore newProjectStore = tempStore.getChild("pnew");
        newProjectStore.mkdir(0, null);
        EFS.getStore((URI)project.getLocationURI()).getChild(".project").copy(newProjectStore.getChild(".project"), 0, null);
        project.close(null);
        project.delete(true, false, null);
        Throwable throwable = null;
        Object var7_8 = null;
        try (InputStream is = newProjectStore.getChild(".project").openInputStream(0, null);){
            description = ResourcesPlugin.getWorkspace().loadProjectDescription(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        description.setLocationURI(newProjectStore.toURI());
        project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName() + "-mybranch");
        project.create(description, null);
        project.open(0, null);
        IFile file = project.getFile("file");
        IFolder folder = project.getFolder("folder");
        IFolder subfolder = folder.getFolder("subfolder");
        IFile subfile = folder.getFile("subfile");
        Assert.assertTrue((String)"1.1", (boolean)file.exists());
        Assert.assertTrue((String)"1.2", (boolean)folder.exists());
        Assert.assertTrue((String)"1.3", (boolean)subfolder.exists());
        Assert.assertTrue((String)"1.4", (boolean)subfile.exists());
    }

    @Test
    public void testResetAutoLoadSnapshot() throws Throwable {
        IProject project = this.projects[0];
        URI tempURI = this.workspaceRule.getTempStore().toURI();
        IFile projectFile = project.getFile(".project");
        long stamp = projectFile.getModificationStamp();
        ProjectDescription desc = (ProjectDescription)project.getDescription();
        desc.setSnapshotLocationURI(null);
        project.setDescription((IProjectDescription)desc, null);
        Assert.assertEquals((String)"1.0", (long)stamp, (long)projectFile.getModificationStamp());
        project.saveSnapshot(2, tempURI, null);
        Assert.assertEquals((String)"2.0", (Object)tempURI, (Object)((ProjectDescription)project.getDescription()).getSnapshotLocationURI());
        long stamp2 = projectFile.getModificationStamp();
        Assert.assertFalse((String)"2.1", (stamp == stamp2 ? 1 : 0) != 0);
        project.saveSnapshot(2, tempURI, null);
        Assert.assertEquals((String)"2.2", (long)stamp2, (long)projectFile.getModificationStamp());
        desc = (ProjectDescription)project.getDescription();
        desc.setSnapshotLocationURI(null);
        project.setDescription((IProjectDescription)desc, null);
        Assert.assertNull((String)"3.0", (Object)((ProjectDescription)project.getDescription()).getSnapshotLocationURI());
        Assert.assertFalse((String)"3.1", (stamp2 == projectFile.getModificationStamp() ? 1 : 0) != 0);
        project.close(null);
        Assert.assertThrows(CoreException.class, () -> project.saveSnapshot(2, tempURI, null));
    }
}

