/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public class ResourceAttributeTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    private void setArchive(IResource resource, boolean value) throws CoreException {
        ResourceAttributes attributes = resource.getResourceAttributes();
        Assert.assertNotNull((String)"setAchive for null attributes", (Object)attributes);
        attributes.setArchive(value);
        resource.setResourceAttributes(attributes);
    }

    private void setExecutable(IResource resource, boolean value) throws CoreException {
        ResourceAttributes attributes = resource.getResourceAttributes();
        Assert.assertNotNull((String)"setExecutable for null attributes", (Object)attributes);
        attributes.setExecutable(value);
        resource.setResourceAttributes(attributes);
    }

    private void setHidden(IResource resource, boolean value) throws CoreException {
        ResourceAttributes attributes = resource.getResourceAttributes();
        Assert.assertNotNull((String)"setHidden for null attributes", (Object)attributes);
        attributes.setHidden(value);
        resource.setResourceAttributes(attributes);
    }

    private void setSymlink(IResource resource, boolean value) throws CoreException {
        ResourceAttributes attributes = resource.getResourceAttributes();
        Assert.assertNotNull((String)"setSymlink for null attributes", (Object)attributes);
        attributes.setSymbolicLink(value);
        resource.setResourceAttributes(attributes);
    }

    @Test
    public void testAttributeArchive() throws CoreException {
        Assume.assumeTrue((String)"only relevant for platforms supporting archive attribute", (boolean)ResourceTestUtil.isAttributeSupported(8));
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("target");
        ResourceTestUtil.createInWorkspace(file, ResourceTestUtil.createRandomString());
        Assert.assertTrue((String)"1.0", (boolean)file.getResourceAttributes().isArchive());
        this.setArchive((IResource)file, false);
        Assert.assertTrue((String)"1.2", (!file.getResourceAttributes().isArchive() ? 1 : 0) != 0);
        this.setArchive((IResource)file, true);
        Assert.assertTrue((String)"1.4", (boolean)file.getResourceAttributes().isArchive());
        Assert.assertTrue((String)"2.0", (!project.getResourceAttributes().isArchive() ? 1 : 0) != 0);
        this.setArchive((IResource)project, true);
        Assert.assertTrue((String)"2.2", (boolean)project.getResourceAttributes().isArchive());
        this.setArchive((IResource)project, false);
        Assert.assertTrue((String)"2.4", (!project.getResourceAttributes().isArchive() ? 1 : 0) != 0);
    }

    @Test
    public void testAttributeExecutable() throws CoreException {
        Assume.assumeTrue((String)"only relevant for platforms supporting executable attribute", (boolean)ResourceTestUtil.isAttributeSupported(4));
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("target");
        ResourceTestUtil.createInWorkspace(file, ResourceTestUtil.createRandomString());
        Assert.assertTrue((String)"1.0", (!file.getResourceAttributes().isExecutable() ? 1 : 0) != 0);
        this.setExecutable((IResource)file, true);
        Assert.assertTrue((String)"1.2", (boolean)file.getResourceAttributes().isExecutable());
        this.setExecutable((IResource)file, false);
        Assert.assertTrue((String)"1.4", (!file.getResourceAttributes().isExecutable() ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.0", (boolean)project.getResourceAttributes().isExecutable());
        this.setExecutable((IResource)project, false);
        Assert.assertTrue((String)"2.2", (!project.getResourceAttributes().isExecutable() ? 1 : 0) != 0);
        this.setExecutable((IResource)project, true);
        Assert.assertTrue((String)"2.4", (boolean)project.getResourceAttributes().isExecutable());
    }

    @Test
    public void testAttributeHidden() throws CoreException {
        Assume.assumeTrue((String)"only relevant for platforms supporting hidden attribute", (boolean)ResourceTestUtil.isAttributeSupported(16));
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("target");
        ResourceTestUtil.createInWorkspace(file, ResourceTestUtil.createRandomString());
        Assert.assertTrue((String)"1.0", (!file.getResourceAttributes().isHidden() ? 1 : 0) != 0);
        this.setHidden((IResource)file, true);
        Assert.assertTrue((String)"1.2", (boolean)file.getResourceAttributes().isHidden());
        this.setHidden((IResource)file, false);
        Assert.assertTrue((String)"1.4", (!file.getResourceAttributes().isHidden() ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.0", (!project.getResourceAttributes().isHidden() ? 1 : 0) != 0);
        this.setHidden((IResource)project, true);
        Assert.assertTrue((String)"2.2", (boolean)project.getResourceAttributes().isHidden());
        this.setHidden((IResource)project, false);
        Assert.assertTrue((String)"2.4", (!project.getResourceAttributes().isHidden() ? 1 : 0) != 0);
    }

    @Test
    public void testAttributeReadOnly() throws CoreException {
        Assume.assumeTrue((String)"only relevant for platforms supporting read-only attribute", (boolean)ResourceTestUtil.isAttributeSupported(2));
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("target");
        ResourceTestUtil.createInWorkspace(file, ResourceTestUtil.createRandomString());
        Assert.assertTrue((String)"1.0", (!file.getResourceAttributes().isReadOnly() ? 1 : 0) != 0);
        ResourceTestUtil.setReadOnly((IResource)file, true);
        Assert.assertTrue((String)"1.2", (boolean)file.getResourceAttributes().isReadOnly());
        ResourceTestUtil.setReadOnly((IResource)file, false);
        Assert.assertTrue((String)"1.4", (!file.getResourceAttributes().isReadOnly() ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.0", (!project.getResourceAttributes().isReadOnly() ? 1 : 0) != 0);
        ResourceTestUtil.setReadOnly((IResource)project, true);
        Assert.assertTrue((String)"2.2", (boolean)project.getResourceAttributes().isReadOnly());
        ResourceTestUtil.setReadOnly((IResource)project, false);
        Assert.assertTrue((String)"2.4", (!project.getResourceAttributes().isReadOnly() ? 1 : 0) != 0);
    }

    @Test
    public void testClosedProject() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        project.close(ResourceTestUtil.createTestMonitor());
        Assert.assertNull((String)"1.0", (Object)project.getResourceAttributes());
    }

    @Test
    public void testNonExistingResource() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("testNonExistingResource");
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file");
        ResourceTestUtil.removeFromWorkspace((IResource)project);
        Assert.assertNull((String)"1.0", (Object)project.getResourceAttributes());
        Assert.assertNull((String)"1.1", (Object)folder.getResourceAttributes());
        Assert.assertNull((String)"1.2", (Object)file.getResourceAttributes());
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.createInWorkspace((IResource)folder);
        ResourceTestUtil.createInWorkspace((IResource)file);
        Assert.assertNotNull((String)"2.0", (Object)project.getResourceAttributes());
        Assert.assertNotNull((String)"2.1", (Object)folder.getResourceAttributes());
        Assert.assertNotNull((String)"2.2", (Object)file.getResourceAttributes());
    }

    @Test
    @Ignore(value="currently failing on Hudson: see https://bugs.eclipse.org/bugs/show_bug.cgi?id=397353")
    public void testRefreshExecutableOnFolder() throws CoreException {
        Assume.assumeTrue((String)"only relevant for platforms supporting executable attribute", (boolean)ResourceTestUtil.isAttributeSupported(4));
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("testRefreshExecutableOnFolder");
        IFolder folder = project.getFolder("folder");
        IFile file = folder.getFile("file");
        ResourceTestUtil.createInWorkspace(file, ResourceTestUtil.createRandomString());
        Assert.assertTrue((String)"1.0", (boolean)project.getResourceAttributes().isExecutable());
        Assert.assertTrue((String)"1.1", (boolean)file.exists());
        this.setExecutable((IResource)folder, false);
        ResourceTestUtil.waitForRefresh();
        boolean wasExecutable = folder.getResourceAttributes().isExecutable();
        boolean fileExists = file.exists();
        this.setExecutable((IResource)folder, true);
        Assert.assertTrue((String)"2.1", (!wasExecutable ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.2", (!fileExists ? 1 : 0) != 0);
    }

    @Test
    public void testAttributeSymlink() throws Exception {
        Assume.assumeTrue((String)"only relevant for platforms supporting symbolic links", (boolean)FileSystemHelper.canCreateSymLinks());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFile link = project.getFile("link");
        ResourceTestUtil.createInWorkspace(link, ResourceTestUtil.createRandomString());
        Assert.assertTrue((String)"1.0", (!link.getResourceAttributes().isSymbolicLink() ? 1 : 0) != 0);
        this.setSymlink((IResource)link, true);
        Assert.assertTrue((String)"2.0", (!link.getResourceAttributes().isSymbolicLink() ? 1 : 0) != 0);
        this.setSymlink((IResource)link, false);
        Assert.assertTrue((String)"3.0", (!link.getResourceAttributes().isSymbolicLink() ? 1 : 0) != 0);
        ResourceTestUtil.removeFromWorkspace((IResource)link);
        IFile target = project.getFile("target");
        ResourceTestUtil.createInFileSystem((IResource)target);
        FileSystemHelper.createSymLink((File)project.getLocation().toFile(), (String)"link", (String)"target", (boolean)false);
        ResourceTestUtil.createInWorkspace((IResource)link);
        Assert.assertTrue((String)"5.0", (boolean)link.getResourceAttributes().isSymbolicLink());
        this.setSymlink((IResource)link, false);
        Assert.assertTrue((String)"3.0", (boolean)link.getResourceAttributes().isSymbolicLink());
        String s = link.getLocation().toOSString();
        link.getLocation().toFile().delete();
        new File(s).createNewFile();
        Assert.assertTrue((String)"3.0", (!link.getResourceAttributes().isSymbolicLink() ? 1 : 0) != 0);
    }

    @Test
    public void testAttributes() throws CoreException {
        int[] attributes = new int[]{0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000};
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFile file = project.getFile(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace(file, ResourceTestUtil.createRandomString());
        int[] nArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            int attribute = nArray[n2];
            if (ResourceTestUtil.isAttributeSupported(attribute)) {
                ResourceAttributes resAttr = file.getResourceAttributes();
                resAttr.set(attribute, true);
                file.setResourceAttributes(resAttr);
                Assert.assertTrue((String)"1.0", (boolean)file.getResourceAttributes().isSet(attribute));
                resAttr.set(attribute, false);
                file.setResourceAttributes(resAttr);
                Assert.assertFalse((String)"2.0", (boolean)file.getResourceAttributes().isSet(attribute));
                resAttr = project.getResourceAttributes();
                resAttr.set(attribute, true);
                project.setResourceAttributes(resAttr);
                Assert.assertTrue((String)"3.0", (boolean)project.getResourceAttributes().isSet(attribute));
                resAttr.set(attribute, false);
                project.setResourceAttributes(resAttr);
                Assert.assertFalse((String)"4.0", (boolean)project.getResourceAttributes().isSet(attribute));
            }
            ++n2;
        }
    }
}

