/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ValidateProjectEncoding;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.eclipse.core.tests.resources.TestUtil;
import org.junit.Assert;

public final class ResourceTestUtil {
    private static final Random RANDOM = new Random();

    private ResourceTestUtil() {
    }

    public static IProgressMonitor createTestMonitor() {
        return new FussyProgressMonitor();
    }

    public static String createUniqueString() {
        return new UniversalUniqueIdentifier().toString();
    }

    public static InputStream createInputStream(String text) {
        return new ByteArrayInputStream(text.getBytes());
    }

    public static String createRandomString() {
        return RANDOM.nextLong() + " " + RANDOM.nextLong();
    }

    public static InputStream createRandomContentsStream() {
        return ResourceTestUtil.createInputStream(ResourceTestUtil.createRandomString());
    }

    public static void createInFileSystem(IFileStore file) throws CoreException, IOException {
        ResourceTestUtil.createInFileSystem(file, 20);
    }

    public static void createInFileSystem(IFileStore file, int fileSizeInBytes) throws CoreException, IOException {
        file.getParent().mkdir(0, null);
        byte[] content = new byte[fileSizeInBytes];
        RANDOM.nextBytes(content);
        file.write(content, 0, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createInFileSystem(IPath path) throws CoreException, IOException {
        path.toFile().getParentFile().mkdirs();
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            InputStream input = ResourceTestUtil.createRandomContentsStream();
            try {
                try (FileOutputStream output = new FileOutputStream(path.toFile());){
                    input.transferTo(output);
                }
                if (input == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (input == null) throw throwable;
                input.close();
                throw throwable;
            }
            input.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void createInFileSystem(IResource resource) throws CoreException, IOException {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            ResourceTestUtil.createInFileSystem(((Resource)file).getStore());
        } else {
            ((Resource)resource).getStore().mkdir(0, null);
        }
    }

    public static void createInWorkspace(IFile resource, String contents) throws CoreException {
        InputStream contentStream = ResourceTestUtil.createInputStream(contents);
        if (resource == null) {
            return;
        }
        IWorkspaceRunnable body = resource.exists() ? monitor -> resource.setContents(contentStream, true, false, null) : monitor -> {
            ResourceTestUtil.createInWorkspace((IResource)resource.getParent(), monitor);
            resource.create(contentStream, true, null);
        };
        ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
    }

    public static void createInWorkspace(IResource resource) throws CoreException {
        IWorkspaceRunnable body = monitor -> ResourceTestUtil.createInWorkspace(resource, monitor);
        ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
    }

    public static void createInWorkspace(IResource[] resources) throws CoreException {
        IWorkspaceRunnable body = monitor -> {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)resources.length);
            IResource[] iResourceArray2 = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray2[n2];
                ResourceTestUtil.createInWorkspace(resource, (IProgressMonitor)subMonitor.split(1));
                ++n2;
            }
        };
        ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
    }

    private static void createInWorkspace(IResource resource, IProgressMonitor monitor) throws CoreException {
        if (resource == null || resource.exists()) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (!resource.getParent().exists()) {
            ResourceTestUtil.createInWorkspace((IResource)resource.getParent(), (IProgressMonitor)subMonitor.split(1));
        }
        switch (resource.getType()) {
            case 1: {
                ((IFile)resource).create(InputStream.nullInputStream(), true, (IProgressMonitor)subMonitor.split(1));
                break;
            }
            case 2: {
                ((IFolder)resource).create(true, true, (IProgressMonitor)subMonitor.split(1));
                break;
            }
            case 4: {
                subMonitor.setWorkRemaining(2);
                ((IProject)resource).create((IProgressMonitor)subMonitor.split(1));
                ((IProject)resource).open((IProgressMonitor)subMonitor.split(1));
            }
        }
    }

    public static void removeFromFileSystem(File file) {
        FileSystemHelper.clear((File)file);
    }

    public static void removeFromFileSystem(IResource resource) {
        IPath path = resource.getLocation();
        if (path != null) {
            ResourceTestUtil.removeFromFileSystem(path.toFile());
        }
    }

    public static void removeFromWorkspace(IResource resource) throws CoreException {
        if (resource.exists()) {
            resource.delete(5, ResourceTestUtil.createTestMonitor());
        }
    }

    public static void removeFromWorkspace(IResource[] resources) throws CoreException {
        IWorkspaceRunnable body = monitor -> {
            IResource[] iResourceArray2 = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray2[n2];
                ResourceTestUtil.removeFromWorkspace(resource);
                ++n2;
            }
        };
        ResourcesPlugin.getWorkspace().run(body, null);
    }

    public static void assertExistsInWorkspace(IResource resource) {
        Assert.assertTrue((String)(String.valueOf(resource.getFullPath()) + " unexpectedly does not exist in the workspace"), (boolean)ResourceTestUtil.existsInWorkspace(resource));
    }

    public static void assertExistsInWorkspace(IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            ResourceTestUtil.assertExistsInWorkspace(resource);
            ++n2;
        }
    }

    private static boolean existsInWorkspace(IResource resource) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ISchedulingRule modifyWorkspaceRule = workspace.getRuleFactory().modifyRule((IResource)workspace.getRoot());
        class CheckIfResourceExistsJob
        extends Job {
            private final AtomicBoolean resourceExists;
            private final /* synthetic */ IResource val$resource;

            public CheckIfResourceExistsJob(IResource iResource) {
                this.val$resource = iResource;
                super("Checking whether resource exists: " + String.valueOf(iResource));
                this.resourceExists = new AtomicBoolean(false);
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                IResource target = ResourcesPlugin.getWorkspace().getRoot().findMember(this.val$resource.getFullPath(), false);
                boolean existsInWorkspace = target != null && target.getType() == this.val$resource.getType();
                this.resourceExists.set(existsInWorkspace);
                return Status.OK_STATUS;
            }

            boolean resourceExists() {
                return this.resourceExists.get();
            }
        }
        CheckIfResourceExistsJob checkIfResourceExistsJob = new CheckIfResourceExistsJob(resource);
        checkIfResourceExistsJob.setRule(modifyWorkspaceRule);
        checkIfResourceExistsJob.schedule();
        try {
            checkIfResourceExistsJob.join(30000L, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (InterruptedException | OperationCanceledException e) {
            throw new IllegalStateException("failed when joining resource-existence-checking job", e);
        }
        return checkIfResourceExistsJob.resourceExists();
    }

    public static void assertDoesNotExistInWorkspace(IResource resource) {
        Assert.assertFalse((String)(String.valueOf(resource.getFullPath()) + " unexpectedly exists in the workspace"), (boolean)ResourceTestUtil.existsInWorkspace(resource));
    }

    public static void assertDoesNotExistInWorkspace(IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            ResourceTestUtil.assertDoesNotExistInWorkspace(resource);
            ++n2;
        }
    }

    public static void assertExistsInFileSystem(IResource resource) {
        Assert.assertTrue((String)(String.valueOf(resource.getFullPath()) + " unexpectedly does not exist in the file system"), (boolean)ResourceTestUtil.existsInFileSystem(resource));
    }

    public static void assertExistsInFileSystem(IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            ResourceTestUtil.assertExistsInFileSystem(resource);
            ++n2;
        }
    }

    private static boolean existsInFileSystem(IResource resource) {
        IPath path = resource.getLocation();
        if (path == null) {
            path = ResourceTestUtil.computeDefaultLocation(resource);
        }
        return path.toFile().exists();
    }

    private static IPath computeDefaultLocation(IResource target) {
        switch (target.getType()) {
            case 8: {
                return Platform.getLocation();
            }
            case 4: {
                return Platform.getLocation().append(target.getFullPath());
            }
        }
        IPath location = ResourceTestUtil.computeDefaultLocation((IResource)target.getProject());
        location = location.append(target.getFullPath().removeFirstSegments(1));
        return location;
    }

    public static void assertDoesNotExistInFileSystem(IResource resource) {
        Assert.assertFalse((String)(String.valueOf(resource.getFullPath()) + " unexpectedly exists in the file system"), (boolean)ResourceTestUtil.existsInFileSystem(resource));
    }

    public static void assertDoesNotExistInFileSystem(IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            ResourceTestUtil.assertDoesNotExistInFileSystem(resource);
            ++n2;
        }
    }

    public static void waitForBuild() {
        ((Workspace)ResourcesPlugin.getWorkspace()).getBuildManager().waitForAutoBuild();
    }

    public static void waitForRefresh() {
        try {
            Job.getJobManager().wakeUp(ResourcesPlugin.FAMILY_AUTO_REFRESH);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, null);
        }
        catch (InterruptedException | OperationCanceledException throwable) {
            // empty catch block
        }
    }

    public static void waitForEncodingRelatedJobs(String testName) {
        TestUtil.waitForJobs(testName, 10L, 5000L, ValidateProjectEncoding.class);
        TestUtil.waitForJobs(testName, 10L, 5000L, "org.eclipse.core.resourcescharsetJobFamily");
    }

    public static boolean isAttributeSupported(int attribute) {
        return (EFS.getLocalFileSystem().attributes() & attribute) != 0;
    }

    public static boolean isReadOnlySupported() {
        return ResourceTestUtil.isAttributeSupported(2);
    }

    public static void setReadOnly(IFileStore target, boolean value) throws CoreException {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)ResourceTestUtil.isReadOnlySupported()).withFailMessage("setting read only is not supported by local file system", new Object[0])).isTrue();
        IFileInfo fileInfo = target.fetchInfo();
        fileInfo.setAttribute(2, value);
        target.putInfo(fileInfo, 1024, null);
    }

    public static void setReadOnly(IResource target, boolean value) throws CoreException {
        ResourceAttributes attributes = target.getResourceAttributes();
        Assert.assertNotNull((String)"tried to set read only for null attributes", (Object)attributes);
        attributes.setReadOnly(value);
        target.setResourceAttributes(attributes);
    }

    public static IResource[] buildResources(IContainer root, String[] hierarchy) throws CoreException {
        IResource[] result = new IResource[hierarchy.length];
        int i = 0;
        while (i < hierarchy.length) {
            IPath path = IPath.fromOSString((String)hierarchy[i]);
            IPath fullPath = root.getFullPath().append(path);
            switch (fullPath.segmentCount()) {
                case 0: {
                    result[i] = ResourcesPlugin.getWorkspace().getRoot();
                    break;
                }
                case 1: {
                    result[i] = ResourcesPlugin.getWorkspace().getRoot().getProject(fullPath.segment(0));
                    break;
                }
                default: {
                    result[i] = hierarchy[i].charAt(hierarchy[i].length() - 1) == '/' ? root.getFolder(path) : root.getFile(path);
                }
            }
            ++i;
        }
        return result;
    }

    public static void ensureOutOfSync(IFile file) throws CoreException, IOException {
        ResourceTestUtil.modifyInFileSystem(file);
        ResourceTestUtil.waitForRefresh();
        ResourceTestUtil.touchInFilesystem((IResource)file);
    }

    private static void modifyInFileSystem(IFile file) throws FileNotFoundException, IOException {
        String originalContent = ResourceTestUtil.readStringInFileSystem(file);
        String newContent = originalContent + "f";
        Files.writeString(file.getLocation().toPath(), (CharSequence)newContent, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public static String readStringInFileSystem(IFile file) throws IOException {
        IPath location = file.getLocation();
        Assert.assertNotNull((String)("location was null for file: " + String.valueOf(file)), (Object)location);
        return new String(Files.readAllBytes(location.toPath()), StandardCharsets.UTF_8);
    }

    public static void touchInFilesystem(IResource resource) throws CoreException, IOException {
        IPath location = resource.getLocation();
        int count = 0;
        while (count < 3000 && ResourceTestUtil.isInSync(resource)) {
            FileTime now = FileTime.fromMillis(resource.getLocalTimeStamp() + 1000L);
            Files.setLastModifiedTime(location.toFile().toPath(), now);
            if (count > 1) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++count;
        }
        ((AbstractLongAssert)Assertions.assertThat((long)resource.getLocalTimeStamp()).as("file not out of sync: %s", new Object[]{location.toOSString()})).isNotEqualTo(ResourceTestUtil.getLastModifiedTime(location));
    }

    private static boolean isInSync(IResource resource) {
        IPath location = resource.getLocation();
        long localTimeStamp = resource.getLocalTimeStamp();
        return ResourceTestUtil.getLastModifiedTime(location) == localTimeStamp || location.toFile().lastModified() == localTimeStamp;
    }

    private static long getLastModifiedTime(IPath fileLocation) {
        IFileInfo fileInfo = EFS.getLocalFileSystem().getStore(fileLocation).fetchInfo();
        return fileInfo.getLastModified();
    }

    public static void setAutoBuilding(boolean enabled) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.isAutoBuilding() != enabled) {
            IWorkspaceDescription description = workspace.getDescription();
            description.setAutoBuilding(enabled);
            workspace.setDescription(description);
        }
        ResourceTestUtil.waitForBuild();
    }

    public static void setBuildOrder(IProject ... projects) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        if (projects == null) {
            desc.setBuildOrder(null);
        } else {
            desc.setBuildOrder((String[])Stream.of(projects).map(IResource::getName).toArray(String[]::new));
        }
        workspace.setDescription(desc);
    }

    public static ProjectDescriptionUpdater updateProjectDescription(IProject project) throws CoreException {
        return new ProjectDescriptionUpdater(project);
    }

    public static String getLineSeparatorFromFile(IFile file) {
        block21: {
            if (file.exists()) {
                block22: {
                    InputStream input = null;
                    try {
                        input = file.getContents();
                        int c = input.read();
                        while (c != -1 && c != 13 && c != 10) {
                            c = input.read();
                        }
                        if (c == 10) {
                            return "\n";
                        }
                        if (c != 13) break block21;
                        if (input.read() != 10) break block22;
                    }
                    catch (IOException | CoreException throwable) {
                        break block21;
                    }
                    finally {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return "\r\n";
                }
                return "\r";
            }
        }
        return null;
    }

    public static String[] findAvailableDevices() {
        String[] devices = new String[2];
        int i = 97;
        while (i < 123) {
            block9: {
                char c = (char)i;
                File rootFile = new File(c + ":\\");
                if (rootFile.exists() && rootFile.canWrite()) {
                    File probe = new File(rootFile, ResourceTestUtil.createUniqueString());
                    try {
                        try {
                            probe.createNewFile();
                        }
                        catch (IOException e) {
                            probe.delete();
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        probe.delete();
                        throw throwable;
                    }
                    probe.delete();
                    if (devices[0] == null) {
                        devices[0] = c + ":/";
                    } else {
                        devices[1] = c + ":/";
                        break;
                    }
                }
            }
            ++i;
        }
        return devices;
    }

    public static IPath wrapInCanonicalIPath(Path path) throws IOException {
        return IPath.fromOSString((String)path.toFile().getCanonicalPath());
    }

    public static IFileStore getFileStore(Path path) throws IOException {
        IPath canonicalIPath = ResourceTestUtil.wrapInCanonicalIPath(path);
        return EFS.getLocalFileSystem().getStore(canonicalIPath);
    }

    public static class ProjectDescriptionUpdater {
        private IProject project;
        private IProjectDescription description;
        private List<ICommand> commands = new ArrayList<ICommand>();

        private ProjectDescriptionUpdater(IProject project) throws CoreException {
            this.project = project;
            this.description = project.getDescription();
        }

        public void apply() throws CoreException {
            this.description.setBuildSpec((ICommand[])this.commands.toArray(ICommand[]::new));
            this.project.setDescription(this.description, ResourceTestUtil.createTestMonitor());
        }

        public ProjectDescriptionUpdater removingExistingCommands() {
            this.commands.clear();
            return this;
        }

        public CommandBuilder addingCommand(ICommand command) {
            this.commands.add(command);
            return new CommandBuilder(command);
        }

        public CommandBuilder addingCommand(String builderName) {
            ICommand command = this.description.newCommand();
            command.setBuilderName(builderName);
            this.commands.add(command);
            return new CommandBuilder(command);
        }

        public class CommandBuilder {
            private final ICommand command;

            private CommandBuilder(ICommand command) {
                this.command = command;
            }

            public CommandBuilder withTestBuilderId(String id) {
                return this.withAdditionalBuildArgument("BuildID", id);
            }

            public CommandBuilder withBuildingSetting(int kind, boolean value) {
                this.command.setBuilding(kind, value);
                return this;
            }

            public CommandBuilder withAdditionalBuildArgument(String key, String value) {
                Map args = this.command.getArguments();
                args.put(key, value);
                this.command.setArguments(args);
                return this;
            }

            public CommandBuilder andCommand(String builderName) {
                return ProjectDescriptionUpdater.this.addingCommand(builderName);
            }

            public void apply() throws CoreException {
                ProjectDescriptionUpdater.this.apply();
            }
        }
    }
}

