/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ResourceURLTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private final String[] resourcePaths = new String[]{"/", "/1/", "/1/1", "/1/2", "/1/3", "/2/", "/2/1", "/2/2", "/2/3", "/3/", "/3/1", "/3/2", "/3/3", "/4/", "/5"};
    private static final String CONTENT = "content";
    protected static IPath[] interestingPaths;
    protected static IResource[] interestingResources;

    private void checkURL(IResource resource) throws Throwable {
        URL url = this.getURL(resource);
        IPath file = IPath.fromOSString((String)FileLocator.resolve((URL)url).getFile());
        IPath metric = resource.getLocation();
        Assert.assertEquals((Object)metric, (Object)file);
    }

    protected IProject getTestProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject("testProject");
    }

    protected IProject getTestProject2() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject("testProject2");
    }

    private URL getURL(IPath path) throws Throwable {
        return new URL("platform:/resource" + path.makeAbsolute().toString());
    }

    private URL getURL(IResource resource) throws Throwable {
        return this.getURL(resource.getFullPath());
    }

    @Test
    public void testBasicURLs() throws Throwable {
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.resourcePaths);
        ResourceTestUtil.createInWorkspace(resources);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            this.checkURL(resource);
            ++n2;
        }
    }

    @Test
    public void testExternalURLs() throws Throwable {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("test");
        IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription("test");
        desc.setLocation(Platform.getLocation().append("../testproject"));
        project.create(desc, null);
        project.open(null);
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, this.resourcePaths);
        ResourceTestUtil.createInWorkspace(resources);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            this.checkURL(resource);
            ++n2;
        }
    }

    @Test
    public void testNonExistantURLs() throws Throwable {
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.resourcePaths);
        int i = 1;
        while (i < resources.length) {
            int index = i++;
            Assert.assertThrows(IOException.class, () -> this.checkURL(resources[index]));
        }
    }

    @Test
    public void testSpaces() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("My Project");
        IFile file = project.getFile("a.txt");
        ResourceTestUtil.createInWorkspace(file, CONTENT);
        URL url = new URL("platform:/resource/My%20Project/a.txt");
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream stream = url.openStream();){
            Assertions.assertThat((InputStream)stream).hasContent(CONTENT);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

